Rem
Rem $Header: xmld901.sql 26-jun-2002.12:12:08 vnimani Exp $
Rem
Rem xmld901.sql
Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      xmld901.sql - Load 9.0.1 XDK component (part of downgrade to 9.0.1)
Rem
Rem    DESCRIPTION
Rem       Load 9.0.1 XDK component (part of downgrade to 9.0.1)
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vnimani     04/30/02 - bug2343833 - drop xdb.jar
Rem    tyu         03/14/02 - drop class .../org_w3c_dom_range_Installer
Rem    kkarun      12/05/01 - use registry
Rem    kkarun      10/30/01 - Merged kkarun_fix_migration_scritps
Rem    kkarun      01/16/01 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: Remove 9.2.0 XML Classes and packages
Rem =========================================================================

-- Drop Java Packages
create or replace procedure xdk_drop_package(pkg varchar2) is
   CURSOR classes is select dbms_java.longname(object_name) class_name from all_objects where object_type='JAVA CLASS' and dbms_java.longname(object_name) like '%' || pkg || '%';
begin
   FOR class IN classes LOOP
      sys.dbms_java.dropjava('-r -v -synonym ' || class.class_name);
   END LOOP;
end xdk_drop_package;
/

call xdk_drop_package('org/w3c/dom');
call xdk_drop_package('org/xml/sax');
call xdk_drop_package('javax/xml/parsers');
call xdk_drop_package('javax/xml/transform');
call xdk_drop_package('oracle/xml/io');
call xdk_drop_package('oracle/xml/jaxp');
call xdk_drop_package('oracle/xml/comp');
call xdk_drop_package('oracle/xml/util');
call xdk_drop_package('oracle/xml/async');
call xdk_drop_package('oracle/xml/classgen');
call xdk_drop_package('oracle/xml/parser/v2/XML');
call xdk_drop_package('oracle/xml/parser/v2/XSL');
call xdk_drop_package('oracle/xml/parser/v2');
call xdk_drop_package('oracle/xml/parser/plsql');
call xdk_drop_package('oracle/xml/parser/schema');
call xdk_drop_package('oracle/xml/sql');
call xdk_drop_package('oracle/xdb');

drop procedure xdk_drop_package;

-- Drop PL/SQL XML Parser Packages
drop package xmlattrcover;
drop package xmlchardatacover;
drop package xmldocumentcover;
drop package xmldom;
drop package xmldomimplcover;
drop package xmldtdcover;
drop package xmlelementcover;
drop package xmlentitycover;
drop package xmlnnmcover;
drop package xmlnodecover;
drop package xmlnodelistcover;
drop package xmlnotationcover;
drop package xmlparser;
drop package xmlparsercover;
drop package xmlpicover;
drop package xmltextcover;
drop package xslprocessor;
drop package xslprocessorcover;
drop package xslstylesheetcover;
drop public synonym xmldom;
drop public synonym xmlparser;
drop public synonym xslprocessor;

-- Drop XSU packages and synonyms
drop package dbms_xmlquery;
drop package dbms_xmlsave;
drop package xmlgen;
drop public synonym dbms_xmlquery;
drop public synonym dbms_xmlsave;
drop public synonym xmlgen;

Rem =========================================================================
Rem END STAGE 1: Remove 9.2.0 XML Classes and packages
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: Initialize with 9.0.1 Classes and packages
Rem =========================================================================

@@initxml.sql

Rem =========================================================================
Rem END STAGE 2: Initialize with 9.0.1 Classes and packages
Rem =========================================================================
