Rem
Rem $Header: xmldbmig.sql 28-feb-2005.14:24:04 kkarun Exp $
Rem
Rem xmldbmig.sql
Rem
Rem Copyright (c) 2001, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xmldbmig.sql - XML DB Migration script
Rem
Rem    DESCRIPTION
Rem      This script invokes a migration script based on the DB version
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kkarun      02/28/05 - Fix 4189351 (reload if version == current)
Rem    kkarun      12/17/01 - Merged kkarun_update_mig_scripts
Rem    kkarun      12/05/01 - Created
Rem

COLUMN :file_name NEW_VALUE comp_file NOPRINT
VARIABLE file_name VARCHAR2(12)

BEGIN
  IF substr(dbms_registry.version('XML'),1,5)='8.1.5' THEN
    :file_name := '@xmlu815.sql';
  ELSIF substr(dbms_registry.version('XML'),1,5)='8.1.6' THEN
    :file_name := '@xmlu816.sql';
  ELSIF substr(dbms_registry.version('XML'),1,5)='8.1.7' THEN
    :file_name := '@xmlu817.sql';
  ELSIF substr(dbms_registry.version('XML'),1,5)='9.0.1' THEN
    :file_name := '@xmlu901.sql';
  ELSIF substr(dbms_registry.version('XML'),1,5)='9.2.0' THEN
    :file_name := '@xmlrelod.sql';
  ELSE
    :file_name := '?/rdbms/admin/nothing.sql';
  END IF;
END;
/

SELECT :file_name FROM DUAL;
@&comp_file
