Rem
Rem $Header: xmlu901.sql 19-jul-2006.02:06:45 aime Exp $
Rem
Rem xmlu901.sql
Rem
Rem Copyright (c) 2001, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xmlu901.sql - Upgrade from 9.0.1 database
Rem
Rem    DESCRIPTION
Rem      Upgrade from 9.0.1 database
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aime        07/19/06 - bug 5356316: version change to 9.2.0.10.0
Rem    clakshma    05/19/05 - bug 4192904 
Rem    sasriniv    09/08/04 - Update version to 9208 
Rem    aime        10/13/03 - Bug 3128169: update version to 9.2.0.7.0
Rem    kkarun      03/25/03 - update version to 9.2.0.6
Rem    vnimani     04/30/02 - bug2343833 - drop xdb.jar
Rem    tyu         03/14/02 - drop class .../org_w3c_dom_range_Installer
Rem    kkarun      02/20/02 - drop 901 ncomp classes
Rem    kkarun      02/13/02 - update version
Rem    kkarun      12/17/01 - split drop  package v2
Rem    kkarun      12/05/01 - update to use registry
Rem    kkarun      10/30/01 - Merged kkarun_fix_migration_scritps
Rem    kkarun      10/24/01 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: Remove 9.0.1 XML Classes and packages
Rem =========================================================================

call dbms_registry.upgrading('XML', 'Oracle XDK for Java');

-- Drop Java Packages
create or replace procedure xdk_drop_package(pkg varchar2) is
   CURSOR classes is select dbms_java.longname(object_name) class_name from all_objects where object_type='JAVA CLASS' and dbms_java.longname(object_name) like '%' || pkg || '%';
begin
   FOR class IN classes LOOP
      sys.dbms_java.dropjava('-r -v -synonym ' || class.class_name);
   END LOOP;
end xdk_drop_package;
/

call xdk_drop_package('org/w3c/dom');
call xdk_drop_package('org/xml/sax');
call xdk_drop_package('javax/xml/parsers');
call xdk_drop_package('oracle/xml/jaxp');
call xdk_drop_package('oracle/xml/comp');
call xdk_drop_package('oracle/xml/async');
call xdk_drop_package('oracle/xml/classgen');
call xdk_drop_package('oracle/xml/parser/v2/XML');
call xdk_drop_package('oracle/xml/parser/v2/XSL');
call xdk_drop_package('oracle/xml/parser/v2');
call xdk_drop_package('oracle/xml/parser/plsql');
call xdk_drop_package('oracle/xml/parser/schema');
call xdk_drop_package('oracle/xml/sql');
call xdk_drop_package('oracle/xdb');

drop procedure xdk_drop_package;

-- Drop PL/SQL XML Parser Packages
drop package xmlattrcover;
drop package xmlchardatacover;
drop package xmldocumentcover;
drop package xmldom;
drop package xmldomimplcover;
drop package xmldtdcover;
drop package xmlelementcover;
drop package xmlentitycover;
drop package xmlnnmcover;
drop package xmlnodecover;
drop package xmlnodelistcover;
drop package xmlnotationcover;
drop package xmlparser;
drop package xmlparsercover;
drop package xmlpicover;
drop package xmltextcover;
drop package xslprocessor;
drop package xslprocessorcover;
drop package xslstylesheetcover;
drop public synonym xmldom;
drop public synonym xmlparser;
drop public synonym xslprocessor;

-- Drop XSU packages and synonyms
drop package dbms_xmlquery;
drop package dbms_xmlsave;
drop package xmlgen;
drop public synonym dbms_xmlquery;
drop public synonym dbms_xmlsave;
drop public synonym xmlgen;

Rem =========================================================================
Rem Drop NCOMP related classes from 9.0.1
Rem As the 9.2.0 jar is a superset of 9.0.1 just drop the 9.2.0 jar file.
Rem This had to be done in 901, but it wasn't, so it is needed in this script
Rem =========================================================================

call sys.dbms_java.dropjava('-v xdk/install/ncomp_xmlparserv2.jar');
drop java class "oracle/aurora/deploy/org_w3c_dom_range_Installer";

Rem =========================================================================
Rem END STAGE 1: Remove 9.0.1 XML Classes and packages
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: Initialize with 9.2.0 Classes and packages
Rem =========================================================================

@@initxml.sql

Rem =========================================================================
Rem END STAGE 2: Initialize with 9.2.0 Classes and packages
Rem =========================================================================

call dbms_registry.upgraded('XML', '9.2.0.10.0', 'Oracle XDK for Java Release 9.2.0.10.0 - Production');
