Rem
Rem $Header: initxml.sql 19-jul-2006.02:06:42 aime Exp $
Rem
Rem initxml.sql
Rem
Rem Copyright (c) 1999, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      initxml.sql - INITialize (load) XML components in JServer
Rem
Rem    DESCRIPTION
Rem      Loads xml components into the JServer
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aime        07/19/06 - bug 5356316: version change to 9.2.0.10.0
Rem    clakshma    05/19/05 - bug 4192904 
Rem    sasriniv    09/08/04 - Update version for 9.2.0.8 
Rem    aime        10/13/03 - Bug 3128169: update version to 9.2.0.7.0
Rem    kkarun      03/25/03 - update version to 9.2.0.6
Rem    tyu         03/18/02 - call dbmsxsu.sql after xsu12.jar.
Rem    bcchang     03/15/02 - Create xsu packages.
Rem    kkarun      02/13/02 - update version
Rem    kkarun      12/05/01 - update to use registry
Rem    kkarun      05/18/01 - update xsu path
Rem    kkarun      04/04/01 - add xsu
Rem    kkarun      01/29/01 - Fix paths
Rem    kkarun      04/07/00 - update initxml.sql
Rem    nramakri    10/21/99 - Created
Rem

BEGIN
   dbms_registry.loading('XML', 'Oracle XDK for Java', 'xmlvalidate');
   sys.dbms_java.loadjava('-v -r -grant PUBLIC -synonym lib/xmlparserv2.jar lib/classgen.jar lib/xmlplsql.jar rdbms/jlib/servlet.jar rdbms/jlib/xdb.jar lib/xsu12.jar');
END;
/

-- Load dbmsxsu
@@dbmsxsu.sql
create or replace public synonym dbms_xmlsave for dbms_xmlsave;
create or replace public synonym dbms_xmlquery for dbms_xmlquery;

-- Load PL/SQL XML Parser files
@@xmlload.sql

BEGIN
   dbms_registry.loaded('XML', '9.2.0.10.0', 'Oracle XDK for Java Release 9.2.0.10.0 - Production');
END;
/

create or replace procedure xmlvalidate is
  p_num NUMBER;
begin
  SELECT COUNT(*) INTO p_num FROM obj$ WHERE type#=29 AND owner#=0
    AND status<>1 AND (
      name like 'org/xml/sax%' OR
      name like 'org/w3c/dom%' OR
      name like 'javax/xml/parsers%' OR 
      name like 'javax/xml/transform%' OR 
      name like 'oracle/xml/io%' OR 
      name like 'oracle/xml/jaxp%' OR 
      name like 'oracle/xml/comp%' OR 
      name like 'oracle/xml/util%' OR 
      name like 'oracle/xml/async%' OR 
      name like 'oracle/xml/parser%' OR
      name like 'oracle/xml/classgen%'
    );
  IF p_num != 0 THEN
    dbms_registry.invalid('XML');
  ELSE
    dbms_registry.valid('XML');
  END IF;
  EXCEPTION WHEN no_data_found THEN
    dbms_registry.valid('XML');
end xmlvalidate;
/

execute xmlvalidate;
