@echo off
REM Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
REM  executeSampleCode.bat
REM
REM  Batch script to execute ODM sample programs
REM
REM  under dm/demo/sample
REM

if "%JAVA_HOME%"=="" goto error_java_home

if "%ORACLE_HOME%"=="" goto error_oracle_home


set CLASSPATH=.;%ORACLE_HOME%/rdbms/jlib/jmscommon.jar;%ORACLE_HOME%/rdbms/jlib/aqapi.jar;%ORACLE_HOME%/rdbms/jlib/xsu12.jar;%ORACLE_HOME%/lib/xmlparserv2.jar;%ORACLE_HOME%/jdbc/lib/classes12.jar;%ORACLE_HOME%/jdbc/lib/nls_charset12.zip;%ORACLE_HOME%/dm/lib/odmapi.jar 

if "%1"=="" goto error
if "%1"=="all" goto all
if "%2"=="" goto default

%JAVA_HOME%/bin/java  %1 Sample_Global.property %2
goto end

:default
%JAVA_HOME%/bin/java  %1 Sample_Global.property %1.property
goto end

:all

REM Adaptive Bayes Network

%JAVA_HOME%/bin/java Sample_AdaptiveBayesNetworkBuild Sample_Global.property Sample_AdaptiveBayesNetworkBuild.property
%JAVA_HOME%/bin/java Sample_AdaptiveBayesNetworkApply Sample_Global.property Sample_AdaptiveBayesNetworkApply.property
%JAVA_HOME%/bin/java Sample_AdaptiveBayesNetworkLiftAndTest Sample_Global.property Sample_AdaptiveBayesNetworkLiftAndTest.property

REM Association Rules

%JAVA_HOME%/bin/java Sample_AssociationRules Sample_Global.property Sample_AssociationRules_TwoDimensional.property
%JAVA_HOME%/bin/java Sample_AssociationRules Sample_Global.property Sample_AssociationRules_Transactional.property

REM Attribute Importance

%JAVA_HOME%/bin/java Sample_AttributeImportanceBuild Sample_Global.property Sample_AttributeImportanceBuild.property
%JAVA_HOME%/bin/java Sample_AttributeImportanceUsage Sample_Global.property Sample_AttributeImportanceUsage.property

REM Clustering

%JAVA_HOME%/bin/java Sample_ClusteringBuild Sample_Global.property Sample_ClusteringBuild.property
%JAVA_HOME%/bin/java Sample_ClusteringApply Sample_Global.property Sample_ClusteringApply.property 
%JAVA_HOME%/bin/java Sample_Clustering_Results Sample_Global.property Sample_Clustering_Results.property

REM Discretization

%JAVA_HOME%/bin/java Sample_Discretization_CreateBinBoundaryTables Sample_Global.property Sample_Discretization_CreateBinBoundaryTables.property
%JAVA_HOME%/bin/java Sample_Discretization_UseBinBoundaryTables Sample_Global.property Sample_Discretization_UseBinBoundaryTables.property

REM Model Seeker

%JAVA_HOME%/bin/java Sample_ModelSeeker Sample_Global.property Sample_ModelSeeker.property

REM Naive Bayes

%JAVA_HOME%/bin/java Sample_NaiveBayesBuild Sample_Global.property Sample_NaiveBayesBuild.property
%JAVA_HOME%/bin/java Sample_NaiveBayesCrossValidate Sample_Global.property Sample_NaiveBayesCrossValidate.property
%JAVA_HOME%/bin/java Sample_NaiveBayesApply Sample_Global.property Sample_NaiveBayesApply.property
%JAVA_HOME%/bin/java Sample_NaiveBayesLiftAndTest Sample_Global.property Sample_NaiveBayesLiftAndTest.property

REM PMML

%JAVA_HOME%/bin/java Sample_PMMLExport Sample_Global.property Sample_PMMLExport.property
%JAVA_HOME%/bin/java Sample_PMMLImport Sample_Global.property Sample_PMMLImport.property

goto end

:error_java_home
echo JAVA_HOME environment variable is not defined.
goto end

:error_oracle_home
echo ORACLE_HOME environment variable is not defined.
goto end

:error
echo To execute all sample programs:
echo -------------------------------
echo syntax: %0 all
echo " "
echo To execute a specific sample program:
echo -------------------------------------
echo syntax: %0 classname [sample property file]
echo e.g.  : %0 Sample_ModelSeeker
echo         %0 Sample_ModelSeeker myFile.property
goto end

:end
