#
# Copyright (c) 2001, 2006, Oracle. All rights reserved.  
#
#    NAME
#    Command
#
#    DESCRIPTION
#    The command set is initialized by this module. This includes the
#    methods (or if you prefer, subroutines) needed for these tasks.
#
#    NOTES
#
#    BUGS
#    * <if you know of any bugs, put them here!>
#
#    MODIFIED   (MM/DD/YY)
#    phnguyen    01/23/06 - Release 1.55 which undo the 'umask 007' in opatch.pl (bug 4970846).
#                           This release may regresses on bug 4460956) 
#    vsriram     01/10/06 - If perl is 5.00503, then put quotes around the system command.
#    vsriram     01/10/06 - Release 1.0.0.0.54
#    vsriram     01/02/06 - Comment out the logics to read OH/oraInst.loc
#    vsriram     12/21/05 - Put the message in verbose mode for getting the dependent perl command.
#                           Use opendir and readdir for change_perm instead of <*>
#    vsriram     12/01/05 - Exit OPatch with error, if verification fails.
#                           Added change_perm_recursive, to change the perm of patch_storage.
#    vsriram     11/11/05 - Move verify_patch out of update_inventory as a separate function.
#    vsriram     10/26/05 - Added escape_special_chars
#    phnguyen    10/21/05 - Add env. var. OPATCH_SKIP_VERIFY
#    phnguyen    10/19/05 - Merge with Vijay 10/18 label, use live printing
#                               with VerifyPatch
#    phnguyen    10/17/05 - Add VerifyPatch to update_inventory()
#                            (update_inventory() is called by Apply only)
#    vsriram     10/17/05 - Creating release.
#    vsriram     10/07/05 - Adding checkinv.pl code here to make it part of OPatch Apply/Rollback.
#                           Do the live printing for the java commands.
#    vsriram     09/29/05 - grabtrans 'phnguyen_fix_orasrvm10dll' 
#    vsriram     09/26/05 - Bug-4628014 - Save the original Oracle Home path and use it for make.
#                           Bug-4594853 - Backup the rollback.sh script before overwriting.
#                           Add a message to shutdown and stop all the active processes.
#                           Add the warning message in the rollback.sh script and prompt the user.
#    phnguyen    09/27/05 - Add ouiLoc as the last param. to PropagatePatchToCluster and
#                             PropagatePatchToNode, fix bug 4634381 
#    vsriram     09/15/05 - Release 1.53 to release dir
#    vsriram     08/30/05 - Bug-4582141: Change the reqex to search for empty unpatch_node_list.
#    vsriram     08/30/05 - vjayaram:Modified getDependentPerlCommand : to get 64 bit processor
#    vsriram     08/15/05 - Bug-4541352: Flush stdout before reading user input.
#    vsriram     08/08/05 - Bug : 4395294
#    vsriram     08/01/05 - Log OPatch Java error into the log file.
#    vsriram     07/08/05 - Release 1.53 
#    vsriram     06/26/05 - Bug-4450313 : Decouple fuser from pre script.
#    vsriram     06/16/05 - 
#    vsriram     06/09/05 - Print the "What is the cause" of answering Y or N during errors.
#    vsriram     05/23/05 - Change release date
#    vsriram     05/18/05 - Added get_abs_path. Skip fuser if files
#                           does not exist or is a directory.
#    phnguyen    05/09/05 - Add note if System32 not in Windows PATH (note 293415.1 
#                             on meta-link)
#    phnguyen    05/07/05 - Special note on Windows if can't load inventory
#                              due to command.exe not in PATH
#                         - Pass in OPATCH_IS_SHARED (-DOPatch.is_shared)
#                             as true, false, or detect
#    phnguyen    05/05/05 - Fix propagate_patch_to_RAC_nodes() to use
#                              globals ROLLING_PATCH and MINIMIZE_DOWNTIME_OPTION
#                              instead of other vars.
#                         - Make sure during propagate_patch_to_*(), if
#                             user quits, we return the error string.
#                         - Bug 4083591: Linux 226
#    vsriram     05/03/05 - Use env. var OPATCH_NO_FUSER. 
#    vsriram     04/27/05 - Added method replace_oh_with_patchdir
#    phnguyen    04/26/05 - API to check for OH/jdk/bin/jar
#    vsubrahm    04/25/05 - Update release date
#    vsubrahm	 04/20/05 - Added check for OS: Linux x86_64/AMD64
#    vsriram     03/07/05 - Print log file name in create_logging_file
#    shgangul    02/15/05 - Update release date 
#    shgangul    02/15/05 - Bug 4177133: changes to rollback_<patchid>.sh 
#    phnguyen    01/20/05 - put all new dirs. to be 'mkdir -p' to a
#                              file under .patch_storage/<ID> and
#                              have Java propagation code parse
#                              that file.
#    phnguyen    01/18/05 - put all files to be propagated to a file
#                              under .patch_storage/<ID> and have
#                              Java parse that file.
#                         - clearly say doing nothing with make/wins
#    shgangul    01/18/05 - grabtrans 'phnguyen_fix_emptyline' 
#    shgangul    01/13/05 - Change OUI detection code for NOH 
#    phnguyen    01/14/05 - No code change, just touch up output of
#                             skipThisComponent() and change releaseDate
#    shgangul    01/11/05 - Change the release date 
#    phnguyen    01/08/05 - Reset release-date
#    shgangul    01/05/05 - Bug 4058201: Do not escape $ for windows 
#    shgangul    01/05/05 - Control filemap backup feature using env 
#                           OPATCH_BACKUP_FILEMAP 
#    phnguyen    01/05/05 - Fix timestamp bug 4101719, add function to return
#                           current timestamp as string
#    shgangul    01/04/05 - Copy filemap with comps.xml 
#    shgangul    01/03/05 - Change logging info for optional comp checks 
#    shgangul    12/31/04 - Changed the copyright message, Bug 4094100, 4085436
#    phnguyen    12/30/04 - Error msg. for the case where OPatch was invoked
#                                by root.
#    shgangul    12/22/04 - Change copyright message 
#    shgangul    12/17/04 - Use OPATCH_AR_COMMAND for ar and OPATCH_MAKE_COMMAND for 
#                           make 
#    shgangul    12/17/04 - Change the copyright message 
#    phnguyen    12/02/04 - Deal with case where patch needs 9.0 and home
#                                has 9.1 (skipThisComponent function)
#                         - Parse the ver. and use it along with component
#                              name to decide if we should skip a missing,
#                              optional component or not.
#                         - printRollbackedPatches() API not being used
#    shgangul 11/29/04 - Bug 3894539: OS ID for Microsoft Windows Server 
#                           2003 - 215 
#    shgangul 11/22/04 - Add ORACLE_HOME to rollback.txt and make.txt 
#
#    phnguyen    11/11/04 - Add -no_relink
#    phnguyen    10/15/04 - Move the REMOTE_MAKE_COMMAND_IS_INVOKED
#                              to right before we actually qx/make/
#                              on remote node.  
#                           Move the MAKE Warning for remote node
#                              inside the loop so that:
#                                - it doesn't print out twice for same node
#                                - it doesn't print out on non-make patch
#    phnguyen    10/13/04 - Implement getMakeCommand().  Error out if 'make'
#                              is required but not available in predefined
#                              path or in PATH#    
#                         - fix run_make_on_remote_nodes() to redirect stderr
#                           to a file and read it to check for make error.
#                           If there're errors (rsh itself failed or make failed),
#                              prompt if users want to continue.
#                         - getMakeCommand() to return non-empty string on Windows
#
#                         - fix path separator
#
#    phnguyen 10/06/04 - fuser fix on search path
#
#    1.51 Release + doc changes on FAQ.
#    phnguyen    10/04/04   - Add to CLASS_PATH the absolute path to jlib/opatch.jar
#                               instead of a relative path to where
#                               we launch OPatch.  Temporarily 'chdir' to
#                               OH/inventory before calling UpdateInventory
#                               and 'chdir' back to where we were after that.
#                               This is to fix the "Oneoff21" problem in OUI.
#                          
#    phnguyen    10/03/04   - Concatenate all remote make commands on all
#                               nodes and print it out, reminding users to
#                               check the binaries' timestamp & size
#                           - Do RAC diagnostic messages with Debashis, Ali and
#                               Sudip feedback
#                           - Error out if RAC + auto-rb + (min. downtime or rolling)
#                           - Fix bug in run_make_on_remote_nodes() when the                            
#                                filtering of local node should use String::equals(),
#                                not string matching.
#                           - Call shouldPropagateChange() b4 UpdateInventory
#                                to make sure the Java code path is the same
#                                for both CFS and -local cases.
#                           - Back up comps.xml inside Apply.  And if there's
#                               auto-rb, back it up again inside Apply
#                           - Back up comps.xml inside Rollback if it's not
#                               the auto-rb case
#                           - fix bug in shouldPropagateChage() where we forget
#                               to check of is_CFS case.
#                           - Print out the CFS case and say patch will be
#                               processed as -local
#    phnguyen    09/30/04  - use shouldPropagateChange() to set the system
#                              property -Dopatch.local_node_only to make sure
#                              the code path to Java is the same for both
#                              CFS and -local cases.
#                          - fix bug in make on remote nodes where the remote
#                              notes are mistaken for the local node because
#                              of reg. expression matching, i.e. hprac-1 matches
#                              hprac-10, 11 and 12.
#                          - add message to remind users to check on binary
#                              size & timestamp on each remote node.
#                          - print out local node name in addition to list of
#                              remote nodes.
#    phnguyen    09/29/04  - Fix shouldPropagateChange() bug: do not propagate
#                                if CFS is detected, fixing bug3917405 when
#                                CFS detected, Apply then set node list to ""
#                                but go ahead and call 
#                                propagate_patch_to_RAC_nodes() ->
#                                SRVM propagation API fails
#    phnguyen    09/22/04 
#                         - Move the header printing out of build_required_OUI..
#                           because the jlib/OraInstaller.jar is not accurate.
#                           Instead, print out the absolute path where we will
#                           use it as CLASS_PATH for OraInstaller.jar when
#                           we launch Java apps.
#                         - Fix the problem with liboraInstaller.so [sl]
#                            By default, it's liboraInstaller.so
#                            On Windows, it's oraInstaller.dll
#                            On HP 192, it's liboraInstaller.so
#                            On other HP, it's liboraInstaller.sl
#                           Bug cause:
#                             get_os_id() calls build_required_OUI_filenames()
#                                which makes reference to $Command::OS_ID, but
#                                $Command::OS_ID is initialized by get_os_id().
#                                Because of this circular referencing, on HP,
#                                we are not able to switch the name of the lib.
#                                to liboraInstaller.sl for HP 197.  As a result,
#                                we error out not finding it.  On other platforms,
#                                it is OK since we switch the name using
#                                $OSNAME, not platform ID.
#                                The fix is to write a separate API to search
#                                for the lib., then have the caller try twice
#                                on HP platforms, first with *.sl, then *.so.
#    phnguyen    09/21/04 - init $Command::RSH_SSH to "rsh", then if
#                            $Command::RSH_SSH is not set to
#                            user-supplied SSH env. var, set it to
#                            remsh on HP.
#                         - add function to retrieve path to fuser
#                         - do not support -no_inventory
#                           
#    phnguyen    09/20/04 - add  backupCompsXML() function to back up
#                              OH comps.xml to .patch_storage/<ID>
#    shgangul    06/21/04 - bug 3690710: Check for jre 1.4.2 before 1.3.1 
#    shgangul    06/07/04 - fix the get_child_error() for linux, check
#                           ARU_ID is greater than 0, display
#                           message from build_required_OUI_filenames
#                           only once
#    phnguyen    05/28/04 - 1.50 -> 1.50R1 for internal release
#                           take out & 127 mask in get_child_error() on linux
#                           print out ERROR and exit if we run into
#                              error during remote-make invocation via rsh 
#    shgangul    05/18/04 - bump up opatch ver. to 1.50 
#    shgangul    04/26/04 - Bug 3593316
#    phnguyen    04/20/04 - Merge with Shamik, change ver. to 1.49
#    phnguyen    04/15/04 - Add GetPlatformID, eliminate dup. call in Apply.pm
#    shgangul    04/13/04 - Add -pre and -post options to Apply and Rollback 
#    shgangul    04/09/04 - BUG 3522420 
#    phnguyen    04/01/04 - add more info. to run_make_on_remote_nodes
#    phnguyen    02/18/04 - 208 platform added
#    phnguyen    02/11/04 - use built-in substr for the \p problem
#    phnguyen    02/10/04 - fix Unicode problem on Win. with \p in OH
#    phnguyen    02/02/04 - work-around for Active State Perl as follow:
#                             on Windows, always surround command with extra qq(")
#                             unless ACTIVE_STATE_PERL is set to TRUE
#    phnguyen    01/30/04 - remove extra "" on Windows, fix cdrom problem
#    phnguyen    12/31/03 - just change ver. to 1.47 for release 
#    phnguyen    12/30/03 - 147I release 
#    shgangul    12/23/03 - bug 3334888: added a new error message, ver. to 1.47H
#    phnguyen    12/20/03 - fault tolerant on RAC: Java RAC propagation will throw
#                             exceptions on fatal errors (arg. mismatch).  On file prop.
#                             error or dir. creation error, pass "ERROR:..." string
#                             back so that users can decide to go on or not
#                         - change name of RAC routines to clearly reflect if
#                             one is called in All-Node, Min. DownTime or Rolling Patch
#    phnguyen    12/15/03 - pass in -Dopatch.debug & cluster debug if OPATCH_DEBUG is set to TRUE
#    phnguyen    12/10/03 - fault-tolerant: default to continue, v 1.47F 
#                           internal release for EM pickup 
#    phnguyen    12/09/03 - process stderr of make
#    shgangul    12/09/03 - bug 3257294 
#    phnguyen    12/08/03 - 1.47D to be picked up by EM
#    phnguyen    12/01/03 - add retry / delay options for OPatch to retry
#                           locking the inventory
#                           remove extra / in OH/oui (oui_path)
#    phnguyen    11/18/03 - all Java classes are in opatch package
#                           so we need to run as opatch/LsInventory or
#                           opatch/LsHome (the / is also used for Windows)
#                         - change log file format so that it could
#                             keep multiple log files around
#                         - add log file for LsInventory
#                         - if platform incompatible, print out detected
#                             platform IDs & supported one
#                         - hide conflict/super-set output from users
#                         - change 'conflict' to 'super-set'
#                         - fix bug where 1 should be a super-set of itself
#                         - remove Cluster.getLocalNode()

#    shgangul    11/20/03 - changes to build_required_OUI_filenames to 
#                           calculate java, library 
#    shgangul    11/17/03 - bug 3252933: Return error for RAC 
#    shgangul    11/12/03 - more changes for 3240232 
#    shgangul    11/07/03 - bug 3240232, Updated find_a_file() function 
#    phnguyen    10/29/03 - have rac code use get_child_error() to check
#                             for error instead of Java output
#                           fix lock file parsing code
#
#    phnguyen    10/22/03 - fix prompt on RAC
#    phnguyen    10/20/03 - add Cluster debug
#    phnguyen    10/10/03 - touch up help 
#    phnguyen    10/08/03 - fix bug in path to xmlparserv2.jar
#                           ver. from 1.46B to 1.46
#    phnguyen    10/06/03 - Add -jre and -jdk option
#    phnguyen    10/03/03 - Pre/post processing & copy to .patch storage
#    shgangul    10/07/03 - rollback.sh fix, part of bug 3170021
#    phnguyen    09/29/03 - Merge in bug-superset and file conflict
#    shgangul    09/26/03 - Further changes to pre post functionality
#    shgangul    09/11/03 - Logging changes for 10G
#    phnguyen    08/29/03 - 1.44 release
#    shgangul    08/13/03 - Code changes for BUG 2899335
#    (manual merged by phnguyen)
#                           Rewrote functions is_symbolic_link() and
#                           resolve_symbolic_link(). Added a new
#                           function verify_internal_link()
#    phnguyen    06/10/03  v1.39
#                          Take out CheckRACDetails.java in
#                              initial_RAC_safety_check(): use cached
#                              info. in O2O
#                          Roll in 1.38.1: -invPtrLoc to Java call O2O
#                          Place holder for -localNodeOnly
#                          Place holder for "opatch query"
#    phnguyen    05/30/03  v1.37
#                          Fix Windows on java path & non-default OUI loc.
#                          OUI not under default OH/oui on Unix
#                          Rollback on EM with dup. OH
#    phnguyen    05/28/03  v1.36
#     			               Introduce isDebug()
#    phnguyen    05/28/03  v1.35
#                          Fix localNode problem
#    phnguyen    05/25/03  v1.34
#                          Implement a primitive hashCode()
#                            so that we can use filename as
#                            key to the hash table
#                          Look up both swd.oui and jre from xml file
#                          Print out ver. loc of both components for debug
#    phnguyen    05/21/03  V33: Add util function is_option_set() and validate_
#                             OUI_and_RAC()
#                          Add $ENV{OPATCH_DEBUG}
#
#    phnguyen    05/16/03  Add comp. name and comp. ver. to UpdateInventory
#                             cmd. arg.  Version 32
#    phnguyen    05/15/03  Give 1st priority to OH/oui, ver. 31
#    phnguyen    05/14/03  Add util. func. to check all commands in path
#                          Re-writen the build_required_OUI_files() to
#                           not use relative oui ../ and make clear the
#                           the difference between central inventory
#                           location and oui component location
#
#    phnguyen    05/05/03  Pump to 29
#    phnguyen    04/29/03  Introduce has_inventory() to check if there's
#    phnguyen    04/29/03  Introduce has_inventory() to check if there's
#                            inventory on system or not
#                          Introduce ERROR_CODE_INVENTORY_PROBLEM and
#                                    ERROR_CODE_PERL_PROBLEM
#    phnguyen    04/28/03  Fix a problem with Linux 'pwd' returns sym.
#                          path while Solaris works fine
#    phnguyen    04/18/03  Pump to 1.0.0.0.26
#    phnguyen    04/11/03  Fix: oui dir. not found causes confusing error
#                             msg.  Fix is more detailed error message
#                          Fix: symbolic link Oracle_Home causes problem
#                             during rollback
#                          Error out early if Oracle_Home not exist
#                          Warn users if Oracle_Home is a symbolic link
#                          Add util. routine to check if a dir. is
#                             a symbolic link.
#                          Add util. routine to resolve a symbolic link
#                          Add more detailed error message in
#                             find_java_libraries() to deal with the
#                             case when oui dir. is not at the same
#                             level of $ORACLE_HOME
#
#    phnguyen    04/04/03  regular expression problem on Win (2751325)
#                          CHILD_ERROR on Linux (2887659)
#                          Need detailed error message if lock file
#                              exists (2885756)
#                          Roll back AIX 5L as 212 -- not 211 (2889700)
#    phnguyen    03/28/03 - skip fuser on Win32, use 211 for Linux/S390
#    phnguyen    03/26/03 - add new 214 Linux Intel Itanium
#    phnguyen    03/25/03 - pump up ver. for installable OPatch
#    phnguyen    03/21/03 - add new Win32 215
#    daevans     03/07/03 - Fix for bug 2610729 and inflate ver. number.
#    daevans     03/05/03 - Fix for bug 2835213 and raise ver. number.
#    daevans     02/28/03 - Added general fixes for local node issues and
#                           fuser command, fixed the issues with rolling
#                           RAC patching. Increased ver. to 19. This
#                           will be a general release.
#    daevans     02/26/03 - Bumped ver. to 18 for external testing of
#                           integration with Enterprise Manager.
#    rajayara    02/21/03 - Bumped ver. to 17 for internal testing.
#    daevans     02/11/03 - daevans_relocate_directories
#    daevans     02/11/03 - Missed a string in the redesign.
#    daevans     02/11/03 - Version 16 is a redesign of the hierarchy.
#    rajayar     02/05/03 - Classpath changes for internal testing.
#    daevans     01/30/03 - New ver. 15 for rolling RAC rollback.
#                           Siemens only release until confirmed working
#                           and then incorporate changes.
#    daevans     01/15/03 - Added another location to check for the java
#                           binary.
#    daevans     12/24/02 - Added 'attach' command.
#    daevans     12/20/02 - Bump number for changes in Apply.pm.
#    daevans     12/06/02 - Add support for installations that used the
#                           unsupported "invPtrLoc" flag.
#    daevans     12/05/02 - Add more log output.
#    daevans     12/04/02 - Fix #2 for bug 2678540. Forgot about CHILD_ERROR.
#    daevans     12/03/02 - Fix for bug 2663858.
#    daevans     12/02/02 - Fix for bug 2678540.
#    daevans     11/24/02 - Fix for bug 2671736.
#    daevans     11/15/02 - Fix for more errors relating to use of 'goto'
#                           statements.
#    daevans     10/29/02 - Fix for bugs 2638971 and 2635535.
#    daevans     10/25/02 - Fix for bug 2644099.
#    daevans     10/17/02 - Fix for bugs 2607816, 2626988, 2582512, 2569528,
#                           25629289 (may need to cover more cases) and
#                           introduce support for Win98 clinets.
#    daevans     10/02/02 - Start using bits for flag values.
#    daevans     09/30/02 - 1.0.0.0.6 - bug fix in RollBack.pm.
#    daevans     09/12/02 - Reverted 1.0.0.0.4 and jumped to 1.0.0.0.5.
#                           Problems with inventory updates and NT in x.4.
#                           Fix for Japanese NLS issues with Microsoft.
#    praghuna    08/31/02 - 2478680: Locate OUI by using comps.xml.
#    daevans     08/27/02 - Fix for RAC processing.
#    daevans     08/01/02 - Added file based locking for 'Apply'.
#                           Incremented minor ver. number too.
#                           Many small bug fixes.
#    daevans     06/01/02 - Many code changes. Stable check-in.
#    daevans     11/28/01 - Updated code and comments.
#    psciarra    11/01/01 - Initial coding.
#
##########################################################################

###############################################################################
###############################################################################
#
#  ------------------------ INITIALIZATION ------------------------
#
###############################################################################
###############################################################################

package Command;

######
# Standard modules:
use English;         # Let us say "$CHILD_ERROR" instead of "$?", etc.
use strict;          # Enforce strict variables, refs, subs, etc.

use Cwd();
use Cwd;
use File::Basename();
use File::Spec();
use File::Copy();
use File::Copy;
use File::Find;
use File::Path;
use lib &File::Basename::dirname($PROGRAM_NAME);
use lib &File::Basename::dirname($PROGRAM_NAME) .
                              File::Spec -> catfile ( "", "perl_modules" );

# Local modules.
use Apply();
use AttachHome();
use LsInventory();
use RollBack();
use Version();
use opatchIO();
use Query();

# Version
#####################################
use constant version => "1.0.0.0.55";
use constant release_date => "Jan 23, 2006";
#####################################

# Global arrays to hold names of files that we failed to back up
@Command::FAILED_BACKUP_JAR_FILES = ();
@Command::FAILED_BACKUP_AR_FILES  = ();

# Global constants. Called as &<class>::<name>.
use constant copyright => "Copyright (c) 2006 Oracle Corporation. " .
    "All Rights Reserved..\n\n" .
    "We recommend you refer to the OPatch documentation under\n" .
    "OPatch/docs for usage reference. We also recommend using\n" .
    "the latest OPatch version. For the latest OPatch version\n" .
    "and other support related issues, please refer to document\n" .
    "293369.1 which is viewable from metalink.oracle.com";

use constant save_dir => ".patch_storage";

#
# This global, if initialized, will point to user-defined RSH/SSH,
#   except for HP_UX, where we always use remsh.
#
$Command::RSH_SSH => "rsh";

#
# This global will be set to the real remote make command
# to be invoked on remote nodes
#   the 1st one will contain all concatenated commands
#   the 2nd one will be set to 1 if there's at least one remote invoked
#   the 3rd one will contain all concatenated failed commands
$Command::REMOTE_MAKE_COMMAND_INVOKED => "";
$Command::REMOTE_MAKE_COMMAND_IS_INVOKED => "";
$Command::REMOTE_MAKE_COMMAND_FAILED => "";

#
# RAC message, init. by validate_OUI_RAC(),
#   printed out in Apply/RollBack b4 prompting
#
$Command::RAC_MESSAGE = "";

#
# Search path for 'fuser' in addition to user's PATH env. var.
#
@Command::FUSER_SEARCH_PATH = ("/sbin/fuser",  "/usr/sbin/fuser");


# This global is initialized to ORACLE_HOME. 
# If OH is a symbolic link, then Oracle_Home points to the resolved link while
#    UNRESOLVED_ORACLE_HOME points to the original value of OH set in the env.
# If OH is not a symbolic link, then Oracle_Home and UNRESOLVED_ORACLE_HOME are
#    identical
$Command::UNRESOLVED_ORACLE_HOME = "";

# Global variables. Called as $Command::<name>. See set_OS_dependent_items().
# Mainly unused thanks to the File module. Will be removed on rewrite.
$Command::current_directory_token   = "";
$Command::directory_separator_token = "";
$Command::parent_directory_token    = "";
$Command::path_separator_token      = "";
$Command::do_not_update_inventory   = 0;
$Command::patch_missing_from_inventory = 0;

$Command::inventory_location_ptr    = "";

$Command::COMPONENT_NAME = "";
$Command::COMPONENT_VERSION = "";
$Command::OS_ID = "";

# Name of pre/post-install scripts & readmes
$Command::UNIX_PRE_SCRIPT = "pre";
$Command::UNIX_POST_SCRIPT= "post";
$Command::WIN_PRE_SCRIPT  = "pre.bat";
$Command::WIN_POST_SCRIPT = "post.bat";

$Command::PRE_README = "pre.txt";
$Command::POST_README= "post.txt";

# Header to print pre/post readme and pre/post-install scripts output
$Command::PRE_README_HEADER  = "\n======= Pre-Install README =====================================\n";
$Command::PRE_README_TAIL    = "\n======= End of Pre-Install README ==============================\n";
$Command::PRE_SCRIPT_HEADER  = "\n======= Pre-Install Script Output ==============================\n";
$Command::PRE_SCRIPT_TAIL    = "\n======= End of Pre-Install Script Output =======================\n";

$Command::POST_README_HEADER  = "\n======= Post-Install README ====================================\n";
$Command::POST_README_TAIL    = "\n======= End of Post-Install README =============================\n";
$Command::POST_SCRIPT_HEADER  = "\n======= Post-Install Script Output =============================\n";
$Command::POST_SCRIPT_TAIL    = "\n======= End of Post-Install Script Output ======================\n";

# PRE_SCRIPT_STATUS and POST_SCRIPT_STATUS will be set to the exit status of 
#  the pre-script which should be 0 (SUCCESS), 1 (WARNING) or 2 (ERROR)
# under Solaris, if the script is not executable, attempting to exec() it 
#  would return error code 1, so we should set our pre/post error code as 1 too
$Command::PREPOST_SUCCESS = 0;
$Command::PREPOST_WARNING = 2;
$Command::PREPOST_ERROR   = 1;
$Command::PREPOST_UNDEF   = 10;

# Globals to keep track of whether pre script is there during apply/rollback
$Command::APPLY_PRE_SCRIPT_IS_THERE = 0;
$Command::ROLLBACK_PRE_SCRIPT_IS_THERE = 1;

# Globals to keep track of whether pre/post scripts were called
# during apply, and if yes, were set to the values of return codes
$Command::APPLY_PRE_SCRIPT_STATUS  = $Command::PREPOST_UNDEF;
$Command::APPLY_POST_SCRIPT_STATUS = $Command::PREPOST_UNDEF;

# Since RollBack could be called from Apply, we need similar globals
# to track if pre/post scripts were called during roll back and if yes,
# they were set to the values of return codes
$Command::ROLLBACK_PRE_SCRIPT_STATUS = $Command::PREPOST_UNDEF;
$Command::ROLLBACK_POST_SCRIPT_STATUS = $Command::PREPOST_UNDEF;

# These global variables are used for logging OPatch messages
$Command::logging_error_flag = "";
$Command::logging_fh_log_file = 0;
$Command::logging_log_file_name = "";
$Command::opatch_operations = ""; # Will be apply, rollback,
                                  # lsinventory, query or attachhome
$Command::verbose_mode = 0; # Set to 1, when verbose mode is set

# The following 2 options is for JDK / JRE stuff
# They will be left empty string ("") if options are not specified.
# Otherwise, they will be changed to the location specified, then
# the path to the jar.exe and java.exe.
$Command::JRE_LOC = "";
$Command::JDK_LOC = "";
# the 2 below hold the -jdk / -jre command line argument
$Command::JRE_ARG = "";
$Command::JDK_ARG = "";
#
# Example: if users run 'opatch -jdk /tmp/Java ...', then
# JDK_LOC will be "/tmp/Java/bin/java" while JDK_ARG will be "/tmp/Java"
#

# <absolute path>/etc/config/actions
$Command::ACTION_FILE = "";

# file containing a list of new directories to be created by Apply
$Command::DIRS_TO_MKDIR = "opatch_dirs_created.lst"; 
# file containing a list of files to be propagated to remote nodes
$Command::FILES_TO_PROPAGATE = "opatch_files_to_propagate.lst";

# These store the parameters for pre and post
$Command::PRE_PARAMETERS = "";
$Command::POST_PARAMETERS = "";

# Global values for bit-wise comparison.
# General processing.
use constant display_usage            =>  1;
use constant force_patch_installation =>  2;
use constant no_inventory_update      =>  4;
use constant report_only              =>  8;
use constant no_bug_superset          => 16;
use constant silent                   => 32;
use constant local_node_only          => 64;
use constant verbose                  => 128;


# Retry / Delay to retry locking inventory in case of a failure
$Command::RETRY = 10;
$Command::DELAY = 30;
#     the RETRY_OPTION and DELAY_OPTION strings will be set to
#        -Dopatch.retry=<n>
#        -Dopatch.delay=<s>
#     by isRetry() and isDelay()
$Command::RETRY_OPTION = ""; 
$Command::DELAY_OPTION = "";
use constant RETRY_ERROR_MESSAGE => 
   "-retry <times> and -delay <seconds> must be positive, non-zero integers.";
   
use constant INVOKED_BY_ROOT_ERROR_MESSAGE =>
"OPatch can't be invoked as super-user.  Log in as regular user and try again.";

#
# RAC processing.
use constant minimize_downtime        =>  1;
use constant rolling_RAC_enabled      =>  2;

# (MIN_OPTION will be set to 1 if users specify -minimize_downtime)
$Command::MINIMIZE_DOWNTIME_OPTION = 0;
# set to 1 if template file says this's a rolling patch
use constant ROLLING_PATCH => 0;

# Some values probed & set up by OUI API
#   updated by call to validate_OUI_and_RAC
use constant HOME_INDEX => -1;

# deprecated IS_CLUSTER and CHECK_CLUSTER
# use constant IS_CLUSTER => 0;
# use constant CHECK_CLUSTER => 0;
# 
use constant CAN_GET_LOCAL_NODE_NAME => 1;

# the LOCAL_NODE_NAME will be set to the value of -local_node supplied
#   by the user.  If not, it will set by Perl/Java later on.
use constant LOCAL_NODE_NAME => "";
use constant NODE_COUNT => 1;
use constant NODE_LIST => "";

# User wanna turn off CFS detection?
#    OPATCH_IS_SHARED = true   -> CFS=true, no detect
#                       false        =false, no detect
#                       detect       =<detected value>, yes detect
#                       not set      =false, no detect
use constant OPATCH_IS_SHARED => "";
# IS_CFS will be set to the value returned from Java
use constant IS_CFS => 0;

# will be set to 1 if user supplies -local_node <node name>
use constant LOCAL_NODE_NAME_MODE => 0; 

#
# RAC_CODE is set to:
#
#   RAC_CODE = 0  -->  not a RAC system, not even Cluster
#            = 1  -->  RAC system of more than one node
#                      (need to propagate changes to other nodes)
#            = 2  -->  RAC system comprising of only one node
#                      (don't propagate changes to other nodes)
#            = 3  -->  Cluster detected but users had picked
#                         non-RAC install option on this OH
#                      (don't propagate changes to other nodes)
#
use constant RAC_CODE => 0;
# set to 1 if users supply -local
use constant LOCAL_NODE_ONLY => 0;
# set to "-DTRACING.ENABLED=TRUE -DTRACING.LEVEL=2 -Dopatch.debug=true "; 
#    if OPATCH_DEBUG = "TRUE" in env.  Otherwise it's set to ""
use constant DEBUG => "";
# set to 1 if users supply -silent_operation
use constant SILENT_MODE => 0;
# set to 1 if users supply -no_relink
use constant NO_RELINK_MODE => 0;

# set to 1 if Apply -force calls RollBack
use constant ROLLBACK_CALLED_BY_APPLY => 0;

#########################################################################
# Error code returned to top-level opatch shell script
# these error codes should be passed to opatchIO->print_message_and_die()
#
#    Add more error codes as we go cleaning up the code
#########################################################################

# No error
use constant ERROR_CODE_NO_ERROR => 0;
# Perl problem
use constant ERROR_CODE_PERL_PROBLEM => 1;
# Inventory: can't find inventory, can't find liboraInstaller...
use constant ERROR_CODE_INVENTORY_PROBLEM => 100;
# Path: can't find required shell commands in path such as echo, fuser..
use constant ERROR_CODE_PATH_PROBLEM => 110;
# Cluster has 0 node count, can't get local node name...
use constant ERROR_CODE_CLUSTER_PROBLEM => 120;
# Conflicts in cmd. arg. supplied
use constant ERROR_CODE_COMMAND_LINE_ARGUMENT => 130;
# Bug/File/Bug-Superset Conflict
use constant ERROR_CODE_ERROR_ON_CONFLICT => 140;
# Pre-req failed such as instances are running...
use constant ERROR_CODE_PREREQ_PROBLEM => 150;
# Problem during roll back
use constant ERROR_CODE_ROLLBACK_PROBLEM => 160;
# Problem with patch area
use constant ERROR_CODE_PATCH_AREA => 170;
# Problem with pre/post script
use constant ERROR_CODE_PRE_SCRIPT => 180;
# Problem with RAC installation of the patch
use constant ERROR_RAC_INSTALL_PROBLEM => 190;
# Problem with file backup, file restore, running make ...
#   due to missing files.  OPatch exits with this error code
#   after notifying and users decided to quit
use constant ERROR_CODE_PATCH_PROBLEM => 200;
# Error code for bug/file conflict or bug superset conflict
use constant ERROR_CODE_BUG_FILE_CONFLICT => 210;
# Error code, when patching is stopped on user's request
use constant ERROR_CODE_PATCHING_STOPPED_ON_USER_REQUEST => 220;
# Error code for make failure
use constant ERROR_CODE_MAKE_FAILURE => 230;
# Error code for verify failure
use constant ERROR_CODE_VERIFY_FAILURE => 240;

# This field is used to return the matched file in find_a_file()
my $find_a_file_result = "";
my $find_a_file_target = "";

# Display build_required_OUI_filenames() only once
$Command::build_filenames_called = 0;

# Inventory clean up related variables
my $FILEMAP_SET = "";
my %FILEMAP_CACHED = ();
my $COMPS_XML_SET = "";
my $BANG = "!";
my $COMMA = ",";
my $D_COLON = "::";
# Arguments for Grep function
my $search_pattern = "";
my $file_pattern = "";



###############################################################################
#
#  ------------------------ DATA STRUCTURES ------------------------
#
###############################################################################
# %Command::list :
#           This hash is created by &Command::build_command_list() and is used
#           to describe the command and attributes. This allows a lookup by
#           the command name instead of iterating through an array. Not all
#           attributes are present with every command.
#
#           It is used to validate the command line.
#
# $command        = The command name.
# description     = A short string for descriptive purposes.
# help_text       = Text to be displayed to the user as the help message.
# $option_name    = The string that is the option.
# command_set     = ***********************************
#
# default_value   = If applicable this will be present.
# description     = A short string for descriptive purposes.
# flag            = ************************************
# help_text       = Text to be displayed to the user as the help message.
# option_set      = ************************************
# required        = A flag to say if the option is mandatory.
# type            = An attribute describing the data.
# validity_checks = Checks required for the type.
# value           = ************************************
# value_set       = ************************************
#
#
# Data structure :
# %Command::list = (
#        $command => (
#           _commandSet,
#           _current,
#           _description,
#           _helpText,
#           _last,
#           _options => (
#               $option_name => (
#                   _defaultValue,
#                   _description,
#                   _flag,
#                   _help_text,
#                   _optionSet,
#                   _required,
#                   _type,
#                   _validityChecks,
#                   _value,
#                   _valueSet,
#
###############################################################################
# %<Class>::rh_command_line :
#           Used to store the command line details for validation and later
#           dispatch. This is normally done in opatch::parse_arguments().
#
# command   = The command to be validated.
# arguments = The arguments to be validated and actioned.
# invalid   = A string giving the command name and class when validation
#             of the command line fails.
###############################################################################


###############################################################################
#
#  ------------------------ SUBROUTINES ------------------------
#
###############################################################################

###############################################################################
#
# NAME   : add_options_to_command_description
#
# PURPOSE: A method that adds each key in the _options attribute to the
#          description of the command.
#
# INPUTS : $$ARG[1]{rh_command} - A reference to a hash for the class Command.
#
# OUTPUTS: NONE.
#
# NOTES  : 1. The input reference is updated.
#          2. You can use ( keys %{${$$rh_command{_options}}} )
#             but taking a reference to this first is much easier to read.
#          3. But what happens if the arguments are longer than three lines.
#
###############################################################################
sub add_options_to_command_description {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_command   = $$rh_arguments{rh_command};

    my $rh_for_loop  = $$rh_command{_options};
    my $multiplier   =  1;

    my $indent = length ( $$rh_command{_description} );
    foreach my $option ( sort keys %{$$rh_for_loop} ) {

        if ( ( $this_class eq "AttachHome" ) &&
             ( $option eq "-invPtrLoc" ) ) {
            $$rh_command{_description} .=
                 " [ ${$$rh_for_loop}{$option}{_description} ]]\n ";

        } elsif ( ( ( $this_class ne "RollBack" ) || ( $option eq "-oh" ) ) &&
             ( $option ne "-name" ) ) {
                 $$rh_command{_description} =
                         $$rh_command{_description} .
                             " [ ${$$rh_for_loop}{$option}{_description} ]";

        } elsif ( ( $this_class eq "RollBack" ) &&
                  ( $option eq "-invPtrLoc" ) ) {
            $$rh_command{_description} .=
                 "[ ${$$rh_for_loop}{$option}{_description} ]";
        } else {
            $$rh_command{_description} =
                 $$rh_command{_description} .
                                " ${$$rh_for_loop}{$option}{_description} ";
        }

        if ( ( length ( $$rh_command{_description} ) ) >
             ( $multiplier * 65 ) ) {
            my $short_string = " [ ${$$rh_for_loop}{$option}{_description} ]";
            my $short_length = length ( $short_string );
            my $long_length  = length ( $$rh_command{_description} );
            my $pad_string   = " " x $indent;

                $$rh_command{_description} =
                                       substr $$rh_command{_description}, 0,
                                                ($long_length - $short_length);

                $$rh_command{_description} .=
                                       "\n" . $pad_string . $short_string;
            $multiplier++;
        }
     }

}   # End of add_options_to_description().

###############################################################################
#
# NAME   : bless_array
#
# PURPOSE: A method implementation to tie an array with the class given as the
#          argument.
#
# INPUTS : $ARG[0] - The class to add the variable to. If not supplied the
#                    default is the current class.
#
# OUTPUTS: A reference to a hash that's blessed.
#
# NOTES  : 1. This means the returning value is accessed as:
#             a.   $ra_array  = CLASS => HASH.
#
###############################################################################
sub bless_array {

    my ( $class ) = @ARG;

    $class = ref($class) || $class;

    my $array = [];
    bless ( $array, $class );

    return $array;

}   # End bless_array().

###############################################################################
#
# NAME   : bless_hash
#
# PURPOSE: A method implementation to tie a hash with the class given as the
#          argument.
#
# INPUTS : $ARG[0] - The class to add the variable to. If not supplied the
#                    default is the current class.
#
# OUTPUTS: A reference to a hash that's blessed.
#
# NOTES  : 1. This means the returning value is accessed as:
#             a.   $rh_hash  = CLASS => HASH.
#
###############################################################################
sub bless_hash {

    my ( $class ) = @ARG;

    $class = ref($class) || $class;
    my $rh_hash = {};
    bless ( $rh_hash, $class );

    return $rh_hash;

}   # End bless_hash().

###############################################################################
#
# NAME   : build_command_list
#
# PURPOSE: Build the command list with the attributes associated with each
#          command.
#
# INPUTS : Nothing.
#
# OUTPUTS: \%command_list - A hash containing the valid command and the
#                           attributes associated with each command.
#
# NOTES  :
#
###############################################################################
sub build_command_list {

    # Get a blessed reference for the commands.
    my $rh_command_list = Command -> bless_hash();

    # Get the details for each command from the command package and add it
    # to the hash.
    Apply       -> command_details ( { rh_detail => $rh_command_list } );
    AttachHome  -> command_details ( { rh_detail => $rh_command_list } );
    LsInventory -> command_details ( { rh_detail => $rh_command_list } );
    RollBack    -> command_details ( { rh_detail => $rh_command_list } );
    Version     -> command_details ( { rh_detail => $rh_command_list } );
    Query       -> command_details ( { rh_detail => $rh_command_list } );

    # Install the global options according to the design specs.
    Command     -> global_options  ( { rh_detail => $rh_command_list } );

    return $rh_command_list;

}

###############################################################################
#
# NAME   : build_option_details
#
# PURPOSE: Provide the details about the options for a given command.
#
# INPUTS : $$ARG[1]{rh_option}  - A reference to an empty hash where the
#                                 details about the option is to be stored.
#          $$ARG[1]{ra_optlist} - An array of strings, on for each option.
#
# OUTPUTS: $rh_options          - A reference to a hash is keyed on the option
#                                 name and references the attributes for the
#                                 option.
#
# NOTES  : 1. The return values are in hash so the caller will get the new
#             details when this subroutine is finished.
#
###############################################################################
sub build_option_details {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_options   = $$rh_arguments{rh_options};
    my $ra_opt_list  = $$rh_arguments{ra_option_list};

    foreach my $option_name ( @$ra_opt_list ) {
        # Just in case there's an empty element.
        next if ( ! $option_name );

        # Get a default option template.
        my $rh_option_detail = Command -> new_option();
        if ( $option_name ne "patch_location" ) {
            $$rh_options{"-$option_name"} = $rh_option_detail;
        } else {
            $$rh_options{"$option_name"} = $rh_option_detail;
        }

        my $option_name = "option_$option_name";
        $this_class -> $option_name ( {
                                    rh_option_detail => $rh_option_detail } );
    }

    return \$rh_options;

}   # End of build_option_details().
############################################################################
#
# Return the path to libOraInstaller, called as
#
#     my $libOraInstallerBinary = $this_class->getBinaryLibOraInstallerPath();
#
#     Parameter:
#           oui_component_loc:   dir path to oui comp. where there is
#                                liboraInstaller underneath (lib or bin)
#
############################################################################
sub getBinaryLibOraInstallerPath {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];
    my $oui_component_loc = $$rh_arguments{oui_component_loc};
    my $name_to_find      = $$rh_arguments{name_to_find};

    my $path = "";
    my $liboraInstaller_lib = $name_to_find;

    my $top_dir = File::Spec->catfile ( $oui_component_loc, "lib" );
    $path = $this_class -> find_a_file ( { start_point => $top_dir,
                                      target => $liboraInstaller_lib } );

    if ( $path ) { 
         return $path;
    } else {
         $top_dir = File::Spec->catfile ( $oui_component_loc, "bin" );
         $path = $this_class -> find_a_file ( { start_point => $top_dir,
                                              target => $liboraInstaller_lib } );
    }
    
    if ( $path ) {
        $liboraInstaller_lib = $path;
        # A small hack to get around a problem in linux until the class
        # files are updated. If it works it's needed, if it fails it's
        # either there already or there are bigger problems with the machine.
        if ( ( $OSNAME eq "linux" ) && ( $liboraInstaller_lib ) ) {
            my ( $target_dir ) = ( $liboraInstaller_lib =~ m#^(.+)/[Ll]inux# );
            my $target_check = File::Spec->catfile ( $target_dir, "Linux" );
            if ( ! -e $target_check ) {
                my $system_command =
                                "cd $target_dir; ln -s linux ./Linux 2>/dev/null";
                my $sys_call_result = qx/$system_command/;
            }
        }
    }
    
    return $path;
}

###############################################################################
#
# NAME   : build_required_OUI_filenames
#
# PURPOSE: Build the paths to files needed by OUI.
#
# INPUTS :
#          $$ARG[1]{Oracle_home} - A path to an $ORACLE_HOME;
#
# ABSTRACT:
#       In Oracle RDBMS 9i, central inventory and oui component
#       could be installed in different places.  They could even
#       be symbolic link.
#
#       Starting in RDBMS 10i, oui comp. will be a OH component,
#           locating under $OH
#
# ALGO:
#       Look for path_to_oI_loc: this is our central inventory, either
#          specified by -invPtrLoc (1st prior.) XOR under
#          /var/opt/oracle/oraInst.loc (2nd prior.)
#
#       Look for oui component location, either under OH/oui (1st pri.)
#          XOR from comps.xml, located by entry from the above
#          file path_to_oI_loc
#
# OUTPUTS:
#       Return the following
#           liboraInstaller_lib: the path to libOrainstaller.so [sl] or
#                                    oraInstaller.dll on Windows
#                                  
#           required_jar_file:   lib/OraInstaller.jar
#           path_to_oI_loc:      - point to the oraInst.loc where we can
#                                  search for central inventory location
#                                - it is /etc/oraInst.loc for AIX
#                                      /var/opt/oracle/oraInst.loc for others
#                                         Unix
#                                      "N/A" on Windows
#                                - will be overriden if users supply
#                                       -invPtrLoc
#           inventory_location:  central inventory which has comps.xml telling
#                                us where is oui comp.  We will construct
#                                liboraInstaller_lib by searching for the
#                                file from this oui comp. loc.
#           path_to_java:        where is executable java
#           oui_component_loc:   dir path to oui comp. where there is
#                                liboraInstaller.so underneath (lib or bin)
#
###############################################################################
sub build_required_OUI_filenames {

    my $this_class   = shift @ARG;

    my $rh_arguments = $ARG[0];
    my $Oracle_Home = $$rh_arguments{Oracle_Home} || $ENV{ORACLE_HOME};

    # These are the values returned to the caller.
    my ( $error_flag, $inventory_location, $liboraInstaller_lib,
         $path_to_java, $path_to_oI_loc,
	       $required_jar_file,
	       $oui_component_loc) = ("", "", "", "", "", "", "");

    
    # 1. construct required_jar_file
    $required_jar_file = File::Spec->catfile ( "jlib", "OraInstaller.jar" );

    # 2. construct inventory_location 
    my @file_data      = ();
    my $use_OH_oui  = 0;
    my $is_OH_oui = File::Spec->catfile($Oracle_Home, "oui");

    # 1st priority to $OH/oui
    my $test_inventory_loc = File::Spec->catfile($Oracle_Home, "inventory");
    if ( -e $is_OH_oui && -d $is_OH_oui ) {
          # (this function is called more than once, 
          if ($Command::build_filenames_called == 0) {
             opatchIO -> print_message ( {
                message => "Using ORACLE_HOME/oui to look up oui libs...\n"
             } );
          }
          $use_OH_oui = 1;
	        $inventory_location = $test_inventory_loc;
    }
 
    # we still need path_to_oI_loc to point to central inventory
    #    to be used by System.Properties in later Java call.
    # First we'll try to get oraInst.loc in OH, if that does not succeed, then
    # we fall back to default values.
    #    path_to_oI_loc will be either /etc/oraInst.loc,
    #    /var/opt/oracle/oraInst.loc or "n/a"
    # /etc/oraInst.loc for AIX and Linux

    # now if users specify -invPtrLoc, we will use it instead
    if ( $Command::inventory_location_ptr ) {
        ( $path_to_oI_loc ) = ( $Command::inventory_location_ptr =~
                                m#^-Doracle.installer.invPtrLoc=(.+)$# );
           if ($Command::build_filenames_called == 0) { 
                  opatchIO -> print_message( {
	             message => "Picking up oraInst.loc using -invLocPtr:\n".
                                "  $path_to_oI_loc\n"
		  } );
           }
    }else {
       if ( ( $OSNAME eq "aix" ) || ( $OSNAME eq "linux" ) ) {
                $path_to_oI_loc = File::Spec->catfile
                            ( "", "etc", "oraInst.loc" );
       } elsif ($OSNAME =~ m#Win32#) {
	         $path_to_oI_loc = "N/A";
       } else {
               # /var/opt/oracle/oraInst.loc for anything else
               $path_to_oI_loc = File::Spec->catfile
                            ( "", "var", "opt", "oracle", "oraInst.loc" );
       }

       # Commenting this code. This has to be re-opened when complete
       # logics for handling oraInst.loc is implemented.
       # my $oh_oraInst = File::Spec->catfile($Oracle_Home, "oraInst.loc" );
       #
       #if ($OSNAME !~ m#Win32#) {
       #    if ( ! -e $oh_oraInst || ! -f $oh_oraInst ) {
       #          opatchIO -> print_message ( {
       #                          message => "OH/oraInst.loc does not exists or is not a file\n " .
       #                                     "So, falling back to default value " .
       #                                     "$path_to_oI_loc\n"
       #          } );
       #    } else {
       #          $path_to_oI_loc = $oh_oraInst;
       #    }
       #}
    }

    # Set the derived path to oraInst.loc in Command.pm for others to use.
    $Command::inventory_location_ptr =
                    "-Doracle.installer.invPtrLoc=" . $path_to_oI_loc;

    # Check if the oraInst.loc is correct else exit opatch.
    if ($OSNAME !~ m#Win32#) {
        if ( ! -e $path_to_oI_loc || -d $path_to_oI_loc ) {
             opatchIO -> print_message_and_die( {
                    exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM ,
                    message => "Cannot open the file: $path_to_oI_loc\n" .
                               "Please use -invPtrLoc option and specify " .
                               "the correct file for OPatch to look for central inventory.\n"
                    } );
        }
    }

    # Now, read the contents and put it in the log file.
    if ($OSNAME !~ m#Win32#) {
         local *ORAINST_LOC_FILE;
         open ( ORAINST_LOC_FILE, $path_to_oI_loc ) or do {
              opatchIO -> print_message_and_die ( {
                   exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM ,
                   message => "Cannot open to read the file\n" .
                              "  $path_to_oI_loc\n" .
                              "  OS_ERROR = [$OS_ERROR]"
              } );
         };

         @file_data = <ORAINST_LOC_FILE>;

         close ORAINST_LOC_FILE or do {
               opatchIO -> print_message ( {
                      message  => "Cannot close the file after reading:\n" .
                                  "  $path_to_oI_loc\n" .
                                  "  OS_ERROR = [$OS_ERROR]\n" .
                                  "  OPatch will ignore and goes on\n"
               } );
         };

         opatchIO -> print_message ( {
               message => "The contents of the file: ".
                          "$path_to_oI_loc\n"
         } );

         foreach my $line ( @file_data ) {
               opatchIO -> print_message ( {
                    message => $line
               } );
         }
    } 


    # 3. construct inventory_location using either default path
    #    or supplied by -invPtrLoc
    #
    # On windows platform the inventory location is hard-coded to
    # c:\Program Files\oracle\inventory
    if (  $OSNAME  =~  m#Win32# ) {
        if ( $use_OH_oui == 0 ) {
          $inventory_location  = $ENV{INVENTORY_LOC};
          if (! -d $inventory_location ) {
            $inventory_location = File::Spec->catfile
              ( $ENV{SYSTEMDRIVE}, "Program Files", "oracle", "inventory" );
          }
          if ( ! -d $inventory_location ) {
                my $reg_key = 
			          "\\\\HKEY_LOCAL_MACHINE\\Software\\Oracle\\inst_loc";
                opatchIO -> print_message_and_die ( {
                    exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM ,
                    message => "Cannot look for inventory on Windows\n" .
                      "  Please set environment variable INVENTORY_LOC" .
                                  " to the value of registry key $reg_key " .
                                  "and try again.\n" .
                                  "  SystemDrive = $ENV{SYSTEMDRIVE}"
                } );
          }       
        }

    # For Unix variants find it out from oraInst.loc, but if there is
    #    OH/oui, then no need to look up, $inventory_location has been
    #    set to OH/inventory
    } else {
	  # Unix case
         if ( $use_OH_oui == 0 ) {
           local *INVENTORY_LOCATOR;
           open ( INVENTORY_LOCATOR, $path_to_oI_loc ) or do {
            opatchIO -> print_message_and_die ( {
              exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM ,
              message => "Cannot open to read the file\n" .
		                "  $path_to_oI_loc\n" .
                    "  OS_ERROR = [$OS_ERROR]"
              } );
           };

           @file_data = <INVENTORY_LOCATOR>;

           close INVENTORY_LOCATOR or do {
               opatchIO -> print_message ( {
                     message  => "Cannot close the file after reading:\n" .
                                   "  $path_to_oI_loc\n" .
                                   "  OS_ERROR = [$OS_ERROR]\n" .
			           "  OPatch will ignore and goes on\n"
			         } );
           };

           # OK, where is the inventory.
           my $inventory_loc_variable = "inventory_loc";

           foreach my $line ( @file_data ) {
              # Search for $inventory_loc_variable instead of inventory_loc.
              if ( $line =~ m#^$inventory_loc_variable=# ) {
                 ( $inventory_location ) =
                              ( $line =~ m#^$inventory_loc_variable=(.+)$# );
              }
           }
       }
    } # end of Unix case

    # Assert: $inventory_location has been set to OH/inventory, xor
    #    set by pattern -Doracle.installer.invPtrLoc in either
    #    user-supplied -invPtrLoc xor default file oraInst.loc
    if ( $inventory_location eq "" ) {

	       opatchIO -> print_message_and_die ( {
		         exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM ,
		             message => "Cannot look for invPtrLoc pattern\n" .
		                "  -Doracle.installer.invPtrLoc in file\n" .
		                "  $path_to_oI_loc\n"
		         } );
    }

    # first, open the file comps.xml under $inventory_location,
    #   which must have been set above to look for
    #   both OUI and JRE components

    my $oui_loc = "";
    my $oui_ver   = "";
    my $jre_loc = "";
    my $jre_ver   = "";
    my $found_oui = 0;
    my $found_jre = 0;

    my $comps = $inventory_location .
                          File::Spec -> catfile ("", "ContentsXML","comps.xml");
    $oui_loc = File::Spec->catfile (
                  &File::Basename::dirname( $inventory_location), "oui" );

    if ( $use_OH_oui != 1 ) {
        # parse ContentsXML/comps.xml under $oui_loc
        # (this function is called more than once, so do not print out anything
        #   on 1+ call)
         if ($Command::build_filenames_called == 0) {
          opatchIO->print_message({
            message => "Parsing $comps\n"
          });
        }
    
        local *COMPS;
        open(COMPS,"<$comps") || do {
            opatchIO -> print_message_and_die ( {
             exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM ,
             message => "Cannot open to read file $comps\n" .
                        "  OS_ERROR = [$OS_ERROR]\n"
             } );
        };
    
        # Begin parsing comps.xml
        while (my $line = <COMPS>) {
    
               # If the line doesnt describe a component then skip it.
               next, if !($line =~ /^<COMP /);
    
               # Get the component name and the install location
               my ($comp_name, $comp_ver, $inst_loc) =
               ($line =~ /^<COMP .*NAME="(.*)" VER="(.*)" BUILD_NUMBER=.*INST_LOC="(.*)"/);
    
               # If the component is oui then lets use the install location
               if ($comp_name eq "oracle.swd.oui") {
                  $oui_loc = $inst_loc;
                  $oui_ver = $comp_ver;
                  $found_oui = 1;
                  # (this function is called more than once, 
                  #   so print out once only)
                  if ($Command::build_filenames_called == 0) {
                      opatchIO -> print_message ( {
                        message => 
			                  "Found \"$comp_name\" version \"$comp_ver\"\n" .
                        "  on \"$inst_loc\"\n"
                      } );
                  }
               } elsif ($comp_name eq "oracle.swd.jre") {
                  if ($comp_ver =~ m#1.4.#) { 
                     $jre_loc = $inst_loc;
                     $jre_ver = $comp_ver;
                     $found_jre = 1;
                     if ($OSNAME =~ m#Win32#) {
                       $path_to_java = 
		       	           File::Spec->catfile ( $jre_loc,"bin","java.exe");
                     } else {
                       $path_to_java = 
		       	           File::Spec->catfile ( $jre_loc,"bin","java");
                     }
	     	       } elsif ($comp_ver =~ m#1.3.#) {
                     if ( ($jre_loc eq "") || ($jre_ver eq "") ) {
                     	   $jre_loc = $inst_loc;
                     	   $jre_ver = $comp_ver;
                     	   if ($OSNAME =~ m#Win32#) {
                           $path_to_java = 
		                       File::Spec->catfile ( $jre_loc,"bin","java.exe");
                        } else {
                       	   $path_to_java = 
		                       File::Spec->catfile ( $jre_loc,"bin","java");
                        }
                     }
                  }
               } # if found oracle.swd.oui
    
               if ($found_oui && $found_jre) {
                  last;
               }
        } # end of while loop
        close COMPS;
        # done opening comps.xml to parse
    
        # If we haven't located the oui location, then its no point
        # proceeding. Print error and die.
        if (($oui_loc eq "") || (! -e $oui_loc)) {
            opatchIO -> print_message_and_die ( {
                 exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM ,
                 message => "Cannot locate oui location \"$oui_loc\"" .
                            "  in file $comps or via oraInst.loc\n"
                 } );
        } else {
            $oui_component_loc = $oui_loc;
        }
    } else {
	      # case of $use_OH_use == 1
        $oui_component_loc = $is_OH_oui;
    }


    # 4 Find binary lib liboraInstaller_lib.  
    # Default to Solaris. On HP 197, it should be liboraInstaller.sl but
    #      we don't know the OS_ID at this point, so there's no way to tell.
    #      The safe way is to search for both liboraInstaller.so, then *.sl
    #
    my $name_to_find = "liboraInstaller.so";
    if ($OSNAME =~ /Win32/ ) {
        # the equivalnt of .so is this .dll on NT.
        $name_to_find = "oraInstaller.dll";
    } elsif ($OSNAME eq "hpux") {
        $name_to_find = "liboraInstaller.sl";
    }
 
    $liboraInstaller_lib = $this_class->getBinaryLibOraInstallerPath(
        { oui_component_loc => $oui_component_loc,
          name_to_find      => $name_to_find
        }
    );
    
    # Try again because it might be HP 197 with *.so extension
    if ( ! $liboraInstaller_lib ) {
      if ($OSNAME eq "hpux") {
        $name_to_find = "liboraInstaller.so";
        $liboraInstaller_lib = $this_class->getBinaryLibOraInstallerPath(
            { oui_component_loc => $oui_component_loc,
              name_to_find      => $name_to_find
            }
        );
      }   
    }
    
    # Exit with error if we still cannot find binary lib.
    if ( ! $liboraInstaller_lib ) {
      opatchIO -> print_message_and_die ( {
                    exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM ,
                    message => "Cannot find Oracle Universal Installer shared library\n"
		    } );
    }

    # 5. construct path_to_java if can't find in comps.xml
    if ( ! -e $path_to_java ) {
       my $java = "java";

       if ($OSNAME =~ m#Win32#) {
          $java = "java.exe";
       }

       if ( $OSNAME eq "aix" ) {
          $path_to_java = File::Spec->catfile (
                            &File::Basename::dirname( $inventory_location ),
                                       "jre", "1.4.2", "jre", "bin", $java );

          if ( ! -e $path_to_java ) {
              $path_to_java = File::Spec->catfile (
                            &File::Basename::dirname( $inventory_location ),
                                       "jre", "1.3.1", "jre", "bin", $java );
          }
       }

       $path_to_java = File::Spec->catfile ( &File::Basename::dirname(
                                                      $inventory_location ),
                                              "jre", "1.4.2", "bin", $java );

       if ( ! -e $path_to_java ) {
          $path_to_java = File::Spec->catfile ( &File::Basename::dirname(
                                                      $inventory_location ),
                                              "jre", "1.3.1", "bin", $java );
       }

        # Maybe it's an Enterprise Manager issue.
        if ( ! -e $path_to_java ) {
            $path_to_java = File::Spec->catfile ( "$Oracle_Home",
                                              "jre", "1.4.2", "bin", $java );
        }
        if ( ! -e $path_to_java ) {
            $path_to_java = File::Spec->catfile ( "$Oracle_Home",
                                              "jre", "1.3.1", "bin", $java );
        }

       if ( ! -e $path_to_java ) {

         # Intial fallback if OUI loc does't work.
         $path_to_java = File::Spec->catfile ( "$Oracle_Home",
                                              "jdk", "jre", "bin", $java );

        # Look into OH/jdk/bin
        if ( ! -e $path_to_java ) {
            $path_to_java = File::Spec->catfile
                                     ( "$Oracle_Home", "jdk", "bin", $java );
        }

         # Fallback if installation went wrong.
         if ( ! -e $path_to_java ) {
            $path_to_java = File::Spec->catfile
                                     ( "$Oracle_Home", "oracle.swd.jre",
                                                              "bin", $java );
        }

        # Your on your own. I hope $PATH picks up the correct version.
        if ( ! -e $path_to_java ) {
            opatchIO -> print_message ( {
                message => "Cannot find suitable path to java.  " .
                           "OPatch will proceed in hope that " .
                           "java will be in your PATH env. var.\n"
            } );
            $path_to_java = $java;
        }
      }
    }

    # If users supply -jre or -jdk options, use that.  No need to check
    #   because it's been done so by pre-req. check
    if ( $Command::JRE_LOC ne "" ) {
      # (this function is called more than once, so do not print out anything
      #   on 1+ call)
      if ($Command::build_filenames_called == 0) {
          opatchIO->print_message ( {
            message => "Using user-supplied JRE, java is set to " . 
	          $Command::JRE_LOC . " \n"
          } );
      }
      $path_to_java = $Command::JRE_LOC;
    }

    # For windows surround $path_to_java with quotes. Takes
    # care of directories like c:\program files\oracle...
    if ($OSNAME =~ m#Win32#) {
        if ($path_to_java ne "")
        {
            chomp $path_to_java;
            # Get each element of the directory string into an array
            my @directory_bits = split (//, $path_to_java);
            if ($directory_bits[0] ne "\"")
            {
                $path_to_java = "\"" . $path_to_java . "\"";
            }
            
        }
    }

    my %file_names = ();
    $file_names{error_flag}          = $error_flag;
    $file_names{inventory_location}  = $inventory_location;
    $file_names{liboraInstaller_lib} = $liboraInstaller_lib;
    $file_names{path_to_java}        = $path_to_java;
    $file_names{path_to_oI_loc}      = $path_to_oI_loc;
    $file_names{required_jar_file}   = $required_jar_file;
    $file_names{oui_component_loc}   = $oui_component_loc;

    return ( \%file_names );

}   # End of build_required_OUI_filenames().

###############################################################################
#
# NAME   : build_required_XML_filenames
#
# PURPOSE: Build the paths to known files.
#
# INPUTS : NONE
#
# OUTPUTS: %file_names - A hash containing the file names.
#
# NOTES  : 1. This is hardcoded and will probably change.
#          2. Done here so the paths are only built once.
#
###############################################################################
sub build_required_XML_filenames {

    # Because this was called in an OO manner the first argument is the
    # class name. Not really needed, just force of habit.
    my $this_class   = shift @ARG;

    my $actions_file  =  File::Spec -> catfile( "etc", "config", "actions" );
    my $inventory_file =
                        File::Spec -> catfile( "etc", "config", "inventory" );

    my $GenericActions_file =
                  File::Spec -> catfile( "etc", "xml", "GenericActions.xml" );

    my $ShiphomeDirectoryStructure_file =
      File::Spec -> catfile( "etc", "xml", "ShiphomeDirectoryStructure.xml" );

    my %file_names = ();

    $file_names{actions} = $actions_file;
    $file_names{inventory} = $inventory_file;
    $file_names{GenericActions} = $GenericActions_file;
    $file_names{ShiphomeDirectoryStructure} =
                                             $ShiphomeDirectoryStructure_file;

    return ( \%file_names );

}   # End of build_required_filenames().

###############################################################################
#
# NAME   : check_patch_lock_status
#
# PURPOSE: Check if there is a lock file. If not create the lock. If there
#          is a lock, check the details.
#
# INPUTS : $$ARG[1]{Oracle_Home} - The $ORACLE_HOME to check.
#          $$ARG[1]{patch_id}    - The patch id. Used to name the log.
#
# OUTPUTS: %return_values        - A hash to hold the values in.
#
# NOTES  :
#
###############################################################################
sub check_patch_lock_status {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home  = $$rh_arguments{Oracle_Home};
    my $patch_id     = $$rh_arguments{patch_id} || "";

    # patch that's holding the lock file
    my $holding_patch = "";

    my $error_messages = "";
    my $match_patch_flag = 0;
    my $RAC_node_patched = "";
    my %return_values = ();

    my $patch_store = File::Spec -> catfile( $Oracle_Home, ".patch_storage" );
    my $free_lock   = File::Spec -> catfile( $patch_store, "patch_free"     );
    my $busy_lock   = File::Spec -> catfile( $patch_store, "patch_locked"   );

    # If first time, or something is terribly wrong, create the lock file.
    if ( ( ! -e $free_lock ) && ( ! -e $busy_lock ) ) {
        local *LOCK_FILE;
        open ( LOCK_FILE, ">$free_lock" ) || ( $error_messages .=
                                          "Couldn't create the lock file. " .
                                          "Error is: $OS_ERROR\n" );
        close LOCK_FILE, or do {
            opatchIO -> print_message ( { f_handle => *STDERR,
                                      message  => "Cannot close the lock " .
                                      "file after creation: $free_lock\n" .
                                      "[$OS_ERROR]\nProcessing continuing" } );
        }
    }

    # If on an NFS device the non-existance of a file is guaranteed.
    # If the lock isn't free read the details, otherwise create the details.
    if ( ! -e $free_lock ) {
        local *LOCK_FILE;
        open ( LOCK_FILE, "<$busy_lock" ) || ( $error_messages .=
                                              "Couldn't read the lock file " .
                                              "data. Error is: $OS_ERROR\n" );

        if ( ! $error_messages ) {
            my @file_data = <LOCK_FILE>;
            close LOCK_FILE, or do {
                my $message = "Cannot close the lock file after reading: " .
                              "$busy_lock\n" .
                              "[$OS_ERROR]\nProcessing continuing.";
                opatchIO -> print_message ( { f_handle => *STDERR,
                                              message  => $message } )
            };


            foreach my $line ( @file_data ) {
                chomp $line;

                if ( $line =~ m#^Locked by class  : # ) {
                    ( $return_values{lock_class} ) =
                                 ( $line =~ m#^Locked by class  :\s+(\w+)$# );
                }

                if ( $line =~ m#^RAC node details  : # ) {
                    ( $RAC_node_patched ) =
                                    ( $line =~ m#^RAC node details  : (.+)$# );
                }

                if ( $line =~ m#^Locked for patch  :  $patch_id# ) {

                    $match_patch_flag = 1;
                    $line = "";
                    if ( ! $match_patch_flag ) {
                        $error_messages .= $line;
                    }
                }

                if ( $line =~ m#Locked for patch  : # ) {
                   my @list = split ':', $line;
                   $holding_patch = $list[1];
                }
            }

            if ( ! $match_patch_flag ) {
                if (  ! $error_messages eq "" ) {
                  $error_messages = "Lock file exists, details are:\n" .
                                  $error_messages;
                } else {
                  if ($Command::ROLLBACK_CALLED_BY_APPLY) {
                     opatchIO->print_message({ message =>
                        "Interim Patch $holding_patch is holding the lock " .
                        "from this patch $patch_id.  But OPatch will ignore " .
                        "the lock file since this is a forced RollBack.\n" });
                  } else {
                     $error_messages = "Lock file exists, details are:\n" .
                                    " Interim Patch " . $holding_patch .
                                    " is holding the lock from this patch $patch_id,\n" .
                                    " probably due to previous" .
                                    " unsuccessful operation\n";
                  }
                }

            } else {
                $error_messages = "";
            }
        }
    }


    # This is the else from above.
    # Should update the date when continuing with an interrupted patch.
    # Due to new RAC requirements this update is being stopped as I need
    # a new lock mechanism in the next major rewrite. A rewrite now would
    # loose the RAC node details if they exist.
    if ( ! -e $busy_lock ) {

        local *LOCK_FILE;
        open ( LOCK_FILE, ">$free_lock" ) || ( $error_messages .=
                                              "Couldn't write the lock file " .
                                              "data. Error is: $OS_ERROR\n" );
        # Assumes a POSIX unix by default.
        my $host_details = "Microsoft Node unknown at this time.";
        if ( $OSNAME !~ m#Win32# ) {
            $host_details = qx/uname -n/;
            chomp $host_details;
        }

        if ( ! $RAC_node_patched ) {
            $RAC_node_patched = "Not Applicable";
        }

        if ( ! $error_messages ) {
            my $time_now = localtime();
            my $message = "Locked for patch  :  $patch_id\n" .
                          "Locked by class   :  $this_class\n" .
                          "Locked by process :  $PROCESS_ID\n" .
                          "Locked at time    :  $time_now\n" .
                          "Effective User ID :  $EUID\n" .
                          "Real User ID      :  $UID\n" .
                          "Host details      :  $host_details\n" .
                          "RAC node details  :  $RAC_node_patched \n";

            opatchIO -> write_lock_file ( { lock_file => *LOCK_FILE,
                                          message  => $message } );

            # And now make it the lock file.
            close ( LOCK_FILE );
            rename ( $free_lock, $busy_lock ) || ( $error_messages .=
                                         "Couldn't move lock file into " .
                                         "place\n" );
        }
    }

    $RAC_node_patched =~ s/Not Applicable//;

    $return_values{lock_file_errors}  = $error_messages   || "";
    $return_values{patched_RAC_nodes} = $RAC_node_patched || "";

    return ( \%return_values );

}   # End of check_patch_lock_status().


###############################################################################
#
# NAME   : check_if_database_running
#
# PURPOSE: Check and try to determine if any processes are active for a
#          the given $ORACLE_HOME.
#
# INPUTS : $$ARG[1]{Oracle_Home}    - The $ORACLE_HOME to check.
#          $$ARG[1]{rh_executables} - A list of files that shouldn't have
#                                     any active processes attached.
#
# OUTPUTS: $active_files            - A list of files that have active
#                                     processes when the file shouldn't be
#                                     active at all.
#
# NOTES  : 1. OS dependant at the moment, there are no OUI (or other API)
#             call that will return this data.
#          3. Notes on the calls are in the OS dependant sections.
#
###############################################################################
sub check_if_database_running {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home  = $$rh_arguments{Oracle_Home};
    my $rh_executable_files = $$rh_arguments{rh_executables};

    my $active_files   = "";
    my $counter        = 0;
    my $system_command = "";
    my $process_error  = 0;
    my $use_csh_syntax = 0;

    my $fuser = $this_class->getFuserCommand();

    # Small hack originally only for Tru64. If the account is C shell then
    # when perl issues a system call (in the bourne shell) then all messages
    # appear on the controlling terminal.
    # Redirection of STDERR and STDOUT fails totally.
    if ( $OSNAME !~ m#Win32# ) {
        my $shell_check_command = "echo \$SHELL";
        my $shell_check_result = qx/$shell_check_command/;

        if ( $shell_check_result =~ m#csh$# ) {
            # Normally caused by the account having a C shell.
            $use_csh_syntax = "csh -c \"$fuser full_path |& cut -f1\"";
        }
    } else {
        # No module to do fuser on Win yet, cut short to not run fuser
        return ( $active_files );
    }

    # Read the env. var to skip the invocation of fuser on user request.
    my $no_fuser_check = $ENV{OPATCH_NO_FUSER};
    if($no_fuser_check eq "TRUE" || $no_fuser_check eq "true")
    {
	opatchIO -> print_message_noverbose ( { message => "Skipping invocation of fuser command as" .
					 " OPATCH_NO_FUSER env. variable is set.\n" });
	return( $active_files );
    }
    else
    {
	opatchIO -> print_message_noverbose ( { message => "Invoking fuser" .
                                         " to check for active processes.\n" });

    }

    my $process_list = "";
    foreach my $file ( keys %$rh_executable_files ) {

        my $full_path = $$rh_executable_files{$file};

       # A hack for Solaris 2.6 where fuser lies to us.
       if ( ( $OSNAME eq "solaris" ) && ( $full_path eq
              File::Spec -> catfile ( "$Oracle_Home", "bin", "oracle" ) ) ) {
           my $check_file_name = File::Spec -> catfile ( "$Oracle_Home",
                                                      "mesg", "oraus.msb" );
           $$rh_executable_files{oraus} = $check_file_name;
       }

        # If a critical file doesn't exist the patch is wrong or the
        # system has _major_ problems with the instance were patching.
        if ( (! -e $full_path ) || ( -d $full_path ) )
	{
	    opatchIO -> print_message_noverbose({ 
				message => "Skipping invocation of fuser on \"" .$full_path ."\" as the file does not exist or is a directory." });
	    next;
	}


        # Some OSs put the file name on STDERR, lets keep it all together.
        # Perl spawns "qx" commands as /bin/sh so it's bourne/korn syntax.
        $system_command = "$fuser $full_path 2>&1";
        if ( $use_csh_syntax ) {
	          my $temp_use_csh = $use_csh_syntax;
            $temp_use_csh =~ s/full_path/$full_path/;
            $system_command = $temp_use_csh;
        }

        opatchIO -> print_message_noverbose ( { message => "Invoking fuser on \"" . 
                             $full_path ."\"" } );

        my $sys_call_result = qx/$system_command/;
        chomp $sys_call_result;
        opatchIO -> debug ( { message => "Invoked fuser command: \"$system_command\"\n" .
                                               "  Result is \"$sys_call_result\"\n"
                                } );

        my $status = $this_class -> get_child_error ( {
          CHILD_ERROR     => $CHILD_ERROR
        } );
        if ( ! $status ) {
            # On some OSs "fuser: not found" returns 0 instead of an error.
            if ( ( $sys_call_result =~ m#fuser: Command not found#i ) ||
                 ( $sys_call_result =~ m#fuser: cannot execute#i )    ||
                 ( $sys_call_result =~ m#fuser: not found#i )    ||
                 ( $sys_call_result =~ m#fuser: Permission denied#i ) ) {
                $process_error = 1;
            } else {
                ( $sys_call_result ) =
                          ( $sys_call_result =~ m#^$full_path:\s+(.+)$# );
            }
        } else {
            # Linux returns CHILD_ERROR as 256 (100000000)
            # so 100000000 & 127 = 0 and 100000000 >> 8 != 0
            if ( $OSNAME eq "linux" ) {
              $status = $CHILD_ERROR  & 127;
              if ( $status ) {
                $process_error = 1;
              } else {
                # OK on Linux
              }
            } else {
              # so far it should be an error for other platforms
              $process_error = 1;
            }
        }

        if ( $sys_call_result ) {
            $counter++;
            $active_files .= "$counter.  $full_path\n";
        }
    }

    if ( $active_files ne "" ) {
        $active_files = "The following files have active processes when " .
                        "there should be no activity.\nBefore you proceed," .
                        " shutdown and stop all active processes.\n" . 
                        $active_files ;
    }

    if ( $process_error )  {
        $active_files = "There were problems when checking for active " .
                        "processes on critical files.\n\n" .
                        "The patch tool runs the command \"$fuser\" to check " .
                        "that critical files are not in use. " .
                        "Make sure 'fuser' is available and executable on your PATH";
    }

    return ( $active_files );

}   # End of check_if_database_running().

###############################################################################
#
# NAME   : check_patch_OS_against_machine
#
# PURPOSE: Check if the patch is supported on the current OS.
#
# INPUTS : $$ARG[1]{current_os_id}    - The OS id number from get_osid().
#          $$ARG[1]{rh_os_platforms}  - A hash containing the list of OSs
#                                       that this patch supports. The key is
#                                       OS number, the value is the OS name.
#
# OUTPUTS: $matching_os_flag
#
# NOTES  : 1. Add to the OS's as they are known.
#          2. Give me time and all the methods will be this short.
#
###############################################################################
sub check_patch_OS_against_machine {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $current_os_id   = $$rh_arguments{current_os_id};
    my $rh_os_platforms = $$rh_arguments{rh_os_platforms};

    my $match_flag = 0;

    foreach my $os_number ( keys %$rh_os_platforms ) {
        my $os_name = $$rh_os_platforms{$os_number};
        if ( $os_number == $current_os_id ) {
            $match_flag = 1;
        }
    }

    return ( $match_flag );

}   # End of check_patch_OS_against_machine().

###############################################################################
#
# NAME : get_current_timestamp
#
# OUTPUTS: return a string to represent the current timestamp.  Caller is
#          not supposed to parse the format of the string.
#
###############################################################################
sub get_current_timestamp { 

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst )
                                                       = localtime ( time() );
    $year = $year + 1900;
    # There is no month "zero" to people.
    $mon++;
    if ( $mon < 10 ) { $mon = "0" . $mon; }
    if ( $mday < 10 ) { $mday = "0" . $mday; }
 
    # Make hour, min and sec a 2-digit number 
    if ( $hour < 10 ) { $hour = "0" . $hour; }
    if ( $min < 10 )  { $min = "0" . $min; }
    if ( $sec < 10 )  { $sec = "0" . $sec; }

    my $time_tag = "$mon" . "-" . "$mday" . "-" . "$year" . "_" . 
                   "$hour" . "-" . "$min" . "-" . "$sec";                    

    return $time_tag;
}


###############################################################################
#
# NAME   : create_logging_file
#
# PURPOSE: Create a file for logging actions.
#
# INPUTS : $$ARG[1]{patch_id}    - The patch id. Used to name the log.
#          $$ARG[1]{Oracle_Home} - The base directory for the log.
#
# OUTPUTS: %rh_return_values     - A hash containing the details of the
#                                  values to be returned. The keys are:
#                {error_flag}    - A string of any error messages.
#                {fh_log_file}   - A file handle pointing to the log file.
#                {log_file_name} - The name of the log file.
#
# NOTES  : 1. See opatchIO::log_message for the writer.
#
###############################################################################
sub create_logging_file {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $patch_id     = $$rh_arguments{patch_id};
    my $Oracle_Home  = $$rh_arguments{Oracle_Home};

    my $dir_creation_result = "";
    my $error_messages = "";

    my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst )
                                                       = localtime ( time() );
    $year = $year + 1900;
    # There is no month "zero" to people.
    $mon++;
    if ( $mon < 10 ) { $mon = "0" . $mon; }
    if ( $mday < 10 ) { $mday = "0" . $mday; }

    # Make hour, min and sec a 2-digit number (bug 4101719)
    if ( $hour < 10 ) { $hour = "0" . $hour; }
    if ( $min < 10 )  { $min = "0" . $min; }
    if ( $sec < 10 )  { $sec = "0" . $sec; }
    
    my $log_file_name = "$patch_id" . "_" . "$this_class" . "_" .
                                                    "$year$mon$mday" . ".log";
    
    my $time_tag = "$mon" . "-" . "$mday" . "-" . "$year" . "_" . 
                   "$hour" . "-" . "$min" . "-" . "$sec";                    
    $log_file_name = "$this_class" . "_" . "$patch_id" . "_" .
                     "$time_tag" . ".log";

    my $patch_directory   = File::Spec -> catfile ( "$Oracle_Home",
                                                     $this_class -> save_dir,
                                                     $patch_id );

    my $output_file_name = File::Spec -> catfile
                                    ( "$patch_directory" , "$log_file_name" );

    if ( -e $output_file_name ) {
        my $new_name = $output_file_name . "~";
        rename ( $output_file_name, $new_name ) || ( $error_messages .=
                                         "Couldn't move existing file: " .
                                         "$output_file_name\n" );
    }

    local *LOG_FILE;
    if ( ! $error_messages ) {
        open ( LOG_FILE, ">$output_file_name" ) || ( $error_messages .=
                                         "Couldn't create file for logging. " .
                                         "Error is: $OS_ERROR\n" );
    }

    my %rh_return_values = ();
    $rh_return_values{error_flag} = $error_messages;
    $rh_return_values{fh_log_file} = *LOG_FILE;
    $rh_return_values{log_file_name} = $log_file_name;

    # Store the log file details in global variables
    $Command::logging_error_flag = $error_messages;
    $Command::logging_fh_log_file = *LOG_FILE;
    $Command::logging_log_file_name = $log_file_name;

    #printing for bug 4218253
    opatchIO -> print_message_noverbose ( {
          message =>
            "Creating log file \"$output_file_name\"\n"
        } );

    return ( \%rh_return_values );

}   # End of create_logging_file().

###############################################################################
#
# NAME   : create_rollback_file
#
# PURPOSE: Create a file for the commands to rollback an incomplete
#          patch installation as rollback_<ID>.sh 
#
# INPUTS : $$ARG[1]{patch_id}    - The patch id. Used to name the log.
#          $$ARG[1]{Oracle_Home} - The base directory for the log.
#
# OUTPUTS: %rh_return_values     - A hash containing the details of the
#                                  values to be returned. The keys are:
#                {error_flag}    - A string of any error messages.
#                {fh_log_file}   - A file handle pointing to the log file.
#                {log_file_name} - The name of the log file.
#
# NOTES  : 1. Yes, this can be done directly. But they want everything
#             as a method.
#
###############################################################################
sub create_rollback_file {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $patch_id     = $$rh_arguments{patch_id};
    my $Oracle_Home  = $$rh_arguments{Oracle_Home};

    my $error_messages = "";
    my $rollback_file_name = "rollback" . "_" . "$patch_id";
    my ( $extension ) = ( $OSNAME =~ m#Win32# ) ? ".cmd" : ".sh" ;
    $rollback_file_name .= $extension;

    # Comment in Unix shell scripts = #, Windows = "REM";
    my ( $c_char )    = ( $OSNAME =~ m#Win32# ) ? "REM" : "#" ;

    my $patch_directory   = File::Spec -> catfile ( "$Oracle_Home",
                                                     $this_class -> save_dir,
                                                     $patch_id );

    my $output_file_name = File::Spec -> catfile
                              ( "$patch_directory" , "$rollback_file_name" );

    local *ROLLBACK_FILE;

    # If the file exists, then back it up so that
    # it is not over-written below.
    # backup file name is "rollback_<patchID>.sh_<timestamp>"
    if( -e $output_file_name) {
       my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst )
                                                       = localtime ( time() );
        $year = $year + 1900;
        # There is no month "zero" to people.
        $mon++;
        if ( $mon < 10 ) { $mon = "0" . $mon; }
        if ( $mday < 10 ) { $mday = "0" . $mday; }

        # Make hour, min and sec a 2-digit number (bug 4101719)
        if ( $hour < 10 ) { $hour = "0" . $hour; }
        if ( $min < 10 )  { $min = "0" . $min; }
        if ( $sec < 10 )  { $sec = "0" . $sec; }

        my $log_file_name = "$patch_id" . "_" . "$this_class" . "_" .
                                                    "$year$mon$mday" . ".log";

        my $time_tag = "$mon" . "-" . "$mday" . "-" . "$year" . "_" .
                       "$hour" . "-" . "$min" . "-" . "$sec";

       my $backup_rollback_file = "$output_file_name" . "_" . "$time_tag";

       File::Copy::copy( $output_file_name, $backup_rollback_file );
       opatchIO -> print_message( {message => "Backing up the rollback script as \"$backup_rollback_file\" \n"} );
    }

    # It may be half-way through. If the file exists append to it.
    # We now create a fresh file always, as we want to call pre
    # at the start, and not somewhere in between
    open ( ROLLBACK_FILE, ">$output_file_name" ) || ( $error_messages =
                                "Couldn't create file for the make " .
                                "commands. Error is: $OS_ERROR\n" );

    # Provide execute permission to the file
    chmod 0755, $output_file_name;

    my $message = "#!/bin/sh\n\n";
    if ( $OSNAME =~ m#Win32# ) { $message = "\@echo off\n"; }

    if ( ( ! $error_messages ) && ( ! -s $output_file_name ) ) {
        $message .=
      "$c_char Use this script at your own risk!\n$c_char\n"                  .
      "$c_char This will replace the files from the patch script so that\n"   .
      "$c_char any file is returned to the same state as it was in before\n"  .
      "$c_char the patch was applied.\n$c_char\n"                             .
      "$c_char This assumes no make command was issued. If a make command\n"  .
      "$c_char was issued then this will corrupt your installation. The\n"    .
      "$c_char best thing to do is to rerun the apply command and let the\n"  .
      "$c_char apply phase finish once the first make command is run.\n"      .
      "$c_char\n"                                                             .
      "$c_char The commands in this file can be run from the command line.\n" .
      "$c_char The file existence check is written before the file is in\n"   .
      "$c_char place so it's possible the last entry will not be required.\n" .
      "\n\n\n\n" .
      "$c_char Get ORACLE_HOME from environment variable \"ORACLE_HOME\"\n";

      if ( $OSNAME =~ m#Win32# )
      {
        $message .= "set OH=\%ORACLE_HOME\%\n\n";
      }
      else
      {
        $message .= "OH=\${ORACLE_HOME}\n\n";
      }

      $message .= "$c_char Error out if OH is not set\n";

      if ( $OSNAME =~ m#Win32# )
      {
        $message .=
        "if NOT \"\%OH\%\" == \"\" goto MODIFY_FILES\n" .
        "    echo Oracle Home is not set. rollback_ID$extension cannot proceed!\n" .
        "    set \%ERRORLEVEL\% = 1\n" .
        "    exit \%ERRORLEVEL\%\n\n" .
        ":MODIFY_FILES\n" .
        "echo This script is going to roll back the changes made to system files on\n" .
        "echo this Oracle Home only. It does not perform any of the following:\n" .
        "echo - Inventory update\n" .
        "echo - Customized steps performed manually by user\n" .
        "echo Please use this script with supervision from Oracle Technical Support.\n" .
        "echo To rollback a patch, please use 'opatch rollback'.\n\n" .
        "echo About to modify Oracle Home( \%OH\% )\n" .
        "echo Do you want to proceed? [Y/N]\n" .
        "if \"\%1\" == \"-silent\" goto PROCEED\n" .
        "set /p response= ^>\n\n" .
        "if \"\%response\%\" == \"Y\" goto PROCEED\n" .
        "if \"\%response\%\" == \"y\" goto PROCEED\n" .
        "echo User responded with : \%response\%\n" . "exit 0;\n" . "\n" .
        ":PROCEED\n" .
        "echo User responded with : Y\n" . "\n";
      }
      else
      {
        $message .= 
        "if [ \"\$OH\" = \"\" ]; then\n" .
        "    echo Oracle Home is not set. rollback_ID$extension cannot proceed!\n" .
        "    exit 1\n" .
        "fi\n" .
        "echo This script is going to roll back the changes made to system files on\n" .
        "echo this Oracle Home only. It does not perform any of the following:\n" .
        "echo - Inventory update\n" .
        "echo - Oracle binary re-link\n" .
        "echo - Customized steps performed manually by user\n" .
        "echo Please use this script with supervision from Oracle Technical Support.\n" .
        "echo To rollback a patch, please use \"'opatch rollback'\".\n\n" .
        "echo \"About to modify Oracle Home( \$OH )\"\n" .
        "echo \"Do you want to proceed? [Y/N]\"\n" .
        "if [ \"\$1\" = \"-silent\" ]; then\n" .
        "   response=\"Y\"\n" .
        "else\n" .
        "    read response;\n" .
        "fi\n\n" .
        "if [ \$response = \"y\" ] || [ \$response = \"Y\" ]; then\n" .
        "    echo \"User responded with : Y\"\n" .
        "else\n" .
        "    echo \"User responded with : \$response\"\n" .
        "    exit 0\n" .
        "fi\n\n";

      }

        # Save the rollback.sh file details in a global location
        $Command::fh_rollback = *ROLLBACK_FILE;
        $Command::rollback_file_name = $rollback_file_name;

        opatchIO -> print_message ( { f_handle => *ROLLBACK_FILE,
                                     message  => $message } );

    }

    my %rh_return_values = ();
    $rh_return_values{error_flag} = $error_messages;
    $rh_return_values{fh_log_file} = *ROLLBACK_FILE;
    $rh_return_values{log_file_name} = $rollback_file_name;

    return ( \%rh_return_values );

}   # End of create_rollback_file().

###############################################################################
#
# NAME   : create_save_area
#
# PURPOSE: Create an area to save the back-up files to.
#
# INPUTS : $$ARG[1]{patch_id}    - The patch id. Used to name the log.
#          $$ARG[1]{Oracle_Home} - The base directory for the log.
#
# OUTPUTS: error_messages        - A string of any error messages.
#
# NOTES  :
#
###############################################################################
sub create_save_area {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $patch_id     = $$rh_arguments{patch_id};
    my $Oracle_Home  = $$rh_arguments{Oracle_Home};

    my $error_messages  = "";

    my $save_directory = File::Spec -> catfile
                                         ( "$Oracle_Home",
                                           $this_class -> save_dir );

    my $patch_directory = File::Spec -> catfile
                                         ( "$save_directory",
                                           $patch_id );

    if ( ! -e $save_directory ) {
        my $dir_creation_result = mkdir ( $save_directory, 0750 );
        if ( ! $dir_creation_result ) {
            $error_messages = "Problem with creating directory: " .
                              "$save_directory.\n";
        }
    } else {
        opatchIO -> print_message( { message => ".patch_storage exists, checking its perms" .
                                                " and changing it if necessary.\n" });
        my $current_dir = Cwd::cwd();
        chmod 0750, $save_directory;
        chdir $save_directory;
        $this_class -> change_perm_recursive();
        chdir $current_dir;
    }

    if ( ( ! -e $patch_directory ) && ( ! $error_messages ) ) {
        my $dir_creation_result = mkdir ( $patch_directory, 0755 );
        if ( ! $dir_creation_result ) {
            $error_messages = "Problem with creating directory: " .
                              "$patch_directory.\n";
        }
    }

    return ( $error_messages );

}   # End of create_save_area().

###############################################################################
#
# NAME   : display_help
#
# PURPOSE: Display a help message for the command.
#
# INPUTS : $$ARG[1]{command}         - The command to display the help details.
#          $$ARG[1]{rh_command_list} - A reference to a hash containg details
#                                      about the valid commands and options.
#
# OUTPUTS: NONE
#
# NOTES  :
#
###############################################################################
sub display_help {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $command           = $$rh_arguments{command};
    my $rh_command_list   = $$rh_arguments{rh_command_list};

    # This is the indent used in the "here doc" for output.
    my $indent = " "x9;

    # Format the command synopsis.
    my $synopsis_string = $indent . $$rh_command_list{$command}{_description};
    $synopsis_string =~ s/\n/\n$indent/g;

    # Format the command description.
    my $description_string = $indent . $$rh_command_list{$command}{_helpText};
    $description_string =~ s/\n/\n$indent/g;

    # Format the commands arguments.
    my $longest_string = 0;
    foreach my $argument ( keys %${$$rh_command_list{$command}{_options}} ) {
        my $this_length = length ( $argument );
        if ( $longest_string < $this_length ) {
            $longest_string = $this_length;
        }
    }
    $longest_string += 2;

    my $argument_list = "";
    foreach my $argument
                     ( sort keys %${$$rh_command_list{$command}{_options}} ) {

        my $pad = $longest_string - length ( $argument );
        my $help_text =
              $${$$rh_command_list{$command}{_options}}{$argument}{_helpText};

        # Format any new lines into the correct shape.
        my $format_pad = " "x$longest_string . $indent;
        $help_text =~ s/\n/\n$format_pad/g;

        $argument_list .= $indent . $argument . " "x$pad . $help_text . "\n\n";
    }
    ( $argument_list ) = ( $argument_list =~ m#(.+)\n\n$#s );
    if ( ! $argument_list ) {
        $argument_list = $indent . "No arguments to this command";
    }

    # Start of "here doc".
    print STDOUT <<END_OF_USAGE

    Help for opatch command: $command

    SYNOPSIS:

$synopsis_string

    DESCRIPTION:

$description_string

    ARGUMENTS:

$argument_list

END_OF_USAGE
;
}   # End of display_help().

###############################################################################
#
# NAME   : get_patched_files
#
# PURPOSE: Recusively and inefficiently but safely traverse a patch
#          storage area and recover the details of patched files and
#          return the details in a similar way the OUI APIs would.
#
# INPUTS : $$ARG[1]{Oracle_Home} - The $ORACLE_HOME to check.
#          $$ARG[1]{patch_id}    - The patch id. Used to name the log.
#          $$ARG[1]{patch_loc}   - The patch directory being searched.
#
# OUTPUTS: \@file_names          - A reference to an array of strings.
#
# NOTES  : Errors to be figured out later.
#
###############################################################################
sub get_patched_files {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home  = $$rh_arguments{Oracle_Home};
    my $patch_id     = $$rh_arguments{patch_id};
    my $patch_loc    = $$rh_arguments{patch_loc};    # Really current loc.

    my @file_names   = ();

    local *DIR_HANDLE;
    opendir ( DIR_HANDLE, $patch_loc );
    my @dir_details = readdir DIR_HANDLE;
    closedir DIR_HANDLE;

    my $top_dir = "";
    if ( $patch_id eq &File::Basename::basename( $patch_loc ) ) {
        $top_dir = $patch_id;
    }

    my $patch_suffix = "_pre_" . $patch_id;
    my $patch_dir = File::Spec -> catfile ( "", $patch_id, "" );

    foreach my $entry ( @dir_details ) {

        next if ( ( $entry eq "." ) || ( $entry eq ".." ) );

        my $full_path = File::Spec -> catfile ( $patch_loc, $entry );

        next if ( ( $top_dir ) && ( -f $full_path ) );

        # Lets see if we need to use recursion.
        if ( -d $full_path ) {
           my $ra_local_paths = $this_class -> get_patched_files ( {
                                             Oracle_Home => $Oracle_Home,
                                             patch_id    => $patch_id,
                                             patch_loc   => $full_path } );

           foreach my $path ( @$ra_local_paths ) {
               push ( @file_names, $path );
           }
        }

        # Yes, this could have been done as an else to the above's -d test
        # but what if it's a sym link, pipe, etc...
        if ( ( -f $full_path ) &&
             ( $full_path =~ m#$patch_suffix$# ) ) {
            # OK, we have a filename. Let see what we can do with it.

            # Strip off the suffix.
            my ( $path ) = ( $full_path =~m#^(.+)$patch_suffix$# );
            # Strip off the patch loc details.
            ( $path ) = ( $path =~ m#$patch_dir(.*)$# );

            # Now find where the base file is. Needed for parent/child types.
            my $match_found = "";
            my $test_dir = $path;
            while ( ! $match_found ) {

                $test_dir = &File::Basename::dirname( $test_dir );
                my $check_location =
                            File::Spec -> catfile ( $Oracle_Home, $test_dir );
                opendir ( DIR_HANDLE, $check_location );
                @dir_details = readdir DIR_HANDLE;
                closedir DIR_HANDLE;
                foreach my $check_file ( @dir_details ) {
                    if ( $path =~ m#$check_file$# ) {
                        $match_found = File::Spec -> catfile (
                                              $check_location, $check_file );
                    }
                }
            }

           my $installed_file = &File::Basename::basename( $match_found );
           my ( $installed_dir ) =
                             ( $match_found =~ m#^(.+)$installed_file$# );

           if ( $path =~ m#_$installed_file$# ) {

               # Child/parent relationship.

               # Strip off the parent identifier.
               ( $path ) = ( $path =~ m#^(.+)_$installed_file$# );
               # Fully qualify the path.
               $path = File::Spec -> catfile ( $Oracle_Home, $path );
               # Strip it down to child component.
               ( $path ) = ( $path =~ m#$installed_dir(.+)$# );

               # Small hack to get around and OUI limitation.
               if ( $path !~ m#/# ) { $path = "/$path"; }

               $match_found = "$match_found -> $path";
               push ( @file_names, $match_found );

           } else {

               # Simple file.
               push ( @file_names, $match_found );
           }
        }
    }

    return ( \@file_names );

}   # End of get_patched_files().

###############################################################################
#
# NAME   : free_the_lock_file
#
# PURPOSE: Remove the lock file so other patches can be applied.
#
# INPUTS : $$ARG[1]{all_nodes}   - A list of the nodes in the RAC.
#          $$ARG[1]{local_node}  - The name of the local node.
#          $$ARG[1]{Oracle_Home} - The $ORACLE_HOME to check.
#          $$ARG[1]{patch_id}    - The patch id. Used to name the log.
#
# OUTPUTS: $error_message        - A string with the details about any
#                                  problems.
#
#
# NOTES  :
#
###############################################################################
sub free_the_lock_file {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $all_nodes    = $$rh_arguments{all_nodes}  || "";
    my $local_node   = $$rh_arguments{local_node} || "";
    my $Oracle_Home  = $$rh_arguments{Oracle_Home};
    my $patch_id     = $$rh_arguments{patch_id};

    my $error_messages = "";
    my $match_patch_flag = 0;

    my $patch_store = File::Spec -> catfile( $Oracle_Home, ".patch_storage" );
    my $free_lock   = File::Spec -> catfile( $patch_store, "patch_free"     );
    my $busy_lock   = File::Spec -> catfile( $patch_store, "patch_locked"   );

    # If it doesn't work get the user to fix it.
    rename ( $busy_lock, $free_lock ) || (
        $error_messages = "Couldn't rename lock file. Please remove the " .
                          "file:\n  $busy_lock\n" );
    #
    # And just remove it from the other nodes.
    #

    # On HP-UX use remsh, not rsh. Not using :? syntax as there may be
    # changes for other OSs.
    
    my $rsh_command    = $Command::RSH_SSH; 
    my $isRSH_SSH = $ENV{OPATCH_REMOTE_SHELL};
    if ( $isRSH_SSH eq "" && $OSNAME eq "hpux") {
       $rsh_command = "remsh";
    }

    my @nodes          = split ( " ", $all_nodes );
    foreach my $target ( @nodes ) {

        next if ( ! $target ); # Damn null values.
        # next if ( $target =~ m#$local_node# );
        if ( $target eq $local_node ) {
              next;
        }

        my $system_command = "$rsh_command -n $target \"";
        if ( ( $OSNAME eq "hpux" ) || ( $OSNAME eq "aix" ) ) {
            $system_command = "$rsh_command $target -n \"";
        }

        $system_command .= "rm -f $busy_lock\"";
        my $sys_call_result = qx/$system_command/;

        # Need error processing here.
    }

    return ( $error_messages );

}   # End of free_the_lock_file().

###############################################################################
#
# NAME   : find_executable_file
#
# PURPOSE: Find an executable file and return its path
#
# INPUTS : $$ARG[1]{start_point} - The directory to start from.
#          $$ARG[1]{target}      - The file to find.
#
# OUTPUTS: $result - Path to the target or "" if can't find
#
# NOTE: This sub. exits with error code if it can't find the file
#
###############################################################################
sub find_executable_file {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $start_point  = $$rh_arguments{start_point};
    my $target       = $$rh_arguments{target};

    my $result = $this_class -> find_a_file ( { start_point => $start_point,
                                      target => $target } );
    opatchIO -> debug ( { message => "finding $target from $start_point, " .
                                               "result is $result\n"
                                } );
    if ( ! $result ) {
        opatchIO -> print_message_and_die ( {
                     exit_val => $this_class -> ERROR_CODE_COMMAND_LINE_ARGUMENT ,
                     message => "find_executable_file(): Cannot find \"$target\" from \"$start_point\"\n"
		     } );
    }
    if (! -x $result) {
        opatchIO -> print_message_and_die ( {
                     exit_val => $this_class -> ERROR_CODE_COMMAND_LINE_ARGUMENT ,
                     message => "find_executable_file(): \"$target\" is not executable\n"
		     } );
    }

    return $result;
}

###############################################################################
#
# NAME   : find_a_file
#
# PURPOSE: A simplified directory traversal to locate a known file.
#
# INPUTS : $$ARG[1]{start_point} - The directory to start from.
#          $$ARG[1]{target}      - The file to find.
#
# OUTPUTS: $result - Path to the target
#
# NOTES  : 1. Don't need the complexity of File::Find or find2perl. This
#             is for a know to be small directory. If you want anything more
#             complex use the perl modules.
#          2. The file should be located at $start_point/<somedir>/file.
#          3. This util. cannot find "foo" if it is in /tmp/foo
#
# Note: 11/07/03: Converted this function to search a directory
#                 recursively. It now uses Perl's find function
#                 to do the job
###############################################################################
sub find_a_file {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $start_point  = $$rh_arguments{start_point};
    my $target       = $$rh_arguments{target};

    $find_a_file_result = "";
    $find_a_file_target = $target;
    my $result = "";

    if ( (! -e $start_point) || ($target eq "") ) {
        return $result;
    }
    sub check_for_file {
        if ( $find_a_file_target eq $_ ) {
            $find_a_file_result = $File::Find::name;
            $File::Find::prune = 1;
        }
    }

    find( \&check_for_file, $start_point);
    $result = $find_a_file_result;

    # Update directory name to take care of windows case
    if ( $OSNAME =~ m#Win# ) {
        $result =~ s/\//\\/g;
    }

    return ( $result );

}   # End of find_a_file().

###############################################################################
#
# NAME   : get_child_error
#
# PURPOSE: process CHILD_ERROR (error code from child program being "qx"
#          by OPatch Perl
#
# INPUT: $$ARG[1] - CHILD_ERROR
#
# OUTPUT: process platform-independent CHILD_ERROR 
#         and return either
#           ERROR
#           SUCCESS
#           WARNING
#
###############################################################################
sub get_child_error {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $status  = $$rh_arguments{CHILD_ERROR};
    # PERL returns CHILD_ERROR as 256 (100000000) if error and 0 if OK
    # so 100000000 >> 8 will be 1.
    # We have to ship by 8 because the lower bits are reserved and could
    #   be set to indicate other things 
    $status = $status >> 8;

    return $status;
}

###############################################################################
#
# NAME   : save_prescript_return_code
#
# PURPOSE: process the return code from pre/post script and forge it
#          into expected $Command::PREPOST_SUCCESS/ERROR/WARNING
#
# INPUT: $$ARG[1] - return code from pre script
#
# OUTPUT: $Command::PREPOST_SUCCESS
#         $Command::PREPOST_WARNING
#         $Command::PREPOST_ERROR
#
###############################################################################
sub save_apply_prescript_return_code {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $cooked_return_code = $$rh_arguments{return_code};
    if ( $cooked_return_code == $Command::PREPOST_SUCCESS ) {
      $cooked_return_code = $Command::PREPOST_SUCCESS;
    } elsif ( $cooked_return_code == $Command::PREPOST_WARNING ) {
      $cooked_return_code = $Command::PREPOST_WARNING;
    } else {
      $cooked_return_code = $Command::PREPOST_ERROR;
    }
    
    $Command::APPLY_PRE_SCRIPT_STATUS = $cooked_return_code;
}

sub save_apply_postscript_return_code {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $cooked_return_code = $$rh_arguments{return_code};
    if ( $cooked_return_code == $Command::PREPOST_SUCCESS ) {
      $cooked_return_code = $Command::PREPOST_SUCCESS;
    } elsif ( $cooked_return_code == $Command::PREPOST_WARNING ) {
      $cooked_return_code = $Command::PREPOST_WARNING;
    } else {
      $cooked_return_code = $Command::PREPOST_ERROR;
    }

    $Command::APPLY_POST_SCRIPT_STATUS = $cooked_return_code;
}

sub save_rollback_prescript_return_code {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $cooked_return_code = $$rh_arguments{return_code};
    if ( $cooked_return_code == $Command::PREPOST_SUCCESS ) {
      $cooked_return_code = $Command::PREPOST_SUCCESS;
    } elsif ( $cooked_return_code == $Command::PREPOST_WARNING ) {
      $cooked_return_code = $Command::PREPOST_WARNING;
    } else {
      $cooked_return_code = $Command::PREPOST_ERROR;
    }
    
    $Command::ROLLBACK_PRE_SCRIPT_STATUS = $cooked_return_code;
}

sub save_rollback_postscript_return_code {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $cooked_return_code = $$rh_arguments{return_code};
    if ( $cooked_return_code == $Command::PREPOST_SUCCESS ) {
      $cooked_return_code = $Command::PREPOST_SUCCESS;
    } elsif ( $cooked_return_code == $Command::PREPOST_WARNING ) {
      $cooked_return_code = $Command::PREPOST_WARNING;
    } else {
      $cooked_return_code = $Command::PREPOST_ERROR;
    }

    $Command::ROLLBACK_POST_SCRIPT_STATUS = $cooked_return_code;
}
###############################################################################
#
# The following subs check if the pre/post scripts have been invoked or not
# INPUT: none
# OUTPUT: 1 for yes, 0 for no
###############################################################################

# this tells if pre script has been invokded during Apply session.
sub was_prescript_run_during_apply {
   if ( $Command::APPLY_PRE_SCRIPT_STATUS == $Command::PREPOST_UNDEF ) {
      return 0;
   } else {
      return 1;
   }
}
# this tells if post script has been invoked during Apply session
sub was_postscript_run_during_apply {
   if ( $Command::APPLY_POST_SCRIPT_STATUS == $Command::PREPOST_UNDEF ) {
      return 0;
   } else {
      return 1;
   }
}

sub was_prescript_run_during_rollback {
   if ( $Command::ROLLBACK_PRE_SCRIPT_STATUS == $Command::PREPOST_UNDEF ) {
      return 0;
   } else {
      return 1;
   }
}
sub was_postscript_run_during_rollback {
   if ( $Command::ROLLBACK_POST_SCRIPT_STATUS == $Command::PREPOST_UNDEF ) {
      return 0;
   } else {
      return 1;
   }
}

###############################################################################
#
# NAME   : get_os_id
#
# PURPOSE: Parse an XML file to get a list 'action' tags and associated files.
#
# INPUTS : $$ARG[1]{Oracle_Home} - The installation to be patched.
#
# OUTPUTS: $os_id - A scalar that represents the OS id number used by the
#                   patch packaging tool.
#
# NOTES  : 1. Use OPATCH_PLATFORM_ID env. var. if set
#          2. If env. var. above not set, use OUI ARU_ID APIs to get platform ID
#          3. If OUI APIs fail, fall back to "uname -a"
#
###############################################################################
sub get_os_id {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home = $this_class -> get_abs_path( { Path => ($$rh_arguments{Oracle_Home} || $ENV{ORACLE_HOME} ) } );

    my $os_id = "";
    my $system_command = "";

    # First set-up the Java class for the inventory read.
    my $rh_OUI_file_names = $this_class -> build_required_OUI_filenames ( {
                                              Oracle_home => $Oracle_Home } );

    my $path_to_java                 = $$rh_OUI_file_names{path_to_java};
    my $inventory_location           = $$rh_OUI_file_names{inventory_location};
    my $liboraInstaller_lib          = $$rh_OUI_file_names{liboraInstaller_lib};
    my $path_to_oI_loc               = $$rh_OUI_file_names{path_to_oI_loc};
    my $oui_component_loc            = $$rh_OUI_file_names{oui_component_loc};
    my $required_jar_file            = $$rh_OUI_file_names{required_jar_file};
    
    
    my $rh_java_paths = $this_class -> make_java_paths ( {
                  Oracle_Home       => $Oracle_Home,
                  rh_OUI_file_names => $rh_OUI_file_names } );
                  
    my $class_path = $$rh_java_paths{class};
    my $lib_path   = $$rh_java_paths{oui_library};
    my $oui_path   = $$rh_java_paths{oui_path};

    if ( ($Command::build_filenames_called == 0) ||
         ($Command::verbose_mode) ||
         ($this_class->isDebug()) )
    {
        opatchIO -> print_message_noverbose ( {
          message =>
            "Oracle Home = $Oracle_Home\n" .
            "Location of Oracle Universal Installer components = $oui_component_loc\n" .
            "Location of OraInstaller.jar  = $lib_path\n" .
            "Oracle Universal Installer shared library = $liboraInstaller_lib\n" .
            "Location of Oracle Inventory Pointer = $path_to_oI_loc\n" .
            "Location of Oracle Inventory = $inventory_location\n" .
            "Path to Java = $path_to_java\n" .
            "Log file = $Oracle_Home/.patch_storage/<patch ID>/*.log\n"
        } );
        # record that this function is called
        $Command::build_filenames_called = 1;
    }

    # Use OPATCH_PLATFORM_ID if it is set
    my $envPlatformID = $ENV{OPATCH_PLATFORM_ID};
    if ( $envPlatformID ne "" ) {
      opatchIO->debug({ message => "Using Pre-defined Platform ID \"$envPlatformID\"\n" });
      $Command::OS_ID = $envPlatformID;
      return $envPlatformID;
    }

    # Now set-up the call and capture the results. 
    my $class_to_run = "opatch/GetPlatformID";
    my $program_name = &File::Basename::basename($PROGRAM_NAME);
    my $version_num  = $this_class -> version;
    my $debug = $Command::DEBUG; 

    my $debug = $Command::DEBUG; 

    my $local_node_only_flag = "";
    if ($Command::LOCAL_NODE_ONLY) {
      $local_node_only_flag = "-Dopatch.local_node_only";
    }
    
    my $local_node_name_flag = "";
    if ($Command::LOCAL_NODE_NAME_MODE) {
      $local_node_name_flag = "-Dopatch.local_node_name=$Command::LOCAL_NODE_NAME"; 
    }

    my $system_command = join(' ', $path_to_java, 
                         $local_node_only_flag,
                         $local_node_name_flag,
                         $Command::inventory_location_ptr,
                         $debug,
                         $class_path, $class_to_run,
                         $oui_path, qq(").$Oracle_Home.qq("),
                         $program_name, $version_num);
                         
    $system_command = $this_class->getDependentPerlCommand({ system_command => $system_command });
    
    my $status = 0;

    opatchIO->debug({ message => "get_os_id(): " });
    my $sys_call_result = $this_class -> run_cmd_print_live ( { sys_command => $system_command,
                                              level => 0 } );

    my $status = $this_class -> get_child_error ( {
          CHILD_ERROR     => $CHILD_ERROR
    } );
    chomp $sys_call_result;    

    # Now parse the output from GetPlatformID to see if it succeeds.  It not,
    # fall back to the old "uname -a"
    my @result = split ( /\n/, $sys_call_result );
    my $ARU_ID = "";

    foreach my $line ( @result ) {
      if ( $line =~ m#ARU_ID=# ) {
          my @list = split '=', $line;
          $ARU_ID = $list[1];
      } 
    }
   
    if ( ($ARU_ID ne "") && ($ARU_ID > 0) ) {
      opatchIO->debug({message => "\nUsing OUI Platform ID $ARU_ID\n" });
      $Command::OS_ID = $ARU_ID;
      return $ARU_ID;
    } else {
      opatchIO->debug({ message => "Fall back to run-time detection for Platform ID...\n" });
    }

    # Leave the print statement in. It's needed when identifying a new OS.
    # print "NAME=$OSNAME*\n";
    if ( $OSNAME eq "solaris" ) {
        # Are we on a "v9" platform (64bit) or 32bit? isainfo doesn't
        # exist in Solaris 2.6 and Oracle doesn't support Solaris 7.
        $system_command = "/bin/isainfo";
        my $sys_call_result = qx/$system_command/;
        my $status = $this_class -> get_child_error ( {
          CHILD_ERROR     => $CHILD_ERROR
        } );

        if ( ( $sys_call_result =~ m#^sparcv9 # ) && ( $status == 0 ) ) {
            $os_id = "23";
            # Now check if it's a 32bit install on Solaris.
            if ( ( ! -e "$Oracle_Home/lib32" ) && ( -e "$Oracle_Home/lib" ) ) {
                $os_id = "453";
            }
        } elsif ( ( ( $sys_call_result =~ m#^sparc\b# ) && ( ! $status ) ) ||
                  ( ( $sys_call_result eq "" )      && ( $status ) ) ) {
            # First test of Solaris 8 and above, second for earlier versions.
            $os_id = "453";
        }

    } elsif ( $OSNAME =~ m#Win32# ) {
        # Only supporting NT at this time. Need to find the difference
        # between NT and 2K at a minimum.
        $system_command = "ver";
        my $sys_call_result = qx/$system_command/;
        my $status = $this_class -> get_child_error ( {
          CHILD_ERROR     => $CHILD_ERROR
        } );
        if ( ( $sys_call_result =~ m#Microsoft Windows 2000# ) &&
             ( $status == 0 ) ) {
            $os_id = "100";
        } elsif ( ( $sys_call_result =~
                               m#Microsoft Windows NT Terminal Server"# ) &&
             ( $status == 0 ) ) {
            $os_id = "175";
        } elsif ( ( $sys_call_result =~ m#Windows NT Version 4.0# ) &&
             ( $status == 0 ) ) {
            # Microsoft _isn't_ in the string for NT v 4.0!
            $os_id = "912";
        } elsif ( ( $sys_call_result =~ m#Microsoft Windows XP# ) &&
             ( $status == 0 ) ) {
            $os_id = "207";
        } elsif ( ( $sys_call_result =~ m#Windows 98 \[# ) &&
             ( $status == 0 ) ) {
            $os_id = "50";
        } elsif ( ( ($sys_call_result =~ m#Microsoft Windows \[Version 5#) ||
                    ($sys_call_result =~ m#Microsoft Windows \[version 5#) ) &&
             ( $status == 0 ) ) {
            $os_id = "215";
            my $processor = "$ENV{'PROCESSOR_IDENTIFIER'}";
            if ( $processor =~ /ia64/ ) { 
              # DDR is using 208 for both 208 Microsoft Windows (64-bit) 
              #    and 206 Microsoft Windows XP (64-bit)
              $os_id = "208"; 
            }			
        }
    } elsif ( $OSNAME eq "hpux" ) {
        # How to differentiate between OS IDs 190 and 197? And what about
        # other versions of HP-UX?

        # HP-UX haha4 B.11.11 U 9000/800 -> HP-UX PA-RISC (64-bit), 59
        $os_id = "59";

        # HP-UX jphp38e6 B.11.22 U ia64 1195119863 -> HP-UX Itanium, 197
        $system_command = "uname -a";
        my $sys_call_result = qx/$system_command/;
        if ( $sys_call_result =~ m#ia64# ) {
          $os_id = "197";
        }
    } elsif ( $OSNAME eq "aix" ) {
        # 4.3 and 5 can be distinguised with a simple 'uname -v'.
        $system_command = "uname -v";
        my $sys_call_result = qx/$system_command/;
        my $status = $this_class -> get_child_error ( {
          CHILD_ERROR     => $CHILD_ERROR
        } );
        if ( ( $sys_call_result == 5 ) && ( $status == 0 ) ) {
            $os_id = "212";
        } elsif ( ( $sys_call_result == 4 ) && ( $status == 0 ) ) {
            $os_id = "38";
        }

    } elsif ( $OSNAME eq "linux" ) {
        # How to differentiate between Intel32 and Intel64 bit?
        # What about RedHat, SuSe, Caldera, etc.?

        $system_command = "uname -a";
        my $sys_call_result = qx/$system_command/;
        my $status = $this_class -> get_child_error ( {
          CHILD_ERROR     => $CHILD_ERROR
        } );
        $os_id = "46";

        my @words = split ' ', $sys_call_result;
        my $word_count = 0;
        foreach my $word (@words) {
           $word_count++;
        }
        my $last_word = $words[$word_count-1];
        my $next_to_last_word = $words[$word_count-2];
  	if ( $last_word =~ m#unknown# && $next_to_last_word =~ m#s390# )
        {
           # 211: Linux on IBM AIX RS 6000
           $os_id = "211";
        } 
	elsif ( $last_word =~ m#s390# ) {
           # 211: Linux on IBM AIX RS 6000
           $os_id = "211";
        } elsif ( $last_word =~ m#unknown# && $next_to_last_word =~ m#ia64# ) {
           # 214: Linux Intel Itanium, output of uname is
           # Linux rmtdcia1.us.oracle.com 2.4.18-e.37smp #1 SMP Tue Aug 5 16:07:26 EDT 2003 ia64 unknown
           # OR
           # Linux pinnacle.netcom.utah.edu 2.4.21-9.EL #1  SMP Thu Jan 8 16:54:40 EST 2004 ia64 ia64 ia64 GNU/Linux
           $os_id = "214";
        } elsif ( $last_word =~ m#Linux# && $next_to_last_word =~ m#ia64# ) {
           $os_id = "214";
        } elsif ( $last_word =~ m#unknown# && $next_to_last_word =~ m#[456]86# ) {
           # 46: Linux IA32
           $os_id = "46";
        } elsif ( $last_word =~ m#x86_64# || $next_to_last_word =~ m#x86_64# ) {
            # 226: Linux x86_64/AMD64
            $os_id = "226";
        }
    } elsif ( $OSNAME eq "dec_osf" ) {
        $os_id = "87";

    }

    opatchIO->debug({ message => "OS ID = $os_id\n" });
    $Command::OS_ID = $os_id;
    return ( $os_id );

}   # End of get_os_id().

###############################################################################
#
# NAME   : global_options
#
# PURPOSE: Install global options so they appear _like_ commands.
#
# INPUTS : $$ARG[1]{rh_detail} - A reference to a hash structure of the class
#                                Command to store the attributes in.
#
# OUTPUTS: NONE
#
# NOTES  : 1. The return values are in hash so the caller will get the new
#             details when this subroutine is finished.
#          2. The design specification has "-help" as a command while "-n"
#             "-x" are options to an instance of Command->global. In reality
#             either they are all options or all commands. These have been
#             coded at the level of a command and are identified as global
#             options by the leading "-" symbol. This removes the dichotomy
#             of the usage and design specification. Of course making a
#             command "global" and having all three as options achieves the
#             same result.
#
###############################################################################
sub global_options {

    # Because this was called in an OO manner the first argument is the
    # class name.
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_detail    = $$rh_arguments{rh_detail};

    my @option_list = ( "help", "report" );

    foreach my $option ( @option_list ) {
        $$rh_detail{-$option}  = Command -> new_command();
        $$rh_detail{-$option}{description} = "-$option [ <command> ]";
    }

    $$rh_detail{-help}{_defaultValue}  = "false";
    $$rh_detail{-report}{_defaultValue} = "false";
    #$$rh_detail{-xhtml}{_defaultValue} = "false";

    $$rh_detail{-help}{_description}  = "Print the help and usage message.";
    $$rh_detail{-report}{_description} = "The no operation flag.";
    #$$rh_detail{-xhtml}{_description} = "Output in XHTML format.";

    # Occassionally everbody has to hardwire something.
    $$rh_detail{-help}{_helpText}  = "Displays the help message for the " .
                                     "command.";
    $$rh_detail{-report}{_helpText} = "Print the actions without executing (" .
                                      "deprecated).\n";
    #$$rh_detail{-xhtml}{_helpText} = "All output will be formatted using " .
    #                                 "XHTML.";

    $$rh_detail{-help}{_flag}  = "yes";
    $$rh_detail{-report}{_flag} = "yes";
    #$$rh_detail{-xhtml}{_flag} = "yes";

    $$rh_detail{-help}{_requiredOption}  = "yes";
    $$rh_detail{-report}{_requiredOption} = "yes";
    #$$rh_detail{-xhtml}{_requiredOption} = "yes";


}   # End of command_details().

###############################################################################
#
# NAME   : find_java_libraries
#
# PURPOSE: A method that tries to find the path to a location.
#
# INPUTS : $$ARG[1]{hint}        - An item with the majority of the path.
#          $$ARG[1]{Oracle_Home} - The installation to be patched.
#          $$ARG[1]{target}      - The point were trying to locate.
#
# OUTPUTS: %return_values  - A reference to a hash data structure containing:
#                            {target_path} that locates the target or an empty
#                            string on failure.
#
# NOTES  : 1. Need to defined directory seperator based on OS.
#
# The rule of thumb is: every time we search for oui/lib, we search for
#   oui/jlib first.  If not found, then switch to oui/lib
#
###############################################################################
sub find_java_libraries {


    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $hint        = $$rh_arguments{hint}        || "";
    my $Oracle_Home = $$rh_arguments{Oracle_Home} || $ENV{ORACLE_HOME};
    my $target      = $$rh_arguments{target}      || "";
    my $orgTarget = $target;

    # Lets add some more obvious paths (in case they weren't passed in).
    my $invoked_location = &File::Basename::dirname($PROGRAM_NAME);
    my $cwd              = &Cwd::cwd();

    $target = &File::Basename::basename( $target );
    # $target = File::Spec -> catfile ( "", $target ); (this creates an extra / 
    #    in front of 'oui'
    
    my ( $leading_part ) = ( $hint =~ m#^(.+)$target# );

    my $jar_file = "OraInstaller.jar";

    my $test_location = File::Spec -> catfile ( $leading_part, $target,
                                                "jlib", $jar_file );
    if ( ! -e $test_location ) {
        $test_location = File::Spec -> catfile ( $leading_part, $target,
                                                "lib", $jar_file );
    }
    
    my $target_path = "";

    # The following is for support of when the install goes wrong and
    # the OUI libraries are left in ORACLE_HOME.
    if ( ! -e $test_location ) {
        $test_location = File::Spec -> catfile ( $Oracle_Home,
                                        "oracle.swd.oui", "jlib", $jar_file );
    }
    if ( ! -e $test_location ) {
        $test_location = File::Spec -> catfile ( $Oracle_Home,
                                        "oracle.swd.oui", "lib", $jar_file );
    }

    # The following is for support of Enterprise Manager. If it's not
    # found in the above areas let try this area.
    if ( ! -e $test_location  ) {
        $test_location = File::Spec -> catfile ( $Oracle_Home, "oui",
                                                 "jlib", $jar_file );
    }
    if ( ! -e $test_location  ) {
        $test_location = File::Spec -> catfile ( $Oracle_Home, "oui",
                                                 "lib", $jar_file );
    }

    if ( ! -e $test_location ) {
	      $test_location = File::Spec -> catfile ( $orgTarget, "jlib",
		                                 $jar_file);
    }

    if ( -e $test_location ) {
       $target_path = &File::Basename::dirname( $test_location );
    }
    
    my %return_values = ();
    $return_values{target_path} = $target_path;

    return ( \%return_values );

}   # End of find_java_libraries().

###############################################################################
#
# NAME   : initial_safety_check
#
# PURPOSE: Return details of the database to so the calling function can
#          determine if it's safe to continue.
#
# INPUTS : $$ARG[1]{fh_log_file}     - The file handle for the log file.
#          $$ARG[1]{general_options} - A binary flag for processing issues.
#          $$ARG[1]{Oracle_Home}     - The area that is to be patched.
#          $$ARG[1]{os_id}           - The numeral id for the OS.
#          $$ARG[1]{patch_id}        - The patch identification string.
#          $$ARG[1]{patch_location}  - The location of the patch directory.
#          $$ARG[1]{rh_file_details}
#                                    - A list of files that are the patches.
#          $$ARG[1]{rh_file_names}   - A list of files that are to be patched.
#          --------{rh_bug_list}     - A list of bugs of the patch that's about
#                                         to be applied
#          $$ARG[1]{rh_executables}  - A list of files that shouldn't have
#                                      any active processes attached.
#          $$ARG[1]{rh_required_items}
#                                    - A list of internal component names that
#                                      need to be present for the patch to be
#                                      applied.
#          $$ARG[1]{rh_OUI_file_names}
#                                    - A list of files that are needed when
#                                      invoking OUI through the JVM.
#
# OUTPUT:
#      $check_results{files_in_use}     = list of files in use
#      $check_results{error_flag}       = "" or error strings
#      $check_results{conflict_patches} = () or list of conflict patches
#      $check_results{skip_components}  = () or list of components to be skipped
#                                         (since they are optional and not installed)
#      $check_results{bug_subset_patches} = () or list of patches whose bugsFixed
#                                         is a sub-set or same set of this patch's
#                                         bugsToFix
#      $check_results{bug_conflict}     = 0 (No bug conflict) or 1
#      $check_results{file_conflict}    = 0 (No file conflict) or 1
#      $check_results{missed_component} = 0 (No req. comp. is missing) or 1
#      $check_results{bug_superset}     = 0 (not a bug-superset case) or 1
#
###############################################################################
sub initial_safety_check {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $fh_log_file       = $$rh_arguments{fh_log_file};
    my $no_inventory_update   = $$rh_arguments{no_inventory_update};
    my $Oracle_Home       = $$rh_arguments{Oracle_Home};
    my $os_id             = $$rh_arguments{os_id};
    my $patch_id          = $$rh_arguments{patch_id};
    my $patch_location    = $$rh_arguments{patch_location};
    my $rh_bug_list       = $$rh_arguments{rh_bug_list};
    my $rh_executables    = $$rh_arguments{rh_executables};
    my $rh_OUI_file_names = $$rh_arguments{rh_OUI_file_names};

    my $error_flag     = "";

    my $path_to_java = $$rh_OUI_file_names{path_to_java};

    # Construct bug string
    my $bugString = "";
    foreach my $bug ( keys %$rh_bug_list ) {
        $bugString .= "$bug ";
    }
    my $bug_conflict = 0;
    my $file_conflict = 0;
    my $missed_component = 0;
    my $bug_superset = 0;

    # Check 1: Active processes on critical files.
    my $active_files  = "";
    
    $active_files = $this_class -> check_if_database_running ( {
                                      Oracle_Home    => $Oracle_Home,
                                      rh_executables => $rh_executables } );
    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                message  => "Checking active processes:\n" .
                                            "$active_files\n" } );
        
    # A small detour is needed: a call to OUI to retrieve:
    # a. RAC nodes ,
    # b. any conflicts with previous one-off patches, and
    # c. required components are available.

    my $class_path = "";
    my $lib_path   = "";
    my $oui_path   = "";
    my $inventory_error = 0;
    my @conflict_patches = ();
    my @skip_components = ();
    my @bug_subset_patches = ();
    my %check_results = ();

    if ( $no_inventory_update ) {
      $check_results{files_in_use}     = "";
      $check_results{error_flag}       = "";
      $check_results{conflict_patches} = ();
      $check_results{skip_components}  = ();
      $check_results{bug_subset_patches} = ();
      $check_results{bug_conflict}     = 0;
      $check_results{file_conflict}    = 0;
      $check_results{missed_component} = 0;
      $check_results{bug_superset}     = 0;
      $check_results{inventory_error}  = 0;

      return ( \%check_results );
    }

    # First set-up the Java class for the inventory read.
    my $rh_java_paths = $this_class -> make_java_paths ( {
                  Oracle_Home       => $Oracle_Home,
                  rh_OUI_file_names => $rh_OUI_file_names } );
    $class_path = $$rh_java_paths{class};
    $lib_path   = $$rh_java_paths{oui_library};
    $oui_path   = $$rh_java_paths{oui_path};

    # Now set-up the call and capture the results. Quoting $file_names to
    # make the $file_names a single argument to the Java program.
    # This may need some tuning.
    my $class_to_run = "opatch/CheckConflict";
    my $program_name = &File::Basename::basename($PROGRAM_NAME);
    my $version_num  = $this_class -> version;

    my $debug = $Command::DEBUG; 
    my $local_node_only_flag = "";
    # At this time we should not call shouldPropagateChange()
    #   because the function accesses some globals that have not
    #   been init.
    if ($Command::LOCAL_NODE_ONLY) {
        $local_node_only_flag = "-Dopatch.local_node_only";
    }
    my $local_node_name_flag = "";
    if ($Command::LOCAL_NODE_NAME_MODE) {
        $local_node_name_flag = "-Dopatch.local_node_name=$Command::LOCAL_NODE_NAME"; 
    }
    
    my $is_shared_flag = "";
    # User wanna turn off CFS detection?
    #    OPATCH_IS_SHARED = true   -> CFS=true, no detect
    #                       false        =false, no detect
    #                       detect       =<detected value>, yes detect
    #                       not set      =false, no detect
    if ($Command::OPATCH_IS_SHARED eq "TRUE") {
        $is_shared_flag = "-Dopatch.is_shared=true";
		    opatchIO -> print_message ( {
               		 message => "No CFS detection, CFS set to true."
              	  });        
    } elsif ( $Command::OPATCH_IS_SHARED eq "FALSE" ) {
        $is_shared_flag = "-Dopatch.is_shared=false";
		    opatchIO -> print_message ( {
               		 message => "No CFS detection, CFS set to false."
              	  });            
    } elsif ( $Command::OPATCH_IS_SHARED eq "DETECT" ) {
        $is_shared_flag = "-Dopatch.is_shared=detect";
		    opatchIO -> print_message ( {
               		 message => "Perform CFS detection, CFS set to detected value."
              	  });        
    } elsif ( $Command::OPATCH_IS_SHARED eq "" ) {
        $is_shared_flag = "";
        # Env. variable OPATCH_IS_SHARED is not set, so ignore it.
    } else {
        $is_shared_flag = "";
		    opatchIO -> print_message ( {
               		 message => "Unknown OPATCH_IS_SHARED value, no CFS detection, CFS set to false."
              	  });        
    } 
    
    my $system_command = join(' ', $path_to_java, $local_node_only_flag,
                         $local_node_name_flag,
                         $is_shared_flag,
                         $Command::inventory_location_ptr,
                         $Command::RETRY_OPTION,
                         $Command::DELAY_OPTION,
                         $debug,
                         $class_path, $class_to_run,
                         $oui_path, qq(").$Oracle_Home.qq("),
                         $program_name, $version_num,
                         $patch_id,
                         qq(").$bugString.qq("),
                         $Command::ACTION_FILE);
    $system_command = $this_class->getDependentPerlCommand({ system_command => $system_command });

    my $status = 0;
    my $rh_installed_data;

    $this_class -> warn_about_retry({ f_handle => $fh_log_file } );
    opatchIO -> print_message ({ f_handle => $fh_log_file,
                                  message  => "\nSystem Command: $system_command"  
                              });
    
    #$sys_call_result = qx/$system_command/;

    opatchIO->print_message( { f_handle => $fh_log_file,
                               message => "Result :\n " } );
    my $sys_call_result = $this_class -> run_cmd_print_live ( { sys_command => $system_command,
                                              level => 1,
					      f_handle => $fh_log_file } );

    close(READ);

    my $status = $this_class -> get_child_error ( {
          CHILD_ERROR     => $CHILD_ERROR
    } );
    chomp $sys_call_result;
    
    my $error = $this_class->catch_and_print_Java_error({
              sys_call_result => $sys_call_result
            });
    if( $error ) {
        opatchIO->print_message({
          message=>
           $sys_call_result
        });
        $error_flag = "Cannot check bug/file conflict and component pre-req.\n";
    }

    # This part of code would print conflict file list to stdout if there
    #   is conflict
    my @result = split ( /\n/, $sys_call_result );
    foreach my $line ( @result ) {

       if ( $line =~ m#FILE_CONFLICT# ) {
          $file_conflict = 1;
       } elsif ( $line =~ m#BUG_CONFLICT# ) {
          $bug_conflict = 1;
       } elsif ( $line =~ m#MISSING_COMPONENT# ) {
          $missed_component = 1;
       } elsif ( $line =~ m#PATCH_ID# ) {
          my @list = split '=', $line;
          my $conflictPatch = $list[1];
          push ( @conflict_patches, $conflictPatch);
          opatchIO->debug({message=>
            "Saving conflict patch $conflictPatch so that we can auto-rollback if needed"
         });
       } elsif ( $line =~ m#SKIPPING_COMPONENT# ) {
          my @list = split '=', $line;
          my $skipComp = $list[1];
          push ( @skip_components, $skipComp);
          opatchIO->debug({message=>
            "OPatch will skip the missing, optional component $skipComp"
         });
       } elsif ( $line =~ m#BUG_SUBSET_PATCH# ) {
          $bug_superset = 1;

          my @list = split '=', $line;
          my $bssPatch = $list[1];
          push ( @bug_subset_patches, $bssPatch);
          opatchIO->debug({message=>
            "Found 1 patch for the bug-superset case"
          });
       } elsif ( $line =~ m#INVENTORY_ERROR# ) {
          $inventory_error = 1;
          opatchIO->debug({message=>
            "This patch will generate an inventory update exception"
          });
       } 
    }

    # If we are not in verbose mode, the following will print out Java output 
    # if there is any conflict.  If we are in verbose mode, the output of the Java
    # program has been printed out earlier regardless of conflict or not
    if ( ($bug_conflict || $file_conflict || $missed_component || $bug_superset) &&
         (! $Command::verbose_mode) ) {
       opatchIO->print_message ( {
                        message => $sys_call_result
       } );
    }

    if ( $missed_component ) { 
       opatchIO->print_message_noverbose ({
              message => $sys_call_result
       } );
    }

    if ( $status ) {
        $error_flag = "Error in executing Java program to check conflict\n";
    }
    # Detour to OUI via Java finished.

    $check_results{files_in_use}       = $active_files;
    $check_results{error_flag}         = $error_flag;
    $check_results{conflict_patches}   = \@conflict_patches;
    $check_results{skip_components}    = \@skip_components;
    $check_results{bug_subset_patches} = \@bug_subset_patches;
    $check_results{bug_conflict}     = $bug_conflict;
    $check_results{file_conflict}    = $file_conflict;
    $check_results{missed_component} = $missed_component;
    $check_results{bug_superset}     = $bug_superset;
    $check_results{inventory_error}  = $inventory_error;

    return ( \%check_results );

}   # End of initial_safety_check();

###############################################################################
#
# NAME   : is_symbolic_link
#
# PURPOSE: Check if the given directory path is a symbolic link or not.
#
# INPUT: $$ARG[1] - directory path to be check
#
# OUTPUT:  0 if it is not a symbolic link
#          1 if it is a symbolic link
#         -1 if it does not exist
#
##############################################################################
sub is_symbolic_link {

    my $this_class = shift @ARG;
    my $directory_to_check = $ARG[0];
    my $ret_value = 0;

    if ( ! -e $directory_to_check ) {
       $ret_value = -1;
    }

    # Try to expand directory_to_check with the link. If the expanded
    # directory is different from the original directory, the original
    # directory is a symbolic link
    chomp $directory_to_check;
    my @directory_bits = split (//, $directory_to_check);
    # components of the directory
    my @directory_components = split (/\//, $directory_to_check);

    # Directory passed to this subroutine to process, could be an
    # absolute path, where it starts with '/', then the processing
    # will be different from a path that is not absolute
    my $absolute_path = "";
    my $resolved_path = "";
    if ($directory_bits[0] eq "\/")
    {
        $absolute_path = "/";
        $resolved_path = "/";
        shift (@directory_components);
    }

    # Take each component at a time and expand it using readlink()
    my $directory = "";
    my $real_path = "";
    foreach $directory (@directory_components)
    {
        $absolute_path .= $directory;
    $! = "";
        $real_path = readlink ( $absolute_path);
        if ( $real_path eq "" ) {
            $real_path = $absolute_path;
            $resolved_path .= $directory . "/";
        }
        else {
            my @real_path_bits = split (//, $real_path);
            if ($real_path_bits[0] eq "\/")
            {
                if ( pop(@real_path_bits) eq "/" ) {
                $resolved_path = $real_path;
                }
                else {
                $resolved_path = $real_path . "/";
                }
                $absolute_path = $real_path;
            }
            else
            {
                $resolved_path .= $real_path . "/";
            }
        }
        $absolute_path .= "/";
    }

    # If the directory passed as argument ends with a '/' we want
    # to end resolved_path with a '/'. And if the directory passed
    # does not end with '/', resolved_path does not end with '/'
    my @resolved_path_bits = split (//, $resolved_path);
    if ($directory_bits[scalar(@directory_bits) - 1] eq "\/") {
        if ($resolved_path_bits[scalar(@resolved_path_bits) - 1] ne "\/") {
            $resolved_path .= "\/";
        }
    }
    else {
        if ($resolved_path_bits[scalar(@resolved_path_bits) - 1] eq "\/") {
            $resolved_path =~ s#\/$##;
        }
    }

    # if resolved_path, matches with $directory_to_check, this is not
    # a symbolic link, otherwise is a symbolic link
    if ( $resolved_path ne $directory_to_check ) {
       $ret_value = 1;
       return $ret_value;
    }

    return $ret_value;
}

###############################################################################
#
# NAME   : resolve_symbolic_link
#
# PURPOSE: convert a symbolic link to the real directory path it's pointing to
#          if the given argument is not a symbolic link, it returns the org.
#          path.
#          if the given argument does not exist or is not a dir., it  returns
#          empty string.
#
# INPUT: $$ARG[1] - symbolic link
#
# OUTPUT: resolved path or empty string
#
###############################################################################
sub resolve_symbolic_link {

    my $this_class = shift @ARG;
    my $directory_to_check = $ARG[0];

    if ( ! -e $directory_to_check || ! -d $directory_to_check )
    {
         return "";
    }

    # First check if this is a symbolic link. Normally this is not
    # required as user calls is_symbolic_link before making a call
    # to resolve_symbolic_link
    my $result = $this_class -> is_symbolic_link ( $directory_to_check );
    if ( $result == 1 )
    { # Is a symbolic link, so try to resolve
        chomp $directory_to_check;
        # Get each element of the directory string into an array
        my @directory_bits = split (//, $directory_to_check);
        # Get component of the directory string into an array
        my @directory_components = split (/[\/ ]+/, $directory_to_check);

        my $absolute_path = "";
       my $resolved_path = "";
        if ($directory_bits[0] eq "\/")
        {
            $absolute_path = "/";
            $resolved_path = "/";
            # if directory_to_check starts with a '/' then the first
            # element of @directory_components is a NULL string.
            # Following command solves the problem
            shift (@directory_components);
        }

        # Now the real processing starts. Take one component at a time
        # and try to expand the link.
        my $directory = "";
        my $real_path = "";
        my @resolved_path_bits = split (//, $resolved_path);
        foreach $directory (@directory_components)
        {
            $absolute_path .= $directory;
            $! = "";
            $real_path = readlink ( $absolute_path);
            if ( $real_path eq "" )
            {
                $real_path = $absolute_path;
                $resolved_path .= $directory . "/";
            }
            else
            {
                my @real_path_bits = split (//, $real_path);
                if ($real_path_bits[0] eq "\/")
                {
                    if ( pop(@real_path_bits) eq "/" )
                    {
                        $resolved_path = $real_path;
                    }
                    else
                    {
                        $resolved_path = $real_path . "/";
                    }
                    $absolute_path = $real_path;
                }
                else
                {
                    $resolved_path .= $real_path . "/";
                }
            }
            $absolute_path .= "/";
        }

        # If the directory passed as argument ends with a '/' we want
        # to end resolved_path with a '/'. And if the directory passed
        # does not end with '/', resolved_path does not end with '/'
        my @resolved_path_bits = split (//, $resolved_path);
        if ($directory_bits[scalar(@directory_bits) - 1] eq "\/")
        {
            if ($resolved_path_bits[scalar(@resolved_path_bits) - 1] ne "\/")
            {
                $resolved_path .= "\/";
            }
        }
        else
        {
            if ($resolved_path_bits[scalar(@resolved_path_bits) - 1] eq "\/")
            {
                $resolved_path =~ s#\/$##;
            }
	 }

        # Newly resolved symbolic link can be a symbolic link inturn.
        # Resolve that case now
        my $new_result = $this_class -> is_symbolic_link ( $resolved_path );
        if ($new_result == 1)
        {
            return ($this_class -> resolve_symbolic_link ($resolved_path));
       }
        else
        {
       return $resolved_path;
        }

    }
    else
    {
       return $directory_to_check;
    }
} # End of subroutine resolve_symbolic_link()

###############################################################################
#
# NAME   : verify_internal_link
#
# PURPOSE: This subroutine verifies if a directory has symbolic link
# internally. For example, for a directory /tmp/a/b/c, directory component
# 'a' can point to d. After that b/c is not a link. This directory qualifies
# as a internal link.
#
# INPUT: $$ARG[1] - symbolic link
#
# OUTPUT:  0 if it is not an INTERNAL symbolic link
#          1 if it is a INTERNAL symbolic link
#         -1 if it does not exist or not a link at all
#
###############################################################################
sub verify_internal_link {

    my $this_class = shift @ARG;
    my $directory_to_check = $ARG[0];
    my $ret_value = 0;

    # Check for existence of the directory_to_check
    if ( ! -e $directory_to_check || ! -d $directory_to_check )
    {
        return -1;
}

    # If it is a symbolic link in the first place
    my $result = $this_class -> is_symbolic_link ($directory_to_check);
    if ( $result == 1 )
    { # Is a symbolic link, so try to resolve
        chomp $directory_to_check;
        # Get each element of the directory string into an array
        my @directory_bits = split (//, $directory_to_check);
        # Get component of the directory string into an array
        my @directory_components = split (/[\/ ]+/, $directory_to_check);

        my $absolute_path = "";
        my $resolved_path = "";
        if ($directory_bits[0] eq "\/")
        {
            $absolute_path = "/";
            $resolved_path = "/";
            # if directory_to_check starts with a '/' then the first
            # element of @directory_components is a NULL string.
            # Following command solves the problem
            shift (@directory_components);
        }

        # Now the real processing starts. Take one component at a time
        # and try to expand the link.
        my $directory = "";
        my $real_path = "";
        my $dir_component_number = 0;
        my @resolved_path_bits = split (//, $resolved_path);
        foreach $directory (@directory_components)
        {
            # Increment the directory component number
            $dir_component_number ++;
            $absolute_path .= $directory;
            $! = "";
            $real_path = readlink ( $absolute_path);
            if ( $real_path eq "" )
            { # This is not a symbolic link
                # If this the last component of the directory and this
                # is not a symbolic link, it shows that this is an
                # internal link
                if ( $dir_component_number == scalar (@directory_components) )
                {
                    return 1; # This is an internal link
                }
                $real_path = $absolute_path;
                $resolved_path .= $directory . "/";
            }
            else
            { # This is symbolic link
                my @real_path_bits = split (//, $real_path);
                if ($real_path_bits[0] eq "\/")
                {
                    if ( pop(@real_path_bits) eq "/" )
                    {
                        $resolved_path = $real_path;
                    }
                    else
                    {
                        $resolved_path = $real_path . "/";
                    }
                    $absolute_path = $real_path;
                }
                else
                {
                    $resolved_path .= $real_path . "/";
                }
            }
            $absolute_path .= "/";
        }

        # Not an internal symbolic link
        return 0;
    }
    else
    {
        return -1;
    }
}
# End Add: BUG 2899335

###############################################################################
#
# NAME   : make_directories_recursively
#
# PURPOSE: A method creates an appropriate class path for calling OUI.
#
# INPUTS : $$ARG[1]{patch_dir} - Where the backup of the patched files go.
#          $$ARG[1]{path}      - A hash of names needed to build a
#                                        usable class path.
#
# OUTPUTS: $error_messages     - A string to be used to return any errors.
#
# NOTES  : 1. OK, this isn't recursive. I decided against the hit of pushing
#             a new call onto the stack and just keep it simple.
#
###############################################################################
sub make_directories_recursively {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $patch_dir = $$rh_arguments{patch_dir};
    my $path      = $$rh_arguments{path};

    my $error_messages = "";

    my $test_path = File::Spec -> catfile ( "test", "this" );
    my ( $dir_separator ) = ( $test_path =~ m#test(.+)this# );

    if ( $OSNAME =~ m#Win32# ) {
        $dir_separator =~ s/\\/\\\\/;
        $patch_dir =~ s/\\/\\\\/g;
    }

    my ( $remaining_path ) = ( $path =~ m#$patch_dir(.*)$# );

    my @path_elements = split /$dir_separator/, $remaining_path;

    my @full_paths = ( );
    push ( @full_paths, $patch_dir );
    foreach my $element ( @path_elements ) {

        # Any empty values?
        next if ( ! $element );

        my $next_directory = File::Spec -> catfile ( $full_paths[$#full_paths],
                                                     $element );
                                                    # $path_elements[$i] );
        push ( @full_paths, $next_directory );
    }

    # Now create the directories. There should only be a few.
    foreach my $directory ( @full_paths ) {

        next if ( ( -e $directory ) || ( $error_messages ) );

        my $created_flag = mkdir ( $directory, 0755 );
        if ( ! $created_flag ) {
            $error_messages = "Couldn't create directory: $directory.\n";
        }
    }

    return ( $error_messages );

}   # End of make_directories_recursively().

###############################################################################
#
# NAME   : make_java_paths
#
# PURPOSE: A method creates an appropriate class path for calling OUI.
#
# INPUTS : $$ARG[1]{Oracle_Home}       - A location of a valid $ORACLE_HOME.
#          $$ARG[1]{rh_OUI_file_names} - A hash of names needed to build a
#                                        usable class path.
#
# OUTPUTS: $class_path                 - A string to be used as the classpath
#                                        argument when calling java.
#
# NOTES  : 1. The keys in rh_OUI_file_names comes from
#             build_required_OUI_filenames().
#
###############################################################################
sub make_java_paths {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home         = $$rh_arguments{Oracle_Home};
    my $rh_OUI_file_names   = $$rh_arguments{rh_OUI_file_names};

    my $liboraInstaller_lib = $$rh_OUI_file_names{liboraInstaller_lib};
    my $required_jar_file   = $$rh_OUI_file_names{required_jar_file};
    my $oui_component_loc   = $$rh_OUI_file_names{oui_component_loc};

    my $class_path          = "";
    my $invoked_location  = &File::Basename::dirname($PROGRAM_NAME);
    
    # $invoked_location points to where OPatch resides, but it might be
    #   just a "." if we 'cd' to OPatch and launch it from there
    
    # PROGRAM_NAME points to OPatch_Location/opatch.pl
    #   but OPatch_Location could also be just a "."
    
    # So we have to 'cd' to $invoked_location, get its absolute path,
    # then 'cd' back
    my $curDir = $this_class->get_cwd();
    chdir $invoked_location;
    my $absolute_OPatch_location = $this_class->get_cwd();
    chdir $curDir;
    
    my $absolute_OPatch_opatchjar_location = 
       $absolute_OPatch_location . "/jlib/opatch.jar";
       
    $absolute_OPatch_opatchjar_location = 
        $this_class->convert_path_separator({ path => $absolute_OPatch_opatchjar_location });
        
    my $Oracle_Base      =  $ENV{ORACLE_BASE} || File::Spec->catfile
                               ( "$Oracle_Home",
                                 "$Command::parent_directory_token",
                                 "$Command::parent_directory_token" );

    my $Oracle_Env_Home  = $ENV{ORACLE_HOME} || "";

    # Can we find the paths for the other jar files?
    my $rh_return_values = $this_class -> find_java_libraries ( {
                                             hint => $liboraInstaller_lib,
                                             Oracle_Home => $Oracle_Home,
                                             target => $oui_component_loc } );


    # $target_path is used (and sent to the Java call) to help locate
    # the shared library liboraInstaller.so (which is wired somewhere
    # into the OUI APIs).
    $required_jar_file = &File::Basename::basename( $required_jar_file );
    my $library_path =  $$rh_return_values{target_path} ;

    if ( ! $library_path ) {

         my $hint = $liboraInstaller_lib;
         my $target = $oui_component_loc;

         my $msg = "ERROR: \n" .
	               "  Problem finding Java libraries\n" .
		       "  Oracle_Home = $Oracle_Home\n" .
		       "  Target = $target\n" .
		       "  Hint = $hint\n" .
		       "  OPatch can't find oui, oui/jlib, \n" .
		       "     oui/lib/$required_jar_file\n" .
                       "\n" .
		       "  Couldn't find required file OraInstaller.jar.\n" .
		       "  This could be due to inventory problem.\n" ;

         opatchIO -> print_message_and_die( {
		       message => $msg,
		       exit_val=> $this_class -> ERROR_CODE_INVENTORY_PROBLEM
	             } );
    }

    my $oui_path = File::Basename::dirname ( $library_path );


    # The classpath needs to find OraInstaller.jar and srvm.jar which should
    # be in the same location. "jlib" is now current. Keeping "Java/class"
    # until rewrite to make sure. Then it can be dropped.
    #
    my $required_OPSM_file = "srvm.jar";

    # OH/oui might not be there, so if there's no OH/oui, we will
    # use the oui_component_loc collected above
    #
    my $xmlPath = "";
    my $sharePath = "";
    my $testPath = File::Spec->catfile
                                    ( "$Oracle_Home", "oui", "jlib",
                                                        "xmlparserv2.jar" );
    # Search for xmlparserv2.jar
    if (! -e $testPath ) {
       $testPath = File::Spec->catfile
                                    ("$Oracle_Home", "oui", "lib",
                                                        "xmlparserv2.jar" );
    }

    if (! -e $testPath ) {
       $testPath = File::Spec->catfile
                                    ("$Oracle_Home", "jlib",
                                                        "xmlparserv2.jar" );
       if ( -e $testPath ) {
          $xmlPath = $testPath;
       } else {
          $testPath = File::Spec->catfile
                                    ($oui_component_loc, "oui", "jlib",
                                                        "xmlparserv2.jar" );
          if (! -e $testPath ) {
            $testPath = File::Spec->catfile
                                    ($oui_component_loc, "jlib",
                                                         "xmlparserv2.jar" );
            if ( -e $testPath ) {
               $xmlPath = $testPath;
            }
          } else {
            $xmlPath = $testPath;
          }
       }
    } else {
       $xmlPath = $testPath;
    }

    # Search for share.jar
    $testPath = File::Spec->catfile("$Oracle_Home", "oui", "jlib",
                                           "share.jar");
    if (! -e $testPath ) {
       $testPath = File::Spec->catfile
                                    ("$Oracle_Home", "oui", "lib",
                                                        "share.jar" );
    }
    if (! -e $testPath ) {
       $testPath = File::Spec->catfile
                                    ("$Oracle_Home", "jlib",
                                                        "share.jar" );
       if ( -e $testPath ) {
          $sharePath = $testPath;
       } else {
          $testPath = File::Spec->catfile
                                    ($oui_component_loc, "oui", "jlib",
                                                        "share.jar" );
          if (! -e $testPath ) {
            $testPath = File::Spec->catfile
                                    ($oui_component_loc, "jlib",
                                                         "share.jar" );
            if ( -e $testPath ) {
               $sharePath = $testPath;
            }
          } else {
            $sharePath = $testPath;
          }
       }
    } else {
       $sharePath = $testPath;
    }
    
    # Build class path
    $class_path = "-classpath " . "\"" .
                     File::Spec->catfile
                                  ( "$library_path", "$required_jar_file" ) .
                     "$Command::path_separator_token" .
                     File::Spec->catfile
                                  ( "$library_path", "$required_OPSM_file" ) .
                     "$Command::path_separator_token" .
                    
                     # absolute path to where OPatch was launched
                     $absolute_OPatch_opatchjar_location .
                     "$Command::path_separator_token" .

                     # this path could be a relative path, since we already
                     # have absolute path to opatch.jar, we can take this out 
		     # File::Spec->catfile
                     #               ( "$invoked_location", "jlib", "opatch.jar") .
                     # "$Command::path_separator_token" .

                     # Needed for Enterprise Manager agent installs.
                     $xmlPath  .
                     "$Command::path_separator_token" .

                     # Needed for Enterprise Manager agent installs too.
                     $sharePath .

                     # Do not add the "." since this is CLASS_PATH 
                     # "$Command::path_separator_token" .
                     # "$Command::current_directory_token" . 
                     
                     "\"" ;

    # Done building class path
    #
    my %return_paths = ();
    $return_paths{class}       = $class_path;
    $return_paths{oui_library} = "\"$library_path\"";
    $return_paths{oui_path}    = "\"$oui_path\"";

    return ( \%return_paths );

}   # End of make_java_paths().

##############################################################################
#
# Check if this Oracle_Home has inventory or not
# Return 1 if it does, 0 if not
#
##############################################################################
sub has_inventory {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home         = $$rh_arguments{Oracle_Home};
    my $rh_OUI_file_names   = $$rh_arguments{rh_OUI_file_names};

    my $inventory_location  = $$rh_OUI_file_names{inventory_location};
    my $liboraInstaller_lib = $$rh_OUI_file_names{liboraInstaller_lib};
    my $path_to_java        = $$rh_OUI_file_names{path_to_java};
    my $path_to_oI_loc      = $$rh_OUI_file_names{path_to_oI_loc};
    my $required_jar_file   = $$rh_OUI_file_names{required_jar_file};
    my $oui_component_loc    = $$rh_OUI_file_names{oui_component_loc};

    my $class_path          = "";
    my $invoked_location  = &File::Basename::dirname($PROGRAM_NAME);

    my $Oracle_Base      =  $ENV{ORACLE_BASE} || File::Spec->catfile
                               ( "$Oracle_Home",
                                 "$Command::parent_directory_token",
                                 "$Command::parent_directory_token" );

    my $Oracle_Env_Home  = $ENV{ORACLE_HOME} || "";

    # Can we find the paths for the other jar files?
    my $rh_return_values = $this_class -> find_java_libraries ( {
                                             hint => $liboraInstaller_lib,
                                             Oracle_Home => $Oracle_Home,
                                             target => $oui_component_loc } );


    # $target_path is used (and sent to the Java call) to help locate
    # the shared library liboraInstaller.so (which is wired somewhere
    # into the OUI APIs).
    $required_jar_file = &File::Basename::basename( $required_jar_file );
    my $library_path =  $$rh_return_values{target_path} ;


    if ( $library_path ) {
       return 1;
    } else {
       return 0;
    }

}

###############################################################################
#
# NAME   : new_command
#
# PURPOSE: A method that sets the default values for a new command.
#
# INPUTS : NONE
#
# OUTPUTS: A reference to a hash data structure containing the default
#          values for commands.
#
# NOTES  : 1. _options is set to being undefined as it will be a hash if
#             there is any data for it later.
#          2. The design specification stated a "_command" item. However
#             since the command structure is a hash that is keyed on the
#             command name this element is redundant and has been removed.
#
###############################################################################
sub new_command {

    my %default_command = ();

    $default_command{_commandSet}  = "no";
    $default_command{_current}     = 0;
    $default_command{_description} = "";
    $default_command{_helpText}    = "";
    $default_command{_last}        = -1;
    $default_command{_options}     = undef;

    return \%default_command;

}   # End new_command().

###############################################################################
#
# NAME   : new_option
#
# PURPOSE: A method that sets the default values for an option.
#
# INPUTS : NONE
#
# OUTPUTS: A reference to a hash data structure containing the default
#          fields for any option.
#
# NOTES  : 1. These values should be overridden by the calling function. This
#             method is used to try and ensure at least each option has these
#             descriptive attributes.
#          2. Other attributes are added by the appropriate method.
#
###############################################################################
sub new_option {

    my %default_option = ();

    $default_option{_description}  = "";
    $default_option{_helpText}     = "";

    return \%default_option;

}   # End of new_option();

###############################################################################
#
# NAME   : number_of_commands
#
# PURPOSE: A method that returns the number of commands and global options.
#
# INPUTS : $$ARG[1]{rh_commands} - A reference to a hash structure that is an
#                                  instantiation of the class Command.
#
# OUTPUTS: A scalar that is also an integer.
#
# NOTES  : 1. Well, it's specified in the design spec.
#
###############################################################################
sub number_of_commands {

    # Because this was called in an OO manner the first argument is the
    # class name.
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_commands  = $$rh_arguments{rh_commands};

    # This is all it needs to do.
    return (scalar  (keys %$rh_commands ));

}   # End of number_of_commands().

###############################################################################
#
# NAME   : option_invPtrLoc
#
# PURPOSE: Allow the central inventory to be located when invPtrLoc has
#          has been used during an installation.
#
# INPUTS : $$ARG[1]{rh_option} - A reference to a hash where the details about
#                                the option are to be stored.
#
# OUTPUTS: NONE
#
# NOTES  : 1. invPtrLoc was supposed to be internal to Oracle to help
#             developers but it escaped. How it was used was a closely
#             held secret until last night. Now it can be used to support
#             interim patches.
#          2. The formatting is used in the help methods.
#
###############################################################################
sub option_invPtrLoc {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_details   = $$rh_arguments{rh_option_detail};

    $$rh_details{_defaultValue} = "false";
    $$rh_details{_description}  = "-invPtrLoc <Path to oraInst.loc>";
    $$rh_details{_flag}         = "yes";
    $$rh_details{_helpText}     = "Used to locate the oraInst.loc file.\n" .
                                  "Needed when the installation used the\n" .
                                  "invPtrLoc flag. This should " .
                                  "\nbe the path to the oraInst.loc file";
    $$rh_details{_type}         = "file";
    $$rh_details{_validityChecks} = [ "read" ];

}   # End of option_invPtrLoc().

##############################################################################
#
# NAME   : option_oh
#
# PURPOSE: Set the Oracle home directory path.
#
# INPUTS : $$ARG[1]{rh_option} - A reference to a hash where the details about
#                                the option is to be stored.
#
# OUTPUTS: NONE
#
# NOTES  : 1. The return values are in hash so the caller will get the new
#             details when this subroutine is finished.
#
###############################################################################
sub option_oh {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_details   = $$rh_arguments{rh_option_detail};

    $$rh_details{_description}    = "-oh <ORACLE_HOME>";
    $$rh_details{_helpText}       = "The directory to use instead of the " .
                                    "default of\n\$ORACLE_HOME.";
    $$rh_details{_required}       = "yes";
    $$rh_details{_type}           = "directory";
    $$rh_details{_validityChecks} = [ "read", "write", "execute" ];

}   # End of option_oh().

##############################################################################
#
# NAME   : process_installed_data
#
# PURPOSE: Organize data from a system call that queries the OUI APIs via
#          Java.
#
# INPUTS : $$ARG[1]{system_data} - The data to process (I hope).
#
# OUTPUTS: %rh_installed_data    - A reference to hash with that groups the
#                                  the data. Keys are:
#           {rh_bug}             - The key is the patch id, the value is a
#                                  sting that is the list of bugs patched by
#                                  the key value.
#           {rh_conflict_list}   - A list of conflicting patches and the files
#                                  that generated the conflict.
#           {ra_one_off_patches} - A list of current one-off patches.
#
# NOTES  : 1. All hardwired. Sections are titled from the OUI call that
#             retrieved the data.
#
###############################################################################
sub process_installed_data {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $system_data  = $$rh_arguments{system_data};

    my $bug_lists       = "BUG LIST ";
    my $conflict_header = "FILE_CONFLICT";
    my $patch_string    = "PATCH ID: ";

    my $count           = 0;
    my $select_string   = "";
    my %bugs            = ();
    my %file_conflicts  = ();
#    my %external        = ();
#    my %internal        = ();
    my @one_off_patches = ();
#    my @rac_nodes       = ();

    # First need to change it from a possibly very long string.
    my @unprocessed_data = split ( "\n", $system_data );

    foreach my $line ( @unprocessed_data ) {

        if ( $line =~ m#^$patch_string# ) {
            $select_string = "";
            my ( $patch_id ) = ( $line =~ m#^$patch_string(.+)$# );
            push ( @one_off_patches, $patch_id);
            next;

        } elsif ( $line =~ m#^$bug_lists# ) {
            $select_string = "";
            my ( $patch_id, $bug_string ) =
                                   ( $line =~ m#^$bug_lists([^:]+):\s+(.+)$# );
            $bugs{$patch_id} = $bug_string;
            next;

        } elsif ( $line =~ m#^$conflict_header# ) {
            $select_string = $conflict_header;
            next;

        }

        # Multi-line processing here.
        if ( $select_string eq $conflict_header ) {
            my ( $patch_id, $file_details ) = ( $line =~ m#^([^:]+):(.+)# );
            push ( @{$file_conflicts{$patch_id}}, $file_details );
        }

    }

    my %rh_installed_data = ();

    $rh_installed_data{rh_bug_list}        = \%bugs;
    $rh_installed_data{rh_conflict_list}   = \%file_conflicts;
    $rh_installed_data{ra_one_off_patches} = \@one_off_patches;

    return ( \%rh_installed_data );


}   # End of process_installed_data().

###############################################################################
#
# NAME   : propagate_patch_to_RAC_nodes
#
# PURPOSE: Propagate the patch from this node to the other nodes in the
#          RAC.
#
# INPUTS : $$ARG[1]{all_nodes}       - A list of the nodes in the RAC.
#          $$ARG[1]{fh_log_file}     - The file handle for the log file.
#          $$ARG[1]{general_options} - A bit pattern flag (new).
#          $$ARG[1]{general_shutdown}- A flag to tell if the database needs
#                                      to be shutdown.
#          $$ARG[1]{local_node}      - The name of the local node.
#          $$ARG[1]{Oracle_Home}     - The area that is to be patched.
#          $$ARG[1]{patch_id}        - The patch identification string.
#          $$ARG[1]{RAC_options}     - A bit pattern flag for RAC (new).
#          $$ARG[1]{rh_file_list}    - The hash that has the details for the
#                                      the make commands included in the data.
#          $$ARG[1]{rh_OUI_file_names}
#                                    - A list of files that are needed when
#                                      invoking OUI through the JVM.
#          $$ARG[1]{shutdown_RAC_flag}
#                                    - A flag to say if the RAC needs to
#                                      be shutdown or if its a rolling
#                                      upgrade.
#
# OUTPUTS: $sys_call_result          - A string with error details on errors
#                                      and users want to quit.  Otherwise,
#                                      return empty string.
#
# NOTES  : 1. This is really just a wrapper to call the appropriate
#             methods to apply the patch. The choice is:
#             a. all nodes down,
#             b. minimum downtime, or
#             c. rolling RAC.
#
#          2. Each of the sub propagate_patch_* will return either error messages
#                or empty string.  If there are errors and users decide to go on,
#                the sub function will suppress errors to return empty string.
#             This returned string will be returned to callers Apply and RollBack
###############################################################################
sub propagate_patch_to_RAC_nodes {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $all_RAC_nodes     = $$rh_arguments{all_nodes};
    my $fh_log_file       = $$rh_arguments{fh_log_file};
    my $general_options   = $$rh_arguments{general_options};
    my $local_RAC_node    = $$rh_arguments{local_node};
    my $Oracle_Home       = $$rh_arguments{Oracle_Home};
    my $patch_id          = $$rh_arguments{patch_id};
    my $patched_RAC_nodes = $$rh_arguments{patched_RAC_nodes};
    my $RAC_options       = $$rh_arguments{RAC_options};
    my $rh_file_list      = $$rh_arguments{rh_file_list};
    my $rh_OUI_file_names = $$rh_arguments{rh_OUI_file_names};
    my $shutdown_flag     = $$rh_arguments{general_shutdown};
    my $shutdown_RAC_flag = $$rh_arguments{shutdown_RAC_flag};

    my $RAC_propagation_errors = "";

    # The next line gets around warning errors. It also makes it easier
    # to read.
    my $downtime_value = ( $this_class -> minimize_downtime );
    my $downtime_flag = $RAC_options & ( $downtime_value );

    opatchIO->debug({message=>
        "propagate_patch_to_RAC_nodes():\n" .
        " all_RAC_nodes= \"$all_RAC_nodes\"\n" .
        " local_RAC_node= \"$local_RAC_node\"\n" .
        " patched_RAC_nodes= \"$patched_RAC_nodes\"\n" .
        " downtime_value = $downtime_value\n" .
        " downtime_flag  = $downtime_flag\n"
    });

    # Simple case first: just drop the RAC and patch it. Downtime not
    # important.
    #if ( ( $downtime_flag != $downtime_value ) &&
    #     ( $shutdown_RAC_flag ) ) {
    
    if($Command::ROLLING_PATCH == 0 && $Command::MINIMIZE_DOWNTIME_OPTION == 0) {
        $RAC_propagation_errors =
                          $this_class -> propagate_patch_all_nodes ( {
                                 all_nodes         => $all_RAC_nodes,
                                 fh_log_file       => $fh_log_file,
                                 local_node        => $local_RAC_node,
                                 Oracle_Home       => $Oracle_Home,
                                 patch_id          => $patch_id,
                                 rh_file_list      => $rh_file_list,
                                 rh_OUI_file_names => $rh_OUI_file_names } );

    # Next: not rolling RAC but minimum downtime.
    #} elsif ( ( $downtime_flag  == $downtime_value ) &&
    #          ( $shutdown_RAC_flag ) ) {

    } elsif ($Command::MINIMIZE_DOWNTIME_OPTION) {
        $RAC_propagation_errors =
                          $this_class -> propagate_patch_minimum_downtime ( {
                                 all_nodes         => $all_RAC_nodes,
                                 fh_log_file       => $fh_log_file,
                                 local_node        => $local_RAC_node,
                                 general_options   => $general_options,
                                 general_shutdown  => $shutdown_flag,
                                 Oracle_Home       => $Oracle_Home,
                                 patch_id          => $patch_id,
                                 RAC_options       => $RAC_options,
                                 rh_file_list      => $rh_file_list,
                                 rh_OUI_file_names => $rh_OUI_file_names } );

    # Rolling RAC.
    # } elsif ( ! $shutdown_RAC_flag ) {
    
    } elsif ($Command::ROLLING_PATCH) {

        $RAC_propagation_errors =
                          $this_class -> propagate_patch_rolling ( {
                                 all_nodes         => $all_RAC_nodes,
                                 fh_log_file       => $fh_log_file,
                                 local_node        => $local_RAC_node,
                                 general_options   => $general_options,
                                 general_shutdown  => $shutdown_flag,
                                 Oracle_Home       => $Oracle_Home,
                                 patch_id          => $patch_id,
                                 patched_RAC_nodes => $patched_RAC_nodes,
                                 RAC_options       => $RAC_options,
                                 rh_file_list      => $rh_file_list,
                                 rh_OUI_file_names => $rh_OUI_file_names } );
    }

    return ( $RAC_propagation_errors );

}   # End of propagate_patch_to_RAC_nodes().

###############################################################################
#
# NAME   : propagate_patch_all_nodes
#
# PURPOSE: Propagate the patch from this node to the other nodes in the
#          RAC.
#
# INPUTS : $$ARG[1]{all_nodes}       - A list of the nodes in the RAC.
#          $$ARG[1]{fh_log_file}     - The file handle for the log file.
#          $$ARG[1]{local_node}      - The name of the local node.
#          $$ARG[1]{Oracle_Home}     - The area that is to be patched.
#          $$ARG[1]{patch_id}        - The patch identification string.
#          $$ARG[1]{rh_file_list}    - The hash that has the details for the
#                                      the make commands included in the data.
#          $$ARG[1]{rh_OUI_file_names}
#                                    - A list of files that are needed when
#                                      invoking OUI through the JVM.
#          $$ARG[1]{general_shutdown}- A flag to tell if the database needs
#                                      to be shutdown.
#          $$ARG[1]{shutdown_RAC_flag}
#                                    - A flag to say if the RAC needs to
#                                      be shutdown or if its a rolling
#                                      upgrade.
#
# OUTPUTS: $return_string            - A string with any error details.
#
# NOTES  :  1. This is All-Node case, will call PropagatePatchToCluster.java
#
#           2. This will need more logic when the APIs to allow rolling
#             upgrades become available. Instead of copying files to all
#             all nodes it'll be neccessary to copy it to the inactive nodes
#             first then bring down an active node, patch it, and bring it
#             back up.
#             Currently this code works for a clustered file system or a
#             non-rolling upgrade. In both cases all nodes should be inactive.
#
###############################################################################
sub propagate_patch_all_nodes {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $all_nodes         = $$rh_arguments{all_nodes};
    my $fh_log_file       = $$rh_arguments{fh_log_file};
    my $local_node        = $$rh_arguments{local_node};
    my $Oracle_Home       = $$rh_arguments{Oracle_Home};
    my $patch_id          = $$rh_arguments{patch_id};
    my $rh_file_list      = $$rh_arguments{rh_file_list};
    my $rh_OUI_file_names = $$rh_arguments{rh_OUI_file_names};

    my $return_string = "";
    my $propagation_error = 0;

    opatchIO->debug({message=>
	     "propagate_patch_all_nodes(): \n" .
	     "  all_nodes = \"$all_nodes\"\n" .
	     "  local_node= \"$local_node\"\n"
    });
    # First set-up the Java class for the inventory read.
    my $rh_java_paths = $this_class -> make_java_paths ( {
                                Oracle_Home       => $Oracle_Home,
                                rh_OUI_file_names => $rh_OUI_file_names } );

    my $path_to_java = $$rh_OUI_file_names{path_to_java};
    my $class_path   = $$rh_java_paths{class};

    # A little hardcoding, sorry. But srvm.jar is needed for the RAC APIs.
    my $class_path_extra = "$Command::path_separator_token" .
                             File::Spec -> catfile ( $Oracle_Home, "jlib", "srvm.jar" );

    if ( $class_path =~ m#"$# ) {
        ( $class_path ) = ( $class_path =~ m#^(.+)"$# );
        $class_path .= $class_path_extra . "\"";
    } else {
        $class_path .= $class_path_extra;
    }

    my $list_of_files_to_copy = "";
    foreach my $name ( keys %$rh_file_list ) {
        next if ( ! $name );
        $list_of_files_to_copy .= $name . "\n";
    }
    # And which directory is to be copied over? The patch storage area.
    my $patch_dir = File::Spec -> catfile ( $Oracle_Home, ".patch_storage",
                                                                $patch_id ) ;

    # Construct the file containing a list of filenames to propagate
    my $fileListName = File::Spec -> catfile ( "$patch_dir" ,
                                              "$Command::FILES_TO_PROPAGATE" );
    my $dirListName  = File::Spec -> catfile ( "$patch_dir" ,
                                              "$Command::DIRS_TO_MKDIR" );
                                                  
    opatchIO->print_message_noverbose({ message => 
                        "Creating file to hold list of files to propagate: " .
                        "\"$fileListName\"" });
    if( -e $fileListName ) {
      opatchIO->print_message
            ({  f_handle => $fh_log_file, 
                message => "  removing old file to write new content to it: " .
                                 "\"$fileListName\"" });
      unlink ( $fileListName );
    }

    local *OUTPUT_FILE;
    open ( OUTPUT_FILE, ">$fileListName" ) or do {
                opatchIO -> print_message ( {
                  f_handle => $fh_log_file,
                  message => "ERROR: Cannot open file to write: " .
                             "\"$fileListName\"\n"
                } ); 
                $return_string = 
                    "ERROR: cannot create file list to propagate to node";
                return $return_string;
    };
    # Write to it list of files to be propagated, already separated by "\n"
    print OUTPUT_FILE ("$list_of_files_to_copy");
    # Then close the file
    close OUTPUT_FILE;
    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message  =>
            "List of files to be propagated: $list_of_files_to_copy" } );
    
    # Remove the local node from the list of machines.
    $all_nodes =~ s#$local_node## ;
    
    opatchIO->debug({message=>
	     "  After removing local_node from all_nodes,\n" .
	     "     all_nodes is \"$all_nodes\"\n"
    });

    my $class_to_run = "opatch/PropagatePatchToCluster";
    my $debug = $Command::DEBUG;

    my $oui_path = $$rh_java_paths{oui_path};
    my $system_command  = join(' ', $path_to_java,
                        $class_path, 
                        $debug,
                        $class_to_run,
                        qq(").$Oracle_Home.qq("), 
                        qq(").$all_nodes.qq("), $patch_dir,
                        qq(").$fileListName.qq("),
                        qq(").$dirListName.qq("),
                        qq(").$oui_path.qq("));

    $system_command = $this_class->getDependentPerlCommand({ system_command => $system_command });
    
    opatchIO->print_message_noverbose ( {
      message => "Propagating the patch..."
    } );

    opatchIO -> print_message ({ f_handle => $fh_log_file,
                                  message  => "\nSystem Command: $system_command"  
                              });
    
    #$sys_call_result = qx/$system_command/;

    opatchIO->print_message( { f_handle => $fh_log_file,
                               message  => "\nResult:\n" } );
    my $sys_call_result = $this_class -> run_cmd_print_live ( { sys_command => $system_command,
                                              level => 1,
                                              f_handle => $fh_log_file } );

    my $status = $this_class -> get_child_error ( {
              CHILD_ERROR     => $CHILD_ERROR
    } );
    chomp $sys_call_result;
      

    # Use $status instead of Java output to check for errors
    my $message = "";
    if ( $status ) {
        $message = "There were problems propagating this patch " .
                       "to the other nodes:\n$sys_call_result";
    } else {
        $message = "Interim patch $patch_id has been " .
                   "propagated to the other nodes.";
    }
    opatchIO -> print_message_noverbose ( { f_handle => $fh_log_file,
                                  message  => $message } );

    my $java_error = $this_class->is_there_Java_error({
                  sys_call_result => $sys_call_result
    });
    
    if( $status || $java_error) {
      $propagation_error = 1;
    } else {
      $propagation_error = 0;
    }

    # If there is error in file propagation, check if users want to stop
    if ( $propagation_error ) {
          my $question = "OPatch encounters the following issues during file propagation " .
                         "to other nodes:\n" .
                         "$sys_call_result" . "\n\n" .

                         "If the error is due to file propagation error, you can " . 
                         "manually copy the files to the remote node, then continue " .
                         "with patching.  The complete list of files are in the file " .
                         "\"$fileListName\"\n" .

                         "Do you want to continue?";

          my $answer = opatchIO->check_to_stop_processing({
                                    message => $question
                                 });
          if ($answer eq "") {
             my $message = "Ignore file propagation issues and continue...\n";
             $propagation_error = 0;
             opatchIO->print_message ({ f_handle=>$fh_log_file,
                                        message =>$message });
             $return_string = "";
          } else {
             $return_string = $sys_call_result;
          }
    }
    
    # Now run make on the remote nodes.
    if ( $propagation_error == 0 ) {
        # Make can lie. Currently ignoring the return value until
        # more research is done. Customer can run make from the
        # file left in the patch backup area if needed. Sorry.
	      opatchIO->debug({message=>
		        "  calling run_make_on_remote_nodes()\n"
	      });
        $sys_call_result = $this_class -> run_make_on_remote_nodes ( {
                                        all_nodes       => $all_nodes,
                                        fh_log_file     => $fh_log_file,
                                        local_node      => $local_node,
                                        Oracle_Home     => $Oracle_Home,
                                        patch_id        => $patch_id } );
    }

    return ( $return_string );

}   # End of propagate_patch_all_nodes().

###############################################################################
#
# NAME   : propagate_patch_minimum_downtime
#
# PURPOSE: Propagate the patch from this node to the other nodes in the
#          RAC, one at a time.
#
# INPUTS : $$ARG[1]{all_nodes}       - A list of the nodes in the RAC.
#          $$ARG[1]{fh_log_file}     - The file handle for the log file.
#          $$ARG[1]{general_shutdown}- A flag to tell if the database needs
#                                      to be shutdown.
#          $$ARG[1]{local_node}      - The name of the local node.
#          $$ARG[1]{Oracle_Home}     - The area that is to be patched.
#          $$ARG[1]{patch_id}        - The patch identification string.
#          $$ARG[1]{rh_file_list}    - The hash that has the details for the
#                                      the make commands included in the data.
#          $$ARG[1]{rh_OUI_file_names}
#                                    - A list of files that are needed when
#                                      invoking OUI through the JVM.
#          $$ARG[1]{shutdown_RAC_flag}
#                                    - A flag to say if the RAC needs to
#                                      be shutdown or if its a rolling
#                                      upgrade.
#
# OUTPUTS: $results_string           - A string with any error details or if
#                                      user quits.  Otherwise, return empty
#                                      string.
#
# NOTES:   Min. DownTime case, will call PropagatePatchToNode.java
#          If there file propagation or dir. creation error, report to users
#             and ask if they want to continue
#
###############################################################################
sub propagate_patch_minimum_downtime {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $all_nodes         = $$rh_arguments{all_nodes};
    my $fh_log_file       = $$rh_arguments{fh_log_file};
    my $general_options   = $$rh_arguments{general_options};
    my $general_shutdown  = $$rh_arguments{general_shutdown};
    my $local_node        = $$rh_arguments{local_node};
    my $Oracle_Home       = $$rh_arguments{Oracle_Home};
    my $patch_id          = $$rh_arguments{patch_id};
    my $rh_file_list      = $$rh_arguments{rh_file_list};
    my $rh_OUI_file_names = $$rh_arguments{rh_OUI_file_names};

    my $failed_node_list  = "";
    my $error_flag  = "";
    my $return_string = "";
    
    opatchIO->debug({message=>
		    "propagate_patch_minimum_downtime():\n" .
		    "  all_nodes = \"$all_nodes\"\n" .
		    "  local_node= \"$local_node\"\n"
	    });
    # First set-up the Java class for the inventory read.
    my $rh_java_paths = $this_class -> make_java_paths ( {
                                Oracle_Home       => $Oracle_Home,
                                rh_OUI_file_names => $rh_OUI_file_names } );

    my $path_to_java = $$rh_OUI_file_names{path_to_java};
    my $class_path   = $$rh_java_paths{class};

    # Get the list of nodes to drop from the user.
    my $message = "You have specified minimum downtime for patching. \n" .
                  "This means patching a sub-set of nodes before stopping " .
                  "and patching the remaining nodes. ";

    opatchIO -> print_message_noverbose ( { f_handle => $fh_log_file,
                                  message  => $message } );

    # A little hardcoding, sorry. But srvm.jar is needed for the RAC APIs.
    my $class_path_extra = "$Command::path_separator_token" . 
                            File::Spec -> catfile ( $Oracle_Home, "jlib", "srvm.jar" );

    if ( $class_path =~ m#"$# ) {
        ( $class_path ) = ( $class_path =~ m#^(.+)"$# );
        $class_path .= $class_path_extra . "\"";
    } else {
        $class_path .= $class_path_extra;
    }

    my $list_of_files_to_copy = "";
    foreach my $name ( keys %$rh_file_list ) {
        next if ( ! $name );
        $list_of_files_to_copy .= $name . "\n";
    }

    # Remove the local node from the list of machines.
    $all_nodes =~ s#$local_node## ;
    
    #
    # BUG: replacing space with \n causes the Java program to fail with arguments
    #
    # $all_nodes =~ s# #\n#g ;
    
    opatchIO->debug({message=>
	     "  After removing local_node from all_nodes,\n" .
	     "     all_nodes is \"$all_nodes\"\n"
    });

    # And which directory is to be copied over? The patch storage area.
    my $patch_dir = File::Spec -> catfile ( $Oracle_Home, ".patch_storage",
                                                                $patch_id ) ;

    # Construct the file containing a list of filenames to propagate
    my $fileListName = File::Spec -> catfile ( "$patch_dir" ,
                                              "$Command::FILES_TO_PROPAGATE" );
    my $dirListName  = File::Spec -> catfile ( "$patch_dir" ,
                                              "$Command::DIRS_TO_MKDIR" );

                                                  
    opatchIO->print_message_noverbose({ 
            message => "Creating file to hold list of files to propagate: " .
                                 "\"$fileListName\"" });
    if( -e $fileListName ) {
      opatchIO->print_message({
            f_handle => $fh_log_file, 
            message => "  removing the old file to write new content to it: " .
                                 "\"$fileListName\"" });
      unlink ( $fileListName );
    }
    
    local *OUTPUT_FILE;
    open ( OUTPUT_FILE, ">$fileListName" ) or do {
                opatchIO -> print_message ( {
                  f_handle => $fh_log_file,
                  message => "ERROR: Cannot open file to write: \"$fileListName\"\n"
                } ); 
                $return_string = "ERROR: cannot create file list to propagate to node";
                return $return_string;
    };
    # Write to it list of files to be propagated, already separated by "\n"
    print OUTPUT_FILE ("$list_of_files_to_copy");
    # Then close the file
    close OUTPUT_FILE;
    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message  =>
    "List of files to be propagated: $list_of_files_to_copy" } );
    
    
    my $class_to_run = "opatch/PropagatePatchToNode";
    my $debug = $Command::DEBUG;

    my $oui_path = $$rh_java_paths{oui_path};
    my $system_command  = join(' ', $path_to_java,  
                        $class_path, 
                        $debug,
                        $class_to_run,
                        qq(").$Oracle_Home.qq("));

    my $nodes_to_patch_first = "";
    my $okay_to_continue = "N";
    
    #
    # Keep prompting users for the 1st set 
    #
    while ( $okay_to_continue eq "N" ) {

      $message =
        "The nodes left to update are:\n" .
        "\"$all_nodes\"\n" .
        "Please enter the next node(s) to be patched on one line, separated by space.\n\n" .
        "NODE LIST: $nodes_to_patch_first";

       opatchIO->print_message_noverbose( {message => $message} );

        # Flush the stdout first
        select(STDOUT);
        $|=1;

        # Read a list of nodes to patch from users
        $nodes_to_patch_first .=  " " . <STDIN>;
        chomp $nodes_to_patch_first;

        # TurnOff the autoflush.
        $|=0;

        # Need to remove duplicates?

        $message = "\n\nThe nodes to patch first are: \n" .
                   "$nodes_to_patch_first\n" .
                   "Is this list correct?";

        $okay_to_continue = opatchIO -> check_to_stop_processing ( {
                                                      message => $message } );

        if ( $okay_to_continue =~ m#^$# ) { 
          $okay_to_continue = "Y"; 
        }
    }

    #  Assert: now users have given us the 1st set to patch
    my $nodes_to_patch_last = $all_nodes;

    # Now drop each node and patch it before moving onto the next node
    # for the initial list of nodes.
    my @nodes_to_patch = split ( " ", $nodes_to_patch_first );
    my $nodes_with_problems = "";
    my $patched_nodes = "";
    
    #
    # Loop thru each node in the 1st set
    #
    while ( $nodes_to_patch[0] ne "" ) {

        my $node_being_patched = shift @nodes_to_patch;

        $nodes_to_patch_last =~ s/[ ]?$node_being_patched[ ]?//;

        # Use RaiseOrLowerRACNode if I can get the java code working in time.
        # If not go with the manual message and get the automated version
        # working later.

        $message =
          "\n" .
          "Please shut down Oracle instances on node(s):\n" .
          "\"$node_being_patched\"\n" .
            "running out of ORACLE_HOME\n" .
          "(Oracle Home = $Oracle_Home)\n" .
          "Is it ready for updating (are the instances down)?";
        $okay_to_continue = opatchIO -> check_to_stop_processing ( {
                                                      message => $message } );

        if ( $okay_to_continue =~ m#^$#i ) { 
          $okay_to_continue = "Y"; 
        }

        # Users say no to 1st set
        if ( $okay_to_continue eq "N" ) { 
          $message = 
                     "Un-patched nodes are: \n" .
                     "\"$all_nodes\"\n";
          return $message;          
        }
        
        if ( $okay_to_continue ) {

            $error_flag= 0;

            # Propagate changes to this node
            my $patch_command = $system_command .
                                " $node_being_patched $patch_dir " .
                                "\"$fileListName\"" . " " .
                                "\"$dirListName\""  . " " .
                                "\"$oui_path\"";

            $patch_command = 
                $this_class->getDependentPerlCommand({ system_command => $patch_command });

            opatchIO->print_message_noverbose ( {
              message => "Propagating the patch..."
            } );
            
            #my $sys_call_result = qx/$patch_command/;
            opatchIO -> print_message ( { f_handle => $fh_log_file,
                                          message  => "System Command:\n\t" .
                                                      $patch_command .
                                                      "\nResult:\n" } );
          

           my $sys_call_result = $this_class -> run_cmd_print_live ( { sys_command => $patch_command,
             		                                level => 1,
                        		                f_handle => $fh_log_file } );

            chomp $sys_call_result;

            my $status = $this_class -> get_child_error ( {
              CHILD_ERROR     => $CHILD_ERROR
            } );            

            my $message = "";
            my $propagation_error = 0;
    
            my $java_error = $this_class->is_there_Java_error({
                  sys_call_result => $sys_call_result
            });
    
            if( $status || $java_error) {
              $propagation_error = 1;
            } else {
              $propagation_error = 0;
            }

            #
            # If there is error in file propagation, check if users want to stop
            # If users say 'quit', return the error string
            #
            if ( $propagation_error ) {
                  $failed_node_list .=  $node_being_patched . " ";
                  $error_flag++;
                  my $question = 
                    "OPatch encounters the following issues during file propagation to " .
                    "$node_being_patched:\n" .
                   "$sys_call_result" . "\n\n" .

                   "If the error is due to file propagation error, you can " .
                   "manually copy the files to the remote node, then continue " .
                   "with patching.  The complete list of files are in the file " .
                   "\"$fileListName\"\n" . 

                   "Do you want to continue?";

                  my $answer = opatchIO->check_to_stop_processing({
                                            message => $question
                                         });
                  if ($answer eq "") {
                     my $message = "Ignore file propagation issues and continue...\n";
                     $propagation_error = 0;
                     opatchIO->print_message ({ f_handle=>$fh_log_file,
                                                message =>$message });
                     $return_string = "";
                  } else {
                     $return_string = $sys_call_result;
                     return $return_string;
                  }
            
            } else {
            # No propagation error
            #
                $patched_nodes .= "$node_being_patched ";
                $message = "Files for interim patch $patch_id have been " .
                           "propagated to $node_being_patched.\n"; 
                opatchIO -> print_message_noverbose ( { f_handle => $fh_log_file,
                                          message  => $message } );
            }


            # Now run make on the remote nodes.
            if ( $propagation_error == 0 ) {
                # Make can lie. Currently ignoring the return value until
                # more research is done. Customer can run make from the
                # file left in the patch backup area if needed. Sorry.
                opatchIO->debug({message=>
                  "calling run_make_on_remote_nodes()\n"
                });
                $sys_call_result = $this_class -> run_make_on_remote_nodes ( {
                                        all_nodes       => $node_being_patched,
                                        fh_log_file     => $fh_log_file,
                                        local_node      => $local_node,
                                        Oracle_Home     => $Oracle_Home,
                                        patch_id        => $patch_id } );
            }
        } # if users say system is ready to patch


        # Users say 'no, system not ready'
        if ( ! $okay_to_continue ) {
            $message = "Do you want to retry patching node " .
                       "$node_being_patched?";
            my $reply = opatchIO -> check_to_stop_processing ( {
                                                   message => $message } );
            if ( $reply eq "N" ) {
                $failed_node_list  =  $node_being_patched;
            } else {
                unshift @nodes_to_patch, $node_being_patched;
            }
        }
    }

    chomp $nodes_to_patch_last;
    @nodes_to_patch = split ( " ", $nodes_to_patch_last );

    # 1st set has been patched.  Ask users to shut down 2nd set
    #
    my $response = "N";
    
    while ( ( $response ne "" ) && ( $nodes_to_patch[0] ne "" ) ) {
        $message =
          "Please shut down Oracle instances on node(s):\n" .
          "\"$nodes_to_patch_last\"\n" .
            "running out of ORACLE_HOME\n" .
          "(Oracle Home = $Oracle_Home)\n" .
          "Is it ready for updating (are the instances down)?";

        $response = opatchIO -> check_to_stop_processing ( {
                                                     message => $message } );
        # if users say 'no'
        if ( $response ne "" ) {
          $message = 
                     "Un-patched nodes are: \n" .
                     "\"$nodes_to_patch_last\"\n";
          return $message;
        }
    }

    # 1st set has been patched, 2nd set has been shut down, now ask
    # users to bring up instances on 1st set
    
    $response = "N";
    while ( ( $response ne "" ) && ( $nodes_to_patch[0] ne "" ) ) {
        $message = "\n" .
	           "Now all the instances are down you can re-start " .
             "Oracle instances on nodes that's been patched.\n" .
             "Patched nodes are: \"$patched_nodes\"\n" .
             "Do you want to continue patching?";

        $response = opatchIO -> check_to_stop_processing ( {
                                                     message => $message } );
                                                     
        # if users say 'no'
        if ( $response ne "" ) {
          $message = 
                     "Un-patched nodes are: \n" .
                     "\"$nodes_to_patch_last\"\n";
          return $message;
        }
    }

    # Now loop thru each node in the remaining list of nodes to patch
    my $success_nodes = "";

    while ( $nodes_to_patch[0] ne "" ) {

        my $node_being_patched = shift @nodes_to_patch;

        # Patch the files on $node_being_patched.
        my $patch_command = $system_command .
                            " $node_being_patched $patch_dir " .
                            "\"$fileListName\"" . " " .
                            "\"$dirListName\"";
                            

        $patch_command = 
           $this_class->getDependentPerlCommand({ system_command => $patch_command });

        #my $sys_call_result = qx/$patch_command/;
        opatchIO -> print_message ( { f_handle => $fh_log_file,
                                      message  => "System Command:\n\t" .
                                                  $patch_command .
                                                  "\nResult:\n" } );


        my $sys_call_result = $this_class -> run_cmd_print_live ( { sys_command => $patch_command,
           	                                   level => 1,
                	                           f_handle => $fh_log_file } );

        chomp $sys_call_result;

        my $status = $this_class -> get_child_error ( {
              CHILD_ERROR     => $CHILD_ERROR
        } );

        my $propagation_error = 0;
        my $java_error = $this_class->is_there_Java_error({
                  sys_call_result => $sys_call_result
        });
    
        if( $status || $java_error) {
          $propagation_error = 1;
        } else {
          $propagation_error = 0;
        }

        # If there is error in file propagation, check if users want to stop
        if ( $propagation_error ) {
            $error_flag++;
            $failed_node_list .=  $node_being_patched . " ";
              my $question = 
                "OPatch encounters the following issues during file propagation to " .
                "$node_being_patched:\n" .
                "$sys_call_result" . "\n" .
                "Failed nodes = $failed_node_list\n\n" .

                "If the error is due to file propagation error, you can " . 
                "manually copy the files to the remote node, then continue " .
                "with patching.  The complete list of files are in the file " .
                "\"$fileListName\"\n" .

                "Do you want to continue?";

              my $answer = opatchIO->check_to_stop_processing({
                                        message => $question
                                     });
              if ($answer eq "") {
                 my $message = "Ignore file propagation issues and continue...\n";
                 $propagation_error = 0;
                 opatchIO->print_message ({ f_handle=>$fh_log_file,
                                            message =>$message });
                 $return_string = "";
              } else {
                 $return_string = $sys_call_result;
                 return $return_string;
              }
        } else {
            $patched_nodes .= "$node_being_patched ";
            $success_nodes .= "$node_being_patched ";
            my $message = "Files for interim patch $patch_id have been " .
                       "propagated to $node_being_patched.\n";
            opatchIO -> print_message_noverbose ( { f_handle => $fh_log_file,
                                      message  => $message } );
        }
    
        # Now run make on the remote nodes.
        if ( $propagation_error == 0 ) {
            # Make can lie. Currently ignoring the return value until
            # more research is done. Customer can run make from the
            # file left in the patch backup area if needed. Sorry.
            $sys_call_result = $this_class -> run_make_on_remote_nodes ( {
                                    all_nodes       => $node_being_patched,
                                    fh_log_file     => $fh_log_file,
                                    local_node      => $local_node,
                                    Oracle_Home     => $Oracle_Home,
                                    patch_id        => $patch_id } );
        }

        # Need to add retry code here.
    }

    if ( $success_nodes ) {
        $message = "NODES: $success_nodes\n" .
                   "have been successfully patched and can now be restarted.";
        opatchIO -> print_message ( { f_handle => $fh_log_file,
                                      message  => $message } );
    }

    return ( $return_string );

}   # End of propagate_patch_minimum_downtime().

###############################################################################
#
# NAME   : propagate_patch_rolling
#
# PURPOSE: Propagate the patch from this node to the other nodes in the
#          RAC, one at a time.
#
# INPUTS : $$ARG[1]{all_nodes}       - A list of the nodes in the RAC.
#          $$ARG[1]{fh_log_file}     - The file handle for the log file.
#          $$ARG[1]{general_shutdown}- A flag to tell if the database needs
#                                      to be shutdown.
#          $$ARG[1]{local_node}      - The name of the local node.
#          $$ARG[1]{Oracle_Home}     - The area that is to be patched.
#          $$ARG[1]{patch_id}        - The patch identification string.
#          $$ARG[1]{patched_RAC_nodes} - The nodes already patched.
#          $$ARG[1]{rh_file_list}    - The hash that has the details for the
#                                      the make commands included in the data.
#          $$ARG[1]{rh_OUI_file_names}
#                                    - A list of files that are needed when
#                                      invoking OUI through the JVM.
#          $$ARG[1]{shutdown_RAC_flag}
#                                    - A flag to say if the RAC needs to
#                                      be shutdown or if its a rolling
#                                      upgrade.
#
# OUTPUTS: $results_string           - A string with any error details.
#
# NOTES: 
#         1. Rolling Patch Case, will call PropagatePatchToNode.java
#
#         2. A big hack here. The need for RAC support has been added to
#           the original specification. So the locking mechanism is a
#           bit primitive. Until the code is rewritten it means the local
#           node will always be repatched. This is a waste of time but
#           currently it can't be avoided without breaking the idempotency
#           of the patching action.
#
###############################################################################
sub propagate_patch_rolling {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $all_nodes         = $$rh_arguments{all_nodes};
    my $fh_log_file       = $$rh_arguments{fh_log_file};
    my $general_options   = $$rh_arguments{general_options};
    my $general_shutdown  = $$rh_arguments{general_shutdown};
    my $local_node        = $$rh_arguments{local_node};
    my $Oracle_Home       = $$rh_arguments{Oracle_Home};
    my $patch_id          = $$rh_arguments{patch_id};
    my $patched_RAC_nodes = $$rh_arguments{patched_RAC_nodes};
    my $rh_file_list      = $$rh_arguments{rh_file_list};
    my $rh_OUI_file_names = $$rh_arguments{rh_OUI_file_names};

    my $error_flag  = "";
    my $finished_flag  = 0;
    my $failed_node_list  = "";
    my $previously_patched_list  = "";
    my $return_string = "";
    my $update_inventory_flag  = "";

    my $verb = "apply";
    if ( $this_class eq "RollBack" ) {
        $verb = "rollback";
    }
                                                  
    $patched_RAC_nodes =~ s/Not Applicable//;
    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message  =>
                                        "Processing rolling patch" } );

    opatchIO->debug({message=>
       "propagate_patch_rolling():\n" .
       "  all_nodes = \"$all_nodes\"\n" .
       "  local_node= \"$local_node\"\n" .
       "  patched_RAC_nodes = \"$patched_RAC_nodes\"\n"
    });

    # Now find the list of nodes left to be patched.
    my $unpatched_node_list = $all_nodes;
    my @patched_nodes = split ( " ", $patched_RAC_nodes );
    if ( $patched_RAC_nodes !~ m#$local_node# ) {
        push ( @patched_nodes, $local_node );
        $patched_RAC_nodes .= " $local_node ";
    }

    foreach my $patched_node ( @patched_nodes ) {
        next if ( $patched_node eq " "  );
        $unpatched_node_list =~ s/$patched_node//;
    }
    1 while $unpatched_node_list =~ s/  / /g;
    1 while $unpatched_node_list =~ s/^ //g;

    # phnguyen: below is not my comment.  This is really unprofessional
    #
    # If it got this far the local node is patched. So let the user make
    # it active again.
    # Damn. I should have ignored the original design specs and kept
    # everythings as hashes or simple arrays. Now I have to do another
    # check each time to see if there are any non-whitespace characters
    # left in the string. I can only blame myself for this.

    my $message = "";
    if ( $unpatched_node_list =~ m#\w# ) {
        $message = "\nThe local instance has been updated and can be\n" .
                   "restarted before answering the next question.\n" .
                   "The nodes left to update are: \"$unpatched_node_list\".\n" .
                   "Do you want to continue patching?";

        my $response = opatchIO -> check_to_stop_processing ( {
                                                 message => $message } );

        if ( $response eq "N" ) { 
          $finished_flag  = 1; 
          $message = 
                     "Only local system binary has been patched but " .
                     "inventory has not been updated.  All remote nodes are unpatched.\n" ;
          return $message;
        }
    }

    if ( ( $finished_flag ) && ( $unpatched_node_list) ) {
        $Command::do_not_update_inventory = 1;
    }

    # Now set-up the various itmes for patching. This will be guarded
    # against in the rewite as it's not needed if patching is finished.
    my $rh_java_paths = $this_class -> make_java_paths ( {
                                Oracle_Home       => $Oracle_Home,
                                rh_OUI_file_names => $rh_OUI_file_names } );

    my $path_to_java = $$rh_OUI_file_names{path_to_java};
    my $class_path   = $$rh_java_paths{class};

    # A little hardcoding, sorry. But srvm.jar is needed for the RAC APIs.
    my $class_path_extra = "$Command::path_separator_token" . 
                            File::Spec -> catfile ( $Oracle_Home, "jlib", "srvm.jar" );

    if ( $class_path =~ m#"$# ) {
        ( $class_path ) = ( $class_path =~ m#^(.+)"$# );
        $class_path .= $class_path_extra . "\"";
    } else {
        $class_path .= $class_path_extra;
    }

    # And which directory is to be copied over? The patch storage area.
    my $patch_dir = File::Spec -> catfile ( $Oracle_Home, ".patch_storage",
                                                                $patch_id ) ;
    
    my $list_of_files_to_copy = "";
    foreach my $name ( keys %$rh_file_list ) {
        next if ( ! $name );
        $list_of_files_to_copy .= $name . "\n";
    }

    # Construct the file containing a list of filenames to propagate
    my $fileListName = File::Spec -> catfile ( "$patch_dir" ,
                                              "$Command::FILES_TO_PROPAGATE" );
    my $dirListName  = File::Spec -> catfile ( "$patch_dir" ,
                                              "$Command::DIRS_TO_MKDIR" );
    my $oui_path = $$rh_java_paths{oui_path};
                                                  
    opatchIO->print_message_noverbose({ 
       message => "Creating file to hold list of files to propagate: " .
                                 "\"$fileListName\"" });
    if( -e $fileListName ) {
      opatchIO->print_message({ 
          f_handle => $fh_log_file,
          message => "  removing the old file to write new content to it: " .
                                 "\"$fileListName\"" });
      unlink ( $fileListName );
    }
    
    local *OUTPUT_FILE;
    open ( OUTPUT_FILE, ">$fileListName" ) or do {
            opatchIO -> print_message ( {
             f_handle => $fh_log_file,
             message => "ERROR: Cannot open file to write: \"$fileListName\"\n"                
            } ); 
            $return_string = "ERROR: cannot create file list to propagate to node";
            return $return_string;
    };
    # Write to it list of files to be propagated, already separated by "\n"
    print OUTPUT_FILE ("$list_of_files_to_copy");
    # Then close the file
    close OUTPUT_FILE;
    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message  =>
              "List of files to be propagated: $list_of_files_to_copy" } );
    
    
    my $class_to_run = "opatch/PropagatePatchToNode";
    my $debug = $Command::DEBUG;

    my $system_command  = "$path_to_java  $class_path $debug $class_to_run " .
                                                         "\"$Oracle_Home\" ";

    # Only whitespace means all nodes done.
    if ( $unpatched_node_list =~ m#^\s*$# ) {
        $unpatched_node_list = "";
        $finished_flag = 1;
    }

    # If not finished keep patching.
    while ( ! $finished_flag ) {

        # Get the next node to drop from the user.
        my $new_node = "";
        my $message = "";

        # Start of patch loop.
        while ( ( ! $new_node ) && ( ! $finished_flag ) ) {
            $message = "Unpatched nodes are \"$unpatched_node_list\"\n" .
                       "Which is the next node to be updated? \n" .
                       "(if there are no more nodes, just press <enter>)";
            
            opatchIO -> print_message_noverbose ( { # f_handle => $fh_log_file,
                                          message  => $message } );

            # Flush the stdout first
            select(STDOUT);
            $|=1;
                                          
            # Read the node from users
            $new_node = <STDIN>;
            chomp $new_node;

            # TurnOff the autoflush.
            $|=0;
            
            1 while $new_node =~ s/ //g;
            
            opatchIO -> print_message ( { f_handle => $fh_log_file,
                                      message  => "Answer: $new_node\n" } );

            my $node_error_message = "";

            # Node name selection.
            if ( ( $unpatched_node_list !~ m#$new_node# ) && ( $new_node ) ) {
                if ( $patched_RAC_nodes =~ m#$new_node# ) {
                    $node_error_message =
                                    "\n\"$new_node\" has already been updated.";
                } else {
                    $node_error_message =
                              "\n\"$new_node\" is not participating " .
                              "in this instance.\n" .
                              "The nodes to be updated are: " .
                              "\"$unpatched_node_list\"";
                }
                $new_node = "";
                opatchIO -> print_message_noverbose ( { f_handle => $fh_log_file,
                                              message  =>
                                                   "$node_error_message\n" } );
            } elsif ( ! $new_node ) {
                $message = "You entered a blank string.\n" .
                           "\nDo you want to continue? \n" .
                           "(If there are no more nodes, answer N to " .
                           "finish patching)";

                my $response = opatchIO -> check_to_stop_processing ( {
                                                 message => $message } );

                if ( $response eq "N" ) { 
                  $finished_flag  = 1; 
                 
                  #Error out only if the unpatched_node_list has nodes in it. 
                  if ($unpatched_node_list !~ m#^\s*$#) {
                    $message = "Unpatched nodes are \"$unpatched_node_list\"";
                    return $message;
                  }
                }
            }

            # This part of code is commented, as the finished flag is set, the while loop ends and
            # the do_not_update_inventory will be set outside the loop properly after checking
            # if the unpatched_node_list has nodes  in it.
            # The code here has a bug because if the unpatched_node_list has only spaces then
            # the flag do_not_update_inventory gets set, which is wrong.
            #
            #if ( ( $finished_flag ) && ( $unpatched_node_list) ) {
            #    $Command::do_not_update_inventory = 1;
            #}

        }   # End of getting new node name.


        if ( ! $finished_flag ) {
            # Stop processing on the new node. When I have the class
            # RaiseOrLowerRACNode running this will be automated. Currently it
            # needs user interaction to be safe.
            $message =
                "\nPlease shut down Oracle instances on node:\n" .
                "\"$new_node\"\n" .
                  "running out of ORACLE_HOME\n" .
                "(Oracle Home = $Oracle_Home)\n" .
                "Is the node ready for updating (are the instances down)?";

            my $okay_to_continue = opatchIO -> check_to_stop_processing ( {
                                                      message => $message } );

            if ( $okay_to_continue =~ m#^$#i ) { 
              $okay_to_continue = "Y"; 
            }

            if ( $okay_to_continue eq "N" ) {
                $message = "Unpatched nodes are $unpatched_node_list";
                return $message;
            } else {

                # Propagate the patch to the new node.
                $error_flag = 0;

                # Patch the files.
                my $patch_command = $system_command . " $new_node $patch_dir " .
                                "\"$fileListName\"" . " " .
                                "\"$dirListName\""  . " " .
                                "\"$oui_path\""; 
                                

                $patch_command = 
                   $this_class->getDependentPerlCommand({system_command=>$patch_command});

                opatchIO->print_message_noverbose ( {
                  message => "Propagating the patch..."
                } );
                
                #my $sys_call_result = qx/$patch_command/;
                opatchIO -> print_message ( { f_handle => $fh_log_file,
                                            message  => "System Command:\n\t" .
                                                      $patch_command .
                                                      "\nResult:\n" } );


  		my $sys_call_result = $this_class -> run_cmd_print_live ( { sys_command => $patch_command,
                   	                		     level => 1,
                        		                     f_handle => $fh_log_file } );

                chomp $sys_call_result;

                my $status = $this_class -> get_child_error ( {
                  CHILD_ERROR     => $CHILD_ERROR
                } );
                my $java_error = $this_class->is_there_Java_error({
                      sys_call_result => $sys_call_result
                });
                my $propagation_error = 0;
                if( $status || $java_error ) {
                   $propagation_error = 1;
                }
                my $message = "";
                if ( $propagation_error ) {
                    $error_flag++;
                    $failed_node_list  .= "$new_node ";
                    my $question = 
                     "OPatch encounters the following issues during file propagation to " .
                     "$new_node:\n" .
                     "$sys_call_result" . "\n\n" .

                     "If the error is due to file propagation error, you can " . 
                     "manually copy the files to the remote node, then continue " .
                     "with patching.  The complete list of files are in the file " .
                     "\"$fileListName\"\n" .
                                 
                     "Do you want to continue?";

                    my $answer = opatchIO->check_to_stop_processing({
                                            message => $question
                                         });
                    if ($answer eq "") {
                      my $message = "Ignore file propagation issues and continue...\n";
                      $propagation_error = 0;
                      opatchIO->print_message ({ f_handle=>$fh_log_file,
                                                message =>$message });
                      $return_string = "";
                    } else {
                      $return_string = $sys_call_result;
                      return $return_string;
                    }
                } else {
                    my $message = "\nFiles for the interim patch $patch_id " .
                               "have been propagated to $new_node.\n";
                    if ( $this_class eq "RollBack" ) {
                        $message = "\nRemoval of the interim patch $patch_id " .
                                   "has been propagated to $new_node.\n";
                    }

                    opatchIO -> print_message_noverbose ( { f_handle => $fh_log_file,
                                              message  => $message } );
                }
                # Update the patched_RAC_nodes
                $patched_RAC_nodes .= "$new_node ";
 
                # Now run make on the remote nodes.
                if ( $propagation_error == 0 ) {
                    # Make can lie. Currently ignoring the return value until
                    # more research is done. Customer can run make from the
                    # file left in the patch backup area if needed. Sorry.
                    opatchIO->debug({message=>
                        "calling run_make_on_remote_nodes()\n"
                    });
                    $sys_call_result =
                               $this_class -> run_make_on_remote_nodes ( {
                                        all_nodes       => $new_node,
                                        fh_log_file     => $fh_log_file,
                                        local_node      => $local_node,
                                        Oracle_Home     => $Oracle_Home,
                                        patch_id        => $patch_id } );
                }

                # Restart processing on the new node.
                opatchIO -> print_message ( { f_handle => $fh_log_file,
                                              message  => $sys_call_result } );

                # Update data structures and print appropriate messages.
                if ( ( $patched_RAC_nodes =~ m#$new_node # ) &&
                     ( $new_node !~ m#^\s$# ) ) {

                    $unpatched_node_list =~ s/$new_node//g;
                    $failed_node_list    =~ s/$new_node//g;

                    $message = "\nNode \"$new_node\" has been updated.\n" .
                           "You can now restart Oracle instance on it.";
                } else {
                    $message = "\nThere were problems applying the patch to " .
                               "node \"$new_node\".\n" ;
                    if ( $this_class eq "RollBack" ) {
                        $message = "\nThere were problems rolling back the " .
                                   "patch to node \"$new_node\".\n";
                    }
                    $message .= "Check the log file for more details before " .
                                "attempting to update \"$new_node\" again.\n";
                }
                $new_node = "";
                opatchIO -> print_message_noverbose ( { f_handle => $fh_log_file,
                                          message  => $message } );

                # Bug:4582141 - Search for empty also, so change '+' to '*'
                # Only whitespace means all nodes done.
                if ( $unpatched_node_list =~ m#^\s*$# ) {
                    $unpatched_node_list = "";
                    $finished_flag = 1;
                }

                # Finished?
                if ( $unpatched_node_list =~ m#\w# ) {
                    $message = "\nThe nodes left to patch are: " .
                               "$unpatched_node_list\n" .
                               "\nDo you want to continue?";

                    my $response = opatchIO -> check_to_stop_processing ( {
                                                 message => $message } );

                    if ( $response eq "N" ) { 
                      $finished_flag  = 1; 
                      $message = "Unpatched nodes are $unpatched_node_list";
                      return $message;
                    }

                }

                if ( ( $finished_flag ) && ( $unpatched_node_list) ) {
                    $Command::do_not_update_inventory = 1;
                }
            }
        }
    }   # End of patching loop.

    if ( $unpatched_node_list =~ m#\w+# ) {
        $Command::do_not_update_inventory = 1;
    }

    my $patch_store = File::Spec -> catfile( $Oracle_Home,
                                                       ".patch_storage" );
    my $busy_lock   = File::Spec -> catfile( $patch_store,
                                                       "patch_locked"   );

    # We know the lock file exists or something has gone very wrong.
    # Except the lock hasn't been implemented for rollback. I'm
    # changing groups and won't have time to fix this due to my being
    # used in another project. Remember my coding is idempotent so you
    # can run it multiple times - the cost is redundant calls. But it's
    # safe to unpatch previously unpatched nodes.
    # In 90% of cases this won't matter. The other 10% will need manual
    # intervention to fix due to the lock not being honored. Sorry.
    my $error_message = "";
    local *LOCK_FILE;
    open ( LOCK_FILE, "+<$busy_lock" ) || ( $error_message =
                                          "Couldn't read the lock file " .
                                          "data.\nError is: $OS_ERROR\n" );
    if ( $error_message ) {
        opatchIO -> print_message ( { f_handle => *STDERR,
                                      message  => $error_message } );
        opatchIO -> print_message ( { f_handle => $fh_log_file,
                                      message  => $error_message } );
    }

    if ( ! $error_message ) {
        my @file_data = <LOCK_FILE>;

        # Update the nodes line in the lock file.
        my $upper_bound = scalar ( @file_data );
        for ( my $i = 0; $i < $upper_bound; $i++ ) {
            if ( $file_data[$i] =~ m#^RAC node details : # ) {
                $file_data[$i] =
                           "RAC node details :  $patched_RAC_nodes\n";
            }
        }

        # Rewrite and close the file.
        print LOCK_FILE @file_data;
        close ( LOCK_FILE );
    }

    return ( $return_string );

}   # End of propagate_patch_rolling().

##############################################################################
#
# NAME   : run_make_on_remote_nodes
#
# PURPOSE: Return a string warning this is a RAC install and that the other
#          nodes in the RAC should be shutdown.
#
# INPUTS : $$ARG[1]{all_nodes}   - A list of all the nodes in the RAC.
#          $$ARG[1]{fh_log_file} - The file handle for the log file.
#          $$ARG[1]{local_node}  - The name of the local node.
#          $$ARG[1]{Oracle_Home} - The area that is to be patched.
#          $$ARG[1]{patch_id}    - The patch identification string.
#
# OUTPUTS: $error_messages - A string containing any errors encountered.
#
# NOTES  : 1. This is just an "rsh" to the remote node. That's what the RAC
#             APIs do. So rather than make another call to Java it's faster
#             to issue it from here.
#          2. This should be integrated with the method
#             Rollback::get_and_run_make_commands().
#
##############################################################################
sub run_make_on_remote_nodes {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $all_nodes    = $$rh_arguments{all_nodes};
    my $fh_log_file  = $$rh_arguments{fh_log_file};
    my $local_node   = $$rh_arguments{local_node};
    my $Oracle_Home  = $$rh_arguments{Oracle_Home};
    my $patch_id     = $$rh_arguments{patch_id};

    my $error_messages = "";
    my @file_data      = ();
    my @nodes          = split ( " ", $all_nodes );

    if ( $OSNAME =~ m#Win32# ) {
      opatchIO->debug({message=>"do nothing on Windows"});
      return "";
    }
    
    opatchIO->debug({message=>
		      "run_make_on_remote_nodes(): \n" .
		      "  all_nodes = \"$all_nodes\"\n" .
		      "  local_node= \"$local_node\"\n"
	  });
    
    if ( $Command::NO_RELINK_MODE ) { 
       opatchIO -> print_message_noverbose ( {
		       message =>
"----------------------------------------------------------------------------------\n" .
   "Skip executing 'make' on remote nodes.\n" .
   "Please invoke 'make' manually after patching on all remote nodes that are patched.\n" .
"----------------------------------------------------------------------------------\n" 
       });    
       return "";
    }

    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message => "Searching for make commands.\n" } );

    my $patch_directory   = File::Spec -> catfile ( "$Oracle_Home",
                                                    $this_class -> save_dir,
                                                    $patch_id );

    # get the "make" command
    my $make_command = $this_class->getMakeCommand();
    if( $make_command eq "" ) { 
       opatchIO -> print_message_and_die ( {
		       exit_val => $this_class -> ERROR_CODE_PATH_PROBLEM,
		       message =>
		       "'make' is not in your PATH or is not executable.\n" .
           "  Extra Search Path= /usr/bin/make (Linux), /usr/ccs/bin/make (others)\n" .
		       "  Path= $ENV{PATH}\n" .
           "You have to manually run make on all remote nodes or use -local option.\n"
	       });    
    } 

    # On HP-UX use remsh, not rsh. Not using :? syntax as there may be
    # changes for other OSs.
    my $rsh_command    = $Command::RSH_SSH;
    my $isRSH_SSH = $ENV{OPATCH_REMOTE_SHELL};
    if ( $isRSH_SSH eq "" && $OSNAME eq "hpux") {
       $rsh_command = "remsh";
    }

    my $make_command_file = $patch_id . "_make.txt";
    $make_command_file = File::Spec -> catfile ( "$patch_directory",
                                                 "$make_command_file" );
    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message  => "Running make commands " .
                                              "on remote nodes with make file " .
                                              "\"$make_command_file\" \n\n" } );
    my $status_ok = 1;
    if ( -e $make_command_file ) {

        opatchIO -> print_message ( { f_handle => $fh_log_file,
                                      message => "open $make_command_file to read\n" } );
        local *MAKE_COMMANDS;
        open ( MAKE_COMMANDS, $make_command_file ) or do {
            opatchIO -> print_message ( { f_handle => *STDERR,
                                          message  => "Cannot open file " .
                            "$make_command_file for reading. Cannot undo " .
                            "make commands.\n" } ),
            $status_ok = 0
        };

        if ( $status_ok ) {
            @file_data = <MAKE_COMMANDS>;
            close MAKE_COMMANDS or do {
            opatchIO -> print_message ( { f_handle => *STDERR,
                                          message  => "Cannot close the " .
                             "file after reading: $make_command_file\n" .
                                    "[$OS_ERROR]\nProcessing continuing" } );
            }
        }
    } else {
        opatchIO -> print_message ( { f_handle => $fh_log_file,
                          message => "$make_command_file to read does not exist\n" } );

        $status_ok = 0;
    }

    my $rsh_ssh_prefix = "";
    if ( $status_ok ) {
        foreach my $target ( @nodes ) {

            # next if ( $target =~ m#$local_node# );
            if ( $target eq $local_node ) {
             opatchIO -> print_message ( { f_handle => $fh_log_file,
                        message => "  skip make on local node \"$local_node\"\n" } );
              next;
            }

            my $node = $target;

            my $system_command = "";
            $rsh_ssh_prefix = "$rsh_command -n $target ";

            opatchIO -> print_message ( { f_handle => $fh_log_file,
                  message => "  initial rsh_ssh_prefix is \"$rsh_ssh_prefix\"" } );

            # On AIX and HP-UX, the '-n' option goes after the target, so we will
            #   switch only if user has not set the env. var. OPATCH_REMOTE_SHELL
            if ( $isRSH_SSH eq "" ) {
                if ( ( $OSNAME eq "hpux" ) || ( $OSNAME eq "aix" ) ) {
                    $rsh_ssh_prefix = "$rsh_command $target -n ";
                    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                      message => 
                    "  on hpux and aix, change rsh_ssh_prefix to \"$rsh_ssh_prefix\"" } );
                    }
            } else {

                # Testing on hprac-12, 13, 15, 16 shows that
                #  if OPATCH_REMOTE_SHELL is set to "/path/remsh", we 
                #  still have to flip the '-n' option just as above.
                if ( ( $OSNAME eq "hpux" ) || ( $OSNAME eq "aix" ) ) {
                    if ( $rsh_ssh_prefix =~ "remsh" ) {
                       $rsh_ssh_prefix = "$rsh_command $target -n ";
                       opatchIO -> print_message ( { f_handle => $fh_log_file,
                                      message =>
                       "  on hpux and aix, if OPATCH_REMOTE_SHELL is set to remsh, " . 
                       "change rsh_ssh_prefix to \"$rsh_ssh_prefix\"" } );
                    }
                }
            } 

            opatchIO -> print_message ( { f_handle => $fh_log_file,
                           message => "  parsing each line in \"$make_command_file\"" } );
            my $entered = "0";
            
            my $changeDirCommand = "";
            foreach my $line ( @file_data ) {
                
                # Strip out comments and blank lines.
                next if ( $line =~ m/^#/ );
                next if ( $line =~ m/^\s+#/ );
                next if ( $line =~ m#^$# );

                if ( $line =~ m#^cd# ) {
                    # this is the "cd /private/phi_local/9201home/rdbms/lib/" line
                    #   or        "cd ORACLE_HOME/rdbms/lib/"
                    if ( $line =~ m#ORACLE_HOME# ) {
                      $changeDirCommand = $line;
                      $changeDirCommand =~ s#\$ORACLE_HOME#$Oracle_Home#;
                    } else {
                      $changeDirCommand = $line;
                    }
                    chomp $changeDirCommand;
                    next;
                    # go to next line, expecting a "make" command there...
                }


                opatchIO -> print_message ( { f_handle => $fh_log_file,
                         message => "  start with rsh_ssh_prefix \"$rsh_ssh_prefix\"" } );

                #
                # This use of regular expression might fail if the "make_command"
                #   picked up when applying this patch is different from the
                #   "make_command" picked up now during rollback.
                #
                # if ( $line =~ m#^$make_command\s# ) {
                
                if ( $line =~ m#make\s# ) {

           	   if ($entered eq "0") {
                      $entered="1";
                      opatchIO -> print_message_noverbose ( { 
                        message => 
    "-------------------------------------------------------------------------------\n" .
            "  OPatch is about to re-link binaries on node \"$target\"\n" .
            "  After patching is done, OPatch recommends you check the binary's size\n" .
     "    and timestamp on the node to make sure the binaries are updated correctly.\n" .
     "-------------------------------------------------------------------------------\n" 
            		      } );
                    }

                    # Because various vendors do _strange_ things in rsh
                    # and $ORACLE_HOME can dissapear during the make
                    # invokation it's neccessary to nail $ORACLE_HOME into
                    # place.
                    # $system_command =~
                    #    s#;$make_command #;$make_command ORACLE_HOME=\"$Oracle_Home\" #;

                    # line is
                    # make -f  ins_rdbms.mk ioracle OR
                    # /usr/bin/make -f ins_rdbms.mk ioracle
                    my @list = split ( ' ', $line );
                    my $cmdPart = $list[0];
                    my $cmdArgPart = $list[1];
                    my $makeFilePart = $list[2];
                    my $targetPart = $list[3];
                    $system_command = 
                       $rsh_ssh_prefix . "\"" .
               " $changeDirCommand; $make_command $cmdArgPart $makeFilePart $targetPart " .
                                      "ORACLE_HOME=\"$Command::UNRESOLVED_ORACLE_HOME\"" . "\"";

                    opatchIO -> print_message ( { f_handle => $fh_log_file,
                         message => "  found make entry: system command is now " .
                                    "\"$system_command\"" } );

                    # And in some cases we need LD_LIBRARY_PATH too.
                    if ( defined $ENV{LD_LIBRARY_PATH} ) {
                        my $ld_string =
                                  "LD_LIBRARY_PATH=\"$ENV{LD_LIBRARY_PATH}\"";
                        $system_command =~
                                    s# ORACLE_HOME=# $ld_string ORACLE_HOME=#;
                        opatchIO -> print_message ( { f_handle => $fh_log_file,
                           message => "  LD_LIBRARY_PATH defined: " .
                                      "system command is now \"$system_command\"" } );
                     }

                    my ( $target ) = ( $line =~ m#\s(\w+);$# );
                    opatchIO -> print_message ( { message  => "  preparing make command " .
                                                          "for $target on " .
                                                          "node \"$node\" with command:\n" .
                                                          "\"$system_command\"" } );

                    # Easier to read in the log file.
                    $system_command =~ s#;#; #g;
                    opatchIO -> print_message ( { 
                        message  => "  re-format system command to:\n" .
                                                          "\"$system_command\"" } );
                    $system_command =~ s#; $# "#;
                    opatchIO -> print_message ( { message  => 
                          "  after substitution, system command is:\n" .
                                                          "\"$system_command\"" } );
                                                          
                    # Redirect stderr to a file called
                    my $filename = File::Spec -> catfile ( 
                                                  "$patch_directory",
                                                  "make_$node.stderr" );
                    # First remove the file if it's there
                    if ( -e $filename ) {
                      unlink $filename;
                    }
                    
                    $system_command = "$system_command" . " 2>$filename";
                    opatchIO -> print_message ( { 
                         message  => "  redirect stderr to file, invoking command \n" .
                                                          "\"$system_command\"" } );
                    
                    # Remember the command to be invoked             
       		          $Command::REMOTE_MAKE_COMMAND_IS_INVOKED = "1";
                    $Command::REMOTE_MAKE_COMMAND_INVOKED .= $system_command . "\n";
                    
                    my $sys_call_result = qx/$system_command/;
                    chomp $sys_call_result;
                    opatchIO -> print_message_noverbose ( { f_handle => $fh_log_file,
                                           message  => "  system command invoked: " .
                                           "\"$system_command\"" . "\nResult:\n" .
                                              "$sys_call_result\n" } );
                   
                    my $status = $this_class -> get_child_error ( {
                        CHILD_ERROR     => $CHILD_ERROR
                    } );

                    # Small note: status may not be enough. The return value
                    # is for the last make target invoked.
                    my $result_message = "   Status: success.\n";
                    if ( $status ) {
                    
                        # Remember the failed command            
                        $Command::REMOTE_MAKE_COMMAND_FAILED .= 
                             "ERROR: \"$system_command\" FAILED ON REMOTE NODE.\n";
                        $result_message = "   Status: failed.\n";

                        $error_messages .= "\nERROR invoking command: " .
                                                      "$system_command\n";
                        $error_messages .= "OPatch failed to invoke a remote ".
                                           "make on the remote nodes due to ".
                                         "rsh/ssh problem.  Please either run ".
                                           "make manually on remote node \"$node\" ".
                                         "or run OPatch with -local option.\n"; 

                        opatchIO -> print_message_noverbose ( {
                           f_handle => $fh_log_file,
                           message => $error_messages
                        } ); 
                        my $question =
                            "Remote make failed on node $node due to rsh/ssh issues.  " .
			    "Replying 'Y' will terminate the patch operation immediately." .
                            "It WILL NOT restore any updates that have been performed to this point. " .
                            "It WILL NOT update the inventory." . "\n" .
	                    "Replying 'N' will continue with additional make operations. " .
			    "You will have to run this make manually on the remote node " .
                            "\"$node\".  " .
                            "\nDo you want to STOP?" ;

                        my $answer = opatchIO -> check_to_stop_processing ( {
                                                message => $question } );
                        if ( $answer eq "" ) {
                          opatchIO->print_message_and_die({
                              exit_val => $this_class->ERROR_CODE_CLUSTER_PROBLEM,
                              message=> message => $error_messages
                          });
                        }
                    }

                    # Read the content of redirected stderr file to check for error
                    # assert: non-zero byte file size means error
                    if ( -e $filename && -s $filename ) {
                        # Remember the failed command            
                        $Command::REMOTE_MAKE_COMMAND_FAILED .= "ERROR: " .
                                    "\"$system_command\" FAILED ON REMOTE NODE.\n";
                        $result_message = "   Status: failed.\n";

                        opatchIO -> print_message_noverbose ( {
                             f_handle => $fh_log_file,
                             message => "ERROR: Make might have failed on remote node " .
                                        "\"$node\", details in \"$filename\"\n"
                        } ); 
                        local *MAKE_ERROR_FILE;
                        open ( MAKE_ERROR_FILE, $filename ) or do {
                            opatchIO -> print_message ( {
                              f_handle => $fh_log_file,
                              message => 
                                "ERROR: Cannot open error file to read: \"$filename\"\n"
                            } ); 
                        };
                        my @file_data = <MAKE_ERROR_FILE>;
                        foreach my $line ( @file_data ) {
                          chomp $line;
                          opatchIO -> print_message_noverbose ( {
                              f_handle => $fh_log_file,
                              message => "  - detailed error: \"$line\"\n"
                          } ); 
                        }
                        close MAKE_ERROR_FILE;
                        my $question =
                            "Make might have failed on node $node.\n" .
			    "Replying 'Y' will terminate the patch operation immediately. " .
                            "It WILL NOT restore any updates that have been performed to this point. " .
                            "It WILL NOT update the inventory." . "\n" .
                            "Replying 'N' will continue with additional make operations.\n" . 
			    "Verify the contents of stderr. You may have to run this make manually on the remote node. " .
                            "\nDo you want to STOP?" ;

                        my $answer = opatchIO -> check_to_stop_processing ( {
                                                message => $question } );
                        if ( $answer eq "" ) {
                          opatchIO -> print_message_and_die ( {
                            exit_val => $this_class->ERROR_CODE_CLUSTER_PROBLEM, 
                            message => 
                                "Remote make failed on remote node \"$node\"." .  
                                "See log file for details.\n"
                          } ); 
                        }
                    } # end of if the stderr output is non-zero in size

                    # result_message will say "success or failed"
                    opatchIO -> print_message ( {
                                              message  => $result_message } );

                    $system_command = "$Command::RSH_SSH -n $node \"";
                    if ( ( $OSNAME eq "hpux" ) || ( $OSNAME eq "aix" ) ) {
                        $system_command = "$rsh_command $node -n \"";
                    }

                }
            }
        }
    }

    opatchIO->debug({message=>
		    "run_make_on_remote_nodes() finishes:\n" .
		    "   error_message= $error_messages\n"
	    });
    return ( $error_messages );

}   # End of run_make_on_remote_nodes().

##############################################################################
#
# NAME   : set_OS_dependent_items
#
# PURPOSE: Set the few OS dependent items that perl doesn't handle.
#
# INPUTS : NONE
#
# OUTPUTS: NONE
#
# NOTES  : 1. Sets global variables to appropriate values.
#
###############################################################################
sub set_OS_dependent_items {

    # Default to Unix
    $Command::current_directory_token   = ".";
    $Command::directory_separator_token = "/";
    $Command::parent_directory_token = "..";
    $Command::path_separator_token   = ":";

    # Now override if needed.
    if ( $OSNAME =~ m#Win32# ) {
        # (Mutter) Need to escape "\" as it's the escape character.
        $Command::directory_separator_token = "\\";
        # Windows path separator is semicolon.
        $Command::path_separator_token = ";";

    } elsif ( $OSNAME eq "VMS" ) {
        $Command::current_directory_token   = "[]";
        $Command::parent_directory_token = "[-]";

        # To get the path separator make a bogus path and remove the known
        # characters. This is a guess since I haven't a VMS system to check
        # this on.
        $Command::directory_separator_token =
                                           File::Spec -> catfile( "", "bin" );
        ( $Command::directory_separator_token ) =
                      ( $Command::directory_separator_token =~ m#^(.+)bin$# );
    }

}   # End of set_OS_dependent_items().

###############################################################################
#
# NAME   : update_inventory
#
# PURPOSE: Return details of the database to so the calling function can
#          determine if it's safe to continue.
#
# INPUTS : $$ARG[1]{fh_log_file}    - The file handle for the log file.
#          $$ARG[1]{Oracle_Home}    - The area that is to be patched.
#          $$ARG[1]{patch_id}       - The patch identification string.
#          $$ARG[1]{patch_location} - The location of the patch directory.
#          $$ARG[1]{rh_bug_list}    - The details of the bugs being fixed.
#          $$ARG[1]{rh_OUI_file_names}
#                                   - A list of files that are needed when
#                                     invoking OUI through the JVM.
#
# OUTPUTS: $error_message           - A string containing the details of any
#                                     errors encountered while updating the
#                                     inventory (error case).
#                                   - empty string if OK.
#
# NOTES  : 1. This bundles-up the details needed to minimize the number of
#             invokations to the Java virtual machine.
#          2. Java only takes strings for arguments so arrays and hashes need
#             to be reformatted into single strings.
#          3. I've just noticed there is another update_inventory in Rollback.
#             These need to be merged if possible.
#          4. Using " -> " as a magic character set to identify files that
#             belong in archives.
#          5. Using " +> " as a magic character set to identify files that
#             are new files to the installation.
#
###############################################################################
sub update_inventory {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $fh_log_file       = $$rh_arguments{fh_log_file};
    my $Oracle_Home       = $$rh_arguments{Oracle_Home};
    my $patch_id          = $$rh_arguments{patch_id};
    my $patch_location    = $$rh_arguments{patch_location};
    my $rh_bug_list       = $$rh_arguments{rh_bug_list};

    my $rh_OUI_file_names = $$rh_arguments{rh_OUI_file_names};

    my $bug_string = "";

    # Build the string that is to be list of bugs.
    foreach my $bug ( keys %$rh_bug_list ) {
        my $description = $$rh_bug_list{$bug};
        $bug_string .= "$bug ";
    }

    my $path_to_java = $$rh_OUI_file_names{path_to_java};

    # Set-up the Java class for the inventory update.
    my $rh_java_paths = $this_class -> make_java_paths ( {
                                Oracle_Home       => $Oracle_Home,
                                rh_OUI_file_names => $rh_OUI_file_names } );

    my $class_path = $$rh_java_paths{class};
    my $oui_path   = $$rh_java_paths{oui_path};

    # temporarily chdir to OH/inventory before calling UpdateInventory to
    #   get around OUI bug when OPatch was launched from a read-only loc.
    #   (OUI trying to mkdir Oneoffs21/<ID>
    
    my $curDir = $this_class->get_cwd();
    my $OHInventory = $Oracle_Home . "/" . "inventory";
    $OHInventory = $this_class->convert_path_separator({ path => $OHInventory });

    # Now set-up the call and capture the results. Quoting $file_names to
    # make the $file_names a single argument to the Java program.
    # This may need some tuning.
    my $class_to_run = "opatch/UpdateInventory";

    my $program_name = &File::Basename::basename($PROGRAM_NAME);
    my $version_num  = $this_class -> version;

    my $debug = $Command::DEBUG;
    my $localNode = $Command::LOCAL_NODE;
    my $nodeList = $Command::NODE_LIST;
    my $racCode  = $Command::RAC_CODE;

    my $local_node_only_flag = "";
    # if ($Command::LOCAL_NODE_ONLY) {
    if(! $this_class -> shouldPropagateChange() ) {
        $local_node_only_flag = "-Dopatch.local_node_only";
    }
    my $local_node_name_flag = "";
    if ($Command::LOCAL_NODE_NAME_MODE) {
        $local_node_name_flag = "-Dopatch.local_node_name=$Command::LOCAL_NODE_NAME";
    }

    my $is_shared_flag = "";
    # User wanna turn off CFS detection?
    #    OPATCH_IS_SHARED = true   -> CFS=true, no detect
    #                       false        =false, no detect
    #                       detect       =<detected value>, yes detect
    #                       not set      =false, no detect
    if ($Command::OPATCH_IS_SHARED eq "TRUE") {
        $is_shared_flag = "-Dopatch.is_shared=true";
		    opatchIO -> print_message ( {
               		 message => "No CFS detection, CFS set to true."
              	  });        
    } elsif ( $Command::OPATCH_IS_SHARED eq "FALSE" ) {
        $is_shared_flag = "-Dopatch.is_shared=false";
		    opatchIO -> print_message ( {
               		 message => "No CFS detection, CFS set to false."
              	  });            
    } elsif ( $Command::OPATCH_IS_SHARED eq "DETECT" ) {
        $is_shared_flag = "-Dopatch.is_shared=detect";
		    opatchIO -> print_message ( {
               		 message => "PerformCFS detection, CFS set to detected value."
              	  });        
    } elsif ( $Command::OPATCH_IS_SHARED eq "" ) {
        $is_shared_flag = "";
        # Env. variable OPATCH_IS_SHARED is not set, so ignore it.
    } else {
        $is_shared_flag = "";
		    opatchIO -> print_message ( {
               		 message => "Unknown OPATCH_IS_SHARED value, no CFS detection, CFS set to false."
              	  });        
    } 
    
    my $system_command = "$path_to_java $local_node_only_flag " .
                         "$is_shared_flag " .
                         "$local_node_name_flag " .
                         "$Command::inventory_location_ptr " .
                         $debug .
                         "$class_path $class_to_run " .
                         "$oui_path \"$Oracle_Home\" $program_name " .
                         "$version_num $patch_id " .
                         "$Command::ACTION_FILE " .
                         "\"$bug_string\"";
    $system_command = $this_class->getDependentPerlCommand({ system_command => $system_command });

    my $error_message = "";
    
    $this_class -> warn_about_retry({ f_handle => $fh_log_file });
    opatchIO -> print_message ({ f_handle => $fh_log_file,
                                  message  => "\nSystem Command: $system_command"  
                              });
            
    chdir $OHInventory;
    #my $sys_call_result = qx/$system_command/;

    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message  => "\nResult:\n" } );

    my $sys_call_result = $this_class -> run_cmd_print_live ( { sys_command => $system_command,
                                              level => 1,
                                              f_handle => $fh_log_file } );

    chdir $curDir;
    
    
    my $status = $this_class -> get_child_error ( {
              CHILD_ERROR     => $CHILD_ERROR
    } );
    chomp $sys_call_result;
      
    my $error = $this_class->catch_and_print_Java_error({
                  sys_call_result => $sys_call_result
                });
    if( $error ) {
        return $error;
    } else {
        return "";
    }

}   # End of update_inventory().

###############################################################################
#
# NAME   : catch_and_print_Java_error
#
# PURPOSE: Given a bunch of text (output from System.out.print() from Java prog.
#          this program searches for any string "ERROR: ...." and print out
#          that line.  This is cheap substitute for CHILD_ERROR checking.
#          It's similar to "cat file | grep "ERROR:"
#
# INPUTS : $$ARG[1]- Output of a Java program which comprises of line(s) of
#                    string. Some strings have "ERROR: ..." format.
#
#
# OUTPUTS: Print out to stdout of "ERROR:..." strings
#
###############################################################################

sub catch_and_print_Java_error {

      my $this_class   = shift @ARG;
      my $rh_arguments = $ARG[0];

      my $sys_call_result   = $$rh_arguments{sys_call_result};
      my @result = split ( /\n/, $sys_call_result );

      my $error = 0;
      foreach my $line ( @result ) {
          if ( $line =~ m#OPATCH_JAVA_ERROR# ) {
             $error = 1;
             opatchIO->print_message_noverbose({ message => $line });  
          }
      }
      return $error;
}

###############################################################################
#
# NAME   : is_there_Java_error
#
# PURPOSE: Given a bunch of text (output from System.out.print() from Java prog.
#          this program searches for any string "ERROR: ...." to return:
#                 1 if there are ERROR: pattern
#                 0 if there is none
#
#          It's similar to "cat file | grep "ERROR:"
#
# INPUTS : $$ARG[1]- Output of a Java program which comprises of line(s) of
#                    string. Some strings have "ERROR: ..." format.
#
#
# OUTPUTS: 1 if there is, 0 if there is no "ERROR:"
#
###############################################################################

sub is_there_Java_error {

      my $this_class   = shift @ARG;
      my $rh_arguments = $ARG[0];

      my $sys_call_result   = $$rh_arguments{sys_call_result};
      my @result = split ( /\n/, $sys_call_result );

      my $error = 0;
      foreach my $line ( @result ) {
          if ( $line =~ m#OPATCH_JAVA_ERROR# ) {
             $error = 1;
          }
      }
      return $error;
}
###############################################################################
#
# NAME   : validate_arguments
#
# PURPOSE: A method to validate the command line.
#
# INPUTS : $$ARG[1]{rh_command_line} - A reference to a hash that has the
#                                      command and options to be validated.
#          $$ARG[1]{rh_command_list} - A reference to a hash containg details
#                                      about the valid commands and options.
#
# OUTPUTS: Nothing directly. If validation fails the attibute {invalid} is
#          defined for rh_command_line.
#
# NOTES  : 1. This is done in two steps:
#             i.   ensure the command is a valid command, then
#             ii.  check the options and any supplied values are valid.
#
###############################################################################
sub validate_command_line_input {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_command_line   = $$rh_arguments{rh_command_line};
    my $rh_command_list   = $$rh_arguments{rh_command_list};

    my $command   = $$rh_command_line{command};
    my @arguments = split ( " ", $$rh_command_line{arguments} );

    # Should never execute this block as parse_arguments() should catch this
    # case. But when someone rewrites this package they'll be glad this is
    # here to catch the error of a non-existant command being passed.
    if ( ! exists $$rh_command_list{$command} ) {
        $$rh_command_line{invalid} =
                 "Problems with the command '$command' [Class: $this_class]";
    }

    # Now validate the options supplied.
    if ( ! exists $$rh_command_line{invalid} ) {
        $this_class -> validate_options ( {
                                rh_command_line => $rh_command_line,
                                rh_command_list => $rh_command_list } );
    }

}   # End of validate_arguments().

###############################################################################
#
# NAME   : validate_directory
#
# PURPOSE: A method to validate a directory's existence and permissions.
#
# INPUTS : $$ARG[1]{item_to_validate} - A directory name.
#          $$ARG[1]{validation_rules} - A reference to an array with what
#                                       permissions are needed to be checked.
#
# OUTPUTS: $error_flag: NULL for success, a string on error.
#
# NOTES  :
#
###############################################################################
sub validate_directory {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $directory_name = $$rh_arguments{item_to_validate};
    my $ra_permissions = $$rh_arguments{validation_rules};

    my $error_flag = "";

    if ( ! -d $directory_name ) {
        $error_flag = "$directory_name is not a directory.";
    }

    if ( ! $error_flag ) {
        foreach my $test ( @$ra_permissions ) {

            if ( ( $test eq "read" ) && ( ! -r $directory_name ) ) {
                $error_flag = "No read permission on $directory_name.";

            } elsif ( ( $test eq "write" ) && ( ! -w $directory_name ) ) {
                if ( ! $error_flag ) {
                    $error_flag = "No write permission on $directory_name.";
                } else {
                    $error_flag .= "\nNo write permission on $directory_name.";
                }

            } elsif ( ( $test eq "execute" ) && ( ! -x $directory_name ) ) {
                if ( ! $error_flag ) {
                    $error_flag = "No execute permission on $directory_name.";
                } else {
                    $error_flag .=
                                "\nNo execute permission on $directory_name.";
                }
            }

        }
    }

    return ( $error_flag );

}   # End of validate_directory().

###############################################################################
#
# NAME   : validate_file
#
# PURPOSE: A method to validate a directory's existence and permissions.
#
# INPUTS : $$ARG[1]{item_to_validate} - A directory name.
#          $$ARG[1]{validation_rules} - A reference to an array with what
#                                       permissions are needed to be checked.
#          $$ARG[1]{required}         - A "yes" or "no" string.
#
# OUTPUTS: $error_flag: NULL for success, a string on error.
#
# NOTES  :
#
###############################################################################
sub validate_file {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $file_name      = $$rh_arguments{item_to_validate};
    my $ra_permissions = $$rh_arguments{validation_rules};
    my $required       = $$rh_arguments{required} || "no" ;

    # Change a no to "" so the negative can be tested implicitly.
    if ( $required eq "no" ) { $required = ""; }

    my $error_flag = "";

    if ( ( ! -f $file_name ) && ( $required ) ) {
        $error_flag = "$file_name is not a file.";
    }

    if ( ( ! $error_flag ) && ( $required ) ) {
        foreach my $test ( @$ra_permissions ) {

            if ( ( $test eq "read" ) && ( ! -r $file_name ) ) {
                $error_flag = "No read permission on $file_name.";

            } elsif ( ( $test eq "write" ) && ( ! -w $file_name ) ) {
                if ( ! $error_flag ) {
                    $error_flag = "No write permission on $file_name.";
                } else {
                    $error_flag .= "\nNo write permission on $file_name.";
                }

            } elsif ( ( $test eq "execute" ) && ( ! -x $file_name ) ) {
                if ( ! $error_flag ) {
                    $error_flag = "No execute permission on $file_name.";
                } else {
                    $error_flag .=
                                "\nNo execute permission on $file_name.";
                }
            }

        }
    }

    return ( $error_flag );

}   # End of validate_file().


###############################################################################
#
# NAME   : validate_number
#
# PURPOSE: A method to validate a directory's existence and permissions.
#
# INPUTS : $$ARG[1]{item_to_validate} - A string to check if its numerical.
#
# OUTPUTS: $error_flag: NULL for success, a string on error.
#
# NOTES  : 1. There is another attribute (validation_rules) supplied but
#             in this case it's ignored.
#
###############################################################################
sub validate_number {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $number = $$rh_arguments{item_to_validate};

    my $return_string = "";

    # In case this changes to hexidecimal in the future just change the
    # description to use $number_string instead of "\d".
    #my $number_string = "[0-9,a-f,A-F]";
    if ( $number !~ m#^\d+$# ) {
        $return_string = "$number is not a valid number.";
    }

    return ( $return_string );

}   # End of validate_number().

###############################################################################
#
# NAME   : validate_options
#
# PURPOSE: A method to validate the command line.
#
# INPUTS : $$ARG[1]{rh_command_line} - A reference to a hash that has the
#                                      command and options to be validated.
#          $$ARG[1]{rh_command_list} - A reference to a hash containg details
#                                      about the valid commands and options.
#
# OUTPUTS: Nothing directly. If validation fails, the attibute {invalid} is
#          defined for rh_command_line.
#
# NOTES  : 1. This is a stub method that does nothing. Commands currently all
#             do something different and have their own method that overrides
#             this.
#          2. Check the given arguments (in $rh_command_line) against the list
#             of valid arguments for the command. If the argument has a
#             an attribute _validityChecks then the value from the command
#             line is validated by the appropriate method.
#          3. If you're trying to debug this (or follow it in a debugger) the
#             following arguments to 'keys' should help:
#             a. %${$$rh_command_list{$command}{_options}}, and
#             b. ${$${$$rh_command_list{$command}{_options}}{$type}}{$attribute}
#             but the loops to see all the values are left to the reader.
#          4. Assumes that the return value from any validation method is
#             a null string for success or a descriptive string of the failure.
#             This is stored in $error_string.
#
###############################################################################
sub validate_options {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_command_line   = $$rh_arguments{rh_command_line};
    my $rh_command_list   = $$rh_arguments{rh_command_list};

    my $command           = $$rh_command_line{command};
    my @arguments         = split ( " ", $$rh_command_line{arguments});

    my $upper_bound = scalar ( @arguments );
    for ( my $i = 0; $i < $upper_bound; $i++ ) {
        my $arg_name = $arguments[$i];

        # Skip global options, already validated.
        next if ( exists $$rh_command_list{$arg_name} );

        # Now check for bogus arguments. Because of perl's autovivification
        # this test needs be done first as the attribute would be created
        # by the validity check if it gets that far.
        # We can re-assign the reference to another variable and make
        # it easier to read but then anyone else reading this may get
        # lost in the arguments.

        if ( ! exists $${$$rh_command_list{$command}{_options}}{$arg_name} ) {
            if ( exists $$rh_command_line{invalid} ) {
                $$rh_command_line{invalid} .= "\nInvalid argument: $arg_name.";
            } else {
                $$rh_command_line{invalid} = "Invalid argument: $arg_name.";
            }
            next;
        }


        # Does this option, now valid, require a check on the value?
        # ( Yes Virgina, you can split hashes like this to avoid line wraps. )
        if ( ${$${$$rh_command_list{$command}{_options}}
                                           {$arg_name}}{_validityChecks} ) {
            my $check_type = ${$${$$rh_command_list{$command}{_options}}
                                              {$arg_name}}{_type};
            my $rule_set   = ${$${$$rh_command_list{$command}{_options}}
                                              {$arg_name}}{_validityChecks};
            my $required   = ${$${$$rh_command_list{$command}{_options}}
                                              {$arg_name}}{_required};

            # Out of hubris I've assumed all validation methods to start
            # with "validate_".
            my $validate_method = "validate_" . $check_type;

            my $error_string = $this_class -> $validate_method ( {
                                        item_to_validate => $arguments[$i+1],
                                        required         => $required,
                                        validation_rules => $rule_set } );
            $i++;
            if ( $error_string ) {
                $$rh_command_line{invalid} .= $error_string;
            }
        }
    }
}   # End of validate_options().

#############################################################################
#
# Pre-req check to make sure:
#     All info. about RAC is available thru OUI APIs
#     Be able to get Oracle Home Info. thru OUI APIs
# Error out if not being able to set up inventory or any RAC pre-reqs fail
#
#############################################################################
sub validate_OUI_and_RAC {

       my $this_class   = shift @ARG;
       my $rh_arguments = $ARG[0];

       my $fh_log_file       = $$rh_arguments{fh_log_file};
       my $Oracle_Home = $$rh_arguments{Oracle_Home};
       my $rh_OUI_file_names = $$rh_arguments{rh_OUI_file_names};
       my $rh_java_paths     = $$rh_arguments{rh_java_paths};

       my $path_to_java = $$rh_OUI_file_names{path_to_java};
       my $class_path   = $$rh_java_paths{class};
       my $class_path_extra = "$Command::path_separator_token" . 
                               File::Spec -> catfile ( $Oracle_Home, "jlib", "srvm.jar" );
       if ( $class_path =~ m#"$# ) {
          ( $class_path ) = ( $class_path =~ m#^(.+)"$# );
          $class_path .= $class_path_extra . "\"";
       } else {
          $class_path .= $class_path_extra;
       }
       my $class_to_run = "opatch/O2O";
       my $oui_path   = $$rh_java_paths{oui_path};
       my $program_name = &File::Basename::basename($PROGRAM_NAME);
       my $version_num  = $this_class -> version;
       my $debug = $Command::DEBUG;
       my $local_node_flag = "";

       # At this time we should not call shouldPropagateChange()
       #   because the function accesses some globals that have not
       #   been init. & we need O2O to detect RAC & CRS
       if ($Command::LOCAL_NODE_ONLY) {
          $local_node_flag = "-Dopatch.local_node_only";
       }

      my $local_node_name_flag = "";
      if ($Command::LOCAL_NODE_NAME_MODE) {
        $local_node_name_flag = "-Dopatch.local_node_name=$Command::LOCAL_NODE_NAME";
      }
       
    my $is_shared_flag = "";
    # User wanna turn off CFS detection?
    #    OPATCH_IS_SHARED = true   -> CFS=true, no detect
    #                       false        =false, no detect
    #                       detect       =<detected value>, yes detect
    #                       not set      =false, no detect
    if ($Command::OPATCH_IS_SHARED eq "TRUE") {
        $is_shared_flag = "-Dopatch.is_shared=true";
		    opatchIO -> print_message ( {
               		 message => "No CFS detection, CFS set to true."
              	  });        
    } elsif ( $Command::OPATCH_IS_SHARED eq "FALSE" ) {
        $is_shared_flag = "-Dopatch.is_shared=false";
		    opatchIO -> print_message ( {
               		 message => "No CFS detection, CFS set to false."
              	  });            
    } elsif ( $Command::OPATCH_IS_SHARED eq "DETECT" ) {
        $is_shared_flag = "-Dopatch.is_shared=detect";
		    opatchIO -> print_message ( {
               		 message => "PerformCFS detection, CFS set to detected value."
              	  });        
    } elsif ( $Command::OPATCH_IS_SHARED eq "" ) {
        $is_shared_flag = "";
        # Env. variable OPATCH_IS_SHARED is not set, so ignore it.
    } else {
        $is_shared_flag = "";
		    opatchIO -> print_message ( {
               		 message => "Unknown OPATCH_IS_SHARED value, no CFS detection, CFS set to false."
              	  });        
    } 
    
    my $system_command = join(' ', $path_to_java, $local_node_flag,
                         $is_shared_flag,
                         $local_node_name_flag,
                         $Command::inventory_location_ptr,
                         $Command::RETRY_OPTION,
                         $Command::DELAY_OPTION,
                         $debug,
                         $class_path, $class_to_run, 
                         qq(").$Oracle_Home.qq("), $oui_path,
                         $program_name, $version_num);
      $system_command = $this_class->getDependentPerlCommand({ system_command => $system_command });
                         
       opatchIO -> print_message ( {
		       message => "Performing RAC pre-req. check...\n"
	     } );

       $this_class -> warn_about_retry({ f_handle => $fh_log_file });
       opatchIO -> print_message ({ f_handle => $fh_log_file,
                                  message  => "\nSystem Command: $system_command"  
                              });
    
       
       #my $sys_call_result = qx/$system_command/;
       opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message  => "\nResult:\n" } );
                                      

       my $sys_call_result = $this_class -> run_cmd_print_live ( { sys_command => $system_command,
          	                                    level => 1,
                	                            f_handle => $fh_log_file } );

       my $error = $this_class->catch_and_print_Java_error({
              sys_call_result => $sys_call_result
            });
            
       if( $error ) {
          opatchIO -> print_message_and_die ( {
             exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM,
		         message => 
                        "$sys_call_result" .
                        "Cannot set up OUI inventory session.\n"
          } );
      }
      
       my @result = split ( /\n/, $sys_call_result );
       # Now parse output strings from O2O
       my $homeIndex = -1;
       my $isCluster = 0;
       my $checkCluster = 0;
       my $canGetLocalNodeName = 0;
       my $nodeCount = 1;
       my $isCFS = 0;
       my $racCode = 0;
       my $localNodeName = "";

       my $actualNodeCount = 0;
       my @nodeList = "";

       foreach my $line ( @result ) {
          if ( $line =~ m#HOME_INDEX=# ) {
             my @list = split '=', $line;
             $homeIndex = $list[1];
          } elsif ( $line =~ m#LOCAL_NODE=# ) {
             my @list = split '=', $line;
             my $test =  $list[1];
             if ( $test eq "NULL" ) {
                $canGetLocalNodeName = 0;
                $localNodeName = "NULL";
             } else {
                $canGetLocalNodeName = 1;
                $localNodeName = $test;
             }
          } elsif ( $line eq "NODE_COUNT=0" ) {
             $nodeCount = 0;
          } elsif ( $line =~ m#NODE_COUNT=# ) {
             # begin to read number of nodes
             my @list = split '=', $line;
             my $count = $list[1];
             $nodeCount = $count;
             # end of read number of nodes
          } elsif ( $line eq "IS_CFS=1" ) {
             $isCFS = 1;
          } elsif ( $line eq "RAC_CODE=1" ) {
             $racCode = 1;
          } elsif ( $line eq "RAC_CODE=2" ) {
             $racCode = 2;
          } elsif ( $line eq "RAC_CODE=0" ) {
            $racCode = 0;
          } elsif ( $line =~ m#NODE_NAME=# ) {
             my @list = split '=', $line;
             my $node = $list[1];
             $nodeList[$actualNodeCount] = $node;
             $actualNodeCount = $actualNodeCount + 1;
          }
       }

       if ( $homeIndex == -1 ) {
          # been unit-tested
          my $message = "The Oracle Home " .
             "$Oracle_Home" . 
             " is not registered with the Central Inventory.  " .
             "OPatch was not able to get details of the home from the inventory.\n";
          if ($OSNAME =~ m#Win32#)  { 
            $message .= "Make sure that Windows 'System32' directory is in your PATH.  " .
                        "For example, C:\\WINNT\\System32\n" ;
          }
          opatchIO -> print_message_and_die ( {
             exit_val => $this_class -> ERROR_CODE_INVENTORY_PROBLEM,
		         message => $message
          } );
       }
       if ( $racCode == 0 ) {
          opatchIO -> print_message ( {
		         message => "This is not a RAC system\n"
          } );
          
       } elsif ( $racCode == 1 ) {
           my $list = " ";
           foreach my $node ( @nodeList ) {
              $list .= $node . " ";
           }
           opatchIO -> print_message ( {
		       message =>
		         "This is a RAC system comprising of $nodeCount nodes:\n" .
             "  $list\n" .
             "Local node is \"$localNodeName\"\n"
			     } );

       } elsif ( $racCode == 2 ) {
           # add to msg that patch -> local system only
          opatchIO -> print_message ( {
            message => "This is a single-node RAC system\n"
          } );
       #
       # Java O2O has deprecated the racNode==3 case, 11/15/04
       #
       # } elsif ( $racCode == 3 ) {
       #    # add to msg that patch -> local system only
       #   opatchIO -> print_message ( {
       #     message => "Users had picked <Non-Cluster Installation> " .
       #               "option even though the local node is part " .
       #                "of a hardware cluster.\n"
       #   } );
       
       }
       
       # Use $status instead of Java output to check for errors
       $Command::HOME_INDEX = $homeIndex;
       #
       # deprecated
       # $Command::IS_CLUSTER = $isCluster;
       # $Command::CHECK_CLUSTER = $checkCluster;
       #
       $Command::CAN_GET_LOCAL_NODE_NAME = $canGetLocalNodeName;
       $Command::LOCAL_NODE_NAME = $localNodeName;
       $Command::NODE_COUNT = $nodeCount;
       $Command::IS_CFS = $isCFS;
       $Command::RAC_CODE = $racCode;

       my $count = 0;
       foreach my $node ( @nodeList ) {
          if( $count == 0 ) {
            $Command::NODE_LIST = $node;
          } else {
            $Command::NODE_LIST = $Command::NODE_LIST . " ". $node;
          }
          $count++;
       }
       opatchIO -> debug ( {
             message => "RAC_CODE = \"$Command::RAC_CODE\"\n" .
	                "NODE_LIST = \"$Command::NODE_LIST\"\n" .
                        "Local Node = \"$Command::LOCAL_NODE_NAME\"\n"
       } );

       if ( $this_class -> shouldPropagateChange() ) {
          if ( $Command::LOCAL_NODE_ONLY ) {
             opatchIO -> debug ( {
                  message =>
                       "-local specified, OPatch " .
                       "will not propagate changes to other nodes.\n"
                  } );
          } else {
            opatchIO -> debug ( {
                  message =>
                      "OPatch will propagate changes to other nodes\n"
                  } );
          }
       } else {
       	  opatchIO -> debug ( {
             message =>
	               "OPatch will NOT propagate changes to other nodes\n"
	       } );

       }
      
       # Extra RAC diagnostic message 
       my $racMsg = "Performing Cluster pre-req. check for Oracle Home...";
       # node list =
       # local node = 
       # if(CFS), pritn CFS too
       
       my $racMsgCase1 = 
        "OPatch will patch the local system only because this is a shared Oracle Home.\n";
        
       my $racMsgCase2 = 
        "Even though OPatch detected the node list from the inventory, it will patch the local system ".
        "only.  This could be because of one or more of the following:\n" .
        "   a) The clusterware is down.\n" .
        "   b) Problems with the clusterware detection.\n" .
        "   c) Problems getting the local node name from the clusterware.\n" .
        "You can correct the problem and " . 
        "verify the node list and the local node name " .
        "by running 'opatch lsinventory -detail'\n" .
        "If you continue, OPatch will patch the local system only.  " .
        "You should then run OPatch on each of the remote nodes using -local option.\n" 
        ;
        
       my $racMsgCase3 = 
       "OPatch will patch the local system only because it detected the Oracle Home has only one associated node in the inventory.  " .
        "To patch additional nodes, exit this session, update the inventory " .
        "by running 'runInstaller(Unix) or setup(Windows) -updateNodeList...'\n" 
        ;
        
       my $racMsgCase4 = 
        "OPatch detected non-cluster Oracle Home from the inventory and will patch the local system only.\n"
        ;
        
       my $racMsgCase5 = 
        "OPatch detected the node list and the local node from the inventory.  " .
        "OPatch will patch the local system then propagate the patch to the remote nodes.\n" 
        ;
        
       my $racMsgCase6 = 
        "You selected -local option, hence OPatch will patch the local system only.\n"
        ;
       
       # Diagnostic message about RAC
       if(! $Command::LOCAL_NODE_ONLY ) {
          if(! $this_class -> shouldPropagateChange()  ) {
             if ( $actualNodeCount > 1 ) {
                 if ( $Command::IS_CFS == 1 ) {
                   # case 1
                   # shared home, will be patched as local only
                   $racMsg = $racMsgCase1;
                 } else {
                   # case 2
                   # (error case)
                   # print out node list + local node 
                   # msg to check cluster stack & verified with 'opatch lsinv'
                   # patch -> local system only
                   $racMsg = $racMsgCase2;
                }
             } elsif ( $actualNodeCount == 1 ) { 
                 # case 3
                 # msg to check node list & verified with 'opatch lsinv'
                 # print out node name
                 # patch -> local system only
                 $racMsg = $racMsgCase3;
             } elsif ( $actualNodeCount == 0 ) { 
                 # case 4
                 # msg to check node list & verified with 'opatch lsinv'
                 # patch -> local system only
                 $racMsg = $racMsgCase4;
             }
          } else { 
              # case 5
              # msg to print out node list + local node (ok case)
              $racMsg = $racMsgCase5;
          }
       } else { 
          # case 6
          # msg about -local (patch -> local system only) (ok case)
          $racMsg = $racMsgCase6;
       }
       
      $Command::RAC_MESSAGE = $racMsg;

}

sub isDebug() {
  if ( $Command::DEBUG eq "" ) {
    return 0;
  } else {
    return 1;
  }
}

sub is_CFS {
  if ( $Command::IS_CFS == 1 ) {
    return 1;
  } else {
    return 0;
  }
}


#
# return non-zero if bad arguments are supplied, expect callers to exit
#
sub isBadRetryDelaySemantics {
  
  if ( $Command::RETRY == 0 || $Command::DELAY == 0 ) {
    return 1;
  } else {
    $Command::RETRY_OPTION = "-Dopatch.retry=" . $Command::RETRY;
    $Command::DELAY_OPTION = "-Dopatch.delay=" . $Command::DELAY;
    return 0;
  }
}
#
# print out message about possible long delay due to 
#   inventory locking retry
#
sub warn_about_retry {
  
  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $f_handle = $$rh_arguments{f_handle};
  if ($Command::DELAY != 0 && $Command::RETRY != 0) {
    my $time = $Command::DELAY * $Command::RETRY;
    
    opatchIO -> print_message ({
        f_handle=> $f_handle,
        message => 
       "\nAccessing inventory ... " .
       "(retry $Command::RETRY times, delay $Command::DELAY seconds each time)\n"    
    });
  }
}

###############################################################
#
# Convert path /a/b/c to platform-dependent
#                         /a/b/c on Unix
#                        \\a\\b\\c
#
###############################################################
sub convert_path_separator {

  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $path = $$rh_arguments{path};
  if ( $OSNAME =~ m#Win32# ) {
    $path =~ s/\//\\/g;
  }
  return $path;
}
###############################################################
#
# Get current working dir., platform-independent
#
###############################################################
sub get_cwd {

  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $path = cwd();
  if ( $OSNAME =~ m#Win32# ) {
    $path =~ s/\//\\/g;
  }
  return $path;
}

###############################################################
#
# Check if a string terminated with "\n"
#
###############################################################
sub is_newline_terminated {

  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $string = $$rh_arguments{string};
  my $len = length ($string) - 1;
  my $last_char = substr($string, $len);
                        
  if ($last_char eq "\n") {
     return 1;
  } else {
     return 0;
  }
}
###############################################################
#
# Take a name and path to return path/name to be used
#   as a key to a hash table
#
###############################################################
sub encodeName {
  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $name = $$rh_arguments{name};
  my $path = $$rh_arguments{path};

  # big patch has lot of files
  # opatchIO->debug({ message => "encodeName(): $path, $name\n" });

  my $encodedName =  File::Spec -> catfile ($path, $name);
  return $encodedName;
}

###############################################################
#
# Take a encoded name and restore it back to the original
#    name
#
###############################################################
sub decodeName {
  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $encodedName = $$rh_arguments{encodedName};

  my $originalName = &File::Basename::basename ($encodedName);
  # big patch has lot of files
  # opatchIO->debug({ message => "decodeName(): $encodedName --> $originalName\n" });
  return $originalName;
}

###############################################################
#
# component_name: a component name to be checked if it's in the
#            'skip_components' list.  
# component_version: a component version to be check if it's in the
#            'skip_components' list.
#
# Both component_name & component_version are created by Perl's parsing
#            the 'actions' file.
#
# skip_components: a list of (optional) components which
#            should not be patched because the patching OH
#            does not have them installed.  And sine they
#            are optional comps., this won't be an error.
#            This list is built from Java output.
#
# NOTE:  This func. needs to be in sync with Java.  It expects
#   the component/version to be encoded with {} around it.
#   For example:
#
#      {oracle.rdbms,9.2.0.1.0} 
#
###############################################################
sub skipThisComponent {
  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $component_name = $$rh_arguments{component_name};
  my $component_version = $$rh_arguments{component_version};
  my $skip_components = $$rh_arguments{skip_components};
  
  my $searchItem = "$component_name,$component_version";
  
  opatchIO->debug({ message =>
           "skipThisComponent: Check whether to skip component \"$searchItem\""
    });
 
  foreach my $comp ( @$skip_components ) {
       
    opatchIO->debug({ message =>
           "skipThisComponent: comparing \"$searchItem\" (Perl) against \"$comp\" (Java)"
    });
    if ( $comp eq $searchItem ) {
        opatchIO->debug({ message =>
           "skipThisComponent: Search string matches, skip component.\n"
        });
        return 1;
    }
  }
  opatchIO->debug({ message =>
     "skipThisComponent: Do not skip component \"$searchItem\"\n"
  });
  return 0;
}
#############################################################################
#
# Check if a given option is set
#
#############################################################################
sub is_option_set {

       my $this_class   = shift @ARG;
       my $rh_arguments = $ARG[0];

       my $general_options = $$rh_arguments{general_options};
       my $option          = $$rh_arguments{option};

       if ( ($general_options & $option) == $option ) {
          return 1;
       } else {
          return 0;
       }
}
############################################################################
#
# Util. func. to query RAC state
#
############################################################################
sub shouldPropagateChange {


       my $this_class   = shift @ARG;
       opatchIO->debug({message=>"shouldPropagateChange():"});
       if ($Command::RAC_CODE == 1) {
           if ( $Command::IS_CFS == 1 ) {
             opatchIO->debug({message=>
                              " (RAC system of more than 1 node but " .
                              "CFS detected)\n" .
                              "  Propagate Change to other nodes: No\n"
                            });
             return 0;
           } elsif ($Command::LOCAL_NODE_ONLY) {
             opatchIO->debug({message=>
                              " (RAC system of more than 1 node but " .
                              "-local specified)\n" .
                              "  Propagate Change to other nodes: No\n"
                            });
             return 0;
           } else {
            opatchIO->debug({message=>
                             "  (RAC system of more than 1 node)\n" .
                             "  Propagate Change to other nodes: Yes\n"});
            return 1;
           }
       } elsif ($Command::RAC_CODE == 2) {
           opatchIO->debug({message=>
                "  (RAC system of only one node)\n" .
                "  Propagate Change to other nodes: No\n"});
           return 0;
       } elsif ($Command::RAC_CODE == 3) {
           opatchIO->debug({message=>
                "  (Cluster detected during installation but users " .
                "   had picked Non-Cluster Installation option for " .
                "   this Oracle Home)\n" .
                "  Propagate Change to other nodes: No\n"});
           return 0;
       } elsif ($Command::RAC_CODE == 0) {
           opatchIO->debug({message=>
               "  (not a RAC system)\n" .
               "  Propagate Change to other nodes: No\n"});
           return 0;
       } else {
           opatchIO->debug({message=>"  Unknown RAC_CODE\n"});
           return 0;
       }
}

############################################################################
#
# An inner java class might be a$b$c .... $k which causes problem
#  when invoking with qx/$command/
# This routine will take such a name and return a\$b\$c .... \$k
# If the given name doesn't have $, then the same name is returned
#
############################################################################
sub getInnerClassName {

      my $this_class   = shift @ARG;
      my $rh_arguments = $ARG[0];

      my $class_file      = $$rh_arguments{class_file};
      my $inner_class_file= "";
      
      if ( $class_file =~ m#\$# ) {
        my @list = split '\$', $class_file;
        foreach my $target ( @list ) {     
          if ( $inner_class_file eq "" ) {
            $inner_class_file = $target;
          } 
          else 
          {
            if ($OSNAME =~ m#Win32#)
            {
                $inner_class_file = $inner_class_file . "\$" . $target;
            }
            else
            {
                $inner_class_file = $inner_class_file . "\\\$" . $target;
            }
          }
        }
      }
      if ( $inner_class_file ne "" ) {
        return $inner_class_file;
      } else {
        return $class_file;
      }        
}

############################################################################
#
# This routine will receive a command as argument and:
#     If it's Unix, do nothing
#     If it's Windows, do
#               if $ENV{ACTIVE_STATE_PERL} is set to TRUE,
#                  do nothing
#               if $ENV{ACTIVE_STATE_PERL} is not set to TRUE,
#                  surround the command with extra "" using qq(") function
#
############################################################################
sub getDependentPerlCommand {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $system_command      = $$rh_arguments{system_command};

    my $processor = "$ENV{'PROCESSOR_IDENTIFIER'}";
    my $perlVersion = $];

    if ( $OSNAME =~ m#Win32# ) 
    {
      my $quotePerlCmd = $ENV{OPATCH_QUOTE_PERL_CMD};
      if( $quotePerlCmd eq "TRUE" ) {
        opatchIO->debug( { message => "OPATCH_QUOTE_PERL_CMD is set, so putting quotes." } );
        $system_command = qq(").$system_command.qq(");
      } elsif ( ( $processor !~ /ia64/ || $perlVersion == 5.00503) ) {
        my $activeStatePerl  = $ENV{ACTIVE_STATE_PERL};

        if ( $activeStatePerl eq "TRUE" ) {
           opatchIO->print_message({message=>"Remove extra quote surrounding system commands for Active state perl."});
        } elsif ( $perlVersion >= 5.008000 ) {
           opatchIO->print_message({message=>"Remove extra quote surrounding system commands for Perl >= 5.8.0."});
        } else {
             opatchIO->debug( { message => "Putting the quotes around the perl command." } );
             $system_command = qq(").$system_command.qq(");
        }
     }
    }
    return $system_command;
}

#############################################################################
#
# back up the Oracle Home comps.xml to  .patch_storage/<ID>
#
#############################################################################
sub backupCompsXML { 
    my $this_class = shift @ARG;
    my $rh_arguments = $ARG[0];
    
    my $Oracle_Home   = $$rh_arguments{Oracle_Home};
    my $patch_id      = $$rh_arguments{patch_id};
    my $fh_log_file   = $$rh_arguments{fh_log_file};
    my $target_name   = $$rh_arguments{target_name};
    my $target_filemap_name   = $$rh_arguments{target_filemap_name};
    
    # Back up comps.xml
    my $backupSource = File::Spec->catfile($Oracle_Home, "inventory", "ContentsXML", "comps.xml");
    my $backupTargetPath = File::Spec->catfile($Oracle_Home, ".patch_storage", "$patch_id");
    my $backupTargetName = $target_name;
    my $backupTarget = File::Spec->catfile($backupTargetPath, $backupTargetName);
    opatchIO -> print_message ( { f_handle => $fh_log_file,
                                  message  => "Back up \"$backupSource\" to \"$backupTarget\"\n" } );

    copy ($backupSource, $backupTarget);

    my $backup_filemap = $ENV{OPATCH_BACKUP_FILEMAP};
    if ( $backup_filemap eq "TRUE" )
    {
        # Backup filemap to .patch_storage
        $backupSource = File::Spec->catfile($Oracle_Home, "inventory", "filemap");
        $backupTargetPath = File::Spec->catfile($Oracle_Home, ".patch_storage", "$patch_id", $target_filemap_name);
        opatchIO -> print_message ( { f_handle => $fh_log_file,
                                      message  => "Back up \"$backupSource\" to \"$backupTargetPath\"\n" } );

        # Delete target if present
        if ( -e $backupTargetPath)
        {
            rmtree ([$backupTargetPath]);
        }

        $backupSource =~ s/\\/\//g;
        $backupTargetPath =~ s/\\/\//g;
        find
        (
            sub
            {
                my $targetdir = $File::Find::dir;
                my $target = $targetdir;
                $targetdir =~ s/$backupSource/$backupTargetPath/o;

                mkpath( $targetdir ) if not -e $targetdir;

                my $file = $_;
                my $source = "./" . $file;
                my $dest   = "$targetdir/$file";

                if ( -f $source ) 
                {
                    copy ($source, $dest);
                }
            },
            $backupSource
        );
    }
}

############################################################################
#
# Return the executable fuser with complete path.  If can't find, return
#   just "fuser" 
# order of path searched are:
#    /sbin/fuser  
#    /usr/sbin/fuser
#
############################################################################
sub getFuserCommand {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];
    
    my $fuser = "fuser";
    foreach my $command ( @Command::FUSER_SEARCH_PATH ) {
        if ( -x $command ) { 
          return $command
        }
    }

    return "fuser";    
}

###############################################################################
#
# NAME   : has_commands_in_path
#
# PURPOSE: Check if all required commands are in path
#
# INPUT: $$ARG[1] - list of commands to be checked
#
# OUTPUT:  1 all commands are in path
#          0 otherwise
#
##############################################################################
sub has_commands_in_path {

    my $this_class   = shift @ARG;
    my $commands = $ARG[0];

    # Check for Unix only
    if ( $OSNAME =~ m#Win32# ) {
       return 1;
    }

    my @tmp_command_list = split ' ', $commands;

    my $paths = $ENV{PATH};
    my @path_list = split ':', $paths;
    foreach my $check_command (@tmp_command_list) {
      my $found = 0;

      if ($check_command eq "fuser" ) {
        foreach my $command ( @Command::FUSER_SEARCH_PATH ) {
          if ( -x $command ) { 
            $found = 1;
          }
        }
      }
      
      if ( $found == 0 ) {
        foreach my $path (@path_list) {
          my $file = File::Spec -> catfile($path,$check_command);
          if ( -e $file ) {
            $found = 1;
          }
        }
      }
      
      if ( $found == 0 ) {
	     opatchIO -> print_message ({
	     message =>
              "OPatch can't find command \'$check_command\'."
         });
         return 0;
      }
    }

    return 1;
}

##########################################################################
#
# Get the "make" command in pre-defined path.  If it's not there,
#  look into PATH.  If still not there, return just "" to signal error.
# Windows doesn't have Make Actions, so just return "make" to avoid
#  error for callers
#
##########################################################################
sub getMakeCommand {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];
   
    # Look for env variable OPATCH_MAKE_COMMAND to use for make
    my $make_env_path = "";
    $make_env_path = $ENV{OPATCH_MAKE_COMMAND};
    if ( ($make_env_path ne "") && ( -e $make_env_path ) && ( -x $make_env_path ) )
    {
        opatchIO -> print_message ({ 
                        message => "Using environment variable OPATCH_MAKE_COMMAND = $make_env_path for make command\n" });
        return $make_env_path;
    }
 
    my $command = "";
    my $make    = "make";
    
    if ( $OSNAME =~ /Win32/ ) {
      return $make;
    } elsif ( $OSNAME eq "linux" ) {
      $command = File::Spec -> catfile ("", "usr", "bin", "$make" );
      if ( -x $command ) { 
        return $command;
      }
    } else {
      $command = File::Spec -> catfile ( "", "usr", "ccs", "bin", "$make" );
      if ( -x $command ) { 
        return $command;
      }
    }
    
    my $paths = $ENV{PATH};
    my @path_list = split ':', $paths;
    foreach my $path (@path_list) {
      $command = File::Spec -> catfile ( "$path", "$make" );
      if ( -x $command ) { 
        return $command;
      }
    }
    
    return "";    
}

##########################################################################
#
# Get the "ar" command in pre-defined path.  If it's not there,
#  look into PATH.  If still not there, return just "" to signal error.
# Windows doesn't have archive Actions, so just return "ar" to avoid
#  error for callers
#
##########################################################################
sub getArchiveCommand {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];
   
    # Look for env variable OPATCH_AR_COMMAND to use for ar
    my $ar_env_path = "";
    $ar_env_path = $ENV{OPATCH_AR_COMMAND};
    if ( ( $ar_env_path ne "" ) && ( -e $ar_env_path ) && ( -x $ar_env_path ) )
    {
        opatchIO -> print_message ({ 
                        message => "Using environment variable OPATCH_AR_COMMAND = $ar_env_path for ar command\n" });
        return $ar_env_path;
    }
 
    my $command = "";
    my $ar    = "ar";
    
    if ( $OSNAME =~ /Win32/ ) {
      return $ar;
    } elsif ( $OSNAME eq "linux" ) {
      $command = File::Spec -> catfile ("", "usr", "bin", "$ar" );
      if ( -x $command ) { 
        return $command;
      }
    } else {
      $command = File::Spec -> catfile ( "", "usr", "ccs", "bin", "$ar" );
      if ( -x $command ) { 
        return $command;
      }
    }
    
    my $paths = $ENV{PATH};
    my @path_list = split ':', $paths;
    foreach my $path (@path_list) {
      $command = File::Spec -> catfile ( "$path", "$ar" );
      if ( -x $command ) { 
        return $command;
      }
    }
    
    return "";
}


##########################################################################
#
# Write to OH/.patch_storage/<ID>/rolledbackpatches.txt a list of patch IDs
# that are rolled back as a result of applying this patch.
#
# Each line in the file contains the rolled back patch ID
#
##########################################################################
sub generateRollbackedPatches {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home    = $$rh_arguments{Oracle_Home};
    my $patch_id       = $$rh_arguments{patch_id};
    my $patch_list     = $$rh_arguments{patch_list};
    
    my @list = split (" ", $patch_list);
   
    my $fileName = "rolledback_patches.txt";
    my $targetFile = File::Spec->catfile($Oracle_Home, ".patch_storage", "$patch_id", "$fileName" );

    # First remove the file if it's there
    if ( -e $targetFile ) {
       unlink $targetFile;
    }
    
    opatchIO->print_message({ message=>"Creating temporary file $targetFile" });
    open ( RB_PATCHES, ">$targetFile" );
    
    opatchIO -> print_message ( { 
        f_handle => *RB_PATCHES,
        message  => "# This file contains a list of patch IDs being rolled back\n" .
                    "# as a result of applying this patch $patch_id.\n" .
                    "# Do not modify the content of this file." 
    } );

    my $fileWritten = 0;
    foreach my $patch ( @list ) { 
      # Do not write the same patch ID (when p1 is applied on top p1)
      next if ( $patch eq $patch_id );
      opatchIO -> print_message ( { 
          f_handle => *RB_PATCHES,
          message  => "$patch" 
      } );
      my $fileWritten = 1;
    }
    
    close RB_PATCHES;
    
    # If the file has no entry, then remove it.  This happens when
    # the patch list has only 1 element with ID identical to this $patch_id.
    # In other words, if we apply P1 on top of P1, no file will be created.
    if( !$fileWritten ) { 
      unlink $targetFile;
    }
    return "";    
}

##########################################################################
#
# Read from OH/.patch_storage/<ID>/rolledbackpatches.txt to get a list 
# of patch IDs that are rolled back as a result of applying this patch, then
# print out to user the list.
#
# Each line in the file contains the rolled back patch ID
# Do nothing (no output to stdout) if the file doesn't exist
#
# Return 0 if the file is not there (no roll backs happend when we applied
#   this patch $patch_id)
# Return 1 if the file exists (there were roll backs of sub-set patches
#   when we applied this patch $patch_id)
#
##########################################################################
sub printRollbackedPatches {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home    = $$rh_arguments{Oracle_Home};
    my $patch_id       = $$rh_arguments{patch_id};
    my $fh_log_file    = $$rh_arguments{f_handle};
    
    my $fileName = "rolledback_patches.txt";
    my $targetFile = File::Spec->catfile($Oracle_Home, ".patch_storage", "$patch_id", "$fileName" );
        
    local *RB_PATCHES;
    open ( RB_PATCHES, $targetFile ) or do {
          return 0;
    };
    my @file_data = <RB_PATCHES>;
    close RB_PATCHES;
    
    opatchIO->print_message_noverbose ({
        f_handle => $fh_log_file,
        message  => "You should apply the following patches because they were " .
                    "rolled back when you applied this patch $patch_id:\n" 
    });
    
    foreach my $line ( @file_data ) {
      # Strip out comments and blank lines.
      next if ( $line =~ m/^#/ );
      next if ( $line =~ m/^\s+#/ );
      next if ( $line =~ m#^$# );
      
      opatchIO->print_message_noverbose ({
        f_handle => $fh_log_file,
        message  => "Patch ID $line"
      });
    }
    
    return 1;
}

###############################################################
#
# Return 1 if the Oracle Home has executable OH/jdk/bin/jar
#
###############################################################
sub hasOracleHomeJdkBinJar {
  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $Oracle_Home = $$rh_arguments{Oracle_Home};

  my $jarDir =  File::Spec -> catfile ($Oracle_Home,
                                    "jdk",
                                    "bin");
  my $jar = File::Spec -> catfile ($jarDir, "jar");
  if ($OSNAME =~ m#Win32#) {
      $jar = File::Spec -> catfile ($jarDir, "jar.exe");
  }
  
  if ( -e $jar ) {
    return 1;
  } else {
    return 0;
  }
}

#############################################################################
#
# pause and tell user to hit any key to continue, used for debugging.
#   output goes to stdout only -- not log file
#
#############################################################################
sub pause {
   print "Please press enter to continue...\n";

   # Flush the stdout first
   select(STDOUT);
   $|=1;

   my $reply = uc <STDIN> || "";
  
   # TurnOff the autoflush.
   $|=0;
}

############################################################################
#
# Method to replace all OH with PatchDir in the given string. 
# All 3 arguments are passed to this.
# 1) OracleHome
# 2) Patch directory
# 3) path in which the change is to be made.
# 
# Return the changed string.
#
############################################################################
sub replace_oh_with_patchdir {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $Oracle_Home  = $$rh_arguments{Oracle_Home};
    my $patch_dir    = $$rh_arguments{patch_dir};
    my $target_path  = $$rh_arguments{target_path};

    $Oracle_Home = $this_class -> get_abs_path( { Path => $Oracle_Home } );
    $patch_dir = $this_class -> get_abs_path( { Path => $patch_dir } );

    $target_path = File::Spec -> catfile ( $patch_dir,
                                   substr($target_path, length($Oracle_Home)));

    return $target_path;

}
############################################################################
#
# Method to replace path with its absolute path.
# 
# Return the changed string.
#
############################################################################
sub get_abs_path {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $local_path  = $$rh_arguments{Path};

    if( $local_path eq "")
    {
	return $local_path;
    }
    $local_path = Cwd::abs_path($local_path);
    
    if (  $OSNAME  =~  m#Win32# ) {
       $local_path =~ s/\//\\/g;
    }
    return $local_path;
}
############################################################################
#
# Method to start the cleaning of the inventory.
# 
#
############################################################################
sub clean_up_inventory {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $OracleHome  = $$rh_arguments{Oracle_Home};
    my $fh_log_file       = $$rh_arguments{fh_log_file};

    my $compsXML = File::Spec -> catfile ("$OracleHome", "inventory", "ContentsXML", "comps.xml");
    my $ohFileMapDirectory = File::Spec -> catfile ("$OracleHome", "inventory", "filemap");

    # Initialise the variables, as they will not be empty during if there is a auto-rollback.
    $FILEMAP_SET = "";
    %FILEMAP_CACHED = ();
    $COMPS_XML_SET = "";

    #-----------------------------------------------------
    # Create the filemapSet by executing the  "xargs" cmd, then
    #   parse the output file
    #------------------------------------------------------
    my $result = $this_class -> createThenParseGrepOutputFile( { fh_log_file => $fh_log_file,
		 	    				Oracle_Home => $OracleHome, 
                        	        	        ohFileMapDirectory => $ohFileMapDirectory } );
    if( $result ) {
	return $result;
    }

    #---------------------------
    # Create the compsxmlSet
    #---------------------------
    $result = $this_class -> parseCompsXML ( { CompsXML => $compsXML } );
    if( $result ) {
	return $result;
    }

    # Remove duplicates in both COMPS_XML_SET and FILEMAP_SET
    $this_class -> removeDuplicateInSet ();

    # Check for dangling patches in filemap, then repair
    # (this will take care of patches exist in FILEMAP_SET but not in COMPS_XML_SET)
    $result = $this_class -> removeDanglingPatchesInFileMap ( { f_handle => $fh_log_file } );
    if( $result ) {
	return $result;
    }
    
    return 0;
}

################################################################################
#
# Invoke the "grep" command and re-direct output to a file
#
# IN:
#   ohFileMapDirectory
# OUT:
#   FILEMAP_SET
#   FILEMAP_CACHED
#   exit if error
#
################################################################################
sub createThenParseGrepOutputFile {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $OracleHome  = $$rh_arguments{Oracle_Home};
    my $fh_log_file       = $$rh_arguments{fh_log_file};
    my $ohFileMapDirectory = $$rh_arguments{ ohFileMapDirectory };

    # Prepare a file to hold the output of
    #   all entries containing "oneoffs" under OH/inventory/filemap
    my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst )
                                                         = localtime ( time() );
    $year = $year + 1900;
    # There is no month "zero" to people.
    $mon++;
    if ( $mon < 10 ) { $mon = "0" . $mon; }
    if ( $mday < 10 ) { $mday = "0" . $mday; }

    my $time_tag = "$mon" . "-" . "$mday" . "-" . "$year" . "_" .
                     "$hour" . "-" . "$min" . "-" . "$sec";
    my $name2 = "checkinv_filemap_oneoff" .
                "$time_tag" . ".txt";

    my $patchStorage = File::Spec -> catfile("$OracleHome", ".patch_storage", "tmp");
    my $grepOutputFile =  File::Spec -> catfile ("$patchStorage", "", "$name2");
    opatchIO->print_message({ f_handle => $fh_log_file, message => "Creating temporary file \"$grepOutputFile\" ...\n"} );

    # Open OH/.patch_storage, create if it doesn't exist
    opendir(DIRHANDLE, $patchStorage) or mkdir($patchStorage, 0755) or opatchIO->print_message_noverbose( { 
										message => "couldn't create $patchStorage dir" } );

    # Open the temp file
    open(OF, ">$grepOutputFile") or opatchIO->print_message_noverbose( {
						message =>  "couldn't open $grepOutputFile\n" } );

    # Set the search patterns
    $search_pattern = "oneoff";
    $file_pattern = "map\$";

    # Do the Find.
    find( \&grepTheFindOutput, $ohFileMapDirectory);

    close OF;

    # Exit if output file doesn't exist
    if ( ! -e $grepOutputFile ) {
      opatchIO->print_message( { f_handle => $fh_log_file, message => "Cannot redirect output to \"$grepOutputFile\", exiting...\n"} );
      return 1;
    }
    # Read the $filemapFile containing output of "grep" for "oneoff"
    #
    # Entry will have the form
    # $fileMap/<path>/files.map:<someObjectName>::{"oneoff","1"},...
    # We need to extract the "1" out
    #
    opatchIO->print_message( { message => "Reading \"$grepOutputFile\"\n" } );
    local *FILEMAP;
    open ( FILEMAP, $grepOutputFile ) or do {
      opatchIO->print_message( { f_handle => $fh_log_file, message => "Cannot open the file \"$grepOutputFile\" to read, exiting\n" } );
      return 1;
    };

    while (my $line = <FILEMAP>) {
      # Search for '::{"oneoff","2664932"}'
      # If the line doesn't contain "oneoff"
      next, if !($line =~ /{"oneoff",/);

      # The entry has the form
      #   FILE_PATH:NAME::ONEOFF
      #     where ONEOFF is '{"oneoff","2664932"},'      OR
      #   FILE_PATH:NAME::{"component","oracle.rdbms.dbscripts","9.2.0.1.0"},..,
      #     ONEOFF
      #
      #  sample entry in file:
      #       /kkm.o::{"oneoff","3557842"},   OR
      #       prvtreut.plb::{"component","oracle.rdbms.dbscripts","9.2.0.1.0"}, \
      #         {"component","oracle.rdbms.dbscripts","9.2.0.2.0"}, \
      #         {"patch","oracle.rdbms.dbscripts","9.2.0.5.0"}, \
      #         {"oneoff","4567"},{"component","oracle.foo"},
      my @list = split $D_COLON, $line;
      my $list_len = @list;
      if( $list[$list_len - 1] eq "")
      {
          next;
      }
      my $list_itr = 1;
      my $filePart = $list[0];
      for( $list_itr = 1; $list_itr <= $list_len - 2; $list_itr ++) # To rebuild the file part
      {
           $filePart = $filePart.$D_COLON.$list[$list_itr];
      }
      my $oneOffPart = $list[$list_len - 1]; #$list_len - 1 is the last element of the list.

      @list = split(/[{}, "]/, $oneOffPart);

      # clean up the list for empty elements
      my $listi = 0;
      my $listlen = @list;
      while ($listi < $listlen)
      {
          if ($list[$listi] eq "")
          {
              splice(@list, $listi, 1);
              $listlen = @list;
          }
          else
          {
              $listi ++;
          }
      }

      my $list_count = -1;
      foreach my $list_elem (@list)
      {
          $list_count ++;
          if ($list_elem ne "oneoff") {next;}

          my $patchID = $list[$list_count+1];

          $FILEMAP_SET .= "$patchID ";

          my @listnew = split $BANG, $filePart;
          my $fileName = $listnew[0];
          my $entryName= $listnew[1];

          $FILEMAP_CACHED{$patchID} .= "$entryName$COMMA$fileName$BANG";
      }

    }
    close FILEMAP;
    return 0;

}# end of createThenParseGrepOutputFile

################################################################################
#
# Remove duplicates in sets
#
################################################################################
sub removeDuplicateInSet {

  my %map = ();
  my @patches = split ( " ", $COMPS_XML_SET );
  foreach my $target ( @patches ) {
    $map{$target} = $target;
  }
  $COMPS_XML_SET = "";
  foreach my $target (sort keys %map ) {
    $COMPS_XML_SET .= "$target ";
  }
  %map = ();
  @patches = split ( " ", $FILEMAP_SET );
  foreach my $target ( @patches ) {
    $map{$target} = $target;
  }
  $FILEMAP_SET = "";
  foreach my $target (sort keys %map ) {
    $FILEMAP_SET .= "$target ";
  }
}# end of removeDuplicateInSet

################################################################################
#
# Check for dangling filemap entries.  Make back up then repair the file.
#
#   OUT:
#        modify files under OH/inventory/filemap/.../files.map
#
################################################################################
sub removeDanglingPatchesInFileMap {

  my $this_class   = shift @ARG;
  my $rh_arguments = $ARG[0];

  my $OracleHome  = $$rh_arguments{Oracle_Home};
  my $fh_log_file       = $$rh_arguments{fh_log_file};

  my @filemapIDs = split (" ", $FILEMAP_SET );
  my @compsIDs   = split (" ", $COMPS_XML_SET );
  my $DANGLING_IDS = "";
  my $hasDangling = 0;
  # build a list of dangling patches that must be cleaned up
  foreach my $fID ( @filemapIDs ) {
    my $found = 0;
    foreach my $cID ( @compsIDs ) {
       opatchIO->print_message( { f_handle => $fh_log_file, message => "comparing $fID and $cID\n" } );
       if ($cID eq $fID) {
          $found = 1;
          #break;
       }
    }
    if ( ! $found ) {
      $DANGLING_IDS .= "$fID ";
      $hasDangling = 1;
    }
  }

  # Now we have a list of dangling patches that must be cleaned.
  # Let's save all the files first, then create a list called
  #   filesToClean.   This list will contain files that every entry
  #   with the word "oneoff" must be removed.
  my $FILES_TO_CLEAN  = "";
  my $FILES_TO_BACKUP = "";

  if ( $hasDangling == 0 ) {
      opatchIO->print_message_noverbose( { message => "\n\nInventory is good and does not have any dangling patches.\n" } );
      return 0;
  } else {
      opatchIO->print_message_noverbose( { message => "\n\nOPatch detected dangling patch filemaps in the inventory. It will" } );
      opatchIO->print_message_noverbose( { message => "clean up the inventory so that you can apply/rollback a patch successfully.\n" } );
      opatchIO->print_message( { f_handle => $fh_log_file, 
				 message => "First, it will back up files that it's going to modify, then it will remove " } );
      opatchIO->print_message( { f_handle =>$fh_log_file,
				 message => "bad entries in the filemap.\n" } );
      opatchIO->print_message( { f_handle => $fh_log_file, 
				 message => "\nThis is a list of dangling patches in your filemap which must be cleaned up:\n"} );
      opatchIO->print_message( { f_handle => $fh_log_file, 
				 message => "[ " } );
      my @patches = split ( " ", $DANGLING_IDS );
      foreach my $target ( @patches ) {
        opatchIO->print_message( { f_handle => $fh_log_file, message => "$target " } );
      }
      opatchIO->print_message ( { f_handle => $fh_log_file, message => "]\n\n" } );
      # Create timestamp to back up files
      my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst )
                                                 = localtime ( time() );
      $year = $year + 1900;
      $mon++;
      if ( $mon < 10 ) { $mon = "0" . $mon; }
      if ( $mday < 10 ) { $mday = "0" . $mday; }

      my $time_tag = "$mon" . "-" . "$mday" . "-" . "$year" . "_" .
                       "$hour" . "-" . "$min" . "-" . "$sec";

      foreach my $target ( @patches ) {
        foreach my $cID (sort keys %FILEMAP_CACHED ) {
          if( $target eq $cID ) {
            my $entries = $FILEMAP_CACHED{$cID};
            my @list = split ( $BANG, $entries );
            foreach my $entry ( @list ) {
              my @subList = split ( $COMMA , $entry );
              my $entryName = $subList[0];
              my $fileName = $subList[1];
              $FILES_TO_BACKUP .= "$fileName$COMMA";
            }
          }
        }
      }

      #
      # First, remove duplicates in list of files to back up
      my %map = ();
      my @list = split ( $COMMA, $FILES_TO_BACKUP );
      foreach my $target ( @list ) {
        $map{$target} = $target;
      }
      $FILES_TO_BACKUP = "";
      foreach my $target (sort keys %map ) {
        $FILES_TO_BACKUP .= "$target$COMMA";
      }

      #
      # Back up files, exit if error
      #
      my @list = split ( $COMMA, $FILES_TO_BACKUP );
      my $count = 0;
      foreach my $fileName ( @list ) {
          # Back up file, exit if backup fails
          $count++;
          my $backupName = $fileName . "." . "$time_tag";
          opatchIO->print_message ( { f_handle => $fh_log_file, message => "Backing to \"$backupName\" ($count)\n" } );

          copy ($fileName, $backupName);
          if ( ! -e $backupName ) {
             opatchIO->print_message ( { f_handle => $fh_log_file, 
					message => "ERROR: cannot back up file \"$fileName\" to \"$backupName\", exiting.\n" } );
             return 1;
          } else {
            $FILES_TO_CLEAN .= "$fileName$COMMA";
          }
      }
      # Remove entry in each file: use the backup file to read,
      #   then write to the org. file
      my $result = 0;
      $result = removeEntryInFile ( $FILES_TO_CLEAN, $DANGLING_IDS );
      return $result;
    }
}# end of removeDanglingPatchesInFileMap

###############################################################################
#
# Given a list of file names.  Just blindly remove all entries in each
#   file that has the word "oneoff" as follow:
#      - if the line contains just "oneoff" and no "component", remove the whole
#           line (case 1 below)
#      - if the line contains both "oneoff" and "component", remove the
#           "oneoff" part only (case 2 below)
#
# IN:
#   $FILES_TO_CLEAN
#
#  sample entry in file:
#       /kkm.o::{"oneoff","3557842"}, (case 1)
#       prvtreut.plb::{"component","oracle.rdbms.dbscripts","9.2.0.1.0"}, \
#         {"component","oracle.rdbms.dbscripts","9.2.0.2.0"}, \
#         {"patch","oracle.rdbms.dbscripts","9.2.0.5.0"}, \
#         {"oneoff","4567"},{"component","oracle.foo"}, (case 2)
#
###############################################################################
sub removeEntryInFile  {

  my $fileList = @_[0];
  my $DANGLING_IDS = @_[1];
  my @filesToClean = split ( $COMMA, $fileList );
  my @patches = split (" ", $DANGLING_IDS);

  # clean up the filesToClean for empty elements
  my $listi = 0;
  my $listlen = @filesToClean;
  while ($listi < $listlen)
  {
      if ($filesToClean[$listi] eq "")
      {
          splice(@filesToClean, $listi, 1);
          $listlen = @filesToClean;
      }
      else
      {
          $listi ++;
      }
  }

  # clean up the patches for empty elements
  my $listi = 0;
  my $listlen = @patches;
  while ($listi < $listlen)
  {
      if ($patches[$listi] eq "")
      {
          splice(@patches, $listi, 1);
          $listlen = @patches;
      }
      else
      {
          $listi ++;
      }
  }

  my $len = scalar ( @filesToClean );
  if ( $len == 0 ) {
    opatchIO->print_message_noverbose( { message => "\nList of files to be removed is empty.  Nothing to do...\n" } );
    return 0;
  }

  my $count = 0;
  foreach my $file ( @filesToClean ) {
    $count++;
    opatchIO->print_message( { message => "Cleaning \"$file\" ($count)\n" } );
    #
    # Open the file to read/write
    #
    local *FILE;
    open ( FILE, "$file" ) or do {
      opatchIO->print_message( { message => "Cannot open the file \"$file\" to read, exiting\n" } );
      return 1;
    };
    #
    # Read its content into memory
    #
    my @fileData = <FILE>;
    my $len = scalar ( @fileData );
    #
    # Loop thru each line
    #
    for ( my $i = 0; $i < $len; $i++ ) {
      my $line = $fileData[$i];
      #
      # print "line = $line";
      #
      # Write the line back to the file if the line doesn't contain the
      #   word "oneoff"
      if ($line =~ /{"oneoff",/) {
        #
        # This line contains the word "oneoff"
        #
        my @list = split $D_COLON, $line;
        my $list_len = @list;
        if( $list[$list_len - 1] eq "")
        {
            next;
        }
        my $list_itr = 1;
        my $filePart = $list[0];
        for( $list_itr = 1; $list_itr <= $list_len - 2; $list_itr ++) # To rebuild the file part
        {
             $filePart = $filePart.$D_COLON.$list[$list_itr];
        }
        my $oneOffPart = $list[$list_len - 1]; #$list_len - 1 is the last element of the list.

        chomp $filePart;
        chomp $oneOffPart;

        # split the oneOffPart again to get a list of "oneoff", "component"
        #  or "patch"
        #
        @list = split (/[,{} ]/, $oneOffPart);

        # clean up the list for empty elements
        my $listi = 0;
        my $listlen = @list;
        while ($listi < $listlen)
        {
            if ($list[$listi] eq "")
            {
                splice(@list, $listi, 1);
                $listlen = @list;
            }
            else
            {
                $listi ++;
            }
        }

        $listi = 0;
        $listlen = @list;

        #
        # create a temporary line
        #
        my $tmpLine = $filePart . $D_COLON;
        my $lineHasOnlyOneoffObj = 1;
        #
        # loop thru each object in the line
        #

        while ($listi < $listlen)
        {
          my $object = $list[$listi];

          if ($object eq "\"oneoff\"")
          {
            # Search for dangling patch
            my $found = 0;

            # Loop to search in the array @patches
            foreach my $patch_elem (@patches)
            {
                if ($list[$listi+1] eq "\"$patch_elem\"")
                {
                    $found = 1;
                    last;
                }
            }

            if (!$found)
            {
                $lineHasOnlyOneoffObj = 0;
                $tmpLine = $tmpLine . "{" . $list[$listi] . "," . $list[$listi+1] . "},";
            }
            $listi += 2;
            next;
          }
          if ($object eq "\"patch\"")
          {
            # write it back
            $lineHasOnlyOneoffObj = 0;
            $tmpLine = $tmpLine . "{" . $list[$listi] . "," . $list[$listi+1] . "," . $list[$listi+2] . "},";
            $listi += 3;
            next;
          }
          if ($object eq "\"component\"")
          {
            # write it back
            $lineHasOnlyOneoffObj = 0;
            $tmpLine = $tmpLine . "{" . $list[$listi] . "," . $list[$listi+1] . "," . $list[$listi+2] . "},";
            $listi += 3;
            next;
          }
          $listi ++;
        } # for each object in the line
        #
        # write the modified line back to the file
        #
        if ( $lineHasOnlyOneoffObj ) {
          # do not write the line back, similar to removing this line from file
          # print " - remove this line $line";
          $fileData[$i] = "";
        } else {
          $tmpLine = $tmpLine . "\n";
          $fileData[$i] = $tmpLine;
        }
      } else {
        #
        # This line doesn't have the word "oneoff", write it back.
        #
        $fileData[$i] = $line;
      } # else (the line contains "oneoff" object
    } # for each line in the file
    #
    # Close the file, open it again to write, write modified content
    #  in memory, then close
    #
    close ( FILE );
    open ( FILE, ">$file" ) or do {
      opatchIO->print_message_noverbose( { message =>  "Cannot open the file \"$file\" to write, exiting\n" } );
      return 1;
    };
    print FILE @fileData;
    close ( FILE );
  } # for each file in the list
  return 0;
}

################################################################################
# Grep the find output and put it in $grepOutputfile
# IN:
#   Find output(filenames)
#   search_pattern
#   file_pattern
# OUT:
#   grepOutputfile
################################################################################
sub grepTheFindOutput {

  my $file = $File::Find::name;

  $file =~ s,\\,/,g;

  return unless -f $file;
  return  unless $file =~ /$file_pattern/;

  open F, $file or opatchIO->print_message_noverbose( { message => "couldn't open $file\n" } );

  while (<F>) {
    if (my ($found) = m/($search_pattern)/o) {
                my $substring = "$`"."$found"."$'";
                print OF "$file".$BANG."$substring";
      }
  }

  close F;
}

################################################################################
#
# Parse the comps.xml
#
#   IN:
#     compsXML
#   OUT:
#     COMPS_XML_SET
#
#
################################################################################
sub parseCompsXML {
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $compsXML  = $$rh_arguments{CompsXML};

    local *CONTENTS_XML;
    open ( CONTENTS_XML, $compsXML ) or do {
      opatchIO->print_message_noverbose( { mssage => "Cannot open the file \"$compsXML\" to read, exiting\n" } );
      return 1;
    };
    # Begin parsing comps.xml
    while (my $line = <CONTENTS_XML>) {
      # Search for '<ONEOFF REF_ID='
      # If the line doesnt describe a component then skip it.
      next, if !($line =~ /^<ONEOFF REF_ID=/);

      # Get the component name and the install location
      my ($patchID, $rollbackable, $installedTime) =
      ($line =~ /^<ONEOFF REF_ID="(.*)" ROLLBACK="(.*)" XML_INV_LOC=.*INSTALL_TIME="(.*)"/);

      # print "Patch $patchID installed on $installedTime\n";
      $COMPS_XML_SET .= "$patchID ";
    }
    close CONTENTS_XML;
    return 0;
}

#############################################################################
#
# To do live printing.
#
# Inputs:
#    system command to run
#    level : 0 - debug
#            1 - verbose
#            2 - non-verbose
#    log file
#
#############################################################################
sub run_cmd_print_live {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $system_command  = $$rh_arguments{sys_command};
    my $level = $$rh_arguments{level};
    my $fh_log_file = $$rh_arguments{f_handle} || "";

    #Live printing.
    my $sys_call_result = "";
    open(READ, "$system_command 2>&1 | ");
    while (<READ>) {
         if ( $level == 0 ) {
	         opatchIO->debug({ message => "$_" } );
         } elsif ( $level == 1 ) {
		     if ( $fh_log_file eq "" ) {
		         opatchIO->print_message({ message => "$_" } );
		      } else {
		         opatchIO->print_message({ f_handle => $fh_log_file, message => "$_" } );
                      }
         } else {
	         opatchIO->print_message_noverbose({ message => "$_" } );
         }
         $sys_call_result = $sys_call_result . $_ ;
    }
    close(READ);

    return $sys_call_result;
}

############################################################################
# Method to escape $ character in the filename.
#
#
############################################################################
sub escape_special_chars {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $name  = $$rh_arguments{name};
    my $begins_with_dollar = 0;

    if ( $OSNAME !~ m#Win32# ) {

        #If not windows, escape the $ character in the path
        #But here there is a issue, the path will have $OH in it,
        #which should not be modified. So we replace all occurances
        #of $ by \$, then if the string starts with $, then just
        #replace first occurance of \$ with $.

        if( $name =~ m/^\$/ ) {
           $begins_with_dollar = 1;
        }

        $name =~ s/\$/\\\$/g;

        if( $begins_with_dollar ) {        
           $name =~ s/\\\$/\$/;
        }

    }
    return $name;    
}

############################################################################
# Method to verify the patch apply.
#
#
############################################################################
sub verify_patch {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $fh_log_file       = $$rh_arguments{fh_log_file};
    my $Oracle_Home       = $$rh_arguments{Oracle_Home};
    my $patch_id          = $$rh_arguments{patch_id};
    my $patch_location    = $$rh_arguments{patch_location};
    my $no_inv_update     = $$rh_arguments{no_inventory};

    my $rh_OUI_file_names = $$rh_arguments{rh_OUI_file_names};

    my $path_to_java = $$rh_OUI_file_names{path_to_java};

    # Set-up the Java class for the inventory update.
    my $rh_java_paths = $this_class -> make_java_paths ( {
                                Oracle_Home       => $Oracle_Home,
                                rh_OUI_file_names => $rh_OUI_file_names } );

    my $class_path = $$rh_java_paths{class};
    my $oui_path   = $$rh_java_paths{oui_path};

    my $debug = $Command::DEBUG;

    my $local_node_only_flag = "";
    if(! $this_class -> shouldPropagateChange() ) {
        $local_node_only_flag = "-Dopatch.local_node_only";
    }
    my $local_node_name_flag = "";
    if ($Command::LOCAL_NODE_NAME_MODE) {
        $local_node_name_flag = "-Dopatch.local_node_name=$Command::LOCAL_NODE_NAME";
    }

    my $is_shared_flag = "";
    # User wanna turn off CFS detection?
    #    OPATCH_IS_SHARED = true   -> CFS=true, no detect
    #                       false        =false, no detect
    #                       detect       =<detected value>, yes detect
    #                       not set      =false, no detect
    if ($Command::OPATCH_IS_SHARED eq "TRUE") {
        $is_shared_flag = "-Dopatch.is_shared=true";
                    opatchIO -> print_message ( {
                         message => "No CFS detection, CFS set to true."
                  });
    } elsif ( $Command::OPATCH_IS_SHARED eq "FALSE" ) {
        $is_shared_flag = "-Dopatch.is_shared=false";
                    opatchIO -> print_message ( {
                         message => "No CFS detection, CFS set to false."
                  });
    } elsif ( $Command::OPATCH_IS_SHARED eq "DETECT" ) {
        $is_shared_flag = "-Dopatch.is_shared=detect";
                    opatchIO -> print_message ( {
                         message => "PerformCFS detection, CFS set to detected value."
                  });
    } elsif ( $Command::OPATCH_IS_SHARED eq "" ) {
        $is_shared_flag = "";
        # Env. variable OPATCH_IS_SHARED is not set, so ignore it.
    } else {
        $is_shared_flag = "";
                    opatchIO -> print_message ( {
                         message => "Unknown OPATCH_IS_SHARED value, no CFS detection, CFS set to false."
                  });
    }


    #
    # Run VerifyPatch to make sure copy/jar/archive actions are performed and comps.xml has 
    #   been updated with patch ID
    #
      opatchIO->print_message_noverbose({message =>
                "\nVerifying patch..."
      });
      my $archive_command = $this_class->getArchiveCommand();
      my $class_to_run = "opatch/VerifyPatch";
      my $system_command = "$path_to_java $local_node_only_flag " .
                       "$is_shared_flag " .
                       "$local_node_name_flag " .
                       "$Command::inventory_location_ptr " .
                       $debug .
                       "$class_path $class_to_run " .
                       "\"$Oracle_Home\" $oui_path " .
                       "$patch_location $patch_id " .
                       "$archive_command " .
                       $no_inv_update;
      
      $system_command = $this_class->getDependentPerlCommand({ 
                           system_command => $system_command });

      # If log file is empty, then it would have already come on screen.
      if( $fh_log_file ne "" ) {
            opatchIO -> print_message ({ f_handle => $fh_log_file,
                                 message  => "\nSystem Command: $system_command"  
            });
            opatchIO -> print_message ( { f_handle => $fh_log_file,
                                 message  => "\nResult:\n" 
            } );
      }

      my $sys_call_result = $this_class -> run_cmd_print_live ( { 
                                            sys_command => $system_command,
                                            level => 2,
                                            f_handle => $fh_log_file } );

      # $sys_call_result = qx/$system_command/;
      #my $status = $this_class -> get_child_error ( {
      #      CHILD_ERROR     => $CHILD_ERROR
      #} );

      chomp $sys_call_result;
   
      # Find if there is any error.
      my @result = split ( /\n/, $sys_call_result );

      my $error = 0;
      foreach my $line ( @result ) {
          if ( $line =~ m#OPATCH_JAVA_ERROR# ) {
             $error = 1;
          }
      }

      my $lock_file_errors = $this_class -> free_the_lock_file ( {
                                        Oracle_Home     => $Oracle_Home,
                                        patch_id        => $patch_id } );
 

      # Error out if verification fails.
      if( $error ) {
          opatchIO -> print_message_and_die( {
                    exit_val => $this_class -> ERROR_CODE_VERIFY_FAILURE ,
                    message => "Verification of the patch failed."
          } );         
      }

}
############################################################################
# Method to recursively change the directory/file permissions
#
# It works on the current directory.
############################################################################
sub change_perm_recursive {

    my $entity = "";

    opendir(DIRHANDLE, ".") || return;
    my @filelist = readdir(DIRHANDLE);

   
    foreach $entity (@filelist) {
        if($entity ne "." && $entity ne "..") {
           my $mode = (stat($entity))[2];

           # mode will be in octal but will of 5 digits, 1- unused
           # 2- user, 3- grp, 4-others
           # hence we say 07770, octal, unused, user, grp, others.
           $mode = $mode & 07770;
           chmod $mode, $entity;
       }
    }

    foreach $entity (@filelist) {
	if (-d $entity && $entity ne "." && $entity ne "..") {
	    chdir $entity;
	    &change_perm_recursive(); 
	    chdir ".."; 
	}
    }
}

#############################################################################
# Perl packages need to return a true value.
1;
#############################################################################
