#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#    Version.pm
#
#    DESCRIPTION
#    This file contains the methods for the version command to opatch.
#
#    NOTES
#
#    BUGS
#    * <if you know of any bugs, put them here!>
#
#    MODIFIED   (MM/DD/YY)
#    phnguyen    01/21/05 - 
#    shgangul    01/05/05 - Improve the version display 
#    dsaha       12/10/04 - change release date to Dec 10 
#    phnguyen    12/05/04 - Release after merging with Shamik
#    phnguyen    10/14/04 - Add debug for release date
#       shgangul 09/11/03 - Logging changes for 10G 
#       phnguyen 08/28/03 - phnguyen_installable 
#       daevans  02/11/03 - daevans_relocate_directories
#    daevans     08/05/02  Version update.
#    daevans     03/12/01  Inital code.
#
##########################################################################

###############################################################################
###############################################################################
#
#  ------------------------ INITIALIZATION ------------------------
#
###############################################################################
###############################################################################

package Version;
@ISA = ("Command");

######
#
# Standard modules:
#
use English;         # Let us say "$CHILD_ERROR" instead of "$?", etc.
use strict;          # Enforce strict variables, refs, subs, etc.

###############################################################################
#
#  ------------------------ DATA STRUCTURES ------------------------
#
###############################################################################
#
# Global data structures are defined in Command.pm.
#
###############################################################################

###############################################################################
#
#  ------------------------ SUBROUTINES ------------------------
#
###############################################################################

###############################################################################
#
# NAME   : abdomen
#
# PURPOSE: Run the command.
#
# INPUTS : NONE
#
# OUTPUTS: The version number is printed to STDOUT.
#
# NOTES  : 1. This functions as a main body. Since this is OO perl and perl
#             reads in the main body of the packages during initialization
#             to avoid any side effects the functionality of the body has
#             moved to this method.
#          2. The name abdomen was chosen as its a simile for main body and
#             it'll hopefully remain near the top of the file since it starts
#             with "ab". Unless someone wants to really wreck this scheme.
#          3. Although this is called with arguments nothing is checked or
#             used.
#
###############################################################################
sub abdomen {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $command   = $$rh_arguments{command};
    my $arguments = $$rh_arguments{arguments};

    # OK, the above is not really needed since we're just printing out
    # a version number. But it keeps the operation in sync with the other
    # classes use of abdomen().

    my $version_number = $this_class -> version;
    opatchIO->print_message_noverbose ( {message => "OPatch Version: $version_number\n"} );
    my $debug = $ENV{OPATCH_DEBUG};
    if ( $debug eq "TRUE" ) {
        my $release_date = $this_class -> release_date;
    	opatchIO->print_message_noverbose ( {message => "Release Date: $release_date"} );
    }
    exit ( 0 );

}   # End of abdomen().

###############################################################################
#
# NAME   : command_details
#
# PURPOSE: Provide the details about the command.
#
# INPUTS : $$ARG[rh_detail] - A reference to a hash structure of the class
#                             Command to store the attributes in.
#
# OUTPUTS: NONE
#
# NOTES  : 1. The return values are in hash so the caller will get the new
#             details when this subroutine is finished.
#
###############################################################################
sub command_details {

    # Because this was called in an OO manner the first argument is the
    # class name.
    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $rh_detail    = $$rh_arguments{rh_detail};
  
    my $command = lc ( $this_class );
    $$rh_detail{$command}  = Command -> new_command();

    $$rh_detail{$command}{_description} = "Version of opatch.";

    $$rh_detail{$command}{_helpText}    = 
               "Prints the 5 digit version number of this product.";

    return ( 0 );

}   # End of command_detail().


#############################################################################
# Perl packages need to return a true value.
1;
#############################################################################

