#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#    XML.pm
#
#    DESCRIPTION
#    This file contains the methods for parsing the Oracle inventory
#    file.
#
#    NOTES
#    1.   The file is expected in XML a valid format. This implies validation
#         has occured.
#    2.   Not using one of the many XML packages available as this needs to
#         stay under Oracle's ownership for legal reasons.
#    3.   I haven't looked at any of the XML perl parsing code from any 
#         source because of point 2 so this will need revision as it's
#         refined.
#    4.   This is specific to validating Oracle inventory files.
#
#    BUGS
#    * <if you know of any bugs, put them here!>
#
#    MODIFIED   (MM/DD/YY)
#       phnguyen 01/21/05 - 
#       shgangul 09/11/03 - Logging changes for 10G 
#       phnguyen 08/28/03 - phnguyen_installable 
#       daevans  02/11/03 - daevans_relocate_directories
#    daevans     31/12/01  Inital code.
#
##########################################################################

###############################################################################
###############################################################################
#
#  ------------------------ INITIALIZATION ------------------------
#
###############################################################################
###############################################################################

package XML;
@ISA = ("Command");

######
#
# Standard modules:
#
use English;         # Let us say "$CHILD_ERROR" instead of "$?", etc.
use strict;          # Enforce strict variables, refs, subs, etc.

###############################################################################
#
#  ------------------------ PACKAGE VARIABLES ------------------------
#
###############################################################################
# OK, more like constants.
use constant XML_Start_Comment => "<!--";
use constant XML_End_Comment   => " -->";
use constant XML_Start_Header  => "<?xml version=";
use constant XML_End_Header    => " ?>";
@XML::XML_Valid_Tags           = ( "HOME",
                                   "HOME_LIST",
                                   "INVENTORY",
                                   "MINIMUM_VER",
                                   "SAVED_WITH",
                                   "VERSION_INFO" );

###############################################################################
#
#  ------------------------ DATA STRUCTURES ------------------------
#
###############################################################################
#
# Global data structures are defined in Command.pm.
#
###############################################################################


###############################################################################
#
#  ------------------------ SUBROUTINES ------------------------
#
###############################################################################

###############################################################################
#
# NAME   : build_xml_structure
#
# PURPOSE: Parse a valid XML file into a memory structure.
#
# INPUTS : $$ARG[command]   - The command that is to be executed.
#          $$ARG[arguments] - The arguments to the command.
#
# OUTPUTS: A blessed reference to an array that represents the XML document.
#
# NOTES  :
#
###############################################################################
sub build_xml_structure {

    my $this_class   = shift @ARG;
    my $rh_arguments = $ARG[0];

    my $document = $$rh_arguments{document};
    
    my $ra_inventory = $this_class -> bless_array();

    if ( @XML::XML_Valid_Tags ) {}
}   # End of abdomen().

#############################################################################
# Perl packages need to return a true value.
1;
#############################################################################

