#ifdef RCSID
static char *RCSid =
   "$Header: migctl.c 15-nov-2002.09:59:48 sravada Exp $ ";
#endif /* RCSID */

/* Copyright (c) 1997, 2002, Oracle Corporation.  All rights reserved.  */

/*

   NAME
     migoci.c - <one-line expansion of the name>

   DESCRIPTION
     <short description of component this file declares/defines>

   PUBLIC FUNCTION(S)
     <list of external functions declared/defined - with one-line descriptions>

   PRIVATE FUNCTION(S)
     <list of static functions defined in .c file - with one-line descriptions>

   RETURNS
     <function return values, for .c file with single function>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
   sravada     11/15/02 - bug 2660425
   sravada     02/01/02 - bug 2208353
   sravada     09/22/98 - Add option for point only layers
   sravada     09/15/98 - Creation

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <oci1.h>
#include <oci.h>
#include <math.h>
#include <time.h>
#include <ctype.h>

#include <migctl.h>
#if     !defined(TRUE) || ((TRUE) != 1)
#define TRUE    (1)
#endif
#if     !defined(FALSE) || ((FALSE) != 0)
#define FALSE   (0)
#endif



/*************************************************************************/
/* Function Implementations                                              */
/*************************************************************************/

void main(int argc, char **argv)
{
  sword mainstat;
  time_t now;
  int i, interactive = TRUE, ordcnt = 0, dimnum = 0, incounter = 0;
  char user[MAX_LEN], passwd[MAX_LEN], scratchbufr[MAX_LEN];
  char *token;
  /* char layer[MAX_LEN], query[MAX_LEN], newtabname[MAX_LEN]; */
  char layer[MAX_LEN], query[MAX_LEN], newtabname[MAX_LEN];
  char  gidcolumn[MAX_LEN], geocolname[MAX_LEN]; 
  char ptype[MAX_LEN];

  ptype[0] = '\0'; /* initialize ptype */
  /* print out title */
  time(&now);
  fprintf(stderr, "\nMigration Tool: SDO to SC - Production on %s\n", ctime(&now)); 
  fprintf(stderr, "(c) Copyright 1998 Oracle Corporation. All rights reserved.\n\n");

  /* Either we have all the parameters or none of them */
  if (argc != 1 && argc < 4)
  {
    printf("Usage: %s [<user>/<password> <layer table to generate ctl file from > <target table>\n", argv[0]);
    exit(0);
  }

  if (argc == 1)                      /* no parameter string */
  {
    printf("Enter username: ");
    gets(user);
    printf("Enter password: ");
    gets(passwd);
    printf("Enter source layer name: ");
    gets(layer);
    printf("Enter destination table name: ");
    gets(newtabname);
    printf("Enter layer gtype (e.g. POINT): ");
    gets(ptype);
  }
  else                                /* analyze parameter string */
  {
    interactive = FALSE;
    strncpy(user, argv[1], MAX_LEN);
    token = strchr(user, '/');
    if (token == (char *)0)           /* no '/' in param string */
      strncpy(passwd, "", MAX_LEN);
    else                              /* break the string into two parts */
    {
      *token = '\0';
      strncpy(passwd, token + 1, MAX_LEN);
    }

    /* now get the rest of the arguments */
   
    strncpy(layer, argv[2], MAX_LEN);
    strncpy(newtabname, argv[3], MAX_LEN);
    if (argc == 5)
      strncpy(ptype, argv[4], MAX_LEN);

   }  /* end else */

  /* connect to oracle */
  mdconnect(user, passwd, (ub4)OCI_THREADED|OCI_OBJECT);

  if (interactive == TRUE)
  {
    while (TRUE)
    {
      if (incounter != 0) 
      {
	printf("Enter layer name to migrate from (or . to exit): ");
	gets(layer);
      } 
      if (strncmp(layer, ".", MAX_LEN) == 0)
        break;

      /* uppercase parameters  */
    for (i = 0; i < strlen(layer); i++)
      layer[i] = toupper(layer[i]);

    for (i = 0; i < strlen(newtabname); i++)
      newtabname[i] = toupper(newtabname[i]);

    for (i = 0; i < strlen(ptype); i++)
      ptype[i] = toupper(ptype[i]);

      if (strncmp(ptype, "POINT", MAX_LEN) == 0)
        point = TRUE;

      /* verify that tables and columns exist */
      mainstat = vertabs(layer);
      checkerr(errhp,mainstat);

      initialize();  

      sprintf(query, "SELECT sdo_ordcnt FROM %s_%s", layer, SDOLAYER); 
      ordcnt = (int)execute_query(query); 
      sprintf(query, "SELECT count(*) FROM %s_%s", layer, SDODIM); 
      dimnum = (int)execute_query(query); 
      migrate(layer, newtabname, ordcnt, dimnum); 
 
      incounter = 1;
    } /* end while */
  }
  else
  { /* no interactive, so no loop */
    /* uppercase parameters */
    for (i = 0; i < strlen(layer); i++)
      layer[i] = toupper(layer[i]);
    for (i = 0; i < strlen(newtabname); i++)
      newtabname[i] = toupper(newtabname[i]);
    for (i = 0; i < strlen(gidcolumn); i++)
      gidcolumn[i] = toupper(gidcolumn[i]);
    for (i = 0; i < strlen(geocolname); i++)
      geocolname[i] = toupper(geocolname[i]);
    for (i = 0; i < strlen(ptype); i++)
      ptype[i] = toupper(ptype[i]);


    if (strncmp(ptype, "POINT", MAX_LEN) == 0)
      point = TRUE;
    
    mainstat = vertabs(layer);
    checkerr(errhp,mainstat);

    initialize(); 
    sprintf(query, "SELECT sdo_ordcnt FROM %s_%s", layer, SDOLAYER);
    ordcnt = (int)execute_query(query);
    sprintf(query, "SELECT count(*) FROM %s_%s", layer, SDODIM);
    dimnum = (int)execute_query(query);
    
    migrate(layer, newtabname, ordcnt, dimnum);
  }   /* end else */

  /* in either case, now disconnect from oracle */
  mddisconnect();
}  /* end main */


/*********************/
/* Connect to Oracle */
/*********************/
void mdconnect(char *username, char *password, ub4 mode)
{
 sword sess_stat;
  /* initialize envhp */
  OCIInitialize((ub4)mode, (dvoid *)0, 
		(dvoid *(*)())0, (dvoid *(*)())0, (void (*)())0);
  OCIEnvInit(&envhp, (ub4)OCI_DEFAULT, (size_t)0, (dvoid **)0);

  /* initialize errhp and srvhp */
  OCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp, (ub4)OCI_HTYPE_ERROR,
		 (size_t)0, (dvoid **)0);
  OCIHandleAlloc((dvoid *)envhp, (dvoid **)&srvhp, (ub4)OCI_HTYPE_SERVER,
		 (size_t)0, (dvoid **)0);
  OCIServerAttach(srvhp, errhp, (text *)0, (sb4)0, (ub4)OCI_DEFAULT);

  /* initialize svchp */
  OCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp, (ub4)OCI_HTYPE_SVCCTX, 
		 (size_t)0, (dvoid **)0);
  OCIAttrSet((dvoid *)svchp, (ub4)OCI_HTYPE_SVCCTX, (dvoid *)srvhp, (ub4)0, 
	     (ub4)OCI_ATTR_SERVER, errhp);

  /* initialize usrhp */
  OCIHandleAlloc((dvoid *)envhp, (dvoid **)&usrhp, (ub4)OCI_HTYPE_SESSION, 
		 (size_t)0, (dvoid **)0);
  OCIAttrSet((dvoid *)usrhp, (ub4)OCI_HTYPE_SESSION, 
	     (dvoid *)username, (ub4)strlen(username), 
	     (ub4)OCI_ATTR_USERNAME, errhp);
  OCIAttrSet((dvoid *)usrhp, (ub4)OCI_HTYPE_SESSION, 
	     (dvoid *)password, (ub4)strlen(password), 
	     (ub4)OCI_ATTR_PASSWORD, errhp);

  /* initialize table handles */
  OCIHandleAlloc((dvoid *)envhp, (dvoid **)&parmh, (ub4)OCI_HTYPE_DESCRIBE, 
		 (size_t)0, (dvoid **)0);
  
  OCIHandleAlloc((dvoid *)envhp, (dvoid **)&collsthd, (ub4)OCI_HTYPE_DESCRIBE, 
		 (size_t)0, (dvoid **)0);
  
  OCIHandleAlloc((dvoid *)envhp, (dvoid **)&colhd, (ub4)OCI_HTYPE_DESCRIBE, 
		 (size_t)0, (dvoid **)0);
  /* session begins */


  sess_stat =  OCISessionBegin(svchp, errhp, usrhp, OCI_CRED_RDBMS,  
				  OCI_DEFAULT);  
  if (sess_stat != OCI_SUCCESS)
  {
     fprintf(stderr,"ERROR: Failed to connect to Oracle; check instance\n");
     exit(sess_stat);
  }
  
  OCIAttrSet((dvoid *)svchp, (ub4)OCI_HTYPE_SVCCTX, (dvoid *)usrhp, (ub4)0, 
	     (ub4)OCI_ATTR_SESSION, errhp);

  /* initialize stmthp  */
  checkerr(errhp, OCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, 
				 (ub4)OCI_HTYPE_STMT, (size_t)0, (dvoid **)0));

  /* describe spatial object types */
  checkerr(errhp, OCIHandleAlloc(envhp, (dvoid **)&dschp, 
				 (ub4)OCI_HTYPE_DESCRIBE, (size_t)0,
				 (dvoid **)0));

  elem_info_tdo = get_tdo(SDO_ELEM_INFO_ARRAY);
  ordinates_tdo = get_tdo(SDO_ORDINATE_ARRAY);

  /* instantiate OCIArray objects */
  checkerr(errhp, OCIObjectNew(envhp, errhp, svchp, OCI_TYPECODE_VARRAY,
			       elem_info_tdo, (dvoid *)NULL, 
			       OCI_DURATION_SESSION,
			       FALSE, (dvoid **)&elem_info));
  checkerr(errhp, OCIObjectNew(envhp, errhp, svchp, OCI_TYPECODE_VARRAY,
			       ordinates_tdo, (dvoid *)NULL, 
			       OCI_DURATION_SESSION,
			       FALSE, (dvoid **)&ordinates));

  fprintf (stderr, "\nConnected to Oracle.\n");
}


/**************************/
/* Disconnect from Oracle */
/**************************/
void mddisconnect()
{
  /* free the OCIArray objects */
  checkerr(errhp, OCIObjectFree(envhp, errhp, (dvoid *)ordinates, 
				(ub2)OCI_OBJECTFREE_FORCE));
  checkerr(errhp, OCIObjectFree(envhp, errhp, (dvoid *)elem_info, 
				(ub2)OCI_OBJECTFREE_FORCE));

  /* finalize type descriptor */
  checkerr(errhp, OCIHandleFree((dvoid *)dschp, (ub4)OCI_HTYPE_DESCRIBE));

  /* finalize stmthp  etc. */
  OCIHandleFree((dvoid *)stmthp, (ub4)OCI_HTYPE_STMT);

  /* session ends */
  OCISessionEnd(svchp, errhp, usrhp, (ub4)OCI_DEFAULT);
  OCIServerDetach(srvhp, errhp, (ub4)OCI_DEFAULT);

  /* finalize svchp, srvhp, and errhp */
  OCIHandleFree((dvoid *)svchp, (ub4)OCI_HTYPE_SVCCTX);
  OCIHandleFree((dvoid *)srvhp, (ub4)OCI_HTYPE_SERVER);
  OCIHandleFree((dvoid *)errhp, (ub4)OCI_HTYPE_ERROR);

  fprintf (stderr, "\nDisconnected from Oracle.\n");
  exit(0);
}


/******************************/
/* Check and print out errors */
/******************************/
void checkerr(OCIError *errhp, sword status)
{
  text errbuf[512];
  sb4 errcode = 0;

  switch (status)
  {
  case OCI_SUCCESS:
    break;
  case OCI_SUCCESS_WITH_INFO:
    fprintf(stderr, "OCI_SUCCESS_WITH_INFO\n");
    break;
  case OCI_ERROR:
    OCIErrorGet((dvoid *)errhp, (ub4)1, (text *)NULL, &errcode, 
		errbuf, (ub4)sizeof(errbuf), OCI_HTYPE_ERROR);
    fprintf(stderr, "%.*s\n", 512, errbuf);
    break;
  case OCI_NEED_DATA:
    fprintf(stderr, "OCI_NEED_DATA\n");
    break;
  case OCI_NO_DATA:
    fprintf(stderr, "OCI_NO_DATA\n");
    break;
  case OCI_INVALID_HANDLE:
    fprintf(stderr, "OCI_INVALID_HANDLE\n");
    break;
  case OCI_STILL_EXECUTING:
    fprintf(stderr, "OCI_STILL_EXECUTING\n");
    break;
  case OCI_CONTINUE:
    fprintf(stderr, "OCI_CONTINUE\n");
    break;
  default:
    break;
  }

  if (status != OCI_SUCCESS && status != OCI_SUCCESS_WITH_INFO)
    mddisconnect();
}


/************************/
/* Get TDO by type name */
/************************/
OCIType *get_tdo(char *typename)
{
  OCIParam *paramp = NULL;
  OCIRef *type_ref = NULL;
  OCIType *tdo = NULL;

  /*  
  checkerr(errhp, OCITypeByName(envhp, errhp, svchp, (text *)TYPE_OWNER,
				(ub4)strlen((char *)TYPE_OWNER), 
				(text *)typename, 
				(ub4)strlen((char *)typename), 
				(text *)0, (ub4)0, OCI_DURATION_SESSION, 
				OCI_TYPEGET_HEADER, &tdo));
  */
  checkerr(errhp, OCIDescribeAny(svchp, errhp, (text *)typename, 
				 (ub4)strlen((char *)typename), 
				 OCI_OTYPE_NAME, (ub1)1, 
				 (ub1)OCI_PTYPE_TYPE, dschp));
  checkerr(errhp, OCIAttrGet((dvoid *)dschp, (ub4)OCI_HTYPE_DESCRIBE,
			     (dvoid *)&paramp, (ub4 *)0, 
			     (ub4)OCI_ATTR_PARAM, errhp));
  checkerr(errhp, OCIAttrGet((dvoid *)paramp, (ub4)OCI_DTYPE_PARAM,
			     (dvoid *)&type_ref, (ub4 *)0, 
			     (ub4)OCI_ATTR_REF_TDO, errhp));
  checkerr(errhp, OCIObjectPin(envhp, errhp, type_ref, (OCIComplexObject *)0, 
			       OCI_PIN_ANY, OCI_DURATION_SESSION, 
			       OCI_LOCK_NONE, (dvoid **)&tdo));
  if (!tdo)
  {
    fprintf(stderr, "Null tdo returned for type %s.\n", typename);
    mddisconnect();
  }

  return tdo;
}

/*******************************************************/
/*  verify existence of tables and columns to be used  */
/*******************************************************/
sword vertabs(char *layer)
{
   sword verstat;
   ub4 layerlen, tab_len, gidlen, geolen, namlen, i;
   char nambuf[MAX_LEN], geocoltype[MAX_LEN], oldgeotab[MAX_LEN];
   char *namptr;
   ub2 sql_coltype, numcols;
   ub1 got_gidcol, got_geocol = 0;

   numcols = 0;


   /* check that table to migrate from exists */
   /* Since we ask for layer name, need to append _SDOGEOM before check */
   /* to see if the old geometry table exists. */
   layerlen = strlen(layer);
   strncpy(oldgeotab,layer,layerlen);
   oldgeotab[layerlen] = '\0';

   strcat(oldgeotab,"_SDOGEOM");
   tab_len = strlen(oldgeotab);
   verstat = OCIDescribeAny(svchp,errhp, (text *)oldgeotab, (ub4) tab_len, 
                         OCI_OTYPE_NAME, (ub1)0, (ub1)OCI_PTYPE_TABLE, dschp);

   checkerr(errhp,verstat);

   if (verstat != OCI_SUCCESS && verstat != OCI_SUCCESS_WITH_INFO)
   {
     fprintf(stderr, "Table %s to migrate from not found.\n", oldgeotab);
     exit(1);
   }

  return verstat;
} /* end function */ 
                        



/*****************************************************/
/* Initialize data structures and new geometry table */
/*****************************************************/
void initialize()
{
  int i;
  /* Initialize global Oracle number 0 and 1 */
  i = 0;
  checkerr(errhp, OCINumberFromInt(errhp, (dvoid *)&i, (uword)sizeof(int), 
				   OCI_NUMBER_SIGNED, (dvoid *)&zero));
  i = 1;
  checkerr(errhp, OCINumberFromInt(errhp, (dvoid *)&i, (uword)sizeof(int), 
				   OCI_NUMBER_SIGNED, (dvoid *)&one));

  /* Initialize global variables */
  global_gid = zero;
  global_eseq = zero;
  global_cnt = 0;
  global_p[0] = zero;
  global_p[1] = zero;
  global_p[2] = zero;

}


/*********************************************/
/* Execute query statement to get an integer */
/*********************************************/
long execute_query(char *query)
{
  OCIDefine *defn1p = NULL;
  sword value = 0;

  /* parse query */
  checkerr(errhp, OCIStmtPrepare(stmthp, errhp, 
				 (text *)query, (ub4)strlen(query), 
				 (ub4)OCI_NTV_SYNTAX, (ub4)OCI_DEFAULT));

  /* define ordcnt */
  checkerr(errhp, OCIDefineByPos(stmthp, &defn1p, errhp, (ub4)1, 
				 (dvoid *)&value, (sb4)sizeof(sword), 
				 SQLT_INT, (dvoid *)0, (ub2 *)0, (ub2 *)0, 
				 (ub4)OCI_DEFAULT));

  /* execute and fetch */
  checkerr(errhp, OCIStmtExecute(svchp, stmthp, errhp, (ub4)1, (ub4)0, 
				 (OCISnapshot *)NULL, (OCISnapshot *)NULL, 
				 (ub4)OCI_DEFAULT)); 

  return (long)value;
}


/*******************************************************************/
/* Read geometries from old table and call write geometry function */
/*******************************************************************/
void migrate(char *layer, char *new, int ordcnt, int dimnum)
{
  int i, nrows = 0;
  char query[MAX_LEN];
  sword status;
  int rows_fetched = 0, rows_processed = 0;
  boolean has_more_data = TRUE;
  OCIDefine *defnp[MAX_ITEMS];               /* OCI define pointers, etc. */
  OCIBind *bnd1p = NULL, *bnd2p = NULL, *bnd3p = NULL, *bnd4p = NULL;
  OCIBind *pbind1 = NULL, *pbind2 = NULL, *pbind3 = NULL;
  OCINumber *data_buf;                       /* data buffer */
  sb2 *indi_buf;                             /* inidicator buffer */

  /* allocate space for data, indicators */
  if ((data_buf = (OCINumber *) malloc((FIRST_COORD + ordcnt) * 
				       ARRAY_SIZE * 
				       sizeof(OCINumber))) == NULL)
  {
    fprintf(stderr, "couldn't allocate memory for data.\n");
    mddisconnect();
  }
  if ((indi_buf = (sb2 *) malloc((FIRST_COORD + ordcnt) * ARRAY_SIZE * 
				 sizeof(sb2))) == NULL)
  {
    free(data_buf);
    fprintf(stderr, "couldn't allocate memory for indicators.\n");
    mddisconnect();
  }
  
  /* construct query */
  sprintf(query, "SELECT * FROM %s_%s ORDER BY sdo_gid, sdo_eseq, sdo_seq", 
	  layer, SDOGEOM);

  /* parse query */
  checkerr(errhp, OCIStmtPrepare(stmthp, errhp, 
				 (text *)query, (ub4)strlen(query), 
				 (ub4)OCI_NTV_SYNTAX, (ub4)OCI_DEFAULT));

  /* define columns */
  for (i = 0; i < (FIRST_COORD + ordcnt); i++)
  {
    defnp[i] = NULL;
    checkerr(errhp, OCIDefineByPos(stmthp, &(defnp[i]), errhp, (ub4)(i + 1), 
				   (dvoid *)&(data_buf[i * ARRAY_SIZE]), 
				   (sb4)sizeof(OCINumber), SQLT_VNU, 
				   (dvoid *)&(indi_buf[i * ARRAY_SIZE]), 
				   (ub2 *)0, (ub2 *)0, (ub4)OCI_DEFAULT));
  }

  time(&begin);


  /* write the initial header for the ctl file */

  printf("LOAD DATA\nINFILE *\nINTO TABLE %s\nreplace\n", new);
  printf("FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"'\n");
  printf("TRAILING NULLCOLS\n");
  printf("(\n");
  if (point == TRUE)
    {
      printf("gid    char(6),\n");
      printf("geometry COLUMN OBJECT\n");
      printf("( sdo_gtype INTEGER EXTERNAL,\n");
      printf("  sdo_srid INTEGER EXTERNAL,\n");
      printf("  SDO_POINT COLUMN OBJECT \n");
      printf("  ( X INTEGER EXTERNAL,\n");
      printf("    Y INTEGER EXTERNAL,\n");
      printf("    Z INTEGER EXTERNAL),\n");
      printf("    is_null1 FILLER CHAR, \n");
      printf(" SDO_ELEM_INFO VARRAY terminated by ';' NULLIF geometry.is_null1=\"v1\"\n");
      printf("        (SDO_ORDINATES char(38)),\n");
      printf("    is_null2 FILLER CHAR, \n");
      printf(" SDO_ORDINATES VARRAY terminated by ':'\n NULLIF geometry.is_null2=\"v2\"\n");
      printf("    (SDO_ORDINATES char(38))))\n");
    }
  else
    {
      printf("gid    char(6),\n");
      printf("geometry COLUMN OBJECT\n");
      printf("( sdo_gtype INTEGER EXTERNAL,\n");
      printf("  sdo_srid INTEGER EXTERNAL,\n");
      printf("   isnull FILLER CHAR,\n");
      printf("  SDO_POINT COLUMN OBJECT  NULLIF geometry.isnull=\"pt\"\n");
      printf("  ( X INTEGER EXTERNAL,\n");
      printf("    Y INTEGER EXTERNAL,\n");
      printf("    Z INTEGER EXTERNAL),\n");
      printf(" SDO_ELEM_INFO VARRAY terminated by ';'\n");
      printf("        (SDO_ORDINATES char(38)),\n");
      printf(" SDO_ORDINATES VARRAY terminated by ':'\n");
      printf("    (SDO_ORDINATES char(38))))\n");
    }
  printf("begindata\n");
      
  /* execute */

  status = OCIStmtExecute(svchp, stmthp, errhp, (ub4)ARRAY_SIZE, (ub4)0, 
			  (OCISnapshot *)NULL, (OCISnapshot *)NULL, 
			  (ub4)OCI_DEFAULT); 

  if (status == OCI_SUCCESS_WITH_INFO || status == OCI_NO_DATA)
    has_more_data = FALSE;
  else
  {
    has_more_data = TRUE;
    checkerr(errhp, status);
  }

  /* process data */
  checkerr(errhp, OCIAttrGet((dvoid *)stmthp, (ub4)OCI_HTYPE_STMT,
			     (dvoid *)&rows_fetched, (ub4 *)0, 
			     (ub4)OCI_ATTR_ROW_COUNT, errhp));
  process_data(data_buf, indi_buf, ordcnt, dimnum, 
	       (rows_fetched - rows_processed), &rows_processed);
  
  while (has_more_data)
  {
    status = OCIStmtFetch(stmthp, errhp, (ub4)ARRAY_SIZE, 
			  (ub2)OCI_FETCH_NEXT, (ub4)OCI_DEFAULT);
    
    if (status != OCI_SUCCESS)
      has_more_data = FALSE;
    
    checkerr(errhp, OCIAttrGet((dvoid *)stmthp, (ub4)OCI_HTYPE_STMT,
			       (dvoid *)&rows_fetched, (ub4 *)0, 
			       (ub4)OCI_ATTR_ROW_COUNT, errhp));
    process_data(data_buf, indi_buf, ordcnt, dimnum, 
		 (rows_fetched - rows_processed), &rows_processed);
  }
    
  if (status != OCI_SUCCESS_WITH_INFO && status != OCI_NO_DATA)
    checkerr(errhp, status);
  
  /* write the last geometry into database */
  write_geometry();

  time(&endtime);
  fprintf(stderr, "\r                                                   ");
  fprintf(stderr, "\r%d geometries processed in %d sec.\n", ++global_cnt,
  (int)(endtime - begin));
  fflush(stderr);

  /* commit and free memory space */
  checkerr(errhp, OCITransCommit(svchp, errhp, (ub4)0)); 
  free(indi_buf);
  free(data_buf);
}


/*************************/
/* process geometry data */
/*************************/
void process_data(OCINumber *data_buf, sb2 *indi_buf, int ordcnt, int dimnum, 
		  int rows_to_process, int *rows_processed)
{
  int row, i;
  sword gid_result, eseq_result, seq_result;
  char gid_str[MAX_LEN], seq_str[MAX_LEN];
  int gid_strlen, seq_strlen;

  for (row = 0; row < rows_to_process; row++, (*rows_processed)++)
  {
    /* compare current and previous (GID, ESEQ) pair */
    checkerr(errhp, OCINumberCmp(errhp, &(data_buf[row + ARRAY_SIZE * 0]), 
				 &global_gid, &gid_result));
    checkerr(errhp, OCINumberCmp(errhp, &(data_buf[row + ARRAY_SIZE * 1]), 
				 &global_eseq, &eseq_result));
    /* first element in the first GID? */
    if (*rows_processed == 0)
    {
      global_offset = 0;
      append_elem_info(data_buf[row + ARRAY_SIZE * 2], global_offset, 1);
    }
    /* got a new element? */
    else if (gid_result != 0 || eseq_result != 0)
    {
      /* got a new GID? */
      if (gid_result != 0)
      {
	write_geometry();
	
	if ((++global_cnt % 256) == 0)
	{
	  time(&endtime);
	  fprintf(stderr, "\r                                                   ");
	  fprintf(stderr, "\r%d geometries processed in %d sec.\n", global_cnt,
		  (int)(endtime - begin));
	  fflush(stderr);
	}

	global_offset = 0;
      }

      append_elem_info(data_buf[row + ARRAY_SIZE * 2], global_offset, 1);
    }

    /* update global info */
    global_gid = data_buf[row + ARRAY_SIZE * 0];
    global_eseq = data_buf[row + ARRAY_SIZE * 1];
    global_etype = data_buf[row + ARRAY_SIZE * 2];
    cur_seq = data_buf[row + ARRAY_SIZE * 3];

    /* process coordinates in a row */
    if (*rows_processed == 0 || gid_result != 0 || eseq_result != 0)
    {
      /* The first row of a new element */
      append_ordinates(data_buf, indi_buf, row, FIRST_COORD, 
		    FIRST_COORD + ordcnt);
      global_seq = cur_seq;
    }
    else
    {
      /* Existing element: check sequence number */
      checkerr(errhp, OCINumberAdd(errhp, &global_seq, &one, &global_seq));
      checkerr(errhp, OCINumberCmp(errhp, &cur_seq, &global_seq, &seq_result));
      append_ordinates(data_buf, indi_buf, row, FIRST_COORD + dimnum, 
		       FIRST_COORD + ordcnt);

      if (seq_result != 0)
      {
	gid_strlen = seq_strlen = MAX_LEN;
	checkerr(errhp, OCINumberToText(errhp, &global_gid, 
					(text *)"FM9999999999999999999999",
					(ub4)24, (text *)0, (ub4)0,
					(ub4 *)&gid_strlen, (text *)&gid_str));
	checkerr(errhp, OCINumberToText(errhp, &cur_seq, 
					(text *)"FM9999999999999999999999",
					(ub4)24, (text *)0, (ub4)0,
					(ub4 *)&seq_strlen, (text *)&seq_str));
        fprintf(stderr, "Warning: sdo_seq %s not continuous in GID: %s\n", 
		seq_str, gid_str);
      }
    }
  } /* end of for-loop */
}


/*************************************************/
/* generate the geometry type from element types */
/*************************************************/
void generate_gtype(OCIArray *elem_info, OCINumber *gtype)
{
  int         i;
  boolean     exists;
  OCINumber  *etype;
  int         int_etype;
  int         max_etype = 0;
  sb4         sz = 0;

  /* NOTE: this function body is just a placeholder */
  /* Search all etypes, determine GTYPE
   * Rules used:
   * If all elements are points, 1;
   * If all elements are lines,  2;
   * If all elements are polys,  3;
   * If mix, higher number wins.
   */
  checkerr(errhp, OCICollSize(envhp, errhp, elem_info, &sz));
  sz /= 3;
  for (i = 0; i < sz; i++)
  {
    checkerr(errhp, OCICollGetElem(envhp, errhp, (OCIColl *)elem_info, 
  				   (sb4)i*3+1, (boolean *)&exists, 
				   (dvoid **)&etype, (dvoid **)0));

    if (exists)
    {
      checkerr(errhp, OCINumberToInt(errhp, etype, sizeof(int_etype),
                                   OCI_NUMBER_SIGNED, &int_etype));
      if (int_etype > max_etype)
        max_etype = int_etype;
    }
    else
    {
      fprintf(stderr, "Info_Obj element does not exist.\n");
      mddisconnect();
    }
  }
  checkerr(errhp, OCINumberFromInt(errhp, &max_etype, (uword)sizeof(max_etype),
                                   OCI_NUMBER_SIGNED, gtype));
}


/**********************************************/
/* append info_obj data to the elme_info list */
/**********************************************/
void append_elem_info(OCINumber etype, ub4 starting_offset, ub4 interpolation)
{
  info_obj_type info_obj;

  /* shift offset from 0..n-1 to 1..n */
  starting_offset++;

  info_obj.etype = etype;
  checkerr(errhp, OCINumberFromInt(errhp, (dvoid *)&starting_offset, 
				   (uword)sizeof(ub4), OCI_NUMBER_UNSIGNED, 
				   (dvoid *)&(info_obj.starting_offset)));
  checkerr(errhp, OCINumberFromInt(errhp, (dvoid *)&interpolation, 
				   (uword)sizeof(ub4), OCI_NUMBER_UNSIGNED, 
				   (dvoid *)&(info_obj.interpolation)));
  /* append the info object into the elem_info array */
/*
  checkerr(errhp, OCICollAppend(envhp, errhp, (dvoid *)&info_obj,
				(dvoid *)0, (OCIColl *)elem_info));
*/
  checkerr(errhp, OCICollAppend(envhp, errhp, (dvoid *)&(info_obj.starting_offset),
				(dvoid *)0, (OCIColl *)elem_info));
  checkerr(errhp, OCICollAppend(envhp, errhp, (dvoid *)&(info_obj.etype),
				(dvoid *)0, (OCIColl *)elem_info));
  checkerr(errhp, OCICollAppend(envhp, errhp, (dvoid *)&(info_obj.interpolation),
				(dvoid *)0, (OCIColl *)elem_info));
}


/***********************************************/
/* append geometry data to the coordinate list */
/***********************************************/
void append_ordinates(OCINumber *data_buf, sb2 *indi_buf, int row, 
		   int begin_col, int end_col)
{
  int col;

  for (col = begin_col; col < end_col; col++)
  {
    if (indi_buf[row + ARRAY_SIZE * col] < 0) 
      break;                                  /* Null column */
  
    /* append the coordinate into this node */
    /*
    if (point == TRUE)
      {
	if ( (col-begin_col) < 3)
	  {
	    global_p[col-begin_col] = data_buf[row+ARRAY_SIZE*col];	  
	  }
      }
    else
    */
      checkerr(errhp, OCICollAppend(envhp, errhp, 
				    (dvoid *)&(data_buf[row+ARRAY_SIZE*col]),
				    (dvoid *)0, (OCIColl *)ordinates));
    global_offset++;
  } 
}


/*******************************************************************/
/* write geometry data into SDOGEOM table, and reset the OCIArrays */
/*******************************************************************/
void write_geometry()
{
  text out_num[65];
  ub4 length;
  sword nelem;
  int i;
  sword hherr;
  boolean exists;
  OCINumber *element;
  /* generate the geometry type from the element types */
  generate_gtype(elem_info, &global_gtype);
  /* execute insert statement */
  /*
    checkerr(errhp, OCIStmtExecute(svchp, alt_stmthp, errhp, (ub4)1, (ub4)0, 
    (OCISnapshot *)NULL, (OCISnapshot *)NULL, 
    (ub4)OCI_DEFAULT));
    */

  length = (ub4)65;
  checkerr(errhp, OCINumberToText(errhp, &global_gid, (text *)"TM", (ub4)2, (text *)0, 
				  (ub4)0, &length, out_num));
    
  printf("%s,", (char *)out_num);

  length = (ub4)65;
  checkerr(errhp, OCINumberToText(errhp, &global_gtype, (text *)"TM", (ub4)2, (text *)0, 
				  (ub4)0, &length, out_num));
    
  printf("%s,", (char *)out_num);
  
  printf("," );  /* dummy SRID */
  
  if (point == TRUE)
    {
      hherr = OCICollSize(envhp, errhp, ordinates, &nelem);
      if (nelem > 3)
	fprintf(stderr, "Point should have less than 4 dimensions to fit in point only layer\n");
      
      checkerr(errhp,  OCICollGetElem(envhp, errhp, 
				      (OCIColl *)ordinates,
				      (sb4)0, &exists,
				      (dvoid **)&element,
				      (dvoid **)0));
      length = (ub4)65;
      checkerr(errhp, OCINumberToText(errhp, element, (text *)"TM", (ub4)2, (text *)0, 
				      (ub4)0, &length, out_num));
      printf("%s,", (char *)out_num);

      checkerr(errhp,  OCICollGetElem(envhp, errhp, 
				      (OCIColl *)ordinates,
				      (sb4)1, &exists,
				      (dvoid **)&element,
				      (dvoid **)0));
      length = (ub4)65;
      checkerr(errhp, OCINumberToText(errhp, element, (text *)"TM", (ub4)2, (text *)0, 
				      (ub4)0, &length, out_num));
      printf("%s,", (char *)out_num);
      
      if (nelem == 3)
	{
	  checkerr(errhp,  OCICollGetElem(envhp, errhp, 
					  (OCIColl *)ordinates,
					  (sb4)2, &exists,
					  (dvoid **)&element,
					  (dvoid **)0));
	  length = (ub4)65;
	  checkerr(errhp, OCINumberToText(errhp, element, (text *)"TM", (ub4)2, (text *)0, 
					  (ub4)0, &length, out_num));
	  printf("%s,", (char *)out_num);
	}
      else
	printf(",");
      printf("v1,;v2,:");
    }
  else
    {
      printf("pt,,,,");
      
      hherr = OCICollSize(envhp, errhp, elem_info, &nelem);
      for(i=0; i<nelem; i++)
	{
	  
	  checkerr(errhp,  OCICollGetElem(envhp, errhp, 
					  (OCIColl *)elem_info,
					  (sb4)i, &exists,
					  (dvoid **)&element,
					  (dvoid **)0));
	  length = (ub4)65;
	  checkerr(errhp, OCINumberToText(errhp, element, (text *)"TM", (ub4)2, (text *)0, 
					  (ub4)0, &length, out_num));
	  printf("%s", (char *)out_num);
	  if (i < nelem-1)
	    printf(",");
	}
      printf(";");
      
      
      hherr = OCICollSize(envhp, errhp, ordinates, &nelem);
      for(i=0; i<nelem; i++)
	{
	  checkerr(errhp,  OCICollGetElem(envhp, errhp, 
					  (OCIColl *)ordinates,
					  (sb4)i, &exists,
					  (dvoid **)&element,
					  (dvoid **)0));
	  length = (ub4)65;
	  checkerr(errhp, OCINumberToText(errhp, element, (text *)"TM", (ub4)2, (text *)0, 
					  (ub4)0, &length, out_num));
	  printf("%s", (char *)out_num);
	  if (i < nelem-1)
	    printf(",");
	}
      printf(":");
    }
  checkerr(errhp, OCIObjectFree(envhp, errhp, (dvoid *)elem_info, 
				(ub2)OCI_OBJECTFREE_FORCE));
  checkerr(errhp, OCIObjectNew(envhp, errhp, svchp, OCI_TYPECODE_VARRAY,
			       elem_info_tdo, (dvoid *)NULL, 
			       OCI_DURATION_SESSION,
			       FALSE, (dvoid **)&elem_info));
  
  checkerr(errhp, OCIObjectFree(envhp, errhp, (dvoid *)ordinates, 
				(ub2)OCI_OBJECTFREE_FORCE));
  checkerr(errhp, OCIObjectNew(envhp, errhp, svchp, OCI_TYPECODE_VARRAY,
			       ordinates_tdo, (dvoid *)NULL, 
			       OCI_DURATION_SESSION,
			       FALSE, (dvoid **)&ordinates));
  printf("\n");
}

/* end of file migoci.c */



