/*
 * $Header: migctl.h 15-nov-2002.10:02:30 sravada Exp $
 */

/* Copyright (c) 1997, 2002, Oracle Corporation.  All rights reserved.  */
 
/* NOTE:  See 'header_template.doc' in the 'doc' dve under the 'forms' 
      directory for the header file template that includes instructions. 
*/
 
/* 
   NAME 
     <<<LOWERCASE_FILENAME>>>.h - <one-line expansion of the name> 

   DESCRIPTION 
     <short description of component this file declares/defines> 

   RELATED DOCUMENTS 
 
   INSPECTION STATUS 
     Inspection date: 
     Inspection status: 
     Estimated increasing cost defects per page: 
     Rule sets: 
 
   ACCEPTANCE REVIEW STATUS 
     Review date: 
     Review status: 
     Reviewers: 
 
   PUBLIC FUNCTION(S) 
     <list of external functions declared/defined - with one-line descriptions>

   PRIVATE FUNCTION(S)
     <list of static functions defined in .c file - with one-line descriptions>

   EXAMPLES

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
   sravada     11/15/02 - bug 2660425
   sravada     02/01/02 - bug 2208353
   sravada     09/15/98 - add point only option

*/

 
#ifndef migoci_ORACLE
# define migoci_ORACLE

#ifndef OCI_ORACLE
#include <oci.h>
#endif
 

/*---------------------------------------------------------------------------
                     PUBLIC TYPES AND CONSTANTS
  ---------------------------------------------------------------------------*/
#define MAX_LEN 2048
#define MAX_ITEMS 256
#define FIRST_COORD 4
#define ARRAY_SIZE 100
 
#define TYPE_OWNER "MDSYS"
#define SDOLAYER "SDOLAYER"
#define SDODIM "SDODIM"
#define SDOGEOM "SDOGEOM"
#define SDOINDEX "SDOINDEX"
#define SDO_ORDINATE_ARRAY TYPE_OWNER".SDO_ORDINATE_ARRAY"
#define SDO_ELEM_INFO_OBJECT TYPE_OWNER".SDO_ELEM_INFO_OBJECT"
#define SDO_ELEM_INFO_ARRAY TYPE_OWNER".SDO_ELEM_INFO_ARRAY"
#define SDO_POINT TYPE_OWNER".SDO_POINT_TYPE"
#define SDO_GEOMETRY TYPE_OWNER".SDO_GEOMETRY"
#define SDO_ETYPE "SDO_ETYPE"
#define SDO_STARTING_OFFSET "SDO_STARTING_OFFSET"
#define SDO_INTERPOLATION "SDO_INTERPOLATION"
#define SDO_GID "SDO_GID"
#define SDO_GTYPE "SDO_GTYPE"
#define SDO_ELEM_INFO "SDO_ELEM_INFO"
#define SDO_ORDINATES "SDO_ORDINATES"
#define DEFAULT_GID_COLNAME "GID"
#define DEFAULT_GEOM_COLNAME "GEOMETRY"
 
/*************************************************************************/
/* Type definitions                                                      */
/*************************************************************************/
typedef struct info_obj_struct
{
  OCINumber etype;              /* element type */
  OCINumber starting_offset;    /* starting position in coordinate array */
  OCINumber interpolation;      /* coordinates */
} info_obj_type;
 

/*************************************************************************/
/* Global variables                                                      */
/*************************************************************************/
OCIEnv *envhp;                     /* OCI general handles */
OCIError *errhp;
OCIServer *srvhp;
OCISvcCtx *svchp;
OCISession *usrhp;
OCIStmt *stmthp, *alt_stmthp;
 
OCIParam *parmh, *collsthd, *colhd;  /* OCI handles for tables */

OCIDescribe *dschp = NULL;
OCIType *elem_info_tdo = NULL;     /* Varrays and the type descriptors */
OCIArray *elem_info;
OCIType *ordinates_tdo = NULL;
OCIArray *ordinates;

 
OCINumber zero, one;               /* Oracle number 0 and 1 */
OCINumber global_gid, global_eseq;
OCINumber global_etype, global_gtype;
OCINumber global_p[3];
OCINumber cur_seq, global_seq;
ub4 global_offset;                 /* current offset in coordinate array */
ub4 global_cnt;                    /* number of geometries processed */
time_t begin, endtime;
int point = FALSE;  


/*-------------------------------------------------------------------------- 
                 PRIVATE TYPES AND CONSTANTS
  ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
                           PUBLIC FUNCTIONS
  ---------------------------------------------------------------------------*/
 
void mdconnect(char *username, char *password, ub4 mode);
void mddisconnect();
void checkerr(OCIError *errhp, sword status);
 
sword verstat(char *layer);

OCIType *get_tdo(char *typename);
void initialize();
long execute_query(char *query);
void execute_update(char *update);
 
void migrate(char *layer, char *new, int ordcnt, int dimnum);
void process_data(OCINumber *data_buf, sb2 *indi_buf, int ordcnt, int dimnum,
                  int rows_to_process, int *rows_processed);
 
void generate_gtype(OCIArray *controls, OCINumber *gtype);
void append_elem_info(OCINumber etype, ub4 starting_offset, ub4 interpolation);
void append_ordinates(OCINumber *data_buf, sb2 *indi_buf, int row,
                      int begin_col, int end_col);
void write_geometry();
sword vertabs(char *layer);


/*---------------------------------------------------------------------------
                          PRIVATE FUNCTIONS
  ---------------------------------------------------------------------------*/


#endif                                              /* migoci_ORACLE */









