--
-- THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL
-- INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE
-- RELEASES.  
-- THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
-- COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.
--
-- Copyright (c) 1996, 2003 by Oracle Corporation
--
-- NAME
-- ordispec.sql - ORDImage Specification
--
-- DESCRIPTION
-- MODIFIED (MM/DD/YY)
-- smavris   01/30/03 - Change to create type
-- trowell   04/13/01 - Adding extra message text to Java calls
-- mannamal  03/22/01 - make indicator variables in sync
-- smavris   03/02/01 - Remove / after alter
-- mannamal  02/13/01 - Add indicator for VIR score sigs
-- smavris   02/12/01 - Remove blank line
-- alandeck  01/31/01 - Removing openSource/closeSource due to overloading prob
-- smavris   01/23/01 - Fix inconsistencies with i,a,d
-- alandeck  01/09/01 - Re-adding the openSource closeSource functions
-- smavris   01/05/01 - Make methods match documentation
-- mannamal  12/27/00 - update VIR_NUM_ATTR constant
-- alandeck  11/09/00 - adding missing NOCOPY for process
-- mannamal  11/09/00 - Add image constant for VIR
-- alandeck  10/18/00 - Adding open and close Source static functions
-- fechen    09/25/00 - Rename ExtCodec_Pkg to ORDImgExtCodec_Pkg.
-- fechen    09/07/00 - Add package ExtCodec_Pkg and methods in ORDImg_Pkg 
-- mannamal  10/30/00 - Add score to internal interface
-- mannamal  09/28/00 - Add PL/SQL internal interface for VIR compatibility
-- mannamal  09/21/00 - Add image matching constants
-- alandeck  08/25/00 - Adding relational interface
-- smavris   04/28/00 - Fix upgrade bug
-- dmullen   11/02/99 - Add static funtions to act as constructors
-- smavris   09/30/99 - Make it work with sqlplus
-- dmullen   08/17/99 - Fix alter type problem
-- dmullen   08/13/99 - Add alter type syntax for upgrade scenarios
-- dmullen   08/06/99 - set mimeType for headerless
-- dmullen   07/19/99 - More work with temp lobs
-- dmullen   07/15/99 - Add nocopy to ORDImage IN OUT params
-- rchatter  11/16/98 - ORDSource plugin changes
-- smavris   10/22/98 - Reorganize so we can invoke ordispec from upgrade scrip
-- smavris   10/09/98 - Add exception
-- smavris   10/07/98 - Add constants package
-- smavris   10/01/98 - Add invokers rights to package
-- smavris   09/30/98 - Add new exceptions
-- smavris   09/28/98 - Minor bug fixes
-- smavris   09/18/98 - Add exceptions
-- smavris   08/11/98 - Update for new api
-- smavris   08/11/98 - Update for new api
-- smavris   08/03/98 - Fix merged api
-- smavris   07/30/98 - Merge audio, video, image apis
-- smavris   07/30/98 - Converge audio,video,image apis
-- smavris   07/01/98 - Fix package
-- smavris   06/29/98 - Add pragmas so methods can be called in query
-- dbrown    05/27/98 - temp lob support
-- smavris   05/19/98 - Add accessor and check functions
-- smavris   05/14/98 - Add getMimeType, etc.
-- dmullen   04/17/98 - Add headerless image support
-- mannamal  01/14/98 - Updating version numbers to 8.0.5
-- dmullen   10/30/97 - Add OID to CREATE TYPE
-- ctrezza   08/22/97 - Adding disclaimer
-- trowell   07/09/97 - Update version
-- svivian   04/11/97 - remove ordimgF_copyContent in lieu of LOADFROMFILE
-- dmullen   04/07/97 - cosmetic version number change
-- dmullen   03/24/97 - Use new object type syntax
-- ctrezza   01/14/97 - Take out funarg
-- ctrezza   01/08/97 - Rewrap types using calls to package
-- bmichon   01/02/97 - change funarg to command
-- jsharma   12/26/96 - Incorporating ctrezza's changes to attribute and 
--                      function names
-- bmichon   11/03/96 - Added new methods for data i/o
-- bmichon   10/24/96 - Added compression attribute to type 
--                      Changed naming to reflect new packaging standard

-- bmichon   10/09/96 - Added BFILE support
-- bmichon   10/02/96 - Creation

---------------------------------------------------------------- 
-- Type Declaration Section
--
-- The following types are declared in this file:
--    ORDImgB - now depricated
--    ORDImgF - now depricated
--    ORDImage
-- ORDImage is declared after ORDImgB/F because of the migration
-- methods.  The migration methods use the ORDImgB/F types
-- as parameters so they must be declared prior to ORDImage.
--


CREATE TYPE ORDImgB 
  TIMESTAMP '1997-10-31:08:04:00'
  OID '1EC322A450AA28AAE03400400B4066F3'
  authid current_user
  AS OBJECT
(
-- THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL
-- INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE
-- RELEASES.  THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
-- COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.

  -------------------
  -- TYPE ATTRIBUTES
  --  
  -- content
  --   Image data
  -- height
  --   Height of the image in pixels 
  -- width
  --   Width of image in pixels
  -- contentLength
  --   Size of image (header and image data) in bytes
  -- fileFormat
  --   File type of image (e.g., TIFF, JFIF) 
  -- contentFormat
  --   Type of image (e.g., monochrome, 8-bit Grayscale)
  -- compressionFormat
  --   Compression used in image
  
  content             BLOB,
  height              INTEGER,  
  width               INTEGER,
  contentLength       INTEGER,
  fileFormat          VARCHAR2(64),
  contentFormat       VARCHAR2(64),
  compressionFormat   VARCHAR2(64),


----------------
-- METHOD DECLARATION
--     

  MEMBER PROCEDURE copyContent(SELF IN OUT NOCOPY ORDImgB,
                               dest IN OUT NOCOPY BLOB),
    
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgB),

  MEMBER PROCEDURE process(SELF    IN OUT NOCOPY ORDImgB,
                           command IN            VARCHAR2),

  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImgB,
                               command IN     VARCHAR2, 
                               dest    IN OUT NOCOPY BLOB)


);
/
 show errors;

ALTER TYPE ORDImgB REPLACE
  authid current_user
  AS OBJECT
(
  content             BLOB,
  height              INTEGER,  
  width               INTEGER,
  contentLength       INTEGER,
  fileFormat          VARCHAR2(64),
  contentFormat       VARCHAR2(64),
  compressionFormat   VARCHAR2(64),
--
--
----------------
-- METHOD DECLARATION
--     
--
  MEMBER PROCEDURE copyContent(SELF IN OUT NOCOPY ORDImgB,
                               dest IN OUT NOCOPY BLOB),
--    
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgB),
--
  MEMBER PROCEDURE process(SELF    IN OUT NOCOPY ORDImgB,
                           command IN            VARCHAR2),
--
  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImgB,
                               command IN            VARCHAR2,
                               dest    IN OUT NOCOPY BLOB),
--
-- Add methods new to 8.1
--
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgB,
                                 description IN VARCHAR2),
--
  MEMBER FUNCTION getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDImgB),
--
  MEMBER FUNCTION getHeight RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getHeight, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getWidth RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getWidth, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getFileFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFileFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getContentFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getContentFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getCompressionFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION checkProperties RETURN BOOLEAN
);
 show errors;

-- End ORDImgB


CREATE TYPE ORDImgF
  TIMESTAMP '1997-10-31:08:04:00'
  OID '1EC322A450AB28AAE03400400B4066F3'
  authid current_user
  AS OBJECT
(
  -------------------
  -- TYPE ATTRIBUTES
  -- 
  -- content
  --   Image data
  -- height
  --   Height of the image in pixels 
  -- width
  --   Width of image in pixels
  -- contentLength
  --   Size of image data (headers and image) in bytes
  -- fileFormat
  --   File type of image (e.g., TIFF, JFIF) 
  -- contentFormat
  --   Type of image (e.g., monochrome, 8-bit Grayscale)
  -- compressionFormat
  --   Compression used in image

  content              BFILE,
  height               INTEGER,  
  width                INTEGER,
  contentLength        INTEGER,
  fileFormat           VARCHAR2(64),
  contentFormat        VARCHAR2(64),
  compressionFormat    VARCHAR2(64),


----------------
-- METHOD DECLARATION
-- 
  
  
  MEMBER PROCEDURE copyContent(SELF IN OUT NOCOPY ORDImgF,
                               dest IN OUT NOCOPY BLOB),

  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgF),

  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImgF,
                               command IN            VARCHAR2,
                               dest    IN OUT NOCOPY BLOB)

);
/
show errors;

ALTER TYPE ORDImgF REPLACE
  authid current_user
  AS OBJECT
(
-- Add methods new to 8.1
--
  content              BFILE,
  height               INTEGER,  
  width                INTEGER,
  contentLength        INTEGER,
  fileFormat           VARCHAR2(64),
  contentFormat        VARCHAR2(64),
  compressionFormat    VARCHAR2(64),
--
--
----------------
-- METHOD DECLARATION
-- 
--
  --
  MEMBER PROCEDURE copyContent(SELF IN OUT NOCOPY ORDImgF,
                               dest IN OUT NOCOPY BLOB),
--
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgF),
--
  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImgF,
                               command IN            VARCHAR2, 
                               dest    IN OUT NOCOPY BLOB),
--
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgF,
                                 description IN VARCHAR2),
--
  MEMBER FUNCTION getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getContent RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getHeight RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getHeight, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getWidth RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getWidth, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getFileFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFileFormat, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getContentFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getContentFormat, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getCompressionFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionFormat, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION checkProperties RETURN BOOLEAN
--
);
show errors;
-- End ORDImgF

CREATE TYPE ORDImage
  TIMESTAMP '1998-07-30:08:14:00'
  OID '34327E50C6C314AAE03400400B4066F3'
  authid current_user
  AS OBJECT
(

  -------------------
  -- TYPE ATTRIBUTES
  -------------------
  -- source
  --   Image source (ORDSource)
  -- height
  --   Height of the image in pixels 
  -- width
  --   Width of image in pixels
  -- contentLength
  --   Size of the on-disk image in bytes
  -- fileFormat
  --   File type of image (e.g., TIFF, JFIF) 
  -- contentFormat
  --   Type of image (e.g., monochrome, 8-bit Grayscale)
  -- compressionFormat
  --   Compression used in image
  -- mimeType
  --   Mime type of the image

  source              ORDSource,
  height              INTEGER,
  width               INTEGER,
  contentLength       INTEGER,
  fileFormat          VARCHAR2(4000),
  contentFormat       VARCHAR2(4000),
  compressionFormat   VARCHAR2(4000),
  mimeType            VARCHAR2(4000)
);
/
show errors;
-- End ORDImage data only declaration

--
-- Recompile ORDImage in case this is an upgrade and an upgrade of
-- ORDSource has invalidated ORDImage.
--
ALTER TYPE ORDImage COMPILE;

ALTER TYPE ORDImage REPLACE
  authid current_user
  AS OBJECT
(
  -------------------
  -- TYPE ATTRIBUTES
  -------------------
  -- source
  --   Image source (ORDSource)
  -- height
  --   Height of the image in pixels 
  -- width
  --   Width of image in pixels
  -- contentLength
  --   Size of the on-disk image in bytes
  -- fileFormat
  --   File type of image (e.g., TIFF, JFIF) 
  -- contentFormat
  --   Type of image (e.g., monochrome, 8-bit Grayscale)
  -- compressionFormat
  --   Compression used in image
  -- mimeType
  --   Mime type of the image
  --
  source              ORDSource,
  height              INTEGER,
  width               INTEGER,
  contentLength       INTEGER,
  fileFormat          VARCHAR2(4000),
  contentFormat       VARCHAR2(4000),
  compressionFormat   VARCHAR2(4000),
  mimeType            VARCHAR2(4000),
--
---------------------
-- METHOD DECLARATION
---------------------
--
  -- CONSTRUCTORS
  STATIC FUNCTION init RETURN ORDImage,
  STATIC FUNCTION init( srcType IN VARCHAR2,
            srcLocation IN VARCHAR2,
            srcName IN VARCHAR2 ) RETURN ORDImage,
--
  -- IMAGE COPY METHOD
  MEMBER PROCEDURE copy(SELF IN OUT NOCOPY ORDImage,
                        dest IN OUT NOCOPY ORDImage),
--
  -- IMAGE PROCESSING RELATED METHODS
  MEMBER PROCEDURE process(SELF    IN OUT NOCOPY ORDImage,
                           command IN            VARCHAR2),
  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImage,
                               command IN            VARCHAR2, 
                               dest    IN OUT NOCOPY ORDImage),
--
  -- IMAGE PROPERTY SET AND CHECK METHODS
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImage),
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImage,
                                 description IN VARCHAR2),
  MEMBER FUNCTION checkProperties RETURN BOOLEAN,
--
  -- IMAGE ATTRIBUTE ACCESSOR METHODS
  MEMBER FUNCTION getHeight RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getHeight, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getWidth RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getWidth, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getFileFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFileFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getContentFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getContentFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getCompressionFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionFormat, WNDS, WNPS, RNDS, RNPS), 
--
  -- LOCAL RELATED METHODS
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDImage),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDImage),
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  --
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setUpdateTime(SELF         IN OUT NOCOPY ORDImage,
                                 current_time               DATE),
--
  -- MIMETYPE RELATED METHODS
  MEMBER FUNCTION  getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setMimeType(SELF IN OUT NOCOPY ORDImage,
                               mime IN            VARCHAR2),
--
  -- SOURCE/CONTENT RELATED METHODS
  MEMBER FUNCTION  getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION  getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getBFILE RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFILE, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDImage),
--
  MEMBER PROCEDURE setSource(SELF IN OUT NOCOPY ORDImage,
                             source_type     IN VARCHAR2,
                             source_location IN VARCHAR2,
                             source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSource RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSource, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER PROCEDURE import(SELF IN OUT NOCOPY ORDImage,
                          ctx IN OUT RAW),
  MEMBER PROCEDURE importFrom(
                          SELF IN OUT NOCOPY     ORDImage,
                          ctx             IN OUT RAW,
                          source_type     IN     VARCHAR2,
                          source_location IN     VARCHAR2,
                          source_name     IN     VARCHAR2),
  MEMBER PROCEDURE export(
                          SELF IN OUT NOCOPY     ORDImage,
                          ctx             IN OUT RAW,
                          source_type     IN     VARCHAR2,
                          source_location IN     VARCHAR2,
                          source_name     IN     VARCHAR2),
  --
  MEMBER FUNCTION  processSourceCommand(
                            SELF      IN OUT NOCOPY ORDImage,
                            ctx       IN OUT RAW,
                            cmd       IN VARCHAR2,
                            arguments IN VARCHAR2,
                            result    OUT RAW)
                   RETURN RAW,
  -- FILE OPERATIONS on the source
  MEMBER FUNCTION openSource(SELF IN OUT NOCOPY ORDImage, 
                             userArg IN RAW,
                             ctx  OUT RAW) RETURN INTEGER,
  --
  MEMBER FUNCTION closeSource(SELF IN OUT NOCOPY ORDImage, ctx IN OUT RAW) 
  RETURN INTEGER,
  --
  MEMBER FUNCTION trimSource(SELF IN OUT NOCOPY ORDImage, ctx IN OUT RAW, 
                             newlen IN INTEGER) RETURN INTEGER,
  --
  MEMBER PROCEDURE readFromSource(SELF IN OUT NOCOPY ORDImage,
                                  ctx IN OUT RAW,
                                  startPos IN INTEGER,
                                  numBytes IN OUT INTEGER,
                                  buffer OUT RAW),
  --
  MEMBER PROCEDURE writeToSource(SELF IN OUT NOCOPY ORDImage,
                                 ctx IN OUT RAW,
                                 startPos IN INTEGER,
                                 numBytes IN OUT INTEGER,
                                 buffer IN RAW),
  --
  -- MIGRATION RELATED METHODS
  MEMBER PROCEDURE migrateFromORDImgB( 
            SELF IN OUT NOCOPY ORDImage, 
            old_object ORDImgB), 
  --
  MEMBER PROCEDURE migrateFromORDImgF( 
            SELF IN OUT NOCOPY ORDImage, 
            old_object ORDImgF),
  --
  --
  -- Static Methods for the relational functional interface
  STATIC PROCEDURE export(ctx             IN OUT RAW,
                          local_data      IN BLOB,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2,
                              format          OUT VARCHAR2,
                              mime_type       OUT VARCHAR2),
  --
  STATIC PROCEDURE getProperties(imageBlob         IN BLOB,
                                 attributes        IN OUT NOCOPY CLOB,
                                 mimeType          OUT VARCHAR2,
                                 width             OUT INTEGER,
                                 height            OUT INTEGER,
                                 fileFormat        IN OUT VARCHAR2,
                                 contentFormat     OUT VARCHAR2,
                                 compressionFormat OUT VARCHAR2,
                                 contentLength     OUT INTEGER),
  --
  STATIC PROCEDURE getProperties(imageBlob         IN BLOB,
                                 attributes        IN OUT NOCOPY CLOB),
  --
  STATIC PROCEDURE getProperties(imageBfile       IN OUT NOCOPY BFILE,
                                 attributes        IN OUT NOCOPY CLOB,
                                 mimeType          OUT VARCHAR2,
                                 width             OUT INTEGER,
                                 height            OUT INTEGER,
                                 fileFormat        IN OUT VARCHAR2,
                                 contentFormat     OUT VARCHAR2,
                                 compressionFormat OUT VARCHAR2,
                                 contentLength     OUT INTEGER),
  --
  STATIC PROCEDURE getProperties(imageBfile       IN OUT NOCOPY BFILE,
                                 attributes        IN OUT NOCOPY CLOB),
  --
  STATIC PROCEDURE process(imageBlob IN OUT NOCOPY BLOB,
                           command IN VARCHAR2),
  --
  STATIC PROCEDURE processCopy(imageBlob IN BLOB,
                               command IN     VARCHAR2, 
                               dest    IN OUT NOCOPY BLOB),
  --
  STATIC PROCEDURE processCopy(imageBfile IN OUT BFILE,
                               command IN     VARCHAR2, 
                               dest    IN OUT NOCOPY BLOB),
  --
  STATIC PROCEDURE process(imageBlob     IN OUT NOCOPY BLOB,
                           command       IN VARCHAR2,
                           width         IN INTEGER,
                           height        IN INTEGER,
                           fileFormat    IN VARCHAR2,
                           contentFormat IN VARCHAR2,
                           compressionFormat IN VARCHAR2),
  --
  STATIC PROCEDURE processCopy(imageBlob IN BLOB,
                               command       IN VARCHAR2, 
                               dest          IN OUT NOCOPY BLOB,
                               width         IN INTEGER,
                               height        IN INTEGER,
                               fileFormat    IN VARCHAR2,
                               contentFormat IN VARCHAR2,
                               compressionFormat IN VARCHAR2),
  --
  STATIC PROCEDURE processCopy(imageBfile    IN OUT NOCOPY BFILE,
                               command       IN VARCHAR2, 
                               dest          IN OUT NOCOPY BLOB,
                               width         IN INTEGER,
                               height        IN INTEGER,
                               fileFormat    IN VARCHAR2,
                               contentFormat IN VARCHAR2,
                               compressionFormat IN VARCHAR2)
);
show errors;
-- END ORDImage data and method declaration

-- BEGIN ORDImageSignature data and method declaration

CREATE TYPE ORDImageSignature
authid current_user
AS OBJECT
(
  -- Signature of the image.  Contains color, texture
  -- and shape information of the image.  It is stored
  -- in a BLOB.

  signature BLOB,

-----------------------
-- METHOD DECLARATION

-- Makes the callout

STATIC FUNCTION init RETURN ORDImageSignature,

STATIC FUNCTION evaluateScore(sig1 IN ORDImageSignature,
                              sig2 IN ORDImageSignature,
			      weights IN VARCHAR2)
  RETURN FLOAT,

STATIC FUNCTION isSimilar(sig1 IN ORDImageSignature,
                          sig2 IN ORDImageSignature,
			  weights IN VARCHAR2,
			  threshold IN FLOAT)
  RETURN PLS_INTEGER,

MEMBER PROCEDURE generateSignature(SELF      IN OUT NOCOPY ORDImageSignature,
				   image     IN ORDImage)
);
/
show errors;

-- END ORDImageSignature data and method declaration


-- END ORDImageSignature DECLARATION SECTION

--
-- END TYPE DECLARATION SECTION
----------------------------------------------------------------


----------------------------------------------------------------
-- BEGIN PACKAGE DECLARATION SECTION
--

--
-- The ORDImageExceptions package is used to raise more meaningful
-- exception messages.
-- 

CREATE OR REPLACE PACKAGE ORDImageExceptions AS

  NULL_CONTENT                          EXCEPTION;
  NULL_PROPERTIES_DESCRIPTION           EXCEPTION;
  NULL_LOCAL_DATA                       EXCEPTION;
  NULL_DESTINATION                      EXCEPTION;
  DATA_NOT_LOCAL                        EXCEPTION;
  NULL_SOURCE                           EXCEPTION;
  INDEX_CREATE_STR_PARSE_ERR            EXCEPTION;
  DUPL_PARAM_STR                        EXCEPTION;
  THRESHOLD_OUT_OF_RANGE                EXCEPTION;
  INVALID_MIME_TYPE                     EXCEPTION;

END ORDImageExceptions;
/
show errors;

CREATE OR REPLACE PACKAGE ORDImageConstants AS 
  RPIX_HEADER_LENGTH_1_0   CONSTANT INTEGER := 34; 
-- image matching constants
  NUM_IDX_ATTR             CONSTANT INTEGER := 63;
  NUM_VIR_IDX_ATTR         CONSTANT INTEGER := 25;
  THRESHOLD_LOWER_BOUND    CONSTANT NUMBER  := 0.0;
  THRESHOLD_UPPER_BOUND    CONSTANT NUMBER  := 100.0;
  SCORE_LOWER_BOUND        CONSTANT NUMBER  := 0.0;
  SCORE_UPPER_BOUND        CONSTANT NUMBER  := 100.0;
END ORDImageConstants; 
/ 
show errors; 

CREATE OR REPLACE PACKAGE ORDImg_Pkg
  authid current_user
AS
  FUNCTION ordimgB_setProperties(
    content       IN     BLOB,
    height        OUT BINARY_INTEGER,
    width         OUT BINARY_INTEGER,
    contentLength OUT BINARY_INTEGER,
    fileFormat    OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2) return BINARY_INTEGER;

  FUNCTION ordimg_headerlessSetProperties(
    description    IN  VARCHAR2,
    height         OUT BINARY_INTEGER,
    width          OUT BINARY_INTEGER,
    fileFormat     OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2,
    mimeType       OUT VARCHAR2)
  return BINARY_INTEGER;

  FUNCTION ordimgB_process(
    command        IN     VARCHAR2,
    headerlessInfo IN     VARCHAR2,
    src            IN     BLOB,
    dest           IN OUT NOCOPY BLOB)
  return BINARY_INTEGER;

  FUNCTION ordimgF_setProperties(
    content        IN     BFILE,
    height         OUT BINARY_INTEGER,
    width          OUT BINARY_INTEGER,
    contentLength  OUT BINARY_INTEGER,
    fileFormat     OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2)
  return BINARY_INTEGER;

  FUNCTION ordimgF_processCopy( 
    command        IN     VARCHAR2,
    headerlessInfo IN     VARCHAR2,
    src            IN     BFILE, 
    dest           IN OUT NOCOPY BLOB)
  return BINARY_INTEGER;

  FUNCTION getMimeType(
    FileFormat IN VARCHAR2) 
  RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS);

  PROCEDURE buildXMLAttributes(
    retAttributes     IN OUT NOCOPY CLOB,
    mimeType          IN VARCHAR2,
    width             IN INTEGER,
    height            IN INTEGER,
    fileFormat        IN VARCHAR2,
    contentFormat     IN VARCHAR2,
    compressionFormat IN VARCHAR2,
    contentLength     IN INTEGER,
    version           IN INTEGER);

  PROCEDURE copy(
    S    IN OUT NOCOPY ORDImage, 
    dest IN OUT NOCOPY ORDImage);

  PROCEDURE process(
    S       IN OUT NOCOPY ORDImage,
    command IN            VARCHAR2);

  PROCEDURE processCopy(
    S       IN OUT NOCOPY ORDImage,
    command IN            VARCHAR2,
    dest    IN OUT NOCOPY ORDImage);

  PROCEDURE setProperties(
    S       IN OUT NOCOPY ORDImage);
  
  PROCEDURE setProperties(
    S           IN OUT NOCOPY ORDImage,
    description IN            VARCHAR2);
  
  FUNCTION checkProperties(
    S IN ORDImage)
  RETURN BOOLEAN;

  PROCEDURE import(
    S              IN OUT NOCOPY ORDImage,
    ctx            IN OUT        RAW);

  PROCEDURE importFrom(
    S               IN OUT NOCOPY ORDImage,
    ctx             IN OUT        RAW,
    source_type     IN            VARCHAR2,
    source_location IN            VARCHAR2,
    source_name     IN            VARCHAR2);

  PROCEDURE getHeaderlessInfo(
          fileFormat        IN  VARCHAR2,
          height            IN  NUMBER,
          width             IN  NUMBER,
          compressionFormat IN  VARCHAR2,
          contentFormat     IN  VARCHAR2,
          info              OUT VARCHAR2);

  PROCEDURE copyContent(source IN OUT BFILE, dest IN OUT NOCOPY BLOB);
  PROCEDURE setProperties(S IN OUT NOCOPY ORDImgF);
  PROCEDURE setProperties(S IN OUT NOCOPY ORDImgF, description IN VARCHAR2);
  PROCEDURE processCopy(S IN OUT NOCOPY ORDImgF,
                        command IN VARCHAR2,
                        dest IN OUT NOCOPY BLOB);
  FUNCTION  checkProperties(S IN ORDImgF) RETURN BOOLEAN;

  PROCEDURE copyContent(source IN OUT NOCOPY BLOB, dest IN OUT NOCOPY BLOB);
  PROCEDURE setProperties(S IN OUT NOCOPY ORDImgB);
  PROCEDURE setProperties(S IN OUT NOCOPY ORDImgB, description IN VARCHAR2);
  PROCEDURE process(S IN OUT NOCOPY ORDImgB, command IN VARCHAR2);
  PROCEDURE processCopy(S IN OUT NOCOPY ORDImgB,
                        command IN VARCHAR2,
                        dest IN OUT NOCOPY BLOB);
  PROCEDURE deleteContent(S IN OUT NOCOPY ORDImgB);
  FUNCTION  checkProperties(S IN ORDImgB) RETURN BOOLEAN;

  PROCEDURE ORDImgB2ORDImage(src IN ORDImgB, dest IN OUT NOCOPY ORDImage); 
  PROCEDURE ORDImgF2ORDImage(src IN ORDImgF, dest IN OUT NOCOPY ORDImage); 

  FUNCTION getImageProperties(
    content       IN     BLOB,
    height        OUT    NUMBER,
    width         OUT    NUMBER,
    contentLength OUT    NUMBER,
    fileFormat    OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2,
    addnlErrorText      OUT VARCHAR2)
  return    NUMBER;

  FUNCTION imageConvert(
    command        IN     VARCHAR2,
    headerlessInfo IN     VARCHAR2,
    src            IN     BLOB,
    dest           IN OUT NOCOPY BLOB,
    addnlErrorText    OUT VARCHAR2)
  return    NUMBER;

  FUNCTION getImageProperties(
    content        IN     BFILE,
    height         OUT    NUMBER,
    width          OUT    NUMBER,
    contentLength  OUT    NUMBER,
    fileFormat     OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2,
    addnlErrorText      OUT VARCHAR2)
  return    NUMBER;

  FUNCTION imageConvert(
    command        IN     VARCHAR2,
    headerlessInfo IN     VARCHAR2,
    src            IN     BFILE,
    dest           IN OUT NOCOPY BLOB,
    addnlErrorText    OUT VARCHAR2)
  return    NUMBER;

END ORDImg_Pkg;
/
show errors;

CREATE OR REPLACE PACKAGE ORDImgSig_Pkg
  authid current_user
AS
  FUNCTION generateSignatureFunc(content   IN BLOB,
                                 width     IN PLS_INTEGER,
				 height    IN PLS_INTEGER,
				 signature IN OUT BLOB)
  RETURN PLS_INTEGER
  IS
  LANGUAGE C
  NAME "kidigen_sig" LIBRARY ORDIMLIBT
  WITH CONTEXT
  PARAMETERS(
          CONTEXT,
	  content  OCILobLocator,
	  height   sb4,
	  width    sb4,
	  signature OCILobLocator,
	  signature INDICATOR sb4);
  
  -- internal usage only--
  PROCEDURE analyzeFunc(content     IN    ORDSYS.ORDImage,
                        signature   OUT   RAW);


  -- internal usage only--
  FUNCTION generateRawSignatureFunc(content    IN    BLOB,
                                    width      IN    PLS_INTEGER,
                                    height     IN    PLS_INTEGER,
                                    signature  OUT   RAW)
  RETURN PLS_INTEGER 
  IS
  LANGUAGE C
  NAME "kidivir_sig" LIBRARY ORDIMLIBT
  WITH CONTEXT
  PARAMETERS(
             CONTEXT,
             content OCILobLocator,
             height  sb4,
             width   sb4,
             signature RAW,
             signature LENGTH sb4,
             signature MAXLEN sb4,
             signature INDICATOR);

  -- internal usage only--
  FUNCTION Score(Signature1    IN   RAW,
                 Signature2    IN   RAW,
                 Weights       IN   VARCHAR2)
  RETURN FLOAT
  IS
  LANGUAGE C
  NAME "kidivir_scr" LIBRARY ORDIMLIBT
  WITH CONTEXT
  PARAMETERS(
             CONTEXT,
             Signature1    RAW,
             Signature1    LENGTH sb4,
             Signature1    INDICATOR ,
             Signature2    RAW,
             Signature2    LENGTH sb4,
             Signature2    INDICATOR ,
             Weights       String);
  PRAGMA RESTRICT_REFERENCES(Score,WNDS,RNDS,WNPS,RNPS);
END ORDImgSig_Pkg;
/
show errors;

--
-- External Codec Package
--
CREATE OR REPLACE PACKAGE ORDImgExtCodec_Pkg
AUTHID CURRENT_USER
AS

  FUNCTION jpeg_decode(inputlob      IN BLOB,
                  inputlobReadPos    IN PLS_INTEGER,
                  headerlob          IN BLOB,
                  outColorID         IN PLS_INTEGER,
                  outputlobWritePos  IN PLS_INTEGER,
                  outputlob          IN OUT NOCOPY BLOB)
  RETURN PLS_INTEGER;

  FUNCTION jpeg_decode(inputfile     IN BFILE,
                  inputfileReadPos   IN PLS_INTEGER,
                  headerlob          IN BLOB,
                  outColorID         IN PLS_INTEGER,
                  outputlobWritePos  IN PLS_INTEGER,
                  outputlob          IN OUT NOCOPY BLOB)
  RETURN PLS_INTEGER;

  FUNCTION jpeg_encode(inputlob       IN BLOB,
                   inputlobReadPos    IN PLS_INTEGER,
                   headerlob          IN BLOB,
                   imageWidth         IN PLS_INTEGER,
                   imageHeight        IN PLS_INTEGER,
                   inNumComponents    IN PLS_INTEGER,
                   inColorID          IN PLS_INTEGER,
                   outputlobWritePos  IN PLS_INTEGER,
                   outputBytesWritten OUT PLS_INTEGER,
                   outputlob          IN OUT NOCOPY BLOB)
  RETURN PLS_INTEGER;

  FUNCTION mmtk_getProperties(inputLob          IN   BLOB,
                              height            OUT  PLS_INTEGER,
                              width             OUT  PLS_INTEGER,
                              contentLength     OUT  PLS_INTEGER,
                              fileFormat        OUT  VARCHAR2,
                              contentFormat     OUT  VARCHAR2,
                              compressionFormat OUT  VARCHAR2)
  RETURN PLS_INTEGER;

  FUNCTION mmtk_getProperties(inputFile         IN   BFILE,
                              height            OUT  PLS_INTEGER,
                              width             OUT  PLS_INTEGER,
                              contentLength     OUT  PLS_INTEGER,
                              fileFormat        OUT  VARCHAR2,
                              contentFormat     OUT  VARCHAR2,
                              compressionFormat OUT  VARCHAR2)
  RETURN PLS_INTEGER;

  FUNCTION mmtk_process(command          IN VARCHAR2,
                        headerlessInfo   IN VARCHAR2,
                        srcLob           IN BLOB,
                        destLob          IN OUT NOCOPY BLOB)
  RETURN PLS_INTEGER;

  FUNCTION mmtk_ext_process(command      IN VARCHAR2,
                        headerlessInfo   IN VARCHAR2,
                        srcLob           IN BLOB,
                        destLob          IN OUT NOCOPY BLOB)
  RETURN PLS_INTEGER;

  FUNCTION mmtk_process(command          IN VARCHAR2,
                        headerlessInfo   IN VARCHAR2,
                        srcFile          IN BFILE,
                        destLob          IN OUT NOCOPY BLOB)
  RETURN PLS_INTEGER;

  FUNCTION mmtk_ext_process(command      IN VARCHAR2,
                        headerlessInfo   IN VARCHAR2,
                        srcFile          IN BFILE,
                        destLob          IN OUT NOCOPY BLOB)
  RETURN PLS_INTEGER;


END ORDImgExtCodec_Pkg;
/
show errors;

--
-- END PACKAGE DECLARATION SECTION
----------------------------------------------------------------
