Rem
Rem $Header: catxs.sql 28-jun-2002.12:48:44 zqiu Exp $
Rem
Rem catxs.sql
Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catxs.sql - eXpreSs Catalog creation
Rem
Rem    DESCRIPTION
Rem      This loads the catalog for the analytic workspaces
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    zqiu        06/28/02 - backport:trigger to clean up aw$, ps$ when user table is gone.
Rem    jcarey      10/18/01 - remove lobtab from aw$
Rem    esoyleme    09/25/01 - esoyleme_txn100146
Rem    esoyleme    09/13/01 - views in spec..
Rem    esoyleme    09/10/01 - creation

--create views on aw$

create or replace view DBA_AWS
(OWNER, AW_NUMBER, AW_NAME, PAGESPACES, GENERATIONS)
as
SELECT u.name, a.awseq#, a.awname, count(unique(p.psnumber)), 
	count(unique(p.psgen))
FROM aw$ a, ps$ p, user$ u
WHERE   a.owner#=u.user# and a.awseq#=p.awseq#
group by a.awseq#, a.awname, u.name
/

comment on table DBA_AWS is
'Analytic Workspaces in the database'
/
comment on column DBA_AWS.OWNER is
'Owner of the Analytic Workspace'
/
comment on column DBA_AWS.AW_NUMBER is
'Number of the Analytic Workspace'
/
comment on column DBA_AWS.AW_NAME is
'Name of the Analytic Workspace'
/
comment on column DBA_AWS.PAGESPACES is
'Number of pagespaces in the Analytic Workspace'
/
comment on column DBA_AWS.GENERATIONS is
'Number of active generations in the Analytic Workspace'
/

create or replace view USER_AWS
(AW_NUMBER, AW_NAME, PAGESPACES, GENERATIONS)
as
SELECT a.awseq#, a.awname, count(unique(p.psnumber)), count(unique(p.psgen))
FROM aw$ a, ps$ p
WHERE   a.owner#=USERENV('SCHEMAID') and a.awseq#=p.awseq#
group by a.awseq#, a.awname
/

comment on table USER_AWS is
'Analytic Workspaces owned by the user'
/
comment on column DBA_AWS.AW_NUMBER is
'Number of the Analytic Workspace'
/
comment on column USER_AWS.AW_NAME is
'Name of the Analytic Workspace'
/
comment on column USER_AWS.PAGESPACES is
'Number of pagespaces in the Analytic Workspace'
/
comment on column USER_AWS.GENERATIONS is
'Number of active generations in the Analytic Workspace'
/

--create views on ps$

create or replace view DBA_AW_PS
(OWNER, AW_NUMBER, AW_NAME, PSNUMBER, GENERATIONS)
as
SELECT u.name, a.awseq#, a.awname, p.psnumber, count(unique(p.psgen))
FROM aw$ a, ps$ p, user$ u
WHERE   a.owner#=u.user# and a.awseq#=p.awseq#
group by a.awseq#, a.awname, u.name, p.psnumber
/

comment on table DBA_AW_PS is
'Pagespaces in Analytic Workspaces owned by the user'
/
comment on column DBA_AW_PS.OWNER is
'Owner of the Analytic Workspace'
/
comment on column DBA_AWS.AW_NUMBER is
'Number of the Analytic Workspace'
/
comment on column DBA_AW_PS.AW_NAME is
'Name of the Analytic Workspace'
/
comment on column DBA_AW_PS.PSNUMBER is
'Number of the pagespace'
/
comment on column DBA_AW_PS.GENERATIONS is
'Number of active generations in the pagespace'
/

create or replace view USER_AW_PS
(AW_NUMBER, AW_NAME, PSNUMBER, GENERATIONS)
as
SELECT a.awseq#, a.awname, p.psnumber, count(unique(p.psgen))
FROM aw$ a, ps$ p
WHERE   a.owner#=USERENV('SCHEMAID') and a.awseq#=p.awseq#
group by a.awseq#, a.awname, p.psnumber
/

comment on table USER_AW_PS is
'Pagespaces in Analytic Workspaces owned by the user'
/
comment on column DBA_AWS.AW_NUMBER is
'Number of the Analytic Workspace'
/
comment on column USER_AW_PS.AW_NAME is
'Name of the Analytic Workspace'
/
comment on column USER_AW_PS.PSNUMBER is
'Number of the pagespace'
/
comment on column USER_AW_PS.GENERATIONS is
'Number of active generations in the pagespace'
/

CREATE OR REPLACE PUBLIC SYNONYM DBA_AWS FOR SYS.DBA_AWS
/
GRANT DELETE, INSERT, SELECT, UPDATE ON DBA_AWS to select_catalog_role
/
CREATE OR REPLACE PUBLIC SYNONYM DBA_AW_PS FOR SYS.DBA_AW_PS
/
GRANT DELETE, INSERT, SELECT, UPDATE ON DBA_AW_PS to select_catalog_role
/

CREATE OR REPLACE PUBLIC SYNONYM USER_AWS FOR SYS.USER_AWS
/
GRANT DELETE, INSERT, SELECT, UPDATE ON USER_AWS to public
/
CREATE OR REPLACE PUBLIC SYNONYM USER_AW_PS FOR SYS.USER_AW_PS
/
GRANT DELETE, INSERT, SELECT, UPDATE ON USER_AW_PS to public
/


CREATE OR REPLACE PROCEDURE aw_drop_proc 
  (obj_type IN VARCHAR2, obj_name IN VARCHAR2, obj_owner IN VARCHAR2)
AS
  db_name VARCHAR2(50);	
  db_awnum  NUMBER;
  db_exist NUMBER;
BEGIN 
-- 1. Check if we are deleting a table prefixed with 'AW$'.
-- 2. Check if both AW$ and PS$ tables are there. 
  IF obj_type = 'TABLE' THEN    IF obj_name like 'AW$_%' THEN
      SELECT count(table_name) INTO db_exist 
      FROM user_tables 
      WHERE table_name = 'AW$' or table_name = 'PS$';
      IF db_exist = 2 THEN
  
        db_name := SUBSTR(obj_name, 4, LENGTH(obj_name));
        SELECT a.awseq# INTO db_awnum FROM aw$ a, user$ u
        WHERE  a.awname = db_name AND
               a.owner# = u.user# and u.name = obj_owner;
        DELETE FROM ps$ WHERE awseq# = db_awnum;	
        DELETE FROM aw$ WHERE awseq# = db_awnum;	
      END IF;
    END IF;  
  END IF;
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    NULL; -- aw$ table may already be empty.
END aw_drop_proc;
/

CREATE OR REPLACE TRIGGER aw_drop_trg AFTER DROP ON DATABASE 
BEGIN 
   aw_drop_proc(ora_dict_obj_type, ora_dict_obj_name, ora_dict_obj_owner);
END;
/
