set   define on
set   verify off
set   termout off 
set   trimout on
set   trimspool on
set   serveroutput on size 1000000
set linesize 400
set feedback off;


COLUMN SPOOLFILE NEW_VALUE SPOOLFILE_VAR NOPRINT;
select 'owa_restore_' || value || '.sql'  spoolfile from v_$SYSTEM_PARAMETER where name='instance_name';

set   termout on 
prompt Backing up previous OWA packages to: &SPOOLFILE_VAR ;
prompt
set   termout off 

spool &SPOOLFILE_VAR ;

declare
     
      
      Type t_owapkg_table IS TABLE OF VARCHAR2(32)
      INDEX BY BINARY_INTEGER;

      owapkgtable t_owapkg_table;

      Counter1       BINARY_INTEGER;
      rowsprocessed       BINARY_INTEGER;
      NEWLINE constant varchar2(1) := '
';

   FUNCTION remove_newline(str IN OUT varchar2)
        RETURN BOOLEAN is
    loc pls_integer;
    ans boolean;
   BEGIN
    loc := instr(str, NEWLINE , 1);
    if (loc > 0) then
     -- str := substr(str, 1, loc - 1) || ' ' || substr(str, loc + 1, length(str) - loc);
     str := substr(str, 1, loc - 1) || substr(str, loc + 1, length(str) - loc);
     ans := true;
    else
      ans := false;
    end if;
    return ans;
   END;


  FUNCTION print_pkg_spec(pkgname IN varchar2) RETURN INTEGER IS
    l_pkgline VARCHAR2(400);
    l_cursor    INTEGER;
    l_rowint    INTEGER;
    l_stmt      VARCHAR2(256);
    l_type      VARCHAR2(32);
    l_status    INTEGER;
    l_bstatus    BOOLEAN;
  BEGIN

    l_type := 'PACKAGE';
    l_rowint := 1;
    l_stmt := 'select text from user_source where UPPER(NAME)=UPPER( :d_pkgname ) and type= :d_type order by line';
    l_cursor := dbms_sql.open_cursor;
    dbms_sql.parse(l_cursor, l_stmt, dbms_sql.native);
    dbms_sql.bind_variable(l_cursor, ':d_pkgname', pkgname);
    dbms_sql.bind_variable(l_cursor, ':d_type', l_type);
    dbms_sql.define_column( l_cursor, 1, l_pkgline, 400 );
    l_status := dbms_sql.execute(l_cursor);

    loop
       if dbms_sql.fetch_rows (l_cursor) > 0 then
          dbms_sql.column_value(l_cursor, 1, l_pkgline);
	  l_bstatus := remove_newline(l_pkgline);
          if l_rowint = 1 then
             if pkgname = 'owa_cx' then
	       dbms_output.put_line('CREATE or REPLACE ');
	       dbms_output.put_line(l_pkgline);
             else
	       dbms_output.put_line('CREATE or REPLACE ' || l_pkgline);
             end if;
             l_rowint := l_rowint + 1;
          else
             if (instr(l_pkgline, 'NLNL_CHAR', 1)) > 0 then
              dbms_output.put(l_pkgline);
              dbms_output.put(NEWLINE);
             else
              dbms_output.put_line(l_pkgline);
             end if;
          end if;
       else
          exit;
       end if;
    end loop;

    if l_rowint = 2 then
       dbms_output.put_line('/');
       dbms_output.put_line('show errors');
       dbms_output.put_line(NEWLINE);
       l_rowint := l_rowint + 1;
    end if;

    dbms_sql.close_cursor(l_cursor);
    
    return l_status;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN  
	  dbms_output.put_line('Not Found');
    WHEN VALUE_ERROR THEN  
	  dbms_output.put_line('Value Error');
    WHEN OTHERS THEN
	  dbms_output.put_line('Error creating Spec: ' || pkgname);
     if dbms_sql.is_open(l_cursor) then
         dbms_sql.close_cursor(l_cursor);
     end if;
     return 0;
  END;


  FUNCTION print_pkg_body(pkgname IN varchar2) RETURN INTEGER IS
    l_pkgline VARCHAR2(400);
    l_cursor    INTEGER;
    l_rowint    INTEGER;
    l_stmt      VARCHAR2(256);
    l_type      VARCHAR2(32);
    l_status    INTEGER;
    l_bstatus    BOOLEAN;
  BEGIN

    l_type := 'PACKAGE BODY';
    l_rowint := 1;
    l_stmt := 'select text from user_source where UPPER(NAME)=UPPER( :d_pkgname ) and type= :d_type order by line';
    l_cursor := dbms_sql.open_cursor;
    dbms_sql.parse(l_cursor, l_stmt, dbms_sql.native);
    dbms_sql.bind_variable(l_cursor, ':d_pkgname', pkgname);
    dbms_sql.bind_variable(l_cursor, ':d_type', l_type);
    dbms_sql.define_column( l_cursor, 1, l_pkgline, 400 );
    l_status := dbms_sql.execute(l_cursor);

    loop
       if dbms_sql.fetch_rows (l_cursor) > 0 then
          dbms_sql.column_value(l_cursor, 1, l_pkgline);
	  l_bstatus := remove_newline(l_pkgline);
          if l_rowint = 1 then
             if pkgname = 'owa_cx' then
	       dbms_output.put_line('CREATE or REPLACE ');
	       dbms_output.put_line(l_pkgline);
             else
	       dbms_output.put_line('CREATE or REPLACE ' || l_pkgline);
             end if;
             l_rowint := l_rowint + 1;
          else
             if (instr(l_pkgline, 'NLNL_CHAR', 1)) > 0 then
              dbms_output.put(l_pkgline);
              dbms_output.put(NEWLINE);
             else
              dbms_output.put_line(l_pkgline);
             end if;
          end if;
       else
          exit;
       end if;
    end loop;

    if l_rowint = 2 then
       dbms_output.put_line('/');
       dbms_output.put_line('show errors');
       dbms_output.put_line(NEWLINE);
       l_rowint := l_rowint + 1;
    end if;

    dbms_sql.close_cursor(l_cursor);
    
    return l_status;

  EXCEPTION
    WHEN OTHERS THEN
	  dbms_output.put_line('Error creating Body: ' || pkgname);
     if dbms_sql.is_open(l_cursor) then
         dbms_sql.close_cursor(l_cursor);
     end if;
     return 0;
  END;


begin

      owapkgtable(1) := 'owa_cx';
      owapkgtable(2) := 'owa_custom';
      owapkgtable(3) := 'htf';
      owapkgtable(4) := 'htp';
      owapkgtable(5) := 'owa_util';
      owapkgtable(6) := 'owa_sec';
      owapkgtable(7) := 'owa';
      owapkgtable(8) := 'owa_text';
      owapkgtable(9) := 'owa_pattern';
      owapkgtable(10) := 'owa_image';
      owapkgtable(11) := 'owa_cookie';
      owapkgtable(12) := 'owa_opt_lock';
      owapkgtable(13) := 'owa_cache';
      owapkgtable(14) := 'owa_match';
      owapkgtable(15) := 'wpg_docload';


    begin
	    
  
         FOR Counter1  IN 1 .. 15 LOOP
	          -- dbms_output.put_line('pkgname: ' || owapkgtable(Counter1));
                 rowsprocessed := print_pkg_spec(owapkgtable(Counter1));
	         -- dbms_output.put(NEWLINE);

         end Loop;
         
         FOR Counter1  IN 1 .. 15 LOOP

                 rowsprocessed := print_pkg_body(owapkgtable(Counter1));
	         -- dbms_output.put(NEWLINE);
         
         end Loop;
         

      -- commit;
       exception
	   -- 
	   when  OTHERS  then
	          dbms_output.put_line('error : ');

    end; 
end;
/

spool off;
show errors

