Rem
Rem $Header: amdpatch.sql 05-apr-2006.13:42:24 awesley Exp $
Rem
Rem amdpatch.sql
Rem
Rem Copyright (c) 2000, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      amdpatch.sql
Rem
Rem    DESCRIPTION
Rem      Upgrade existing OLAP Catalog schemas to 9.2.0.8 patch release
Rem
Rem    NOTES
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    awesley     04/05/06 - correct corruption caused by bad ade merge
Rem    awesley     03/10/06 - bug 5087329: DISPLAY_NAME and  PLURAL_NAME too short in CWM2$MRALL_HIERDIMS
Rem    awesley     03/20/06 - drop view odm_olap2_dim_hier_level_uses
Rem    awesley     12/06/05 - migrate display and plural name fix from main 
Rem    cdalessi    02/04/05 - Move validation to SYS 
Rem    cdalessi    10/08/04 - Fix invalid state on SE
Rem    dbardwel    08/04/04 - 3 new indexes to fix bug 3813809
Rem    cdalessi    02/26/04 - fixing patch problems for 9205 
Rem    cdalessi    01/13/04 - Further 9205 patch changes
Rem    cdalessi    01/06/04 - 
Rem    cdalessi    12/08/03 - 9.2.0.4 starting point
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    cdalessi    06/18/03 - 9.2.0.3.0
Rem    cdalessi    06/04/03 -
Rem    cdalessi    06/02/03 - Bug 2971733
Rem    cdalessi    04/14/03 - New tables/views
Rem    cdalessi    03/18/03 - Update to handle 9.2.0.2 and/or 9.2.0.3
Rem    dbardwel    03/04/03 - comment out cwm2awmd.sql due to ora06550 errors
Rem    cdalessi    02/28/03 - 9202 to 9203 fixes
Rem    dbardwel    02/14/03 - Minor tweeks per testing with Candance
Rem    dbardwel    02/13/03 - Add stuff that changed post 9.2.0.2 release
Rem    cdalessi    01/31/03 - changing loading/ed to upgrading/ed
Rem    cdalessi    08/05/02 - cdalessi_txn103649
Rem    cdalessi    07/24/02 - Creation

execute sys.dbms_registry.upgrading('AMD');

alter session set current_schema = olapsys;

alter table olapsys.CwM2$Dimension modify (
    displayname varchar2(90),
    pluralname varchar2(90)
); 

alter table olapsys.CwM2$Level modify (
    displayname varchar2(90),
    pluralname varchar2(90)
); 

alter table olapsys.CwM2$Hierarchy modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$DimensionAttribute modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$LevelAttribute modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$Cube modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$Measure modify (
    displayname varchar2(90)
); 

alter table olapsys.CWM2$MRALL_HIERDIMS modify (
     DISPLAY_NAME varchar2(240),
     PLURAL_NAME varchar2(240)
); 

drop package cwm2_olap_aw_create;
drop package cwm2_olap_aw_map;
drop package cwm2_olap_aw_object;
drop package cwm2_olap_aw_utility;

drop view all$aw_load_cube_agg;
drop view all$olap2_aw_map_attr_use;
drop view all$olap2_aw_map_dim_use;
drop view all$olap2_aw_map_meas_use;

drop view odm_olap2_dim_hier_level_uses;

COLUMN :upg_script NEW_VALUE amdu NOPRINT
VARIABLE upg_script VARCHAR2(128)
declare
begin
  if substr(dbms_registry.version('AMD'),1,7)='9.2.0.1' then
    :upg_script := 'amdu9201.sql';
  elsif substr(dbms_registry.version('AMD'),1,7)='9.2.0.2' then
    :upg_script := 'amdu9202.sql';
  elsif substr(dbms_registry.version('AMD'),1,7)='9.2.0.3' then
    :upg_script := 'amdu9203.sql';
  else
    :upg_script := '?/rdbms/admin/nothing.sql';
  end if;
end;
/
SELECT :upg_script FROM DUAL;
@@&amdu

alter table cwm2$awcubeloadparmvalue modify (
    value varchar2(4000)
); 
alter table cwm2$awdimloadparmvalue modify (
    value varchar2(4000)
); 
alter table cwm2$awcompspecmembership drop constraint cwm2$awcompspecmembership_id ;
alter table cwm2$awcompspecmembership add ( constraint cwm2$awcompspecmembership_id unique ( compspec_irid ,membertype ,name ) ) ;

CREATE INDEX CWM2$COMPSPEC_IRID_IDX on OLAPSYS.CWM2$AWCOMPSPECMEMBERSHIP (COMPSPEC_IRID);
CREATE INDEX CWM2$COMPOSITE_IRID_IDX on OLAPSYS.CWM2$AWCOMPSPECMEMBERSHIP (COMPOSITE_IRID);
CREATE INDEX CWM2$CUBECOMPSPEC_IRID_IDX on OLAPSYS.CWM2$AWCUBECOMPPLAN (CUBECOMPSPEC_IRID);

drop package cwm2_olap_validate_mapping;

@@cwm2sed2.sql
@@amdrelod.sql

execute sys.dbms_registry.upgraded('AMD',dbms_registry.release_version);

execute sys.cwm2_olap_installer.Validate_CWM2_Install;

declare
  compat varchar2(30);
begin
  select value into compat from v$option where parameter='OLAP';
  if upper(compat) = 'FALSE' then
    dbms_registry.valid('AMD');
  end if;
end;
/

alter session set current_schema = sys;
