Rem
Rem $Header: amdu9202.sql 27-oct-2003.11:19:58 cdalessi Exp $
Rem
Rem amdu9202.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      amdu9202.sql
Rem
Rem    DESCRIPTION
Rem      Upgrade OLAP Catalog from 9.2.0.2.0
Rem
Rem    NOTES
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    cdalessi    06/19/03 - cdalessi_txn107665
Rem    cdalessi    06/09/03 - 
Rem    cdalessi    06/04/03 - Creation (sort of)

alter table cwm2$awcubeload set unused (
    aggregationindicator,
    loadprocesscode_irid,
    measureloadindicator
);
alter table cwm2$awcubeload modify (
    cube_irid number not null
);
alter table cwm2$awcubeload add (
    loadtype_irid number,
    version_id varchar2(10)
);

alter table cwm2$awcubeloadfilter set unused (
    facttblname,
    facttblowner
);
alter table cwm2$awcubeloadfilter modify (
    cubeload_irid number not null
);
alter table cwm2$awcubeloadfilter add (
    createddate date,
    fact_table_name varchar2(30),
    fact_table_owner varchar2(30),
    lastchangeuser varchar2(30),
    updateddate date
);

alter table cwm2$awdimload set unused (
    loadprocesscode_irid,
    uniquekeys
);
alter table cwm2$awdimload modify (
    dim_irid number not null
);
alter table cwm2$awdimload add (
    loadtype_irid number,
    version_id varchar2(10)
);

alter table cwm2$awdimloadfilter set unused (
    lkuptblname,
    lkuptblowner
);
alter table cwm2$awdimloadfilter modify (
    dimload_irid number not null
);
alter table cwm2$awdimloadfilter add (
    createddate date,
    lastchangeuser varchar2(30),
    lookup_table_name varchar2(30),
    lookup_table_owner varchar2(30),
    updateddate date
);

alter table cwm2$mrall_cube_measures add (
    shortdescription varchar2(240)
);

alter table cwm2$mrall_dim_attributes add (
    shortdescription varchar2(240)
);

alter table cwm2$mrall_dim_hiers add (
    shortdescription varchar2(240)
);

alter table cwm2$mrall_hierdim_keycol_map add (
    shortdescription varchar2(240)
);

alter table cwm2$mrall_hierdims add (
    shortdescription varchar2(240)
);

alter table cwm2$mrall_listdims add (
    shortdescription varchar2(240)
);

create table cwm2$_aw_next_perm_cust_meas (
    aw_access_view_name varchar2(61),
    num_cust_measure varchar2(30),
    text_cust_measure varchar2(30) ) ;

create global temporary table cwm2$_aw_next_temp_cust_meas (
    aw_access_view_name varchar2(61),
    num_cust_measure varchar2(30),
    text_cust_measure varchar2(30) ) on commit preserve rows ;

create table cwm2$_aw_perm_cust_meas_map (
    aw_access_view_name varchar2(61) not null,
    aw_measure_name varchar2(64),
    cust_adt_column varchar2(30) not null,
    sessionid varchar2(10),
    username varchar2(30),
    workspace_name varchar2(61) ) ;

create global temporary table cwm2$_aw_temp_cust_meas_map (
    aw_access_view_name varchar2(61) not null,
    aw_measure_name varchar2(64),
    cust_adt_column varchar2(30) not null,
    sessionid varchar2(10),
    username varchar2(30),
    workspace_name varchar2(61) ) on commit preserve rows ;

create global temporary table cwm2$_temp_values (
    int_var number(30),
    num_var number(36,6),
    text_var varchar2(255) ) on commit preserve rows ;

create table cwm2$awcompositespec (
    createddate date,
    cube_irid number not null,
    irid number not null,
    lastchangeuser varchar2(30),
    name varchar2(30),
    updateddate date,
    version_id varchar2(10) ) ;

create table cwm2$awcompspecmembership (
    composite_irid number,
    composite_position number,
    compspec_irid number not null,
    compspec_position number,
    createddate date,
    dim_irid number,
    irid number not null,
    lastchangeuser varchar2(30),
    membertype varchar2(10),
    name varchar2(30),
    segwidth number,
    updateddate date ) ;

create table cwm2$awcubeagg (
    createddate date,
    cube_irid number not null,
    irid number not null,
    lastchangeuser varchar2(30),
    name varchar2(60),
    updateddate date,
    version_id varchar2(10) ) ;

create table cwm2$awcubeagglevel (
    createddate date,
    cubeagg_irid number not null,
    dim_irid number not null,
    irid number not null,
    lastchangeuser varchar2(30),
    level_irid number not null,
    updateddate date ) ;

create table cwm2$awcubeaggmeasure (
    createddate date,
    cubeagg_irid number not null,
    irid number not null,
    lastchangeuser varchar2(30),
    measure_irid number not null,
    updateddate date ) ;

create table cwm2$awcubecompplan (
    createddate date,
    cubecompspec_irid number not null,
    cubeload_irid number not null,
    irid number not null,
    lastchangeuser varchar2(30),
    updateddate date ) ;

create global temporary table cwm2$awcubecreateaccess (
    cube_name varchar2(30),
    cube_owner varchar2(30),
    processaction varchar2(30),
    query_text clob,
    runid# number ) on commit preserve rows ;

create table cwm2$awcubeloadaggplan (
    createddate date,
    cubeagg_irid number not null,
    cubeload_irid number not null,
    irid number not null,
    lastchangeuser varchar2(30),
    updateddate date ) ;

create table cwm2$awcubeloadmeasure (
    createddate date,
    cubeload_irid number not null,
    displayname varchar2(60),
    irid number not null,
    lastchangeuser varchar2(30),
    measure_irid number not null,
    name varchar2(60),
    updateddate date ) ;

create table cwm2$awcubeloadparm (
    datatype varchar2(30),
    default_value varchar2(30),
    irid number not null,
    name varchar2(16) ) ;

create table cwm2$awcubeloadparmvalue (
    createddate date,
    cubeload_irid number not null,
    irid number not null,
    lastchangeuser varchar2(30),
    parmname_irid number not null,
    updateddate date,
    value varchar2(30) ) ;

create table cwm2$awcubeloadtype (
    description varchar2(255),
    irid number not null,
    name varchar2(60) ) ;

create global temporary table cwm2$awdimcreateaccess (
    dim_name varchar2(30),
    dim_owner varchar2(30),
    processaction varchar2(30),
    query_text clob,
    runid# number ) on commit preserve rows ;

create table cwm2$awdimloadparm (
    datatype varchar2(30),
    default_value varchar2(30),
    irid number not null,
    name varchar2(16) ) ;

create table cwm2$awdimloadparmvalue (
    createddate date,
    dimload_irid number not null,
    irid number not null,
    lastchangeuser varchar2(30),
    parmname_irid number not null,
    updateddate date,
    value varchar2(30) ) ;

create table cwm2$awdimloadtype (
    description varchar2(255),
    irid number not null,
    name varchar2(60) ) ;

create table cwm2$awviews (
    createddate date,
    irid number not null,
    lastchangeuser varchar2(30),
    rowtocellcol_id number,
    table_id number not null,
    updateddate date,
    view_name varchar2(30) not null,
    view_owner varchar2(30) not null ) ;

create table cwm2$mrall_awviews (
    rowtocellcol_name varchar2(30),
    view_name varchar2(30),
    view_owner varchar2(30) ) ;



REM
REM Constraints
REM
 alter table cwm2$awdimloadparmvalue add ( constraint cwm2$awdimloadparmvalue_pk primary key ( irid ) ) ;
 alter table cwm2$awdimloadparm add ( constraint cwm2$awdimloadparm_pk primary key ( irid ) ) ;
 alter table cwm2$awdimloadtype add ( constraint cwm2$awdimloadtype_pk primary key ( irid ) ) ;
 alter table cwm2$awcubeloadparmvalue add ( constraint cwm2$awcubeloadparmvalue_pk primary key ( irid ) ) ;
 alter table cwm2$awcubeloadparm add ( constraint cwm2$awcubeloadparm_pk primary key ( irid ) ) ;
 alter table cwm2$awcubeloadtype add ( constraint cwm2$awcubeloadtype_pk primary key ( irid ) ) ;
 alter table cwm2$awcubeloadmeasure add ( constraint cwm2$awcubeloadmeasure_pk primary key ( irid ) ) ;
 alter table cwm2$awcubeloadaggplan add ( constraint cwm2$awcubeloadaggplan_pk primary key ( irid ) ) ;
 alter table cwm2$awcubeagg add ( constraint cwm2$awcubeagg_pk primary key ( irid ) ) ;
 alter table cwm2$awcubeagglevel add ( constraint cwm2$awcubeagglevel_pk primary key ( irid ) ) ;
 alter table cwm2$awcubeaggmeasure add ( constraint cwm2$awcubeaggmeasure_pk primary key ( irid ) ) ;
 alter table cwm2$awcompositespec add ( constraint cwm2$awcompositespec_pk primary key ( irid ) ) ;
 alter table cwm2$awcompspecmembership add ( constraint cwm2$awcompspecmembership_pk primary key ( irid ) ) ;
 alter table cwm2$awcubecompplan add ( constraint cwm2$awcubecompplan_pk primary key ( irid ) ) ;
 alter table cwm2$awdimload add ( constraint cwm2$awdimload_name unique ( dim_irid, version_id, name ) ) ;
 alter table cwm2$awdimloadfilter add ( constraint cwm2$awdimloadfilter_id unique ( dimload_irid, lookup_table_owner, lookup_table_name ) ) ;
 alter table cwm2$awdimloadparmvalue add ( constraint cwm2$awdimloadparmvalue_id unique ( dimload_irid, parmname_irid ) ) ;
 alter table cwm2$awcubeload add ( constraint cwm2$awcubeload_name unique ( cube_irid, version_id, name ) ) ;
 alter table cwm2$awcubeloadfilter add ( constraint cwm2$awcubeloadfilter_id unique ( cubeload_irid, fact_table_owner, fact_table_name ) ) ;
 alter table cwm2$awcubeloadparmvalue add ( constraint cwm2$awcubeloadparmvalue_id unique ( cubeload_irid, parmname_irid ) ) ;
 alter table cwm2$awcubeagg add ( constraint cwm2$awcubeagg_name unique ( cube_irid, version_id, name ) ) ;
 alter table cwm2$awcubeagglevel add ( constraint cwm2$awcubeagglevel_id unique ( cubeagg_irid, dim_irid, level_irid ) ) ;
 alter table cwm2$awcubeaggmeasure add ( constraint cwm2$awcubeaggmeasure_id unique ( cubeagg_irid, measure_irid ) ) ;
 alter table cwm2$awcompositespec add ( constraint cwm2$awcompositespec_id unique ( cube_irid ,version_id, name ) ) ;
 alter table cwm2$awcompspecmembership add ( constraint cwm2$awcompspecmembership_id unique ( compspec_irid ,name ) ) ;
 alter table cwm2$awdimloadfilter add constraint cwm2$awdimloadfilter_fk1 foreign key ( dimload_irid ) references cwm2$awdimload ( irid ) on delete cascade ;
 alter table cwm2$awdimloadparmvalue add constraint cwm2$awdimloadparmvalue_fk1 foreign key ( dimload_irid ) references cwm2$awdimload ( irid ) on delete cascade ;
 alter table cwm2$awcubeloadfilter add constraint cwm2$awcubeloadfilter_fk1 foreign key ( cubeload_irid ) references cwm2$awcubeload ( irid ) on delete cascade ;
 alter table cwm2$awcubeloadparmvalue add constraint cwm2$awcubeloadparmvalue_fk1 foreign key ( cubeload_irid ) references cwm2$awcubeload ( irid ) on delete cascade ;
 alter table cwm2$awcubeloadmeasure add constraint cwm2$awcubeloadmeasure_fk foreign key ( cubeload_irid ) references cwm2$awcubeload ( irid ) on delete cascade ;
 alter table cwm2$awcubeagglevel add constraint cwm2$awcubeagglevel_fk1 foreign key ( cubeagg_irid ) references cwm2$awcubeagg ( irid ) on delete cascade ;
 alter table cwm2$awcubeaggmeasure add constraint cwm2$awcubeaggmeasure_fk1 foreign key ( cubeagg_irid ) references cwm2$awcubeagg ( irid ) on delete cascade ;
 alter table cwm2$awcubeloadaggplan add constraint cwm2$awcubeloadaggplan_fk1 foreign key ( cubeload_irid ) references cwm2$awcubeload ( irid ) on delete cascade ;
 alter table cwm2$awcubeloadaggplan add constraint cwm2$awcubeloadaggplan_fk2 foreign key ( cubeagg_irid ) references cwm2$awcubeagg ( irid ) on delete cascade ;
 alter table cwm2$awcompspecmembership add constraint cwm2$awcompspecmembership_fk1 foreign key ( compspec_irid ) references cwm2$awcompositespec ( irid ) on delete cascade ;
 alter table cwm2$awcompspecmembership add constraint cwm2$awcompspecmembership_fk2 foreign key ( composite_irid ) references cwm2$awcompspecmembership ( irid ) on delete cascade ;
 alter table cwm2$awcubecompplan add constraint cwm2$awcubecompplan_fk1 foreign key ( cubeload_irid ) references cwm2$awcubeload ( irid ) on delete cascade ;
 alter table cwm2$awcubecompplan add constraint cwm2$awcubecompplan_fk2 foreign key ( cubecompspec_irid ) references cwm2$awcompositespec ( irid ) on delete cascade ;
 alter table cwm2$awviews add ( constraint cwm2$awviews_tblunq unique ( table_id ) ) ;
 alter table cwm2$awviews add ( constraint cwm2$awviews_tblunq2 unique ( view_owner, view_name ) ) ;

create index cwm2$_cust_meas_view_name on cwm2$_aw_next_perm_cust_meas ( aw_access_view_name ) ;
create index cwm2$_view_and_cust_meas_col on cwm2$_aw_perm_cust_meas_map ( aw_access_view_name, cust_adt_column ) ;
grant select, insert, update, delete on cwm2$_aw_next_temp_cust_meas to public;
grant select, insert, update, delete on cwm2$_aw_temp_cust_meas_map to public;
grant select, insert, update, delete on cwm2$_temp_values to public;

@@amdu9203.sql