Rem
Rem $Header: amdu9203.sql 11-nov-2003.13:56:55 cdalessi Exp $
Rem
Rem amdu9203.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      amdu9203.sql
Rem
Rem    DESCRIPTION
Rem      Upgrade OLAP Catalog from 9.2.0.3.0
Rem
Rem    NOTES
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    11/11/03 - Add call to amdu9204.sql 
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    cdalessi    07/01/03 - Drop certain constraints and readd less
Rem			      restrictive constraints.
Rem    cdalessi    06/19/03 - Creation


alter table cwm2$awcubeloadmeasure add (
    description varchar2(4000)
); 

alter table cwm2$awviews add (
    aw_name varchar2(30),
    aw_owner varchar2(30)
); 

alter table cwm2$factkeydimhiermap add (
    aggoperator_irid number,
    aggorder number,
    aggweightcol_id number,
    aggweighttbl_id number
); 

alter table cwm2$mrall_awviews add (
    aw_name varchar2(30),
    aw_owner varchar2(30)
); 

alter table cwm2$mrall_dim_level_attr_maps modify (
    dtype varchar2(106)
); 
alter table cwm2$mrall_dim_level_attr_maps add (
    data_length number,
    data_precision number,
    olap_api_data_type number
); 

alter table cwm2$mrall_facttblfctmaps modify (
    data_type varchar2(106)
); 
alter table cwm2$mrall_facttblfctmaps add (
    data_length number,
    data_precision number,
    olap_api_data_type number
); 

alter table cwm2$mrall_facttblkeymaps add (
    column_data_length number,
    column_data_precision number,
    column_data_type varchar2(106),
    gid_column_data_length number,
    gid_column_data_precision number,
    gid_column_data_type varchar2(106)
); 

alter table cwm2$mrall_hier_custom_sort add (
    data_length number,
    data_precision number,
    data_type varchar2(106)
); 

alter table cwm2$mrall_hierdim_keycol_map add (
    data_length number,
    data_precision number,
    data_type varchar2(106)
); 

alter table cwm2$mrall_listdims add (
    data_length number,
    data_precision number,
    data_type varchar2(106)
); 

alter table cwm2$mrfacttblfctmaps modify (
    data_type varchar2(106)
); 
alter table cwm2$mrfacttblfctmaps add (
    data_length number,
    data_precision number,
    olap_api_data_type number
); 

create table cwm2$awviewcols ( 
    awobject varchar2(2000),
    awviews_irid number not null,
    column_id number,
    createddate date,
    irid number not null,
    lastchangeuser varchar2(30),
    updateddate date ) ;

create table cwm2$mrall_awviewcols ( 
    awobject varchar2(2000),
    column_name varchar2(30),
    view_name varchar2(30),
    view_owner varchar2(30) ) ;

create table cwm2$mrall_cwm1_aggop ( 
    column_name varchar2(30),
    cube_name varchar2(30),
    dimension_name varchar2(30),
    dimension_owner varchar2(30),
    func_name varchar2(240),
    id number,
    measure_name varchar2(30),
    owner varchar2(30),
    table_name varchar2(30),
    table_owner varchar2(30),
    version_id char(4) ) ;

create table cwm2$mrall_cwm1_aggord ( 
    cube_name varchar2(30),
    dimension_name varchar2(30),
    dimension_owner varchar2(30),
    id number,
    owner varchar2(30),
    position number,
    version_id char(4) ) ;

create table cwm2$mrall_olap2_agg_uses ( 
    aggregation_name varchar2(240),
    aggregation_order number,
    column_name varchar2(30),
    cube_name varchar2(30),
    dim_hier_combo_id number,
    dimension_name varchar2(30),
    dimension_owner varchar2(30),
    hierarchy_name varchar2(30),
    id number,
    owner varchar2(30),
    table_name varchar2(30),
    table_owner varchar2(30),
    version_id char(4) ) ;

create table mrac_olap2_aw_attributes_t ( 
    attribute_type varchar2(1000),
    aw_dimension_name varchar2(1000),
    aw_logical_name varchar2(90),
    aw_name varchar2(30),
    aw_owner varchar2(30),
    aw_physical_object varchar2(1000),
    description varchar2(1000),
    display_name varchar2(1000),
    source_dimension_name varchar2(1000),
    source_name varchar2(1000),
    source_owner varchar2(1000) ) ;

create table mrac_olap2_aw_cube_agg_lvl_t ( 
    aw_aggspec_name varchar2(1000),
    aw_cube_name varchar2(90),
    aw_dimension_name varchar2(1000),
    aw_level_name varchar2(1000),
    aw_name varchar2(30),
    aw_owner varchar2(30) ) ;

create table mrac_olap2_aw_cube_agg_meas_t ( 
    aw_aggspec_name varchar2(1000),
    aw_cube_name varchar2(90),
    aw_measure_name varchar2(1000),
    aw_name varchar2(30),
    aw_owner varchar2(30) ) ;

create table mrac_olap2_aw_cube_agg_op_t ( 
    aw_aggspec_name varchar2(1000),
    aw_cube_name varchar2(90),
    aw_dimension_name varchar2(1000),
    aw_name varchar2(30),
    aw_owner varchar2(30),
    operator varchar2(1000) ) ;

create table mrac_olap2_aw_cube_agg_specs_t ( 
    aw_aggspec_name varchar2(1000),
    aw_cube_name varchar2(90),
    aw_name varchar2(30),
    aw_owner varchar2(30) ) ;

create table mrac_olap2_aw_cube_dim_uses_t ( 
    aw_logical_name varchar2(90),
    aw_name varchar2(30),
    aw_owner varchar2(30),
    dimension_aw_name varchar2(1000),
    dimension_aw_owner varchar2(1000),
    dimension_source_name varchar2(1000),
    dimension_source_owner varchar2(1000) ) ;

create table mrac_olap2_aw_cube_measures_t ( 
    aw_cube_name varchar2(90),
    aw_measure_name varchar2(1000),
    aw_name varchar2(30),
    aw_owner varchar2(30),
    aw_physical_object varchar2(1000),
    description varchar2(1000),
    display_name varchar2(1000),
    is_aggregateable varchar2(1000),
    measure_source_name varchar2(1000) ) ;

create table mrac_olap2_aw_cubes_t ( 
    aw_logical_name varchar2(90),
    aw_name varchar2(30),
    aw_owner varchar2(30),
    aw_physical_object varchar2(1000),
    source_name varchar2(1000),
    source_owner varchar2(1000) ) ;

create table mrac_olap2_aw_dim_levels_t ( 
    aw_logical_name varchar2(90),
    aw_name varchar2(30),
    aw_owner varchar2(30),
    description varchar2(1000),
    display_name varchar2(1000),
    level_name varchar2(1000) ) ;

create table mrac_olap2_aw_dimensions_t ( 
    aw_logical_name varchar2(90),
    aw_name varchar2(30),
    aw_owner varchar2(30),
    aw_physical_object varchar2(1000),
    source_name varchar2(1000),
    source_owner varchar2(1000) ) ;

create table mrac_olap2_aw_hier_lvl_ord_t ( 
    aw_dimension_name varchar2(90),
    aw_hierarchy_name varchar2(1000),
    aw_level_name varchar2(1000),
    aw_name varchar2(30),
    aw_owner varchar2(30),
    is_default_hier varchar2(1000),
    position number ) ;

create table mrac_olap2_aw_map_attr_use_t ( 
    attribute_name varchar2(1000),
    aw_name varchar2(30),
    aw_object_name varchar2(90),
    aw_owner varchar2(30),
    dimension_name varchar2(1000),
    dimension_owner varchar2(1000) ) ;

create table mrac_olap2_aw_map_dim_use_t ( 
    aw_name varchar2(30),
    aw_object_name varchar2(90),
    aw_owner varchar2(30),
    dimension_name varchar2(1000),
    dimension_owner varchar2(1000) ) ;

create table mrac_olap2_aw_map_meas_use_t ( 
    aw_name varchar2(30),
    aw_object_name varchar2(90),
    aw_owner varchar2(30),
    cube_name varchar2(1000),
    cube_owner varchar2(1000),
    measure_name varchar2(1000) ) ;

create table mrac_olap2_aw_phys_obj_prop_t ( 
    aw_name varchar2(30),
    aw_object_name varchar2(90),
    aw_owner varchar2(30),
    aw_prop_name varchar2(1000),
    aw_prop_value varchar2(1000) ) ;

create table mrac_olap2_aw_phys_obj_t ( 
    aw_name varchar2(30),
    aw_object_datatype varchar2(1000),
    aw_object_name varchar2(90),
    aw_object_type varchar2(1000),
    aw_owner varchar2(30) ) ;

create table mrac_olap2_aws_t ( 
    aw varchar2(30),
    owner varchar2(30) not null ) ;



REM
REM Constraints
REM
alter table cwm2$dimension add constraint cwm2$dimension_name unique ( owner, name ) ;
 alter table cwm2$dimensionattribute add constraint cwm2$dimensionattribute_name unique ( dimension_irid, name ) ;
 alter table cwm2$hierarchy add constraint cwm2$hierarchy_name unique ( dimension_irid, name ) ;
 alter table cwm2$level add constraint cwm2$level_name unique ( dimension_irid, name ) ;
 alter table cwm2$levelattribute add constraint cwm2$levelattribute_name unique ( level_irid, name ) ;
 alter table cwm2$cube add constraint cwm2$cube_name unique ( owner, name ) ;
 alter table cwm2$measure add constraint cwm2$measure_name unique ( cube_irid, name ) ;
 alter table cwm2$awdimload drop constraint cwm2$awdimload_name ;
 alter table cwm2$awdimload add constraint cwm2$awdimload_name unique ( dim_irid, name ) ;
 alter table cwm2$awdimloadfilter drop constraint cwm2$awdimloadfilter_id ;
 alter table cwm2$awdimloadfilter add constraint cwm2$awdimloadfilter_name unique ( dimload_irid, lookup_table_owner, lookup_table_name ) ;
 alter table cwm2$awdimloadparmvalue drop constraint cwm2$awdimloadparmvalue_id ;
 alter table cwm2$awdimloadparmvalue add constraint cwm2$awdimloadparmvalue_name unique ( dimload_irid, parmname_irid ) ;
 alter table cwm2$awcubeload drop constraint cwm2$awcubeload_name ;
 alter table cwm2$awcubeload add constraint cwm2$awcubeload_name unique ( cube_irid, name ) ;
 alter table cwm2$awcubeloadfilter drop constraint cwm2$awcubeloadfilter_id ;
 alter table cwm2$awcubeloadfilter add constraint cwm2$awcubeloadfilter_name unique ( cubeload_irid, fact_table_owner, fact_table_name ) ;
 alter table cwm2$awcubeloadparmvalue drop constraint cwm2$awcubeloadparmvalue_id ;
 alter table cwm2$awcubeloadparmvalue add constraint cwm2$awcubeloadparmvalue_name unique ( cubeload_irid, parmname_irid ) ;
 alter table cwm2$awcubeloadmeasure add constraint cwm2$awcubeloadmeasure_name unique ( cubeload_irid, name ) ;
 alter table cwm2$awcubeloadaggplan add constraint cwm2$awcubeloadaggplan_name unique ( cubeload_irid, cubeagg_irid ) ;
 alter table cwm2$awcubeagg drop constraint cwm2$awcubeagg_name ;
 alter table cwm2$awcubeagg add constraint cwm2$awcubeagg_name unique ( cube_irid, name ) ;
 alter table cwm2$awcubeagglevel drop constraint cwm2$awcubeagglevel_id ;
 alter table cwm2$awcubeagglevel add constraint cwm2$awcubeagglevel_name unique ( cubeagg_irid, dim_irid, level_irid ) ;
 alter table cwm2$awcubeaggmeasure drop constraint cwm2$awcubeaggmeasure_id ;
 alter table cwm2$awcubeaggmeasure add constraint cwm2$awcubeaggmeasure_name unique ( cubeagg_irid, measure_irid ) ;
 alter table cwm2$awcompositespec add constraint cwm2$awcompositespec_name unique ( cube_irid, name ) ;
 alter table cwm2$awcompspecmembership drop constraint cwm2$awcompspecmembership_id ;
 alter table cwm2$awcompspecmembership add constraint cwm2$awcompspecmember_name unique ( compspec_irid, name ) ;
 alter table cwm2$awcubecompplan add constraint cwm2$awcubecompplan_name unique ( cubeload_irid, cubecompspec_irid ) ;
 alter table cwm2$awviews add constraint cwm2$awviewpk primary key ( irid ) ;
 alter table cwm2$awviewcols add constraint cwm2$awviewcolsfk foreign key ( awviews_irid ) references cwm2$awviews ( irid ) on delete cascade ;

@@amdu9204.sql
