DECLARE
  tabcount NUMBER;
  sql_stmt varchar(1000);
  ind_name varchar(30):= 'MVIEW$_ADV_INDEX';
  par_name varchar(30):= 'MVIEW$_ADV_PARTITION';
  own_name varchar(30):= 'SYSTEM';
  owb_name varchar(30):= 'MVIEW$_ADV_OWB';
BEGIN

  SELECT COUNT(*) INTO tabcount FROM SYS.DBA_TABLES WHERE TABLE_NAME = ind_name AND OWNER = own_name;
  IF tabcount <> 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYSTEM.MVIEW$_ADV_INDEX';
  END IF;
  EXECUTE IMMEDIATE 'CREATE TABLE SYSTEM.MVIEW$_ADV_INDEX (RUNID# NUMBER NOT NULL,
                                      RANK# NUMBER NOT NULL,
                                      MVINDEX# NUMBER NOT NULL,
                                      INDEX_TYPE NUMBER,
                                      INDEX_NAME VARCHAR2(50),
                                      COLUMN_NAME VARCHAR2(32),
                                      INDEX_CONTENT VARCHAR2(2000),
                                      SUMMARY_OWNER VARCHAR2(32))';
  SELECT COUNT(*) INTO tabcount FROM SYS.DBA_TABLES WHERE TABLE_NAME = par_name AND OWNER = own_name;
  IF tabcount <> 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYSTEM.MVIEW$_ADV_PARTITION';
  END IF;
  EXECUTE IMMEDIATE 'CREATE TABLE SYSTEM.MVIEW$_ADV_PARTITION(RUNID# NUMBER NOT NULL,
                                      RANK# NUMBER NOT NULL,
                                      SUMMARY_OWNER VARCHAR2(32),
                                      QUERY_TEXT LONG)';

  SELECT COUNT(*) INTO tabcount FROM SYS.DBA_TABLES WHERE TABLE_NAME = owb_name AND OWNER = own_name;
  IF tabcount <> 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYSTEM.MVIEW$_ADV_OWB';
  END IF;
  EXECUTE IMMEDIATE 'CREATE global temporary TABLE SYSTEM.MVIEW$_ADV_OWB
    (
     RUNID#    number,
     OBJNAME   varchar2(30),
     OWNERNAME varchar2(30),
     MVSCRIPT  CLOB,
     INDEXSCRIPT CLOB)
  on commit preserve rows';
END;
/
GRANT SELECT,INSERT,UPDATE,DELETE ON SYSTEM.MVIEW$_ADV_OWB TO PUBLIC
/
GRANT SELECT,INSERT,UPDATE,DELETE ON SYSTEM.MVIEW$_ADV_PARTITION TO PUBLIC
/
GRANT SELECT,INSERT,UPDATE,DELETE ON SYSTEM.MVIEW$_ADV_INDEX TO PUBLIC
/
