REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM  FILE
REM   cwm2awen.pls
REM
REM  DESCRIPTION
REM   Procedure Language Specification file for PL/SQL Package
REM   CWM2_OLAP_OLAPAPI_ENABLE
REM
REM  NOTES
REM
REM  MODIFIED  (MM/DD/YY)
REM     dbardwel 08/19/03 - 
REM     dbardwel 01/15/03 - Moving 9.2.0.2.1 work to 9.2.0.3.0 code stream 
REM     dbardwe 01/06/03 - 
REM     dbardwe 11/25/02 - 
REM     dbardwe 11/07/02 - 
REM     dbardwe 11/04/02 - 
REM     dbardwe 09/20/02 - dbardwel_txn104130
REM    dbardwe   09/11/02  Adding second procedure for writing to a table
REM    dbardwel  09/05/02  Initial version
REM


create or replace package cwm2_olap_olapapi_enable authid current_user as

  procedure aw_dimension_create_access(p_Dimension_Owner varchar2,
                                       p_Dimension_Name varchar2,
                                       p_AW_Owner varchar2,
                                       p_AW_Name varchar2,
                                       p_Prefix varchar2,
                                       p_Access_Type varchar2,
                                       p_Script_Directory varchar2,
                                       p_Script_Name varchar2,
                                       p_OpenMode varchar2,
                                       p_Caller varchar2 default null);


  procedure aw_dimension_create_access(p_runid number,
                                       p_Dimension_Owner varchar2,
                                       p_Dimension_Name varchar2,
                                       p_AW_Owner varchar2,
                                       p_AW_Name varchar2,
                                       p_Prefix varchar2,
                                       p_Access_Type varchar2);



  procedure aw_cube_create_access(p_Cube_Owner varchar2,
                                  p_Cube_Name varchar2,
                                  p_AW_Owner varchar2,
                                  p_AW_Name varchar2,
                                  p_Prefix varchar2,
                                  p_Access_Type varchar2,
                                  p_Script_Directory varchar2,
                                  p_Script_Name varchar2,
                                  p_OpenMode varchar2,
                                  p_Caller varchar2 default null);


  procedure aw_cube_create_access(p_runid number,
                                  p_Cube_Owner varchar2,
                                  p_Cube_Name varchar2,
                                  p_AW_Owner varchar2,
                                  p_AW_Name varchar2,
                                  p_Prefix varchar2,
                                  p_Access_Type varchar2);



  procedure aw_dimension_drop_access(p_Target_Dim_Name varchar2,
                                     p_AW_Owner varchar2,
                                     p_AW_Name varchar2,
                                     p_Access_Type varchar2,
                                     p_Script_Directory varchar2,
                                     p_Script_Name varchar2,
                                     p_OpenMode varchar2);


  procedure aw_dimension_drop_access(p_runid number,
                                     p_Target_Dim_Name varchar2,
                                     p_AW_Owner varchar2,
                                     p_AW_Name varchar2,
                                     p_Access_Type varchar2,
                                     p_caller varchar2 default null);


  procedure aw_cube_drop_access(p_Target_Cube_Name varchar2,
                                p_AW_Owner varchar2,
                                p_AW_Name varchar2,
                                p_Access_Type varchar2,
                                p_Script_Directory varchar2,
                                p_Script_Name varchar2,
                                p_OpenMode varchar2);


  procedure aw_cube_drop_access(p_runid number,
                                p_Target_Cube_Name varchar2,
                                p_AW_Owner varchar2,
                                p_AW_Name varchar2,
                                p_Access_Type varchar2,
                                p_caller varchar2 default null);
                                     


  procedure update_enabled_dim_view(p_AWOwner varchar2,
                                    p_AWName varchar2,
                                    p_DimName varchar2,
                                    p_HierName varchar2,
                                    p_UserViewName varchar2);

  procedure update_enabled_cube_view(p_AWOwner varchar2,
                                     p_AWName varchar2,
                                     p_CubeName varchar2,
                                     p_HierComboNum number,
                                     p_UserViewName varchar2);


end cwm2_olap_olapapi_enable;
/
show errors;

