REM
REM Copyright (c) 2001, 2004, Oracle Corporation.  All rights reserved.  
REM
REM    NAME
REM      cwm2awmd.sql
REM
REM    DESCRIPTION
REM
REM    NOTES
REM
REM    MODIFIED   (MM/DD/YY)
REM       dbardwel 11/29/04 - Fix bug for too short an adt column for all_aw_cube_enabled_views
REM       mstasiew 08/13/03 - 
REM       cdalessi 06/10/03 - 
REM       cdalessi 05/14/03 - Change some create to create or replace type
REM       mstasiew 05/21/03 - 
REM       dbardwel 05/22/03 - 
REM       mstasiew 04/11/03 - 
REM       mstasiew 04/07/03 - 
REM       mstasiew 01/20/03 - 
REM       mstasiew 01/17/03 - 
REM       dbardwel 01/23/03 - 
REM       dbardwel 01/03/03 - 
REM       mstasiew 01/13/03 - 
REM       mstasiew 11/08/02 - 
REM       mstasiew 10/29/02 - 
REM       mstasiew 08/19/02 - mstasiew_txn103605
REM       mstasiew 08/16/02 - 
REM       mstasiew 08/16/02 - 
REM    mstasiew    8/16/02


create or replace view olapsys.ALL$OLAP2_AWS as
select u.name OWNER,
aw.awname AW,
aw.awseq# AW_NUMBER
from sys.user$ u, sys.aw$ aw
where u.user# = aw.owner#
/

grant select on olapsys.all$olap2_aws to public
/

create or replace public synonym ALL_OLAP2_AWS for
olapsys.all$olap2_aws
/


REM ADTs used by all views

DROP TYPE olapsys.ALL_OLAP2_AW_METADATA_T
/
DROP TYPE olapsys.ALL_OLAP2_AW_METADATA_O
/

CREATE OR REPLACE TYPE olapsys.ALL_OLAP2_AW_METADATA_O AS OBJECT (
 AWOWNER VARCHAR2(30),
 AWNAME VARCHAR2(30),
 AWOBJECT VARCHAR2(90),
 COL1 VARCHAR2(1000),
 COL2 VARCHAR2(1000),
 COL3 VARCHAR2(1000),
 COL4 VARCHAR2(1000),
 COL5 number,
 COL6 VARCHAR2(4000),
 COL7 VARCHAR2(1000),
 COL8 VARCHAR2(1000),
 COL9 VARCHAR2(1000),
 AWMDKEY NUMBER)
/

CREATE OR REPLACE TYPE olapsys.ALL_OLAP2_AW_METADATA_T AS TABLE OF ALL_OLAP2_AW_METADATA_O
/

drop view olapsys.all$olap2_aw_phys_obj_ext
/
drop view olapsys.all$olap2_aw_phys_obj_rel_obj
/
drop view olapsys.all$olap2_aw_map_hier_use
/ 
drop view olapsys.all$olap2_aw_map_lvl_use
/

REM ALL_OLAP2_AW_PHYS_OBJ

CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_PHYS_OBJ AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_OBJECT_NAME,
       AW.COL1 as AW_OBJECT_TYPE,
       AW.COL2 as AW_OBJECT_DATATYPE 
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ALL_OLAP2_AW_METADATA ''ALL_OLAP2_AW_PHYS_OBJ''',
                       'MEASURE AWOWNER FROM sys.awmd!AWOWNER
                        MEASURE AWNAME FROM sys.awmd!AWNAME
                        MEASURE AWOBJECT FROM sys.awmd!AWOBJECT
                        MEASURE COL1 FROM sys.awmd!AWOBJECTTYPE
                        MEASURE COL2 FROM sys.awmd!AWOBJECTDATATYPE
                        DIMENSION AWMDKEY FROM sys.awmd!AWMDKEY')
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_PHYS_OBJ TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_PHYS_OBJ for olapsys.ALL$OLAP2_AW_PHYS_OBJ
/


REM ALL_OLAP2_AW_PHYS_OBJ_PROP



CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_PHYS_OBJ_PROP AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_OBJECT_NAME,
       AW.COL1 as AW_PROP_NAME,
       AW.COL2 as AW_PROP_VALUE 
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ALL_OLAP2_AW_METADATA ''ALL_OLAP2_AW_PHYS_OBJ_PROP''',
                         'MEASURE AWOWNER FROM sys.awmd!AWOWNER
                          MEASURE AWNAME FROM sys.awmd!AWNAME
                          MEASURE AWOBJECT FROM sys.awmd!AWOBJECT
                          MEASURE COL1 FROM sys.awmd!AWOBJECTPROPNAME
                          MEASURE COL2 FROM sys.awmd!AWOBJECTPROPVALUE
                          DIMENSION AWMDKEY FROM sys.awmd!AWMDKEY')
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_PHYS_OBJ_PROP TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_PHYS_OBJ_PROP for olapsys.ALL$OLAP2_AW_PHYS_OBJ_PROP
/


REM ALL_OLAP2_AW_DIMENSIONS


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_DIMENSIONS AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_LOGICAL_NAME,
       AW.COL3 as AW_PHYSICAL_OBJECT,
       AW.COL1 as SOURCE_OWNER,
       AW.COL2 as SOURCE_NAME
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_DIMENSIONS''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!DIMENSION_NAME
                        MEASURE COL1 FROM SYS.AWMD!SOURCE_OWNER
                        MEASURE COL2 FROM SYS.AWMD!SOURCE_NAME
                        MEASURE COL3 from SYS.AWMD!AW_PHYSICAL_OBJECT
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_DIMENSIONS TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_DIMENSIONS for olapsys.ALL$OLAP2_AW_DIMENSIONS
/

REM ALL_OLAP2_AW_ATTRIBUTES


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_ATTRIBUTES AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.COL4 as AW_DIMENSION_NAME,
       AW.AWOBJECT as AW_LOGICAL_NAME,
       AW.COL3 as AW_PHYSICAL_OBJECT,
       AW.COL7 as DISPLAY_NAME,
       AW.COL8 as DESCRIPTION,
       AW.COL9 as ATTRIBUTE_TYPE,
       AW.COL1 as SOURCE_OWNER,
       AW.COL6 as SOURCE_DIMENSION_NAME,
       AW.COL2 as SOURCE_NAME
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_ATTRIBUTES''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!ATTRIBUTE_NAME
                        MEASURE COL1 FROM SYS.AWMD!SOURCE_OWNER
                        MEASURE COL2 FROM SYS.AWMD!SOURCE_NAME
                        MEASURE COL3 from SYS.AWMD!AW_PHYSICAL_OBJECT
                        MEASURE COL6 FROM SYS.AWMD!DIMENSION_SOURCE_NAME
                        MEASURE COL4 FROM SYS.AWMD!DIMENSION_NAME
                        MEASURE COL7 FROM SYS.AWMD!DISPLAY_NAME
                        MEASURE COL8 FROM SYS.AWMD!DESCRIPTION
                        MEASURE COL9 FROM SYS.AWMD!CF_TYPE
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_ATTRIBUTES TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_ATTRIBUTES for olapsys.ALL$OLAP2_AW_ATTRIBUTES
/




REM ALL_OLAP2_AW_CUBES


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_CUBES AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_LOGICAL_NAME,
       AW.COL3 as AW_PHYSICAL_OBJECT,
       AW.COL1 as SOURCE_OWNER,
       AW.COL2 as SOURCE_NAME
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_CUBES''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!CUBE_NAME
                        MEASURE COL1 FROM SYS.AWMD!SOURCE_OWNER
                        MEASURE COL2 FROM SYS.AWMD!SOURCE_NAME
                        MEASURE COL3 FROM SYS.AWMD!AW_PHYSICAL_OBJECT
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_CUBES TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_CUBES for olapsys.ALL$OLAP2_AW_CUBES
/


REM ALL_OLAP2_AW_CUBE_DIM_USES


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_CUBE_DIM_USES AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_LOGICAL_NAME,
       AW.COL1 as DIMENSION_AW_OWNER,
       AW.COL2 as DIMENSION_AW_NAME,
       AW.COL3 as DIMENSION_SOURCE_OWNER,
       AW.COL4 as DIMENSION_SOURCE_NAME
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_CUBE_DIM_USES''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!CUBE_NAME
                        MEASURE COL1 FROM SYS.AWMD!DIMENSION_OWNER
                        MEASURE COL2 FROM SYS.AWMD!DIMENSION_NAME
                        MEASURE COL3 FROM SYS.AWMD!DIMENSION_SOURCE_OWNER
                        MEASURE COL4 FROM SYS.AWMD!DIMENSION_SOURCE_NAME
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_CUBE_DIM_USES TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_CUBE_DIM_USES for olapsys.ALL$OLAP2_AW_CUBE_DIM_USES
/



CREATE OR REPLACE VIEW ALL$AW_DIM_ENABLED_VIEWS AS
  SELECT AW.AWOWNER as AW_OWNER,
         AW.AWNAME as AW_NAME,
         AW.COL1 as DIMENSION_NAME,
         AW.COL2 as HIERARCHY_NAME,
         AW.COL3 as SYSTEM_VIEWNAME,
         AW.COL4 as USER_VIEWNAME
  FROM
    TABLE(CAST(OLAP_TABLE('SYS.AWMD duration query',
                          'olapsys.ALL_OLAP2_AW_METADATA_T',
                          'ACTIVE_CATALOG ''ALL_AW_DIM_ENABLED_VIEWS''',
                          'MEASURE AWOWNER FROM SYS.AWMD!AWOWNER
                           MEASURE AWNAME FROM SYS.AWMD!AWNAME
                           MEASURE COL1 FROM SYS.AWMD!DIMENSION_NAME
                           MEASURE COL2 FROM SYS.AWMD!HIERARCHY_NAME
                           MEASURE COL3 FROM SYS.AWMD!VIEWNAME
                           MEASURE COL4 FROM SYS.AWMD!USERVIEWNAME
                           DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY')
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$AW_DIM_ENABLED_VIEWS TO PUBLIC
/

create or replace public synonym ALL_AW_DIM_ENABLED_VIEWS for olapsys.ALL$AW_DIM_ENABLED_VIEWS
/



CREATE OR REPLACE VIEW ALL$AW_CUBE_ENABLED_VIEWS AS
  SELECT AW.AWOWNER as AW_OWNER,
         AW.AWNAME as AW_NAME,
         AW.COL1 as CUBE_NAME,
         AW.COL5 as HIERCOMBO_NUM,
         AW.COL6 as HIERCOMBO_STR,
         AW.COL3 as SYSTEM_VIEWNAME,
         AW.COL4 as USER_VIEWNAME
  FROM
    TABLE(CAST(OLAP_TABLE('SYS.AWMD duration query',
                          'olapsys.ALL_OLAP2_AW_METADATA_T',
                          'ACTIVE_CATALOG ''ALL_AW_CUBE_ENABLED_VIEWS''',
                          'MEASURE AWOWNER FROM SYS.AWMD!AWOWNER
                           MEASURE AWNAME FROM SYS.AWMD!AWNAME
                           MEASURE COL1 FROM SYS.AWMD!CUBE_NAME
                           MEASURE COL5 FROM SYS.AWMD!HIERCOMBO_NUM
                           MEASURE COL6 FROM SYS.AWMD!HIERCOMBO_STR
                           MEASURE COL3 FROM SYS.AWMD!VIEWNAME
                           MEASURE COL4 FROM SYS.AWMD!USERVIEWNAME
                           DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY')
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$AW_CUBE_ENABLED_VIEWS TO PUBLIC
/

create or replace public synonym ALL_AW_CUBE_ENABLED_VIEWS for olapsys.ALL$AW_CUBE_ENABLED_VIEWS
/


CREATE OR REPLACE VIEW ALL$AW_CUBE_ENABLED_HIERCOMBO AS
  SELECT AW.AWOWNER as AW_OWNER,
         AW.AWNAME as AW_NAME,
         AW.COL1 as CUBE_NAME,
         AW.COL5 as HIERCOMBO_NUM,
         AW.COL3 as HIERCOMBO_STR
  FROM
    TABLE(CAST(OLAP_TABLE('SYS.AWMD duration query',
                          'olapsys.ALL_OLAP2_AW_METADATA_T',
                          'ACTIVE_CATALOG ''ALL_AW_CUBE_ENABLED_HIERCOMBO''',
                          'MEASURE AWOWNER FROM SYS.AWMD!AWOWNER
                           MEASURE AWNAME FROM SYS.AWMD!AWNAME
                           MEASURE COL1 FROM SYS.AWMD!CUBE_NAME
                           MEASURE COL5 FROM SYS.AWMD!HIERCOMBO_NUM
                           MEASURE COL3 FROM SYS.AWMD!HIERCOMBO_STR
                           DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY')
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$AW_CUBE_ENABLED_HIERCOMBO TO PUBLIC
/

create or replace public synonym ALL_AW_CUBE_ENABLED_HIERCOMBO for olapsys.ALL$AW_CUBE_ENABLED_HIERCOMBO
/


REM ALL_OLAP2_AW_DIM_LEVELS


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_DIM_LEVELS AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_LOGICAL_NAME,
       AW.COL1 as LEVEL_NAME,
       AW.COL2 as DISPLAY_NAME,
       AW.COL3 as DESCRIPTION
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_DIM_LEVELS''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!DIMENSION_NAME
                        MEASURE COL1 FROM SYS.AWMD!LEVEL_NAME
                        MEASURE COL2 FROM SYS.AWMD!DISPLAY_NAME
                        MEASURE COL3 FROM SYS.AWMD!DESCRIPTION
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_DIM_LEVELS TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_DIM_LEVELS for olapsys.ALL$OLAP2_AW_DIM_LEVELS
/

REM ALL_OLAP2_AW_DIM_HIER_LVL_ORD


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_DIM_HIER_LVL_ORD AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_DIMENSION_NAME,
       AW.COL1 as AW_HIERARCHY_NAME,
       AW.COL2 as IS_DEFAULT_HIER,
       AW.COL3 as AW_LEVEL_NAME,
       AW.COL5 as POSITION
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_DIM_HIER_LVL_ORD''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!DIMENSION_NAME
                        MEASURE COL1 FROM SYS.AWMD!HIERARCHY_NAME
                        MEASURE COL2 FROM SYS.AWMD!IS_DFLT_HIER
                        MEASURE COL3 FROM SYS.AWMD!LEVEL_NAME
                        MEASURE COL5 FROM SYS.AWMD!HIER_LVL_POS
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_DIM_HIER_LVL_ORD TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_DIM_HIER_LVL_ORD for olapsys.ALL$OLAP2_AW_DIM_HIER_LVL_ORD
/


REM ALL_OLAP2_AW_CUBE_MEASURES


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_CUBE_MEASURES AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_CUBE_NAME,
       AW.COL1 as AW_MEASURE_NAME,
       AW.COL6 as AW_PHYSICAL_OBJECT,
       AW.COL2 as MEASURE_SOURCE_NAME,
       AW.COL3 as DISPLAY_NAME,
       AW.COL4 as DESCRIPTION,
       AW.COL7 as IS_AGGREGATEABLE
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_CUBE_MEASURES''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!CUBE_NAME
                        MEASURE COL1 FROM SYS.AWMD!MEASURE_NAME
                        MEASURE COL2 FROM SYS.AWMD!SOURCE_NAME
                        MEASURE COL3 FROM SYS.AWMD!DISPLAY_NAME
                        MEASURE COL4 FROM SYS.AWMD!DESCRIPTION
                        MEASURE COL6 FROM SYS.AWMD!AW_PHYSICAL_OBJECT
                        MEASURE COL7 FROM SYS.AWMD!ISAGGREGATEABLE
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_CUBE_MEASURES TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_CUBE_MEASURES for olapsys.ALL$OLAP2_AW_CUBE_MEASURES
/

REM ALL_OLAP2_AW_CUBE_AGG_SPECS


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_CUBE_AGG_SPECS AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_CUBE_NAME,
       AW.COL1 as AW_AGGSPEC_NAME
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_CUBE_AGGSPECS''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!CUBE_NAME
                        MEASURE COL1 FROM SYS.AWMD!AGGSPEC_NAME
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_CUBE_AGG_SPECS TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_CUBE_AGG_SPECS for olapsys.ALL$OLAP2_AW_CUBE_AGG_SPECS
/


REM ALL_OLAP2_AW_CUBE_AGG_MEAS


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_CUBE_AGG_MEAS AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_CUBE_NAME,
       AW.COL1 as AW_AGGSPEC_NAME,
       AW.COL2 as AW_MEASURE_NAME
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_CUBE_AGGSPECS_MEASURES''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!CUBE_NAME
                        MEASURE COL1 FROM SYS.AWMD!AGGSPEC_NAME
                        MEASURE COL2 FROM SYS.AWMD!MEASURE_NAME
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_CUBE_AGG_MEAS TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_CUBE_AGG_MEAS for olapsys.ALL$OLAP2_AW_CUBE_AGG_MEAS
/

REM ALL_OLAP2_AW_CUBE_AGG_LVL


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_CUBE_AGG_LVL AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_CUBE_NAME,
       AW.COL1 as AW_AGGSPEC_NAME,
       AW.COL2 as AW_DIMENSION_NAME,
       AW.COL3 as AW_LEVEL_NAME
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_CUBE_AGGSPECS_LEVELS''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!CUBE_NAME
                        MEASURE COL1 FROM SYS.AWMD!AGGSPEC_NAME
                        MEASURE COL2 FROM SYS.AWMD!DIMENSION_NAME
                        MEASURE COL3 FROM SYS.AWMD!LEVEL_NAME
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_CUBE_AGG_LVL TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_CUBE_AGG_LVL for olapsys.ALL$OLAP2_AW_CUBE_AGG_LVL
/

REM ALL_OLAP2_AW_CUBE_AGG_OP


CREATE OR REPLACE VIEW olapsys.ALL$OLAP2_AW_CUBE_AGG_OP AS 
SELECT AW.AWOWNER as AW_OWNER,
       AW.AWNAME as AW_NAME,
       AW.AWOBJECT as AW_CUBE_NAME,
       NULL as AW_MEASURE_NAME,
       AW.COL1 as AW_AGGSPEC_NAME,
       AW.COL2 as AW_DIMENSION_NAME,
       AW.COL3 as OPERATOR
FROM 
TABLE(CAST (OLAP_TABLE('SYS.AWMD duration query', 'olapsys.ALL_OLAP2_AW_METADATA_T', 
                       'ACTIVE_CATALOG ''ALL_CUBE_AGGSPECS_OPERATORS''',
                       'MEASURE AWOWNER FROM SYS.AWMD!OWNER
                        MEASURE AWNAME FROM SYS.AWMD!AWNAME
                        MEASURE AWOBJECT FROM SYS.AWMD!CUBE_NAME
                        MEASURE COL1 FROM SYS.AWMD!AGGSPEC_NAME
                        MEASURE COL2 FROM SYS.AWMD!DIMENSION_NAME
                        MEASURE COL3 FROM SYS.AWMD!OPERATOR
                        DIMENSION AWMDKEY FROM SYS.AWMD!AWMDKEY'
                        )
                        AS olapsys.ALL_OLAP2_AW_METADATA_T)) AW
/

GRANT SELECT ON olapsys.ALL$OLAP2_AW_CUBE_AGG_OP TO PUBLIC
/

create or replace public synonym ALL_OLAP2_AW_CUBE_AGG_OP for olapsys.ALL$OLAP2_AW_CUBE_AGG_OP
/


commit
/

