
--SET ECHO OFF

-- |----------------------------------------------------------------------------
-- | $Header: cwm2conv.sql 09-Sep-2001 Aziz.Mboya@oracle.com
-- |
-- | cwm2conv.pls
-- |
-- | Copyright (c) Oracle Corporation  2001. All Rights Reserved.
-- |
-- | NAME
-- | cwm2conv.pls - package: cwm2_olap_awconvert
-- |
-- | DESCRIPTION
-- |   Create CwMLite Relational data structures for Analytic Workspaces
-- |
-- | NOTES
-- |
-- | MODIFIED   (MM/DD/YY)
-- | Aziz.Mboya  12/09/02 - Fix to bug 2698866 - CWM2_OLAP_AW_ACCESS REQUIRES NAME UPDATE 
-- | Aziz.Mboya  07/01/02 - Add API calls for creating Custom Measures
-- | Aziz.Mboya  02/04/02 - Remove test api call for XADEMO.
-- | Aziz.Mboya  12/14/01 - Split into .pls and .sql files for build
-- | Aziz.Mboya  01/29/02 - changed package name from cwm2_olap_awconvert to cwm2_olap_aw_access
-- |----------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE CWM2_OLAP_AW_ACCESS AUTHID CURRENT_USER AS

	PROCEDURE CreateAWAccessStructures_FR(
	p_vScriptDirectory VARCHAR2,
	p_vScriptFileName VARCHAR2,
	p_vPrefix VARCHAR2,
	p_vWorkspace VARCHAR2,
	p_vInputFileDirectory VARCHAR2,
	p_vInputFileName VARCHAR2);

	PROCEDURE CreateAWAccessStructures(
	p_vScriptDirectory VARCHAR2,
	p_vScriptFileName VARCHAR2,
	p_vPrefix VARCHAR2,
	p_vWorkspace VARCHAR2,
	p_vAWObjectsInfo VARCHAR2);

	PROCEDURE CreateCustomMeasure(
	p_vWorkspace VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vAWFormulaExpr VARCHAR2,
	p_vAWFormulaCreateMode VARCHAR2,
	p_vRDBMSViewName VARCHAR2);

	PROCEDURE UpdateCustomMeasure(
	p_vWorkspace VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vAWFormulaExpr VARCHAR2);

	PROCEDURE DeleteCustomMeasure(
	p_vWorkspace VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vRDBMSViewName VARCHAR);
	
END CWM2_OLAP_AW_ACCESS;
/

SHOW ERRORS;


CREATE OR REPLACE PACKAGE DBMS_AW_UTILITIES AUTHID CURRENT_USER AS

	PROCEDURE CreateAWAccessStructures_FR(
	p_vScriptDirectory VARCHAR2,
	p_vScriptFileName VARCHAR2,
	p_vPrefix VARCHAR2,
	p_vWorkspace VARCHAR2,
	p_vInputFileDirectory VARCHAR2,
	p_vInputFileName VARCHAR2);

	PROCEDURE CreateAWAccessStructures(
	p_vScriptDirectory VARCHAR2,
	p_vScriptFileName VARCHAR2,
	p_vPrefix VARCHAR2,
	p_vWorkspace VARCHAR2,
	p_vAWObjectsInfo VARCHAR2);

	PROCEDURE Create_Custom_Measure(
	p_vWorkspace VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vAWFormulaExpr VARCHAR2,
	p_vAWFormulaCreateMode VARCHAR2,
	p_vRDBMSViewName VARCHAR2);

	PROCEDURE Update_Custom_Measure(
	p_vWorkspace VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vAWFormulaExpr VARCHAR2);

	PROCEDURE Delete_Custom_Measure(
	p_vWorkspace VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vRDBMSViewName VARCHAR);
	
	FUNCTION GET_AW_OBJECT_NAME(
	p_vRDBMSViewName VARCHAR2,
	p_vRDBMSColumn VARCHAR2) RETURN VARCHAR2;
	
	FUNCTION GET_WORKSPACE_NAME(p_vRDBMSViewName VARCHAR2)
	RETURN VARCHAR2;
	
END DBMS_AW_UTILITIES;
/

SHOW ERRORS;

