--
-- $Header: cwm2enut.pls 02-dec-2002.18:16:54 kingols Exp $
--
-- cwm2enut.pls
--
-- Copyright (c) Oracle Corporation 2002. All Rights Reserved.
--
--   NAME
--     cwm2enut.pls - <one-line expansion of the name>
--
--   DESCRIPTION
--     Utility Package for SQL and OLAP Enablement 
--
--   RETURNS
--
--   NOTES
--     <other useful comments, qualifications, etc.>
--
--   MODIFIED   (MM/DD/YY)
--   kingols     12/02/02 - kingols_txn105343
--   mstasiew    10/31/02 - mstasiew_txn105023
--   dbardwel    10/29/02 - Creation
--

create sequence olapsys.cwm2_olap_enableseq
    increment by 1
    start with 1
    minvalue 1
    maxvalue 9999
    cycle
    nocache
    order;



create or replace package cwm2_olap_Enable_Utility as

  procedure Get_Next_Sequence(p_NextSeq IN OUT number);


  function Build_Dim_AdtName(p_Owner varchar2,
                             p_AWName varchar2,
                             p_DimName varchar2,
                             p_Seq number) return varchar2;


  function Build_Dim_TblName(p_Owner varchar2,
                             p_AWName varchar2,
                             p_DimName varchar2,
                             p_Seq number) return varchar2;


  function Build_Dim_ViewName(p_Owner varchar2,
                              p_AWName varchar2,
                              p_DimName varchar2,
                              p_HierName varchar2,
                              p_Seq number) return varchar2;
                

  function Build_Cube_AdtName(p_Owner varchar2,
                              p_AWName varchar2,
                              p_CubeName varchar2,
                              p_Seq number) return varchar2;


  function Build_Cube_TblName(p_Owner varchar2,
                              p_AWName varchar2,
                              p_CubeName varchar2,
                              p_Seq number) return varchar2;


  function Build_Cube_ViewName(p_Owner varchar2,
                               p_AWName varchar2,
                               p_CubeName varchar2,
                               p_Seq number) return varchar2;
                             

end cwm2_olap_Enable_Utility;
/
show errors;


