REM
REM Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
REM
REM    NAME
REM      cwm2mtun.sql
REM
REM    DESCRIPTION
REM       CwM2Lite Metadata Table Unique Name Constraints
REM
REM    NOTES
REM
REM    MODIFIED   (MM/DD/YY)
REM    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
REM    dbardwel    07/25/03 - Remove duplicate constriaint defs
REM    awesley     05/21/03 - 
REM    awesley     04/24/03 - awesley_txn107041
REM    awesley     04/02/03 - created
REM

alter table OLAPSYS.CwM2$Dimension
  ADD Constraint    CwM2$Dimension_Name
    UNIQUE (Owner, Name)
/

alter table OLAPSYS.CwM2$DimensionAttribute
  ADD Constraint    CwM2$DimensionAttribute_Name
    UNIQUE (Dimension_IRID, Name)
/

alter table OLAPSYS.CwM2$Hierarchy
  ADD Constraint    CwM2$Hierarchy_Name
    UNIQUE (Dimension_IRID, Name)
/

alter table OLAPSYS.CwM2$Level
  ADD Constraint    CwM2$Level_Name
    UNIQUE (Dimension_IRID, Name)
/

alter table OLAPSYS.CwM2$LevelAttribute
  ADD Constraint    CwM2$LevelAttribute_Name
    UNIQUE (Level_IRID, Name)
/

alter table OLAPSYS.CwM2$Cube
  ADD Constraint    CwM2$Cube_Name
    UNIQUE (Owner, Name)
/

alter table OLAPSYS.CwM2$Measure
  ADD Constraint    CwM2$Measure_Name
    UNIQUE (Cube_IRID, Name)
/

alter table OLAPSYS.CwM2$AWCubeLoadMeasure
  ADD Constraint    CwM2$AWCubeLoadMeasure_Name
    UNIQUE (CubeLoad_IRID, Name)
/

alter table OLAPSYS.CwM2$AWCubeLoadAggPlan
  ADD Constraint    CwM2$AWCubeLoadAggPlan_Name
    UNIQUE (CubeLoad_IRID, CubeAgg_IRID)
/

alter table OLAPSYS.CwM2$AWCubeCompPlan
  ADD Constraint    CwM2$AWCubeCompPlan_Name
    UNIQUE (CubeLoad_IRID, CubeCompSpec_IRID)
/

show errors;
 
