REM
REM Copyright (c) 2001, 2004, Oracle Corporation.  All rights reserved.  
REM
REM   NAME
REM    cwm2pkfk.sql
REM
REM   DESCRIPTION
REM    File contains primary and foreign key constraint
REM    definitions for CWM2$ metadata tables.
REM
REM   NOTES
REM
REM    MODIFIED   (MM/DD/YY)
REM     dbardwel   08/04/04 - Add 3 indexes to fix bug 3813809
REM     awesley    08/25/03 - add MemberType to unique constraint CWM2$AWCompSpecMembership_ID
REM     dbardwel   10/24/01 - created
REM

REM
REM All the Primary Keys
REM

ALTER TABLE CWM2$DIMENSION
 ADD (CONSTRAINT CWM2$DIMENSION_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$HIERARCHY
 ADD (CONSTRAINT CWM2$HIERARCHY_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$DIMENSIONATTRIBUTE
 ADD (CONSTRAINT CWM2$DIMENSIONATTRIBUTE_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$LEVEL
 ADD (CONSTRAINT CWM2$LEVEL_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$HIERLEVELREL
 ADD (CONSTRAINT CWM2$HIERLEVELREL_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$LEVELATTRIBUTE
 ADD (CONSTRAINT CWM2$LEVELATTRIBUTE_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$DIMHIERLVLMAP
 ADD (CONSTRAINT CWM2$DIMHIERLVLMAP_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$LEVELATTRIBUTEMAP
 ADD (CONSTRAINT CWM2$LEVELATTRIBUTEMAP_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$AW_DIMENSIONMAP
 ADD (CONSTRAINT CWM2$AW_DIMENSIONMAP_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$CUBE
 ADD (CONSTRAINT CWM2$CUBE_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$MEASURE
 ADD (CONSTRAINT CWM2$MEASURE_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$CUBEDIMENSIONUSE
 ADD (CONSTRAINT CWM2$CUBEDIMENSIONUSE_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$MEASURETABLEMAP
 ADD (CONSTRAINT CWM2$MEASURETABLEMAP_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$FACTDIMHIERMAP
 ADD (CONSTRAINT CWM2$FACTDIMHIERMAP_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$FACTDIMHIERTPLSDTL
 ADD (CONSTRAINT CWM2$FACTDIMHIERTPLSDTL_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$FACTKEYDIMHIERMAP
 ADD (CONSTRAINT CWM2$FACTKEYDIMHIERMAP_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$FACTKEYDIMHIERLVLMAP
 ADD (CONSTRAINT CWM2$FACTKEYDIMHIERLVLMAP_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE CWM2$AW_MEASUREMAP
 ADD (CONSTRAINT CWM2$AW_MEASUREMAP_PK PRIMARY KEY
  (IRID))
/

ALTER TABLE OLAPSYS.CWM2$AWVIEWS
 ADD (CONSTRAINT CWM2$AWVIEWS_TBLUNQ
   UNIQUE(TABLE_ID))
/

ALTER TABLE OLAPSYS.CWM2$AWVIEWS
 ADD (CONSTRAINT CWM2$AWVIEWS_TBLUNQ2
   UNIQUE(VIEW_OWNER,
          VIEW_NAME))
/

REM
REM All the foreign keys
REM

ALTER TABLE CWM2$HIERARCHY ADD CONSTRAINT
 CWM2$HIERARCHY_DIM_FK FOREIGN KEY
  (DIMENSION_IRID) REFERENCES CWM2$DIMENSION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$DIMENSIONATTRIBUTE ADD CONSTRAINT
 CWM2$DIMATTR_DIM_FK FOREIGN KEY
  (DIMENSION_IRID) REFERENCES CWM2$DIMENSION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$LEVEL ADD CONSTRAINT
 CWM2$LEVEL_DIM_FK FOREIGN KEY
  (DIMENSION_IRID) REFERENCES CWM2$DIMENSION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$HIERLEVELREL ADD CONSTRAINT
 CWM2$HIERLEVELREL_DIM_FK FOREIGN KEY
  (DIMENSION_IRID) REFERENCES CWM2$DIMENSION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$HIERLEVELREL ADD CONSTRAINT
 CWM2$HIERLEVELREL_HIER_FK FOREIGN KEY
  (HIERARCHY_IRID) REFERENCES CWM2$HIERARCHY
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$HIERLEVELREL ADD CONSTRAINT
 CWM2$HIERLEVELREL_PLEVEL_FK FOREIGN KEY
  (PARENTLEVEL_IRID) REFERENCES CWM2$LEVEL
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$HIERLEVELREL ADD CONSTRAINT
 CWM2$HIERLEVELREL_CLEVEL_FK FOREIGN KEY
  (CHILDLEVEL_IRID) REFERENCES CWM2$LEVEL
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$LEVELATTRIBUTE ADD CONSTRAINT
 CWM2$LEVELATTR_DIM_FK FOREIGN KEY
  (DIMENSION_IRID) REFERENCES CWM2$DIMENSION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$LEVELATTRIBUTE ADD CONSTRAINT
 CWM2$LEVELATTR_LEVEL_FK FOREIGN KEY
  (LEVEL_IRID) REFERENCES CWM2$LEVEL
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$LEVELATTRIBUTE ADD CONSTRAINT
 CWM2$LEVELATTR_DIMATTR_FK FOREIGN KEY
  (DIMATTR_IRID) REFERENCES CWM2$DIMENSIONATTRIBUTE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$DIMHIERLVLMAP ADD CONSTRAINT
 CWM2$DIMHIERLVLMAP_DHL_FK FOREIGN KEY
 (DIMHIERLVL_IRID) REFERENCES CWM2$HIERLEVELREL
 (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$LEVELATTRIBUTEMAP ADD CONSTRAINT
 CWM2$LVLATTRMAP_HIERLVLREL_FK FOREIGN KEY
 (HIERLVLREL_IRID) REFERENCES CWM2$HIERLEVELREL
 (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$LEVELATTRIBUTEMAP ADD CONSTRAINT
 CWM2$LVLATTRMAP_LVLATTR_FK FOREIGN KEY
 (LEVELATTR_IRID) REFERENCES CWM2$LEVELATTRIBUTE
 (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$MEASURE ADD CONSTRAINT
 CWM2$MEASURE_CUBE_FK FOREIGN KEY
 (CUBE_IRID) REFERENCES CWM2$CUBE
 (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$CUBEDIMENSIONUSE ADD CONSTRAINT
 CWM2$CUBEDIMENSIONUSE_CUBE_FK FOREIGN KEY
 (CUBE_IRID) REFERENCES CWM2$CUBE
 (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$CUBEDIMENSIONUSE ADD CONSTRAINT
 CWM2$CUBEDIMENSIONUSE_DIM_FK FOREIGN KEY
 (DIMENSION_IRID) REFERENCES CWM2$DIMENSION
 (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$FACTDIMHIERMAP ADD CONSTRAINT
 CWM2$FACTDIMHIERMAP_CUBE_FK FOREIGN KEY
  (CUBE_IRID) REFERENCES CWM2$CUBE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$FACTDIMHIERTPLSDTL ADD CONSTRAINT
 CWM2$FACTDIMHTD_CUBE_FK FOREIGN KEY
 (CUBE_IRID) REFERENCES CWM2$CUBE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$FACTDIMHIERTPLSDTL ADD CONSTRAINT
 CWM2$FACTDIMHTD_FDHM_FK FOREIGN KEY
 (FACTDIMHIER_IRID) REFERENCES CWM2$FACTDIMHIERMAP
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$FACTKEYDIMHIERMAP ADD CONSTRAINT
 CWM2$FACTKEYDHM_FDHM_FK FOREIGN KEY
  (FACTDIMHIER_IRID) REFERENCES CWM2$FACTDIMHIERMAP
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$FACTKEYDIMHIERLVLMAP ADD CONSTRAINT
 CWM2$FACTKEYDHLM_FKDHM_FK FOREIGN KEY
  (FACTKEYDIMHIER_IRID) REFERENCES CWM2$FACTKEYDIMHIERMAP
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$MEASURETABLEMAP ADD CONSTRAINT
 CWM2$MEASURETABLEMAP_MEAS_FK FOREIGN KEY
 (MEASURE_IRID) REFERENCES CWM2$MEASURE
 (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM2$MEASURETABLEMAP ADD CONSTRAINT
 CWM2$MEASURETABLEMAP_FDHM_FK FOREIGN KEY
 (FACTDIMHIER_IRID) REFERENCES CWM2$FACTDIMHIERMAP
 (IRID) ON DELETE CASCADE
/

REM Create Primary Keys for the analytical workspace create facility tables

alter table OLAPSYS.CWM2$AWDimLoad
  ADD (Constraint CWM2$AWDimLoad_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWDimLoadFilter
  ADD (Constraint CWM2$AWDimLoadFilter_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWDimLoadParmValue
  ADD (Constraint CWM2$AWDimLoadParmValue_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWDimLoadParm
  ADD (Constraint CWM2$AWDimLoadParm_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWDimLoadType
  ADD (Constraint CWM2$AWDimLoadType_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeLoad
  ADD (Constraint CWM2$AWCubeLoad_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeLoadFilter
  ADD (Constraint CWM2$AWCubeLoadFilter_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeLoadParmValue
  ADD (Constraint CWM2$AWCubeLoadParmValue_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeLoadParm
  ADD (Constraint CWM2$AWCubeLoadParm_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeLoadType
  ADD (Constraint CWM2$AWCubeLoadType_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeLoadMeasure
  ADD (Constraint CWM2$AWCubeLoadMeasure_PK PRIMARY KEY
  (IRID))
/

alter table OLAPSYS.CWM2$AWCubeLoadAggPlan
  ADD (Constraint CWM2$AWCubeLoadAggPlan_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeAgg
  ADD (Constraint CWM2$AWCubeAgg_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeAggLevel
  ADD (Constraint CWM2$AWCubeAggLevel_PK PRIMARY KEY
   (IRID))
/

alter table OLAPSYS.CWM2$AWCubeAggMeasure
  ADD (Constraint CWM2$AWCubeAggMeasure_PK PRIMARY KEY
   (IRID))
/


alter table OLAPSYS.CWM2$AWCompositeSpec
  ADD (Constraint CWM2$AWCompositeSpec_PK Primary KEY
  (IRID))
/

alter table OLAPSYS.CWM2$AWCompSpecMembership
  ADD (Constraint CWM2$AWCompSpecMembership_PK Primary KEY
  (IRID))
/

alter table OLAPSYS.CWM2$AWCubeCompPlan
  ADD (Constraint CWM2$AWCubeCompPlan_PK Primary KEY
  (IRID))
/
REM Unique key constraints

alter table OLAPSYS.CWM2$AWDimLoad
  ADD (Constraint CWM2$AWDimLoad_Name UNIQUE
   (Dim_IRID, Version_Id, Name))
/

alter table OLAPSYS.CWM2$AWDimLoadFilter
  ADD (Constraint CWM2$AWDimLoadFilter_ID UNIQUE
   (DimLoad_IRID, Lookup_Table_Owner, Lookup_Table_Name))
/

alter table OLAPSYS.CWM2$AWDimLoadParmValue
  ADD (Constraint CWM2$AWDimLoadParmValue_ID UNIQUE
   (DimLoad_IRID, ParmName_IRID))
/

alter table OLAPSYS.CWM2$AWCubeLoad
  ADD (Constraint CWM2$AWCubeLoad_Name UNIQUE
   (Cube_IRID, Version_Id, Name))
/

alter table OLAPSYS.CWM2$AWCubeLoadFilter
  ADD (Constraint CWM2$AWCubeLoadFilter_ID UNIQUE
   (CubeLoad_IRID, Fact_Table_Owner, Fact_Table_Name))
/

alter table OLAPSYS.CWM2$AWCubeLoadParmValue
  ADD (Constraint CWM2$AWCubeLoadParmValue_ID UNIQUE
   (CubeLoad_IRID, ParmName_IRID))
/

alter table OLAPSYS.CWM2$AWCubeAgg
  ADD (Constraint CWM2$AWCubeAgg_Name UNIQUE
   (Cube_IRID, Version_Id, Name))
/

alter table OLAPSYS.CWM2$AWCubeAggLevel
  ADD (Constraint CWM2$AWCubeAggLevel_ID UNIQUE
   (CubeAgg_IRID, Dim_IRID, Level_IRID))
/


alter table OLAPSYS.CWM2$AWCubeAggMeasure
  ADD (Constraint CWM2$AWCubeAggMeasure_ID UNIQUE
   (CubeAgg_IRID, Measure_IRID))
/


alter table OLAPSYS.CWM2$AWCompositeSpec
  ADD (Constraint CWM2$AWCompositeSpec_ID UNIQUE
   (Cube_IRID ,Version_Id, Name))
/


alter table OLAPSYS.CWM2$AWCompSpecMembership
  ADD (Constraint CWM2$AWCompSpecMembership_ID UNIQUE
   (CompSpec_IRID ,MemberType ,Name))
/


REM Foreign Key Constraints


alter table OLAPSYS.CWM2$AWDimLoadFilter ADD Constraint
  CWM2$AWDimLoadFilter_FK1 FOREIGN KEY
  (DIMLOAD_IRID) References OLAPSYS.CWM2$AWDimLoad
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWDimLoadParmValue ADD Constraint
  CWM2$AWDimLoadParmValue_FK1 FOREIGN KEY
  (DIMLOAD_IRID) References OLAPSYS.CWM2$AWDimLoad
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCubeLoadFilter ADD Constraint
  CWM2$AWCubeLoadFilter_FK1 FOREIGN KEY
  (CUBELOAD_IRID) References OLAPSYS.CWM2$AWCubeLoad
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCubeLoadParmValue ADD Constraint
  CWM2$AWCubeLoadParmValue_FK1 FOREIGN KEY
  (CUBELOAD_IRID) References OLAPSYS.CWM2$AWCubeLoad
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCubeLoadMeasure ADD Constraint
  CWM2$AWCubeLoadMeasure_FK FOREIGN KEY
  (CUBELOAD_IRID) References OLAPSYS.CWM2$AWCubeLoad
  (IRID) On Delete Cascade
/


alter table OLAPSYS.CWM2$AWCubeAggLevel ADD Constraint
  CWM2$AWCubeAggLevel_FK1 FOREIGN KEY
  (CUBEAGG_IRID) References OLAPSYS.CWM2$AWCubeAgg
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCubeAggMeasure ADD Constraint
  CWM2$AWCubeAggMeasure_FK1 FOREIGN KEY
  (CUBEAGG_IRID) References OLAPSYS.CWM2$AWCubeAgg
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCubeLoadAggPlan ADD Constraint
  CWM2$AWCubeLoadAggPlan_FK1 FOREIGN KEY
  (CUBELOAD_IRID) References OLAPSYS.CWM2$AWCubeLoad
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCubeLoadAggPlan ADD Constraint
  CWM2$AWCubeLoadAggPlan_FK2 FOREIGN KEY
  (CUBEAGG_IRID) References OLAPSYS.CWM2$AWCubeAgg
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCompSpecMembership ADD Constraint
  CWM2$AWCompSpecMembership_FK1 FOREIGN KEY
  (CompSpec_IRID) References OLAPSYS.CWM2$AWCompositeSpec
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCompSpecMembership ADD Constraint
  CWM2$AWCompSpecMembership_FK2 FOREIGN KEY
  (Composite_IRID) References OLAPSYS.CWM2$AWCompSpecMembership
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCubeCompPlan ADD Constraint
  CWM2$AWCubeCompPlan_FK1 FOREIGN KEY
  (CUBELOAD_IRID) References OLAPSYS.CWM2$AWCubeLoad
  (IRID) On Delete Cascade
/

alter table OLAPSYS.CWM2$AWCubeCompPlan ADD Constraint
  CWM2$AWCubeCompPlan_FK2 FOREIGN KEY
  (CUBECOMPSPEC_IRID) References OLAPSYS.CWM2$AWCompositeSpec
  (IRID) On Delete Cascade
/

-- bug 2967276
ALTER TABLE OLAPSYS.CWM2$FACTKEYDIMHIERMAP ADD CONSTRAINT
   CWM2$FACTKEYDIMHIERMAP_DIM_FK FOREIGN KEY
   (DIMENSION_IRID) REFERENCES OLAPSYS.CWM2$DIMENSION (IRID) 
   ON DELETE CASCADE
/
-- 123456789012345678901234567890
-- BUG 2639233
ALTER TABLE OLAPSYS.CWM2$FACTKEYDIMHIERLVLMAP ADD CONSTRAINT
   CWM2$FACTKEYD_H_L_MAP_LVL_FK FOREIGN KEY
   (LEVEL_IRID) REFERENCES OLAPSYS.CWM2$LEVEL (IRID) 
   ON DELETE CASCADE
/

-- BUG 2639233
ALTER TABLE OLAPSYS.CWM2$FACTKEYDIMHIERLVLMAP ADD CONSTRAINT
   CWM2$FACTKEYD_H_L_MAP_HIER_FK FOREIGN KEY
   (HIERARCHY_IRID) REFERENCES OLAPSYS.CWM2$HIERARCHY (IRID) 
   ON DELETE CASCADE
/

-- BUG 2639233
ALTER TABLE OLAPSYS.CWM2$FACTDIMHIERTPLSDTL ADD CONSTRAINT
   CWM2$FACTDIMH_TPLSDTL_HIER_FK FOREIGN KEY
   (HIER_IRID) REFERENCES OLAPSYS.CWM2$HIERARCHY (IRID) 
   ON DELETE CASCADE
/


CREATE INDEX OLAPSYS.CWM2$_CUST_MEAS_VIEW_NAME ON
    OLAPSYS.CWM2$_AW_NEXT_PERM_CUST_MEAS(AW_ACCESS_VIEW_NAME)
/


CREATE INDEX OLAPSYS.CWM2$_VIEW_AND_CUST_MEAS_COL ON
    OLAPSYS.CWM2$_AW_PERM_CUST_MEAS_MAP(AW_ACCESS_VIEW_NAME, CUST_ADT_COLUMN)
/

CREATE INDEX CWM2$COMPSPEC_IRID_IDX on OLAPSYS.CWM2$AWCOMPSPECMEMBERSHIP (COMPSPEC_IRID)
/

CREATE INDEX CWM2$COMPOSITE_IRID_IDX on OLAPSYS.CWM2$AWCOMPSPECMEMBERSHIP (COMPOSITE_IRID)
/

CREATE INDEX CWM2$CUBECOMPSPEC_IRID_IDX on OLAPSYS.CWM2$AWCUBECOMPPLAN (CUBECOMPSPEC_IRID)
/

