
--SET ECHO OFF

-- |----------------------------------------------------------------------------
-- | $Header: cwm2utl2.pls 19-Sep-2002 by Aziz.Mboya@oracle.com
-- |
-- | cwm2utl2.pls
-- |
-- | Copyright (c) Oracle Corporation  2001. All Rights Reserved.
-- |
-- | NAME
-- | cwm2utl2.pls - package: cwm2_olap_aw_awutil
-- |
-- | DESCRIPTION
-- |   Utility functions for accessing any manipulating Analytic Workspaces objects
-- |
-- | NOTES
-- |
-- | MODIFIED   (MM/DD/YY)
-- |    awesley  08/06/03 - 92031 to 92041
-- | Aziz.Mboya  06/16/03 - Fix to bug 3009625: CANNOT ADD MEASURES IN DATABASE STANDARD FORM TO AN ANALYTIC WORKSPACE
-- | Aziz.Mboya  12/09/02 - Fix to bug 2698866 - CWM2_OLAP_AW_ACCESS REQUIRES NAME UPDATE 
-- |    kingols  12/02/02 - kingols_txn105343
-- | Aziz.Mboya  07/19/02 - Created .pls file
-- |----------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE CWM2_OLAP_AW_AWUTIL AUTHID CURRENT_USER AS
	
	FUNCTION GetTokenAtIndex(p_iWordNumber INTEGER,
	p_vSeparator VARCHAR2,
	p_vStrContainingWord VARCHAR2) RETURN VARCHAR2;

	PROCEDURE OpenFile(p_FileHandle IN OUT utl_file.file_type,
	p_vDirectory VARCHAR2, p_vFileName VARCHAR2, p_vMode VARCHAR2);

	PROCEDURE OpenDebugFile(p_vDebugDirectory VARCHAR2 DEFAULT NULL,
	p_vDebugFileName VARCHAR2 DEFAULT NULL);

	PROCEDURE CloseDebugFile;

	PROCEDURE OpenTestOutputFile(p_FileHandle IN OUT utl_file.file_type,
	p_vDebugDirectory VARCHAR2 DEFAULT NULL,
	p_vDebugFileName VARCHAR2 DEFAULT NULL,
	p_vDebugPackage VARCHAR2 DEFAULT NULL,
	p_bSuppressDateStamp BOOLEAN DEFAULT NULL);

	PROCEDURE CloseTestOutputFile(p_FileHandle IN OUT utl_file.file_type);

	FUNCTION FileExists(p_vDirectory VARCHAR2,
	p_vFileName VARCHAR2) RETURN BOOLEAN;

	FUNCTION FileExists_Str(p_vDirectory VARCHAR2,
	p_vFileName VARCHAR2) RETURN VARCHAR2;

	PROCEDURE CloseFile(p_FileHandle IN OUT utl_file.file_type,
	p_bFileFlush BOOLEAN DEFAULT NULL);

	FUNCTION QUOTE(p_vStr VARCHAR2) RETURN VARCHAR2;

	PROCEDURE DisplayAllErrors(p_vAWCommand VARCHAR2 DEFAULT NULL);

	FUNCTION AW_ObjectExists(p_vAWObjectName VARCHAR2,
	p_vWorkspace VARCHAR2 DEFAULT NULL,
	p_bOpenAW BOOLEAN DEFAULT NULL) RETURN BOOLEAN;
    
	FUNCTION AW_ObjectExists_Str(p_vAWObjectName VARCHAR2,
	p_vWorkspace VARCHAR2 DEFAULT NULL,
	p_bOpenAW BOOLEAN DEFAULT NULL) RETURN VARCHAR2;

	PROCEDURE AW_DeleteObject(p_vAWObjectName VARCHAR2,
	p_vWorkspace VARCHAR2,
	p_bOpenAW BOOLEAN DEFAULT NULL);
	
	FUNCTION AW_AW(p_vKeyWord VARCHAR2, p_vWorkspace VARCHAR2 DEFAULT NULL) RETURN VARCHAR2;

	FUNCTION AW_IsOpen(p_vWorkspace VARCHAR2) RETURN BOOLEAN;

	FUNCTION AW_IsOpen_Str(p_vWorkspace VARCHAR2) RETURN VARCHAR2;
	
	FUNCTION AW_IsATextExpr(p_vExpr VARCHAR2) RETURN VARCHAR2;

	FUNCTION AW_GetOpenMode(p_vWorkspace VARCHAR2) RETURN VARCHAR2;

	FUNCTION AW_Detach(p_vWorkspace VARCHAR2) RETURN BOOLEAN;

	FUNCTION AW_Attach(p_vWorkspace VARCHAR2, p_vOpenMode VARCHAR2) RETURN BOOLEAN;

	FUNCTION CreateAWFormula(
	p_vAWFormulaCreateMode VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vAWFormulaExpr VARCHAR2,
	p_vWorkspace VARCHAR2) RETURN BOOLEAN;

	PROCEDURE PCreateAWFormula(
	p_vAWFormulaCreateMode VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vAWFormulaExpr VARCHAR2,
	p_vWorkspace VARCHAR2);

	PROCEDURE PrintMsg(p_vLineText VARCHAR2,
	p_bLeadBlankLine BOOLEAN DEFAULT NULL,
	p_bTrailBlankLine BOOLEAN DEFAULT NULL);

	PROCEDURE LogMessage(p_vMessage_Name VARCHAR2,
	p_vParam1 VARCHAR2 DEFAULT NULL,
	p_vParam2 VARCHAR2 DEFAULT NULL,
	p_vParam3 VARCHAR2 DEFAULT NULL,
	p_vParam4 VARCHAR2 DEFAULT NULL,
	p_vParam5 VARCHAR2 DEFAULT NULL);

	PROCEDURE Log_Note(p_vMessage VARCHAR2);

	PROCEDURE LogAWErrorText(p_vAWCommand VARCHAR2 DEFAULT NULL);

	PROCEDURE PutLine(p_FileHandle IN OUT utl_file.file_type,
	p_vLineText VARCHAR2);
	
	PROCEDURE PutMultiLine(p_FileHandle IN OUT utl_file.file_type,
	p_vMultiLineText VARCHAR2);

	FUNCTION ReadMappingInfo(p_FileHandle IN OUT utl_file.file_type,
	p_vInputFileDirectory VARCHAR2,
	p_vInputFileName VARCHAR2,
	p_vLimitMap IN OUT VARCHAR2) RETURN BOOLEAN;

	PROCEDURE SaveLineText(p_FileHandle IN OUT utl_file.file_type,
	p_vLineText VARCHAR2, p_bAddNewLine BOOLEAN);

	PROCEDURE GetLine(p_FileHandle IN OUT utl_file.file_type,
	p_vLineText IN OUT VARCHAR2, p_EOF IN OUT BOOLEAN);

	FUNCTION TrimInt(p_iVal INTEGER) RETURN VARCHAR2;

	FUNCTION LeftFill(p_iValue INTEGER, p_iStrLength INTEGER,
	p_vFillChar VARCHAR2) RETURN VARCHAR2;

	FUNCTION NullString(p_vStr VARCHAR2 DEFAULT NULL) RETURN BOOLEAN;

	PROCEDURE AW_EQ(p_vAWFormulaName VARCHAR2,
	p_vAWFormulaExpr VARCHAR2,
	p_vWorkspace VARCHAR2);
    
	FUNCTION AW_OneDim_Var_QDR(p_vVariableName VARCHAR2,
	p_vDimensionName VARCHAR2,
	p_vDimensionValue VARCHAR2,
	p_vWorkspace VARCHAR2,
	p_bOpenAW BOOLEAN DEFAULT NULL) RETURN VARCHAR2;

	PROCEDURE AW_OneDim_Var_Save(p_vVariableName VARCHAR2,
	p_vDimensionName VARCHAR2,
	p_vDimensionValue VARCHAR2,
	p_vNewValue VARCHAR2,
	p_vWorkspace VARCHAR2,
	p_bOpenAW BOOLEAN DEFAULT NULL);

	PROCEDURE SetNewLine;

	FUNCTION NewLine RETURN VARCHAR2;

	FUNCTION InString(p_vStrToSearch VARCHAR2, p_vStr VARCHAR2) RETURN BOOLEAN;

	PROCEDURE ClearErrorText;

	PROCEDURE PrintMsgCreationFailed(p_vWorkspace VARCHAR2,
	p_vAWFormulaName VARCHAR2);
	
	PROCEDURE Log_MultiLine_Note(p_vMessage VARCHAR2);
	
	FUNCTION FetchAWLog(p_vFetchExpr VARCHAR2,
	p_iNewLineLength INTEGER DEFAULT NULL) RETURN VARCHAR2;

	FUNCTION FetchAsStr(p_vFetchExpr VARCHAR2,
	p_iNewLineLength INTEGER DEFAULT NULL,
	p_ibUseShowCmd INTEGER DEFAULT NULL,
	p_ibConvertToText INTEGER DEFAULT NULL) RETURN VARCHAR2;

	FUNCTION FetchErrorText RETURN VARCHAR2;

	FUNCTION ReadCurrMeasureColName(p_vRDBMSViewName VARCHAR2,
	p_vFormulaDataType VARCHAR2,
	p_vAWFormulaCreateMode VARCHAR2) RETURN VARCHAR2;

	FUNCTION MakeNextMeasureColName(p_vCurrColumnName VARCHAR2,
	p_iTextPartLength INTEGER) RETURN VARCHAR2;

	FUNCTION GetNextMeasureColName(p_vRDBMSViewName VARCHAR2,
	p_vFormulaDataType VARCHAR2,
	p_vAWFormulaCreateMode VARCHAR2,
	p_iReusableCount IN OUT INTEGER) RETURN VARCHAR2;

	FUNCTION TableSelect(p_vTableName VARCHAR2,
	p_vSelectedColumn VARCHAR2,
	p_vWhereCondition VARCHAR2) RETURN VARCHAR2;

    FUNCTION TableRowCount(p_vTableName VARCHAR2,
    p_vCountExpr VARCHAR2,
    p_vWhereCondition VARCHAR2) RETURN INTEGER;
	
	PROCEDURE TableInsert(p_vTableName VARCHAR2,
	p_vUpdateColumn VARCHAR2,
	p_vNewColumnValue VARCHAR2,
	p_ibAddQuotes INTEGER DEFAULT NULL);
	
	PROCEDURE TableInsertMultiCol(p_vTableName VARCHAR2,
	p_ibAddQuotes INTEGER,
	p_vUpdateColumn1 VARCHAR2, p_vNewColumn1Value VARCHAR2,
	p_vUpdateColumn2 VARCHAR2 DEFAULT NULL, p_vNewColumn2Value VARCHAR2 DEFAULT NULL,
	p_vUpdateColumn3 VARCHAR2 DEFAULT NULL, p_vNewColumn3Value VARCHAR2 DEFAULT NULL,
	p_vUpdateColumn4 VARCHAR2 DEFAULT NULL, p_vNewColumn4Value VARCHAR2 DEFAULT NULL,
	p_vUpdateColumn5 VARCHAR2 DEFAULT NULL, p_vNewColumn5Value VARCHAR2 DEFAULT NULL,
	p_vUpdateColumn6 VARCHAR2 DEFAULT NULL, p_vNewColumn6Value VARCHAR2 DEFAULT NULL);
    
	PROCEDURE TableUpdate(p_vTableName VARCHAR2,
	p_vUpdateColumn VARCHAR2,
	p_vNewColumnValue VARCHAR2,
	p_vWhereCondition VARCHAR2,
	p_ibAddQuotes INTEGER DEFAULT NULL);
	
	PROCEDURE TableUpdateMultiCol(p_vTableName VARCHAR2,
	p_ibAddQuotes INTEGER, p_vWhereCondition VARCHAR2,
	p_vUpdateColumn1 VARCHAR2, p_vNewColumn1Value VARCHAR2,
	p_vUpdateColumn2 VARCHAR2 DEFAULT NULL, p_vNewColumn2Value VARCHAR2 DEFAULT NULL,
	p_vUpdateColumn3 VARCHAR2 DEFAULT NULL, p_vNewColumn3Value VARCHAR2 DEFAULT NULL,
	p_vUpdateColumn4 VARCHAR2 DEFAULT NULL, p_vNewColumn4Value VARCHAR2 DEFAULT NULL,
	p_vUpdateColumn5 VARCHAR2 DEFAULT NULL, p_vNewColumn5Value VARCHAR2 DEFAULT NULL,
	p_vUpdateColumn6 VARCHAR2 DEFAULT NULL, p_vNewColumn6Value VARCHAR2 DEFAULT NULL);
    
	PROCEDURE TableDelete(p_vTableName VARCHAR2,
	p_vWhereCondition VARCHAR2);

	FUNCTION MakeFormulaLimitMap(p_vMeasureLimitMap VARCHAR2,
	p_vAWFormulaName VARCHAR2,
	p_vRDBMSMeasureColumn VARCHAR2) RETURN VARCHAR2;

	PROCEDURE ReadCursor(p_vSQLStmt VARCHAR2,
	p_vRetVal IN OUT VARCHAR2,
	p_iRowToRead INTEGER DEFAULT NULL);
	
	FUNCTION NumberOfUsers(p_vOwner VARCHAR2, 
	p_vWorkspace VARCHAR2,
	p_vAccessMode VARCHAR2 DEFAULT NULL) RETURN INTEGER;

	FUNCTION UserLoggedIn(
	p_vUsername VARCHAR2,
	p_vSID NUMBER DEFAULT NULL) RETURN INTEGER;

	PROCEDURE InitTempVTable;

	FUNCTION ParseLimitMap(p_vRDBMSColumn VARCHAR2,
	p_vLimitMap IN OUT VARCHAR2,
	p_iMultiLine INTEGER) RETURN VARCHAR2;

	FUNCTION User_View_Exists(p_vRDBMSViewName VARCHAR2) RETURN INTEGER;

    FUNCTION Get_Object_Type(p_vObjectName VARCHAR2) RETURN VARCHAR2;

    PROCEDURE CREATE_DSF_FORMULA(p_vSchema VARCHAR2, 
    p_vWorkspace VARCHAR2,
    p_vAWMeasure_Name VARCHAR2,
    p_vDisplay_Name VARCHAR2,
    p_vData_Type VARCHAR2,
    p_vCube VARCHAR2,
    p_vSegWidth VARCHAR2,
    p_vAggMap VARCHAR2,
    p_vCreated_By VARCHAR2,
    p_bIncl_Schema_In_Metadata BOOLEAN DEFAULT NULL);

    PROCEDURE CREATE_DSF_MEASURE(p_vSchema VARCHAR2, 
    p_vWorkspace VARCHAR2,
    p_vAWMeasure_Name VARCHAR2,
    p_vDisplay_Name VARCHAR2,
    p_vData_Type VARCHAR2,
    p_vCube VARCHAR2,
    p_vSegWidth VARCHAR2,
    p_vAggMap VARCHAR2,
    p_vCreated_By VARCHAR2,
    p_bIncl_Schema_In_Metadata BOOLEAN DEFAULT NULL);

    PROCEDURE DELETE_DSF_MEASURE(p_vSchema VARCHAR2, 
    p_vWorkspace VARCHAR2,
    p_vAWMeasure_Name VARCHAR2,
    p_vCube VARCHAR2,
    p_bIncl_Schema_In_Metadata BOOLEAN DEFAULT NULL);

    PROCEDURE DELETE_OLAPI_METADATA(p_vSchema VARCHAR2, 
    p_vWorkspace VARCHAR2,
    p_vAWMeasure_Name VARCHAR2,
    p_vCube VARCHAR2,
    p_bIncl_Schema_In_Metadata BOOLEAN DEFAULT NULL);

    PROCEDURE CONVERT_TO_DSF_MEASURE(p_vSchema VARCHAR2, 
    p_vWorkspace VARCHAR2,
    p_vAWMeasure_Name VARCHAR2,
    p_vDisplay_Name VARCHAR2,
    p_vCube VARCHAR2,
    p_vSegWidth VARCHAR2,
    p_vCreated_By VARCHAR2,
    p_bSkipObjChecks BOOLEAN DEFAULT NULL);

    PROCEDURE CONVERT_TO_OLAPI_MEASURE(p_vSchema VARCHAR2, 
    p_vWorkspace VARCHAR2,
    p_vAWMeasure_Name VARCHAR2,
    p_vCube VARCHAR2,
    p_vDisplay_Name VARCHAR2,
    p_vCreated_By VARCHAR2,
    p_bSkipObjChecks BOOLEAN DEFAULT NULL,
    p_bIncl_Schema_In_Metadata BOOLEAN DEFAULT NULL);

END CWM2_OLAP_AW_AWUTIL;

/

SHOW ERRORS;

