-- |----------------------------------------------------------------------------
-- | $Header: makcmcat.sql 20-Aug-2002 Aziz.Mboya@oracle.com
-- |
-- | Copyright (C) Oracle Corporation  2002. All Rights Reserved.
-- |
-- | NAME
-- | makcmcat.sql
-- |
-- | DESCRIPTION
-- |   SQL script to create catalog used by Custom Measures API functions:
-- |   cwm2_olap_aw_access.CreateCustomMeasure(),
-- |   cwm2_olap_aw_access.UpdateCustomMeasure(),
-- |   cwm2_olap_aw_access.DeleteCustomMeasure() in cwm2conv.sql
-- |
-- | NOTES
-- |
-- | MODIFIED   (MM/DD/YY)
-- |    cdalessi 10/27/03 - upgrade to 9.2.0.5.0 
-- |    kingols  12/02/02 - kingols_txn105343
-- | Aziz.Mboya  10/03/02 - Fix to bug 2608598. CUSTOM MEASURES GLOBAL TEMPORARY TABLE NOT VISIBLE TO NON-DBA USER
-- | Aziz.Mboya  08/20/02 - Created.
-- |----------------------------------------------------------------------------


-- Table to keep log of next available Custom Measure ADT column to use
-- Initially this is blank. Before the first PERMANENT Custom Measure for a
-- particular View is created, the initial values 'CUST_MEAS_NUM1' for numeric
-- Custom Measures and 'CUST_MEAS_TEXT1' for text Custom Measures are Inserted.
--
-- | AW_ACCESS_VIEW_NAME              | NUM_CUST_MEASURE | TEXT_CUST_MEASURE |
-- |----------------------------------|------------------|-------------------|
-- | XADEMO.DLB_XADEMO_ANALYTI_1_VIEW | CUST_MEAS_NUM1   | CUST_MEAS_TEXT1   |

--DROP INDEX CWM2$_CUST_MEAS_VIEW_NAME;
--DROP TABLE CWM2$_AW_NEXT_PERM_CUST_MEAS;

CREATE TABLE CWM2$_AW_NEXT_PERM_CUST_MEAS (
    AW_ACCESS_VIEW_NAME VARCHAR2(61),
    NUM_CUST_MEASURE	VARCHAR2(30),
    TEXT_CUST_MEASURE	VARCHAR2(30)
);

--GRANT SELECT, INSERT, UPDATE, DELETE ON CWM2$_AW_NEXT_PERM_CUST_MEAS TO PUBLIC;

CREATE INDEX CWM2$_CUST_MEAS_VIEW_NAME ON
CWM2$_AW_NEXT_PERM_CUST_MEAS(AW_ACCESS_VIEW_NAME);
COMMIT;


-- Table to contain a catalog of mappings for PERMANENT Custom Measures by
-- View. Multiple Views can access the same Analytic Workspace the same way
-- one can create multiple Views against the same Relational Table.
-- | AW_ACCESS_VIEW_NAME              | CUST_ADT_COLUMN | WORKSPACE_NAME | AW_MEASURE_NAME |
-- |----------------------------------|-----------------|----------------|-----------------|
-- | XADEMO.DLB_XADEMO_ANALYTI_1_VIEW | CUST_MEAS_NUM1  | XADEMO.CLONED  | f.profit        |
-- | XADEMO.DLB_XADEMO_ANALYTI_1_VIEW | CUST_MEAS_NUM2  | XADEMO.CLONED  | f.netprf        |
-- | ..                               | ..              | ..             | ..              |
-- If a Custom Measure is deleted its entry in the column AW_MEASURE_NAME is set to NULL
-- so its View column mapping can be reused.

--DROP INDEX CWM2$_VIEW_AND_CUST_MEAS_COL;
--DROP TABLE CWM2$_AW_PERM_CUST_MEAS_MAP;

CREATE TABLE CWM2$_AW_PERM_CUST_MEAS_MAP (
    AW_ACCESS_VIEW_NAME VARCHAR2(61) NOT NULL,
    CUST_ADT_COLUMN     VARCHAR2(30) NOT NULL,
    WORKSPACE_NAME      VARCHAR2(61),
    AW_MEASURE_NAME     VARCHAR2(64),
    SESSIONID           VARCHAR2(10),
    USERNAME            VARCHAR2(30)
);

--GRANT SELECT, INSERT, UPDATE, DELETE ON CWM2$_AW_PERM_CUST_MEAS_MAP TO PUBLIC;

CREATE INDEX CWM2$_VIEW_AND_CUST_MEAS_COL ON
CWM2$_AW_PERM_CUST_MEAS_MAP(AW_ACCESS_VIEW_NAME, CUST_ADT_COLUMN);
COMMIT;



--Session specific tables for Temporary Custom Measures

--Table to keep log of next available Custom Measure ADT column to use
--DROP TABLE CWM2$_AW_NEXT_TEMP_CUST_MEAS;

CREATE GLOBAL TEMPORARY TABLE CWM2$_AW_NEXT_TEMP_CUST_MEAS (
    AW_ACCESS_VIEW_NAME VARCHAR2(61),
    NUM_CUST_MEASURE	VARCHAR2(30),
    TEXT_CUST_MEASURE	VARCHAR2(30))
    ON COMMIT PRESERVE ROWS;

GRANT SELECT, INSERT, UPDATE, DELETE ON CWM2$_AW_NEXT_TEMP_CUST_MEAS TO PUBLIC;

-- Table to contain a catalog of mappings for TEMPORARY Custom Measures by
-- View.

--DROP TABLE CWM2$_AW_TEMP_CUST_MEAS_MAP;

CREATE GLOBAL TEMPORARY TABLE CWM2$_AW_TEMP_CUST_MEAS_MAP (
    AW_ACCESS_VIEW_NAME VARCHAR2(61) NOT NULL,
    CUST_ADT_COLUMN     VARCHAR2(30) NOT NULL,
    WORKSPACE_NAME      VARCHAR2(61),
    AW_MEASURE_NAME     VARCHAR2(64),
    SESSIONID           VARCHAR2(10),
    USERNAME            VARCHAR2(30))
    ON COMMIT PRESERVE ROWS;

GRANT SELECT, INSERT, UPDATE, DELETE ON CWM2$_AW_TEMP_CUST_MEAS_MAP TO PUBLIC;



--Table for storing temporary session-specific runtime information.

--DROP TABLE CWM2$_TEMP_VALUES;

CREATE GLOBAL TEMPORARY TABLE CWM2$_TEMP_VALUES (
    INT_VAR NUMBER(30),
    NUM_VAR NUMBER(36,6),
    TEXT_VAR VARCHAR2(255))
    ON COMMIT PRESERVE ROWS;

GRANT SELECT, INSERT, UPDATE, DELETE ON CWM2$_TEMP_VALUES TO PUBLIC;

--End of file: makcmcat.sql


