Rem
Rem $Header: olapawi.sql 27-oct-2003.11:21:19 cdalessi Exp $
Rem
Rem olapawi.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      olapawi.sql
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem

CREATE OR REPLACE PACKAGE DBMSAW AUTHID CURRENT_USER AS


PROCEDURE aw_dimension_create(awOwner IN varchar2,awName IN varchar2,exOwnerName IN varchar2,exDimName IN varchar2);

PROCEDURE aw_dimension_refresh(awOwner IN varchar2,awName IN varchar2,exOwnerName IN varchar2,exDimName IN varchar2);

PROCEDURE aw_cube_create(awOwner IN varchar2,awName IN varchar2,exOwnerName IN varchar2,exCubeName IN varchar2);

PROCEDURE aw_cube_refresh(awOwner IN varchar2,awName IN varchar2,exOwnerName IN varchar2,exCubeName IN varchar2);


END;
/
CREATE OR REPLACE PACKAGE BODY DBMSAW AS

FUNCTION FetchAsStr(p_vFetchExpr VARCHAR2) RETURN VARCHAR2 IS
cTempClob CLOB;
vAWShowCmd VARCHAR2(30000);
vRetVal VARCHAR2(32767);


BEGIN
    vAWShowCmd := 'show convert(' || p_vFetchExpr || ' text)';
    cTempClob := DBMS_AW.INTERP(vAWShowCmd); --copy AW log to CLOB variable
    vRetVal := DBMS_LOB.SUBSTR(cTempClob); --copy first 32K of AW log to variable
    DBMS_LOB.FREETEMPORARY(cTempClob);
    RETURN LTRIM(RTRIM(vRetVal));
END FetchAsStr;

PROCEDURE aw_dimension_create(awOwner IN varchar2,awName IN varchar2,exOwnerName IN varchar2,exDimName IN varchar2) IS

    eDimName varchar2(30);
    eOwnerName varchar2(30);
		eAWName  varchar2(30);
    eAWOwner varchar2(30);
    retcode varchar2(10);
    QUOTE varchar2(10) := '''';
    dim_id NUMBER;
    eUpdate BOOLEAN;
    clobval CLOB;
    retval varchar2(1000);
    eIrid NUMBER;
    splcmd varchar2(1000);
		others EXCEPTION;
BEGIN
    eDimName:= UPPER(exDimName);
    eOwnerName:= UPPER(exOwnerName);
    eAWName:= UPPER(awName);
    eAWOwner:= UPPER(awOwner);

  --  dim_id:= cwm$util.get_dimension_id(eOwnerName,eDimName);
  --  If dim_id = 0 THEN
  --    cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create');
  --    raise cwm2_olap_exception.Not_Found;
  --  else
  --  end if;

  --  SELECT IRID into eIrid from OLAPSYS.CwM2$Dimension where
  --    Owner= eOwnerName AND
  --    Name= eDimName;

 --  splcmd:= 'show  AW_CREATE_DIMENSION(''''eAWOwner'''' ''''eAWName'''' ''''eOwnerName'''' ''''eDimName'''')';
 --   splcmd:= 'show  AW_CREATE_DIMENSION(eAWOwner || ' ' || eAWName ' ' || eOwnerName ' ' || eDimName)';
   splcmd:= 'AW_CREATE_DIMENSION(' || QUOTE || eAWOwner || QUOTE || ' '
   || QUOTE || eAWName || QUOTE || ' ' || QUOTE || eOwnerName || QUOTE || ' '
   || QUOTE || eDimName || QUOTE || ')';
 --  dbms_output.put_line(splcmd);
 --    dbms_aw.execute('shw aw_create_dimension(''XADEMO'' ''CLONED'' ''XADEMO'' ''CHANNEL'')');
    retcode:= FetchAsStr(splcmd);
  --  dbms_aw.execute (AW_REFRESH_CUBE('eAWOwner' 'eAWName' 'eOwnerName' 'eCubeName');

 --   retcode:= To_char(dbms_aw.interp('show AW_CREATE_DIMENSION(''eAWOwner'' ''eAWName'' ''eOwnerName'' ''eDimName'')'));

    if retcode = '1' then
      --retval:= To_char(dbms_aw.interp('show ___err.text'));
   --   retval:= FetchAsStr('___err-text'));
--    raise cwm2_olap_exception.Invalid;
     DBMS_OUTPUT.PUT_LINE(retval);
    end if;



  --  exception
    --  when NO_DATA_FOUND
    --  then
    --    cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create','eDimName');
    --    raise cwm2_olap_exception.Not_Found;
    --  when INVALID
    --  then
    --    cwm2_olap_manager.log_Message(retval,'aw_mv_dim_create','eDimName');
    --    raise cwm2_olap_exception.Invalid;
    --  DBMS_OUTPUT.PUT_LINE('aw_dimension_create: %s',retval);

  end;



PROCEDURE aw_dimension_refresh(awOwner IN varchar2,awName IN varchar2,exOwnerName IN varchar2,exDimName IN varchar2) IS

    eDimName varchar2(30);
    eOwnerName varchar2(30);
		eAWName  varchar2(30);
    eAWOwner varchar2(30);
    dim_id NUMBER;
    QUOTE varchar2(10) := '''';
    retcode varchar2(10);
    eUpdate BOOLEAN;
    splcmd varchar2(1000);
    retval varchar2(100);
    eIrid NUMBER;
		others EXCEPTION;

		BEGIN
	--	CREATE TABLE SYSTEM.MVIEW$_ADV_INDEX (RUNID# NUMBER NOT NULL,
	--  																			RANK# NUMBER NOT NULL,
	--  																			SUMMARY_OWNER VARCHAR2(32),
	--  																			INDEX_TEXT LONG);


    eDimName:= UPPER(exDimName);
    eOwnerName:= UPPER(exOwnerName);
    eAWName:= UPPER(awName);
    eAWOwner:= UPPER(awOwner);

  --  dim_id:= cwm$util.get_dimension_id(eOwnerName,eDimName);
  --  If dim_id = 0 THEN
  --    cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create');
  --    raise cwm2_olap_exception.Not_Found;
  --  else
  --  end if;

  --  SELECT IRID into eIrid from OLAPSYS.CwM2$Dimension where
  --    Owner= eOwnerName AND
  --    Name= eDimName;



--  splcmd:= 'show AW_REFRESH_DIMENSION(''''eAWOwner'''' ''''eAWName'''' ''''eOwnerName'''' ''''eDimName'''')';
--    splcmd:= 'show AW_REFRESH_DIMENSION(eAWOwner || ' ' ||  eAWName || ' ' || eOwnerName || ' ' || eDimName)';
--  splcmd:= '''show AW_REFRESH_DIMENSION(''''' || eAWOwner || ''''' ''''' || eAWName || ''''' ''''' || eOwnerName || ''''' ''''' || eDimName||''''')';
    splcmd:= 'AW_REFRESH_DIMENSION(' || QUOTE || eAWOwner || QUOTE || ' ' || QUOTE || eAWName || QUOTE || ' ' || QUOTE || eOwnerName || QUOTE || ' ' || QUOTE || eDimName || QUOTE || ')';

    dbms_output.put_line(splcmd);
    retcode:= FetchAsStr(splcmd);
--    retcode:= To_char(dbms_aw.interp(splcmd));

--    retcode:= To_char(dbms_aw.interp('show AW_REFRESH_DIMENSION(''eAWOwner'',''eAWName'',''eOwnerName'', ''eDimName'')'));
    if retcode = '1' then
      retval:= To_char(dbms_aw.interp('show ___err.text'));
   --  raise cwm2_olap_exception.Invalid;
     DBMS_OUTPUT.PUT_LINE(retval);
    end if;

--    exception
--      when NO_DATA_FOUND
--      then
--        cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create','eDimName');
--        raise cwm2_olap_exception.Not_Found;
--      when INVALID
--      then
     --   cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create','eDimName');
     --   raise cwm2_olap_exception.Not_Found;
--        DBMS_OUTPUT.PUT_LINE('aw_dimension_refresh: %s',retval);
end;



PROCEDURE aw_cube_create(awOwner IN varchar2,awName IN varchar2,exOwnerName IN varchar2,exCubeName IN varchar2) IS

    eCubeName varchar2(30);
    eOwnerName varchar2(30);
		eAWName  varchar2(30);
    eAWOwner varchar2(30);
    dim_id NUMBER;
    QUOTE varchar2(10) := '''';
    eUpdate BOOLEAN;
    splcmd varchar2(1000);
    retval varchar2(1000);
    eIrid NUMBER;
    retcode varchar2(10);
		others EXCEPTION;

    BEGIN
    eCubeName:= UPPER(exCubeName);
    eOwnerName:= UPPER(exOwnerName);
    eAWName:= UPPER(awName);
    eAWOwner:= UPPER(awOwner);

  --  dim_id:= cwm$util.get_dimension_id(eOwnerName,eDimName);
  --  If dim_id = 0 THEN
  --    cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create');
  --    raise cwm2_olap_exception.Not_Found;
  --  else
  --  end if;

  --  splcmd:= 'show AW_CREATE_CUBE(''''eAWOwner'''' ''''eAWName'''' ''''eOwnerName'''' ''''eCubeName'''')';
  --  splcmd:= 'show AW_CREATE_CUBE(eAWOwner || ' ' || eAWName || ' ' || eOwnerName ||  ' ' || eCubeName)';
  -- splcmd:= '''show AW_CREATE_CUBE(''''' || eAWOwner ||''''' ''''' || eAWName || ''''' ''''' || eOwnerName || ''''' ''''' || eCubeName ||''''')';
     splcmd:= 'AW_CREATE_CUBE(' || QUOTE || eAWOwner || QUOTE || ' ' || QUOTE || eAWName || QUOTE || ' ' || QUOTE || eOwnerName || QUOTE || ' ' || QUOTE || eCubeName || QUOTE || ')';

    dbms_output.put_line(splcmd);
    retcode:= FetchAsStr(splcmd);
  --  retcode:= To_char(dbms_aw.interp(splcmd));
  --  retcode:= To_char(dbms_aw.interp('show AW_CREATE_CUBE(''eAWOwner'' ''eAWName'' ''eOwnerName'', ''eCubeName'')'));

    if retcode = '1' then
      retval:= To_char(dbms_aw.interp('show ___err.text'));
--      raise cwm2_olap_exception.Invalid;
      DBMS_OUTPUT.PUT_LINE(retval);
    end if;

 --   exception
--      when NO_DATA_FOUND
--      then
--        cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create','eDimName');
--        raise cwm2_olap_exception.Not_Found;
--      when INVALID
--      then
     --   cwm2_olap_manager.log_Message(retval,'aw_mv_dim_create','eDimName');
     --   raise cwm2_olap_exception.Invalid;
--          DBMS_OUTPUT.PUT_LINE('aw_cube_create: %s',retval);
  end;



PROCEDURE aw_cube_refresh(awOwner IN varchar2,awName IN varchar2,exOwnerName IN varchar2,exCubeName IN varchar2) IS

    eCubeName varchar2(30);
    eOwnerName varchar2(30);
		eAWName  varchar2(30);
    eAWOwner varchar2(30);
    retcode varchar2(32767);
    eUpdate BOOLEAN;
    QUOTE varchar2(10) := '''';
    retval varchar2(1000);
    splcmd varchar2(1000);
    eIrid NUMBER;
		others EXCEPTION;

		BEGIN


    eCubeName:= UPPER(exCubeName);
    eOwnerName:= UPPER(exOwnerName);
    eAWName:= UPPER(awName);
    eAWOwner:= UPPER(awOwner);

 -- splcmd:= 'show AW_REFRESH_CUBE('' || eAWOwner || ''''' ''''' || eAWName || ''''' '''''|| eOwnerName || ''''' ''''' || eCubeName ||''''')';

 --   splcmd:= 'AW_REFRESH_CUBE(' || QUOTE || eAWOwner || QUOTE || ' ' || QUOTE || eAWName || QUOTE || ' ' || QUOTE || eOwnerName || QUOTE || ' ' || QUOTE || eCubeName || QUOTE || ')';

 --   splcmd:= 'AW_REFRESH_CUBE(' || QUOTE || eAWOwner || QUOTE || ' ' || QUOTE || eAWName || QUOTE || ' ' || QUOTE || eOwnerName || QUOTE || ' ' || QUOTE || eCubeName || QUOTE || ')';
  splcmd:= 'AW_REFRESH_CUBE(' || QUOTE || eAWOwner || QUOTE || ' ' || QUOTE || eAWName || QUOTE || ' ' || QUOTE || eOwnerName || QUOTE || ' ' || QUOTE || eCubeName || QUOTE || ')';


    dbms_output.put_line(splcmd);
--   retcode:= FetchAsStr(splcmd);
       retcode:= FetchAsStr(splcmd);
--  retcode:= To_char(dbms_aw.interp(splcmd));
--    dbms_aw.execute (AW_REFRESH_CUBE('XADEMO' 'CLONED' 'eOwnerName' 'eCubeName');
--    dbms_aw.execute('shw aw_refresh_cube(''XADEMO'' ''CLONED'' ''XADEMO'' ''ANALYTIC_CUBE'')');
    if retcode = '1' then
      retval:= To_char(dbms_aw.interp('show ___err.text'));
      DBMS_OUTPUT.PUT_LINE(retval);
  --    raise;
    end if;

 --   exception
 --     when NO_DATA_FOUND
 --     then
 --       cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create','eDimName');
 --       raise cwm2_olap_exception.Not_Found;
 --     when INVALID
 --     then
--        cwm2_olap_manager.log_Message('not_found','aw_mv_dim_create','eDimName');
--          DBMS_OUTPUT.PUT_LINE('aw_cube_refresh: %s',retval);
--        raise cwm2_olap_exception.Invalid;
  end;

end;
/
GRANT EXECUTE ON OLAPSYS.DBMSAW TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM DBMSAW FOR OLAPSYS.DBMSAW;




























