REM
REM Copyright (c) 2002, 2005, Oracle. All rights reserved.  
REM
REM  FILE
REM   olapodm.sql
REM
REM  DESCRIPTION
REM    Package Body Implementation of DBMS_ODM
REM
REM  NOTES
REM
REM
REM  MODIFIED  (MM/DD/YY)
Rem     awesley 10/21/05 - port from main
REM     awesley 09/22/05 - bug 4594651 subscript beyound count and performance improvements
REM     awesley 08/24/05 - fix problem with selected levels and tuples
REM     awesley 07/05/05 - port from 10105
REM     awesley 06/28/05 - awesley_txn115083
REM     awesley 03/09/05 - owb enhancements and fixes 
REM     awesley 02/15/05 - add partitioning parameter to CreateDimMV_GS and bug fixed
REM     awesley 12/13/04 - 
REM     awesley 08/16/04 - rewrote
REM     awesley 07/29/04 - version change, CreateDimLevTuple change, Sperry changes
REM     awesley 06/11/04 - started work on generating more consistant so oratst can be written
REM     awesley 06/07/04 - bug 3649263 CreateFactMV_GS bad view
REM     awesley 06/07/04 - bug 3649018 CreateDimMv_GS hang on single level time dimension
REM     awesley 05/27/04 - bug 3630664 generated bitmap index name not unique
REM     awesley 05/12/04 - bug 3172114 CreateStdFactMv minimun (base) row set not correct
REM     awesley 05/12/04 - remove tab characters with emacs untabify and messed up formating in some places, 
REM                        remove some dead code, consolidate type definitions
REM     awesley 05/07/04 - bug 3485203 generated names in create bitmap index too long; limit size
REM     awesley 05/06/04 - bug 3134524 exception messages are returned to call but no exception; reraise exception
REM  09/25/03  mrangwal Fix bug related to non additive aggregates
REM  09/14/03  mrangwal Added non additive aggregates
REM  07/03/03  mrangwal Added code for standard MV generation and better exec time
REM  02/28/03  mrangwal Fix to Dimensions
REM  01/30/03  mrangwal Add Dimension changes
REM  01/20/02  mrangwal created
REM






























































CREATE OR REPLACE PACKAGE BODY DBMS_ODM AS  -- line 101

  --0        1         2         3
  --123456789012345678901234567890

    -- debuging aids for developers
    V_NO                           constant boolean      := FALSE; 
    V_YES                          constant boolean      := TRUE; 

    v_Debug                        boolean               := V_NO;  --?? SET V_NO BEFORE SUBMITTING 
    v_Debug_Overide                boolean               := V_NO;  --?? SET V_NO BEFORE SUBMITTING 

    v_Add_Comment                  boolean               := V_NO;  --?? SET V_NO BEFORE SUBMITTING 

    v_Indented                     boolean               := V_NO;  --?? SET V_NO BEFORE SUBMITTING 

    V_VERSION                      constant varchar2(8)  := '20051015';
    V_VERSION_DATE                 constant varchar2(10) :=        substr(V_VERSION ,5 ,2)
                                                         || '/' || substr(V_VERSION ,7 ,2)
                                                         || '/' || substr(V_VERSION ,1 ,4);
    V_VERSION_YEAR                 constant varchar2(4)  :=        substr(V_VERSION ,1 ,4);

    type t_Procedure_Record is record
    (v_Label                       varchar2(30)          := null
    ,v_Value                       varchar2(100)         := null
    );
    type t_Procedure_Table is table of t_Procedure_Record;
    v_Procedure                    t_Procedure_Table     := t_Procedure_Table();
    v_Procedure_Name               number                := null;
    v_Procedure_Cube_Owner         number                := null;
    v_Procedure_Cube_Name          number                := null;
    v_Procedure_Levels_Table_Owner number                := null;
    v_Procedure_Levels_Table_Name  number                := null;
    v_Procedure_Tuples_Table_Owner number                := null;
    v_Procedure_Tuples_Table_Name  number                := null;
    v_Procedure_Dimension_Owner    number                := null;
    v_Procedure_Dimension_Name     number                := null;
    v_Procedure_Output_File_Path   number                := null;
    v_Procedure_Output_File_Name   number                := null;
    v_Procedure_Partitioning       number                := null;
    v_Procedure_Materializ_Level   number                := null;
    v_Procedure_Materializ_Percent number                := null;
    v_Procedure_Tablespace_MV      number                := null;
    v_Procedure_Tablespace_Index   number                := null;
    v_Procedure_Refresh_Method     number                := null;
    v_Procedure_Refresh_On         number                := null;
    v_Procedure_Execute            number                := null;
    v_Procedure_Hierarchy          number                := null;

    v_Cube_Owner                   varchar2(30)          := null;
    v_Cube_Name                    varchar2(30)          := null;

    v_Dimension_Owner              varchar2(30)          := null;
    v_Dimension_Name               varchar2(30)          := null;

    v_Object_Owner                 varchar2(30)          := null;
    v_Object_Name                  varchar2(30)          := null;

    V_DEFAULT_LEVELS_TABLE_OWNER   constant varchar2(30) := 'SYS';
    V_DEFAULT_LEVELS_TABLE_NAME    constant varchar2(30) := 'OlapTabLevels';
    v_Levels_Table_Owner           varchar2(30)          := V_DEFAULT_LEVELS_TABLE_OWNER;
    v_Levels_Table_Name            varchar2(30)          := V_DEFAULT_LEVELS_TABLE_NAME;

    V_DEFAULT_TUPLES_TABLE_OWNER   constant varchar2(30) := 'SYS';
    V_DEFAULT_TUPLES_TABLE_NAME    constant varchar2(30) := 'OlapTabLevelTuples';
    v_Tuples_Table_Owner           varchar2(30)          := V_DEFAULT_TUPLES_TABLE_OWNER;
    v_Tuples_Table_Name            varchar2(30)          := V_DEFAULT_TUPLES_TABLE_NAME;

    v_ID_Index_Name                varchar2(30)          := null;
    v_Sel_Index_Name               varchar2(30)          := null;

    V_Output_File                  varchar2(1999)        := null;
    v_Output_Path                  varchar2(1999)        := null;

    V_PARTITION_TRUE               constant number       := 1;    -- default
    V_PARTITION_FALSE              constant number       := 0;
    v_Partitioning                 number                := V_PARTITION_TRUE; 

    v_Tablespace_MV                varchar2(30)          := null;
    v_Tablespace_Index             varchar2(30)          := null;

    V_FULL                         constant varchar2(30) := 'FULL';
    V_MINIMUM                      constant varchar2(30) := 'MINIMUM';
    V_PERCENT                      constant varchar2(30) := 'PERCENT';
    V_SELECTED                     constant varchar2(30) := 'SELECTED';

    v_Materialization_Level        varchar2(30)          := null;
    v_Materialization_Percent      number                := null;
    v_Materialization_Percent_Mod  number                := null;

    V_REFRESH_METHOD_FORCE         constant varchar2(30) := 'FORCE';       -- default
    V_REFRESH_METHOD_FAST          constant varchar2(30) := 'FAST';
    V_REFRESH_METHOD_COMPLETE      constant varchar2(30) := 'COMPLETE';
    v_Refresh_Method               varchar2(30)          :=  V_REFRESH_METHOD_FORCE;

    V_REFRESH_ON_DEMAND            constant varchar2(30) := 'DEMAND';      -- default
    V_REFRESH_ON_COMMIT            constant varchar2(30) := 'COMMIT';
    v_Refresh_On                   varchar2(30)          :=  V_REFRESH_ON_DEMAND;

    v_EXECUTE_FALSE                constant varchar2(30) := 'FALSE'; -- do not execute 
    v_EXECUTE_TRUE                 constant varchar2(30) := 'TRUE'; -- execute the 
    v_Execute                      varchar2(30)          := v_EXECUTE_FALSE;

    v_Run_ID                       number                := null;

    V_CREATEDIMLEVTUPLE            constant varchar2(30) := 'CreateDimLevTuple';
    V_CREATECUBELEVELTUPLE         constant varchar2(30) := 'CreateCubeLevelTuple';
    V_CREATEDIMMV_GS               constant varchar2(30) := 'CreateDimMV_GS';
    V_CREATEFACTMV_GS              constant varchar2(30) := 'CreateFactMV_GS';
    V_CREATESTDFACTMV              constant varchar2(30) := 'CreateStdFactMV';
    V_CREATEDIMOWB                 constant varchar2(30) := 'CreateDimOWB';
    V_CREATEFACTOWB                constant varchar2(30) := 'CreateFactOWB';
    V_CREATESTDFACTMVOWB           constant varchar2(30) := 'CreateStdFactMVOW';
    v_Command                      varchar2(1999)        := null;

    V_UNIQUE_SEPERATOR             constant varchar2(30) := '_'; 
    V_COMMA_SEPERATOR              constant varchar2(30) := ', ';
    V_ALIAS_SEPERATOR              constant varchar2(30) := 'x';
    V_ALIAS_ATTRIBUTE_SEPERATOR    constant varchar2(30) := 'a';
    V_ALIAS_SPACE                  constant varchar2(30) := '  ';

    V_MV_CAN_NOT_BE_CREATED        constant varchar2(99) := '-- MATERIALIZED VIEW CAN NOT BE CREATED.  ';

    V_MV_TYPE_DIMENSION            constant varchar2(30) := 'DIMENSION';
    V_MV_TYPE_FACT                 constant varchar2(30) := 'FACT';
    v_MV_Type                      varchar2(30)          := null;

    V_MV_STEP_PUT_GROUPING_ID      varchar2(30)          := 'V_MV_STEP_PUT_GROUPING_ID'; 
    V_MV_STEP_PUT_GROUP_BY_GS      varchar2(30)          := 'V_MV_STEP_PUT_GROUP_BY_GS';
    V_MV_STEP_PUT_PARTITION_BY_RNG varchar2(30)          := 'V_MV_STEP_PUT_PARTITION_BY_RNG'; 
    v_MV_Step                      varchar2(30)          := null;

    v_Varchar2s                    dbms_sql.varchar2s; 
    v_Varchar2s_Remaining           number                := null;
    v_V                            number                := 0;  -- varchar2s index
    v_Cursor                       integer               := 0;
    v_Result                       integer               := 0;

    V_STATUS_OK                    constant varchar2(30) := 'OK';   
    V_STATUS_NOT_FOUND             constant varchar2(30) := 'NOT FOUND';   
    V_STATUS_NO_HIERARCHY          constant varchar2(30) := 'NO HIERARCHY';
    V_STATUS_TOO_LARGE             constant varchar2(30) := 'TOO LARGE';        -- mv is too large
    V_STATUS_ALL_LOWEST_LEVEL      constant varchar2(30) := 'LOWEST LEVEL';     -- all levels lowest levels
    V_STATUS_NOT_UNSOLVED          constant varchar2(30) := 'NOT UNSOLVED';     -- hierarchy  not unsolved level-based
    v_Status                       varchar2(30)          := null;
    v_Status_Message               varchar2(1999)        := null;

    V_OUTPUT_SEGMENT_DIM_COMMENT   constant varchar2(30) := 'DIMENSION COMMENT';
    V_OUTPUT_SEGMENT_DIM_CREATE    constant varchar2(30) := 'DIMENSION CREATE';
    V_OUTPUT_SEGMENT_DIM_INDEX     constant varchar2(30) := 'DIMENSION INDEX';
    V_OUTPUT_SEGMENT_FACT_COMMENT  constant varchar2(30) := 'FACT COMMENT';
    V_OUTPUT_SEGMENT_FACT_CREATE   constant varchar2(30) := 'FACT CREATE';
    V_OUTPUT_SEGMENT_FACT_INDEX    constant varchar2(30) := 'FACT INDEX';
    v_Output_Segment               varchar2(30)          := null;

    V_MAX_CREATE_LENGTH            number                := 65534;

    v_dbms_sql_cursor              number                := 0;
    v_dbms_sql_return              number                := 0;

    v_Create_Clob                  clob                  := null;
    v_Index_Clob                   clob                  := null;

    V_PUT_TO_FILE                  constant varchar2(30) := 'FILE';
    V_PUT_TO_CLOB                  constant varchar2(30) := 'CLOB';
    V_Put_TO                       varchar2(30)          := null;

    v_File                         utl_file.file_type    := null;
    
    -- owb

    v_Fact_Level_Key_Column_Count  number                := null;

    type t_Column_Name_Record is record
    (v_Column_Name                 varchar2(30)          := null
    ,v_Column_Alias                varchar2(30)          := null
    ,v_Column_Alias_Attribute      varchar2(30)          := null  -- a column that is used as an attribute and a 
                                                                  -- level key will cause a 'duplicate column name' 
                                                                  -- error in the mv script if the attribute is not 
                                                                  -- give a unique alias name  
    );
    type t_Column_Name_Table is table of t_Column_Name_Record;
    v_CN                           number;
    v_CN2                          number;

  
    type t_Table_Name_Record is record
    (v_Table_Owner                 varchar2(30)          := null
    ,v_Table_Name                  varchar2(30)          := null
    ,v_Table_Alias                 varchar2(30)          := null
    ,v_CN_Table                    t_Column_Name_Table   := t_Column_Name_Table()
    );
    type t_Table_Name_Table is table of t_Table_Name_Record;
    v_TN_Table                     t_Table_Name_Table    := t_Table_Name_Table();
    v_TN                           number;
    v_TN2                          number;


    type t_Level_Name_Record is record
    (v_Dimension_ID                number                := null
    ,v_Level_Name                  varchar2(30)          := null
    ,v_Level_Partition_Range       number                := null
    );
    type t_Level_Name_Table is table of t_Level_Name_Record;
    v_LN_Table                     t_Level_Name_Table := t_Level_Name_Table();
    v_LN                           number;


    type t_Column_Record is record
    (v_Column_Name_ID              number                := null
    ,v_Column_Position             number                := null
    ,v_Column_Same_AS              number                := null  -- a column is the same as another column if
                                                                  -- 1.  same table owner
                                                                  -- 2.  same table name
                                                                  -- 2.  same column name
    );
    type t_Column_Table is table of t_Column_Record;
    v_C                           number;  -- column index


    type t_Table_Record is record
    (v_Table_Same_AS               number                := null
    ,v_Current_C                   number                := null
    ,v_C_Table                     t_Column_Table        := t_Column_Table()
    );
    type t_Table_Table is table of t_Table_Record;

    v_Fact_Table_ID                number;  -- flk, only one fact table
    v_Fact_Table_Same_AS           number;


    V_DLK                          constant number       := 1;  -- dimension level key table
    V_PLK                          constant number       := 2;  -- dimension parent level key table
    V_LA                           constant number       := 3;  -- dimension level attribute table
    V_FLK                          constant number       := 4;  -- fact level key table
    V_FM                           constant number       := 5;  -- fact measure table

    type t_Level_Record is record
    (v_Level_Posistion             number                := null
    ,v_Level_Name_ID               number                := null
    ,v_Level_Same_AS               number                := null  -- a level is the same as another level if
                                                                  -- 1.  same dimension owner
                                                                  -- 2.  same dimension name
                                                                  -- 3.  same level name
    ,v_Level_Table_ID              number                := null  -- dlk, plk, and la are in the same table
                                                                  -- flk, and fm are in the same table
    ,v_Level_Table_Same_As         number                := null  -- a table is the same as aonther if
                                                                  -- 1.  same table owner
                                                                  -- 2.  same table name
    ,v_Level_In_Grouping_Set       number                := null 
    ,v_Current_T                   number                := null
    ,v_T_Table                     t_Table_Table         := t_Table_Table()
    );

    type t_Level_Table is table of t_Level_Record;
    v_L                            number;  -- level index


    V_CURRENT_L_STATE_OK           varchar2(30)       := 'V_CURRENT_L_STATE_OK';
    V_CURRENT_L_STATE_BOTTOM       varchar2(30)       := 'V_CURRENT_L_STATE_BOTTOM';
    V_CURRENT_L_STATE_SECOND       varchar2(30)       := 'V_CURRENT_L_STATE_SECOND';
    V_CURRENT_L_STATE_TOP          varchar2(30)       := 'V_CURRENT_L_STATE_TOP';

    type t_Hierarchy_Record is record
    (v_Hierarchy_Name              varchar2(30)          := null
    ,v_Current_L                   number                := null
    ,v_Current_L_State             varchar2(30)          := null
    ,v_L_Table                     t_Level_Table         := t_Level_Table()
    );
    type t_Hierarchy_Table is table of t_Hierarchy_Record;
    v_H                            number;  -- hierarchy index

    v_Current_L                    number                := null;


    type t_Dimension_Record is record
    (v_Dimension_Owner             varchar2(30)      := null    
    ,v_Dimension_Name              varchar2(30)      := null    
    ,v_Current_H                   number            := null
    ,v_GS_Count                    number            := null
    ,v_H_Table                     t_Hierarchy_Table := t_Hierarchy_Table()
    );
    type t_Dimension_Table is table of t_Dimension_Record;
    v_D_Table                      t_Dimension_Table := t_Dimension_Table();
    v_Current_D                    number;
    v_D                            number;  -- dimension index

    v_Grouping_OK                  number            := null;
    v_Partition_Less_Than          number            := null;
    v_Partition_Less_Than_Previous number            := null;
    v_Partition_Less_Than_Shift    number            := null;

    type t_Partition_Less_Record is record
    (v_Partition_Less_Than         number            := null
    ,v_Partition_Count             number            := null
    );
    type t_Partition_Less_Table is table of t_Partition_Less_Record;
    v_Partition_Less_Table         t_Partition_Less_Table := t_Partition_Less_Table();
    v_PL                           number;  -- partition less than set index

    type t_Grouping_Set_Record is record
    (v_Grouping_Set                varchar2(1999)    := null
    ,v_Grouping_Comment            varchar2(1999)    := null
    );
    type t_Grouping_Set_Table is table of t_Grouping_Set_Record;
    v_GS_Table                     t_Grouping_Set_Table := t_Grouping_Set_Table(); -- one for each table in grouping set
    v_GS                           number;  -- grouping set index


    -- used to detect duplicate grouping set that can occure in dimensions with more than one d that have the same top l
    type t_Grouping_Set_Save_Record is record
    (v_Grouping_Set                varchar2(32767)    := null
    );
    type t_Grouping_Set_Save_Table is table of t_Grouping_Set_Save_Record;
    v_GS_Table_Save                t_Grouping_Set_Save_Table := t_Grouping_Set_Save_Table(); -- one for each table in grouping set
    v_GSS                          number;  -- grouping set save index
 

    type t_Selected_ID_Record is record
    (v_Selected_ID    number := null
    ,v_Selected_Count number := null
    );
    type t_Selected_ID_Table is table of t_Selected_ID_Record;
    v_SID_Table                    t_Selected_ID_Table := t_Selected_ID_Table(); -- one for each selected id
    v_SID                          number;  -- selected id index


    v_Owner                        varchar2(30)      := null;
    v_Contains_Wildcard            varchar2(3)       := null;
    v_Cube_Count                   number            := 0;
    v_Dimension_Count              number            := 0;
    v_Hierarchy_Count              number            := 0;

    V_CWM1_HIDDEN_HIERARCHY_NAME   constant varchar2(40) := 'NONE';
    V_CWM2_HIDDEN_HIERARCHY_NAME   constant varchar2(40) := 'CWM2_OLAP_HIERARCHY_HIDDEN';

    v_Highest_Level_In_Dimension   number             := null;
    v_Highest_Level_In_Hierarchy   number             := null;

    v_Level_Count                  number             := null;
    v_Level_Combo_ID               number             := null;
    v_Level_Combo_Selected         number             := null;

    v_Current_Dimension_Owner      varchar2(30)       := null;
    v_Current_Dimension_Name       varchar2(30)       := null;
    v_Current_Dimension_Alias      varchar2(30)       := null;
    v_Current_Hierarchy_Name       varchar2(30)       := null;
    v_Current_Hierarchy_Alias      varchar2(30)       := null;
    v_Current_Level_top            number             := null;
    v_Current_Level_Name           varchar2(30)       := null;
    v_Current_Level_Alias          varchar2(30)       := null;
    v_Current_Table_Name           varchar2(30)       := null;
    v_Current_Table_Alias          varchar2(30)       := null;

    v_Current_LK_Table_Owner       varchar2(30)       := null;
    v_Current_LK_Table_Name        varchar2(30)       := null;
    v_Current_LK_Column_Name       varchar2(30)       := null;

    v_Current_PLK_Table_Owner      varchar2(30)       := null;
    v_Current_PLK_Table_Name       varchar2(30)       := null;
    v_Current_PLK_Column_Name      varchar2(30)       := null;

    v_Current_LA_Table_Owner       varchar2(30)       := null;
    v_Current_LA_Table_Name        varchar2(30)       := null;
    v_Current_LA_Column_Name       varchar2(30)       := null;

    v_Current_FLK_Table_Owner      varchar2(30)       := null;
    v_Current_FLK_Table_Name       varchar2(30)       := null;
    v_Current_FLK_Column_Name      varchar2(30)       := null;

    v_Current_FM_Table_Owner       varchar2(30)       := null;
    v_Current_FM_Table_Name        varchar2(30)       := null;
    v_Current_FM_Column_Name       varchar2(30)       := null;

    v_Current_GS_Table_Name        varchar2(30)       := null;

    v_Materialized_View_Name       varchar2(30)       := null;
    v_Aggregation_Name             varchar2(30)       := null;
    v_Bitmap_Index_Name            varchar2(30)       := null;

    v_ID                           number             := null;
    v_Skip_Current_Combination     number             := null;
    v_Last_Dimension               number             := null;  -- do not count the measure dimension
    v_Measure_Dimension            number             := null;
    v_Start_With_Last_Dimension    number             := null;
    v_Finished                     number             := null;
    v_Incroment_Finished           number             := null;

    v_Prefix                       varchar2(100)      := null;
    v_Prefix1                      varchar2(100)      := null;
    v_Prefix2                      varchar2(100)      := null;
    v_Prefix3                      varchar2(100)      := null;
    v_Suffix                       varchar2(100)      := null;
    v_Suffix1                      varchar2(100)      := null;
    v_Suffix2                      varchar2(100)      := null;
    v_Suffix3                      varchar2(100)      := null;

    V_LINE_TYPE_BLANK              varchar2(30)       := 'BLANK';  
    V_LINE_TYPE_COMMENT            varchar2(30)       := 'COMMENT';  
    V_LINE_TYPE_UNDEFINED          varchar2(30)       := 'UNDEFINED';  -- not special  
    V_LINE_TYPE_EXECUTE_COMMAND    varchar2(30)       := 'EXECUTE COMMAND';  
    V_LINE_TYPE_END_OF_COMMAND     varchar2(30)       := 'END OF COMMAND';  
    v_Line_Type                    varchar2(30)       := null;

    v_Line                         varchar2(1999)     := null;
    v_Line_Length                  number             := null;
    v_Create_Length                number             := null;

    v_Comment                      varchar2(1999)     := null;

    v_Insert                       varchar2(1999)     := null;  


    V_PUT_CASE_NO                  constant varchar2(30) := 'NO';
    V_PUT_CASE_YES                 constant varchar2(30) := 'YES';
    v_Put_Case                     varchar2(30)          := null;

    v_Sys_Op_Base                  varchar2(32767)    := null;
    v_Sys_Op_Base_Count            number             := null;
    v_Sys_Op_Base_Max_Level        number             := null;

    v_Case                         varchar2(32767)    := null;
    v_Case_Count                   number             := null;
    v_Count                        number             := null;

    v_Start_Time                   timestamp(1)       := null;
    v_Create_End_Time              timestamp(1)       := null;
    v_Index_End_Time               timestamp(1)       := null;
    v_Elapsed_Time                 interval day to second(1);

    /* 
       the grouping set dimension level varables are used to count the position of levels in hierarchies
       to detect if a grouping set is valid for a mv type.
    */
    v_GS_D_L_Top                   number             := null;
    v_GS_D_L_Second                number             := null;
    v_GS_D_L_Bottom                number             := null;
    v_GS_D_L_One                   number             := null;

    /*
      if only one dimension in a cube generates more than one grouping set then the lowest level of that dimension
      will not be in any grouping set and the lowest level should not be in the gid or select list.  the gs count
      varables are used to detect this
    */

    v_Partition_Range_Count        number             := null;
    v_Partition_Count              number             := null;
    v_Grouping_Set_Count           number             := null;
 
    v_Column_Count                 number             := null;
    v_ET_Level_Count               number             := null;

    v_Current_Column_Name_List     varchar2(32767)    := null;
    v_Current_Column_Alias_List    varchar2(32767)    := null;
    v_Else_Column_Name_List        varchar2(32767)    := null;
    v_Else_Column_Alias_List       varchar2(32767)    := null;

    v_Use_This_Column              number             := null;


    type t_Ref_Cursor is ref cursor;  -- return SYS.OlapTabLevels%ROWTYPE;
    v_Dynamic_Cursor1              varchar2(1999)     := null;
    v_Dynamic_Cursor2              varchar2(1999)     := null;

    type t_When_Record is record
    (v_Line                        varchar2(1999)     := null
    ,v_Comment                     varchar2(1999)     := null
    );
    type t_When_Table is table of  t_When_Record;
    v_When                         t_When_Table       := t_When_Table();
    v_W                            number             := 0;  -- when

    v_Index_Count                  number             := null;

    v_Suffix_Characters            varchar2(26)       := 'abcdefghijklmnopqrstuvwxyz';
    v_Suffix_Return                varchar2(30)       := null;
    v_Suffix_Key                   number             := 0;
    v_Suffix_4                     number             := (26*26*26*26);
    v_Suffix_3                     number             := (26*26*26);
    v_Suffix_2                     number             := (26*26);
    v_Suffix_1                     number             := (26);


    -- for debugging
    v_X                            number := 0;  
    v_Xmax                         number := 1;
    v_Second_Begin                 timestamp    := null;
    v_Second_End                   timestamp    := null;
    v_Second_Elapsed               interval day to second;
    v_Second_Return                varchar2(30) := null;

function Get_Second return varchar2 is
begin
  v_Second_End := systimestamp;

  if v_Second_Begin is null
  then 
    v_Second_Begin := v_Second_End;
  end if;

  v_Second_Elapsed := v_Second_End - v_Second_Begin;

  /*
  cwm2_olap_manager.Log_Note('Get_Second'
    || ' v_Second_Begin:'   || v_Second_Begin
    || ' v_Second_End:'     || v_Second_End
    || ' v_Second_Elapsed:' || v_Second_Elapsed);
  */

  v_Second_Begin  := v_Second_End;
  V_Second_Return := v_Second_Elapsed || '  ';

  return v_Second_Return;
end Get_Second;


function Get_Suffix(p_Key number) return varchar2 is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Get_Suffix BEGIN' || ' p_Key:' || p_Key);
  end if;

  v_Suffix_Return := null;
  v_Suffix_Key    := p_Key;

  if v_Suffix_Key >= v_Suffix_4
  then
    raise cwm2_olap_exceptions.internal_error;
  end if;

  if v_Suffix_Key > v_Suffix_3
  then
    v_Suffix_Return := v_Suffix_Return || substr(v_Suffix_Characters ,floor((v_Suffix_Key / v_Suffix_3)) ,1);
    v_Suffix_Key    := mod(v_Suffix_Key ,v_Suffix_3);
  end if;

  if v_Suffix_Key > v_Suffix_2
  then
    v_Suffix_Return := v_Suffix_Return || substr(v_Suffix_Characters ,floor((v_Suffix_Key / v_Suffix_2)) ,1);
    v_Suffix_Key    := mod(v_Suffix_Key ,v_Suffix_2);
  end if;

  if v_Suffix_Key > v_Suffix_1
  then
    v_Suffix_Return := v_Suffix_Return || substr(v_Suffix_Characters ,floor((v_Suffix_Key / v_Suffix_1)) ,1);
    v_Suffix_Key    := mod(v_Suffix_Key ,v_Suffix_1);
  end if;

  v_Suffix_Return := v_Suffix_Return || substr(v_Suffix_Characters ,v_Suffix_Key ,1);

  /*
  cwm2_olap_manager.Log_Note('Get_Suffix'
      || ' v_Suffix_Key:'    || v_Suffix_Key
      || ' v_Suffix_Return:' || v_Suffix_Return);
  */
  return v_Suffix_Return;

exception
  when others 
  then
    cwm2_olap_manager.Log_Note('Get_Suffix: '|| sqlerrm);
    raise;
end Get_Suffix;


procedure Check_Name_Type_Parameter(p_Parameter_Name varchar2
                                   ,p_Parameter_Value varchar2)  is
begin
  if lengthb(p_Parameter_Value) > 30
  then
    cwm2_olap_manager.log_message('parameter_too_long'
                                  ,p_Parameter_Name 
                                  ,p_Parameter_Value
                                  );
    raise cwm2_olap_exceptions.Parameter_Not_Valid;
  end if;
end Check_Name_Type_Parameter;


procedure Test_P_Dimension(p_Dimension_Owner varchar2
                          ,p_Dimension_Name  varchar2) is
begin
  -- v_Contains_Wildcard := cwm2_olap_utility.Check_Name_Type_Parameter('p_Dimension_Owner' ,p_Dimension_Owner ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Dimension_Owner' ,p_Dimension_Owner);
  v_Dimension_Owner   := upper(p_Dimension_Owner);

  -- v_Contains_Wildcard := cwm2_olap_utility.Check_Name_Type_Parameter('p_Dimension_Name'  ,p_Dimension_Name ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Dimension_Name'  ,p_Dimension_Name);
  v_Dimension_Name    := upper(p_Dimension_Name);

  v_Command := v_Command || '''' || v_Dimension_Owner || ''', ''' || v_Dimension_Name  || '''';
  v_Procedure(v_Procedure_Dimension_Owner).v_Value := v_Dimension_Owner;
  v_Procedure(v_Procedure_Dimension_Name).v_Value  := v_Dimension_Name;

  V_Object_Owner := v_Dimension_Owner;
  V_Object_Name  := v_Dimension_Name;
end Test_P_Dimension;



procedure Test_P_Cube(p_Cube_Owner varchar2
                     ,p_Cube_Name  varchar2) is
begin
  -- v_Contains_Wildcard := cwm2_olap_utility.Check_Name_Type_Parameter('p_Cube_Owner' ,p_Cube_Owner ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Cube_Owner' ,p_Cube_Owner);
  v_Cube_Owner        := upper(p_Cube_Owner);

  -- v_Contains_Wildcard := cwm2_olap_utility.Check_Name_Type_Parameter('p_Cube_Name'  ,p_Cube_Name  ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Cube_Name'  ,p_Cube_Name);
  v_Cube_Name         := upper(p_Cube_Name);

  v_Command := v_Command || '''' || v_Cube_Owner || ''', ''' || v_Cube_Name  || '''';
  v_Procedure(v_Procedure_Cube_Owner).v_Value := v_Cube_Owner;
  v_Procedure(v_Procedure_Cube_Name).v_Value  := v_Cube_Name;

  V_Object_Owner := v_Cube_Owner;
  V_Object_Name  := v_Cube_Name;
end Test_P_Cube;



procedure Test_P_Output(p_Output_File varchar2
                       ,p_Output_Path varchar2) is
begin
  -- v_Contains_Wildcard := cwm2_olap_utility.Check_Name_Type_Parameter('p_Output_File' ,p_Output_File ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Output_File' ,p_Output_File);
  V_Output_File       := p_Output_File;

  -- v_Contains_Wildcard := cwm2_olap_utility.Check_Parameter_Max_Length('p_Output_Path' ,V_MAX_PATH_LENGTH , p_Output_Path ,'NO');
  v_Output_Path       := p_Output_Path;

  v_Command := v_Command || ', ''' || V_Output_File || ''', ''' || v_Output_Path || '''';
  v_Procedure(v_Procedure_Output_File_Path).v_Value := v_Output_Path;
  v_Procedure(v_Procedure_Output_File_Name).v_Value := v_Output_File;

end Test_P_Output;



procedure Test_P_Partitioning(p_Partitioning boolean) is
begin
  if p_Partitioning
  then
    v_Partitioning := V_PARTITION_TRUE;
    v_Command      := v_Command || ', TRUE';
    v_Procedure(v_Procedure_Partitioning).v_Value := 'TRUE';
  else
    v_Partitioning := V_PARTITION_FALSE;
    v_Command      := v_Command || ', FALSE';
    v_Procedure(v_Procedure_Partitioning).v_Value := 'FALSE';
  end if;
end Test_P_Partitioning;


procedure Test_P_Levels_Table(p_Levels_Table_Owner varchar2
                             ,p_Levels_Table_Name  varchar2) is
begin
  -- v_Contains_Wildcard  := cwm2_olap_utility.Check_Name_Type_Parameter('p_Levels_Table_Owner' ,p_Levels_Table_Owner ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Levels_Table_Owner' ,p_Levels_Table_Owner);
  v_Levels_Table_Owner := p_Levels_Table_Owner;

  -- v_Contains_Wildcard  := cwm2_olap_utility.Check_Name_Type_Parameter('p_Levels_Table_Name'  ,p_Levels_Table_Name  ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Levels_Table_Name'  ,p_Levels_Table_Name);
  v_Levels_Table_Name  := p_Levels_Table_Name;

  v_Command := v_Command || ', ''' || v_Levels_Table_Owner || ''', ''' || v_Levels_Table_Name  || '''';
  v_Procedure(v_Procedure_Levels_Table_Owner).v_Value := v_Levels_Table_Owner;
  v_Procedure(v_Procedure_Levels_Table_Name).v_Value  := v_Levels_Table_Name;
end Test_P_Levels_Table;



procedure Test_P_Tuples_Table(p_Tuples_Table_Owner varchar2
                             ,p_Tuples_Table_Name  varchar2) is
begin
  -- v_Contains_Wildcard  := cwm2_olap_utility.Check_Name_Type_Parameter('p_Tuples_Table_Owner' ,p_Tuples_Table_Owner ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Tuples_Table_Owner' ,p_Tuples_Table_Owner);
  v_Tuples_Table_Owner := p_Tuples_Table_Owner;

  -- v_Contains_Wildcard  := cwm2_olap_utility.Check_Name_Type_Parameter('p_Tuples_Table_Name'  ,p_Tuples_Table_Name  ,'NO');
  DBMS_ODM.Check_Name_Type_Parameter('p_Tuples_Table_Name'  ,p_Tuples_Table_Name);
  v_Tuples_Table_Name  := p_Tuples_Table_Name;

  v_Command := v_Command || ', ''' || v_Tuples_Table_Owner || ''', ''' || v_Tuples_Table_Name  || '''';
  v_Procedure(v_Procedure_Tuples_Table_Owner).v_Value := v_Tuples_Table_Owner;
  v_Procedure(v_Procedure_Tuples_Table_Name).v_Value  := v_Tuples_Table_Name;
end Test_P_Tuples_Table;



procedure Test_P_Tablespace(p_Tablespace_MV    varchar2
                           ,p_Tablespace_Index varchar2) is
begin
  if p_Tablespace_MV is null
  then
     v_Tablespace_MV := null;
     if p_Tablespace_Index is not null
     then
       v_Command := v_Command || ', NULL';
     end if;
  else
    -- v_Contains_Wildcard := cwm2_olap_utility.Check_Name_Type_Parameter('p_Tablespace_MV' ,p_Tablespace_MV  ,'NO');
    DBMS_ODM.Check_Name_Type_Parameter('p_Tablespace_MV' ,p_Tablespace_MV);
    v_Tablespace_MV := upper(p_Tablespace_MV);
    v_Command := v_Command || ', ''' || v_Tablespace_MV || '''';
    v_Procedure(v_Procedure_Tablespace_MV).v_Value := v_Tablespace_MV;
  end if;

  if p_Tablespace_Index is null
  then
    v_Tablespace_Index := null;
  else
    -- v_Contains_Wildcard := cwm2_olap_utility.Check_Name_Type_Parameter('p_Tablespace_Index' ,p_Tablespace_Index  ,'NO');
    DBMS_ODM.Check_Name_Type_Parameter('p_Tablespace_Index' ,p_Tablespace_Index);
    v_Tablespace_Index := upper(p_Tablespace_Index);
    v_Command := v_Command || ', ''' || v_Tablespace_Index || '''';
    v_Procedure(v_Procedure_Tablespace_Index).v_Value := v_Tablespace_Index;
  end if;
end Test_P_Tablespace;



procedure Test_P_Refresh(p_Refresh_Method varchar2
                        ,p_Refresh_On     varchar2) is
begin
  v_Refresh_Method := upper(p_Refresh_Method);
  if v_Refresh_Method =  V_REFRESH_METHOD_FORCE
  or v_Refresh_Method =  V_REFRESH_METHOD_FAST
  or v_Refresh_Method =  V_REFRESH_METHOD_COMPLETE
  then 
    v_Command := v_Command || ', ''' || v_Refresh_Method || '''';
    v_Procedure(v_Procedure_Refresh_Method).V_Value := v_Refresh_Method;
  else
    cwm2_olap_manager.Log_Message('parameter_not_valid' ,'p_Refresh_Method' ,p_Refresh_Method);
    raise cwm2_olap_exceptions.Parameter_Not_Valid;
  end if;
 
  v_Refresh_On := upper(p_Refresh_on);
  if v_Refresh_On = V_REFRESH_ON_DEMAND
  or v_Refresh_On = V_REFRESH_ON_COMMIT
  then
    v_Command := v_Command || ', ''' || v_Refresh_On || '''';
    v_Procedure(v_Procedure_Refresh_On).V_Value := v_Refresh_On;
  else
    cwm2_olap_manager.Log_Message('parameter_not_valid' ,'p_Refresh_On' ,p_Refresh_On);
    raise cwm2_olap_exceptions.Parameter_Not_Valid;
  end if;
end Test_P_Refresh;



procedure Test_P_Execute(p_Execute boolean) is
begin
  if p_Execute
  then
    v_Execute := V_EXECUTE_TRUE; 
    v_Command := v_Command || ', TRUE';
    v_Procedure(v_Procedure_Execute).v_Value := 'TRUE';

  else
    v_Execute := V_EXECUTE_FALSE;
    v_Command := v_Command || ', FALSE';
    v_Procedure(v_Procedure_Execute).v_Value := 'FALSE';
  end if;
end Test_P_Execute;



procedure Test_P_Materialization(p_Materialization_Level varchar2
                                ,p_Materialization_Pct   number) is
begin

  v_Materialization_Level := upper(p_Materialization_Level);
  if v_Materialization_Level = V_FULL
  or v_Materialization_Level = V_MINIMUM
  or v_Materialization_Level = V_PERCENT
  then
    v_Command := v_Command || ', ''' || v_Materialization_Level || '''';
    v_Procedure(v_Procedure_Materializ_Level).v_Value := v_Materialization_Level;

  else
    cwm2_olap_manager.Log_Message('parameter_not_valid' ,'p_Materialization_Level' ,p_Materialization_Level);
    raise cwm2_olap_exceptions.Parameter_Not_Valid;
  end if;

  if v_Materialization_Level = V_PERCENT
  then
    if p_Materialization_Pct is not null
    and p_Materialization_Pct >= 1    -- 1%
    and p_Materialization_Pct <= 100  -- 100%
    then 
      v_Materialization_Percent     := p_Materialization_Pct;
      v_Materialization_Percent_Mod := round(100 / p_Materialization_Pct);

      /*
      cwm2_olap_manager.Log_Note(' Test_P_Materialization'
        || ' v_Materialization_Percent_Mod:' ||  v_Materialization_Percent_Mod);
      */
      v_Command := v_Command || ', ' || p_Materialization_Pct;
      v_Procedure(v_Procedure_Materializ_Percent).v_Value := p_Materialization_Pct;

    else
      cwm2_olap_manager.Log_Message('parameter_not_valid' ,'p_Materialization_Pct' ,p_Materialization_Pct);
      raise cwm2_olap_exceptions.Parameter_Not_Valid;
    end if;  -- if p_Materialization_Pct is not null

  else
    if p_Materialization_Pct is null
    then 
      v_Materialization_Percent     := null;
      v_Materialization_Percent_Mod := null;
      v_Command := v_Command || ', null';
    else
      cwm2_olap_manager.Log_Message('parameter_not_valid' ,'p_Materialization_Pct' ,p_Materialization_Pct);
      raise cwm2_olap_exceptions.Parameter_Not_Valid;
    end if;  -- if p_Materialization_Pct is null

  end if;  -- if p_Materialization_Level = V_PERCENT

end Test_P_Materialization;



procedure Execute_Immediate(p_Insert varchar) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Execute_Immediate BEGIN p_Insrt:' || p_Insert);
  end if;

  execute immediate p_Insert;
 
end Execute_Immediate;


procedure Test_Solved_Code(p_Hierarchy_Name varchar2
                          ,p_Solved_Code    varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Test_Solved_Code BEGIN');
  end if;

  if p_Solved_Code != 'UL'
  then
    v_Status := V_STATUS_NOT_UNSOLVED;
    raise cwm2_olap_exceptions.internal_error;
  end if;
end Test_Solved_Code;



function Get_Mvseq return varchar2 is
  v_NextValue number;
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Get_Mvseq BEGIN');
  end if;

  select olapsys.dbms_mvseq.nextval into v_NextValue from dual;
  return v_NextValue;
exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Get_Mvseq: '|| sqlerrm);
    end if;
    raise;
end Get_Mvseq;



function Get_Column_Name_ID(p_Table_ID    number
                           ,p_Column_Name varchar2
                           ) return number is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Get_Column_Name_ID BEGIN');
  end if;

  for cn in 1..v_TN_Table(p_Table_ID).v_CN_Table.count
  loop
    if v_TN_Table(p_Table_ID).v_CN_Table(cn).v_Column_Name = p_Column_Name 
    then
      return cn;  -- found
    end if;
  end loop;

  return null;  -- not found

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Get_Column_Name_ID: '|| sqlerrm);
    end if;
    raise;
end Get_Column_Name_ID;



procedure Add_Column_Name(p_Table_ID       in   number
                         ,p_Column_Name    in  varchar2
                         ,p_Column_ID      out number
                         ,p_Column_SAME_AS out number) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Column_Name BEGIN');
  end if;

  p_Column_ID := Get_Column_Name_ID(p_Table_ID
                                   ,p_Column_Name);

  if p_Column_ID is not null
  then
    p_Column_Same_AS := 1;
    return;
  end if;

  v_TN_Table(p_Table_ID).v_CN_Table.extend;
  p_Column_ID := v_TN_Table(p_Table_ID).v_CN_Table.count;

  v_TN_Table(p_Table_ID).v_CN_Table(p_Column_ID).v_Column_Name            := p_Column_Name;

  v_TN_Table(p_Table_ID).v_CN_Table(p_Column_ID).v_Column_Alias           := v_TN_Table(p_Table_ID).v_Table_Alias 
                                                                          || '_'
                                                                          || DBMS_ODM.Get_Suffix(p_Column_ID); 
  v_TN_Table(p_Table_ID).v_CN_Table(p_Column_ID).v_Column_Alias_Attribute := v_TN_Table(p_Table_ID).v_Table_Alias 
                                                                          || '_'
                                                                          || DBMS_ODM.Get_Suffix(p_Column_ID)
                                                                          || '_';  -- make attribute alias unique
  p_Column_Same_AS := 0;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Column_Name: '|| sqlerrm);
    end if;
    raise;
end Add_Column_Name;



function Get_Table_Name_ID(p_Table_Owner varchar2
                          ,p_Table_Name  varchar2
                          ) return number is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Get_Table_Name_ID BEGIN');
  end if;

  for tn in 1..v_TN_Table.count
  loop
    if  v_TN_Table(tn).v_Table_Owner = p_Table_Owner 
    and v_TN_Table(tn).v_Table_Name  = p_Table_Name 
    then
      return tn;  -- found
    end if;
  end loop;

  return null;  -- not found

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Get_Table_Name_ID: '|| sqlerrm);
    end if;
    raise;
end Get_Table_Name_ID;



procedure Add_Table_Name(p_Table_Owner   in  varchar2
                        ,p_Table_Name    in  varchar2
                        ,p_Table_ID      out number
                        ,p_Table_Same_As out number) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Table_Name BEGIN');
  end if;

  p_Table_ID := Get_Table_Name_ID(p_Table_Owner
                                 ,p_Table_Name);

  if p_Table_ID is not null
  then
    p_Table_Same_As := 1;
    return;
  end if;

  v_TN_Table.extend;
  p_Table_ID := v_TN_Table.count;

  v_TN_Table(p_Table_ID).v_Table_Owner := p_Table_Owner;
  v_TN_Table(p_Table_ID).v_Table_Name  := p_Table_Name;
  v_TN_Table(p_Table_ID).v_Table_Alias := Get_Suffix(p_Table_ID);  
  v_TN_Table(p_Table_ID).v_CN_Table    := t_Column_Name_Table();

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Table_Name: '|| sqlerrm);
    end if;
    raise;
end Add_Table_Name;



function Get_Level_Name_ID(p_Dimension_ID number
                          ,p_Level_Name   varchar2
                          ) return number is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Get_Level_Name_ID BEGIN');
  end if;

  if v_LN_Table.count = 0
  then
    return null;
  end if;

  for ln in 1..v_LN_Table.count
  loop
    if  v_LN_Table(ln).v_Dimension_ID = p_Dimension_ID
    and v_LN_Table(ln).v_Level_Name   = p_Level_Name 
    then
      return ln;
    end if;
  end loop;

  return null;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Get_Level_Name_ID: '|| sqlerrm);
    end if;
    raise;
end Get_Level_Name_ID;



procedure Add_Level_Name(p_Dimension_ID  in  number
                        ,p_Level_Name    in  varchar2
                        ,p_Level_ID      out number
                        ,p_Level_Same_As out number) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Level_Name BEGIN');
  end if;

  p_Level_ID := Get_Level_Name_ID(p_Dimension_ID
                                 ,p_Level_Name);

  if p_Level_ID is not null
  then
    p_Level_Same_As := 1;
    return;
  end if;
    
  v_LN_Table.extend;
  p_Level_ID := v_LN_Table.count;

  v_LN_Table(p_Level_ID).v_Dimension_ID := p_Dimension_Id;
  v_LN_Table(p_Level_ID).v_Level_Name   := p_Level_Name;

  p_Level_Same_As := 0;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Level_Name: '|| sqlerrm);
    end if;
    raise;
end Add_Level_Name;



procedure Add_Fact_Level_Key(p_Cube_Owner      varchar2
                            ,p_Cube_Name       varchar2
                            ,p_Dimension_Owner varchar2
                            ,p_Dimension_Name  varchar2
                            ,p_Hierarchy_Name  varchar2
                            ,p_Level_Name      varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Fact_Level_Key BEGIN'
      || ' p_Cube_Owner:'      || p_Cube_Owner
      || ' p_Cube_Name:'       || p_Cube_Name 
      || ' p_Dimension_Owner:' || p_Dimension_Owner
      || ' p_Dimension_Name:'  || p_Dimension_Name
      || ' p_Hierarchy_Name:'  || p_Hierarchy_Name 
      || ' p_Level_Name:'      || p_Level_Name);
  end if;

  if p_Cube_Owner is not null
  then
    for c_Add_Fact_Level_Key in (select  distinct
                                          owner   
                                         ,cube_name           
                                         ,dimension_owner     
                                         ,dimension_name      
                                         ,dimension_alias     
                                         ,hierarchy_name      
                                         --,dim_hier_combo_id   
                                         ,level_name          
                                         ,fact_table_owner    
                                         ,fact_table_name     
                                         ,column_name         
                                         ,position     column_position       
                                         -- ,dimension_keymap_type
                                         -- ,foreign_key_name   
                                   from  olapsys.ODM$olap2ufact_level_uses
                                   where owner            = p_Cube_Owner
                                   and   cube_name        = p_Cube_Name
                                   and   dimension_owner  = p_Dimension_Owner
                                   and   dimension_name   = p_Dimension_Name
                                   and   hierarchy_name   = p_Hierarchy_Name
                                   and   level_name       = p_Level_Name
                                   order by position)
    loop
      if v_Fact_Table_ID is null
      then
        DBMS_ODM.Add_Table_Name(c_Add_Fact_Level_Key.fact_table_owner
                               ,c_Add_Fact_Level_Key.fact_table_name
                               ,v_Fact_Table_ID
                               ,v_Fact_Table_Same_As);
      end if;

      v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FLK).v_C_Table.extend;
      v_C := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FLK).v_C_Table.count;
    
      DBMS_ODM.Add_Column_Name(v_Fact_Table_ID
                              ,c_Add_Fact_Level_Key.column_name
                              ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FLK).v_C_Table(v_C).v_Column_Name_ID 
                              ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FLK).v_C_Table(v_C).v_Column_Same_As); 
      /*
      cwm2_olap_manager.Log_Note('Add_Fact_Level_Key'
        || ' v_D:'             || v_D 
        || ' v_H:'             || v_H
        || ' v_L:'             || v_L
        || ' v_FLK:'           || v_FLK
        || ' v_C:'             || v_C
        || ' level_name:'      || c_Add_Fact_Level_Key.level_name
        || ' fact_table_name:' || c_Add_Fact_Level_Key.fact_table_name
        || ' column_name:'     || c_Add_Fact_Level_Key.column_name);
      */

      v_Fact_Level_Key_Column_Count :=  v_Fact_Level_Key_Column_Count + 1;

    end loop;
  end if;  -- if p_Cube_Owner is not null

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Fact_Level_Key: '|| sqlerrm);
    end if;
    raise;
end Add_Fact_Level_Key;



procedure Add_Level_Attribute(p_Cube_Owner      varchar2
                             ,p_Cube_Name       varchar2
                             ,p_Dimension_Owner varchar2
                             ,p_Dimension_Name  varchar2
                             ,p_Hierarchy_Name  varchar2
                             ,p_Level_Name      varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Level_Attribute BEGIN');
  end if;

  /*
    attributes that are mapped to the same table.column should only be added once so that the column 
    will only be in the mv once.  the attribute name and level attribute name are not used for so doing 
    a select distinct with them commented out accomplishes this.
  */

  for c_Add_Level_Attribute in (select  distinct
                                         owner                 
                                        ,dimension_name        
                                        ,hierarchy_name        
                                        -- ,attribute_name        
                                        -- ,lvl_attribute_name    
                                        ,level_name            
                                        ,table_owner           
                                        ,table_name            
                                        ,column_name           
                                        ,dtype                 
                                        ,data_length           
                                        ,data_precision        
                                        ,olap_api_data_type    
                                from  all_olap2_dim_level_attr_maps
                                where owner          = p_Dimension_Owner
                                and   dimension_name = p_Dimension_Name
                                and   hierarchy_name = p_Hierarchy_Name
                                and   level_name     = p_Level_Name
                                order by table_name
                                        ,column_name)

  loop

    /*
    cwm2_olap_manager.Log_Note('Add_Level_Attribute'
      || ' owner:'              || c_Add_Level_Attribute.owner                 
      || ' dimension_name:'     || c_Add_Level_Attribute.dimension_name        
      || ' hierarchy_name:'     || c_Add_Level_Attribute.hierarchy_name        
      -- || ' attribute_name:'     || c_Add_Level_Attribute.attribute_name        
      -- || ' lvl_attribute_name:' || c_Add_Level_Attribute.lvl_attribute_name    
      || ' level_name:'         || c_Add_Level_Attribute.level_name            
      || ' table_owner:'        || c_Add_Level_Attribute.table_owner           
      || ' table_name:'         || c_Add_Level_Attribute.table_name            
      || ' column_name:'        || c_Add_Level_Attribute.column_name           
      || ' dtype:'              || c_Add_Level_Attribute.dtype                 
      || ' data_length:'        || c_Add_Level_Attribute.data_length           
      || ' data_precision:'     || c_Add_Level_Attribute.data_precision        
      || ' olap_api_data_type:' || c_Add_Level_Attribute.olap_api_data_type);
    */

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_LA).v_C_Table.extend;
    v_C := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_LA).v_C_Table.count;

    DBMS_ODM.Add_Column_Name(v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_Level_Table_ID
                            ,c_Add_Level_Attribute.column_name
                            ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_LA).v_C_Table(v_C).v_Column_Name_ID 
                            ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_LA).v_C_Table(v_C).v_Column_Same_As
                            );
  end loop;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Level_Attribute: '|| sqlerrm);
    end if;
    raise;
end Add_Level_Attribute;



procedure Add_Parent_Level_Key(p_Cube_Owner      varchar2
                              ,p_Cube_Name       varchar2
                              ,p_Dimension_Owner varchar2
                              ,p_Dimension_Name  varchar2
                              ,p_Hierarchy_Name  varchar2
                              ,p_Level_Name      varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Parent_Level_Key'
      || ' p_Cube_Owner:'      || p_Cube_Owner
      || ' p_Cube_Name:'       || p_Cube_Name
      || ' p_Dimension_Owner:' || p_Dimension_Owner
      || ' p_Dimension_Name:'  || p_Dimension_Name
      || ' p_Hierarchy_Name:'  || p_Hierarchy_Name
      || ' p_Level_Name:'      || p_Level_Name);
  end if;

  -- this select returns 'level is referenced by foreign key from' not 'level has foreign key to'
  for c_Add_Parent_Level_Key in (select distinct owner              
                                                ,dimension_name     
                                                ,hierarchy_name     
                                                ,child_level_name   
                                                ,table_owner        
                                                ,table_name         
                                                ,column_name        
                                                ,position     column_position      
                                                ,join_key_type      
                                   from olapsys.ODM$olap2ujoin_key_column_uses
                                  where join_key_type    = 'FOREIGN KEY'
                                    and owner            = p_Dimension_Owner
                                    and dimension_name   = p_Dimension_Name
                                    and hierarchy_name   = p_Hierarchy_Name
                                    and child_level_name = p_Level_Name
                                  order by position)

  loop
    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L - 1).v_T_Table(V_PLK).v_C_Table.extend;
    v_C := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L - 1).v_T_Table(V_PLK).v_C_Table.count;

    DBMS_ODM.Add_Column_Name(v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L - 1).v_Level_Table_ID
                            ,c_Add_Parent_Level_Key.column_name
                            ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L - 1).v_T_Table(V_PLK).v_C_Table(v_C).v_Column_Name_ID 
                            ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L - 1).v_T_Table(V_PLK).v_C_Table(v_C).v_Column_Same_As
                            );
    /*
    cwm2_olap_manager.Log_Note('Add_Parent_Level_Key'
      || ' v_D:'              || v_D 
      || ' v_H:'              || v_H
      || ' v_L:'              || v_L
      || ' v_PLK:'            || v_PLK
      || ' v_C:'              || v_C
      || ' child_level_name:' || c_Add_Parent_Level_Key.child_level_name
      || ' table_name:'       || c_Add_Parent_Level_Key.table_name
      || ' column_name:'      || c_Add_Parent_Level_Key.column_name);
    */
  end loop;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Parent_Level_Key: '|| sqlerrm);
    end if;
    raise;
end Add_Parent_Level_Key;



procedure Add_Level_Key(p_Cube_Owner      varchar2
                       ,p_Cube_Name       varchar2
                       ,p_Dimension_Owner varchar2
                       ,p_Dimension_Name  varchar2
                       ,p_Hierarchy_Name  varchar2
                       ,p_Level_Name      varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Level_Key BEGIN'
      || ' p_Cube_Owner:'      || p_Cube_Owner 
      || ' p_Cube_Name:'       || p_Cube_Name
      || ' p_Dimension_Owner:' || p_Dimension_Owner
      || ' p_Dimension_Name:'  || p_Dimension_Name
      || ' p_Hierarchy_Name:'  || p_Hierarchy_Name
      || ' p_Level_Name:'      || p_Level_Name); 
  end if;

  /* 
     the order of columns in a composit key (multi column) is user defined.  if a composit key 
     is used there is nothing in the metadata to indicate if the columns have anything to do with 
     the order of aggragation so composit keys are processed in the order they are defined.
  */ 
  for c_Add_Level_Key in (select  distinct
                                   owner            
                                  ,dimension_name   
                                  ,hierarchy_name   
                                  ,child_level_name 
                                  ,table_owner      
                                  ,table_name       
                                  ,column_name      
                                  ,position     column_position        
                            from  olapsys.ODM$olap2ulevel_key_col_uses
                            where owner            = p_Dimension_Owner
                            and   dimension_name   = p_Dimension_Name
                            and   hierarchy_name   = p_Hierarchy_Name
                            and   child_level_name = p_Level_Name
                            order by position)

  loop
    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table.extend;
    v_C := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table.count;
  
    DBMS_ODM.Add_Column_Name(v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_Level_Table_ID
                            ,c_Add_Level_Key.column_name
                            ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table(v_C).v_Column_Name_ID 
                            ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table(v_C).v_Column_Same_As);
    /*
    cwm2_olap_manager.Log_Note('Add_Level_Key c_Add_Level_Key'
      || ' v_D:'              || v_D 
      || ' v_H:'              || v_H
      || ' v_L:'              || v_L
      || ' v_DLK:'            || v_DLK
      || ' v_C:'              || v_C
      || ' child_level_name:' || c_Add_Level_Key.child_level_name
      || ' table_name:'       || c_Add_Level_Key.table_name
      || ' column_name:'      || c_Add_Level_Key.column_name
      || ' v_Column_Name_ID:' || v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table(v_C).v_Column_Name_ID 
      || ' v_Column_Same_As:' || v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table(v_C).v_Column_Same_As);
    */
  end loop;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Level_Key: '|| sqlerrm);
    end if;
    raise;
end Add_Level_Key;



procedure Init_v_L_Table is

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Init_v_L_Table BEGIN');
  end if;

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table.extend;
    v_L := v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count;

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table                  := t_Table_Table();   -- init 
    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table.extend(5);                             -- lk, plk, la, flk, fm

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table := t_Column_Table();  -- init 
    v_Current_LK_Table_Owner                                                := null;
    v_Current_LK_Column_Name                                                := null;

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_PLK).v_C_Table := t_Column_Table();  -- init 
    v_Current_PLK_Table_Owner                                               := null;
    v_Current_PLK_Column_Name                                               := null;

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_LA).v_C_Table  := t_Column_Table();  -- init 
    v_Current_LA_Table_Owner                                                := null;
    v_Current_LA_Column_Name                                                := null;

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FLK).v_C_Table := t_Column_Table();  -- init 
    v_Current_FLK_Table_Owner                                               := null;
    v_Current_FLK_Column_Name                                               := null;

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FM).v_C_Table  := t_Column_Table();  -- init 
    v_Current_FM_Table_Owner                                                := null;
    v_Current_FM_Column_Name                                                := null;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Init_v_L_Table: '|| sqlerrm);
    end if;
    raise;
end Init_v_L_Table;



procedure Add_Level(p_Cube_Owner      varchar2
                   ,p_Cube_Name       varchar2
                   ,p_Dimension_Owner varchar2
                   ,p_Dimension_Name  varchar2
                   ,p_Hierarchy_Name  varchar2
                   ,p_Level_Position  number
                   ,p_Level_Name      varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Level BEGIN');
  end if;

  for c_Add_Level in (select  distinct
                               owner            
                              ,dimension_name   
                              ,hierarchy_name   
                              ,child_level_name 
                              ,table_owner      
                              ,table_name       
                              --,column_name  too meny rows with these      
                              --,position   not set correctly for cwm1
                        from  olapsys.ODM$olap2ulevel_key_col_uses
                        where owner            = p_Dimension_Owner
                        and   dimension_name   = p_Dimension_Name
                        and   hierarchy_name   = p_Hierarchy_Name
                        and   child_level_name = p_Level_Name)
  loop
    /*
    cwm2_olap_manager.Log_Note('Add_Level '
      || ' owner:'            || c_Add_Level.owner            
      || ' dimension_name:'   || c_Add_Level.dimension_name   
      || ' hierarchy_name:'   || c_Add_Level.hierarchy_name   
      || ' child_level_name:' || c_Add_Level.child_level_name 
      || ' table_owner:'      || c_Add_Level.table_owner      
      || ' table_name:'       || c_Add_Level.table_name);
    */

    if v_Current_Level_Name is null          -- first 
    or v_Current_Level_Name != p_Level_Name  -- next 
    then

      v_Current_Level_Name := p_Level_Name;
   
      v_Highest_Level_In_Hierarchy := p_Level_Position;

      DBMS_ODM.Init_v_L_Table;
  
      v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_Level_Posistion := p_Level_Position;

      -- if there is a fact table add it first so that it will have alias 'a'
      DBMS_ODM.Add_Fact_Level_Key(p_Cube_Owner      
                                 ,p_Cube_Name       
                                 ,p_Dimension_Owner 
                                 ,p_Dimension_Name  
                                 ,p_Hierarchy_Name
                                 ,p_level_name); 

      DBMS_ODM.Add_Level_Name(v_D
                             ,c_Add_Level.child_level_name
                             ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_Level_Name_ID 
                             ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_Level_Same_As);

      DBMS_ODM.Add_Table_Name(c_Add_Level.table_owner  
                             ,c_Add_Level.table_name
                             ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_Level_Table_ID 
                             ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_Level_Table_Same_As);

      DBMS_ODM.Add_Level_Key(p_Cube_Owner      
                            ,p_Cube_Name       
                            ,p_Dimension_Owner 
                            ,p_Dimension_Name  
                            ,p_Hierarchy_Name
                            ,p_level_name); 

      DBMS_ODM.Add_Parent_Level_Key(p_Cube_Owner      
                                   ,p_Cube_Name       
                                   ,p_Dimension_Owner 
                                   ,p_Dimension_Name  
                                   ,p_Hierarchy_Name
                                   ,p_level_name); 

      DBMS_ODM.Add_Level_Attribute(p_Cube_Owner      
                                  ,p_Cube_Name       
                                  ,p_Dimension_Owner 
                                  ,p_Dimension_Name  
                                  ,p_Hierarchy_Name
                                  ,p_level_name); 

    end if;  -- if v_Current_Level_Name is null          -- first 
  end loop;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Level: '|| sqlerrm);
    end if;
    raise;
end Add_Level;



procedure Add_Hierarchy(p_Cube_Owner      varchar2 
                       ,p_Cube_Name       varchar2 
                       ,p_Dimension_Owner varchar2
                       ,p_Dimension_Name  varchar2
                       ,p_Hierarchy_Name  varchar2
                       ,p_Solved_Code     varchar2
                       ,p_Level_Position  number
                       ,p_Level_Name      varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Hierarchy BEGIN');
  end if;
    
  /*
  cwm2_olap_manager.Log_Note('Add_Hierarchy' || ' v_Current_Hierarchy_Name:' || v_Current_Hierarchy_Name);
  */

  if v_Current_Hierarchy_Name is null               -- first 
  or v_Current_Hierarchy_Name != p_Hierarchy_Name   -- next 
  then
    
    DBMS_ODM.Test_Solved_Code(p_Hierarchy_Name
                             ,p_Solved_Code);

    v_Current_Hierarchy_Name  := p_Hierarchy_Name;

    v_D_Table(v_D).v_H_Table.extend;
    v_H := v_D_Table(v_D).v_H_Table.count;

    /*
    cwm2_olap_manager.Log_Note('Add_Hierarchy p_Hierarchy_Name:' || p_Hierarchy_Name);
    */
    
    if  p_Hierarchy_Name != V_CWM1_HIDDEN_HIERARCHY_NAME 
    and p_Hierarchy_Name != V_CWM2_HIDDEN_HIERARCHY_NAME 
    then
      v_Hierarchy_Count := v_Hierarchy_Count + 1;
    end if;

    v_D_Table(v_D).v_H_Table(v_H).v_Hierarchy_Name := p_Hierarchy_Name;
    v_D_Table(v_D).v_H_Table(v_H).v_Current_L      := 1;
    v_D_Table(v_D).v_H_Table(v_H).v_L_Table        := t_Level_Table();  -- init 
    v_Current_Level_Name                           := null;

    v_Highest_Level_In_Hierarchy := 0;
  else

    v_H := v_D_Table(v_D).v_H_Table.count;
  end if;  -- if v_Current_Hierarchy_Name is null               -- first 

  DBMS_ODM.Add_Level(p_Cube_Owner      
                    ,p_Cube_Name       
                    ,p_Dimension_Owner 
                    ,p_Dimension_Name  
                    ,p_Hierarchy_Name  
                    ,p_Level_Position  
                    ,p_Level_Name);

  if v_Highest_Level_In_Dimension < v_Highest_Level_In_Hierarchy
  then
    v_Highest_Level_In_Dimension := v_Highest_Level_In_Hierarchy;
  end if;

  /*
  cwm2_olap_manager.Log_Note('Add_Hierarchy' || ' v_Highest_Level_In_Dimension;' ||  v_Highest_Level_In_Dimension);
  */

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Hierarchy: '|| sqlerrm);
    end if;
    raise;
end Add_Hierarchy;



procedure Add_Dimension(p_Cube_Owner      varchar2
                       ,p_Cube_Name       varchar2
                       ,p_Dimension_Owner varchar2
                       ,p_Dimension_Name  varchar2
                       ,p_Hierarchy_Name  varchar2
                       ,p_Solved_Code     varchar2
                       ,p_Level_Position  number
                       ,p_Level_Name      varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Dimension BEGIN'
      || ' p_Cube_Owner:'      || p_Cube_Owner
      || ' p_Cube_Name:'       || p_Cube_Name      
      || ' p_Dimension_Owner:' || p_Dimension_Owner
      || ' p_Dimension_Name:'  || p_Dimension_Name 
      || ' p_Hierarchy_Name:'  || p_Hierarchy_Name 
      || ' p_Solved_Code:'     || p_Solved_Code
      || ' p_Level_Position:'  || p_Level_Position    
      || ' p_Level_Name:'      || p_Level_Name);
  end if;

  /*
  cwm2_olap_manager.Log_Note('Add_Dimension'
    || ' v_Current_Dimension_Owner:' || v_Current_Dimension_Owner 
    || ' v_Current_Dimension_Name:'  || v_Current_Dimension_Name);
  */

  if v_Current_Dimension_Owner is null               -- first 
  or v_Current_Dimension_Owner != p_Dimension_Owner  -- next 
  or v_Current_Dimension_Name  != p_Dimension_Name   -- next 
  then

    /*
    cwm2_olap_manager.Log_Note('Add_Dimension NEXT DIMENSION');
    */

    v_Current_Dimension_Owner := p_Dimension_Owner;
    v_Current_Dimension_Name  := p_Dimension_Name;

    v_D_Table.extend;
    v_D := v_D_Table.count;
    v_Dimension_Count := v_Dimension_Count + 1;
    v_Status          := V_STATUS_OK;
    v_Last_Dimension  := v_D;    
    /*
    cwm2_olap_manager.Log_Note('Add_Dimension' || ' v_Last_Dimension:' ||  v_Last_Dimension);
    */

    v_D_Table(v_D).v_Dimension_Owner := v_Current_Dimension_Owner;
    v_D_Table(v_D).v_Dimension_Name  := v_Current_Dimension_Name;
    v_D_Table(v_D).v_Current_H       := 1;
    v_D_Table(v_D).v_H_Table         := t_Hierarchy_Table();  -- init 
    v_Current_Hierarchy_Name         := null;

  else

    v_D := v_D_Table.count;
  end if;  -- if v_Current_Dimension_Owner is null               -- first 

  /*
  cwm2_olap_manager.Log_Note('Add_Dimension' || ' v_Highest_Level_In_Dimension:' || v_Highest_Level_In_Dimension);
  */

  DBMS_ODM.Add_Hierarchy(p_Cube_Owner      
                        ,p_Cube_Name       
                        ,p_Dimension_Owner 
                        ,p_Dimension_Name  
                        ,p_Hierarchy_Name   
                        ,p_Solved_Code 
                        ,p_Level_Position   
                        ,p_Level_Name); 

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Dimension: '|| sqlerrm);
    end if;
    raise;
end Add_Dimension;



procedure Add_Measure is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Measure BEGIN');
  end if;

  -- setup psudo measure dimension 
  v_D_Table.extend;
  v_D := v_D_Table.count;

  v_Measure_Dimension := v_D;

  v_D_Table(v_D).v_H_Table := t_Hierarchy_Table();  -- init 

  -- setup psudo measure hierarchy 
  v_D_Table(v_D).v_H_Table.extend;
  v_H := v_D_Table(v_D).v_H_Table.count;

  v_D_Table(v_D).v_H_Table(v_H).v_L_Table         := t_Level_Table();  -- init 

  -- setup psudo measure level
  DBMS_ODM.Init_v_L_Table;

  -- measure dimension does not have lk, plk, or la

  for c_cube_measure_maps in (select  distinct
                                      owner
                                     ,cube_name
                                     ,measure_name    
                                     --,dim_hier_combo_id do not include, may get too meny rows
                                     ,fact_table_owner
                                     ,fact_table_name
                                     ,column_name
                                from  all_olap2_cube_measure_maps
                                where owner     = v_Cube_Owner
                                and   cube_name = v_Cube_Name
                                order by measure_name)
  loop

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note('c_Cube_Measure_Maps;'
        || ' ' || 'measure_name,fact_table_owner,fact_table_name,column_name:'
        || ' ' || c_Cube_Measure_Maps.measure_name
        || ' ' || c_Cube_Measure_Maps.Fact_Table_Owner
        || ' ' || c_Cube_Measure_Maps.Fact_Table_Name
        || ' ' || c_Cube_Measure_Maps.Column_Name);
    end if;

    v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FM).v_C_Table.extend;
    v_C := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FM).v_C_Table.count;

    DBMS_ODM.Add_Column_Name(v_Fact_Table_ID
                            ,c_Cube_Measure_Maps.column_name
                            ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FM).v_C_Table(v_C).v_Column_Name_ID
                            ,v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_FM).v_C_Table(v_C).v_Column_Same_AS);
    /*
    cwm2_olap_manager.Log_Note('c_Cube_Measure_Maps'
      || ' v_Fact_Table_ID:' || v_Fact_Table_ID
      || ' Column_Name:'     || c_Cube_Measure_Maps.Column_Name
      || ' v_D:'             || v_D
      || ' v_H:'             || v_H
      || ' v_L:'             || v_L
      || ' v_FM:'            || v_FM
      || ' v_C:'             || v_C);
    */
  end loop;  -- for c_Cube_Measure_Maps in (select  *

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Measure: '|| sqlerrm);
    end if;
    raise;
end Add_Measure;



procedure Get_Aggregation_Name is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Get_Aggregation_Name BEGIN');
  end if;

  v_Aggregation_Name := 'SUM';  -- set default
  for c_Get_Aggregation_Name in(select  distinct (case when aggregation_name = 'SCALED SUM' then 'SUM'
                                                       else aggregation_name 
                                                       end
                                                 ) aggregation_name
                                  from  ALL_OLAP2_AGGREGATION_USES
                                  where owner     = v_Cube_Owner
                                  and   cube_name = v_Cube_Name)
  loop

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note('c_Get_Aggregation_Name:' || c_Get_Aggregation_Name.aggregation_name);
    end if;

    v_Aggregation_Name := c_Get_Aggregation_Name.aggregation_name;  -- update default
  end loop;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Get_Aggregation_Name: '|| sqlerrm);
    end if;
    raise;
end Get_Aggregation_Name;



procedure Set_Partition_Range is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Set_Partition_Range BEGIN');
  end if;

  v_Partition_Range_Count := 0;

  for d in reverse 1..v_Last_Dimension
  loop

    for h in 1..v_D_Table(d).v_H_Table.count
    loop

      for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
      loop

        v_LN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Name_ID;
 
        -- if same as = 1 the partition range will already been set
        if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Same_As = 0
        then
          v_LN_Table(v_LN).v_Level_Partition_Range := power(2 ,v_Partition_Range_Count);
          v_Partition_Range_Count := v_Partition_Range_Count + 1;
        end if;
  
        /* 
        cwm2_olap_manager.Log_Note('Set_Partition_Range'
          || ' v_Level_Name:'            || v_LN_Table(v_LN).v_Level_Name
          || ' v_Level_Partition_Range:' || v_LN_Table(v_LN).v_Level_Partition_Range);
        */

      end loop;  -- for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.coun
    end loop;  -- for h in 1..v_D_Table(d).v_H_Table.count
  end loop;  -- for d reverse in 1..v_Last_Dimension

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Set_Partition_Range: '|| sqlerrm);
    end if;
    raise;
end Set_Partition_Range;

    

procedure Set_Segment(p_Segment varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Set_Segment BEGIN p_Segment:' || p_Segment);
  end if;

  -- segment identifies the part of the script that is being generated.  
    
  v_Output_Segment := p_Segment;  -- set type
  
  if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_COMMENT
  or v_Output_Segment = V_OUTPUT_SEGMENT_FACT_COMMENT
  then
    v_Varchar2s.delete;
    v_V := 0;
  end if;  --  if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_COMMENT

  if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_CREATE
  or v_Output_Segment = V_OUTPUT_SEGMENT_FACT_CREATE
  then
    v_Varchar2s.delete;
    v_V := 0;
  end if;  --  if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_CREATE

  if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_INDEX
  or v_Output_Segment = V_OUTPUT_SEGMENT_FACT_INDEX
  then
    v_Varchar2s.delete;
    v_V := 0;
  end if;  --  if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_INDEX
end Set_Segment;



procedure Execute_Line(p_Recursive boolean) is
  V_MAX_VARCHAR2S_LENGTH number := 256; 
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Execute_Line BEGIN'
--      || ' p_Recursive:'           || p_Recursive
      || ' v_V:'                   || v_V 
      || ' v_Line_Length:'         || v_Line_Length
      || ' v_Varchar2s_Remaining:' || v_Varchar2s_Remaining); 
  end if;

  if v_V = 0
  then 
    v_V                   := 1;
    v_Varchar2s_Remaining := V_MAX_VARCHAR2S_LENGTH;
    v_Varchar2s(v_V)      := null;  --init
  end if;

  if v_Line_Length <= v_Varchar2s_Remaining 
  then
    /*
    cwm2_olap_manager.Log_Note('Execute_Line <='); 
    */
    v_Varchar2s(v_V)      := v_Varchar2s(v_V) || v_line;
    v_Varchar2s_Remaining := v_Varchar2s_Remaining - v_Line_Length;
  else
    /*
    cwm2_olap_manager.Log_Note('Execute_Line NOT <='); 
    */
    v_Varchar2s(v_V)      := v_Varchar2s(v_V) || substr(v_line ,1 ,v_Varchar2s_Remaining);
    v_Line                := substr(v_line ,v_Varchar2s_Remaining + 1);
    v_Line_Length         := v_Line_Length - v_Varchar2s_Remaining;
    v_V                   := v_V + 1;
    v_Varchar2s_Remaining := V_MAX_VARCHAR2S_LENGTH;
    v_Varchar2s(v_V)      := null;  --init
    DBMS_ODM.Execute_Line(V_YES);
  end if;  -- if v_Line_Length < v_Varchar2s_Remaining
  

  if p_Recursive = V_YES
  then 
    /*
    cwm2_olap_manager.Log_Note('Execute_Line RETURN'); 
    */
    return;
  end if;

  -- execute if end of command or execute command and status ok
  if  (   v_Line_Type = V_LINE_TYPE_END_OF_COMMAND
       or v_Line_Type = V_LINE_TYPE_EXECUTE_COMMAND)
  and v_Status = V_STATUS_OK
  then

    /*
    for i in v_Varchar2s.first.. v_Varchar2s.last
    loop
      cwm2_olap_manager.Log_Note('Execute_Line'
        || ' v_Varchar2s(' || i || '):' || v_Varchar2s(i));
    end loop;
    */

    begin
      v_Cursor := dbms_sql.open_cursor;
      dbms_sql.parse(v_Cursor 
                    ,v_Varchar2s
                    ,v_Varchar2s.first
                    ,v_Varchar2s.last
                    ,false
                    ,dbms_sql.native);
      v_Result := dbms_sql.execute(v_Cursor);
      dbms_sql.close_cursor(v_Cursor);

      v_Varchar2s.delete;
      v_V := 0;

    exception
      when others
      then
        cwm2_olap_manager.Log_Note('Execute_Line.parse: '|| sqlerrm);
        raise;
    end;
  end if;  -- if v_Line_Type = V_LINE_TYPE_END_OF_COMMAND
exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Execute_Line: '|| sqlerrm);
    end if;
    raise;
end Execute_Line;



procedure Close_Clob is
v_DBMS_SQL_Cursor integer;
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Close_Clob BEGIN' 
      || ' v_Run_ID:'       || v_Run_ID
      || ' v_Object_Name:'  || v_Object_Name
      || ' v_Object_Owner:' || v_Object_Owner
      || ' v_Create_Clob:'  || v_Create_Clob
      || ' v_Index_Clob:'   || v_Index_Clob);
  end if;

  if v_Put_To = V_PUT_TO_CLOB
  then
 
    insert into system.MVIEW$_ADV_OWB
      (RUNID#
      ,OBJNAME
      ,OWNERNAME
      ,MVSCRIPT
      ,INDEXSCRIPT) 
      VALUES
      ( v_Run_ID
      ,v_Object_Name
      ,v_Object_Owner
      ,v_Create_Clob
      ,v_Index_Clob);
  
      commit;

      /*
      for c in (select * from system.MVIEW$_ADV_OWB)
      loop
        cwm2_olap_manager.Log_Note('Close_Clob' 
          || ' c.RUNID#:'      || c.RUNID#
          || ' c.OBJNAME:'     || c.OBJNAME
          || ' c.OWNERNAME:'   || c.OWNERNAME
          || ' c.MVSCRIPT:'    || c.MVSCRIPT
          || ' c.INDEXSCRIPT:' || c.INDEXSCRIPT);
      end loop;
      */

      v_Create_Clob  := null;
      v_Index_Clob   := null;
    end if;  -- if v_Put_To  = V_PUT_TO_CLOB

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Close_Clob: '|| sqlerrm);
    end if;
    raise;
end Close_Clob;



procedure Put_Line_To_Clob is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Line_To_Clob BEGIN'); 
  end if;

  if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_COMMENT
  or v_Output_Segment = V_OUTPUT_SEGMENT_FACT_COMMENT
  or v_Output_Segment = V_OUTPUT_SEGMENT_DIM_CREATE
  or v_Output_Segment = V_OUTPUT_SEGMENT_FACT_CREATE
  then
    v_Create_Clob := v_Create_Clob || v_line;
  else
    v_Index_Clob  := v_Index_Clob || v_line;
  end if;
end Put_Line_To_Clob;



procedure Close_File is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Close_File BEGIN'); 
  end if;

  if utl_file.is_open(v_File)
  then
    utl_file.fclose(v_File);
  end if;
end Close_File;



procedure Open_File is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Open_File BEGIN' || ' v_Output_Path:' || v_Output_Path || ' v_Output_File:' || v_Output_File);
  end if;

  DBMS_ODM.Close_File;
  v_File := utl_file.fopen(v_Output_Path ,v_Output_File ,'w' ,32767); 
end Open_File;



procedure Put_File(p_Line varchar2) is
begin
  if v_Debug = V_YES or v_Debug_Overide = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_File BEGIN' || ' p_Line:' || p_Line); 
  end if;

  utl_file.put_line(v_File ,p_Line);
end Put_File;


procedure Put_Line_To_File is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Line_To_File BEGIN' || ' v_Line_Type:' || v_Line_Type || ' v_Line:' || v_Line); 
  end if;

  -- process line type, execute command need 'EXECUTE ' and ending ';', commands need ending ';', others need ' '
  if    v_Line_Type = V_LINE_TYPE_EXECUTE_COMMAND
  then
    DBMS_ODM.Put_File('EXECUTE ' || v_Line || ';');

  elsif v_Line_Type = V_LINE_TYPE_END_OF_COMMAND
  then
    DBMS_ODM.Put_File(v_Line || ';');

  else
    DBMS_ODM.Put_File(v_line || ' ');
  end if;
end Put_Line_To_File;




procedure Put_Line is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Line BEGIN' 
      || ' v_Output_Segment:'  || v_Output_Segment
      || ' v_Line:'            || v_Line 
      || ' v_Line_Type:'       || v_Line_Type 
      || ' v_Comment:'         || v_Comment);
  end if;

  if v_Line is not null
  then

    if v_Indented = V_NO
    then
      -- remove lead and trailing spaces
      v_Line := ltrim(v_Line , ' ');
      v_Line := rtrim(v_Line , ' ');
    end if;

    if  v_Comment is not null
    and v_Add_Comment = V_YES
    then 
      v_Line := v_Line || '  /*  ' || v_Comment || '  */';
    end if;

    if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_COMMENT
    or v_Output_Segment = V_OUTPUT_SEGMENT_FACT_COMMENT
    then

      if v_Put_To = V_PUT_TO_FILE
      then
        DBMS_ODM.Put_Line_TO_File;
      end if;  

      if v_Put_To = V_PUT_TO_CLOB
      then
        DBMS_ODM.Put_Line_TO_Clob;
      end if;

    else

      if v_Put_To = V_PUT_TO_FILE
      then
        DBMS_ODM.Put_Line_To_File;
      end if; 

      if v_Line_Type != V_LINE_TYPE_BLANK  -- blank line are not add to the clob or executed
      then
 
        -- process line type, execute command need to plsql block, other need ' ', commands must not have ending ';'
        if v_Line_Type = V_LINE_TYPE_EXECUTE_COMMAND
        then
          v_Line := 'BEGIN ' || v_line || '; END;';
        else
          v_Line := v_line || ' ';
        end if;

        v_Line_Length := length(v_Line);

        if v_Output_Segment =  V_OUTPUT_SEGMENT_DIM_CREATE
        or v_Output_Segment =  V_OUTPUT_SEGMENT_FACT_CREATE
        then
          v_Create_Length := v_Create_Length + v_Line_Length;

          /*
          cwm2_olap_manager.Log_Note('Put_Line' 
            || ' v_Line:'          || v_Line 
            || ' length(v_Line):'  || length(v_Line)
            || ' v_Create_Length:' || v_Create_Length
                                     );
          */

          /*
          if  v_Create_Length > V_MAX_CREATE_LENGTH
          and v_Status = V_STATUS_OK
          then
            v_Status := V_STATUS_TOO_LARGE;
            raise cwm2_olap_exceptions.internal_error;
          end if; 
          */

        end if;  -- if v_Output_Segment =  V_OUTPUT_SEGMENT_DIM_CREATE

        if v_Put_To = V_PUT_TO_CLOB
        then
          DBMS_ODM.Put_Line_TO_Clob;
        end if;

        if v_Execute = V_EXECUTE_TRUE
        then
          DBMS_ODM.Execute_Line(V_NO);
        end if;

      end if;  -- if v_Line_Type != V_LINE_TYPE_BLANK 
    end if;  -- if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_COMMENT
  end if;  -- if v_Line is not null

  -- clear line and comment
  v_Line      := null;
  v_Line_Type := V_LINE_TYPE_UNDEFINED;
  v_Comment   := null;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Line:'|| sqlerrm);
    end if;
    raise;
end Put_Line;



procedure Put_Line(p_Line varchar2) is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Line(p_Line) BEGIN p_Line:' || p_Line); 
  end if;

  v_Line    := p_Line;
  v_Comment :=  null;
  DBMS_ODM.Put_Line;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Line(p_Line): ' || sqlerrm);
    end if;
    raise;
end Put_Line;



procedure Put_2_Blank_Line is
begin
  v_Line_Type := V_LINE_TYPE_BLANK;
  DBMS_ODM.Put_Line(' ');

  v_Line_Type := V_LINE_TYPE_BLANK;
  DBMS_ODM.Put_Line(' ');
end Put_2_Blank_Line;



procedure Put_Copyright is

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Copyright BEGIN');
  end if;

  if  v_Add_Comment = V_YES then
    v_Line_Type := V_LINE_TYPE_COMMENT;
    DBMS_ODM.Put_Line('-- * * * DEVELOPMENT VERSION * * * DEVELOPMENT VERSION * * * ');  
  end if;

  v_Line_Type := V_LINE_TYPE_COMMENT;
  DBMS_ODM.Put_Line('-- Copyright Oracle Corp ' || V_VERSION_YEAR );

  v_Line_Type := V_LINE_TYPE_COMMENT;
  DBMS_ODM.Put_Line('-- OLAP Materialized View Version ' || V_VERSION || ' dated ' || V_VERSION_DATE);

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Copyright: '|| sqlerrm);
    end if;
    raise;
end Put_Copyright;



procedure Put_Time is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Time BEGIN'
      || ' v_Start_Time:'      || v_Start_Time
      || ' v_Create_End_Time:' || v_Create_End_Time
      || ' v_Index_End_Time:'  || v_Index_End_Time);
  end if;

  if v_Start_Time is null
  then

    v_Start_Time   := systimestamp;
 
    if v_Add_Comment = V_YES
    then
      v_Line_Type := V_LINE_TYPE_COMMENT;
      DBMS_ODM.Put_Line('-- ' || v_Command || ')' );
    end if;

    v_Line_Type := V_LINE_TYPE_COMMENT;
    DBMS_ODM.Put_Line('-- Created ' || v_Start_Time);

    for i in 1..v_Procedure.count
    loop

      if v_Procedure(i).v_Value is not null
      or v_Add_Comment = V_YES
      then
        v_Line_Type := V_LINE_TYPE_COMMENT;
        DBMS_ODM.Put_Line('-- ' || v_Procedure(i).v_Label || ': ' || v_Procedure(i).v_Value);
      end if;
    end loop;

  elsif v_Create_End_Time is null
  then
    v_Create_End_Time := systimestamp;
    v_Elapsed_Time    := v_Create_End_Time - v_Start_Time;

    v_Line_Type := V_LINE_TYPE_COMMENT;
    DBMS_ODM.Put_Line('-- ' || v_Create_End_Time 
                            || '  MV time: ' || substr(v_Elapsed_Time ,5) 
                            || '  MV script size: ' || v_Create_Length);
  else
    v_Index_End_Time := systimestamp;
    v_Elapsed_Time   := v_Index_End_Time - v_Create_End_Time;

    v_Line_Type := V_LINE_TYPE_COMMENT;
    DBMS_ODM.Put_Line('-- ' || v_Index_End_Time 
                            || '  MV Indexs time: ' || substr(v_Elapsed_Time ,5));


    DBMS_ODM.Put_2_Blank_Line;
  end if;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Time: '|| sqlerrm);
    end if;
    raise;
end Put_Time;



procedure Put_Create_MV is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Create_MV BEGIN');
  end if;

  v_Create_Length := 0;

  v_Owner := cwm2_olap_utility.Get_User_Name;

  DBMS_ODM.Put_Line('CREATE MATERIALIZED VIEW ' || v_Owner || '.' || v_Materialized_View_Name);

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Create_MV: '|| sqlerrm);
    end if;
    raise;
end Put_Create_MV;



procedure Grouping_Compute is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Grouping_Compute BEGIN');
  end if;

  -- compute partition less than
  v_Partition_Less_Than := 0;

  for d in 1..v_Last_Dimension  -- all d except measure dimension
  loop 

    for h in 1..v_D_Table(d).v_Current_H
    loop

      /*
      cwm2_olap_manager.Log_Note('Grouping_Compute' 
        || ' d:' || d || ' h:' || h || ' v_Current_L:' || v_D_Table(d).v_H_Table(h).v_Current_L);
      */

      if h = v_D_Table(d).v_Current_H
      then

        if v_MV_Type = V_MV_TYPE_FACT
        then
          v_Current_Level_Top := v_D_Table(d).v_H_Table(h).v_Current_L - 1;
        else
          v_Current_Level_Top := v_D_Table(d).v_H_Table(h).v_Current_L;
        end if;

      else
        v_Current_Level_Top := v_D_Table(d).v_H_Table(h).v_L_Table.count;
      end if;  -- if h = v_D_Table(d).v_Current_H

      for l in 1..v_Current_Level_Top
      loop  

        /*
        cwm2_olap_manager.Log_Note('Grouping_Compute'
          || ' v_Partition_Count:' || v_Partition_Count
          || ' d:' || d || ' h:' || h || ' l:' || l 
          || ' v_Level_Same_As:' || v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Same_As); 
        */

        -- all of the hierarchies are processed when generating a fact mv.  a level (not counting the lowest level) may be 
        -- in more than one hierarchy of a dimension.  this will produce a duplicate grouping set.

        if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Same_As = 0
        then
          v_LN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Name_ID;
          v_Partition_Less_Than := v_Partition_Less_Than + v_LN_Table(v_LN).v_Level_Partition_Range;

          /*
          cwm2_olap_manager.Log_Note('Grouping_Compute'
            || ' d:' || d || ' h:' || h || ' l:' || l
            || ' v_Level_Partition_Range:' || v_LN_Table(v_LN).v_Level_Partition_Range
            || ' v_Partition_Less_Than:'   || v_Partition_Less_Than);
          */
        end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Same_As = 0
      end loop;  -- for l in 1..v_Current_Level_Top
    end loop;  -- for h in 1..v_D_Table(d).v_Current_H
  end loop;  -- for d in 1..v_Last_Dimension  -- all d except measure dimension 


  v_Partition_Count           := v_Partition_Count + 1;
  v_Partition_Less_Than_Shift := 0;

  if v_Partition_Less_Than_Previous is null
  then
    v_Partition_Less_Than_Shift    := 0;
    v_Partition_Less_Than_Previous := v_Partition_Less_Than;
  else

    if v_Partition_Less_Than_Previous > v_Partition_Less_Than
    then
      v_Partition_Less_Than_Shift := 1;
    else
      v_Partition_Less_Than_Previous := v_Partition_Less_Than;  -- save new less than
    end if;  -- if v_Partition_Less_Than_Previous > v_Partition_Less_Than
  end if;  -- if v_Partition_Less_Than_Previous is not null

  /*
  cwm2_olap_manager.Log_Note('Grouping_Compute'
    || ' v_Grouping_OK:'                  || v_Grouping_OK
    || ' v_Partition_Less_Than_Previous:' || v_Partition_Less_Than_Previous
    || ' v_Partition_Less_Than:'          || v_Partition_Less_Than 
    || ' v_Partition_Less_Than_Shift:'    || v_Partition_Less_Than_Shift
    || ' v_Partition_Count:'              || v_Partition_Count
    --|| ' v_Hierarchy_Count:'              || v_Hierarchy_Count
    --|| ' v_Highest_Level_In_Dimension:'   || v_Highest_Level_In_Dimension
    );
  */

  if  v_Grouping_OK = 1
  and v_MV_Step     = V_MV_STEP_PUT_PARTITION_BY_RNG
  then
    for d in 1..v_Last_Dimension  -- all d except measure dimension
    loop 
      v_H := v_D_Table(d).v_Current_H;
      v_L := v_D_Table(d).v_H_Table(v_H).v_Current_L;
      v_D_Table(d).v_H_Table(v_H).v_L_Table(v_L).v_Level_In_Grouping_Set := 1;
    end loop;
  end if;  -- if  v_Grouping_OK  = 1

  -- a cell is defined by one level from each of the dimensions.   its group by grouping set is composed of that level an all 
  -- of its parent levels.  ie. given time_dimension of month, quarter, year and customer_dimension of city, state, region, the 
  -- cell for quarter and state would have a group by grouping set of quarter, year, state, region.

  if  v_Grouping_OK = 1
  and v_MV_Step     = V_MV_STEP_PUT_GROUP_BY_GS
  then
    -- generate grouping set
    v_GS_Table.delete;       -- used for current formated grouping set

    v_GS_Table_Save.extend;  -- used to detect duplicate grouping sets
    v_GSS:= v_GS_Table_Save.count;       

    v_Grouping_Set_Count := v_Grouping_Set_Count + 1;

    for d in 1..v_Last_Dimension  -- all d except measure dimension
    loop 
      v_Current_GS_Table_Name := null;
      v_H := v_D_Table(d).v_Current_H;
      /*
      cwm2_olap_manager.Log_Note('Grouping_Compute'
        || ' d:' || d || ' v_H:' || v_H || ' v_Current_L:' || v_D_Table(d).v_H_Table(v_H).v_Current_L
        || ' count:' || v_D_Table(d).v_H_Table(v_H).v_L_Table.count);
      */

      for l in v_D_Table(d).v_H_Table(v_H).v_Current_L..v_D_Table(d).v_H_Table(v_H).v_L_Table.count  -- current to count
      loop 

        /*
        cwm2_olap_manager.Log_Note('Grouping_Compute'
          || ' d:' || d || ' v_H:' || v_H || ' l:' || l
          || ' v_Grouping_Set_Count:' || v_Grouping_Set_Count
          || ' v_Level_Same_As:'      || v_D_Table(d).v_H_Table(v_H).v_L_Table(l).v_Level_Same_As);
        */

          for c in 1..v_D_Table(d).v_H_Table(v_H).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count  -- all c in t
          loop 

            if v_Current_GS_Table_Name is null                                                    -- first
            or v_Current_GS_Table_Name != 
              v_TN_Table(v_D_Table(d).v_H_Table(v_H).v_L_Table(l).v_Level_Table_ID).v_Table_Name  -- next
            then 
              v_Current_GS_Table_Name := 
                v_TN_Table(v_D_Table(d).v_H_Table(v_H).v_L_Table(l).v_Level_Table_ID).v_Table_Name ;
               /*
               cwm2_olap_manager.Log_Note('Grouping_Compute v_Current_GS_Table_Name:'||v_Current_GS_Table_Name);
               */

              v_GS_Table.extend;
              v_GS := v_GS_Table.count;       

              
              -- add grouping comment
              if v_Add_Comment = V_YES
              then
                v_GS_Table(v_GS).v_Grouping_Comment := ' Less Than:' || v_Partition_Less_Than 
                                                    || ' Set Count:' || v_Grouping_Set_Count 
                                                    || ' D:'         || d 
                                                    || ' H:'         || v_H
                                                    || ' L:'         || l;
              end if; 

            end if;  -- if v_Current_GS_Table_Name is null

            v_TN := v_D_Table(d).v_H_Table(v_H).v_L_Table(l).v_Level_Table_ID;
            v_CN := v_D_Table(d).v_H_Table(v_H).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;

            /*
            cwm2_olap_manager.Log_Note('Grouping_Compute'
              || ' v_GS:'  || v_GS
              || ' v_TN:'  || v_TN
              || ' v_CN:'  || v_CN);
           */

            -- add column to grouping set
            v_GS_Table(v_GS).v_Grouping_Set := v_GS_Table(v_GS).v_Grouping_Set 
                                            || v_TN_Table(v_TN).v_Table_Alias
                                            || '.'
                                            || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                                            || v_Suffix;

             -- save for duplicate test
            /*
            cwm2_olap_manager.Log_Note('Grouping_Compute'
              || ' v_GSS:' || v_GSS);
           */
             v_GS_Table_Save(v_GSS).v_Grouping_Set := v_GS_Table_Save(v_GSS).v_Grouping_Set || v_GS_Table(v_GS).v_Grouping_Set; 

          end loop;  -- for c in 1..v_D_Table(d).v_H_Table(v_H).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count  -- all c in t

          /*
          cwm2_olap_manager.Log_Note('Grouping_Compute'
            || ' v_Grouping_Set_Count:'     || v_Grouping_Set_Count
            || ' v_GS:'                     || v_GS
            || ' v_Grouping_Set:'           || v_GS_Table(v_GS).v_Grouping_Set);
         */
      end loop;  -- for l in 1..v_D_Table(d).v_H_TABLE(v_H).v_Current_L  -- all l in h
    end loop;  -- for d in 1..v_Last_Dimension  -- all d except measure dimension

    /*
    cwm2_olap_manager.Log_Note('Grouping_Compute'
      || ' v_Grouping_Set_Count:' || v_Grouping_Set_Count
      || ' v_GSS:'                || v_GSS
      || ' v_Grouping_Set:'       || v_GS_Table_Save(v_GSS).v_Grouping_Set);
    */

    -- test for duplicate grouping set
    if v_Grouping_OK = 1
    then
      for gss in 1..(v_GSS - 1)
      loop
        if v_GS_Table_Save(gss).v_Grouping_Set = v_GS_Table_Save(v_GSS).v_Grouping_Set
        then 
          v_Grouping_OK := 0;
          /*
          cwm2_olap_manager.Log_Note('Grouping_Compute DUPLICATE');
          */
          exit;
        end if;
      end loop;
    end if;  -- if v_Grouping_OK := 1
  end if;  -- if  v_Grouping_OK = 1

    /*
    cwm2_olap_manager.Log_Note('Grouping_Compute'
      || ' v_Grouping_OK:'                  || v_Grouping_OK
      || ' v_Partition_Less_Than_Previous:' || v_Partition_Less_Than_Previous 
      || ' v_Partition_Less_Than:'          || v_Partition_Less_Than);
    */

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Grouping_Compute: '|| sqlerrm);
    end if;
    raise;
end Grouping_Compute;


procedure Set_GS_D_L is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Set_GS_D_L BEGIN');
  end if;

  /* for materialization level full:
     need to know when all level 1 (all bottom)

     for materialization level minimum:
     a level can be both a bottom level (1) and a top level if there is only one level in a hierarchy.  
     getting the correct grouping sets requires processing this type of level twice.  once as a bottom 
     level and once as a top level.

     a level can be both a second level (2) and a top level if there are only two levels in a hierarchy.  
     getting the correct grouping sets requires processing this type of level twice.  once as a second 
     level and once as a top level.

     when processing a level twice level 1 is always bottom level even when it is processed as a top.    
  */  

  -- set grouping set dimension level count
  v_GS_D_L_Top    := 0;
  v_GS_D_L_Second := 0;
  v_GS_D_L_Bottom := 0;
  v_GS_D_L_One    := 0;

  for d in 1..v_Last_Dimension  
  loop 

    v_H := v_D_Table(d).v_Current_H;

    if v_D_Table(d).v_H_Table(v_H).v_Current_L = 1
    then
      v_GS_D_L_One := v_GS_D_L_One + 1;
    end if;

    if v_Materialization_Level = V_MINIMUM
    then

      if v_D_Table(d).v_H_Table(v_H).v_Current_L_State = V_CURRENT_L_STATE_BOTTOM
      then
        v_GS_D_L_Bottom := v_GS_D_L_Bottom + 1;     -- one more bottom

      elsif v_D_Table(d).v_H_Table(v_H).v_Current_L_State = V_CURRENT_L_STATE_SECOND
         then
           v_GS_D_L_Second := v_GS_D_L_Second + 1;  -- one more second
      end if;
    end if;

    if v_Materialization_Level = V_MINIMUM
    or v_Materialization_Level = V_PERCENT
    then
      if v_D_Table(d).v_H_Table(v_H).v_Current_L_State = V_CURRENT_L_STATE_TOP
      then
        v_GS_D_L_Top := v_GS_D_L_Top + 1;           -- one more top
      end if;
    end if;  
  end loop;

  /*
  cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Set_GS_D_L END'
    || ' TOP:'     || v_GS_D_L_Top
    || ' SECOND:'  || v_GS_D_L_Second
    || ' BOTTOM:'  || v_GS_D_L_Bottom
    || ' ONE:'     || v_GS_D_L_One);
  */
exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Set_GS_D_L: '|| sqlerrm);
    end if;
    raise;
End Set_GS_D_L;


procedure Grouping_Test is
  -- is this grouping ok given the type of mv being generated
    c_Grouping_Test1           t_Ref_Cursor;
    c_Grouping_Test2           t_Ref_Cursor;

    l_ID                       number := null;
    l_Dimension_Owner          varchar2(30);
    l_Dimension_Name           varchar2(30);
    l_Level_Name               varchar2(30);

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Grouping_Test BEGIN:'
      || ' v_Materialization_Level:' || v_Materialization_Level);
  end if;

  DBMS_ODM.Set_GS_D_L;

  -- do not include all lowest levels (1) in fact mv except in put grouping id step
  if  v_GS_D_L_One = v_Last_Dimension  -- all level 1
  and v_MV_Type    = V_MV_TYPE_FACT
  and v_MV_Step    != V_MV_STEP_PUT_GROUPING_ID
  then
    /*
    cwm2_olap_manager.Log_Note('Grouping_Test ALL BOTTOM' || ' v_GS_D_L_One:' || v_GS_D_L_One);
    */
    v_Grouping_OK := 0;  -- not ok
    return;
  end if;

  case v_Materialization_Level


    when V_FULL  -- all groupings ok except see above
    then
      /*
      cwm2_olap_manager.Log_Note('Grouping_Test FULL v_Grouping_OK:)' || v_Grouping_OK);
      */
      v_Grouping_OK := 1;


    when V_MINIMUM
    then
      /*
       minimun set:
       (1) all hierarchies at level top(T)
       (2) all hierarchies at level 2
       (3) one hierarchy at top, others a level 1 (bottom)
       (4) one hierarchy at level 2, others at level 1 (bottom)

       this procedure will produce a SYS.OlapTabLevels with these level combinations:

       y dimension levels|
               T         |   1,2,3,T/T(3)      2,3,T/T           3,T/T        T/T(1)
               3,T       |   1,2,3,T/3,T       2,3,T/3,T         3,T/3,T      T/3,T
               2,3,T     |   1,2,3,T/2,3,T(4)  2,3,T/2,3,T(2)    3,T/2,3,T    T/2,3,T
               1,2,3,T   |   1,2,3,T/1,2,3,T   2,3,T/1,2,3,T(4)  3,T/1,2,3,T  T/1,2,3,T(3)
       -----------------------------------------------------------------------------------------
       x dimension levels    1,2,3,T           2,3,T             3,T          T

        1,2,3,T/1,2,3,T, 3,T/1,2,3,T, 3,T/2,3,T, T/2,3,T, 1,2,3,T/3,T, 2,3,T/3,T, 3,T/3,T, T/3,T, 
        2,3,T/T  and 3,T/T are not in the minimum set.
      */

      if (    v_GS_D_L_Top    = v_Last_Dimension)        -- (1) all hierarchies at level top(T)
      or (    v_GS_D_L_Second = v_Last_Dimension)        -- (2) all hierarchies at level 2
      or (    v_GS_D_L_Top    = 1                        -- (3) one hierarchy at top, others a level 1 (bottom)
          and v_GS_D_L_Bottom = (v_Last_Dimension - 1))  -- 
      or (    v_GS_D_L_Second = 1                        -- (4) one hierarchy at level 2, others at level 1 (bottom)
          and v_GS_D_L_Bottom = (v_Last_Dimension - 1))  -- 

      then
        /*
        cwm2_olap_manager.Log_Note('Grouping_Test V_MINIMUM OK'); 
        */
        v_Grouping_OK := 1;
      else
        /*
        cwm2_olap_manager.Log_Note('Grouping_Test V_MINIMUM NOT OK'); 
        */
        v_Grouping_OK := 0;  -- not ok
      end if;

      /*
      cwm2_olap_manager.Log_Note('Grouping_Test'
        || ' v_Grouping_OK:' || v_Grouping_OK
        || ' TOP:'           || v_GS_D_L_Top
        || ' SECOND:'        || v_GS_D_L_Second
        || ' BOTTOM:'        || v_GS_D_L_Bottom
        || ' ONE:'           || v_GS_D_L_One);
      */


    when V_PERCENT
    then

      if v_GS_D_L_Top = v_Last_Dimension                            -- all top level is good
      or mod(v_Partition_Count ,v_Materialization_Percent_Mod) = 0  -- do not include
      then
        v_Grouping_OK := 1;
      else
        v_Grouping_OK := 0;  -- not ok
      end if;  -- if v_GS_D_L_Top != v_Last_Dimension -- all top level is good
      /*
      cwm2_olap_manager.Log_Note('Grouping_Test V_PERCENT' 
        || ' v_GS_D_L_Top:'                  || v_GS_D_L_Top
        || ' v_Partition_Count:'             ||   v_Partition_Count  
        || ' v_Materialization_Percent_Mod:' || v_Materialization_Percent_Mod
        || ' v_Grouping_OK:'                 || v_Grouping_OK);
      */
 

    when V_SELECTED
    then
 
      -- is the current d v_L selected (no v_H)
      v_Dynamic_Cursor1 := 'select id'                 
                     -- ||       ' ,row_count'
                     -- ||       ' ,pct_of_total'
                     -- ||       ' ,schema_name cube_owner'
                     -- ||       ' ,cube_name'
                     -- ||       ' ,dimension_owner'
                     -- ||       ' ,dimension_name'
                     -- ||       ' ,level_name'
                     -- ||       '  selected'
                        ||  ' from ' || v_Tuples_Table_Owner || '.'  || v_Tuples_Table_Name
                        || ' where dimension_owner = :1'  -- v_D_Table(v_Last_Dimension).v_Dimension_Owner
                        ||   ' and dimension_name  = :2'  -- v_D_Table(v_Last_Dimension).v_Dimension_Name
                        ||   ' and level_name      = :3'   
                        ||   ' and selected        = 1'
                        || ' order by id';
      /*
      cwm2_olap_manager.Log_Note('Grouping_Compute' || ' v_Dynamic_Cursor1:' || v_Dynamic_Cursor1);
      */

      v_Dynamic_Cursor2 := 'select'
                     -- ||       '  id'                 
                     -- ||       ' ,row_count'
                     -- ||       ' ,pct_of_total'
                     -- ||       ' ,schema_name cube_owner'
                     -- ||       ' ,cube_name'
                        ||       '  dimension_owner'
                        ||       ' ,dimension_name'
                        ||       ' ,level_name'
                     -- ||       '  selected'
                        ||  ' from ' || v_Tuples_Table_Owner || '.'  || v_Tuples_Table_Name
                        || ' where id       = :1'  -- l_ID
                        ||   ' and selected = 1'
                        || ' order by dimension_owner'
                        ||         ' ,dimension_name'
                        ||         ' ,level_name';
 
      /*
      cwm2_olap_manager.Log_Note('Grouping_Compute' || ' v_Dynamic_Cursor2:' || v_Dynamic_Cursor2);
      */
    
      v_SID_Table.delete;
      v_Grouping_OK := null;  -- have not decided yet

      v_H := v_D_Table(v_Last_Dimension).v_Current_H;
      v_L := v_D_Table(v_Last_Dimension).v_H_Table(v_H).v_Current_L;

      /*
      -- dimension 1, current h, current l 
      cwm2_olap_manager.Log_Note('Grouping_Test V_SELECTED '
        ||' v_Last_Dimension:'  || v_Last_Dimension
        ||' v_H:'               || v_H
        ||' v_L:'               || v_L
        ||' v_Dimension_Owner:' || v_D_Table(v_Last_Dimension).v_Dimension_Owner
        ||' v_Dimension_Name:'  || v_D_Table(v_Last_Dimension).v_Dimension_Name
        ||' v_Level_Name:'      || v_LN_Table(v_D_Table(v_Last_Dimension).v_H_Table(v_H).v_L_Table(v_L).v_Level_Name_ID).v_Level_Name);
      */

      open c_Grouping_Test1 for v_Dynamic_Cursor1 using v_D_Table(v_Last_Dimension).v_Dimension_Owner
                                                       ,v_D_Table(v_Last_Dimension).v_Dimension_Name
                                 ,v_LN_Table(v_D_Table(v_Last_Dimension).v_H_Table(v_H).v_L_Table(v_L).v_Level_Name_ID).v_Level_Name;
      loop
        fetch c_Grouping_Test1 into l_ID;
        exit when c_Grouping_Test1%NOTFOUND;

        /*
        cwm2_olap_manager.Log_Note('Grouping_Test c_Grouping_Test1' || ' ID:' || l_ID);
        */

        for d in reverse 1..(v_Last_Dimension - 1)
        loop

          open c_Grouping_Test2 for v_Dynamic_Cursor2 using l_ID;

          loop
            fetch c_Grouping_Test2 into l_Dimension_Owner
                                       ,l_Dimension_Name 
                                       ,l_Level_Name;
            exit when c_Grouping_Test2%NOTFOUND;

            v_H := v_D_Table(d).v_Current_H;
            v_L := v_D_Table(d).v_H_Table(v_H).v_Current_L;

            /*
            cwm2_olap_manager.Log_Note('Grouping_Test c_Grouping_Test2'
              || ' d:'                 || d
              || ' v_H:'               || v_H
              || ' v_L:'               || v_L
              || ' v_Dimension_Owner:' || v_D_Table(d).v_Dimension_Owner
              || ' v_Dimension_Name:'  || v_D_Table(d).v_Dimension_Name
              || ' v_Level_Name:'      || v_LN_Table(v_D_Table(d).v_H_Table(v_H).v_L_Table(v_L).v_Level_Name_ID).v_Level_Name
              || ' Dimension_Owner:'   || l_Dimension_Owner
              || ' Dimension_Name:'    || l_Dimension_Name
              || ' Level_Name:'        || l_Level_Name);      
            */
 
            if l_Dimension_Owner = v_D_Table(d).v_Dimension_Owner
            or l_Dimension_Name  = v_D_Table(d).v_Dimension_Name
            or l_Level_Name      = v_LN_Table(v_D_Table(d).v_H_Table(v_H).v_L_Table(v_L).v_Level_Name_ID).v_Level_Name
            then
              if d = 1
              then  -- first d and equal so must be ok
                v_Grouping_OK := 1;  -- last d to test and still equal so must be ok
              end if;
            else
              v_Grouping_OK := 0;  -- not equal so not ok
              exit;  -- not ok exit c_Grouping_Test2 fetch loop
            end if;  -- if l_Dimension_Owner = v_D_Table(d).v_Dimension_Owner
          end loop;  -- end c_Grouping_Test2 fetch loop

          if v_Grouping_OK is not null  -- it has been decided os exit
          then
            exit;  -- exit for d in reverse 1..(v_Last_Dimension loop - 1)
          end if;  -- if v_Grouping_OK is not null
        end loop;  -- for d in 2..v_Last_Dimension

        close c_Grouping_Test2;

        if v_Grouping_OK is not null  -- it has been decided
        then
          exit;  --  exit c_Grouping_Test2 fetch loop
        end if;  -- if v_Grouping_OK is not null
      end loop;  -- end c_Grouping_Test1 fetch loop
      
      close c_Grouping_Test1;

      if v_Grouping_OK is null  -- not decided 
      then
        v_Grouping_OK := 0;  -- not ok
      end if;


  else
    -- programing error
    cwm2_olap_manager.Log_Note('Grouping_Test undefined v_Materialization_Level.');
    raise cwm2_olap_exceptions.internal_error;
  end case;  -- case v_Materialization_Level

  /*
  cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second ||'Grouping_Test END' || '  v_Grouping_OK:' || v_Grouping_OK);
  */

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Grouping_Test: '|| sqlerrm);
    end if;
    raise;
end Grouping_Test;


procedure Grouping_Next is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Grouping_Next BEGIN');
  end if;

  /*
     reset/set the group set dimension level count (a level can be a bottom, a second, a top, or a combination). 
     set finished if there is no next.
  */

  v_Current_D := v_Last_Dimension;  -- last d so next pass will start at last d
  v_D         := v_Current_D;
  v_H         := v_D_Table(v_D).v_Current_H;
  v_L         := v_D_Table(v_D).v_H_Table(v_H).v_Current_L;

  /* debugging
  v_X := 0;
  v_XMax := 10;
  */

  while v_Finished = 0
  loop

    /*
    cwm2_olap_manager.Log_Note('Grouping_Next INCREMENT START' || ' v_D:' || v_D || ' v_H:' || v_H || ' v_L:' || v_L);
    */

    /* debugging
    v_X := v_X + 1;
    cwm2_olap_manager.Log_Note('Grouping_Next INCREMENT FORCED x_X:' || v_X);  
    if v_X = v_XMax
    then
      cwm2_olap_manager.Log_Note('Grouping_Next INCREMENT FORCED EXIT');  
      v_Finished := 1;
      exit;
    end if;
    */

      /*
      cwm2_olap_manager.Log_Note('Grouping_Next LOOP BEGIN'
        || ' v_L_Table.count:'   || v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count 
        || ' v_L:'               || v_L
        || ' v_Current_L_State:' || v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State);
      */

    if (    v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count   > 2
        and v_L = v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count)  -- last level in current hierarchy
    or (    v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count   <= 2 
        and v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State = V_CURRENT_L_STATE_TOP)  -- see Set_GS_D_L
    then

      if v_H = v_D_Table(v_D).v_H_Table.count                     -- last hierarchy in current dimension  
      then

        if v_D = 1                                                -- first dimension
        then

          /*
          cwm2_olap_manager.Log_Note('Grouping_Next FINISHED');
          */

          v_Finished := 1;  -- incrementing is finished  
          exit;

        else  -- not first dimension;  set current level to 1, set current hierarchy to 1, decroment current dimension

          /*
          cwm2_olap_manager.Log_Note('Grouping_Next DECROMENT D');
          */

          v_D_Table(v_D).v_H_Table(v_H).v_Current_L       := 1;
          v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State := V_CURRENT_L_STATE_BOTTOM;
          v_D_Table(v_D).v_Current_H                      := 1;

          v_Current_D                               := v_Current_D - 1;
          v_D                                       := v_Current_D;
          v_H                                       := v_D_Table(v_D).v_Current_H;
          v_L                                       := v_D_Table(v_D).v_H_Table(v_H).v_Current_L;

          /*
          cwm2_olap_manager.Log_Note('Grouping_Next DECROMENT D LOOP' || ' v_D:' || v_D || ' v_H:' || v_H || ' v_L:' || v_L );
          */
        end if;  -- if v_D = 1                              -- first dimension

      else  -- not last hierarchy in current dimension;  set current l to 1, increment current h

        /*
        cwm2_olap_manager.Log_Note('Grouping_Next INCREMENT H'); 
        */


        v_D_Table(v_D).v_H_Table(v_H).v_Current_L       := 1;
        v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State := V_CURRENT_L_STATE_BOTTOM;
        v_D_Table(v_D).v_Current_H                      := v_D_Table(v_D).v_Current_H + 1;

        /*
        cwm2_olap_manager.Log_Note('Grouping_Next INCREMENT H EXIT' || ' v_D:' || v_D || ' v_Current_H:' || v_D_Table(v_D).v_Current_H);
        */
      exit;

      end if;  -- if v_H = v_D_Table(v_D).v_H_Table.count   -- last hierarchy in current dimensio

    else  -- not last level in current hierarchy;  incroment current level


      /*
      cwm2_olap_manager.Log_Note('Grouping_Next INCREMENT L');
      */

      if v_D_Table(v_D).v_H_Table(v_H).v_Current_L = 1
      then
   
        if v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count = 1
        then
          v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State := V_CURRENT_L_STATE_TOP;

       else
         v_D_Table(v_D).v_H_Table(v_H).v_Current_L := v_D_Table(v_D).v_H_Table(v_H).v_Current_L + 1;
         v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State := V_CURRENT_L_STATE_SECOND;
       end if;

      elsif v_D_Table(v_D).v_H_Table(v_H).v_Current_L = 2
      then

        if v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count = 2
        then
          v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State := V_CURRENT_L_STATE_TOP;

        else
          v_D_Table(v_D).v_H_Table(v_H).v_Current_L := v_D_Table(v_D).v_H_Table(v_H).v_Current_L + 1;
        end if;

      else

        v_D_Table(v_D).v_H_Table(v_H).v_Current_L := v_D_Table(v_D).v_H_Table(v_H).v_Current_L + 1;
      end if;


      /* the minimum set will only contain bottom levels (1), second levels (2), and top levels.  if minimum 
         only return those levels.  bottom level will have been returned when the hierarchy was incremented.
      */

      if v_Materialization_Level =  V_MINIMUM
      then
     
        if v_D_Table(v_D).v_H_Table(v_H).v_Current_L > 2
        then

          v_D_Table(v_D).v_H_Table(v_H).v_Current_L       := v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count;  -- top level
          v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State := V_CURRENT_L_STATE_TOP;
        end if;

          /*
          cwm2_olap_manager.Log_Note('Grouping_Next INCREMENT L MINIMUM SET TOP' || ' v_D:' || v_D || ' v_H:' || v_H 
            || ' v_Current_L:'       || v_D_Table(v_D).v_H_Table(v_H).v_Current_L
            || ' v_Current_L_State:' || v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State);
          */
      end if; -- if  v_Materialization_Level =  V_MINIMUM

      /*
      cwm2_olap_manager.Log_Note('Grouping_Next INCREMENT L EXIT' 
        || ' v_D:' || v_D || ' v_H:' || v_H || ' v_Current_L:' || v_D_Table(v_D).v_H_Table(v_H).v_Current_L
        || ' v_Current_L_State:' || v_D_Table(v_D).v_H_Table(v_H).v_Current_L_State);
      */
      exit;
    end if;  --  if (    v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count   > 2
  end loop;    

  /*
  cwm2_olap_manager.Log_Note('Grouping_Next EXIT'); 
  */

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Grouping_Next: '|| sqlerrm);
    end if;
    raise;
end Grouping_Next;



procedure Grouping_Generate is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Grouping_Generate BEGIN');
  end if;

  -- is this grouping ok
  DBMS_ODM.Grouping_Test;

  /*
  cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second ||'Grouping_Generate AFTER TEST' || ' v_Grouping_OK:'|| v_Grouping_OK);
  */

  if v_Grouping_OK = 1
  then
    DBMS_ODM.Grouping_Compute;
  end if;

  /*
  cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Grouping_Generate AFTER COMPUTE' || ' v_Grouping_OK:'|| v_Grouping_OK);
  */

  -- get next grouping
  DBMS_ODM.Grouping_Next;

  /*
  cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Grouping_Generate END AFTER NEXT'
    || ' v_Grouping_OK:'                  || v_Grouping_OK
    || ' v_Partition_Less_Than_Previous:' || v_Partition_Less_Than_Previous
    || ' v_Partition_Less_Than:'          || v_Partition_Less_Than); 
  */

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Grouping_Generate: '|| sqlerrm);
    end if;
    raise;
end Grouping_Generate;



procedure Grouping_Init is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Grouping_Init BEGIN');
  end if;

  --  init the current grouping counters to the last dimension and the first hierarchy and first level in each dimension.

  for d in 1..v_Last_Dimension
  loop

    v_D_Table(d).v_Current_H := 1;  -- first d.h

    for h in 1..v_D_Table(d).v_H_Table.count
    loop

      v_D_Table(d).v_H_Table(h).v_Current_L       := 1;  -- first d.h.l
      v_D_Table(d).v_H_Table(h).v_Current_L_State := V_CURRENT_L_STATE_BOTTOM;

      for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
      loop

        v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_Current_C := 1;  -- first d.h.l.t.c

      end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(V_DLK).v_C_Table.count
    end loop;  -- for h in 1..v_D_Table(d).v_H_Table.count
  end loop;  -- for d in 1..v_Last_Dimension

  v_Current_D                    := v_Last_Dimension;  -- last d so partition values less than will be ordered correctly
  v_Partition_Less_Than          := null;              -- needed for multi hierarchy test
  v_Partition_Count              := 0;     
  v_Grouping_Set_Count           := 0;     

  v_Partition_Less_Table.delete;  -- used to store and sort if need partition less than value
  v_GS_Table_Save.delete;         -- used to check for duplicate grouping sets

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Grouping_Init: '|| sqlerrm);
    end if;
    raise;
end Grouping_Init;



procedure Put_Partition_By_Range is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Partition_By_Range BEGIN' || ' v_Partitioning;' || v_Partitioning);
  end if;

  /*
    DBMS_ODM.Grouping_Generate sets level in grouping set, computes the materialization count use with percent mv
    so always call it.  do not put partitioning text if partitioning is not set.
  */

  v_MV_Step := V_MV_STEP_PUT_PARTITION_BY_RNG;

  if v_Partitioning = 1
  then
    DBMS_ODM.put_line('  PARTITION BY RANGE (GID) (');
    v_Prefix := '    PARTITION VALUES LESS THAN (';
    v_Suffix := ', ';
  end if;  -- if v_Partitioning = 1

  DBMS_ODM.Grouping_Init;

  v_Finished := 0;
  while v_Finished = 0
  loop

    -- this will set v_Finished when done
    DBMS_ODM.Grouping_Generate;

    if  v_Grouping_OK  = 1
    and v_Partitioning = 1
    then
      v_Partition_Less_Table.extend;
      v_PL := v_Partition_Less_Table.count;

      v_Partition_Less_Table(v_PL).v_Partition_Less_Than  := v_Partition_Less_Than;
      v_Partition_Less_Table(v_PL).v_Partition_Count      := v_Partition_Count;
      /*
      cwm2_olap_manager.Log_Note('Put_Partition_By_Range' 
        || ' v_PL:'                        || v_PL
        || ' v_Partition_Less_Than:'       || v_Partition_Less_Than
        || ' v_Partition_Count:'           || v_Partition_Count
        || ' v_Partition_Less_Than_Shift:' || v_Partition_Less_Than_Shift);
      */

      if v_Partition_Less_Than_Shift = 1
      then
  
        for pl in reverse 1..(v_Partition_Less_Table.count - 1)
        loop
  
          if v_Partition_Less_Table(pl).v_Partition_Less_Than > v_Partition_Less_Table(pl + 1).v_Partition_Less_Than
          then
  
            v_Partition_Less_Than                                := v_Partition_Less_Table(pl).v_Partition_Less_Than;
            v_Partition_Less_Table(pl).v_Partition_Less_Than     := v_Partition_Less_Table(pl + 1).v_Partition_Less_Than;
            v_Partition_Less_Table(pl + 1).v_Partition_Less_Than := v_Partition_Less_Than;
            /*
            cwm2_olap_manager.Log_Note('Put_Partition_By_Range SHIFT' 
              || ' pl:'                            || pl
              || ' v_Partition_Less_Than(pl):'     || v_Partition_Less_Table(pl).v_Partition_Less_Than
              || ' v_Partition_Less_Than(pl + 1):' ||  v_Partition_Less_Table(pl + 1).v_Partition_Less_Than);
            */
          else 
            exit;
          end if;  -- if v_Partition_Less_Table(pl).v_Partition_Less_Than > v_Partition_Less_Table(pl + 1).v_Partition_Less_Than
        end loop;  -- for pl in  reverse1..(v_Partition_Less_Table.count - 1)
      end if;  -- if v_Partition_Less_Than_Shift = 1
    end if;  -- if v_Grouping_OK = 1
  end loop;  -- while v_Finished = 0

  
  if v_Partitioning = 1
  then
    for pl in 1..v_Partition_Less_Table.count
    loop

      /*
      cwm2_olap_manager.Log_Note('Put_Partition_By_Range' 
        || ' pl:'                    || pl
        || ' v_Partition_Less_Than:' || v_Partition_Less_Table(pl).v_Partition_Less_Than
        || ' v_Partition_Count:'     || v_Partition_Less_Table(pl).v_Partition_Count);
      */

      if v_Partition_Less_Table(pl).v_Partition_Less_Than = 0
      or (    pl > 1
          and v_Partition_Less_Table(pl - 1).v_Partition_Less_Than = v_Partition_Less_Table(pl).v_Partition_Less_Than)
      then
        null;
      else
        v_Line    := v_Prefix || v_Partition_Less_Table(pl).v_Partition_Less_Than || ')' || v_Suffix;
        v_Comment := v_Partition_Less_Table(pl).v_Partition_Count;
        /*
        cwm2_olap_manager.Log_Note('Put_Partition_By_Range' 
          || ' pl:'        || pl
          || ' v_Line:'    || v_Line
          || ' v_Comment:' || v_Comment);
        */
        DBMS_ODM.Put_Line;
      end if;
    end loop;  
  
    DBMS_ODM.Put_Line(v_Prefix || 'MAXVALUE))' );
  end if;  -- if v_Partitioning = 1

  v_MV_Step := null;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Partition_By_Range: '|| sqlerrm);
    end if;
    raise;
end Put_Partition_By_Range;



procedure Put_Physical_Attributes is

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Physical_Attributes BEGIN');
  end if;

  DBMS_ODM.Put_Line('  PCTFREE 5');
  DBMS_ODM.Put_Line('  PCTUSED 40');
  DBMS_ODM.Put_Line('  NOPARALLEL');
  DBMS_ODM.Put_Line('  COMPRESS');

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Physical_Attributes: '|| sqlerrm);
    end if;
    raise;
end Put_Physical_Attributes;



procedure Put_MV_Attributes is

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_MV_Attributes BEGIN');
  end if;

  DBMS_ODM.Put_Line('  BUILD IMMEDIATE');
  DBMS_ODM.Put_Line('  USING NO INDEX');
  DBMS_ODM.Put_Line('  REFRESH '|| v_Refresh_Method || ' ON ' || v_Refresh_On);
  DBMS_ODM.Put_Line('  ENABLE QUERY REWRITE');

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_MV_Attributes: '|| sqlerrm);
    end if;
    raise;
end Put_MV_Attributes;



procedure Put_MV_Tablespace is

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_MV_Tablespace BEGIN');
  end if;

  if v_Tablespace_MV is not null
  then
    DBMS_ODM.Put_Line('  TABLESPACE ' || v_Tablespace_MV);
  end if;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_MV_Tablespace: '|| sqlerrm);
    end if;
    raise;
end Put_MV_Tablespace;



procedure Put_Select is

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Select BEGIN');
  end if;

  DBMS_ODM.Put_Line('  AS');

  DBMS_ODM.Put_Line('  SELECT');

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Select: '|| sqlerrm);
    end if;
    raise;
end Put_Select;



procedure Put_Grouping_ID is

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Grouping_ID BEGIN');
  end if;

  v_MV_Step := V_MV_STEP_PUT_GROUPING_ID;

  DBMS_ODM.Put_Line('    GROUPING_ID (');

  v_Prefix  := '      ';
  v_Suffix  := ',';
  v_Suffix1 := ')  GID,';

  for d in 1..v_Last_Dimension
  loop

    for h in 1..v_D_Table(d).v_H_Table.count
    loop

      for l in reverse 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
      loop

        v_LN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Name_ID;

        if v_LN_Table(v_LN).v_Level_Partition_Range != 0
        then
 
          for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
          loop
    
            if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
            then

              v_TN   := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Table_ID;
              v_CN   := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;

              /*
              cwm2_olap_manager.Log_Note('Put_Grouping_ID'
                || ' v_Table_Alias:'            || v_TN_Table(v_TN).v_Table_Alias
                || ' v_Column_Name:'            || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                || ' v_Level_In_Grouping_Set:'  || v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_In_Grouping_Set);
              */

              if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_In_Grouping_Set is not null
              then

                if v_Line is not null
                then
                  v_Line := rtrim(v_Line , v_Suffix1);
                  v_Line := v_Line || v_Suffix;
                  DBMS_ODM.Put_Line;
                end if;  -- if v_Line is not null

                v_Line := v_Prefix
                       || v_TN_Table(v_TN).v_Table_Alias
                       || '.'
                       || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                       || v_Suffix1;
                v_Comment := v_LN_Table(v_LN).v_Level_Partition_Range;
              end if;  -- v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_In_Grouping_Set is not null
            end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
          end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
        end if;  -- if v_LN_Table(v_LN).v_Level_Partition_Range != 0
      end loop;  -- for l in reverse 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
    end loop;  -- for h in 1..v_D_Table(d).v_H_Table.count
  end loop;  -- for d in 1..v_Last_Dimension

  DBMS_ODM.Put_Line;

  v_MV_Step := null;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Grouping_ID: '|| sqlerrm);
    end if;
    raise;
end Put_Grouping_ID;



procedure Put_Level_Attribute is

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Level_Attribute BEGIN');
  end if;

  /*
    put all attribute columns even if they are the same as some other column.
  */

  v_Prefix := '    '
           || 'MAX'
           || '(';
  v_Suffix := ',';

  v_D := 1;
  v_H := 1;

  for l in reverse 1..v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count
  loop

    for c in 1..v_D_Table(v_D).v_H_Table(v_H).v_L_Table(l).v_T_Table(V_LA).v_C_Table.count
    loop

      /*
      cwm2_olap_manager.Log_Note('Put_Level_Attribute' || ' v_D:' || v_D || ' v_H:' || v_H || ' l:' || l || ' c:' || c);
      */

      v_TN := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(l).v_Level_Table_ID;
      v_CN := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(l).v_T_Table(V_LA).v_C_Table(c).v_Column_Name_ID;
      DBMS_ODM.Put_Line(v_Prefix
                     || v_TN_Table(v_TN).v_Table_Alias
                     || '.'
                     || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                     || ')'
                     || V_ALIAS_SPACE
                     || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Alias_Attribute
                     || v_Suffix);

    end loop;  -- for c in 1..v_D_Table(v_D).v_H_Table(v_H).v_L_Table(l).v_T_Table(V_LA).v_C_Table.count
  end loop;  -- for l in reverse 1..v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Level_Attribute: '|| sqlerrm);
    end if;
    raise;
end Put_Level_Attribute;



procedure Put_Aggregation is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Aggregation BEGIN');
  end if;

  -- FACT TABLE AGGREGATION COLUMNS
  v_Prefix := '    '
           || v_Aggregation_Name  
           || '(';
  v_Suffix := ',';

  v_D := v_Measure_Dimension;

  for h in 1..v_D_Table(v_D).v_H_Table.count
  loop
    
    for l in reverse 1..v_D_Table(v_D).v_H_Table(h).v_L_Table.count
    loop
 
      for c in 1..v_D_Table(v_D).v_H_Table(h).v_L_Table(l).v_T_Table(V_FM).v_C_Table.count
      loop

        v_TN := v_Fact_Table_ID;
        v_CN := v_D_Table(v_D).v_H_Table(h).v_L_Table(l).v_T_Table(V_FM).v_C_Table(c).v_Column_Name_ID;
        DBMS_ODM.Put_Line(v_Prefix
                       || v_TN_Table(v_TN).v_Table_Alias || '.' || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                       || ')'
                       || V_ALIAS_SPACE
                       || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Alias
                       || v_Suffix);

      end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_FM).v_C_Table.count
    end loop;  -- for l in reverse 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
  end loop;  -- for h in 1..v_D_Table(d).v_H_Table.count

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Aggregation: '|| sqlerrm);
    end if;
    raise;
end Put_Aggregation;



procedure Put_Count is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Count BEGIN');
  end if;

  DBMS_ODM.Put_Line('    COUNT(*) COUNT_OF_STAR,');

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Count: '|| sqlerrm);
    end if;
    raise;
end Put_Count;



procedure Put_Level is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Level BEGIN');
  end if;

  v_Prefix := '    ';
  v_Suffix := ',';
  
  for d in 1..v_Last_Dimension
  loop

    for h in 1..v_D_Table(d).v_H_Table.count
    loop

      for l in reverse 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
      loop
  
        v_LN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Name_ID;

        for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
        loop

          if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
          then

            v_TN   := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Table_ID;
            v_CN   := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;

                /*
                cwm2_olap_manager.Log_Note('Put_Level DLK'
                  || ' d:'              || d
                  || ' h:'              || h
                  || ' l:'              || l
                  || ' c:'              || c
                  || ' v_LN:'           || v_LN
                  || ' v_TN:'           || v_TN
                  || ' v_CN:'           || v_CN
                  || ' v_Table_Alias:'  || v_TN_Table(v_TN).v_Table_Alias
                  || ' v_Column_Name:'  || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                  || ' v_Column_Alias:' || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Alias);
                */

            if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_In_Grouping_Set is not null
            then

              if v_Line is not null
              then
                DBMS_ODM.Put_Line;
              end if;  -- if v_Line is not null

              v_Line := v_Prefix 
                     || v_TN_Table(v_TN).v_Table_Alias
                     || '.'
                     || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                     || V_ALIAS_SPACE
                     || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Alias
                     || v_Suffix;

              v_Comment := v_LN_Table(v_LN).v_Level_Partition_Range;
            end if;  -- v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_In_Grouping_Set is not null
          end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
        end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
      end loop;  -- for l in reverse 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
    end loop;  -- for h in 1..v_D_Table(d).v_H_Table(h).count
  end loop;  -- for d in 1..v_D_Table.count

  v_Line := rtrim(v_Line ,v_Suffix);
  DBMS_ODM.Put_Line;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Level: '|| sqlerrm);
    end if;
    raise;
end Put_Level;



procedure Put_From is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_From BEGIN');
  end if;

  DBMS_ODM.Put_Line('  FROM');

  v_Prefix  := '    ';
  v_Suffix  := ',';

  for tn in 1..v_TN_Table.count
  loop

    DBMS_ODM.Put_Line;

    v_Line := v_Prefix
           || v_TN_Table(tn).v_Table_Owner || '.' || v_TN_Table(tn).v_Table_Name
           || V_ALIAS_SPACE
           || v_TN_Table(tn).v_Table_Alias
           || v_Suffix;
  end loop;  -- for tn in 1..v_TN_Table.count

  v_Line := rtrim(v_Line ,v_Suffix);
  DBMS_ODM.Put_Line;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_From: '|| sqlerrm);
    end if;
    raise;
end Put_From;


procedure Put_Where is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Where BEGIN');
  end if;

  -- if there is only one table there will be no where
  if v_TN_Table.count = 1
  then
    null;
    /*
    cwm2_olap_manager.Log_Note('Put_Where NULL');
    */
  else
    DBMS_ODM.Put_Line('  WHERE');
  
    v_Prefix := '    ';
    v_Suffix := 'AND';  -- do not us ' AND'. rtrim will truncate column name ending in A, N, and/or D 
  
    for d in 1..v_Last_Dimension
    loop
  
      for h in 1..v_D_Table(d).v_H_Table.count
      loop
  
        for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
        loop
          /*
          cwm2_olap_manager.Log_Note('Put_Where' || ' d:' || d || ' h:' || h || ' l:'|| l);
          */
          if  v_Fact_Table_ID is not null  -- there is a fact table (not CreateDimMV_GS)
          and l = 1  -- flk are only at the lowest level
          then
  
            -- do where dlk = flk first because there may not be any plk
            for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
            loop

              if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
              then

                DBMS_ODM.Put_Line;

                /*
                cwm2_olap_manager.Log_Note('Put_Where FLK' || ' d:' || d || ' h:' || h || ' l:' || l || ' c:' || c);
                */

                v_TN   := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Table_ID;
                /*
                cwm2_olap_manager.Log_Note('Put_Where DLK v_TN:' || v_TN);  
                */
 
                v_CN   := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;
                /*
                cwm2_olap_manager.Log_Note('Put_Where DLK v_CN:' || v_CN);  
                */

                v_TN2  := v_Fact_Table_ID;
                /*
                cwm2_olap_manager.Log_Note('Put_Where FLK v_TN2:' || v_TN2);  
                */

                v_CN2  := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_FLK).v_C_Table(c).v_Column_Name_ID;
                /*
                cwm2_olap_manager.Log_Note('Put_Where FLK v_CN2:' || v_CN2);  
                */

                /*
                cwm2_olap_manager.Log_Note('Put_Where FLK'
                  || ' v_TN:'          || v_TN
                  || ' v_CN:'          || v_CN
                  || ' v_TN2:'         || v_TN2
                  || ' v_CN2:'         || v_CN2
                  || ' v_Table_Alias:' || v_TN_Table(v_TN).v_Table_Alias
                  || ' v_Column_Name:' || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                  || ' ='
                  || ' v_Table_Alias:' || v_TN_Table(v_TN2).v_Table_Alias
                  || ' v_Column_Name:' || v_TN_Table(v_TN2).v_CN_Table(v_CN2).v_Column_Name);
                */

                v_Line := v_Prefix 
                       || v_TN_Table(v_TN).v_Table_Alias || '.' || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                       || ' = '
                       || v_TN_Table(v_TN2).v_Table_Alias || '.' || v_TN_Table(v_TN2).v_CN_Table(v_CN2).v_Column_Name 
                       || ' '
                       || v_Suffix;
              end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
            end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
          end if;  -- if l = 1  -- fjt are only at the lowest level

          if l < v_D_Table(d).v_H_Table(h).v_L_Table.count  -- no plk on top level
          then

            for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_PLK).v_C_Table.count
            loop
        
--              if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
--              then

                 DBMS_ODM.Put_Line;

                /*
                cwm2_olap_manager.Log_Note('Put_Where PLK' || ' d:' || d || ' h:' || h || ' l:' || l || ' c:' || c);
                */

                v_TN  := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Table_ID;
                v_CN  := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_PLK).v_C_Table(c).v_Column_Name_ID;
                v_TN2 := v_D_Table(d).v_H_Table(h).v_L_Table(l + 1).v_Level_Table_ID;
                v_CN2 := v_D_Table(d).v_H_Table(h).v_L_Table(l + 1).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;

                /*
                cwm2_olap_manager.Log_Note('Put_Where PLK'
                  || ' v_TN:'          || v_TN
                  || ' v_CN:'          || v_CN
                  || ' v_TN2:'         || v_TN2
                  || ' v_CN2:'         || v_CN2
                  || ' v_Table_Alias:' || v_TN_Table(v_TN).v_Table_Alias
                  || ' v_Column_Name:' || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                  || ' ='
                  || ' v_Table_Alias:' || v_TN_Table(v_TN2).v_Table_Alias
                  || ' v_Column_Name:' || v_TN_Table(v_TN2).v_CN_Table(v_CN2).v_Column_Name 
                                           );
                */

                v_Line := v_Prefix 
                       || v_TN_Table(v_TN).v_Table_Alias || '.' || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                       || ' = '
                       || v_TN_Table(v_TN2).v_Table_Alias || '.' || v_TN_Table(v_TN2).v_CN_Table(v_CN2).v_Column_Name 
                       || ' '
                       || v_Suffix;
--              end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
            end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_PLK).v_C_Table.count
          end if;  -- if l < v_D_Table(d).v_H_Table(h).v_L_Table.count
  
        end loop;  -- for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
      end loop;  -- for h in 1..v_D_Table(d).v_H_Table.count
    end loop;  -- for d in 1..v_Last_Dimension
  
    v_Line := rtrim(v_Line ,v_Suffix);
    DBMS_ODM.Put_Line;

  end if;  -- if v_D_Table.count = 1

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Where: '|| sqlerrm);
    end if;
    raise;
end Put_Where;



procedure Put_Group_By is
begin

  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Group_By BEGIN');
  end if;

  DBMS_ODM.Put_Line('  GROUP BY ');

  v_Prefix1 := '    (';
  v_Prefix2 := '    ROLLUP((';
  v_Prefix3 := '           (';
  v_Suffix  := ', ';

  for d in 1..v_Last_Dimension
  loop

    for h in 1..v_D_Table(d).v_H_Table.count
    loop

      for l in reverse 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
      loop

        for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
        loop

          /*
          cwm2_olap_manager.Log_Note('Put_Group_By' || ' d:' || d || ' h:' || h ||  ' l:' || l || ' c:' || c);
          */

          v_Use_This_Column := 1;  
          if v_D_Table(d).v_H_Table(h).v_L_Table.count = l  -- always put top level
          then 
            null;
          elsif v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As != 0
          then
            v_Use_This_Column := 0;  
          else

          /* column same as is set as metadata data is added.  data is add from the lowest level up, therefor
             same as is set on the higher level column.  group by columns are processed in reverse 
             level order so the higher columns are seen first and not used if same as is set.  the exception
             to this is the top level columns which are alway used.  to avoid using a column that is the same 
             as a top level column but same as is not set because of the order of loading test each
             column that is not a top level column against the set of top level columns.
          */    

            null;
          end if;

          if v_Use_This_Column = 1
          then
            if v_Line is null
            then
              if l = v_D_Table(d).v_H_Table(h).v_L_Table.count
              then  -- top level
                v_Prefix := v_Prefix1;
              elsif v_Prefix = v_Prefix1
              then 
                v_Prefix := v_Prefix2;
              else
                v_Prefix := v_Prefix3;
              end if;  -- if l = v_D_Table(d).v_H_Table(h).v_L_Table.count

              v_Line := v_Prefix;
            end if;  -- if v_Line is null

            v_TN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Table_ID;
            v_CN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;

            v_Line := v_Line
                   || v_TN_Table(v_TN).v_Table_Alias
                   || '.'
                   || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                   || v_Suffix;

            v_Comment := v_Comment
                      || v_TN_Table(v_TN).v_Table_Name
                      || '.'
                      || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name
                      || v_Suffix;

          end if;  --  if v_Use_This_Column = 1
        end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count

        if v_Line is not null
        then

          v_Line    := rtrim(v_Line ,v_Suffix);
          v_Comment := rtrim(v_Comment ,v_Suffix);
      
          if l = 1 
          then  -- first l      
            v_Line_Type := V_LINE_TYPE_END_OF_COMMAND;
            if v_D_Table(d).v_H_Table(h).v_L_Table.count = 1  -- only level
            then
              v_Line := v_Line || ')';
            else
              v_Line := v_Line || '))';
            end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table.count = 1  -- only leve
          else
            v_Line := v_Line || '),';
          end if;  -- if l = 1
        end if;  -- if v_Line is not null

        DBMS_ODM.Put_Line;

      end loop;  -- for l in reverse 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
    end loop;  -- for h in 1..v_D_Table(d).v_H_Table.count
  end loop;  -- for d in 1..v_Last_Dimension

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Group_By: '|| sqlerrm);
    end if;
    raise;
end Put_Group_By;



procedure Put_Group_By_Grouping_Set is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Group_By_Grouping_Set BEGIN');
  end if;

  v_MV_Step := V_MV_STEP_PUT_GROUP_BY_GS;

  DBMS_ODM.Put_Line('  GROUP BY GROUPING SETS (');

  v_Prefix1 := '    (';
  v_Prefix2 := '     ';

  v_Prefix  := v_Prefix1;
  v_Suffix  := ', ';

  DBMS_ODM.Grouping_Init;

  v_Finished := 0;
  while v_Finished = 0
  loop

    -- this will set v_Finished when done
    DBMS_ODM.Grouping_Generate;

    if v_Grouping_OK = 1
    then

      DBMS_ODM.Put_Line;

      for gs in 1..v_GS_Table.count
      loop 

        DBMS_ODM.Put_Line;

        if gs = 1
        then
          v_Line := v_Prefix;
        else
          v_Line := v_Prefix2;
        end if;

        v_Line    := v_Line || v_GS_Table(gs).v_Grouping_Set;
        v_Comment := v_GS_Table(gs).v_Grouping_Comment;

      /*
      cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Group_By_Grouping_Set'
        || ' v_Line:'    || v_Line
        || ' v_Comment:' || v_Comment);
      */

      end loop;  -- for gs in 1..v_GS_Table.count
 
      v_Line := rtrim(v_Line , v_Suffix);
      v_Line := v_Line  || '),';

    end if;  -- if v_Grouping_OK = 1
  end loop;  -- while v_Finished = 0

  v_Line := rtrim(v_Line , ',');
  v_Line := v_Line || ')';
  v_Line_Type := V_LINE_TYPE_END_OF_COMMAND;
  DBMS_ODM.Put_Line;

  v_MV_Step := null;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Group_By_Grouping_Set: '|| sqlerrm);
    end if;
    raise;
end Put_Group_By_Grouping_Set;



procedure Put_Gather_Table_Stats is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Gather_Table_Stats BEGIN');
  end if;

  DBMS_ODM.Put_2_Blank_Line;

  v_Line := 'DBMS_STATS.GATHER_TABLE_STATS('
         || '''' || v_Owner || ''', ''' || v_Materialized_View_Name || ''''
         || ', estimate_percent=>dbms_stats.auto_sample_size'
         || ', degree=>dbms_stats.default_degree';

  if v_Output_Segment = V_OUTPUT_SEGMENT_DIM_CREATE
  then
    v_Line := v_Line
           || ', method_opt=>''for all columns size skewonly'')';

  elsif v_Output_Segment = V_OUTPUT_SEGMENT_FACT_CREATE
  then
    v_Line := v_Line
           || ', method_opt=>''for all columns size 1 for columns size 254 GID'''
           || ', granularity=>''GLOBAL'')';

  elsif v_Output_Segment = V_OUTPUT_SEGMENT_DIM_INDEX 
     or v_Output_Segment = V_OUTPUT_SEGMENT_FACT_INDEX
  then
    v_Line := v_Line
           || ', method_opt=>''for all hidden columns size 254'''
           || ', granularity=>''GLOBAL'')';
  else
    -- programing error
    cwm2_olap_manager.Log_Note('Put_Gather_Table_Stats: Segment Type error.');
    raise cwm2_olap_exceptions.internal_error;
  end if;

  v_Line_Type := V_LINE_TYPE_EXECUTE_COMMAND;
  DBMS_ODM.Put_Line;

  /*
  cwm2_olap_manager.Log_Note('Put_Gather_Table_Stats: v_Line:' || v_Line);
  */

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Gather_Table_Stats: '|| sqlerrm);
    end if;
    raise;
end Put_Gather_Table_Stats;



procedure Alter_Table_Records_Per_Block is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Alter_Table_Records_Per_Block BEGIN');
  end if;

  DBMS_ODM.Put_2_Blank_Line;
  
  v_Line_Type := V_LINE_TYPE_END_OF_COMMAND;
  DBMS_ODM.Put_Line('ALTER TABLE '
                 || v_Owner
                 || '.'
                 || v_Materialized_View_Name
                 || ' MINIMIZE RECORDS_PER_BLOCK');
exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Alter_Table_Records_Per_Block: '|| sqlerrm);
    end if;
    raise;
end Alter_Table_Records_Per_Block;



/*
procedure Alter_Table_Noparallel is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Alter_Table_Noparallel BEGIN');
  end if;

  DBMS_ODM.Put_2_Blank_Line;

  v_Line_Type := V_LINE_TYPE_END_OF_COMMAND;
  DBMS_ODM.Put_Line('ALTER MATERIALIZED VIEW ' || v_Owner || '.' || v_Materialized_View_Name || ' NOPARALLEL');

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Alter_Table_Noparallel: '|| sqlerrm);
    end if;
    raise;
end Alter_Table_Noparallel;
*/



procedure Set_Current_Column_List is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Set_Current_Column_List BEGIN' 
      || ' v_D:' || v_D || ' v_H:' || v_H || ' v_L:'|| v_L);
  end if;

  v_Suffix                    := ' || '':'') || ';
  v_Current_Column_Name_List  := null;
  v_Current_Column_Alias_List := null;

  for c in 1..v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table.count
  loop

    v_TN := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_Level_Table_ID;
    v_CN := v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;

    v_Current_Column_Name_List  := '(' || v_Current_Column_Name_List  || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name  || v_Suffix;
    v_Current_Column_Alias_List := '(' || v_Current_Column_Alias_List || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Alias || v_suffix;
  end loop;  -- for c in 1..v_D_Table(v_D).v_H_Table(v_H).v_L_Table(v_L).v_T_Table(V_DLK).v_C_Table.count

  v_Current_Column_Name_List  := rtrim(v_Current_Column_Name_List  ,v_Suffix);
  v_Current_Column_Alias_List := rtrim(v_Current_Column_Alias_List ,v_suffix);
  v_Current_Column_Name_List  := v_Current_Column_Name_List  || ')';
  v_Current_Column_Alias_List := v_Current_Column_Alias_List || ')';

  /*
  cwm2_olap_manager.Log_Note('Put_ET_Bitmap_Index'
    || ' v_Current_Column_Name_List:'  || v_Current_Column_Name_List
    || ' v_Current_Column_Alias_List:' || v_Current_Column_Alias_List);
  */
        
exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Set_Current_Column_List: '|| sqlerrm);
    end if;
    raise;
end Set_Current_Column_List;



procedure Put_Begin_Bitmap_Index is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Begin_Bitmap_Index BEGIN');
  end if;

  v_Index_Count       := v_Index_Count + 1;
  v_Bitmap_Index_Name := v_Materialized_View_Name || v_Bitmap_Index_Name || DBMS_ODM.Get_Suffix(v_Index_Count);


  DBMS_ODM.Put_2_Blank_Line;

  DBMS_ODM.Put_Line('CREATE BITMAP INDEX '
                  || v_Owner || '.' || v_Bitmap_Index_Name
                  || ' ON '
                  || v_Owner || '.' || v_Materialized_View_Name);

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Begin_Bitmap_Index: '|| sqlerrm);
    end if;
    raise;
end Put_Begin_Bitmap_Index;



procedure Put_End_Bitmap_Index is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_End_Bitmap_Index BEGIN');
  end if;

  if v_Partitioning = 1
  then
    DBMS_ODM.Put_Line('  LOCAL');
  end if;
  
  DBMS_ODM.Put_Line('  COMPUTE STATISTICS');
  
  if v_Tablespace_Index is not null
  then
    DBMS_ODM.Put_Line('  TABLESPACE ' || v_Tablespace_Index);
  end if;
    
  DBMS_ODM.Put_Line('  PARALLEL PCTFREE 0');
    
  v_Line_Type := V_LINE_TYPE_END_OF_COMMAND;
  DBMS_ODM.Put_Line('  NOLOGGING');

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_End_Bitmap_Index: '|| sqlerrm);
    end if;
    raise;
end Put_End_Bitmap_Index;



procedure Put_ET_Parent_Bitmap_Index is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_ET_Parent_Bitmap_Index BEGIN');
  end if;

  IF V_D_Table(1).v_H_Table(v_D_Table(v_D).v_Current_H).v_L_Table.count = 1
  then
    return;
  end if;

  v_Bitmap_Index_Name := 'EP';

  DBMS_ODM.Put_Begin_Bitmap_Index;

  if v_Put_Case = V_PUT_CASE_YES
  then
    DBMS_ODM.Put_Line('  ((CASE SYS_OP_PARGID(' || v_Sys_Op_Base || ')');
  end if;  -- if v_Put_Case = V_PUT_CASE_YES

  DBMS_ODM.Grouping_Init;

  v_Finished := 0;
  v_Count    := 0;
  v_When.delete;
  while v_Finished = 0
  loop

     -- this will set v_Finished when done
     DBMS_ODM.Grouping_Generate;

     /*
     cwm2_olap_manager.Log_Note('Put_Level_Parent_Bitmap_Index'
       || ' v_Grouping_OK:'         || v_Grouping_OK
       || ' v_Partition_Less_Than:' || v_Partition_Less_Than);
     */

     if  v_Grouping_OK = 1
     and v_Sys_Op_Base_Max_Level > 1              -- more than one level
     and v_Sys_Op_Base_Max_Level > (v_Count + 1)  -- not top level
     
     then
       v_When.extend;
       v_W := v_When.count;
       v_Count := v_Count + 1;
       v_When(v_W).v_Line  := '    WHEN('
                           || v_Partition_Less_Than 
                           || ') THEN TO_CHAR(SYS_OP_PAR('
                           || (v_Sys_Op_Base_Count - v_Count)
                           || ', '
                           || v_Sys_Op_Base 
                           || '))';
       v_When(v_W).v_Comment := v_Current_Column_Name_List;
     end if;
   end loop;  -- while v_Finished = 0

  if v_Put_Case = V_PUT_CASE_YES
  then
    for w in reverse 1..v_When.count
    loop
      v_Line    := v_When(w).v_Line;
      v_Comment := v_When(w).v_Comment;
      DBMS_ODM.Put_Line;
    end loop;
    DBMS_ODM.Put_Line('    ELSE TO_CHAR(SYS_OP_PAR(' || v_Sys_Op_Base_Count || ', '|| v_Sys_Op_Base || '))');
  else
    DBMS_ODM.Put_Line('  (TO_CHAR(SYS_OP_PAR(' || v_Sys_Op_Base_Count || ', '|| v_Sys_Op_Base || ')))');
  end if;  -- if v_Put_Case = V_PUT_CASE_YES

  if v_Put_Case = V_PUT_CASE_YES
  then
    DBMS_ODM.Put_Line('    END))');
  end if;  -- if v_Put_Case = V_PUT_CASE_YES

  DBMS_ODM.Put_End_Bitmap_Index;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_ET_Parent_Bitmap_Index: '|| sqlerrm);
    end if;
    raise;
end Put_ET_Parent_Bitmap_Index;



procedure Put_ET_Bitmap_Index is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_ET_Bitmap_Index BEGIN');
  end if;

  IF V_D_Table(1).v_H_Table(v_D_Table(v_D).v_Current_H).v_L_Table.count = 1
  then
    return;
  end if;

  v_Bitmap_Index_Name := 'E';

  DBMS_ODM.Put_Begin_Bitmap_Index;

  if v_Put_Case = V_PUT_CASE_YES
  then
    DBMS_ODM.Put_Line('  ((CASE GID');
  end if;   -- if v_Put_Case = V_PUT_CASE_YES

  DBMS_ODM.Grouping_Init;

  -- lowest level
  v_D := 1;
  v_H := 1;
  v_L := 1;
  DBMS_ODM.Set_Current_Column_List;
  v_Else_Column_Name_List  := v_Current_Column_Name_List;
  v_Else_Column_Alias_List := v_Current_Column_Alias_List;

  v_Finished := 0;
  v_When.delete;
  while v_Finished = 0
  loop

    -- this will set v_Finished when done
    DBMS_ODM.Grouping_Generate;

    /*
    cwm2_olap_manager.Log_Note('Put_ET_Bitmap_Index'
      || ' v_Bitmap_Index_Name:'            || v_Bitmap_Index_Name
      || ' v_Grouping_OK:'                  || v_Grouping_OK
      || ' v_Partition_Less_Than_Previous:' || v_Partition_Less_Than_Previous 
      || ' v_Partition_Less_Than:'          || v_Partition_Less_Than);
    */


    if v_Partition_Less_Than_Previous = v_Partition_Less_Than
    then
      v_Grouping_OK := 0;  -- grouping not ok
    end if;

    if v_Grouping_OK = 1 -- grouping ok
    then
 
      v_D := 1;
      v_H := v_D_Table(v_D).v_Current_H;

      v_L := v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count;  -- current l is not set to last l if finished

      /*
      cwm2_olap_manager.Log_Note('Put_ET_Bitmap_Index' || ' v_L '|| v_L);
      */
  
      DBMS_ODM.Set_Current_Column_List;
      v_When.extend;
      v_W := v_When.count;

      v_When(v_W).v_Line := '    WHEN('
                         || v_Partition_Less_Than 
                         || ') THEN TO_CHAR('
                         || v_Current_Column_Alias_List
                         || ')';
      v_When(v_W).v_Comment := v_Current_Column_Name_List;
      /*
      cwm2_olap_manager.Log_Note('Put_ET_Bitmap_Index'
        || ' v_W:'       || v_W
        || ' v_Line::'   || v_When(v_W).v_Line
        || ' v_Comment:' || v_When(v_W).v_Comment);
      */
    end if;  -- if v_Grouping_OK = 1 -- grouping ok
  end loop;  -- while v_Finished = 0

  if v_Put_Case = V_PUT_CASE_YES
  then
    for w in reverse 1..v_When.count  -- reverse the when lines
    loop
      v_Line    := v_When(w).v_Line;
      v_Comment := v_When(w).v_Comment;
      DBMS_ODM.Put_Line;
    end loop;
    DBMS_ODM.Put_Line('    ELSE TO_CHAR(' || v_Else_Column_Alias_List || ')');
  else
    DBMS_ODM.Put_Line('  (TO_CHAR(' || v_Else_Column_Alias_List || '))');
  end if;  -- if v_Put_Case = V_PUT_CASE_YES
 
  v_Comment := v_Else_Column_Name_List;

  DBMS_ODM.Put_Line;

  if v_Put_Case = V_PUT_CASE_YES
  then
    DBMS_ODM.Put_Line('    END))');
  end if;  -- if v_Case_Statemen = V_PUT_CASE_YES

  DBMS_ODM.Put_End_Bitmap_Index;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_ET_Bitmap_Index: '|| sqlerrm);
    end if;
    raise;
end Put_ET_Bitmap_Index;



procedure Put_GID_Parent_Bitmap_Index is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_GID_Parent_Bitmap_Index BEGIN');
  end if;

  v_Bitmap_Index_Name := 'GP';

  DBMS_ODM.Put_Begin_Bitmap_Index;

  v_Line := '  (SYS_OP_PARGID(' || v_Sys_Op_Base || '))';

  DBMS_ODM.Put_Line(v_Line);

  DBMS_ODM.Put_End_Bitmap_Index;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_GID_Parent_Bitmap_Index: '|| sqlerrm);
    end if;
    raise;
end Put_GID_Parent_Bitmap_Index;



procedure Put_GID_Bitmap_Index is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_GID_Bitmap_Index BEGIN');
  end if;

  v_Bitmap_Index_Name := 'G';

  DBMS_ODM.Put_Begin_Bitmap_Index;

  DBMS_ODM.Put_Line('  (GID)');

  DBMS_ODM.Put_End_Bitmap_Index;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_GID_Bitmap_Index: '|| sqlerrm);
    end if;
    raise;
end Put_GID_Bitmap_Index;



procedure Put_Level_Parent_Bitmap_Index is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Level_Parent_Bitmap_Index BEGIN');
  end if;

  v_D := 1;
  v_H := 1;

  for l in 1..v_D_Table(v_D).v_H_Table(v_H).v_L_Table.count
  loop

    v_Bitmap_Index_Name := 'LP';

    DBMS_ODM.Put_Begin_Bitmap_Index;

    v_Line := '  (SYS_OP_PAR(' || (l - 1) || ', ' || v_Sys_Op_Base || '))';

    DBMS_ODM.Put_Line(v_Line);

    DBMS_ODM.Put_End_Bitmap_Index;

  end loop;  -- for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Level_Parent_Bitmap_Index: '|| sqlerrm);
    end if;
    raise;
end Put_Level_Parent_Bitmap_Index;



procedure Put_Level_Bitmap_Index is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Level_Bitmap_Index BEGIN');
  end if;

  for d in 1..v_Last_Dimension
  loop

    for h in 1..v_D_Table(d).v_H_Table.count
    loop

      if v_Output_Segment = V_OUTPUT_SEGMENT_FACT_INDEX 
      then 
        v_Level_Count := v_D_Table(d).v_H_Table(h).v_L_Table.count;        -- index all levels for fact mv
      else 
        v_Level_Count := (v_D_Table(d).v_H_Table(h).v_L_Table.count - 1);  -- do not index on top level for dimension mv
      end if;

      for l in 1..v_Level_Count 
      loop
  
        v_LN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Name_ID;

        if v_LN_Table(v_LN).v_Level_Partition_Range != 0
        then
 
          if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(1).v_Column_Same_As = 0
          then

            for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
            loop

              v_TN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Table_ID;
              v_CN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;


              if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_In_Grouping_Set is not null
              then

                v_Bitmap_Index_Name := 'L';

                DBMS_ODM.Put_Begin_Bitmap_Index;

                v_Line := '  (' || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Alias || ')';

                v_Comment := v_TN_Table(v_TN).v_Table_Name || '.' || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Name;
    
                DBMS_ODM.Put_Line;

                DBMS_ODM.Put_End_Bitmap_Index;

              end if;  -- v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_In_Grouping_Set is not null
            end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
          end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(1).v_Column_Same_As = 0
        end if;  -- if v_LN_Table(v_LN).v_Level_Partition_Range != 0
      end loop;  -- for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
    end loop;  -- for h in 1..v_D_Table(d).v_H_Table(h).count
  end loop;  -- for d in 1..v_D_Table.count

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Level_Bitmap_Index: '|| sqlerrm);
    end if;
    raise;
end Put_Level_Bitmap_Index;



procedure Get_Sys_Op_Base is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Get_Sys_Op_Base BEGIN');
  end if;

  v_Suffix     := ', ';
  v_Sys_Op_Base       := null;
  v_Sys_Op_Base_Count := -1;  -- sys_op_par uses a zero based counter so init to -1 so count will be zero based

  for d in 1..v_Last_Dimension
  loop

    for h in 1..v_D_Table(d).v_H_Table.count
    loop

      for l in reverse 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
      loop
  
        if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count > 1
        then
          v_Sys_Op_Base    := v_Sys_Op_Base || 'SYS_OP_LVL(';
          v_Suffix1 := '), ';
        else
          v_Suffix1 := null;
        end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count > 1

        for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count
        loop

          if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
          then

            v_TN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_Level_Table_ID;
            v_CN := v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Name_ID;

            v_Sys_Op_Base := v_Sys_Op_Base
                   || v_TN_Table(v_TN).v_CN_Table(v_CN).v_Column_Alias
                   || v_Suffix;

            v_Sys_Op_Base_Count := v_Sys_Op_Base_Count + 1;

            v_Sys_Op_Base_Max_Level := v_D_Table(d).v_H_Table(h).v_L_Table.count;

            /*
            cwm2_olap_manager.Log_Note('Get_Sys_Op_Base'
              || ' v_Sys_Op_Base:'           || v_Sys_Op_Base
              || ' v_Sys_Op_Base_Count:'     || v_Sys_Op_Base_Count
              || ' v_Sys_Op_Base_Max_Level:' || v_Sys_Op_Base_Max_Level
                                       );
            */

          end if;  -- if v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table(c).v_Column_Same_As = 0
        end loop;  -- for c in 1..v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.count

      if v_Suffix1 is not null
      then
        v_Sys_Op_Base := rtrim(v_Sys_Op_Base ,v_Suffix);  -- remove normal suffix
        v_Sys_Op_Base := v_Sys_Op_Base || v_Suffix1;      -- add end of lvl suffix
      end if;

      /*
      cwm2_olap_manager.Log_Note('Get_Sys_Op_Base'
        || ' v_Sys_Op_Base '       || v_Sys_Op_Base
        || ' v_Sys_Op_Base_Count ' || v_Sys_Op_Base_Count
                                 );
      */

      end loop;  -- for l reverse in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
    end loop;  -- for h in 1..v_D_Table(d).v_H_Table(h).count
  end loop;  -- for d in 1..v_D_Table.count

  v_Sys_Op_Base := rtrim(v_Sys_Op_Base ,v_Suffix);

  v_Sys_Op_Base := 'GID, '
                || v_Sys_Op_Base;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Get_Sys_Op_Base: '|| sqlerrm);
    end if;
    raise;
end Get_Sys_Op_Base;



procedure Put_Set_MV_Summary_Code is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Put_Set_MV_Summary_Code BEGIN');
  end if;

  DBMS_ODM.Put_2_Blank_Line;

  DBMS_ODM.Put_Line('EXECUTE CWM2_OLAP_CUBE.SET_MV_SUMMARY_CODE('''
                 || v_Cube_Owner
                 || ''', '''
                 || v_Cube_Name
                 || ''', '''
                 || 'ROLLUP'
                 || ''') ; ');

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Put_Set_MV_Summary_Code: '|| sqlerrm);
    end if;
    raise;
end Put_Set_MV_Summary_Code;



procedure Add_Init is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Init BEGIN');
  end if;

  v_Dimension_Count             := 0;
  v_Hierarchy_Count             := 0;

  v_Highest_Level_In_Dimension  := 0;

  v_Status                      := null;
  v_Fact_Table_ID               := null;
  v_Fact_Level_Key_Column_Count := 0;
  v_Index_Count                 := 0;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Init: '|| sqlerrm);
    end if;
    raise;
end Add_Init;



procedure Add_Begin is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_Begin BEGIN');
  end if;

  -- delete tables
  for d in 1..v_D_Table.count
  loop

    for h in 1..v_D_Table(d).v_H_Table.count
    loop

      for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count
      loop
        v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_DLK).v_C_Table.delete;
        v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_PLK).v_C_Table.delete;
        v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_LA).v_C_Table.delete;
        v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_FLK).v_C_Table.delete;
        v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table(V_FM).v_C_Table.delete;
        v_D_Table(d).v_H_Table(h).v_L_Table(l).v_T_Table.delete;
      end loop;  -- for l in 1..v_D_Table(d).v_H_Table(h).v_L_Table.count

      v_D_Table(d).v_H_Table(h).v_L_Table.delete;
    end loop;  -- for h in 1..v_D_Table(d).v_H_Table.count

    v_D_Table(d).v_H_Table.delete;
  end loop;  --for d in reverse 1..v_D_Table.count

  v_D_Table.delete;
  v_LN_Table.delete;
  v_TN_Table.delete;

  v_Current_Dimension_Owner := null;

  v_Status := v_STATUS_OK;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_Begin: '|| sqlerrm);
    end if;
    raise;
end Add_Begin;



procedure Add_End is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Add_End BEGIN' || ' v_Status:' || v_Status);
  end if;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Add_End: '|| sqlerrm);
    end if;
    raise;
end Add_End;



procedure Close_Output is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Close_Output BEGIN' || ' v_Put_To:'  || v_Put_To);
  end if;

  DBMS_ODM.Close_File;

  DBMS_ODM.Close_Clob;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Close_Output: '|| sqlerrm);
    end if;
    raise;
end Close_Output;



procedure Open_Output is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Open_Output BEGIN'
      || ' v_Run_ID:'      || v_Run_ID
      || ' v_Output_Path:' || v_Output_Path
      || ' V_Output_File:' || V_Output_File);
  end if;

  if v_Run_ID is null
  then
    DBMS_ODM.Open_File;
    v_Put_To := V_PUT_TO_FILE;
    
  else
    v_Put_To := V_PUT_TO_CLOB;
  end if;

  /*
  cwm2_olap_manager.Log_Note('Open_Output' || '  v_Put_TO:' || v_Put_To);
  */
exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Open_Output: '|| sqlerrm);
    end if;
    raise;
end Open_Output;



procedure Get_Level_Tuples is
  c_Get_Level_Tuples    t_Ref_Cursor;
  l_Cube_Owner          SYS.OlapTabLevelTuples.schema_name%type                   := null;
  l_Cube_Name           SYS.OlapTabLevelTuples.schema_name%type                   := null;
  l_Dimension_Name      SYS.OlapTabLevelTuples.dimension_name%type                := null;
  l_Dimension_Owner     SYS.OlapTabLevelTuples.dimension_owner%type               := null;
  l_Hierarchy_Name      olapsys.ODM$olap2udim_hier_level_uses.hierarchy_name%type := null;
  l_Solvedcode          olapsys.ODM$olap2udim_hier_level_uses.solvedcode%type     := null;
  l_Level_Position      olapsys.ODM$olap2udim_hier_level_uses.position%type       := null;
  l_Level_Name          SYS.OlapTabLevelTuples.level_name%type                    := null;

begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Get_Level_Tuples BEGIN'
      || ' v_Cube_Owner:' || v_Cube_Owner
      || ' v_Cube_Name:'  || v_Cube_Name
                               );
  end if;

  -- only fetch selected tuples
  v_Dynamic_Cursor1 := 'select distinct' 
                 -- ||               '  nvl(tt.ID ,0)  id'
                 -- ||               ' ,tt.ROW_COUNT'
                 -- ||               ' ,tt.PCT_OF_TOTAL'
                 -- ||               ' ,tt.SCHEMA_NAME'
                 -- ||               ' ,tt.CUBE_NAME'
                 -- ||               ' ,tt.DIMENSION_NAME'
                 -- ||               ' ,tt.DIMENSION_OWNER'
                 -- ||               ' ,tt.LEVEL_NAME'
                 -- ||               '  nvl(tt.SELECTED ,0)  level_selected'
                 --
                    ||               '  x.CUBE_OWNER'
                    ||               ' ,x.CUBE_NAME'
                 -- ||               ' ,x.DIMENSION_OWNER'
                 -- ||               ' ,x.DIMENSION_NAME'
                 -- ||               ' ,x.DIMENSION_ALIAS'
                 -- ||               ' ,x.HIERARCHY_NAME'
                 -- ||               ' ,x.LEVEL_NAME'
                 -- ||               ' ,x.FACT_TABLE_OWNER'
                 -- ||               ' ,x.FACT_TABLE_NAME'
                 -- ||               ' ,x.COLUMN_NAME'
                 -- ||               ' ,x.COLUMN_POSITION'
                 -- 
                    ||               ' ,x.DIMENSION_OWNER'
                    ||               ' ,x.DIMENSION_NAME'
                    ||               ' ,x.HIERARCHY_NAME'
                    ||               ' ,x.SOLVEDCODE'
                    ||               ' ,x.LEVEL_NAME'
                    ||               ' ,x.LEVEL_POSITION'
                    ||  ' from ' || v_Tuples_Table_Owner || '.'  || v_Tuples_Table_Name || ' tt'
                    ||     ', (select distinct flu.OWNER  cube_owner'
                    ||                      ' ,flu.CUBE_NAME'
                 -- ||                      ' ,flu.DIMENSION_OWNER'
                 -- ||                      ' ,flu.DIMENSION_NAME'
                 -- ||                      ' ,flu.DIMENSION_ALIAS'
                 -- ||                      ' ,flu.HIERARCHY_NAME'
                 -- ||                      ' ,flu.LEVEL_NAME'
                 -- ||                      ' ,flu.FACT_TABLE_OWNER'
                 -- ||                      ' ,flu.FACT_TABLE_NAME'
                 -- ||                      ' ,flu.COLUMN_NAME'
                 -- ||                      ' ,flu.POSITION  column_position'
                 -- 
                    ||                      ' ,dhlu.OWNER  dimension_owner'
                    ||                      ' ,dhlu.DIMENSION_NAME'
                    ||                      ' ,dhlu.HIERARCHY_NAME'
                    ||                      ' ,dhlu.SOLVEDCODE'
                    ||                      ' ,dhlu.CHILD_LEVEL_NAME  level_name'
                    ||                      ' ,dhlu.POSITION  level_position'
                    ||         ' from olapsys.ODM$olap2ufact_level_uses  flu'
                    ||             ' ,olapsys.ODM$olap2udim_hier_level_uses  dhlu'
                    ||        ' where flu.DIMENSION_OWNER = dhlu.OWNER'
                    ||          ' and flu.DIMENSION_NAME  = dhlu.DIMENSION_NAME'
                    ||          ' and flu.HIERARCHY_NAME  = dhlu.HIERARCHY_NAME'
                    ||          ' and flu.owner           = :1'     -- v_Cube_Owner 
                    ||          ' and flu.cube_name       = :2) x'  -- v_Cube_Name 
                    || ' where tt.SCHEMA_NAME(+)     = x.cube_owner'
                    || '   and tt.CUBE_NAME(+)       = x.cube_name'
                    || '   and tt.DIMENSION_NAME(+)  = x.dimension_name'
                    || '   and tt.DIMENSION_OWNER(+) = x.dimension_owner'
                    || '   and tt.LEVEL_NAME(+)      = x.level_name'
                    || ' order by dimension_owner'
                    ||         ' ,dimension_name'
                    ||         ' ,hierarchy_name'
                    ||         ' ,level_position';

 
  /*
  cwm2_olap_manager.Log_Note('Get_Level_Tuples' || ' v_Dynamic_Cursor1:' || v_Dynamic_Cursor1);
  */
    
  v_Cube_Count      := 0;
  v_Dimension_Count := 0;
  v_Hierarchy_Count := 0;

  DBMS_ODM.Add_Init;

  DBMS_ODM.Add_Begin;

  open c_Get_Level_Tuples for v_Dynamic_Cursor1 using v_Cube_Owner
                                                     ,v_Cube_Name;
  loop

    fetch c_Get_Level_Tuples into l_Cube_Owner
                                 ,l_Cube_Name 
                                 ,l_Dimension_Owner
                                 ,l_Dimension_Name
                                 ,l_Hierarchy_Name 
                                 ,l_Solvedcode 
                                 ,l_Level_Name 
                                 ,l_Level_Position;

    exit when c_Get_Level_Tuples%NOTFOUND;

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note('c_Get_Level_Tuples'
        || ' l_Cube_Owner:'      || l_Cube_Owner
        || ' l_Cube_Name:'       || l_Cube_Name
        || ' l_dimension_owner:' || l_dimension_owner
        || ' l_Dimension_Name:'  || l_Dimension_Name
        || ' l_Hierarchy_Name:'  || l_Hierarchy_Name
        || ' l_Solvedcode:'      || l_Solvedcode
        || ' l_Level_Position:'  || l_Level_Position
        || ' l_Level_Name:'      || l_Level_Name);
    end if;

    v_Cube_Count := v_Cube_Count + 1;

    DBMS_ODM.Add_Dimension(l_Cube_Owner
                          ,l_Cube_Name
                          ,l_dimension_owner
                          ,l_Dimension_Name
                          ,l_Hierarchy_Name
                          ,l_Solvedcode
                          ,l_Level_Position
                          ,l_Level_Name);

  end loop;

  close c_Get_Level_Tuples;

  if v_Cube_Count = 0
  then 
    /*
    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note('Get_Level_Tuples NOT FOUND');
    end if;
    */
    v_Status := V_STATUS_NOT_FOUND;
    v_Status_Message :=
      v_Tuples_Table_Owner || '.' || v_Tuples_Table_Name || '.' || v_Cube_Owner || '.' ||  v_Cube_Name;
    cwm2_olap_manager.Log_Message('not_found' ,'Cube' ,v_Status_Message);
    raise cwm2_olap_exceptions.Not_Found;
  end if;

-- ONE LEVEL ISSUE
  if v_Hierarchy_Count = 0
  then
    /*
    cwm2_olap_manager.Log_Note('Get_Level_Tuples NO HIERARCHY'
        || ' v_Hierarchy_Count:' ||  v_Hierarchy_Count);
    */
    v_Status := V_STATUS_NO_HIERARCHY;
    raise cwm2_olap_exceptions.internal_error;
  end if;

  if v_Highest_Level_In_Dimension < 2
  then
    /*
    cwm2_olap_manager.Log_Note('Get_Level_Tuples ALL LOWEST LEVEL' 
      || ' v_Highest_Level_In_Dimension;' || v_Highest_Level_In_Dimension);
    */
    v_Status := V_STATUS_ALL_LOWEST_LEVEL;
    raise cwm2_olap_exceptions.internal_error;
  end if;
-- ONE LEVEL ISSUE

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Get_Level_Tuples: '|| sqlerrm);
    end if;
    raise;
end Get_Level_Tuples;



procedure Report_Error is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Report_Error BEGIN' || ' v_Status:' || v_Status);
  end if;

  case v_Status 
  when v_STATUS_OK
  then
    return;

  when V_STATUS_NOT_FOUND
  then
    v_Status_Message := V_MV_CAN_NOT_BE_CREATED || 'Not found: ' || v_Status_Message;

  when V_STATUS_TOO_LARGE 
  then
    v_Status_Message := V_MV_CAN_NOT_BE_CREATED || 'The "CREATE MATERIALIZED VIEW" command will be too long.';

  when V_STATUS_ALL_LOWEST_LEVEL
  then
    v_Status_Message := V_MV_CAN_NOT_BE_CREATED || 'All levels are "LOWEST LEVEL".';

  when V_STATUS_NO_HIERARCHY
  then
    v_Status_Message := V_MV_CAN_NOT_BE_CREATED || 'No Hierarchies found.';

  when V_STATUS_NOT_UNSOLVED
  then
    v_Status_Message := V_MV_CAN_NOT_BE_CREATED || 'One or more Hierarchies is not "UNSOLVED LEVEL-BASED".';
    raise cwm2_olap_exceptions.internal_error;

  else
    v_Status_Message := V_MV_CAN_NOT_BE_CREATED || 'Undefined internal error "' || v_Status || '".';

  end case;
  
  if v_Status_Message is not null
  then
    v_Line_Type := V_LINE_TYPE_COMMENT;
    DBMS_ODM.Put_Line(v_Status_Message);

    cwm2_olap_manager.Log_Note(v_Status_Message);
  end if;

exception
  when others 
  then
    if v_Status = V_STATUS_OK
    then
      cwm2_olap_manager.Log_Note('Report_Error: '|| sqlerrm);
    end if;
    raise;
end Report_Error;



Procedure Generate_Dimension_MV(p_Hierarchy_Name varchar2) is

  begin
    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Generate_Dimension_MV BEGIN'
        || ' p_Hierarchy_Name:' || p_Hierarchy_Name
                                 );
    end if;

    v_MV_Type := V_MV_TYPE_DIMENSION;

    v_Materialized_View_Name := 'MV' || DBMS_ODM.Get_Mvseq;

    -- put comments 
    DBMS_ODM.Set_Segment(V_OUTPUT_SEGMENT_DIM_COMMENT);

    DBMS_ODM.Put_Copyright;

    DBMS_ODM.Put_Time;

    for c_Generate_Dimension_MV in (select  distinct
                                            owner               dimension_owner
                                           ,dimension_name
                                           ,hierarchy_name
                                           ,solvedcode                 
                                           -- ,parent_level_name
                                           ,child_level_name    level_name
                                           ,nvl(position ,1)    level_position
                                      from  olapsys.ODM$olap2udim_hier_level_uses 
                                      where owner          = v_Dimension_Owner
                                      and   dimension_name = v_Dimension_Name
                                      and   hierarchy_name = p_Hierarchy_Name
                                      order by dimension_owner          
                                              ,dimension_name           
                                              ,hierarchy_name           
                                              ,level_position)
    loop
       /*
      cwm2_olap_manager.Log_Note('c_Generate_Dimension_MV:'
        || ' ' || 'Dimension_Owner Name Hierarchy Solvedcode Position Level:'
        || ' ' ||  c_Generate_Dimension_MV.Dimension_Owner
        || ' ' ||  c_Generate_Dimension_MV.Dimension_Name
        || ' ' ||  c_Generate_Dimension_MV.Hierarchy_Name
        || ' ' ||  c_Generate_Dimension_MV.Solvedcode
        || ' ' ||  c_Generate_Dimension_MV.Level_Position
        || ' ' ||  c_Generate_Dimension_MV.Level_Name);
       */

      DBMS_ODM.Add_Dimension(null
                            ,null
                            ,c_Generate_Dimension_MV.Dimension_Owner
                            ,c_Generate_Dimension_MV.Dimension_Name
                            ,c_Generate_Dimension_MV.Hierarchy_Name
                            ,c_Generate_Dimension_MV.Solvedcode
                            ,c_Generate_Dimension_MV.Level_Position
                            ,c_Generate_Dimension_MV.Level_Name); 
    end loop;

    DBMS_ODM.Add_End;

    DBMS_ODM.Set_Partition_Range;

    DBMS_ODM.Set_Segment(V_OUTPUT_SEGMENT_DIM_CREATE);

    DBMS_ODM.Put_Create_MV;

    DBMS_ODM.Put_Partition_By_Range;
  
    DBMS_ODM.Put_MV_Tablespace;
                           
    DBMS_ODM.Put_Physical_Attributes;

    DBMS_ODM.Put_MV_Attributes;
                           
    DBMS_ODM.Put_Select;

    DBMS_ODM.Put_Count;

    DBMS_ODM.Put_Grouping_ID;

    DBMS_ODM.Put_Level_Attribute;

    DBMS_ODM.Put_Level;

    DBMS_ODM.Put_From;

    DBMS_ODM.Put_Where;

    DBMS_ODM.Put_Group_By;

    DBMS_ODM.Put_Time;

    DBMS_ODM.Set_Segment(V_OUTPUT_SEGMENT_DIM_INDEX);

    DBMS_ODM.Put_Gather_Table_Stats;

    DBMS_ODM.Alter_Table_Records_Per_Block; 

    --  DBMS_ODM.Alter_Table_Noparallel;  -- not in dimension mv

    DBMS_ODM.Get_Sys_Op_Base;

    DBMS_ODM.Put_Level_Bitmap_Index;

    DBMS_ODM.Put_Level_Parent_Bitmap_Index;

    DBMS_ODM.Put_Gid_Bitmap_Index;  

    DBMS_ODM.Put_Gid_Parent_Bitmap_Index;

    -- no case in et and etp if only one level.  this can be removed if we do not support one level mv
    if v_D_Table(1).v_H_Table(1).v_L_Table.count = 1
    then
      v_Put_Case := V_PUT_CASE_NO;
    else
      v_Put_Case := V_PUT_CASE_YES;
    end if;  -- if v_D_Table(1).v_H_Table(1).v_L_Table.count = 1

    DBMS_ODM.Put_ET_Bitmap_Index;  

    DBMS_ODM.Put_ET_Parent_Bitmap_Index;  

    DBMS_ODM.Put_Gather_Table_Stats;

    DBMS_ODM.Put_2_Blank_Line;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('Generate_Dimension_MV: '|| sqlerrm);
      end if;
      raise;
  end Generate_Dimension_MV;



Procedure Generate_Fact_MV is
  begin
    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Generate_Fact_MV BEGIN');
    end if;

    v_MV_Type := V_MV_TYPE_FACT;

    v_Materialized_View_Name := 'MV' || DBMS_ODM.Get_Mvseq;

    -- put comments 
    DBMS_ODM.Set_Segment(V_OUTPUT_SEGMENT_FACT_COMMENT);

    DBMS_ODM.Put_Copyright;

    DBMS_ODM.Put_Time;

    DBMS_ODM.Get_Level_Tuples;
      
    DBMS_ODM.Add_Measure;
      
    DBMS_ODM.Get_Aggregation_Name;

    DBMS_ODM.Add_End;

    DBMS_ODM.Set_Partition_Range;

    DBMS_ODM.Set_Segment(V_OUTPUT_SEGMENT_FACT_CREATE);

    DBMS_ODM.Put_Create_MV;

    DBMS_ODM.Put_Partition_By_Range;

    DBMS_ODM.Put_MV_Tablespace;

    DBMS_ODM.Put_Physical_Attributes;

    DBMS_ODM.Put_MV_Attributes;

    DBMS_ODM.Put_Select;

    DBMS_ODM.Put_Grouping_ID;

    DBMS_ODM.Put_Aggregation;

    DBMS_ODM.Put_Count;

    DBMS_ODM.Put_Level;

    DBMS_ODM.Put_From;

    DBMS_ODM.Put_Where;

    DBMS_ODM.Put_Group_By_Grouping_Set;

    DBMS_ODM.Put_Time;

    DBMS_ODM.Set_Segment(V_OUTPUT_SEGMENT_FACT_INDEX);

    DBMS_ODM.Put_Gather_Table_Stats;

    DBMS_ODM.Alter_Table_Records_Per_Block; 

    -- DBMS_ODM.Alter_Table_Noparallel;

    DBMS_ODM.Put_Level_Bitmap_Index;

    -- DBMS_ODM.Put_Level_Bitmap_Index;  -- no gid in fact

    -- DBMS_ODM.Put_Level_Parent_Bitmap_Index;  -- no parent in fact

    -- DBMS_ODM.Put_ET_Bitmap_Index;  -- no et in fact  

    DBMS_ODM.Put_Set_MV_Summary_Code;

    DBMS_ODM.Put_Time;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('Generate_Fact_MV: '|| sqlerrm);
      end if;
      raise;
  end Generate_Fact_MV;



procedure CreateDimLevTuple is
  begin

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'CreateDimLevTuple BEGIN');
    end if;

    v_Status := V_STATUS_OK;

    begin
      -- delete output table
      DBMS_ODM.Execute_Immediate('delete from ' || v_Levels_Table_Owner || '.' || v_Levels_Table_Name);
      DBMS_ODM.Execute_Immediate('commit');
    exception
      when others
      then
        /*
        cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'EXCEPTION DELETING LEVELS TABLE' || ' SQLERRM:' || SQLERRM);
        */
        if SQLCODE = -942 -- ORA-00942 table or view does not exist
        then
           -- create output table
           DBMS_ODM.Execute_Immediate('create table '
                                   || v_Levels_Table_Owner || '.' || v_Levels_Table_Name
                                   || ' of SYS.OlapLevel');
        else
          raise;
        end if;
    end;

    /* 
       the order of the rows in a sql table is undefined.  select commands from SYS.OlapTabLevels should contain 
       a 'order by' clause to order the rows but the table does not contain a hierarchy or position column 
       so that the rows can not be sorted in dimension/hierarchy/position order.  
    */

    v_Level_Count:= 0           ;
    v_Insert := 'insert into '
             || v_Levels_Table_Owner || '.'|| v_Levels_Table_Name
             || '(Schema_Name ,Dimension_Name ,Dimension_Owner ,Cube_Name ,Level_Name ,Selected)values'
             || '(:1          ,:2             ,:3              ,:4        ,:5         ,:6)';
      
    /*
    cwm2_olap_manager.Log_Note('CreateDimLevTuple' || ' v_Insert:' || v_Insert
    */

    for c_CreateDimLevTuple in (select  distinct
                                        cdu.owner
                                       ,cdu.dimension_name
                                       ,cdu.dimension_owner
                                       ,cdu.cube_name
                                     --,cdu.dimension_alias
                                     --,cdu.default_calc_hierarchy_name
                                     --,cdu.dependent_on_dim_use_id
                                     --
                                     --,dlu.owner
                                     --,dhlu.dimension_name
                                     --,dhlu.hierarchy_name
                                     --,dhlu.parent_level_name
                                       ,dhlu.child_level_name  
                                     --,dhlu.position     
                                  from  All_Olap2_Cube_Dim_Uses               cdu   
                                       ,olapsys.ODM$Olap2uDim_Hier_Level_Uses dhlu
                                 where cdu.Dimension_Owner = dhlu.Owner
                                   and cdu.Dimension_Name  = dhlu.Dimension_Name
                                   and cdu.Owner           = v_Cube_Owner
                                   and cdu.Cube_Name       = v_Cube_Name
                                 order by Dimension_Owner
                                         ,Dimension_Name
                                         ,Child_Level_Name)
    loop

      /*
      cwm2_olap_manager.Log_Note('CreateDimLevTuple'
        || ' :1:' || c_CreateDimLevTuple.owner 
        || ' :2:' || c_CreateDimLevTuple.dimension_name
        || ' :3:' || c_CreateDimLevTuple.dimension_owner
        || ' :4:' || c_CreateDimLevTuple.cube_name
        || ' :5:' || c_CreateDimLevTuple.child_level_name  
        || ' :6:' || 1);
      */

      execute immediate v_Insert
                  using c_CreateDimLevTuple.owner 
                       ,c_CreateDimLevTuple.dimension_name
                       ,c_CreateDimLevTuple.dimension_owner
                       ,c_CreateDimLevTuple.cube_name
                       ,c_CreateDimLevTuple.child_level_name  
                       ,1;

      v_Level_Count:= v_Level_Count + 1;

    end loop;
         
    commit;

    if v_Level_Count = 0
    then 
      v_Status := V_STATUS_NOT_FOUND;
      v_Status_Message := v_Cube_Owner || '.' || v_Cube_Name;
      cwm2_olap_manager.Log_Message('not_found' ,'Cube' ,v_Status_Message);
      raise cwm2_olap_exceptions.Not_Found;
    end if;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimLevTuple: ' || sqlerrm);
      else
        DBMS_ODM.Report_Error;
      end if;
      raise;
end CreateDimLevTuple;



procedure CreateCubeLevelTuple is
    c_CreateCubeLevelTuple t_Ref_Cursor;

    l_Cube_Owner           SYS.OlapTabLevels.schema_name%type                        := null;
    l_Cube_Name            SYS.OlapTabLevels.cube_name%type                          := null;
    l_dimension_owner      SYS.OlapTabLevels.dimension_owner%type                    := null;
    l_Dimension_Name       SYS.OlapTabLevels.dimension_name%type                     := null;

    l_Hierarchy_Name       olapsys.ODM$olap2udim_hier_level_uses.hierarchy_name%type := null;
    l_Solvedcode           olapsys.ODM$olap2udim_hier_level_uses.solvedcode%type     := null;
    l_Level_Position       olapsys.ODM$olap2udim_hier_level_uses.position%type       := null;

    l_Level_Name           SYS.OlapTabLevels.level_name%type                         := null;

  begin

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'CreateCubeLevelTuple BEGIN');
    end if;

    v_Status := V_STATUS_OK;

    -- create/recreate indexes to improve performance
    v_ID_Index_Name  := v_Tuples_Table_Name || 'ID';
    v_Sel_Index_Name := v_Tuples_Table_Name || 'Sel';

    begin
      -- delete output table
      DBMS_ODM.Execute_Immediate('delete from ' || v_Tuples_Table_Owner || '.' || v_Tuples_Table_Name);
      DBMS_ODM.Execute_Immediate('commit');
    exception
      when others
      then
        /*
        cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'EXCEPTION DELETING TUPLES TABLE' || ' SQLERRM:' || SQLERRM);
        */
        if SQLCODE = -942 -- ORA-00942 table or view does not exist
        then
           -- create output table
           DBMS_ODM.Execute_Immediate('create table '
                                   || v_Tuples_Table_Owner || '.' || v_Tuples_Table_Name
                                   || ' of SYS.OlapLevelTuple');
        else
          raise;
        end if;
    end;

/*??
    begin
       DBMS_ODM.Execute_Immediate('drop index ' || v_ID_Index_Name);
    exception
      when others 
      then
        / *
        cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'EXCEPTION DROPING ID INDEX' || ' SQLERRM:' || SQLERRM);
        * /
        null;
    end;

    begin
      DBMS_ODM.Execute_Immediate('drop index ' || v_Sel_Index_Name);
    exception
      when others 
      then
        / *
        cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'EXCEPTION DROPING SEL INDEX' || ' SQLERRM:' || SQLERRM);
        * /
        null;
    end;
??*/

    begin
      DBMS_ODM.Execute_Immediate('create index ' ||v_ID_Index_Name || ' on ' 
        || v_Tuples_Table_Owner || '.' || v_Tuples_Table_Name || ' (id)');
    exception
      when others
      then
        /*
        cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'EXCEPTION CREATING ID INDEX' || ' SQLERRM:' || SQLERRM);
        */
        if SQLCODE = -955   -- ORA-00955: name is already used by an existing objec
        or SQLCODE = -1408  -- ORA-01408: such column list already indexed
        or SQLCODE = -14452 -- ORA-14452: attempt to create, alter or drop an index on temporary table already
        then
          null;
        else
          raise;
        end if;
    end;

    begin
      DBMS_ODM.Execute_Immediate('create index ' || v_Sel_Index_Name || ' on ' 
        || v_Tuples_Table_Owner || '.' || v_Tuples_Table_Name || ' (selected ,dimension_owner ,dimension_name ,level_name)');
    exception
      when others
      then
        /*
        cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'EXCEPTION CREATING SEL INDEX' || ' SQLERRM:' || SQLERRM);
        */
        if SQLCODE = -955   -- ORA-00955: name is already used by an existing objec
        or SQLCODE = -1408  -- ORA-01408: such column list already indexed
        or SQLCODE = -14452 -- ORA-14452: attempt to create, alter or drop an index on temporary table already
        then
          null;
        else
          raise;
        end if;
    end;

    -- get all row included rows not selected so meta model will be complete
     v_Dynamic_Cursor1 := 'select distinct lt.schema_name         cube_owner'
                                     || ' ,lt.dimension_name      dimension_name'
                                     || ' ,lt.dimension_owner     dimension_owner'
                                     || ' ,lt.cube_name           cube_name'
                                     || ' ,lt.level_name          level_name'
                                  -- || ' ,lt.selected            selected'
                                  --
                                  -- || ' ,dhlu.owner             owner'
                                  -- || ' ,dhlu.dimension_name    dimension_name'
                                     || ' ,dhlu.hierarchy_name    hierarchy_name'
                                     || ' ,dhlu.solvedcode        solvedcode'
                                  -- || ' ,dhlu.parent_level_name parent_level_name'
                                  -- || ' ,dhlu.child_level_name  child_level_name'
                                     || ' ,nvl(dhlu.position ,1)  level_position'
                        || ' from ' || v_Levels_Table_Owner || '.' || v_Levels_Table_Name || ' lt'
                                 || ' ,olapsys.ODM$olap2udim_hier_level_uses dhlu'
                       || ' where lt.dimension_owner = dhlu.owner'
                         || ' and lt.dimension_name  = dhlu.dimension_name'
                         || ' and lt.level_name      = dhlu.child_level_name'
                         || ' and lt.schema_name     = :1'  -- v_Cube_Owner
                         || ' and lt.cube_name       = :2'  -- v_Cube_Name
                       || ' order by dimension_owner'          
                               || ' ,dimension_name'           
                               || ' ,hierarchy_name'           
                               || ' ,level_position';           

    /*
    cwm2_olap_manager.Log_Note('CreateCubeLevelTuple' || ' v_Dynamic_Cursor1:' || v_Dynamic_Cursor1); 
    */
    
    DBMS_ODM.Add_Init;

    DBMS_ODM.Add_Begin;

    open c_CreateCubeLevelTuple for v_Dynamic_Cursor1 using v_Cube_Owner
                                                          ,v_Cube_Name;
    loop

      fetch c_CreateCubeLevelTuple into l_Cube_Owner
                                       ,l_Dimension_Name
                                       ,l_dimension_owner
                                       ,l_Cube_Name 
                                       ,l_Level_Name 
                                       ,l_Hierarchy_Name
                                       ,l_Solvedcode 
                                       ,l_Level_Position;

      exit when c_CreateCubeLevelTuple%NOTFOUND;

      /*
      if v_Debug = V_YES then
        cwm2_olap_manager.Log_Note('CreateCubeLevelTuple'
          || ' l_Cube_Owner:'      || l_Cube_Owner
          || ' l_Cube_Name:'       || l_Cube_Name
          || ' l_dimension_owner:' || l_dimension_owner
          || ' l_Dimension_Name:'  || l_Dimension_Name
          || ' l_Hierarchy_Name:'  || l_Hierarchy_Name
          || ' l_Solvedcode:'      || l_Solvedcode
          || ' l_Level_Position:'  || l_Level_Position
          || ' l_Level_Name:'      || l_Level_Name);
      end if;
      */

      DBMS_ODM.Add_Dimension(l_Cube_Owner
                            ,l_Cube_Name
                            ,l_dimension_owner
                            ,l_Dimension_Name
                            ,l_Hierarchy_Name
                            ,l_Solvedcode
                            ,l_Level_Position
                            ,l_Level_Name);
    end loop;

    close c_CreateCubeLevelTuple;

    DBMS_ODM.Add_End;

    if v_D_Table.count = 0
    then
      v_Status := V_STATUS_NOT_FOUND;
      cwm2_olap_manager.Log_Message('parameter_not_valid' 
                                   ,'DIMENSION not valid in' 
                                   ,v_Levels_Table_Owner || '.' || v_Levels_Table_Name);
        raise cwm2_olap_exceptions.Parameter_Not_Valid;
    end if;

    -- init tables
    DBMS_ODM.Grouping_Init;

    v_ID        := 0;
    v_Finished  := 0;   
    while v_Finished = 0
    loop

      -- for each dimension test the current hierarchy level combination for level not selected and level same as
      v_Skip_Current_Combination := 0;
      for d in 1..v_D_Table.count
      loop

          /*
          cwm2_olap_manager.Log_Note('CreateDimLevTuple LOOP 111' || ' d:' || d || ' v_D_Table.count:' || v_D_Table.count);
          */
        v_H := v_D_Table(d).v_Current_H;
        v_L := v_D_Table(d).v_H_Table(v_H).v_Current_L;
        
          /*
          cwm2_olap_manager.Log_Note('CreateDimLevTuple LOOP 222' || ' d:' || d ||' v_H:' || v_H || ' v_L:'|| v_L);
          */

        if v_D_Table(d).v_H_Table(v_H).v_L_Table(v_L).v_Level_Same_As != 0  -- same as
        then
          v_Skip_Current_Combination := 1;
          exit;
        end if;
          /*
          cwm2_olap_manager.Log_Note('CreateDimLevTuple LOOP 333' || ' d:' || d);
          */
      end loop;  -- for d in 1..v_D_Table.count
  
      -- if not skiping combination insert the current l in the current h for each d
      if v_Skip_Current_Combination = 0 
      then

        v_ID := v_ID + 1;

        /*
        cwm2_olap_manager.Log_Note('CreateCubeLevelTuple v_ID:' || v_ID);
        */

        v_Insert := 'insert into '
                 || v_Tuples_Table_Owner || '.'|| v_Tuples_Table_Name
                 || '(ID ,Schema_Name ,Dimension_Name ,Dimension_Owner ,Cube_Name ,Level_Name ,Selected) values'
                 || '(:1 ,:2          ,:3             ,:4              ,:5        ,:6         ,:7)';
        /*
        cwm2_olap_manager.Log_Note('CreateDimLevTuple' || ' v_Insert:' || v_Insert);
        */


        for d in 1..v_Last_Dimension
        loop

          /*
          cwm2_olap_manager.Log_Note('CreateDimLevTuple LOOP' || ' d:' || d);
          */
          v_H := v_D_Table(d).v_Current_H;
          /*
          cwm2_olap_manager.Log_Note('CreateDimLevTuple v_H');
          */
          v_L := v_D_Table(d).v_H_Table(v_H).v_Current_L;

          /*
          cwm2_olap_manager.Log_Note('CreateDimLevTuple v_L');
          */
          execute immediate v_Insert
                      using v_ID
                           ,v_Cube_Owner
                           ,v_D_Table(d).v_Dimension_Name
                           ,v_D_Table(d).v_Dimension_Owner
                           ,v_Cube_Name
                           ,v_LN_Table(v_D_Table(d).v_H_Table(v_H).v_L_Table(v_L).v_Level_Name_ID).v_Level_Name
                           ,1;  -- level selected
        end loop;
      end if;  -- if v_Skip_Current_Combination = 0 


      -- next grouping.  
      DBMS_ODM.Grouping_Next;

      /*
      cwm2_olap_manager.Log_Note('CreateDimLevTuple AFTER NEXT' || ' v_Finished:' || v_Finished);
      */

    end loop;  -- while v_Finished = 0
    /*
    cwm2_olap_manager.Log_Note('CreateDimLevTuple AFTER LOOP');
    */

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateCubeLevelTuple: ' || sqlerrm);
      else
        DBMS_ODM.Report_Error;
      end if;
      raise;
end CreateCubeLevelTuple;



procedure CreateDimMV_GS is
  -- cycle through the hierarchies in a dimension and generate a mv for each one.  the tables are
  -- completely reloaded for each hierarchy.
  begin
    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'CreateDimMV_GS BEGIN');
    end if;

    -- full materialization of whatevery is in SYS.OlapTabLevelTuples
    v_Materialization_Level  := V_FULL;

    DBMS_ODM.Open_Output;

    DBMS_ODM.Add_Init;

    for c_CreateDimMV_GS in (select  distinct
                                      owner          dimension_owner
                                     ,dimension_name
                                     ,hierarchy_name
                                     ,solvedcode 
                                     -- ,child_level_name
                                     -- ,position
                               from  olapsys.ODM$olap2udim_hier_level_uses
                               where owner          = v_Dimension_Owner
                               and   dimension_name = v_Dimension_Name
                               order by owner
                                       ,dimension_name)
    loop
      /*
      cwm2_olap_manager.Log_Note('CreateDimMV_GS c_CreateDimMV_GS'
        || ' dimension_owner:'  || c_CreateDimMV_GS.dimension_owner
        || ' dimension_name:'   || c_CreateDimMV_GS.dimension_name
        || ' hierarchy_name:'   || c_CreateDimMV_GS.hierarchy_name
        || ' solvedcode:'       || c_CreateDimMV_GS.solvedcode);
      */

      -- delete the tables
      DBMS_ODM.Add_Begin;

      v_Procedure(v_Procedure_Hierarchy).v_Value := c_CreateDimMV_GS.hierarchy_name;

      DBMS_ODM.Generate_Dimension_MV(c_CreateDimMV_GS.hierarchy_name);

    end loop;

    if v_Dimension_Count = 0
    then
      /*
        cwm2_olap_manager.Log_Note('CreateDimMV_GS NOT FOUND');
      */
      v_Status := V_STATUS_NOT_FOUND;
      v_Status_Message := v_Dimension_Owner || '.' || v_Dimension_Name;
      cwm2_olap_manager.Log_Message('not_found' ,'Dimension' ,v_Dimension_Owner || '.' || v_Dimension_Name);
      raise cwm2_olap_exceptions.Not_Found;
    end if;

-- ONE LEVEL ISSUE
    if v_Hierarchy_Count = 0
    then
      /*
      cwm2_olap_manager.Log_Note('CreateDimMV_GS NO HIERARCHY');
      */
      v_Status := V_STATUS_NO_HIERARCHY;
      raise cwm2_olap_exceptions.internal_error;
    end if;

    if v_Highest_Level_In_Dimension < 2
    then
      /*
        cwm2_olap_manager.Log_Note('CreateDimMV_GS ALL LOWEST LEVEL'
          || ' v_Highest_Level_In_Dimension:' || v_Highest_Level_In_Dimension
                                   );
      */
      v_Status := V_STATUS_ALL_LOWEST_LEVEL;
      raise cwm2_olap_exceptions.internal_error;
    end if;
-- ONE LEVEL ISSUE

   DBMS_ODM.Close_Output;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimMV_GS: ' || sqlerrm);
      else
        DBMS_ODM.Report_Error;
      end if;
      DBMS_ODM.Close_Output;
      raise;
 end CreateDimMV_GS;



procedure CreateFactMV_GS is
  -- cycle through the cube and generate mv
  begin
    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'CreateFactMV_GS BEGIN');
    end if;

    DBMS_ODM.Open_Output;

    DBMS_ODM.Add_Init;

    DBMS_ODM.Add_Begin;

    DBMS_ODM.Generate_Fact_MV;

    DBMS_ODM.Close_Output;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateFactMV_GS: ' || sqlerrm);
      else
        DBMS_ODM.Report_Error;
      end if;
      DBMS_ODM.Close_Output;
      raise;
  end CreateFactMV_GS;



procedure CreateStdFactMV is
  -- cycle through the cube and generate the type of mv requested
  begin
 
    DBMS_ODM.Open_Output;

    DBMS_ODM.CreateDimLevTuple;

    DBMS_ODM.CreateCubeLevelTuple;

    DBMS_ODM.Add_Init;

    DBMS_ODM.Add_Begin;

    DBMS_ODM.Generate_Fact_MV;

    DBMS_ODM.Close_Output;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateStdFactMV: ' || sqlerrm);
      else
        DBMS_ODM.Report_Error;
      end if;
      DBMS_ODM.Close_Output;
      raise;
  end CreateStdFactMV;



procedure Create_Init is
  begin 
    /* 
      global variables are set to there init value on the first call to a procedure in a package.
      what happens on subsequent call to procedures in the same package is not defines.
    */

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'Create_Init BEGIN');
    end if;

    v_Start_Time         := null;
    v_Create_End_Time    := null;
    v_Index_End_Time     := null;

    v_Status             := null;

    v_Cube_Owner         := null;
    v_Cube_Name          := null;

    V_Levels_Table_Owner := V_DEFAULT_LEVELS_TABLE_OWNER;
    V_Levels_Table_Name  := V_DEFAULT_LEVELS_TABLE_NAME;

    V_Tuples_Table_Owner := V_DEFAULT_TUPLES_TABLE_OWNER;
    V_Tuples_Table_Name  := V_DEFAULT_TUPLES_TABLE_NAME;

    v_Dimension_Owner    := null;
    v_Dimension_Name     := null;

    V_Output_File        := null;
    v_Output_Path        := null;

    v_Partitioning       := V_PARTITION_TRUE; 

    v_Tablespace_MV      := null;
    v_Tablespace_Index   := null;

    v_Refresh_Method     := V_REFRESH_METHOD_FORCE;
    v_Refresh_On         := V_REFRESH_ON_DEMAND;
    v_Execute            := v_EXECUTE_FALSE;

    v_Run_ID             := null;

    v_Procedure.delete;

    v_Procedure.extend;
    v_Procedure_Name := v_Procedure.count;
    v_Procedure(v_Procedure_Name).v_Label := 'Procedure';

    v_Procedure.extend;
    v_Procedure_Cube_Owner := v_Procedure.count;
    v_Procedure(v_Procedure_Cube_Owner).v_Label := 'Cube Owner';

    v_Procedure.extend;
    v_Procedure_Cube_Name := v_Procedure.count;
    v_Procedure(v_Procedure_Cube_Name).v_Label := 'Cube Name';

    v_Procedure.extend;
    v_Procedure_Dimension_Owner := v_Procedure.count;
    v_Procedure(v_Procedure_Dimension_Owner).v_Label := 'Dimension Owner';

    v_Procedure.extend;
    v_Procedure_Dimension_Name := v_Procedure.count;
    v_Procedure(v_Procedure_Dimension_Name).v_Label := 'Dimension Name';

    v_Procedure.extend;
    v_Procedure_Levels_Table_Owner := v_Procedure.count;
    v_Procedure(v_Procedure_Levels_Table_Owner).v_Label := 'Levels Tables Owner';

    v_Procedure.extend;
    v_Procedure_Levels_Table_Name := v_Procedure.count;
    v_Procedure(v_Procedure_Levels_Table_Name).v_Label := 'Levels Tables Name';

    v_Procedure.extend;
    v_Procedure_Tuples_Table_Owner := v_Procedure.count;
    v_Procedure(v_Procedure_Tuples_Table_Owner).v_Label := 'Tuples Tables Owner';

    v_Procedure.extend;
    v_Procedure_Tuples_Table_Name := v_Procedure.count;
    v_Procedure(v_Procedure_Tuples_Table_Name).v_Label := 'Tuples Tables Name';

    v_Procedure.extend;
    v_Procedure_Output_File_Path := v_Procedure.count;
    v_Procedure(v_Procedure_Output_File_Path).v_Label := 'Output File Path';

    v_Procedure.extend;
    v_Procedure_Output_File_Name := v_Procedure.count;
    v_Procedure(v_Procedure_Output_File_Name).v_Label := 'Output File Name';

    v_Procedure.extend;
    v_Procedure_Partitioning := v_Procedure.count;
    v_Procedure(v_Procedure_Partitioning).v_Label := 'Partitioning';


    v_Procedure.extend;
    v_Procedure_Materializ_Level := v_Procedure.count;
    v_Procedure(v_Procedure_Materializ_Level).v_Label := 'Materialization Level';

    v_Procedure.extend;
    v_Procedure_Materializ_Percent := v_Procedure.count;
    v_Procedure(v_Procedure_Materializ_Percent).v_Label := 'Materialization Percent';

    v_Procedure.extend;
    v_Procedure_Tablespace_MV := v_Procedure.count;
    v_Procedure(v_Procedure_Tablespace_MV).v_Label := 'MV Tablespace';

    v_Procedure.extend;
    v_Procedure_Tablespace_Index := v_Procedure.count;
    v_Procedure(v_Procedure_Tablespace_Index).v_Label := 'Index Tablespace';

    v_Procedure.extend;
    v_Procedure_Refresh_Method := v_Procedure.count;
    v_Procedure(v_Procedure_Refresh_Method).v_Label := 'Refresh Method';

    v_Procedure.extend;
    v_Procedure_Refresh_On := v_Procedure.count;
    v_Procedure(v_Procedure_Refresh_On).v_Label := 'Refresh On';

    v_Procedure.extend;
    v_Procedure_Execute := v_Procedure.count;
    v_Procedure(v_Procedure_Execute).v_Label := 'Execute';

    v_Procedure.extend;
    v_Procedure_Hierarchy := v_Procedure.count;
    v_Procedure(v_Procedure_Hierarchy).v_Label := 'Hierarchy';

    for i in 1..v_Procedure.count
    loop
      v_Procedure(i).v_Value := null;
    end loop;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateInit: ' || sqlerrm);
      end if;
      raise;
  end Create_Init;

/* *********************************************************** */

-- PUBLIC PROCEDURES AND FUNCTIONS

procedure CreateDimLevTuple(p_Cube_Owner IN varchar2
                           ,p_Cube_Name  IN varchar2) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEDIMLEVTUPLE || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEDIMLEVTUPLE;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);

    v_Levels_Table_Owner := V_DEFAULT_LEVELS_TABLE_OWNER;
    v_Levels_Table_Name  := V_DEFAULT_LEVELS_TABLE_NAME;
 
    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    v_Materialization_Level  := V_FULL;

    DBMS_ODM.CreateDimLevTuple;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimLevTuple: ' || sqlerrm);
      end if;
      raise;
end CreateDimLevTuple;



procedure CreateDimLevTuple(p_Cube_Owner         IN varchar2
                           ,p_Cube_Name          IN varchar2
                           ,p_Levels_Table_Owner IN varchar2
                           ,p_Levels_Table_Name  IN varchar2) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEDIMLEVTUPLE || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEDIMLEVTUPLE;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Levels_Table(p_Levels_Table_Owner ,p_Levels_Table_Name);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    v_Materialization_Level  := V_FULL;

    DBMS_ODM.CreateDimLevTuple;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimLevTuple: ' || sqlerrm);
      end if;
      raise;
end CreateDimLevTuple;



procedure CreateCubeLevelTuple(p_Cube_Owner IN varchar2
                              ,p_Cube_Name  IN varchar2) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATECUBELEVELTUPLE || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATECUBELEVELTUPLE;

    -- check parameters, no wildcards
    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);

    v_Levels_Table_Owner := V_DEFAULT_LEVELS_TABLE_OWNER;
    v_Levels_Table_Name  := V_DEFAULT_LEVELS_TABLE_NAME; 
    v_Tuples_Table_Owner := V_DEFAULT_TUPLES_TABLE_OWNER;
    v_Tuples_Table_Name  := V_DEFAULT_TUPLES_TABLE_NAME; 

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    v_Materialization_Level := V_SELECTED;

    DBMS_ODM.CreateCubeLevelTuple;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateCubeLevelTuple: ' || sqlerrm);
      end if;
      raise;
end CreateCubeLevelTuple;



procedure CreateCubeLevelTuple(p_Cube_Owner         IN varchar2
                              ,p_Cube_Name          IN varchar2
                              ,p_Levels_Table_Owner IN varchar2
                              ,p_Levels_Table_Name  IN varchar2
                              ,p_Tuples_Table_Owner IN varchar2
                              ,p_Tuples_Table_Name  IN varchar2) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATECUBELEVELTUPLE || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATECUBELEVELTUPLE;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Levels_Table(p_Levels_Table_Owner ,p_Levels_Table_Name);
    DBMS_ODM.Test_P_Tuples_Table(p_Tuples_Table_Owner ,p_Tuples_Table_Name);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    v_Materialization_Level := V_SELECTED;

    DBMS_ODM.CreateCubeLevelTuple;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateCubeLevelTuple: ' || sqlerrm);
      end if;
      raise;
end CreateCubeLevelTuple;



procedure CreateDimMV_GS(p_Dimension_Owner  IN varchar2
                        ,p_Dimension_Name   IN varchar2
                        ,p_Output_File      IN varchar2
                        ,p_Output_Path      IN varchar2
                        ,p_Tablespace_MV    IN varchar2 default null
                        ,p_Tablespace_Index IN varchar2 default null) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEDIMMV_GS || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEDIMMV_GS;

    DBMS_ODM.Test_P_Dimension(p_Dimension_Owner ,p_Dimension_Name);
    DBMS_ODM.Test_P_Output(p_Output_File ,p_Output_Path);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateDimMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimMV_GS: ' || sqlerrm);
      end if;
      raise;
 end CreateDimMV_GS;



procedure CreateDimMV_GS(p_Dimension_Owner  IN varchar2
                        ,p_Dimension_Name   IN varchar2
                        ,p_Output_File      IN varchar2
                        ,p_Output_Path      IN varchar2
                        ,p_Partitioning     IN boolean  
                        ,p_Tablespace_MV    IN varchar2
                        ,p_Tablespace_Index IN varchar2) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEDIMMV_GS || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEDIMMV_GS;

    DBMS_ODM.Test_P_Dimension(p_Dimension_Owner ,p_Dimension_Name);
    DBMS_ODM.Test_P_Output(p_Output_File ,p_Output_Path);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateDimMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimMV_GS: ' || sqlerrm);
      end if;
      raise;
 end CreateDimMV_GS;



procedure CreateDimMV_GS(p_Dimension_Owner  IN varchar2
                        ,p_Dimension_Name   IN varchar2
                        ,p_Output_File      IN varchar2
                        ,p_Output_Path      IN varchar2
                        ,p_Partitioning     IN boolean  
                        ,p_Tablespace_MV    IN varchar2
                        ,p_Tablespace_Index IN varchar2
                        ,p_Refresh_Method   IN varchar2  -- 'FORCE', 'FAST, 'COMPLETE'
                        ,p_Refresh_On       IN varchar2  -- 'DEMAND', 'COMMIT'
                        ,p_Execute          IN boolean) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEDIMMV_GS || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEDIMMV_GS;

    DBMS_ODM.Test_P_Dimension(p_Dimension_Owner ,p_Dimension_Name);
    DBMS_ODM.Test_P_Output(p_Output_File ,p_Output_Path);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);
    DBMS_ODM.Test_P_Refresh(p_Refresh_Method ,p_Refresh_On); 
    DBMS_ODM.Test_P_Execute(p_Execute);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateDimMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimMV_GS: ' || sqlerrm);
      end if;
      raise;
 end CreateDimMV_GS;



procedure CreateFactMV_GS(p_Cube_Owner       IN varchar2 
                         ,p_Cube_Name        IN varchar2 
                         ,p_Output_File      IN varchar2 
                         ,p_Output_Path      IN varchar2 
                         ,p_Partitioning     IN boolean
                         ,p_Tablespace_MV    IN varchar2 default null
                         ,p_Tablespace_Index IN varchar2 default null) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEFACTMV_GS || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEFACTMV_GS;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Output(p_Output_File ,p_Output_Path);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    v_Materialization_Level := V_SELECTED;

    DBMS_ODM.CreateFactMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateFactMV_GS: ' || sqlerrm);
      end if;
      raise;
  end CreateFactMV_GS;



procedure CreateFactMV_GS(p_Cube_Owner         IN varchar2 
                         ,p_Cube_Name          IN varchar2 
                         ,p_Output_File        IN varchar2 
                         ,p_Output_Path        IN varchar2 
                         ,p_Tuples_Table_Owner IN varchar2
                         ,p_Tuples_Table_Name  IN varchar2
                         ,p_Partitioning       IN boolean
                         ,p_Tablespace_MV      IN varchar2 
                         ,p_Tablespace_Index   IN varchar2 
                         ,p_Refresh_Method     IN varchar2  -- 'FORCE', 'FAST, 'COMPLETE'
                         ,p_Refresh_On         IN varchar2  -- 'DEMAND', 'COMMIT'
                         ,p_Execute            IN boolean) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEFACTMV_GS || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEFACTMV_GS;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Output(p_Output_File ,p_Output_Path);
    DBMS_ODM.Test_P_Tuples_Table(p_Tuples_Table_Owner ,p_Tuples_Table_Name);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);
    DBMS_ODM.Test_P_Refresh(p_Refresh_Method ,p_Refresh_On); 
    DBMS_ODM.Test_P_Execute(p_Execute);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    v_Materialization_Level := V_SELECTED;

    DBMS_ODM.CreateFactMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateFactMV_GS: ' || sqlerrm);
      end if;
      raise;
  end CreateFactMV_GS;



procedure CreateStdFactMV(p_Cube_Owner            IN varchar2
                         ,p_Cube_Name             IN varchar2
                         ,p_Output_File           IN varchar2
                         ,p_Output_Path           IN varchar2
                         ,p_Partitioning          IN boolean
                         ,p_Materialization_Level IN varchar2
                         ,p_Materialization_Pct   IN number    default null 
                         ,p_Tablespace_MV         IN varchar2  default null
                         ,p_Tablespace_Index      IN varchar2  default null) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATESTDFACTMV || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATESTDFACTMV;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Output(p_Output_File ,p_Output_Path);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Materialization(p_Materialization_Level ,p_Materialization_Pct);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateStdFactMV;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateStdFactMV: ' || sqlerrm);
      end if;
      raise;
  end CreateStdFactMV;



procedure CreateStdFactMV(p_Cube_Owner            IN varchar2
                         ,p_Cube_Name             IN varchar2
                         ,p_Output_File           IN varchar2
                         ,p_Output_Path           IN varchar2
                         ,p_Partitioning          IN boolean
                         ,p_Materialization_Level IN varchar2
                         ,p_Materialization_Pct   IN number   
                         ,p_Tablespace_MV         IN varchar2 
                         ,p_Tablespace_Index      IN varchar2 
                         ,p_Refresh_Method        IN varchar2  -- 'FORCE', 'FAST, 'COMPLETE'
                         ,p_Refresh_On            IN varchar2  -- 'DEMAND', 'COMMIT'
                         ,p_Execute               IN boolean) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATESTDFACTMV || '(';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATESTDFACTMV;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Output(p_Output_File ,p_Output_Path);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Materialization(p_Materialization_Level ,p_Materialization_Pct);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);
    DBMS_ODM.Test_P_Refresh(p_Refresh_Method ,p_Refresh_On); 
    DBMS_ODM.Test_P_Execute(p_Execute);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateStdFactMV;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateStdFactMV: ' || sqlerrm);
      end if;
      raise;
  end CreateStdFactMV;



procedure ODM_VERSION is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'ODM_VERSION BEGIN');
  end if;
  cwm2_olap_manager.Log_Note('ORACLE CORP Copyright File DBMS_ODM Version ' || V_VERSION || ' date ' || V_VERSION_DATE);
end ODM_VERSION;


function ODMVERSION return varchar2 is
begin
  if v_Debug = V_YES then
    cwm2_olap_manager.Log_Note(DBMS_ODM.Get_Second || 'ODMVERSION BEGIN');
  end if;
  return V_VERSION;
end ODMVERSION;

-- create materialized views for oracle warehouse builder (owb)

procedure CreateDimOWB(p_Run_ID           IN number
                      ,p_Dimension_Owner  IN varchar2
                      ,p_Dimension_Name   IN varchar2) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEDIMOWB || '(' || p_Run_ID || ', ';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEDIMOWB;
    v_Run_ID                              := p_Run_ID;

    DBMS_ODM.Test_P_Dimension(p_Dimension_Owner ,p_Dimension_Name);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateDimMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimOWB: ' || sqlerrm);
      end if;
      raise;
end CreateDimOWB;


procedure CreateDimOWB(p_Run_ID           IN number
                      ,p_Dimension_Owner  IN varchar2
                      ,p_Dimension_Name   IN varchar2
                      ,p_Partitioning     IN boolean
                      ,p_Tablespace_MV    IN varchar2
                      ,p_Tablespace_Index IN varchar2
                      ,p_Refresh_Method   IN varchar2  -- 'FORCE', 'FAST, 'COMPLETE'
                      ,p_Refresh_On       IN varchar2  -- 'DEMAND', 'COMMIT'
                      ,p_Execute          IN boolean) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEDIMOWB || '(' || p_Run_ID || ', ';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEDIMOWB;
    v_Run_ID                              := p_Run_ID;

    DBMS_ODM.Test_P_Dimension(p_Dimension_Owner ,p_Dimension_Name);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);
    DBMS_ODM.Test_P_Refresh(p_Refresh_Method ,p_Refresh_On); 
    DBMS_ODM.Test_P_Execute(p_Execute);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateDimMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateDimOWB: ' || sqlerrm);
      end if;
      raise;
end CreateDimOWB;


procedure CreateFactOWB(p_Run_ID           IN number
                       ,p_Cube_Owner       IN varchar2
                       ,p_Cube_Name        IN varchar2) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEFACTOWB || '(' || p_Run_ID || ', ';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEFACTOWB;
    v_Run_ID                              := p_Run_ID;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    v_Materialization_Level := V_SELECTED;

    DBMS_ODM.CreateFactMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateFactOWB: ' || sqlerrm);
      end if;
      raise;
end CreateFactOWB;



procedure CreateFactOWB(p_Run_ID             IN number
                       ,p_Cube_Owner         IN varchar2
                       ,p_Cube_Name          IN varchar2
                       ,p_Tuples_Table_Owner IN varchar2
                       ,p_Tuples_Table_Name  IN varchar2
                       ,p_Partitioning       IN boolean
                       ,p_Tablespace_MV      IN varchar2 
                       ,p_Tablespace_Index   IN varchar2 
                       ,p_Refresh_Method     IN varchar2  -- 'FORCE', 'FAST, 'COMPLETE'
                       ,p_Refresh_On         IN varchar2  -- 'DEMAND', 'COMMIT'
                       ,p_Execute            IN boolean) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATEFACTOWB || '(' || p_Run_ID || ', ';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATEFACTOWB;
    v_Run_ID                              := p_Run_ID;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Tuples_Table(p_Tuples_Table_Owner ,p_Tuples_Table_Name);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);
    DBMS_ODM.Test_P_Refresh(p_Refresh_Method ,p_Refresh_On);
    DBMS_ODM.Test_P_Execute(p_Execute);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    v_Materialization_Level := V_SELECTED;

    DBMS_ODM.CreateFactMV_GS;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateFactOWB: ' || sqlerrm);
      end if;
      raise;
end CreateFactOWB;



procedure CreateStdFactMVOWB(p_Run_ID                IN number
                            ,p_Cube_Owner            IN varchar2
                            ,p_Cube_Name             IN varchar2
                            ,p_Materialization_Level IN varchar2
                            ,p_Materialization_Pct   IN number   default null) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATESTDFACTMVOWB || '(' || p_Run_ID || ', ';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATESTDFACTMVOWB;
    v_Run_ID                              := p_Run_ID;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Materialization(p_Materialization_Level ,p_Materialization_Pct);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateStdFactMV;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateStdFactMVOWB: ' || sqlerrm);
      end if;
      raise;
end CreateStdFactMVOWB;



procedure CreateStdFactMVOWB(p_Run_ID                IN number
                            ,p_Cube_Owner            IN varchar2
                            ,p_Cube_Name             IN varchar2
                            ,p_Partitioning          IN boolean
                            ,p_Materialization_Level IN varchar2
                            ,p_Materialization_Pct   IN number  
                            ,p_Tablespace_MV         IN varchar2
                            ,p_Tablespace_Index      IN varchar2 
                            ,p_Refresh_Method        IN varchar2  -- 'FORCE', 'FAST, 'COMPLETE'
                            ,p_Refresh_On            IN varchar2  -- 'DEMAND', 'COMMIT'
                            ,p_Execute               IN boolean) is
  begin
    DBMS_ODM.Create_Init; 

    v_Command                             := V_CREATESTDFACTMVOWB || '(' || p_Run_ID || ', ';
    v_Procedure(v_Procedure_Name).v_Value := V_CREATESTDFACTMVOWB;
    v_Run_ID                              := p_Run_ID;

    DBMS_ODM.Test_P_Cube(p_Cube_Owner ,p_Cube_Name);
    DBMS_ODM.Test_P_Partitioning(p_Partitioning);
    DBMS_ODM.Test_P_Materialization(p_Materialization_Level ,p_Materialization_Pct);
    DBMS_ODM.Test_P_Tablespace(p_Tablespace_MV ,p_Tablespace_Index);
    DBMS_ODM.Test_P_Refresh(p_Refresh_Method ,p_Refresh_On); 
    DBMS_ODM.Test_P_Execute(p_Execute);

    v_Command := v_Command || ')';

    if v_Debug = V_YES then
      cwm2_olap_manager.Log_Note(v_Command);
    end if;

    DBMS_ODM.CreateStdFactMV;

  exception
    when others 
    then
      if v_Status = V_STATUS_OK
      then
        cwm2_olap_manager.Log_Note('CreateStdFactMVOWB: ' || sqlerrm);
      end if;
      raise;
end CreateStdFactMVOWB;



end;  -- cwmlite/src/api/olapodm.sql
/

show errors;

 
