Rem
Rem $Header: oneuser.sql 27-oct-2003.11:21:34 cdalessi Exp $
Rem
Rem oneuser.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      oneuser.sql
Rem
Rem    DESCRIPTION
Rem      Create metadata owner schema 'OLAPSYS' with default password 'MANAGER'
Rem
Rem    NOTES
Rem      Must be run as 'SYS' and requires paramaters for default and
Rem      temporary tablespace.  
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    04/11/01 - B1716330: Add parameter for default temporary tab
Rem    dallan      06/23/00 - Add parameter for tablespace, created in DBCA.
Rem    dthompso    04/27/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

create user olapsys identified by manager 
default tablespace &1 
temporary tablespace &2  
quota unlimited on &1
/

grant connect, resource to olapsys
/

grant create table, create view, create procedure, create sequence, create public synonym, drop public synonym to olapsys
/

grant select on sys.obj$ to olapsys with grant option
/

grant select on sys.dim$ to olapsys with grant option
/

grant select on sys.con$ to olapsys with grant option
/

grant select on sys.col$ to olapsys with grant option
/

grant select on sys.ccol$ to olapsys with grant option
/

grant select on sys.cdef$ to olapsys with grant option
/

grant select on sys.user$ to olapsys with grant option
/

grant select on sys.dimlevel$ to olapsys with grant option
/

grant select on sys.dimlevelkey$ to olapsys with grant option
/

grant select on sys.dimjoinkey$ to olapsys with grant option
/

grant select on sys.dimattr$ to olapsys with grant option
/

grant select on sys.hier$ to olapsys with grant option
/

grant select on sys.hierlevel$ to olapsys with grant option
/

grant select on sys.dependency$ to olapsys with grant option
/

grant select on sys.objauth$ to olapsys with grant option
/

grant select on sys.sysauth$ to olapsys with grant option
/

grant select on sys.v_$enabledprivs to olapsys with grant option
/

grant execute on sys.dbms_lock to olapsys
/

grant create public synonym to olapsys
/

grant drop public synonym to olapsys
/

grant create library to olapsys
/

