Rem
Rem $Header: onevacdu.sql 27-oct-2003.11:21:37 cdalessi Exp $
Rem
Rem onevacdu.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevacdu.sql - all$olap_cube_dim_uses
Rem
Rem    DESCRIPTION
Rem      Dimension uses within a cube.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_cube_dim_uses AS SELECT
  cdu.irid cube_dimension_use_id
, sch.physicalname owner
, cub.physicalname cube_name
, cdu.dimension_owner
, cdu.dimension_name
, cdu.name dimension_alias
, cdu.cubedimensionuse_irid dependent_on_dim_use_id
, cdu.calc_hierarchy_name default_calc_hierarchy_name
FROM
  sys.user$ u
, cwm$model sch
, cwm$cube cub
, cwm$cubedimensionuse cdu
WHERE u.name = sch.physicalname
AND sch.irid = cub.datamodel_irid
AND (    cwm$util.fact_table_visible(cub.irid) = 'Y'
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
AND cub.irid = cdu.cube_irid
WITH READ ONLY
/
