Rem
Rem $Header: onevaceu.sql 27-oct-2003.11:21:39 cdalessi Exp $
Rem
Rem onevaceu.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevaceu.sql - all$olap_catalog_entity_uses
Rem
Rem    DESCRIPTION
Rem      Uses of measures within a catalog.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    07/19/00 - use correct classificationentry
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_catalog_entity_uses AS SELECT 
  ce.classification_irid catalog_id
, sch.physicalname entity_owner
, cub.physicalname entity_name
, msr.physicalname child_entity_name
FROM
  cwm$classification c
, cwm$classificationentry ce
, cwm$classificationtype cty
, cwm$measure msr
, cwm$cube cub
, cwm$model sch
, sys.user$ u
WHERE cty.irid = c.classificationtype_irid
AND cty.name = 'ORACLE_OLAP_CATALOG'
AND c.irid = ce.classification_irid
AND ce.name = 'MEASURE'    
AND ce.element_irid = msr.irid
AND msr.itemcontainer_irid = cub.irid
AND sch.irid = cub.datamodel_irid
AND sch.physicalname = u.name
AND (    cwm$util.fact_table_visible(cub.irid) = 'Y'
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
WITH READ ONLY
/
