Rem
Rem $Header: onevacmm.sql 27-oct-2003.11:21:40 cdalessi Exp $
Rem
Rem onevacmm.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevacmm.sql - all$olap_cube_measure_maps
Rem
Rem    DESCRIPTION
Rem      Mapping of cube measures to fact table column.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_cube_measure_maps AS SELECT 
  sch.physicalname owner
, cub.physicalname cube_name
, msr.physicalname measure_name
, use2.object_owner fact_table_owner
, use2.object_name fact_table_name
, use2.secondary_object_name column_name
FROM
  sys.user$ u
, cwm$model sch
, cwm$cube cub
, cwm$measure msr
, cwm$itemuse use1
, cwm$itemuse use2
WHERE u.name = sch.physicalname 
AND sch.irid = cub.datamodel_irid
AND (    cwm$util.fact_table_visible(cub.irid) = 'Y'
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
AND cub.irid = msr.itemcontainer_irid
AND msr.irid = use1.mappable_irid
AND use1.operation_irid = use2.operation_irid_1
WITH READ ONLY
/
