Rem
Rem $Header: onevafk.sql 27-oct-2003.11:21:53 cdalessi Exp $
Rem
Rem onevafk.sql
Rem
Rem Copyright (c) 1900, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevafk.sql - all$olap_foreign_keys
Rem
Rem    DESCRIPTION
Rem      Physical foreign key constraints
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_foreign_keys AS SELECT 
  u.name owner
, t.name table_name
, c.name foreign_key_name
, decode(bitand(cd.defer,32),32, 'Y', 'N') is_rely
FROM
  sys.user$ u
, sys.obj$ t
, sys.con$ c
, sys.cdef$ cd
WHERE u.user# = t.owner#
AND t.type# IN (2,4) /* table, view */
AND t.obj# = cd.obj#
AND cd.con# = c.con#
AND cd.type# = 4 /* referential */
AND (   t.owner# = UID
     OR t.obj# IN 
       (SELECT obj# FROM sys.objauth$ 
        WHERE (   grantee# = UID
               OR grantee# IN 
                 (SELECT privilege# 
                  FROM sys.sysauth$ 
                  WHERE privilege# > 0
                  START WITH grantee# = UID 
                  CONNECT BY PRIOR privilege# = grantee#)))
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
WITH READ ONLY
/
