Rem
Rem $Header: onevafnu.sql 27-oct-2003.11:21:58 cdalessi Exp $
Rem
Rem onevafnu.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevafnu.sql - all$olap_function_usages
Rem
Rem    DESCRIPTION
Rem      Use of a function as an aggregation method
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_function_usages AS SELECT 
  u.irid function_usage_id
, f.name function_name
FROM
  cwm$function f
, cwm$functionuse u
, cwm$measuredimensionuse mdu
, cwm$measure msr
WHERE f.irid = u.function_irid
AND u.measuredimensionuse_irid = mdu.irid
AND mdu.measure_irid = msr.irid
AND (    cwm$util.fact_table_visible(msr.itemcontainer_irid) = 'Y'
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
UNION ALL SELECT
  u.irid function_usage_id
, f.name function_name
FROM
  cwm$function f
, cwm$functionuse u 
WHERE f.irid = u.function_irid
AND u.measuredimensionuse_irid IS NULL
WITH READ ONLY
/
