Rem
Rem $Header: onevahie.sql 27-oct-2003.11:22:00 cdalessi Exp $
Rem
Rem onevahie.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevahie.sql - all$olap_dim_hierarchies
Rem
Rem    DESCRIPTION
Rem      Dimension Hierarchies
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_dim_hierarchies AS SELECT 
  u.name owner
, d.name dimension_name
, h.hiername hierarchy_name
, hie.displayname display_name
, hie.description description
FROM 
  sys.user$ u
, sys.obj$ d
, sys.hier$ h
, cwm$hierarchy hie
WHERE u.user# = d.owner#
AND d.type# = 43 /* DIMENSION */
AND (   cwm$util.dimension_tables_visible(d.obj#) = 'Y'
     OR EXISTS /* SELECT ANY TABLE, CREATE, ALTER, DROP ANY DIMENSION */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number IN (-47,-215,-216,-217)))
AND d.obj# = h.dimobj#
AND h.dimobj# = hie.dimension_irid (+)
AND h.hiername = hie.name (+)
WITH READ ONLY
/
