Rem
Rem $Header: onevajkc.sql 27-oct-2003.11:22:02 cdalessi Exp $
Rem
Rem onevajkc.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevajkc.sql - all$olap_join_key_column_uses
Rem
Rem    DESCRIPTION
Rem      Logical join key between hierarchy level use and the dimension
Rem      columns making up the relationship. For a snowflake schema this may
Rem      be a logical foreign key representing the join between 2 dimension
Rem      tables otherwise it is the lower level column key.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_join_key_column_uses AS SELECT /*+ORDERED*/
  u.name owner
, d.name dimension_name
, h.hiername hierarchy_name
, l.levelname child_level_name
, tu.name table_owner
, t.name table_name
, c.name column_name
, k.keypos# position
, 'FOREIGN KEY' join_key_type
FROM
  sys.user$ u
, sys.obj$ d
, sys.hier$ h
, sys.hierlevel$ hl
, sys.dimlevel$ l
, sys.dimjoinkey$ k
, sys.user$ tu
, sys.obj$ t
, sys.col$ c
WHERE u.user# = d.owner#
AND d.type# = 43 /* DIMENSION */
AND (   cwm$util.dimension_tables_visible(d.obj#) = 'Y'
     OR EXISTS /* SELECT ANY TABLE, CREATE, ALTER, DROP ANY DIMENSION */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number IN (-47,-215,-216,-217)))
AND d.obj# = h.dimobj#
AND h.dimobj# = hl.dimobj#
AND h.hierid# = hl.hierid#
AND hl.dimobj# = l.dimobj#
AND hl.levelid# = l.levelid#
AND hl.dimobj# = k.dimobj#
AND hl.hierid# = k.hierid#
AND hl.joinkeyid# = k.joinkeyid#
AND k.detailobj# = t.obj#
AND k.col# = c.col#
AND t.obj# = c.obj#
AND t.owner# = tu.user#
UNION ALL SELECT /*+ORDERED*/
  u.name owner
, d.name dimension_name
, h.hiername hierarchy_name
, l.levelname child_level_name
, tu.name table_owner
, t.name table_name
, c.name column_name
, k.keypos# position
, 'KEY' join_key_type
FROM
  sys.user$ u
, sys.obj$ d
, sys.hier$ h
, sys.hierlevel$ hl
, sys.dimlevel$ l
, sys.dimlevelkey$ k
, sys.user$ tu
, sys.obj$ t
, sys.col$ c
WHERE u.user# = d.owner#
AND d.type# = 43 /* DIMENSION */
AND (   cwm$util.dimension_tables_visible(d.obj#) = 'Y'
     OR EXISTS /* SELECT ANY TABLE, CREATE, ALTER, DROP ANY DIMENSION */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number IN (-47,-215,-216,-217))) 
AND d.obj# = h.dimobj#
AND h.dimobj# = hl.dimobj#
AND h.hierid# = hl.hierid#
AND hl.dimobj# = l.dimobj#
AND hl.levelid# = l.levelid#
AND hl.joinkeyid# = 0
AND l.dimobj# = k.dimobj#
AND l.levelid# = k.levelid#
AND k.detailobj# = t.obj#
AND k.col# = c.col#
AND t.obj# = c.obj#
AND t.owner# = tu.user#
WITH READ ONLY
/
