Rem
Rem $Header: onevakey.sql 27-oct-2003.11:22:04 cdalessi Exp $
Rem
Rem onevakey.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevakey.sql - all$olap_keys
Rem
Rem    DESCRIPTION
Rem      Physical keys, ie primary and unique.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_keys AS SELECT 
  u.name owner
, t.name table_name
, c.name key_name
, decode(bitand(cd.defer,32),32, 'Y', 'N') is_rely
FROM
  sys.user$ u
, sys.obj$ t
, sys.con$ c
, sys.cdef$ cd
WHERE u.user# = t.owner#
AND t.type# IN (2,4) /* table, view */
AND t.obj# = cd.obj#
AND cd.con# = c.con#
AND cd.type# IN (2, 3) /* primary, unique */
AND (   t.owner# = UID
     OR t.obj# IN 
       (SELECT obj# FROM sys.objauth$ 
        WHERE (   grantee# = UID
               OR grantee# IN 
                 (SELECT privilege# 
                  FROM sys.sysauth$ 
                  WHERE privilege# > 0
                  START WITH grantee# = UID 
                  CONNECT BY PRIOR privilege# = grantee#)))
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
WITH READ ONLY
/
