Rem
Rem $Header: onevalkc.sql 27-oct-2003.11:22:08 cdalessi Exp $
Rem
Rem onevalkc.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevalkc.sql - all$olap_level_key_column_uses
Rem
Rem    DESCRIPTION
Rem      Mapping of dimension levels to dimension table columns.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_level_key_column_uses AS SELECT /*+ORDERED*/
  u.name owner
, d.name dimension_name
, l.levelname level_name
, c.name column_name
, k.keypos# position
FROM
  sys.user$ u
, sys.obj$ d
, sys.dimlevel$ l
, sys.dimlevelkey$ k
, sys.col$ c
WHERE u.user# = d.owner#
AND d.type# = 43 /* DIMENSION */
AND (   cwm$util.dimension_tables_visible(d.obj#) = 'Y'
     OR EXISTS /* SELECT ANY TABLE, CREATE, ALTER, DROP ANY DIMENSION */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number IN (-47,-215,-216,-217)))
AND d.obj# = l.dimobj#
AND l.dimobj# = k.dimobj#
AND l.levelid# = k.levelid#
AND k.detailobj# = c.obj#
AND k.col# = c.col#
WITH READ ONLY
/
