Rem
Rem $Header: onevatab.sql 27-oct-2003.11:22:13 cdalessi Exp $
Rem
Rem onevatab.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevatab.sql - all$olap_tables
Rem
Rem    DESCRIPTION
Rem      Tables and Views.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    08/21/00 - add table_type column
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_tables AS SELECT 
  u.name owner
, t.name table_name
, decode (t.type#, 2, 'TABLE', 'VIEW') table_type 
FROM
  sys.user$ u
, sys.obj$ t
WHERE u.user# = t.owner#
AND t.type# IN (2,4)
AND (   t.owner# = UID
     OR t.obj# IN 
       (SELECT obj# FROM sys.objauth$ 
        WHERE (   grantee# = UID
               OR grantee# IN 
                 (SELECT privilege# 
                  FROM sys.sysauth$ 
                  WHERE privilege# > 0
                  START WITH grantee# = UID 
                  CONNECT BY PRIOR privilege# = grantee#)))
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
WITH READ ONLY
/
