Rem
Rem $Header: onevdcmm.sql 27-oct-2003.11:22:18 cdalessi Exp $
Rem
Rem onevdcmm.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevdcmm.sql - dba$olap_cube_measure_maps
Rem
Rem    DESCRIPTION
Rem      Mapping of cube measures to fact table columns.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_cube_measure_maps AS SELECT 
  sch.physicalname owner
, cub.physicalname cube_name
, msr.physicalname measure_name
, use2.object_owner fact_table_owner
, use2.object_name fact_table_name
, use2.secondary_object_name column_name
FROM
  sys.user$ u  
, cwm$model sch
, cwm$cube  cub
, cwm$measure msr
, cwm$itemuse use1
, cwm$itemuse use2
WHERE u.name = sch.physicalname 
AND sch.irid = cub.datamodel_irid
AND cub.irid = msr.itemcontainer_irid
AND msr.irid = use1.mappable_irid
AND use1.operation_irid = use2.operation_irid_1
WITH READ ONLY
/
