Rem
Rem $Header: onevdflu.sql 27-oct-2003.11:22:28 cdalessi Exp $
Rem
Rem onevdflu.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevdflu.sql - dba$olap_fact_level_uses
Rem
Rem    DESCRIPTION
Rem      Mapping of each cube dimension use to the foreign key
Rem      relationship between fact and dimension tables. Also identifies
Rem      the Level considered to be the lowest level of aggregation.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_fact_level_uses AS SELECT 
  sch.name owner
, cub.name cube_name
, cdu.dimension_owner
, cdu.dimension_name
, cdu.name dimension_alias
, flu.level_name
, fu.object_owner fact_table_owner
, fu.object_name fact_table_name
, flu.foreign_key_name
FROM 
  cwm$factuse fu
, cwm$facttablemap fm
, cwm$model sch
, cwm$cube  cub
, sys.user$ u    
, cwm$cubedimensionuse cdu
, cwm$factleveluse flu
WHERE u.name = sch.physicalname
AND sch.irid = cub.datamodel_irid
AND cub.irid = cdu.cube_irid
AND cdu.irid = flu.cubedimensionuse_irid
AND fm.mapcontainer_irid = cub.irid
AND fu.operation_irid_1 = fm.irid
WITH READ ONLY
/
