Rem
Rem $Header: onevdhlu.sql 27-oct-2003.11:22:37 cdalessi Exp $
Rem
Rem onevdhlu.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevdhlu.sql - dba$olap_dim_hier_level_uses
Rem
Rem    DESCRIPTION
Rem     Dimension Levels used within a hierarchy
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_dim_hier_level_uses AS SELECT 
  u.name owner
, d.name dimension_name
, h.hiername hierarchy_name
, pdl.levelname parent_level_name
, cdl.levelname child_level_name
, chl.pos# position
FROM 
  sys.user$ u
, sys.obj$ d
, sys.hier$ h
, sys.hierlevel$ phl
, sys.hierlevel$ chl
, sys.dimlevel$ pdl
, sys.dimlevel$ cdl
WHERE d.type# = 43 /* DIMENSION */
AND u.user# = d.owner#
AND d.obj# = h.dimobj#
AND d.obj# = phl.dimobj#
AND h.hierid# = phl.hierid#
AND d.obj# = pdl.dimobj#
AND phl.levelid# = pdl.levelid#
AND d.obj# = chl.dimobj#
AND h.hierid# = chl.hierid#
AND chl.levelid# = cdl.levelid#
AND d.obj# = cdl.dimobj#
AND phl.pos# = chl.pos# + 1
WITH READ ONLY
/
