Rem
Rem $Header: onevdlat.sql 27-oct-2003.11:22:44 cdalessi Exp $
Rem
Rem onevdlat.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevdlat.sql - dba$olap_dim_level_attributes
Rem
Rem    DESCRIPTION
Rem      Attribute of dimension levels
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    01/18/01 - B1503215 : fix for no duplicates when determined
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_dim_level_attributes AS SELECT 
  a.u_name owner
, a.d_name dimension_name
, nvl(la.lat_name, a.c_name) attribute_name
, la.lat_displayname display_name
, la.lat_description description
, a.l_levelname determined_by_level_name
FROM 
 (SELECT /*+ ORDERED*/
    u.name u_name
  , d.name d_name
  , l.dimobj# l_dimobj#  
  , l.levelname l_levelname
  , c.obj# c_obj#
  , c.name c_name
 FROM
    sys.user$ u
  , sys.obj$ d
  , sys.dimlevel$ l
  , sys.dimattr$ a
  , sys.col$ c
  WHERE d.type# = 43 /* DIMENSION */
  AND u.user# = d.owner#
  AND d.obj# = l.dimobj#
  AND l.dimobj# = a.dimobj#
  AND l.levelid# = a.levelid# 
  AND a.detailobj# = c.obj#
  AND a.col# = c.col#) a
, (SELECT
    lat.name lat_name
    , lat.displayname lat_displayname
    , lat.description lat_description
    , lat.type_irid lat_type_irid
    , lat.physicalname lat_physicalname
    , lev.dimension_irid lev_dimension_irid
    , lev.physicalname lev_physicalname
  FROM cwm$level lev, cwm$levelattribute lat
  WHERE lev.irid = lat.itemcontainer_irid) la
WHERE a.l_dimobj# = la.lev_dimension_irid (+)
AND a.l_levelname = la.lev_physicalname (+)
AND a.c_obj# = la.lat_type_irid (+)
AND a.c_name = la.lat_physicalname (+)   
WITH READ ONLY
/
