Rem
Rem $Header: onevdmdu.sql 27-oct-2003.11:22:48 cdalessi Exp $
Rem
Rem onevdmdu.sql
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      onevdmdu.sql - dba$olap_cube_measure_dim_uses
Rem
Rem    DESCRIPTION
Rem      Intersection of cube dimension use and measure where a default
Rem      aggregation method has been specified.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdalessi    10/27/03 - upgrade to 9.2.0.5.0 
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_cube_measure_dim_uses AS SELECT 
  sch.physicalname owner
, cub.physicalname cube_name
, msr.physicalname measure_name
, cdu.dimension_owner
, cdu.dimension_name
, cdu.name dimension_alias
, fu.irid default_aggr_function_use_id
FROM
  sys.user$ u
, cwm$model sch
, cwm$cube  cub
, cwm$measure msr
, cwm$measuredimensionuse mdu
, cwm$cubedimensionuse cdu
, cwm$functionuse fu
WHERE u.name = sch.physicalname
AND sch.irid = cub.datamodel_irid
AND cub.irid = msr.itemcontainer_irid
AND msr.irid = mdu.measure_irid
AND mdu.cubedimensionuse_irid = cdu.irid
AND mdu.irid = fu.measuredimensionuse_irid (+)
WITH READ ONLY
/
