## java.mk
.SUFFIXES: .java .class .sqlj

.java.class:
	javac -g -classpath $(MAKE_CLASSPATH) $<

.sqlj.class:
	sqlj -classpath $(MAKE_CLASSPATH) -ser2class  $<

# jdk11 classpath
JDK11_CLASSPATH = ".$(PATHSEP)${JAVA_HOME}$(DIRSEP)lib$(DIRSEP)classes.zip$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)aurora_client.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)jdbc$(DIRSEP)lib$(DIRSEP)classes111.zip$(PATHSEP)${ORACLE_HOME}$(DIRSEP)sqlj$(DIRSEP)lib$(DIRSEP)translator.zip$(DIRSEP)sqlj$(DIRSEP)lib$(DIRSEP)runtime11.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)vbjorb.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)vbjapp.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)mts.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)javavm$(DIRSEP)lib$(DIRSEP)aurora.zip$(PATHSEP)${ORACLE_HOME}$(DIRSEP)javavm$(DIRSEP)utl$(DIRSEP)ejb$(DIRSEP)lib$(DIRSEP)vbj30ssl.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)jlib$(DIRSEP)javax-ssl-1_1.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)jlib$(DIRSEP)jssl-1_1.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)servlet.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)http_client.jar$(PATHSEP)${ORACLE_HOME$(DIRSEP)lib$(DIRSEP)http_server.jar"

# jdk12 classpath
JDK12_CLASSPATH = ".$(PATHSEP)${JAVA_HOME}$(DIRSEP)jre$(DIRSEP)lib$(DIRSEP)rt.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)aurora_client.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)jdbc$(DIRSEP)lib$(DIRSEP)classes12.zip$(PATHSEP)${ORACLE_HOME}$(DIRSEP)sqlj$(DIRSEP)lib$(DIRSEP)translator.zip$(PATHSEP)${ORACLE_HOME}$(DIRSEP)sqlj$(DIRSEP)lib$(DIRSEP)runtime12.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)vbjorb.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)vbjapp.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)mts.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)javavm$(DIRSEP)lib$(DIRSEP)aurora.zip$(PATHSEP)${ORACLE_HOME}$(DIRSEP)javavm$(DIRSEP)utl$(DIRSEP)ejb$(DIRSEP)lib$(DIRSEP)vbj30ssl.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)jlib$(DIRSEP)javax-ssl-1_2.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)jlib$(DIRSEP)jssl-1_2.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)servlet.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)http_client.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)http_server.jar"

# jre11 classpath
JRE11_CLASSPATH = ".$(PATHSEP)${JAVA_HOME}$(DIRSEP)lib$(DIRSEP)classes.zip"

# jre12 classpath
JRE12_CLASSPATH = ".$(PATHSEP)${JAVA_HOME}$(DIRSEP)jre$(DIRSEP)lib$(DIRSEP)rt.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)aurora_index.jar"

# services
GIOP_SERVICE=sess_iiop://localhost:2481:${ORACLE_SID}
GIOPS_SERVICE=sess_iiop://localhost:2482:${ORACLE_SID}
HTTP_SERVICE=http://localhost:7777
HTTPS_SERVICE=https://localhost:9000
JDBC_SERVICE=jdbc:oracle:thin:@localhost:${ORACLE_PORT}:${ORACLE_SID}
KPRB_SERVICE=jdbc:oracle:kprb:
OCI8_SERVICE=jdbc:oracle:oci8:@
SERVICE=$(GIOP_SERVICE)

# transaction
UT_NAME=/test/UserTransaction/testut
DS_NAME=/test/DataSource/testds

# demo account(s)
HRuser=HR
HRpwd=HR

USER=SCOTT
PASS=TIGER
