##########################################################################
#
# Copyright (c) 1998, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  frmcpu.tcl -- Forms cpu utilization event script
#                  detects cpu utilization for for Forms runtime
#
# ARGUMENTS:
#  number of occurrence
#  Alert threshold  (%cpu usage)
#  Warning threshold  (%cpu usage)
#
#
# RETURNS:
#
#  OEM Event types
#
# MODIFIED     (MM/DD/YY)
# mkiran        11/30/05 - bug4735676: Comment last_report init setting
# sdulepet      03/13/01 - Fixed NLS bug. Added  agent_characterset
#  vtummala     03/22/00 -
#  ayu          03/06/99 -  took out platform dependent code
#  ayu          10/06/98 -  Creation
#

# Event definition
oradefine event /oracle/forms/fault/frmcpu
oraarguments no_occurrence alert_threshold warning_threshold
oravardesc no_occurrence string default=3 
oravardesc alert_threshold string
oravardesc warning_threshold string
#oraresults current
#oravardesc current int
oradefine end


source [AGENT_ORACLE_HOME]/[NETWORK]/agent/tcl/frminit.tcl
frmdebug "frmucpu.tcl start --> [oratime]"
frmdebug "argv: $argv"

# Initialize global variables

# bug4735676: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and forms target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

set output ""
set total_occ 0

set exename "^$_frmexename|^$_f45exename"
set getcpuusage $_getcpuusage

# The main event checking functions
proc EvalEvent {} {

    # Declare globals we will use
    global argv last_report output total_occ initial
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg
    global exename getcpuusage

    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set no_occurrence [lindex $argv 0]
    set alert_threshold [lindex $argv 1]
    set warning_threshold [lindex $argv 2]


    set tmpf [tempfile tmp]
    set reset 0

    # run ps command to get the current cpu usage
    if { [catch {eval exec $getcpuusage > $tmpf } errmsg] } {
    set output [convertout $oramsg(agent_characterset) $errmsg]        
	#set output $errmsg
        rmfile $tmpf
	if {$last_report == $SCRIPT_FAIL} {
	    return $NO_EVENT
	} else {
	    set last_report $SCRIPT_FAIL
	    return $SCRIPT_FAIL
	} 
    } 

    set fid [open $tmpf r]
    while {[gets $fid line] >= 0} {
        if {[regexp -nocase $exename $line]} {
            # Check for alert and warning threshold
            set cpuutil [lindex $line 3]
#
frmdebug "frmcpu.tcl pid:[lindex $line 1], cpu: $cpuutil"
            if {$cpuutil > $alert_threshold} {
                if {$total_occ < [expr $no_occurrence -1]} {
                    incr total_occ
                } else {
                    set ret_code $ALERT_EVENT
                    set output "PID:[lindex $line 1]/CPU:$cpuutil%. $output"
                }
                incr reset
            } elseif {$cpuutil > $warning_threshold} {
                if {$total_occ < [expr $no_occurrence -1]} {
                    incr total_occ
                } else {
                    set ret_code $WARNING_EVENT
                    set output "PID:[lindex $line 1]/CPU:$cpuutil%. $output"
                }
                incr reset
            } 
        }
    }
    close $fid
    rmfile $tmpf

    if {$reset == 0} {
        set total_occ 0
    }
    if {$ret_code == $CLEAR_EVENT} {
        set output "Event cleared."
    }
#
frmdebug "frmcpu.tcl : [oratime] : $ret_code : $output"

    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
        set last_report $ret_code
        return $ret_code 
    }
}

