#
# Copyright (c) 1998, 2003, Oracle Corporation.  All rights reserved.  
#
# NAME:
#
#  frmlnref.tcl -- Forms Listener Refresh job
#                  Refresh up/down status of current Listeners and discovers
#                  the one not started by OEM
#
# ARGUMENTS:
#
#  argv(0) - connect_string
#
# RETURNS:
#
#  OEM Event types
#
# MODIFIED     (MM/DD/YY)
#  mkiran       07/25/03 - Insert port number also into smp_forms_instances table 
#                          for newly discovered forms listeners.
#  vtummala     03/22/00 -
#  ayu          06/01/99 -  Creation
#

oradefine job /oracle/forms/general/frmlnref
oraarguments connect_str
oravardesc connect_str string
oradefine end

    global oramsg

    set connect_str [lindex $argv 0]

    source [AGENT_ORACLE_HOME]/[NETWORK]/agent/tcl/frminit.tcl
#
frmdebug "frmlnref.tcl start --> [oratime]"

    set instance_type 0
    set exename "^$_lnrexename|^$_lnr45exename"
    set nodename $oramsg(nodename)
    #
    # remove the domain name from nodename
    #
    if {[string first . $nodename] != -1 } {
        set nodename [string range $nodename 0 [expr [string first . $nodename]-1]]
    }

    if {[catch {oralogon $connect_str} lda]} {
        return "Logon failed : MESSAGE - $oramsg(rc)"
    }
    oraautocom $lda on
    set cur1 [oraopen $lda]

    set db_plist {}
    set db_nlist {}
    #
    # get list of instance pids on the local node to monitor 
    #
    set select_sql "select pid, name from smp_forms_instances where type = $instance_type and node = '$nodename' and pid > 0"
    orasql $cur1 $select_sql
    set result [orafetch $cur1]
    while {$oramsg(rc) == 0} {
        lappend db_plist [lindex $result 0]
        lappend db_nlist [lindex $result 1]
        set result [orafetch $cur1]
    }

    set current_plist [frm_getpidlist $exename]

    #
    # update repository for down listeners
    #
    if {[llength $db_plist] > 0} {
        foreach el $db_plist {
            if {[lsearch -exact $current_plist $el] == -1} {
                set update_sql "update smp_forms_instances set pid = -2 where type = $instance_type and node = '$nodename' and pid = $el"
                orasql $cur1 $update_sql
            }
        }
    }
    set select_id_sql "select smp_forms_instance_id_seq.NEXTVAL from dual"

    set current_f45list [frm_getpidlist ^$_lnr45exename]
    #
    # update repository for discovered listeners
    #
    if {[llength $current_f45list] > 0} {
        foreach el $current_f45list {
            if {[lsearch -exact $db_plist $el] == -1} {
                orasql $cur1 $select_id_sql
                if {$oramsg(rc) == 0} {
                    set instance_id [orafetch $cur1]

                    # If process running on OS is of the form.....
                    # "f45srvm port=9090 pool=1 mode=socket", port_number gets '9090'
                    set port_number [frm_getportnumber f45srvm $el]

                    # Insert port_number also, which is used by up/down event to find out 
                    # active and dead forms listeners.
                    set insert_sql "insert into smp_forms_instances (instance_id, name, node, type, pid, portno, version) values ( $instance_id, 'PID$el', '$nodename', $instance_type, $el, $port_number, '4.5')"
                    orasql $cur1 $insert_sql
                }
            }
        }
    }
    set current_f60list [frm_getpidlist ^$_lnrexename]
    if {[llength $current_f60list] > 0} {
        foreach el $current_f60list {
            if {[lsearch -exact $db_plist $el] == -1} {
frmdebug $select_id_sql
                orasql $cur1 $select_id_sql
                if {$oramsg(rc) == 0} {
                    set instance_id [orafetch $cur1]
frmdebug $instance_id

                    # If process running on OS is of the form.....
                    # "f60srvm port=9090 pool=1 mode=socket", port_number gets '9090'
                    set port_number [frm_getportnumber f60srvm $el]

                    # Insert port_number also, which is used by up/down event to find out 
                    # active and dead forms listeners. 
                    set insert_sql "insert into smp_forms_instances (instance_id, name, node, type, pid, portno, version) values ( $instance_id, 'PID$el', '$nodename', $instance_type, $el, $port_number, '6.0')"
#
frmdebug $insert_sql
                    orasql $cur1 $insert_sql
                } else {
#
frmdebug "select id failed"
                }
            }
        }
    }

    oraclose $cur1
    oralogoff $lda

#
frmdebug "frmlnref finish --> [oratime]"

