@echo off
Rem #
Rem # pcmake.bat
Rem #
Rem #  Copyright (c) Oracle Corporation 2000, 2002. All Rights Reserved.
Rem #
Rem #    NAME
Rem #      pcmake.bat - batch file for building PRO*C demos. 
Rem #
Rem #    DESCRIPTION
Rem #      Using this batch file to build PRO*C demos,
Rem #      e.g.  To build sample1, 
Rem #            At command prompt where sample1.pc is located, 
Rem #            type: % pcmake sample1
Rem #     
Rem #      The purpose of this batch file is to illustrate how PRO*C
Rem #      applications can be built at the command prompt.  In order to
Rem #      use this batch file, installation of Microsoft Visual Studio 
Rem #      is required.   PRO*C command line options and linker options
Rem #      vary depending on your application.   This batch file
Rem #      is just an example for your reference.
Rem #
Rem #      For environment setup, please read the note below.
Rem #
Rem #    NOTES
Rem #       Environment variables must be set before using this batch file.
Rem #       They are as follows:
Rem #       1. ORACLE_HOME : This variable is set automatically during 
Rem #                        Oracle installation process.
Rem #       2. MSVCDir     : This variable is defined by running a batch
Rem #                        file, vcvars32.bat, in Microsoft Visual Studio 
Rem #                        directory.  You can find it using Windows Explorer.
Rem #


Rem Environment Check:
if (%MSVCDir%) == () goto msvcdir_error
if (%NLS_LANG%) == ()   set NLS_LANG=american

set old_cp=%CLASSPATH%

set CLASSPATH=%ORACLE_HOME%\jdbc\lib\classes12.zip;%CLASSPATH% 
set CLASSPATH=%ORACLE_HOME%\jdbc\lib\classes111.zip;%CLASSPATH% 
set CLASSPATH=%ORACLE_HOME%\sqlj\lib\translator.zip;%CLASSPATH% 
set CLASSPATH=%ORACLE_HOME%\sqlj\lib\runtime12.zip;%CLASSPATH% 
set CLASSPATH=%ORACLE_HOME%\precomp\lib\ottclasses.zip;%CLASSPATH% 

set pcfile=%1

if (%pcfile%) == () goto usage
if (%pcfile%) == (ansidyn1) goto ansidyn1make
if (%pcfile%) == (ansidyn2) goto ansidyn2make
if (%pcfile%) == (coldemo1) goto cold1make
if (%pcfile%) == (cpdemo1)  goto cpdemo1
if (%pcfile%) == (cpdemo2)  goto cpdemo2
if (%pcfile%) == (cppdemo1) goto cpp1make
if (%pcfile%) == (cppdemo2) goto cpp2make
if (%pcfile%) == (empclass) goto empclsmake
if (%pcfile%) == (cppdemo3) goto cpp3make
if (%pcfile%) == (cv_demo)  goto cvdemomake
if (%pcfile%) == (lobdemo1) goto lob1make
if (%pcfile%) == (mltthrd1) goto mthrd1make
if (%pcfile%) == (navdemo1) goto nav1make
if (%pcfile%) == (objdemo1) goto obj1make
if (%pcfile%) == (oraca)    goto oracamake
if (%pcfile%) == (plssam)   goto plscompile
if (%pcfile%) == (sample5)  goto sample5make
if (%pcfile%) == (sample9)  goto sample9make
if (%pcfile%) == (sample11) goto sample11make
if (%pcfile%) == (winsam)   goto winsammake

set pcfile=%1

@echo on
echo %pcfile%
proc parse=full iname=%pcfile%.pc include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto clink


:ansidyn1make
@echo on
proc mode=ansi parse=full iname=%pcfile%.pc include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto clink


:ansidyn2make
@echo on
proc parse=full dynamic=ansi iname=%pcfile%.pc include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include" include="%MSDevDir%\..\vc\include" include="%MSDevDir\..\..\vc98\include"
@echo off
goto clink


:cold1make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\coldemo1.sql"
copy "%ORACLE_HOME%\precomp\demo\sql\calidata.sql"
sqlplus /nolog @coldemo1
ott intype=coldemo1.typ outtype=coldemo1_o.typ hfile=coldemo1.h code=c userid=scott/tiger
proc parse=full intype=coldemo1_o.typ iname=%pcfile%.pc include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto clink


:cpdemo1
@echo on
proc parse=full cpool=yes iname=%pcfile%.pc include="d:\shiptest\ora92rel11\precomp\public" include="%MSVCDir%\include" include="%MSDevDir%\..\vc\include" include="%MSDevDir\..\..\vc98\include"
@echo off
goto clink


:cpdemo2
@echo on
proc parse=full cpool=yes iname=%pcfile%.pc include="d:\shiptest\ora92rel11\precomp\public" include="%MSVCDir%\include" include="%MSDevDir%\..\vc\include" include="%MSDevDir\..\..\vc98\include"
@echo off
goto clink


:cpp1make
@echo on
proc parse=partial iname=%pcfile%.pc code=cpp include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto cpplink


:cpp2make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\cppdemo2.sql"
copy "%ORACLE_HOME%\precomp\demo\proc\empclass\empclass.h"
copy "%ORACLE_HOME%\precomp\demo\proc\empclass\empclass.pc"
sqlplus /nolog @cppdemo2

proc parse=partial SQLCHECK=SEMANTICS iname=empclass.pc code=cpp userid=scott/tiger include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"

proc parse=partial iname=%pcfile%.pc code=cpp include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include" include="%ORACLE_HOME\precomp\demo\proc\empclass"

cl -I%ORACLE_HOME%\oci\include -I%ORACLE_HOME%\precomp\public -I. -I%MSVCDir%\include -D_DLL -D_MT empclass.cpp /c /link %ORACLE_HOME%\oci\lib\msvc\oci.lib /libpath:%ORACLE_HOME%\precomp\lib /libpath:%ORACLE_HOME%\precomp\lib\msvc orasql9.lib /libpath:%MSVCDir%\lib /nod:libc

cl -I%ORACLE_HOME%\oci\include -I%ORACLE_HOME%\precomp\public -I. -I%MSVCDir%\include -D_DLL -D_MT %1.cpp /link empclass %ORACLE_HOME%\oci\lib\msvc\oci.lib /libpath:%ORACLE_HOME%\precomp\lib /libpath:%ORACLE_HOME%\precomp\lib\msvc orasql9.lib /libpath:%MSVCDir%\lib msvcrt.lib /nod:libc
@echo off
goto end

:empclsmake
@echo on
REM  This is part of the cppdemo2 demo.  Please refer to cppdemo2.
@echo off
goto end


:cpp3make
@echo on
proc parse=partial iname=%pcfile%.pc code=cpp include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto cpplink


:cvdemomake
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\cv_demo.sql"
sqlplus /nolog @cv_demo
goto plscompile


:lob1make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\lobdemo1c.sql"
echo. >> lobdemo1c.sql
echo exit >> lobdemo1c.sql
sqlplus /nolog @lobdemo1c
proc sqlcheck=full userid=scott/tiger parse=full %pcfile%.pc include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto clink

:mthrd1make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\mltthrd1.sql"
sqlplus /nolog @mltthrd1
proc threads=yes parse=partial iname=%pcfile%.pc include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto clink


:nav1make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\navdemo1.sql"
sqlplus /nolog @navdemo1
ott intype=navdemo1.typ outtype=navdemo1_o.typ hfile=navdemo1.h code=c userid=scott/tiger 
proc parse=full intype=navdemo1_o.typ iname=%pcfile%.pc include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto clink


:obj1make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\objdemo1.sql"
sqlplus /nolog @objdemo1
ott intype=objdemo1.typ outtype=objdemo1_o.typ hfile=objdemo1.h code=c userid=scott/tiger
proc parse=full intype=objdemo1_o.typ objdemo1 include=. include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include" 
@echo off
goto clink


:oracamake
@echo on 
copy "%ORACLE_HOME%\precomp\demo\sql\oracatst.sql"
sqlplus scott/tiger @oracatst
proc oraca=yes mode=ANSI iname=%pcfile%.pc include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto clink


:sample5make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\exampbld.sql"
copy "%ORACLE_HOME%\precomp\demo\sql\examplod.sql"
sqlplus /nolog @exampbld
sqlplus /nolog @examplod
@echo off
goto plscompile


:sample9make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\calldemo.sql"
sqlplus /nolog @calldemo
@echo off
goto plscompile



:sample11make
@echo on
copy "%ORACLE_HOME%\precomp\demo\sql\sample11.sql"
sqlplus /nolog @sample11
@echo off
goto plscompile

:winsammake
@echo on
echo %pcfile%
proc parse=full iname=%pcfile%.pc include="%ORACLE_HOME%\oci\include" include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
rc %pcfile%.rc
@echo off
goto winsamlink

:plscompile
@echo on
proc sqlcheck=semantics userid=scott/tiger %pcfile%.pc  include="%ORACLE_HOME%\precomp\public" include="%MSVCDir%\include"
@echo off
goto clink


:clink
cl -I%ORACLE_HOME%\oci\include -I%ORACLE_HOME%\precomp\public -I. -I%MSVCDir%\include -D_MT -D_DLL -Zi %1.c /link %ORACLE_HOME%\oci\lib\msvc\oci.lib /libpath:%ORACLE_HOME%\precomp\lib /libpath:%ORACLE_HOME%\precomp\lib\msvc orasql9.LIB /LIBPATH:%MSVCDir%\lib msvcrt.lib /nod:libc
goto end

:cpplink
cl -I%ORACLE_HOME%\oci\include -I%ORACLE_HOME%\precomp\public -I. -I%MSVCDir%\include -D_DLL -D_MT %1.cpp /link %ORACLE_HOME%\oci\lib\msvc\oci.lib /libpath:%ORACLE_HOME%\precomp\lib /libpath:%ORACLE_HOME%\precomp\lib\msvc orasql9.LIB  /LIBPATH:%MSVCDir%\lib msvcrt.lib msvcirt.lib /nod:libc
goto end

:winsamlink
cl -I%ORACLE_HOME%\oci\include -I%ORACLE_HOME%\precomp\public -I. -I%MSVCDir%\include -D_MT -D_DLL -Zi %1.c /link %ORACLE_HOME%\oci\lib\msvc\oci.lib /libpath:%ORACLE_HOME%\precomp\lib /libpath:%ORACLE_HOME%\precomp\lib\msvc %1.res orasql9.LIB /LIBPATH:%MSVCDir%\lib msvcrt.lib gdi32.lib user32.lib kernel32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib /nod:libc
goto end

:usage
echo .
echo usage pcmake filename.pc [ i.e. pcmake sample1 ]
echo .
goto end


:msvcdir_error 
echo .
echo Environment variable MSVCDIR must be set before running this batch file.
echo Please run vcvars32.bat from MS Visual Studio directory.
echo .
goto end

:end

Rem Restore CLASSPATH
set CLASSPATH=%old_cp%
