Rem
Rem $Header: a0801060.sql 08-sep-2003.15:34:13 kquinn Exp $
Rem
Rem a0801060.sql
Rem
Rem Copyright (c) 1999, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      a0801060.sql - additional ANONYMOUS BLOCK dictionary upgrade.
Rem      		Upgrade Oracle RDBMS from 8.1.6 to the new release
Rem
Rem    DESCRIPTION
Rem      Additional upgrade script to be run during the migration of an
Rem      8.1.6 database to the new release.
Rem
Rem	 This script is called from u0801060.sql and a0801050.sql
Rem
Rem	 Put any anonymous block related changes here.
Rem	 Any dictionary create, alter, updates and deletes  
Rem 	 that must be performed before catalog.sql and catproc.sql go 
Rem	 in c0801060.sql
Rem
Rem      The upgrade is performed in the following stages:
Rem        STAGE 1: additional steps to upgrade from 8.1.6 to 8.1.7
Rem        STAGE 2: upgrade from 8.1.6 to the new release
Rem
Rem    NOTES
Rem      * This script must be run using SQL*PLUS.
Rem      * You must be connected AS SYSDBA to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kquinn      09/08/03 - 3007398: Support mixed case triggers 
Rem    sbalaram    05/18/00 - Set fire once trigger bit for DML triggers
Rem    jdavison    04/11/00 - Modify usage notes for 8.2 changes.
Rem    rshaikh     10/29/99 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: upgrade from 8.1.6 to 8.1.7
Rem =========================================================================

REM INSERT YOUR UPGRADE STATEMENTS HERE

Rem Set the fire once trigger bit in trigger$ for DML triggers
Rem (excluding instead-of triggers)

DECLARE
  CURSOR trig IS
    SELECT u.name towner, o.name tname
      FROM sys.obj$ o, sys.user$ u, sys.trigger$ t
     WHERE o.owner# = u.user#
       AND o.type# = dbms_ddl_internal.sys_obj_type_trigger
       AND o.obj# = t.obj#
       AND t.update$ + t.delete$ + t.insert$ > 0
       AND bitand(t.property, 1) = 0;
BEGIN
  FOR rec IN trig LOOP
    BEGIN
      dbms_ddl.set_trigger_firing_property('"'||rec.towner||'"', 
               '"'||rec.tname||'"', TRUE);
    EXCEPTION WHEN others THEN
      DBMS_SYSTEM.KSDWRT(2, 'Trigger ' || rec.towner || '.' || rec.tname ||
                            'failed with Error' || TO_CHAR(SQLCODE) || ': ' ||
                             SQLERRM);
    END;
  END LOOP;
  COMMIT;
END;
/

Rem =========================================================================
Rem END STAGE 1: upgrade from 8.1.6 to 8.1.7
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: upgrade from 8.1.6 to the new release
Rem =========================================================================

@@a0801070

Rem =========================================================================
Rem END STAGE 2: upgrade from 8.1.6 to the new release
Rem =========================================================================

Rem *************************************************************************
Rem END a0801060.sql
Rem *************************************************************************








