Rem
Rem $Header: catapp.sql 26-jul-2002.18:03:23 alakshmi Exp $
Rem
Rem catapp.sql
Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      catapp.sql - streams apply views
Rem
Rem    DESCRIPTION
Rem      This file contains all the streams apply views
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    alakshmi    07/26/02 - restrict max value for inittrans
Rem    alakshmi    05/06/02 - Bug 2265160: set inittrans, freelists, pctfree 
Rem                           for apply_progress
Rem    sbalaram    06/17/02 - Fix bug 2395423
Rem    elu         06/14/02 - modify all_apply_error
Rem    elu         06/13/02 - add index on apply# to apply$_error
Rem    sbalaram    01/24/02 - Fix view dba_apply_instantiated_objects
Rem    wesmith     01/09/02 - Streams export/import support
Rem    rgmani      01/19/02 - Code review comments
Rem    elu         12/28/01 - modify dba_apply_error
Rem    rgmani      01/10/02 - Add apply dblink to several views
Rem    sbalaram    12/10/01 - use create or replace synonym
Rem    sbalaram    12/04/01 - ALL_APPLY_PARAMETERS - join with all_apply
Rem    wesmith     11/19/01 - dba_apply: apply_user renamed to apply_userid
Rem    sbalaram    11/16/01 - Fix comments on some views
Rem    alakshmi    11/08/01 - Merged alakshmi_apicleanup
Rem    narora      11/02/01 - rename apply_slave
Rem    nshodhan    11/01/01 - Change apply$_error
Rem    nshodhan    11/01/01 - Change apply$_error
Rem    sbalaram    10/29/01 - add views
Rem    lkaplan     10/29/01 - API - dml hdlr, lcr.execute, set key options 
Rem    apadmana    10/26/01 - Created
Rem

----------------------------------------------------------------------------
-- view to get the apply process details
----------------------------------------------------------------------------

-- Private view select to all columns from streams$_apply_process.
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_APPLY"
as select 
  apply#, apply_name, queue_oid, queue_owner, queue_name, status, flags,
  ruleset_owner, ruleset_name, message_handler, ddl_handler,
  apply_userid, apply_dblink, apply_tag, spare1, spare2, spare3
from sys.streams$_apply_process
/
grant select on "_DBA_APPLY" to exp_full_database
/

create or replace view DBA_APPLY
  (APPLY_NAME, QUEUE_NAME, QUEUE_OWNER, APPLY_CAPTURED, RULE_SET_NAME,
   RULE_SET_OWNER, APPLY_USER, APPLY_DATABASE_LINK, APPLY_TAG,
   DDL_HANDLER, MESSAGE_HANDLER, STATUS)
as
select ap.apply_name, q.name, u.name, 
       decode(bitand(ap.flags, 1), 1, 'YES',
                                   0, 'NO'),
       ap.ruleset_name, ap.ruleset_owner,
       u2.name, ap.apply_dblink, ap.apply_tag, ap.ddl_handler,
       ap.message_handler,
       decode(ap.status, 1, 'DISABLED',
                         2, 'ENABLED',
                         4, 'ABORTED', 'UNKNOWN')
  from "_DBA_APPLY" ap, system.aq$_queues q,
       system.aq$_queue_tables t, sys.user$ u, sys.user$ u2
 where ap.queue_oid = q.oid
   and q.table_objno = t.objno
   and t.schema = u.name
   and ap.apply_userid = u2.user#
/

comment on table DBA_APPLY is
'Details about the apply process'
/
comment on column DBA_APPLY.APPLY_NAME is
'Name of the apply process'
/
comment on column DBA_APPLY.QUEUE_NAME is
'Name of the queue the apply process dequeues from'
/
comment on column DBA_APPLY.QUEUE_OWNER is
'Owner of the queue the apply process dequeues from'
/
comment on column DBA_APPLY.APPLY_CAPTURED is
'Yes, if applying captured messages; No, if applying enqueued messages'
/
comment on column DBA_APPLY.RULE_SET_NAME is
'Rule set used by apply process for filtering'
/
comment on column DBA_APPLY.RULE_SET_OWNER is
'Owner of the rule set'
/
comment on column DBA_APPLY.APPLY_USER is
'Current user who is applying the messages'
/
comment on column DBA_APPLY.APPLY_DATABASE_LINK is
'For remote objects, the database link pointing to the remote database'
/
comment on column DBA_APPLY.APPLY_TAG is
'Tag associated with DDL and DML change records that will be applied'
/
comment on column DBA_APPLY.DDL_HANDLER is
'Name of the user specified ddl handler'
/
comment on column DBA_APPLY.MESSAGE_HANDLER is
'User specified procedure to handle messages other than DDL and DML messages'
/
comment on column DBA_APPLY.STATUS is
'Status of the apply process: DISABLED, ENABLED, ABORTED'
/
create or replace public synonym DBA_APPLY for DBA_APPLY
/
grant select on DBA_APPLY to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_APPLY
  (APPLY_NAME, QUEUE_NAME, QUEUE_OWNER, APPLY_CAPTURED, RULE_SET_NAME,
   RULE_SET_OWNER, APPLY_USER, APPLY_DATABASE_LINK, APPLY_TAG,
   DDL_HANDLER, MESSAGE_HANDLER, STATUS)
as
select a.apply_name, a.queue_name, a.queue_owner, a.apply_captured,
       a.rule_set_name, a.rule_set_owner, a.apply_user, a.apply_database_link,
       a.apply_tag, a.ddl_handler, a.message_handler, a.status
  from dba_apply a, all_queues q
 where a.queue_name = q.name
   and a.queue_owner = q.owner
   and a.rule_set_name is null
   and a.rule_set_owner is null
union all
select a.apply_name, a.queue_name, a.queue_owner, a.apply_captured,
       a.rule_set_name, a.rule_set_owner, a.apply_user, a.apply_database_link,
       a.apply_tag, a.ddl_handler, a.message_handler, a.status
  from dba_apply a, all_queues q, all_rule_sets r
 where a.queue_name = q.name
   and a.queue_owner = q.owner
   and a.rule_set_name is not null
   and a.rule_set_name = r.rule_set_name
   and a.rule_set_owner is not null
   and a.rule_set_owner = r.rule_set_owner
/

comment on table ALL_APPLY is
'Details about each apply process that dequeues from the queue visible to the current user'
/
comment on column ALL_APPLY.APPLY_NAME is
'Name of the apply process'
/
comment on column ALL_APPLY.QUEUE_NAME is
'Name of the queue the apply process dequeues from'
/
comment on column ALL_APPLY.QUEUE_OWNER is
'Owner of the queue the apply process dequeues from'
/
comment on column ALL_APPLY.APPLY_CAPTURED is
'Yes, if applying captured messages; No, if applying enqueued messages'
/
comment on column ALL_APPLY.RULE_SET_NAME is
'Rule set used by apply process for filtering'
/
comment on column ALL_APPLY.RULE_SET_OWNER is
'Owner of the rule set'
/
comment on column ALL_APPLY.APPLY_USER is
'Current user who is applying the messages'
/
comment on column ALL_APPLY.APPLY_DATABASE_LINK is
'For remote objects, the database link pointing to the remote database'
/
comment on column ALL_APPLY.APPLY_TAG is
'Tag associated with DDL and DML change records that will be applied'
/
comment on column ALL_APPLY.DDL_HANDLER is
'Name of the user specified ddl handler'
/
comment on column ALL_APPLY.MESSAGE_HANDLER is
'User specified procedure to handle messages other than DDL and DML messages'
/
comment on column ALL_APPLY.STATUS is
'Status of the apply process: DISABLED, ENABLED, ABORTED'
/
create or replace public synonym ALL_APPLY for ALL_APPLY
/
grant select on ALL_APPLY to public with grant option
/

----------------------------------------------------------------------------
-- view to get apply process parameters
--
-- Note: process_type = 1 corresponds to the package variable
--       dbms_streams_adm_utl.proc_type_apply (prvtbsdm.sql)
--       and the macro KNLU_APPLY_PROC (knlu.h). This *must* be
--        kept in sync with both of these.
----------------------------------------------------------------------------
create or replace view DBA_APPLY_PARAMETERS
  (APPLY_NAME, PARAMETER, VALUE, SET_BY_USER)
as
select ap.apply_name, pp.name, pp.value,
       decode(pp.user_changed_flag, 1, 'YES', 'NO')
  from sys.streams$_process_params pp, sys.streams$_apply_process ap
 where pp.process_type = 1
   and pp.process# = ap.apply#
   and /* display internal parameters if the user changed them */
       (pp.internal_flag = 0
        or
        (pp.internal_flag = 1 and pp.user_changed_flag = 1)
       )
/

comment on table DBA_APPLY_PARAMETERS is
'All parameters for apply process'
/
comment on column DBA_APPLY_PARAMETERS.APPLY_NAME is
'Name of the apply process'
/
comment on column DBA_APPLY_PARAMETERS.PARAMETER is
'Name of the parameter'
/
comment on column DBA_APPLY_PARAMETERS.VALUE is
'Either the default value or the value set by the user for the parameter'
/
comment on column DBA_APPLY_PARAMETERS.SET_BY_USER is
'YES if the value is set by the user, NO otherwise'
/
create or replace public synonym DBA_APPLY_PARAMETERS
  for DBA_APPLY_PARAMETERS
/
grant select on DBA_APPLY_PARAMETERS to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_APPLY_PARAMETERS
  (APPLY_NAME, PARAMETER, VALUE, SET_BY_USER)
as
select pa.apply_name, pa.parameter, pa.value, pa.set_by_user
  from dba_apply_parameters pa, all_apply aa
 where pa.apply_name = aa.apply_name
/

comment on table ALL_APPLY_PARAMETERS is
'Details about parameters of each apply process that dequeues from the queue visible to the current user'
/
comment on column ALL_APPLY_PARAMETERS.APPLY_NAME is
'Name of the apply process'
/
comment on column ALL_APPLY_PARAMETERS.PARAMETER is
'Name of the parameter'
/
comment on column ALL_APPLY_PARAMETERS.VALUE is
'Either the default value or the value set by the user for the parameter'
/
comment on column ALL_APPLY_PARAMETERS.SET_BY_USER is
'YES if the value is set by the user, NO otherwise'
/
create or replace public synonym ALL_APPLY_PARAMETERS
  for ALL_APPLY_PARAMETERS
/
grant select on ALL_APPLY_PARAMETERS to public with grant option
/

----------------------------------------------------------------------------
-- view to get apply instantiated objects
----------------------------------------------------------------------------

-- Private view select to all columns from apply$_source_schema.
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_APPLY_SOURCE_SCHEMA"
as select 
  source_db_name, global_flag, name, dblink, inst_scn, spare1
from sys.apply$_source_schema
/
grant select on "_DBA_APPLY_SOURCE_SCHEMA" to exp_full_database
/

-- Private view select to all columns from apply$_source_obj
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_APPLY_SOURCE_OBJ"
as select 
  id, owner, name, decode(type, 2, 'TABLE', 'UNSUPPORTED') type,
  source_db_name, dblink, inst_scn, ignore_scn,
  spare1
from sys.apply$_source_obj
/
grant select on "_DBA_APPLY_SOURCE_OBJ" to exp_full_database
/

create or replace view DBA_APPLY_INSTANTIATED_OBJECTS
  (SOURCE_DATABASE, SOURCE_OBJECT_OWNER, SOURCE_OBJECT_NAME,
   SOURCE_OBJECT_TYPE, INSTANTIATION_SCN, IGNORE_SCN, APPLY_DATABASE_LINK)
as
select source_db_name, owner, name,
       type, inst_scn, ignore_scn, dblink
  from "_DBA_APPLY_SOURCE_OBJ"
/

comment on table DBA_APPLY_INSTANTIATED_OBJECTS is
'Details about objects instantiated'
/
comment on column DBA_APPLY_INSTANTIATED_OBJECTS.SOURCE_DATABASE is
'Name of the database where the objects originated'
/
comment on column DBA_APPLY_INSTANTIATED_OBJECTS.SOURCE_OBJECT_OWNER is
'Owner of the object at the source database'
/
comment on column DBA_APPLY_INSTANTIATED_OBJECTS.SOURCE_OBJECT_NAME is
'Name of the object at source'
/
comment on column DBA_APPLY_INSTANTIATED_OBJECTS.SOURCE_OBJECT_TYPE is
'Type of the object at source'
/
comment on column DBA_APPLY_INSTANTIATED_OBJECTS.INSTANTIATION_SCN is
'Point in time when the object was instantiated at source'
/
comment on column DBA_APPLY_INSTANTIATED_OBJECTS.IGNORE_SCN is
'SCN lower bound for messages that will be considered for apply'
/
comment on column DBA_APPLY_INSTANTIATED_OBJECTS.APPLY_DATABASE_LINK is
'For remote objects, the database link pointing to the remote database'
/
create or replace public synonym DBA_APPLY_INSTANTIATED_OBJECTS
  for DBA_APPLY_INSTANTIATED_OBJECTS
/
grant select on DBA_APPLY_INSTANTIATED_OBJECTS to select_catalog_role
/

----------------------------------------------------------------------------
-- view to get apply key columns
-- TODO: Use long_cname when user-defined type is supported
----------------------------------------------------------------------------
create or replace view DBA_APPLY_KEY_COLUMNS
  (OBJECT_OWNER, OBJECT_NAME, COLUMN_NAME, APPLY_DATABASE_LINK)
as
select sname, oname, cname, dblink
  from sys.streams$_key_columns
/

comment on table DBA_APPLY_KEY_COLUMNS is
'alternative key columns for a table for STREAMS'
/
comment on column DBA_APPLY_KEY_COLUMNS.OBJECT_OWNER is
'Owner of the object'
/
comment on column DBA_APPLY_KEY_COLUMNS.OBJECT_NAME is
'Name of the object'
/
comment on column DBA_APPLY_KEY_COLUMNS.COLUMN_NAME is
'Column name of the object'
/
comment on column DBA_APPLY_KEY_COLUMNS.APPLY_DATABASE_LINK is
'Remote database link to which changes will be aplied'
/
create or replace public synonym DBA_APPLY_KEY_COLUMNS
  for DBA_APPLY_KEY_COLUMNS
/
grant select on DBA_APPLY_KEY_COLUMNS to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_APPLY_KEY_COLUMNS
  (OBJECT_OWNER, OBJECT_NAME, COLUMN_NAME, APPLY_DATABASE_LINK)
as
select k.object_owner, k.object_name, k.column_name, k.apply_database_link
  from dba_apply_key_columns k, all_tab_columns a
 where k.object_owner = a.owner
   and k.object_name = a.table_name
   and k.column_name = a.column_name
/

comment on table ALL_APPLY_KEY_COLUMNS is
'Alternative key columns for a STREAMS table visible to the current user'
/
comment on column ALL_APPLY_KEY_COLUMNS.OBJECT_OWNER is
'Owner of the object'
/
comment on column ALL_APPLY_KEY_COLUMNS.OBJECT_NAME is
'Name of the object'
/
comment on column ALL_APPLY_KEY_COLUMNS.COLUMN_NAME is
'Column name of the object'
/
comment on column ALL_APPLY_KEY_COLUMNS.APPLY_DATABASE_LINK is
'Remote database link to which changes will be aplied'
/
create or replace public synonym ALL_APPLY_KEY_COLUMNS
  for ALL_APPLY_KEY_COLUMNS
/
grant select on ALL_APPLY_KEY_COLUMNS to PUBLIC with grant option
/

----------------------------------------------------------------------------
-- view to get conflict/error handling information during apply
----------------------------------------------------------------------------

-- Private view select to all columns from apply$_error_handler
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_APPLY_ERROR_HANDLER"
as select 
  eh.object_number, eh.method_name, eh.resolution_column, eh.resolution_id, 
  eh.spare1, o.linkname
from sys.apply$_error_handler eh, sys.obj$ o
where eh.object_number = o.obj#
/
grant select on "_DBA_APPLY_ERROR_HANDLER" to exp_full_database
/

-- Create an index on apply# for apply$_error
-- TO DO: move this to sql.bsq
create index streams$_apply_error_idx_2
 on apply$_error(apply#)
/

-- Private view select to all columns from apply$_conf_hdlr_columns
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_APPLY_CONF_HDLR_COLUMNS"
as select 
  object_number, resolution_id, column_name, spare1
from sys.apply$_conf_hdlr_columns
/
grant select on "_DBA_APPLY_CONF_HDLR_COLUMNS" to exp_full_database
/

create or replace view DBA_APPLY_CONFLICT_COLUMNS
  (OBJECT_OWNER, OBJECT_NAME, METHOD_NAME, RESOLUTION_COLUMN, COLUMN_NAME,
   APPLY_DATABASE_LINK)
as
select u.username, o.name, eh.method_name, eh.resolution_column,
       ac.column_name, NULL
  from sys.obj$ o, "_DBA_APPLY_CONF_HDLR_COLUMNS" ac, 
       "_DBA_APPLY_ERROR_HANDLER" eh, dba_users u
 where o.obj# = ac.object_number
   and o.obj# = eh.object_number
   and ac.resolution_id = eh.resolution_id
   and u.user_id = o.owner#
   and o.remoteowner is NULL
union
select o.remoteowner, o.name, eh.method_name, eh.resolution_column,
       ac.column_name, o.linkname
  from sys.obj$ o, apply$_conf_hdlr_columns ac, apply$_error_handler eh
 where o.obj# = ac.object_number
   and o.obj# = eh.object_number
   and ac.resolution_id = eh.resolution_id
   and o.remoteowner is not NULL
/

comment on table DBA_APPLY_CONFLICT_COLUMNS is
'Details about conflict resolution'
/
comment on column DBA_APPLY_CONFLICT_COLUMNS.OBJECT_OWNER is
'Owner of the object'
/
comment on column DBA_APPLY_CONFLICT_COLUMNS.OBJECT_NAME is
'Name of the object'
/
comment on column DBA_APPLY_CONFLICT_COLUMNS.METHOD_NAME is
'Name of the method used to resolve conflict'
/
comment on column DBA_APPLY_CONFLICT_COLUMNS.RESOLUTION_COLUMN is
'Name of the column used to resolve conflict'
/
comment on column DBA_APPLY_CONFLICT_COLUMNS.COLUMN_NAME is
'Name of the column that is to be considered as part of a group to resolve conflict'
/
comment on column DBA_APPLY_CONFLICT_COLUMNS.APPLY_DATABASE_LINK is
'For remote objects, name of database link pointing to remote database'
/
create or replace public synonym DBA_APPLY_CONFLICT_COLUMNS
  for DBA_APPLY_CONFLICT_COLUMNS
/
grant select on DBA_APPLY_CONFLICT_COLUMNS to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_APPLY_CONFLICT_COLUMNS
  (OBJECT_OWNER, OBJECT_NAME, METHOD_NAME, RESOLUTION_COLUMN, COLUMN_NAME,
   APPLY_DATABASE_LINK)
as
select c.object_owner, c.object_name, c.method_name,
       c.resolution_column, c.column_name, c.apply_database_link
  from dba_apply_conflict_columns c, all_tab_columns o
 where c.object_owner = o.owner
   and c.object_name = o.table_name
   and c.column_name = o.column_name
/

comment on table ALL_APPLY_CONFLICT_COLUMNS is
'Details about conflict resolution on tables visible to the current user'
/
comment on column ALL_APPLY_CONFLICT_COLUMNS.OBJECT_OWNER is
'Owner of the object'
/
comment on column ALL_APPLY_CONFLICT_COLUMNS.OBJECT_NAME is
'Name of the object'
/
comment on column ALL_APPLY_CONFLICT_COLUMNS.METHOD_NAME is
'Name of the method used to resolve conflict'
/
comment on column ALL_APPLY_CONFLICT_COLUMNS.RESOLUTION_COLUMN is
'Name of the column used to resolve conflict'
/
comment on column ALL_APPLY_CONFLICT_COLUMNS.COLUMN_NAME is
'Name of the column that is to be considered as part of a group to resolve conflict'
/
comment on column ALL_APPLY_CONFLICT_COLUMNS.APPLY_DATABASE_LINK is
'For remote objects, name of database link pointing to remote database'
/
create or replace public synonym ALL_APPLY_CONFLICT_COLUMNS
  for ALL_APPLY_CONFLICT_COLUMNS
/
grant select on ALL_APPLY_CONFLICT_COLUMNS to public with grant option
/

----------------------------------------------------------------------------
-- view to get user procedure/error handling information during apply
----------------------------------------------------------------------------
create or replace view DBA_APPLY_DML_HANDLERS
  (OBJECT_OWNER, OBJECT_NAME, OPERATION_NAME,
   USER_PROCEDURE, ERROR_HANDLER, APPLY_DATABASE_LINK)
as
select u.username, o.name,
       decode(do.apply_operation, 0, 'DEFAULT',
                                  1, 'INSERT',
                                  2, 'UPDATE',
                                  3, 'DELETE',
                                  4, 'BLOB_UPDATE',
                                  5, 'CLOB_UPDATE',
                                  6, 'NCLOB_UPDATE', 'UNKNOWN'),
       do.user_apply_procedure,
       do.error_handler, NULL
  from sys.obj$ o, apply$_dest_obj_ops do, dba_users u
 where o.obj# = do.object_number
   and o.owner# = u.user_id
   and o.remoteowner is NULL
union
select o.remoteowner, o.name,
       decode(do.apply_operation, 0, 'DEFAULT',
                                  1, 'INSERT',
                                  2, 'UPDATE',
                                  3, 'DELETE',
                                  4, 'BLOB_UPDATE',
                                  5, 'CLOB_UPDATE',
                                  6, 'NCLOB_UPDATE', 'UNKNOWN'),
       do.user_apply_procedure,
       do.error_handler, o.linkname
  from sys.obj$ o, apply$_dest_obj_ops do
 where o.obj# = do.object_number
   and o.remoteowner is not null 
/

comment on table DBA_APPLY_DML_HANDLERS is
'Details about the dml handler'
/
comment on column DBA_APPLY_DML_HANDLERS.OBJECT_OWNER is
'Owner of the object'
/
comment on column DBA_APPLY_DML_HANDLERS.OBJECT_NAME is
'Name of the object'
/
comment on column DBA_APPLY_DML_HANDLERS.OPERATION_NAME is
'Name of the DML operation'
/
comment on column DBA_APPLY_DML_HANDLERS.USER_PROCEDURE is
'Name of the DML handler specified by the user'
/
comment on column DBA_APPLY_DML_HANDLERS.ERROR_HANDLER is
'Y if the user procedure is the error handler, N if it is the DML handler'
/
comment on column DBA_APPLY_DML_HANDLERS.APPLY_DATABASE_LINK is
'For remote objects, name of database link pointing to remote database'
/
create or replace public synonym DBA_APPLY_DML_HANDLERS
  for DBA_APPLY_DML_HANDLERS
/
grant select on DBA_APPLY_DML_HANDLERS to select_catalog_role
/

----------------------------------------------------------------------------

create or replace view ALL_APPLY_DML_HANDLERS
  (OBJECT_OWNER, OBJECT_NAME, OPERATION_NAME,
   USER_PROCEDURE, ERROR_HANDLER, APPLY_DATABASE_LINK)
as
select h.object_owner, h.object_name, h.operation_name,
       h.user_procedure, h.error_handler, h.apply_database_link
  from dba_apply_dml_handlers h, all_tables o
 where h.object_owner = o.owner
   and h.object_name = o.table_name
/

comment on table ALL_APPLY_DML_HANDLERS is
'Details about the dml handler on tables visible to the current user'
/
comment on column ALL_APPLY_DML_HANDLERS.OBJECT_OWNER is
'Owner of the object'
/
comment on column ALL_APPLY_DML_HANDLERS.OBJECT_NAME is
'Name of the object'
/
comment on column ALL_APPLY_DML_HANDLERS.OPERATION_NAME is
'Name of the DML operation'
/
comment on column ALL_APPLY_DML_HANDLERS.USER_PROCEDURE is
'Name of the DML handler specified by the user'
/
comment on column ALL_APPLY_DML_HANDLERS.ERROR_HANDLER is
'Y if the user procedure is the error handler, N if it is the DML handler'
/
comment on column ALL_APPLY_DML_HANDLERS.APPLY_DATABASE_LINK is
'For remote objects, name of database link pointing to remote database'
/
create or replace public synonym ALL_APPLY_DML_HANDLERS
  for ALL_APPLY_DML_HANDLERS
/
grant select on ALL_APPLY_DML_HANDLERS to public with grant option
/

----------------------------------------------------------------------------

-- Private view select to all columns from streams$_apply_milestone
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_APPLY_MILESTONE"
as select 
  apply#, source_db_name, oldest_scn, commit_scn, synch_scn, epoch,
  processed_scn, apply_time, applied_message_create_time, spare1
from sys.streams$_apply_milestone
/
grant select on "_DBA_APPLY_MILESTONE" to exp_full_database
/

-- Private view select to all columns from streams$_apply_progress
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_APPLY_PROGRESS"
as select 
  apply#, source_db_name, xidusn, xidslt, xidsqn, commit_scn, spare1
from sys.streams$_apply_progress
/
grant select on "_DBA_APPLY_PROGRESS" to exp_full_database
/

create or replace view DBA_APPLY_PROGRESS
  (APPLY_NAME, APPLIED_MESSAGE_NUMBER, OLDEST_MESSAGE_NUMBER,
   APPLY_TIME, APPLIED_MESSAGE_CREATE_TIME)
as
select ap.apply_name, am.commit_scn, am.oldest_scn, apply_time,
       applied_message_create_time
  from streams$_apply_process ap, "_DBA_APPLY_MILESTONE" am
 where ap.apply# = am.apply#
/

comment on table DBA_APPLY_PROGRESS is
'Information about the progress made by apply process'
/
comment on column DBA_APPLY_PROGRESS.APPLY_NAME is
'Name of the apply process'
/
comment on column DBA_APPLY_PROGRESS.APPLIED_MESSAGE_NUMBER is
'All messages before this number have been successfully applied'
/
comment on column DBA_APPLY_PROGRESS.OLDEST_MESSAGE_NUMBER is
'Earliest commit number of the transactions currently being applied'
/
comment on column DBA_APPLY_PROGRESS.APPLY_TIME is
'Time at which the message was applied'
/
comment on column DBA_APPLY_PROGRESS.APPLIED_MESSAGE_CREATE_TIME is
'Time at which the message to be applied was created'
/
create or replace public synonym DBA_APPLY_PROGRESS for DBA_APPLY_PROGRESS
/
grant select on DBA_APPLY_PROGRESS to select_catalog_role
/

----------------------------------------------------------------------------
create or replace view ALL_APPLY_PROGRESS
  (APPLY_NAME, APPLIED_MESSAGE_NUMBER, OLDEST_MESSAGE_NUMBER,
   APPLY_TIME, APPLIED_MESSAGE_CREATE_TIME)
as
select ap.apply_name, ap.applied_message_number, ap.oldest_message_number,
       ap.apply_time, ap.applied_message_create_time
  from dba_apply_progress ap, all_apply a
 where ap.apply_name = a.apply_name
/

comment on table ALL_APPLY_PROGRESS is
'Information about the progress made by the apply process that dequeues from the queue visible to the current user'
/
comment on column ALL_APPLY_PROGRESS.APPLY_NAME is
'Name of the apply process'
/
comment on column ALL_APPLY_PROGRESS.APPLIED_MESSAGE_NUMBER is
'All messages before this number have been successfully applied'
/
comment on column ALL_APPLY_PROGRESS.OLDEST_MESSAGE_NUMBER is
'Earliest commit number of the transactions currently being applied'
/
comment on column ALL_APPLY_PROGRESS.APPLY_TIME is
'Time at which the message was applied'
/
comment on column ALL_APPLY_PROGRESS.APPLIED_MESSAGE_CREATE_TIME is
'Time at which the message to be applied was created'
/
create or replace public synonym ALL_APPLY_PROGRESS for ALL_APPLY_PROGRESS
/
grant select on ALL_APPLY_PROGRESS to public with grant option
/

----------------------------------------------------------------------------

-- Private view select to all columns from apply$_error
-- Used by export. Respective catalog views will select from this view.
create or replace view "_DBA_APPLY_ERROR"
as select 
  local_transaction_id, source_transaction_id, source_database,
  queue_owner, queue_name, apply#, message_number, message_count,
  min_step_no, recipient_id, recipient_name, source_commit_scn,
  error_number, error_message, aq_transaction_id, 
  spare1, spare2, spare3
from sys.apply$_error
/
grant select on "_DBA_APPLY_ERROR" to exp_full_database
/

create or replace view DBA_APPLY_ERROR
  (APPLY_NAME, QUEUE_NAME, QUEUE_OWNER, LOCAL_TRANSACTION_ID,
   SOURCE_DATABASE, SOURCE_TRANSACTION_ID,
   SOURCE_COMMIT_SCN, MESSAGE_NUMBER, ERROR_NUMBER,
   ERROR_MESSAGE, RECIPIENT_ID, RECIPIENT_NAME, MESSAGE_COUNT)
as
select p.apply_name, e.queue_name, e.queue_owner, e.local_transaction_id,
       e.source_database, e.source_transaction_id,
       e.source_commit_scn, e.message_number, e.error_number,
       e.error_message, e.recipient_id, e.recipient_name, e.message_count
  from "_DBA_APPLY_ERROR" e, sys.streams$_apply_process p
 where e.apply# = p.apply#(+)
/

comment on table DBA_APPLY_ERROR is
'Error transactions'
/
comment on column DBA_APPLY_ERROR.APPLY_NAME iS
'Name of the apply process at the local site which processed the transaction'
/
comment on column DBA_APPLY_ERROR.QUEUE_NAME is
'Name of the queue at the local site where the transaction came from'
/
comment on column DBA_APPLY_ERROR.QUEUE_OWNER is
'Owner of the queue at the local site where the transaction came from'
/
comment on column DBA_APPLY_ERROR.LOCAL_TRANSACTION_ID is
'Local transaction ID for the error creation transaction'
/
comment on column DBA_APPLY_ERROR.SOURCE_DATABASE is
'Database where the transaction originated'
/
comment on column DBA_APPLY_ERROR.SOURCE_TRANSACTION_ID is
'Original transaction ID at the source database'
/
comment on column DBA_APPLY_ERROR.SOURCE_COMMIT_SCN is
'Original commit SCN for the transaction at the source database'
/
comment on column DBA_APPLY_ERROR.MESSAGE_NUMBER is
'Identifier for the message in the transaction that raised an error'
/
comment on column DBA_APPLY_ERROR.ERROR_NUMBER is
'Error number'
/
comment on column DBA_APPLY_ERROR.ERROR_MESSAGE is
'Error message'
/
comment on column DBA_APPLY_ERROR.RECIPIENT_ID is
'User ID of the original recipient'
/
comment on column DBA_APPLY_ERROR.RECIPIENT_NAME is
'Name of the original recipient'
/
comment on column DBA_APPLY_ERROR.MESSAGE_COUNT is
'Total number of messages inside the error transaction'
/
create or replace public synonym DBA_APPLY_ERROR for DBA_APPLY_ERROR
/
grant select on DBA_APPLY_ERROR to select_catalog_role
/

----------------------------------------------------------------------------
create or replace view ALL_APPLY_ERROR
  (APPLY_NAME, QUEUE_NAME, QUEUE_OWNER, LOCAL_TRANSACTION_ID,
   SOURCE_DATABASE, SOURCE_TRANSACTION_ID,
   SOURCE_COMMIT_SCN, MESSAGE_NUMBER, ERROR_NUMBER,
   ERROR_MESSAGE, RECIPIENT_ID, RECIPIENT_NAME, MESSAGE_COUNT)
as (
select e.apply_name, e.queue_name, e.queue_owner, e.local_transaction_id,
       e.source_database, e.source_transaction_id,
       e.source_commit_scn, e.message_number, e.error_number,
       e.error_message, e.recipient_id, e.recipient_name, e.message_count
  from dba_apply_error e, all_users u, all_queues q
 where e.recipient_id = u.user_id
   and q.name = e.queue_name
   and q.owner = e.queue_owner
union all
select e.apply_name, e.queue_name, e.queue_owner, e.local_transaction_id,
       e.source_database, e.source_transaction_id,
       e.source_commit_scn, e.message_number, e.error_number,
       e.error_message, e.recipient_id, e.recipient_name, e.message_count
  from dba_apply_error e
 where e.recipient_id NOT IN (select user_id from dba_users))
/  

comment on table ALL_APPLY_ERROR is
'Error transactions that were generated after dequeuing from the queue visible to the current user'
/
comment on column ALL_APPLY_ERROR.APPLY_NAME iS
'Name of the apply process at the local site which processed the transaction'
/
comment on column ALL_APPLY_ERROR.QUEUE_NAME is
'Name of the queue at the local site where the transaction came from'
/
comment on column ALL_APPLY_ERROR.QUEUE_OWNER is
'Owner of the queue at the local site where the transaction came from'
/
comment on column ALL_APPLY_ERROR.LOCAL_TRANSACTION_ID is
'Local transaction ID for the error creation transaction'
/
comment on column ALL_APPLY_ERROR.SOURCE_DATABASE is
'Database where the transaction originated'
/
comment on column ALL_APPLY_ERROR.SOURCE_TRANSACTION_ID is
'Original transaction ID at the source database'
/
comment on column ALL_APPLY_ERROR.SOURCE_COMMIT_SCN is
'Original commit SCN for the transaction at the source database'
/
comment on column ALL_APPLY_ERROR.MESSAGE_NUMBER is
'Identifier for the message in the transaction that raised an error'
/
comment on column ALL_APPLY_ERROR.ERROR_NUMBER is
'Error number'
/
comment on column ALL_APPLY_ERROR.ERROR_MESSAGE is
'Error message'
/
comment on column ALL_APPLY_ERROR.RECIPIENT_ID is
'User ID of the original recipient'
/
comment on column ALL_APPLY_ERROR.RECIPIENT_NAME is
'Name of the original recipient'
/
comment on column ALL_APPLY_ERROR.MESSAGE_COUNT is
'Total number of messages inside the error transaction'
/
create or replace public synonym ALL_APPLY_ERROR for ALL_APPLY_ERROR
/
grant select on ALL_APPLY_ERROR to public with grant option
/

----------------------------------------------------------------------------

create or replace view GV_$STREAMS_APPLY_COORDINATOR
as
select * from gv$streams_apply_coordinator;
create or replace public synonym GV$STREAMS_APPLY_COORDINATOR 
  for gv_$streams_apply_coordinator;
grant select on GV_$STREAMS_APPLY_COORDINATOR to select_catalog_role;

----------------------------------------------------------------------------

create or replace view V_$STREAMS_APPLY_COORDINATOR
as
select * from v$streams_apply_coordinator;
create or replace public synonym V$STREAMS_APPLY_COORDINATOR 
  for v_$streams_apply_coordinator;
grant select on V_$STREAMS_APPLY_COORDINATOR to select_catalog_role;

----------------------------------------------------------------------------

create or replace view GV_$STREAMS_APPLY_SERVER
as
select * from gv$streams_apply_server;
create or replace public synonym GV$STREAMS_APPLY_SERVER 
  for gv_$streams_apply_server;
grant select on GV_$STREAMS_APPLY_SERVER to select_catalog_role;

----------------------------------------------------------------------------

create or replace view V_$STREAMS_APPLY_SERVER
as
select * from v$streams_apply_server;
create or replace public synonym V$STREAMS_APPLY_SERVER 
  for v_$streams_apply_server;
grant select on V_$STREAMS_APPLY_SERVER to select_catalog_role;

----------------------------------------------------------------------------

create or replace view GV_$STREAMS_APPLY_READER
as
select * from gv$streams_apply_reader;
create or replace public synonym GV$STREAMS_APPLY_READER 
  for gv_$streams_apply_reader;
grant select on GV_$STREAMS_APPLY_READER to select_catalog_role;

----------------------------------------------------------------------------

create or replace view V_$STREAMS_APPLY_READER
as
select * from v$streams_apply_reader;
create or replace public synonym V$STREAMS_APPLY_READER 
  for v_$streams_apply_reader;
grant select on V_$STREAMS_APPLY_READER to select_catalog_role;

-- ------------------------------------------------------------------------
-- Bug 2265160: Alter initrans, pctfree, freelists values for the 
-- streams$_apply_progress table. 
-- ------------------------------------------------------------------------
DECLARE
  block_size   INTEGER;
  free_lists   INTEGER;
  initrans     INTEGER;
  atb_stmt     VARCHAR2(500);
  done         BOOLEAN      := FALSE;
BEGIN

  SELECT tbs.block_size INTO block_size
  FROM dba_tables tbl, dba_tablespaces tbs
  WHERE tbl.owner = 'SYS' AND
        tbl.table_name = 'STREAMS$_APPLY_PROGRESS' AND
        tbl.tablespace_name = tbs.tablespace_name;

  -- Compute freelists
  -- Formula for computing freelists = 0.25*blocksize/25
  -- 25 is the overhead of each freelist. Using a quarter of (blocksize/25) 
  -- is a good and conservative estimate. 
  free_lists := 0.25*block_size/25;

  -- Since we allow only inserts into this table, set initrans to the number
  -- of rows that could be inserted into a block. Based on some analysis, this
  -- value turned out to be around 30 for a 2k block size. 
  initrans := 30*block_size/2048;

  -- Restrict max value of initrans to 128
  IF initrans > 128 THEN
    initrans := 128;
  END IF;

  -- PCTFREE = 0 since there are no updates to this table.
  WHILE NOT done LOOP
    BEGIN
      atb_stmt := 'ALTER TABLE sys.streams$_apply_progress INITRANS ' || 
                   initrans || ' PCTFREE 0 STORAGE (FREELISTS ' || 
                   free_lists || ')';
      EXECUTE IMMEDIATE atb_stmt;
      done := TRUE;
    EXCEPTION WHEN OTHERS THEN
      IF sqlcode = -1590 THEN
        IF free_lists < 20 THEN
          done := TRUE;
        ELSE
          free_lists := free_lists-2;
        END IF;
      ELSE
        RAISE;
      END IF;
    END;
  END LOOP;

EXCEPTION WHEN OTHERS THEN
  -- Do not raise exceptions in CAT files
  NULL;
END;
/
