Rem
Rem $Header: catbkout.sql 29-jun-2006.14:03:48 rburns Exp $
Rem
Rem catbkout.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      catbkout.sql - CATalog BacKOUT script for 9.2 patch releases
Rem
Rem    DESCRIPTION
Rem      This script is run in the latest 9.2 patch release to perform
Rem      required actions prior to backing out to the older 9.2 patch
Rem      release that was upgraded.
Rem
Rem    NOTES
Rem      Connect AS SYSDBA to run the script and startup the database
Rem      in MIGRATE mode.
Rem
Rem      After running the script, shutdown immediate, revert to 
Rem      the older patch release ORACLE_HOME, and run rdbms/admin/catpatch.sql
Rem      to reload the older release views and packages.
Rem      
Rem      After running catpatch.sql, if Spatial is in the database, also
Rem      run the following:
Rem
Rem      alter session set current_schema =  mdsys;
Rem      @?/md/admin/sdopidx.sql
Rem      @?/md/admin/prvtpidx.plb
Rem      @?/md/admin/prvtsidx.plb
Rem      @?/md/admin/sdogeom.sql
Rem      @?/md/admin/prvt3glh.plb
Rem      @?/md/admin/prvtgeom.plb
Rem      @?/md/admin/prvt3gl.plb
Rem      alter session set current_schema = sys;
Rem
Rem      Then shutdown immediate, startup for normal operation and
Rem      run rdbms/admin/utlrp.sql to recompile any remaining invalid 
Rem      objects.
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      06/28/06 - more 9208 backout actions 
Rem    rburns      04/20/06 - Add actions for 9.2.0.8
Rem    cdilling    11/21/05 - Backport cdilling_bug-4729821 from 
Rem                           st_rdbms_9.2.0.1 
Rem    cdilling    11/14/05 - add COMMIT for CONTEXT - bug 4729821 
Rem    rburns      04/29/05 - rburns_bug-4329242
Rem    rburns      04/27/05 - Created
Rem

Rem =========================================================================
Rem Exit immediately if there are errors in the initial checks
Rem =========================================================================

WHENEVER SQLERROR EXIT;        

DOC 
###################################################################### 
###################################################################### 
    The following statement will cause an "ORA-01722: invalid number" 
    error and terminate the SQLPLUS session if the user is not SYS.  
    Disconnect and reconnect with AS SYSDBA. 
###################################################################### 
###################################################################### 
# 
 
SELECT TO_NUMBER('MUST_BE_AS_SYSDBA') FROM DUAL 
WHERE USER != 'SYS'; 

DOC
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the database server version is not 9.2.0.
  Shutdown ABORT and use a different script or a different server.
#######################################################################
#######################################################################
#

SELECT TO_NUMBER('MUST_BE_920') FROM v$instance
WHERE substr(version,1,5) != '9.2.0';

DOC
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the database has not been opened for MIGRATE.  

  Perform a "SHUTDOWN ABORT"  and 
  restart using MIGRATE.
#######################################################################
#######################################################################
#

SELECT TO_NUMBER(status) FROM v$instance
WHERE status != 'OPEN MIGRATE';

Rem =========================================================================
Rem Continue even if there are SQL errors in remainder of script
Rem =========================================================================

WHENEVER SQLERROR CONTINUE;  


Rem =========================================================================
Rem RDBMS
Rem =========================================================================

drop view GV_$KQRPD;
drop view GV_$KQRSD;
drop view V_$KQRPD;
drop view V_$KQRSD;

Rem =========================================================================
Rem CONTEXT
Rem =========================================================================

BEGIN
    IF dbms_registry.is_loaded ('CONTEXT') IS NOT NULL THEN
       EXECUTE IMMEDIATE 
       'delete from ctxsys.dr$object_attribute where oat_id = 60121';
       COMMIT;
    END IF;
END;
/

Rem =========================================================================
Rem Ultra Search
Rem =========================================================================

BEGIN
    IF dbms_registry.is_loaded ('WK') IS NOT NULL THEN
       EXECUTE IMMEDIATE 
             'DROP PACKAGE WKSYS.OUS_ADM';
    END IF;
END;
/

Rem =========================================================================
Rem Spatial
Rem =========================================================================

BEGIN
    IF dbms_registry.is_loaded ('SDO') IS NOT NULL THEN
       EXECUTE IMMEDIATE 
             'DROP PACKAGE MDSYS.MDPRVT_IDX';
       EXECUTE IMMEDIATE 
             'DROP PACKAGE MDSYS.SDO_PRIDX';
       EXECUTE IMMEDIATE 
             'DROP PACKAGE MDSYS.SDO_IDX';
    END IF;
END;
/

Rem =========================================================================
Rem OLAP CWMLITE
Rem =========================================================================

BEGIN
    IF dbms_registry.is_loaded ('AMD') IS NOT NULL THEN
       EXECUTE IMMEDIATE 
             'DROP VIEW olapsys.ODM$OLAP2UDIM_HIER_LEVEL_USES';
    END IF;
END;
/

Rem =========================================================================
Rem XDX for Java
Rem =========================================================================

BEGIN
    IF dbms_registry.is_loaded ('XML') IS NOT NULL THEN
       EXECUTE IMMEDIATE 
           'drop java class "oracle/xml/parser/schema/XSDEscClass"';
       EXECUTE IMMEDIATE 
           'drop java class "oracle/xml/parser/schema/XSDRangeClass"';
       EXECUTE IMMEDIATE 
           'drop java class "oracle/xml/parser/schema/XSDNegClass"';
       EXECUTE IMMEDIATE 
           'drop java class "oracle/xml/parser/schema/XSDCharClass"';
       EXECUTE IMMEDIATE 
          'drop java class "oracle/xml/parser/schema/XSDCatClass"';
       EXECUTE IMMEDIATE 
          'drop java class "oracle/xml/parser/schema/XSDSubtractionClass"';
    END IF;
END;
/

Rem =====================================================================
Rem END catbkout.sql
Rem =====================================================================
